/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admin;

import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.repository.ResourceAdminImpl;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.resource.ConfigurationPropertyException;
import com.sun.enterprise.resource.DuplicateNameException;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class AdminTool {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$admin$AdminTool == null ? (class$com$sun$enterprise$tools$admin$AdminTool = AdminTool.class$("com.sun.enterprise.tools.admin.AdminTool")) : class$com$sun$enterprise$tools$admin$AdminTool);
    private static final String ADD = "-add";
    private static final String REMOVE_ALL = "-removeall";
    private static final String REMOVE = "-remove";
    private static final String LIST = "-list";
    private static final String HELP = "-help";
    private static final String PROPS = "-props";
    private static final String BATCH = "-file";
    private static final String QUEUE = "queue";
    private static final String TOPIC = "topic";
    private Hashtable resourceTypes = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$tools$admin$AdminTool;

    public static void main(String[] args) {
        AdminTool adminTool = new AdminTool();
        adminTool.start(args);
    }

    public AdminTool() {
        this.resourceTypes.put("jdbcdriver", new Integer(5));
        this.resourceTypes.put("jdbcdatasource", new Integer(3));
        this.resourceTypes.put("jdbcxadatasource", new Integer(4));
        this.resourceTypes.put("jmsdestination", new Integer(1));
        this.resourceTypes.put("jmsfactory", new Integer(2));
        this.resourceTypes.put("connectorfactory", new Integer(6));
    }

    public void start(String[] args) {
        boolean showUsage;
        block12: {
            showUsage = false;
            if (args.length > 0) {
                try {
                    String command = args[0];
                    String operation = this.getOperation(command);
                    if (operation != null && operation.equalsIgnoreCase(HELP)) {
                        showUsage = true;
                        break block12;
                    }
                    if (operation != null && operation.equalsIgnoreCase(BATCH)) {
                        if (args.length == 2) {
                            this.processBatchFile(args[1]);
                        } else {
                            showUsage = true;
                        }
                        break block12;
                    }
                    this.processCommand(command, args);
                }
                catch (ArgumentException argEx) {
                    showUsage = true;
                }
                catch (J2EEResourceException ex2) {
                    if (ex2.getNestedException() != null) {
                        AdminTool.handleDeploymentException(ex2.getNestedException());
                        break block12;
                    }
                    AdminTool.handleDeploymentException(ex2);
                }
                catch (Exception e10) {
                    System.out.println("Error : " + e10.getMessage());
                }
            } else {
                showUsage = true;
            }
        }
        if (showUsage) {
            this.usage();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processBatchFile(String batchFile) throws Exception {
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = new LineNumberReader(new FileReader(batchFile));
            while ((nextLine = ((LineNumberReader)reader).readLine()) != null) {
                void var3_3;
                int lineNum = ((LineNumberReader)reader).getLineNumber();
                if (!var3_3.startsWith("-")) continue;
                StringTokenizer tokenizer = new StringTokenizer((String)var3_3);
                String[] args = new String[tokenizer.countTokens()];
                int argIndex = 0;
                while (tokenizer.hasMoreTokens()) {
                    args[argIndex] = tokenizer.nextToken();
                    ++argIndex;
                }
                String command = args[0];
                this.processCommand(command, args);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    public void usage() {
        System.out.println(localStrings.getLocalString("tools.admin.msg001", "Usage :"));
        System.out.println("-addJdbcDriver <class name>");
        System.out.println("-addJdbcDatasource <jndi name> <url>");
        System.out.println("-addJdbcXADatasource <jndi name> <class name> [<xa user name> <xa password>] [-props (<name>=<value>)+]");
        System.out.println("-addJmsDestination <jndi name> (queue|topic)");
        System.out.println("-addJmsFactory <jndi name> (queue|topic) [-props (<name>=<value>)+]");
        System.out.println("-addConnectorFactory <jndi name> [<app name>:]<rar filename> [<xa user name> <xa password>] [-props (<name>=<value>)+]");
        System.out.println("-list<resource type>");
        System.out.println("-remove<resource type> <name>");
        System.out.println("-removeAll<resource type>");
    }

    private String getOperation(String command) {
        String operation = null;
        String commandLowerCase = command.toLowerCase();
        if (commandLowerCase.startsWith(ADD)) {
            operation = ADD;
        } else if (commandLowerCase.startsWith(REMOVE_ALL)) {
            operation = REMOVE_ALL;
        } else if (commandLowerCase.startsWith(REMOVE)) {
            operation = REMOVE;
        } else if (commandLowerCase.startsWith(LIST)) {
            operation = LIST;
        } else if (commandLowerCase.startsWith(BATCH)) {
            operation = BATCH;
        } else if (commandLowerCase.startsWith(HELP)) {
            operation = HELP;
        }
        return operation;
    }

    private String getResourceTypeName(String command, String operation) {
        int operationLength = operation.length();
        return command.substring(operationLength);
    }

    private Integer getResourceType(String resourceTypeName) {
        String keyLowerCase = resourceTypeName.toLowerCase();
        Integer resourceType = (Integer)this.resourceTypes.get(keyLowerCase);
        return resourceType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getResourceProperties(String[] args, int propStartIndex) throws ArgumentException {
        Properties props = new Properties();
        if (args.length > propStartIndex) {
            if (!args[propStartIndex].equalsIgnoreCase(PROPS)) throw new ArgumentException();
            int argIdx = propStartIndex + 1;
            while (argIdx < args.length) {
                String next = args[argIdx];
                int idx = next.indexOf("=");
                if (idx == -1) throw new ArgumentException();
                String prop = next.substring(0, idx);
                String value = next.substring(idx + 1);
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                ((Hashtable)props).put(prop, value);
                ++argIdx;
            }
            if (!((Hashtable)props).isEmpty()) return props;
            throw new ArgumentException();
        }
        if (args.length == propStartIndex) return props;
        throw new ArgumentException();
    }

    private void setResourceProperties(J2EEResource resource, String[] args, int propStartIndex) throws ArgumentException {
        Properties props = this.getResourceProperties(args, propStartIndex);
        Iterator keys = ((Hashtable)props).keySet().iterator();
        while (keys.hasNext()) {
            String nextKey = (String)keys.next();
            String nextValue = (String)((Hashtable)props).get(nextKey);
            ResourcePropertyImpl resourceProp = new ResourcePropertyImpl(nextKey, nextValue);
            resource.addProperty(resourceProp);
        }
    }

    private void processCommand(String command, String[] args) throws ArgumentException, Exception {
        String resourceTypeName;
        String operation = this.getOperation(command);
        if (operation != null) {
            resourceTypeName = this.getResourceTypeName(command, operation);
            Integer resourceType = this.getResourceType(resourceTypeName);
            if (resourceType == null) {
                throw new ArgumentException();
            }
        } else {
            throw new ArgumentException();
        }
        this.doOperation(operation, resourceTypeName, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doOperation(String operation, String resourceTypeName, String[] args) throws ArgumentException, Exception {
        int resourceType = this.getResourceType(resourceTypeName);
        if (operation.equalsIgnoreCase(ADD)) {
            this.doAdd(resourceType, args);
            return;
        } else if (operation.equalsIgnoreCase(REMOVE)) {
            if (args.length != 2) throw new ArgumentException();
            String name = args[1];
            ResourceAdminImpl resourceAdmin = new ResourceAdminImpl();
            resourceAdmin.removeResource(name, resourceType);
            return;
        } else if (operation.equalsIgnoreCase(REMOVE_ALL)) {
            ResourceAdminImpl resourceAdmin = new ResourceAdminImpl();
            resourceAdmin.removeAllResources(resourceType);
            return;
        } else {
            if (!operation.equalsIgnoreCase(LIST)) return;
            ResourceAdminImpl resourceAdmin = new ResourceAdminImpl();
            Set allResourcesOfType = resourceAdmin.getResources(resourceType);
            if (allResourcesOfType.isEmpty()) {
                System.out.println(localStrings.getLocalString("tools.admin.msg002", "There are no resources of type {0}", new Object[]{resourceTypeName}));
                return;
            } else {
                System.out.println(resourceTypeName);
                StringBuffer underline = new StringBuffer();
                int i2 = 0;
                while (i2 < resourceTypeName.length()) {
                    underline.append("-");
                    ++i2;
                }
                System.out.println(underline.toString());
                Iterator iter = allResourcesOfType.iterator();
                while (iter.hasNext()) {
                    System.out.println(iter.next());
                }
            }
        }
    }

    private void doAdd(int resourceType, String[] args) throws ArgumentException, Exception {
        ResourceAdminImpl resourceAdmin = new ResourceAdminImpl();
        switch (resourceType) {
            case 5: {
                this.addJdbcDriver(resourceAdmin, args);
                break;
            }
            case 3: {
                this.addJdbcDatasource(resourceAdmin, args);
                break;
            }
            case 4: {
                this.addJdbcXADatasource(resourceAdmin, args);
                break;
            }
            case 1: {
                this.addJmsDestination(resourceAdmin, args);
                break;
            }
            case 2: {
                this.addJmsFactory(resourceAdmin, args);
                break;
            }
            case 6: {
                this.addConnectorFactory(resourceAdmin, args);
                break;
            }
            default: {
                throw new ArgumentException("unknown resource type");
            }
        }
    }

    private void addJdbcDriver(ResourceAdmin admin, String[] args) throws ArgumentException, Exception {
        if (args.length != 2) {
            throw new ArgumentException();
        }
        JdbcDriver resource = new JdbcDriver(args[1]);
        admin.addResource(resource);
    }

    private void addJdbcDatasource(ResourceAdmin admin, String[] args) throws Exception {
        if (args.length != 3) {
            throw new ArgumentException();
        }
        JdbcResource resource = new JdbcResource(args[1]);
        resource.setUrl(args[2]);
        admin.addResource(resource);
    }

    private void addJdbcXADatasource(ResourceAdmin admin, String[] args) throws Exception {
        JdbcXAResource resource;
        if (args.length >= 3) {
            resource = new JdbcXAResource(args[1]);
            resource.setClassname(args[2]);
            if (args.length == 4) {
                throw new ArgumentException();
            }
            if (args.length >= 5) {
                int propStartIndex = 3;
                if (!args[3].equalsIgnoreCase(PROPS)) {
                    String xaUserName = args[3];
                    String xaPassword = args[4];
                    resource.setDbuser(xaUserName);
                    resource.setDbpassword(xaPassword);
                    propStartIndex = 5;
                }
                this.setResourceProperties(resource, args, propStartIndex);
            }
        } else {
            throw new ArgumentException();
        }
        admin.addResource(resource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addJmsDestination(ResourceAdmin admin, String[] args) throws Exception {
        if (args.length != 3) throw new ArgumentException();
        JmsDestinationResource resource = new JmsDestinationResource(args[1]);
        String msgStyleString = args[2];
        if (msgStyleString.equalsIgnoreCase(QUEUE)) {
            resource.setIsQueue(true);
        } else {
            if (!msgStyleString.equalsIgnoreCase(TOPIC)) throw new ArgumentException();
            resource.setIsQueue(false);
        }
        admin.addResource(resource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addJmsFactory(ResourceAdmin admin, String[] args) throws Exception {
        if (args.length < 3) throw new ArgumentException();
        JmsCnxFactoryResource resource = new JmsCnxFactoryResource(args[1]);
        String msgStyleString = args[2];
        if (msgStyleString.equalsIgnoreCase(QUEUE)) {
            resource.setIsQueue(true);
        } else {
            if (!msgStyleString.equalsIgnoreCase(TOPIC)) throw new ArgumentException();
            resource.setIsQueue(false);
        }
        this.setResourceProperties(resource, args, 3);
        admin.addResource(resource);
    }

    private void addConnectorFactory(ResourceAdmin admin, String[] args) throws Exception {
        String name;
        String appName;
        Properties props;
        String xaPassword;
        String xaUserName;
        String jndiName;
        if (args.length >= 3) {
            jndiName = args[1];
            String connectorName = args[2];
            xaUserName = null;
            xaPassword = null;
            props = null;
            if (args.length == 4) {
                throw new ArgumentException();
            }
            if (args.length >= 5) {
                int propStartIndex = 3;
                if (!args[3].equalsIgnoreCase(PROPS)) {
                    xaUserName = args[3];
                    xaPassword = args[4];
                    propStartIndex = 5;
                }
                props = this.getResourceProperties(args, propStartIndex);
            }
            appName = null;
            name = connectorName;
            int index = connectorName.indexOf(58);
            if (index != -1) {
                appName = connectorName.substring(0, index);
                name = connectorName.substring(index + 1);
            }
        } else {
            throw new ArgumentException();
        }
        admin.addConnectionFactory(appName, name, jndiName, xaUserName, xaPassword, props);
    }

    private static void handleDeploymentException(Exception ex2) {
        if (ex2 instanceof DuplicateNameException) {
            String msg = localStrings.getLocalString("duplicatename.exception", "", new Object[]{ex2.getMessage()});
            System.err.println(msg);
        } else if (ex2 instanceof NameNotFoundException) {
            String msg = localStrings.getLocalString("namenotfound.exception", "", new Object[]{ex2.getMessage()});
            System.err.println(msg);
        } else if (ex2 instanceof ConfigurationPropertyException) {
            String msg = localStrings.getLocalString("configproperty.exception", "", new Object[]{ex2.getMessage()});
            System.err.println(msg);
        } else {
            String msg = localStrings.getLocalString("generic.exception", "", new Object[]{ex2.toString()});
            System.err.println(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ArgumentException
    extends Exception {
        public ArgumentException() {
        }

        public ArgumentException(String message) {
            super(message);
        }
    }
}

