/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.spi.LoginModule;

public class SharedPasswordLoginModule
implements LoginModule {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$login$SharedPasswordLoginModule == null ? (class$com$sun$enterprise$security$auth$login$SharedPasswordLoginModule = SharedPasswordLoginModule.class$("com.sun.enterprise.security.auth.login.SharedPasswordLoginModule")) : class$com$sun$enterprise$security$auth$login$SharedPasswordLoginModule);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private PrincipalImpl userPrincipal;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$SharedPasswordLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    public boolean login() throws javax.security.auth.login.LoginException {
        if (this.callbackHandler == null) {
            throw new javax.security.auth.login.LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback(localStrings.getLocalString("login.username", "SharedPasswordModule username: ")), new PasswordCallback(localStrings.getLocalString("login.password", "SharedPasswordModule password: "), false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new javax.security.auth.login.LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new javax.security.auth.login.LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        if (this.debug) {
            System.out.println("\t\t[SharedPasswordLoginModule] user entered username: " + this.username);
            System.out.print("\t\t[SharedPasswordLoginModule] user entered password: ");
            int i2 = 0;
            while (i2 < this.password.length) {
                System.out.print(this.password[i2]);
                ++i2;
            }
            System.out.println();
        }
        boolean check = true;
        check = this.authenticate(this.username, new String(this.password));
        if (check) {
            if (this.debug) {
                System.out.println("\t\t[SharedPasswordLoginModule] authentication succeeded");
            }
            this.succeeded = true;
            return true;
        }
        if (this.debug) {
            System.out.println("\t\t[SharedPasswordLoginModule] authentication failed");
        }
        this.succeeded = false;
        this.username = null;
        int i3 = 0;
        while (i3 < this.password.length) {
            this.password[i3] = 32;
            ++i3;
        }
        this.password = null;
        throw new FailedLoginException("Password Incorrect");
    }

    private boolean authenticate(String user, String pass) {
        LoginContext lc = new LoginContext();
        try {
            lc.login(user, pass);
        }
        catch (LoginException le) {
            return false;
        }
        return true;
    }

    public boolean commit() throws javax.security.auth.login.LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[SharedPasswordLoginModule] added PrincipalImpl to Subject");
        }
        String realm = "default";
        PasswordCredential pc = new PasswordCredential(this.username, new String(this.password), realm);
        if (!this.subject.getPrivateCredentials().contains(pc)) {
            this.subject.getPrivateCredentials().add(pc);
        }
        this.username = null;
        int i2 = 0;
        while (i2 < this.password.length) {
            this.password[i2] = 32;
            ++i2;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws javax.security.auth.login.LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i2 = 0;
                while (i2 < this.password.length) {
                    this.password[i2] = 32;
                    ++i2;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws javax.security.auth.login.LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int i2 = 0;
            while (i2 < this.password.length) {
                this.password[i2] = 32;
                ++i2;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

