/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorAllocator;
import com.sun.enterprise.resource.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.NoTxConnectorAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class ConnectionManagerImpl
implements ConnectionManager,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$ConnectionManagerImpl == null ? (class$com$sun$enterprise$resource$ConnectionManagerImpl = ConnectionManagerImpl.class$("com.sun.enterprise.resource.ConnectionManagerImpl")) : class$com$sun$enterprise$resource$ConnectionManagerImpl);
    private String jndiName;
    static /* synthetic */ Class class$com$sun$enterprise$resource$ConnectionManagerImpl;

    public ConnectionManagerImpl(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        String auth;
        InvocationManager i2 = Switch.getSwitch().getInvocationManager();
        if (i2 == null) {
            String msg = localStrings.getLocalString("datasource.wrongclient", "");
            throw new IllegalStateException(msg);
        }
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        boolean resourceShareable = true;
        ResourceReferenceDescriptor ref = poolmgr.getResourceReference(this.jndiName);
        if (ref == null) {
            String msg = localStrings.getLocalString("no.resource.reference", "", new Object[]{this.jndiName});
            Log.err.println(msg);
            return this.internalGetConnection(mcf, null, cxRequestInfo, resourceShareable);
        }
        String shareableStr = ref.getSharingScope();
        if (shareableStr.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
            resourceShareable = false;
        }
        if ((auth = ref.getAuthorization()).equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
            return this.internalGetConnection(mcf, null, cxRequestInfo, resourceShareable);
        }
        ResourcePrincipal prin = ref.getResourcePrincipal();
        if (prin == null) {
            String msg = localStrings.getLocalString("password.info.warning", "", new Object[]{this.jndiName});
            Log.err.println(msg);
            prin = new ResourcePrincipal("", "");
        }
        return this.internalGetConnection(mcf, prin, cxRequestInfo, resourceShareable);
    }

    private Object internalGetConnection(ManagedConnectionFactory mcf, final ResourcePrincipal prin, ConnectionRequestInfo cxRequestInfo, boolean shareable) throws ResourceException {
        try {
            PoolManager poolmgr = Switch.getSwitch().getPoolManager();
            ResourceSpec spec = new ResourceSpec(this.jndiName, 1);
            ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
            ConnectorDescriptor desc = installer.getDescriptorByJndiName(this.jndiName);
            int txLevel = desc.getTransactionSupport();
            Subject subject = null;
            ClientSecurityInfo info = null;
            if (prin != null) {
                String password = prin.getPassword();
                final PasswordCredential pc = new PasswordCredential(prin.getName(), password.toCharArray());
                pc.setManagedConnectionFactory(mcf);
                final Subject tempSubject = new Subject();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tempSubject.getPrincipals().add(prin);
                        tempSubject.getPrivateCredentials().add(pc);
                        return null;
                    }
                });
                subject = tempSubject;
                info = new ClientSecurityInfo(prin);
            } else {
                info = new ClientSecurityInfo(cxRequestInfo);
            }
            ResourceAllocator alloc = null;
            switch (txLevel) {
                case 0: {
                    alloc = new NoTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                    return poolmgr.getResource(spec, alloc, info);
                }
                case 1: {
                    if (!shareable) {
                        throw new ResourceAllocationException("Cannot use resource in unshareable scope: " + this.jndiName);
                    }
                    alloc = new LocalTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                    return poolmgr.getResource(spec, alloc, info);
                }
                case 2: {
                    alloc = new ConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc, shareable);
                    return poolmgr.getResource(spec, alloc, info);
                }
            }
            throw new IllegalStateException("Illegal transaction support level: " + txLevel);
        }
        catch (PoolingException ex2) {
            ex2.printStackTrace(Log.err);
            Log.err.flush();
            ResourceAllocationException rae = new ResourceAllocationException("Error in creating connection");
            rae.setLinkedException(ex2);
            throw rae;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

