/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;

public class ResourceAdminImpl
implements ResourceAdmin {
    private Hashtable resourceAdmins = new Hashtable();
    private boolean triedLookup;
    private InitialContext context;
    private JarInstaller serverHandle;

    public ResourceAdminImpl() {
        this.addAdmin(new AdminJdbcDriver());
        this.addAdmin(new AdminJdbcDatasource());
        this.addAdmin(new AdminJdbcXADatasource());
        this.addAdmin(new AdminJmsDestination());
        this.addAdmin(new AdminJmsFactory());
        this.addAdmin(new AdminConnectorFactory());
        this.triedLookup = false;
        this.serverHandle = null;
        this.context = null;
    }

    public ConnectorResource addConnectionFactory(String appName, String connectorName, String jndiName, String xaRecoveryUser, String xaRecoveryPassword, Properties props) throws J2EEResourceException {
        ConnectorResource resource = null;
        try {
            JarInstaller serverHandle = this.getServerHandle();
            if (serverHandle == null) {
                throw new J2EEResourceException("server unavailable : can't create connector factory");
            }
            serverHandle.addConnectionFactory(appName, connectorName, jndiName, xaRecoveryUser, xaRecoveryPassword, props);
            J2EEResourceCollection resources = this.getResourceCollection();
            resource = (ConnectorResource)resources.getResourceByName(6, jndiName);
        }
        catch (Exception e10) {
            throw new J2EEResourceException(e10);
        }
        return resource;
    }

    public void addResource(J2EEResource resource) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(resource.getType());
            admin.addResource(resource);
        }
        catch (Exception e10) {
            throw new J2EEResourceException(e10);
        }
    }

    public Set getResources(int resourceType) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(resourceType);
            return admin.getResources();
        }
        catch (Exception e10) {
            throw new J2EEResourceException(e10);
        }
    }

    public void removeResource(String name, int resourceType) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(resourceType);
            admin.removeResource(name);
        }
        catch (Exception e10) {
            throw new J2EEResourceException(e10);
        }
    }

    public void removeAllResources(int resourceType) throws J2EEResourceException {
        try {
            Admin admin = this.getAdmin(resourceType);
            admin.removeAllResources();
        }
        catch (Exception e10) {
            throw new J2EEResourceException(e10);
        }
    }

    private void addAdmin(Admin admin) {
        this.resourceAdmins.put(new Integer(admin.getResourceType()), admin);
    }

    private Admin getAdmin(int resourceType) {
        return (Admin)this.resourceAdmins.get(new Integer(resourceType));
    }

    private J2EEResourceCollection getResourceCollection() throws J2EEResourceException {
        J2EEResourceFactory resourceFactory = ServerConfiguration.getJ2EEResourceFactory();
        return resourceFactory.loadDefaultResourceCollection();
    }

    private void storeResourceCollection(J2EEResourceCollection resources) throws J2EEResourceException {
        J2EEResourceFactory resourceFactory = ServerConfiguration.getJ2EEResourceFactory();
        resourceFactory.storeDefaultResourceCollection(resources);
    }

    private JarInstaller getServerHandle() {
        if (!this.triedLookup) {
            this.triedLookup = true;
            try {
                this.context = new InitialContext();
                this.serverHandle = (JarInstaller)this.context.lookup("JarInstaller");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.serverHandle;
    }

    private class AdminConnectorFactory
    extends Admin {
        private AdminConnectorFactory() {
        }

        public int getResourceType() {
            return 6;
        }

        public void addResource(J2EEResource resource) throws Exception {
            throw new Exception("Not Supported : Use ResourceAdmin.addConnectionFactory");
        }

        public Set getResources() throws Exception {
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            return resources.getResourcesByType(this.getResourceType());
        }

        public void removeResource(String name) throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource resource = resources.getResourceByName(this.getResourceType(), name);
            if (serverHandle != null) {
                serverHandle.removeConnectionFactory(name);
            }
        }

        public void removeAllResources() throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            Iterator iter = this.getResources().iterator();
            while (iter.hasNext()) {
                J2EEResource resource = (J2EEResource)iter.next();
                if (serverHandle == null) continue;
                serverHandle.removeConnectionFactory(resource.getName());
            }
        }
    }

    private class AdminJmsFactory
    extends Admin {
        private AdminJmsFactory() {
        }

        public int getResourceType() {
            return 2;
        }

        public void addResource(J2EEResource resource) throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            if (serverHandle != null) {
                serverHandle.createJmsConnectionFactory((JmsCnxFactoryResource)resource);
            }
            super.addResource(resource);
        }

        public void removeResource(String name) throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource resource = resources.getResourceByName(this.getResourceType(), name);
            if (resource != null && serverHandle != null) {
                serverHandle.deleteJmsConnectionFactory((JmsCnxFactoryResource)resource);
            }
            super.removeResource(name);
        }

        public void removeAllResources() throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            Iterator iter = this.getResources().iterator();
            while (iter.hasNext()) {
                JmsCnxFactoryResource resource = (JmsCnxFactoryResource)iter.next();
                if (serverHandle == null) continue;
                serverHandle.deleteJmsConnectionFactory(resource);
            }
            super.removeAllResources();
        }
    }

    private class AdminJmsDestination
    extends Admin {
        private AdminJmsDestination() {
        }

        public int getResourceType() {
            return 1;
        }

        public void addResource(J2EEResource resource) throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            if (serverHandle != null) {
                serverHandle.createDestination((JmsDestinationResource)resource);
            }
            super.addResource(resource);
        }

        public void removeResource(String name) throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource resource = resources.getResourceByName(this.getResourceType(), name);
            if (resource != null && serverHandle != null) {
                serverHandle.deleteDestination((JmsDestinationResource)resource);
            }
            super.removeResource(name);
        }

        public void removeAllResources() throws Exception {
            JarInstaller serverHandle = ResourceAdminImpl.this.getServerHandle();
            Iterator iter = this.getResources().iterator();
            while (iter.hasNext()) {
                JmsDestinationResource resource = (JmsDestinationResource)iter.next();
                if (serverHandle == null) continue;
                serverHandle.deleteDestination(resource);
            }
            super.removeAllResources();
        }
    }

    private class AdminJdbcXADatasource
    extends Admin {
        private AdminJdbcXADatasource() {
        }

        public int getResourceType() {
            return 4;
        }
    }

    private class AdminJdbcDatasource
    extends Admin {
        private AdminJdbcDatasource() {
        }

        public int getResourceType() {
            return 3;
        }
    }

    private class AdminJdbcDriver
    extends Admin {
        private AdminJdbcDriver() {
        }

        public int getResourceType() {
            return 5;
        }
    }

    private abstract class Admin {
        private Admin() {
        }

        public abstract int getResourceType();

        public void addResource(J2EEResource resource) throws Exception {
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            resources.addResource(resource);
            ResourceAdminImpl.this.storeResourceCollection(resources);
        }

        public void removeResource(String name) throws Exception {
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            J2EEResource resource = resources.getResourceByName(this.getResourceType(), name);
            if (resource != null) {
                resources.removeResource(resource);
                ResourceAdminImpl.this.storeResourceCollection(resources);
            }
        }

        public void removeAllResources() throws Exception {
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            resources.removeAllResourcesByType(this.getResourceType());
            ResourceAdminImpl.this.storeResourceCollection(resources);
        }

        public Set getResources() throws Exception {
            J2EEResourceCollection resources = ResourceAdminImpl.this.getResourceCollection();
            return resources.getResourcesByType(this.getResourceType());
        }
    }
}

