/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.resource.ConnectionManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorResource
extends J2EEResourceBase
implements Serializable {
    public static final String CONNECTOR_OBJECT_FACTORY = "com.sun.enterprise.naming.factory.ConnectorObjectFactory";
    private String dbuser_ = "";
    private String dbpassword_ = "";
    private String connectorname_;
    private String appname_ = "";
    private String connectionFactoryClass_;

    public ConnectorResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        ConnectorResource clone = new ConnectorResource(name);
        clone.setDbuser(this.getDbuser());
        clone.setDbpassword(this.getDbpassword());
        clone.setConnectorName(this.getConnectorName());
        clone.setApplicationName(this.getApplicationName());
        clone.setConnectionFactoryClass(this.getConnectionFactoryClass());
        return clone;
    }

    public int getType() {
        return 6;
    }

    public String getApplicationName() {
        return this.appname_;
    }

    public void setApplicationName(String appname) {
        this.appname_ = appname == null ? "" : appname;
    }

    public String getConnectorName() {
        return this.connectorname_;
    }

    public void setConnectorName(String connectorname) {
        this.connectorname_ = connectorname;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass_;
    }

    public void setConnectionFactoryClass(String cfclass) {
        this.connectionFactoryClass_ = cfclass;
    }

    public String getDbuser() {
        return this.dbuser_;
    }

    public void setDbuser(String dbuser) {
        this.dbuser_ = dbuser == null ? "" : dbuser;
    }

    public String getDbpassword() {
        return this.dbpassword_;
    }

    public void setDbpassword(String dbpassword) {
        this.dbpassword_ = dbpassword == null ? "" : dbpassword;
    }

    public Reference createConnectionFactoryReference() {
        Reference ref = new Reference(this.getConnectionFactoryClass(), new StringRefAddr("jndiName", this.getName()), CONNECTOR_OBJECT_FACTORY, null);
        return ref;
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ClassLoader jcl) throws PoolingException {
        try {
            if (jcl == null) {
                jcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            ResourceInstaller ri = Switch.getSwitch().getResourceInstaller();
            ConnectorDescriptor desc = ri.getDescriptorByConnectorName(this.getApplicationName(), this.getConnectorName());
            String jndiName = this.getName();
            String mcfClass = desc.getManagedConnectionFactoryImpl();
            String appName = this.getApplicationName();
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)Class.forName(mcfClass, true, jcl).newInstance();
            AccessController.doPrivileged(new SetMethodAction(mcf, desc));
            return mcf;
        }
        catch (PrivilegedActionException ex2) {
            Exception nested = ex2.getException();
            Log.err.println(nested);
            Log.err.flush();
            throw new PoolingException(nested.toString(), nested);
        }
        catch (Exception ex3) {
            Log.err.println(ex3);
            Log.err.flush();
            throw new PoolingException(ex3.toString(), ex3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object createConnectionFactory() throws PoolingException {
        ManagedConnectionFactory mcf = this.createManagedConnectionFactory(null);
        try {
            void ex2;
            Object cf2 = mcf.createConnectionFactory(new ConnectionManagerImpl(this.getName()));
            return ex2;
        }
        catch (ResourceException ex2) {
            Log.err.println(ex2);
            Log.err.flush();
            throw new PoolingException(ex2.toString(), ex2);
        }
    }

    public String toString() {
        return "< Connector Resource : " + this.getName() + " , " + this.getApplicationName() + " , " + this.getConnectorName() + " , " + this.getDbuser() + " , " + this.getDbpassword() + " >";
    }

    class SetMethodAction
    implements PrivilegedExceptionAction {
        ManagedConnectionFactory mcf;
        ConnectorDescriptor desc;

        SetMethodAction(ManagedConnectionFactory mcf, ConnectorDescriptor desc) {
            this.mcf = mcf;
            this.desc = desc;
        }

        public Object run() throws Exception {
            Iterator iter = this.desc.getConfigProperties().iterator();
            while (iter.hasNext()) {
                EnvironmentProperty envProp = (EnvironmentProperty)iter.next();
                String propName = envProp.getName();
                String propType = envProp.getType();
                String propValue = (String)ConnectorResource.this.getProperty(propName).getValue();
                EnvironmentProperty newProp = new EnvironmentProperty(propName, propValue, "", propType);
                String setMeth = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                Method meth = this.mcf.getClass().getMethod(setMeth, newProp.getValueType());
                meth.invoke((Object)this.mcf, newProp.getValueObject());
            }
            return null;
        }
    }
}

