/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicConnectionFactory;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ConnectionFactoryWrapper
implements QueueConnectionFactory,
TopicConnectionFactory,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$jms$ConnectionFactoryWrapper == null ? (class$com$sun$enterprise$jms$ConnectionFactoryWrapper = ConnectionFactoryWrapper.class$("com.sun.enterprise.jms.ConnectionFactoryWrapper")) : class$com$sun$enterprise$jms$ConnectionFactoryWrapper);
    private static final boolean debug = false;
    private JmsWrapperFactory wrapperFactory_;
    private String connectionFactoryJndiName_;
    private boolean resourceRefHasApplicationAuth_;
    private boolean resourceRefHasContainerAuth_;
    private boolean useContainerAuth_;
    private String userName_;
    private String password_;
    private transient JMSXAConnectionFactory delegateXA_;
    static /* synthetic */ Class class$com$sun$enterprise$jms$ConnectionFactoryWrapper;

    public ConnectionFactoryWrapper(String connectionFactoryJndiName, ResourceReferenceDescriptor resourceRef, JmsWrapperFactory wrapperFactory) {
        this.connectionFactoryJndiName_ = connectionFactoryJndiName;
        this.wrapperFactory_ = wrapperFactory;
        this.resourceRefHasContainerAuth_ = false;
        this.resourceRefHasApplicationAuth_ = false;
        this.useContainerAuth_ = false;
        this.userName_ = null;
        this.password_ = null;
        if (resourceRef != null) {
            if (resourceRef.isContainerAuthorization()) {
                this.resourceRefHasContainerAuth_ = true;
                ResourcePrincipal principal = resourceRef.getResourcePrincipal();
                if (principal != null) {
                    this.userName_ = principal.getName();
                    this.password_ = principal.getPassword();
                    if (this.userName_ != null && this.password_ != null) {
                        this.useContainerAuth_ = true;
                    } else {
                        String errorMsg = localStrings.getLocalString("jms.no.resourceprincipal", "No resource principal for Connection Factory {0}", new Object[]{this.connectionFactoryJndiName_});
                        System.err.println(errorMsg);
                        Log.err.println(errorMsg);
                    }
                } else {
                    String errorMsg = localStrings.getLocalString("jms.no.resourceprincipal", "No resource principal for Connection Factory {0}", new Object[]{this.connectionFactoryJndiName_});
                    System.err.println(errorMsg);
                    Log.err.println(errorMsg);
                }
            } else {
                this.resourceRefHasApplicationAuth_ = true;
            }
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        JMSXAQueueConnection connection = null;
        if (this.useContainerAuth_) {
            connection = this.getQueueDelegateXA().createXAQueueConnection(this.userName_, this.password_);
        } else {
            if (this.resourceRefHasApplicationAuth_) {
                String errorMsg = localStrings.getLocalString("jms.not.container.auth.queue", "Warning : Calling createQueueConnection() on resource-ref with APPLICATION authentication.  Should use createQueueConnection(username, password)");
                System.err.println(errorMsg);
                Log.err.println(errorMsg);
            }
            connection = this.getQueueDelegateXA().createXAQueueConnection();
        }
        return this.wrapperFactory_.createQueueConnectionWrapper(connection);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (this.resourceRefHasContainerAuth_) {
            String errorMsg = localStrings.getLocalString("jms.connection.container.auth.error", "JMS Connection with container authentication  cannot programmatically set username and password");
            System.err.println(errorMsg);
            Log.err.println(errorMsg);
            throw new JMSException(errorMsg);
        }
        JMSXAQueueConnection connection = this.getQueueDelegateXA().createXAQueueConnection(userName, password);
        return this.wrapperFactory_.createQueueConnectionWrapper(connection);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        JMSXATopicConnection connection = null;
        if (this.useContainerAuth_) {
            connection = this.getTopicDelegateXA().createXATopicConnection(this.userName_, this.password_);
        } else {
            if (this.resourceRefHasApplicationAuth_) {
                String errorMsg = localStrings.getLocalString("jms.not.container.auth.topic", "Warning : Calling createTopicConnection() on resource-ref with APPLICATION authentication.  Should use createTopicConnection(username, password)");
                System.err.println(errorMsg);
                Log.err.println(errorMsg);
            }
            connection = this.getTopicDelegateXA().createXATopicConnection();
        }
        return this.wrapperFactory_.createTopicConnectionWrapper(connection);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (this.resourceRefHasContainerAuth_) {
            String errorMsg = localStrings.getLocalString("jms.connection.container.auth.error", "JMS Connection with container authentication  cannot programmatically set username and password");
            System.err.println(errorMsg);
            Log.err.println(errorMsg);
            throw new JMSException(errorMsg);
        }
        JMSXATopicConnection connection = this.getTopicDelegateXA().createXATopicConnection(userName, password);
        return this.wrapperFactory_.createTopicConnectionWrapper(connection);
    }

    private JMSXAQueueConnectionFactory getQueueDelegateXA() {
        return (JMSXAQueueConnectionFactory)this.getDelegateXA();
    }

    private JMSXATopicConnectionFactory getTopicDelegateXA() {
        return (JMSXATopicConnectionFactory)this.getDelegateXA();
    }

    private JMSXAConnectionFactory getDelegateXA() {
        if (this.delegateXA_ == null) {
            try {
                InitialContext context = new InitialContext();
                this.delegateXA_ = (JMSXAConnectionFactory)context.lookup(this.connectionFactoryJndiName_);
            }
            catch (NamingException ne) {
                String errorMsg = localStrings.getLocalString("jms.connectionfactory.not.found", "Connection Factory {0} not found", new Object[]{this.connectionFactoryJndiName_});
                Log.err.println(ne);
                Log.err.println(errorMsg);
            }
        }
        return this.delegateXA_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

