/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourceInstaller;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;

final class StatefulSessionStore {
    private final boolean debug = false;
    private static boolean tableCreated = false;
    private static DataSource dataSource;
    private Hashtable table = new Hashtable();
    private static final String dbName = "jdbc/Cloudscape";
    private static final String dbUser = "someone";
    private static final String dbPasswd = "something";
    private static final String createTableSQL = "CREATE TABLE SessionBeanTable (sessionkey LONGINT, data LONG BIT VARYING)";
    private static final String deleteTableSQL = "DROP TABLE SessionBeanTable";
    private static final String createRowSQL = "INSERT INTO SessionBeanTable (sessionkey, data) VALUES (?,?)";
    private static final String deleteRowSQL = "DELETE FROM SessionBeanTable WHERE sessionkey = ?";
    private static final String loadRowSQL = "SELECT data FROM SessionBeanTable WHERE sessionkey = ?";

    StatefulSessionStore() {
        if (!tableCreated) {
            try {
                StatefulSessionStore.createTable();
                tableCreated = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void storeEJB(Long lkey, SessionContextImpl obj) {
        this.table.put(lkey, obj);
    }

    void deleteEJB(Long lkey) {
        Object obj = this.table.remove(lkey);
        if (obj != null && obj instanceof Long && tableCreated) {
            try {
                this.removeState(lkey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    SessionContextImpl lookupEJB(Long lkey, StatefulSessionContainer container, EJBLocalRemoteObject ejbObject) {
        SessionContextImpl newObj;
        Object obj = this.table.get(lkey);
        if (obj == null) {
            return null;
        }
        if (obj instanceof SessionContextImpl) {
            return (SessionContextImpl)obj;
        }
        try {
            byte[] data = this.loadState(lkey);
            if (data == null) {
                return null;
            }
            newObj = (SessionContextImpl)EJBUtils.deserializeObject(data, container.getClassLoader());
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            return null;
        }
        catch (Error ex3) {
            Log.err.println(ex3);
            return null;
        }
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Object obj2 = this.table.get(lkey);
            if (obj2 == null) {
                SessionContextImpl sessionContextImpl = null;
                return sessionContextImpl;
            }
            if (obj2 instanceof SessionContextImpl) {
                SessionContextImpl sessionContextImpl = (SessionContextImpl)obj2;
                return sessionContextImpl;
            }
            this.table.put(lkey, newObj);
        }
        try {
            container.activateEJB(newObj, lkey, ejbObject);
        }
        catch (Exception ex4) {
            Log.err.println(ex4);
            this.table.remove(lkey);
            return null;
        }
        try {
            this.removeState(lkey);
        }
        catch (Exception ex5) {
            // empty catch block
        }
        return newObj;
    }

    Enumeration listActiveEJBs() {
        Enumeration elems = this.table.elements();
        Vector beans = new Vector();
        while (elems.hasMoreElements()) {
            Object obj = elems.nextElement();
            if (!(obj instanceof SessionContextImpl)) continue;
            beans.add(obj);
        }
        return beans.elements();
    }

    boolean passivateEJB(SessionContextImpl ctx, Long lkey) {
        if (!tableCreated) {
            return false;
        }
        try {
            byte[] data = EJBUtils.serializeObject(ctx);
            this.saveState(data, lkey);
            boolean success = false;
            Hashtable hashtable = this.table;
            synchronized (hashtable) {
                Object obj = this.table.get(lkey);
                if (ctx == obj) {
                    this.table.put(lkey, lkey);
                    success = true;
                }
            }
            if (!success) {
                try {
                    this.removeState(lkey);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            return success;
        }
        catch (Exception ex3) {
            Log.err.println(ex3);
            return false;
        }
    }

    boolean isPassivationEnabled() {
        return tableCreated;
    }

    private synchronized void saveState(byte[] data, Long lkey) throws Exception {
        if (!tableCreated) {
            throw new Exception("saveState: passivation turned off");
        }
        long key = lkey;
        Connection dbCon = null;
        PreparedStatement stmt = null;
        try {
            dbCon = dataSource.getConnection(dbUser, dbPasswd);
            stmt = dbCon.prepareStatement(createRowSQL);
            stmt.setLong(1, key);
            stmt.setBytes(2, data);
            int rc = stmt.executeUpdate();
            if (rc != 1) {
                throw new Exception("ERROR in saveState!! resultCount= " + rc);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon != null) {
                    dbCon.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (dbCon != null) {
                dbCon.close();
            }
        }
        catch (Exception ex2) {}
    }

    /*
     * Loose catch block
     */
    private synchronized byte[] loadState(Long lkey) throws Exception {
        byte[] byArray;
        if (!tableCreated) {
            return null;
        }
        Connection dbCon = null;
        PreparedStatement stmt = null;
        dbCon = dataSource.getConnection(dbUser, dbPasswd);
        stmt = dbCon.prepareStatement(loadRowSQL);
        stmt.setLong(1, lkey);
        ResultSet result = stmt.executeQuery();
        if (result.next()) break block13;
        byte[] byArray2 = null;
        Object var8_6 = null;
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (dbCon != null) {
                dbCon.close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        {
            block13: {
                return byArray2;
            }
            byArray = result.getBytes(1);
        }
        Object var8_7 = null;
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (dbCon != null) {
                dbCon.close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return byArray;
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon != null) {
                    dbCon.close();
                }
            }
            catch (Exception ex2) {}
            throw throwable;
        }
    }

    private synchronized void removeState(Long lkey) throws Exception {
        if (!tableCreated) {
            throw new Exception("saveState: passivation turned off");
        }
        Connection dbCon = null;
        PreparedStatement stmt = null;
        try {
            dbCon = dataSource.getConnection(dbUser, dbPasswd);
            stmt = dbCon.prepareStatement(deleteRowSQL);
            stmt.setLong(1, lkey);
            int rc = stmt.executeUpdate();
            if (rc != 1) {
                throw new Exception("ERROR in removeRow!! resultCount= " + rc);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon != null) {
                    dbCon.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (dbCon != null) {
                dbCon.close();
            }
        }
        catch (Exception ex2) {}
    }

    private static synchronized void createTable() throws Exception {
        InitialContext ctx = new InitialContext();
        String pmJndiName = ResourceInstaller.getPMJndiName(dbName);
        dataSource = (DataSource)ctx.lookup(pmJndiName);
        Connection dbCon = null;
        Statement stmt = null;
        try {
            dbCon = dataSource.getConnection(dbUser, dbPasswd);
            try {
                stmt = dbCon.createStatement();
                stmt.executeUpdate(deleteTableSQL);
                stmt.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            stmt = dbCon.createStatement();
            stmt.executeUpdate(createTableSQL);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon != null) {
                    dbCon.close();
                }
            }
            catch (Exception ex3) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (dbCon != null) {
                dbCon.close();
            }
        }
        catch (Exception ex3) {}
    }
}

