/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.MessageBeanHelper;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;

public abstract class MessageBeanHelperBase
implements MessageBeanHelper {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$containers$MessageBeanHelperBase == null ? (class$com$sun$ejb$containers$MessageBeanHelperBase = MessageBeanHelperBase.class$("com.sun.ejb.containers.MessageBeanHelperBase")) : class$com$sun$ejb$containers$MessageBeanHelperBase);
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final String POOL_SIZE_PROP_NAME = "messagebean.pool.size";
    private static final int MAX_SERVER_SESSION_POOL_SIZE = 100;
    private static final int DEFAULT_MAX_MESSAGES = 1;
    private static final String MAX_MESSAGES_PROP_NAME = "messagebean.max.serversessionmsgs";
    protected static final int POINT_TO_POINT = 0;
    protected static final int PUB_SUB = 1;
    private ConnectionFactory connectionFactory_ = null;
    private Connection connection_ = null;
    private Destination msgBeanDestination_;
    private EjbMessageBeanDescriptor descriptor_;
    private ServerConfiguration serverConfig_;
    private int msgStyle_;
    static /* synthetic */ Class class$com$sun$ejb$containers$MessageBeanHelperBase;

    public MessageBeanHelperBase(EjbMessageBeanDescriptor descriptor, int msgStyle) {
        this.descriptor_ = descriptor;
        this.serverConfig_ = ServerConfiguration.getConfiguration();
        this.msgStyle_ = msgStyle;
    }

    protected abstract void doSetup(MessageBeanContainer var1) throws Exception;

    protected abstract void doClose();

    public EjbMessageBeanDescriptor getDescriptor() {
        return this.descriptor_;
    }

    public void start() throws Exception {
        if (this.connection_ == null) {
            throw new JMSException("No connection available");
        }
        this.connection_.start();
    }

    public void close() {
        this.doClose();
        try {
            if (this.connection_ != null) {
                this.connection_.close();
                this.connection_ = null;
            }
        }
        catch (Exception e10) {
            Log.err.println(e10);
        }
    }

    public void setup(MessageBeanContainer container) throws Exception {
        try {
            String xaFactoryName;
            InitialContext context = new InitialContext();
            String destName = this.getDescriptor().getJndiName();
            try {
                this.msgBeanDestination_ = (Destination)context.lookup(destName);
                if (this.isQueue()) {
                    Queue queue = (Queue)this.msgBeanDestination_;
                } else {
                    Topic topic = (Topic)this.msgBeanDestination_;
                }
            }
            catch (NameNotFoundException nnfe) {
                String errorMsg = localStrings.getLocalString("msgbean.dest.notfound", "Message-bean destination factory {0} not found", new Object[]{destName});
                Log.err.println(errorMsg);
                Log.err.println(nnfe);
                throw new JMSException(errorMsg);
            }
            catch (ClassCastException cce) {
                String destTypeStr = "javax.jms." + (this.isQueue() ? "Queue" : "Topic");
                String errorMsg = localStrings.getLocalString("msgbean.desttype.mismatch", "Message-bean destination type mismatch. Destination {0} is not of type {1}", new Object[]{destName, destTypeStr});
                Log.err.println(errorMsg);
                Log.err.println(cce);
                throw new JMSException(errorMsg);
            }
            if (this.descriptor_.hasConnectionFactory()) {
                String factoryName = this.descriptor_.getConnectionFactoryName();
                xaFactoryName = JmsUtil.getXAConnectionFactoryName(factoryName);
                try {
                    ConnectionFactory factory = (ConnectionFactory)context.lookup(factoryName);
                    if (this.isQueue()) {
                        QueueConnectionFactory o2 = (QueueConnectionFactory)factory;
                    }
                    TopicConnectionFactory o3 = (TopicConnectionFactory)factory;
                }
                catch (NameNotFoundException nnfe) {
                    String errorMsg = localStrings.getLocalString("msgbean.cnxfactory.notfound", "Message-bean connection factory {0} not found", new Object[]{factoryName});
                    Log.err.println(errorMsg);
                    Log.err.println(nnfe);
                    throw new JMSException(errorMsg);
                }
                catch (ClassCastException cfcce) {
                    String destTypeStr = "javax.jms." + (this.isQueue() ? "Queue" : "Topic") + "ConnectionFactory";
                    String errorMsg = localStrings.getLocalString("msgbean.connectionfactory.type.mismatch", "Message-bean connection factory type mismatch. Connection factory {0} is not of type {1}", new Object[]{factoryName, destTypeStr});
                    Log.err.println(errorMsg);
                    Log.err.println(cfcce);
                    throw new JMSException(errorMsg);
                }
            } else {
                xaFactoryName = this.isQueue() ? "ContainerXAQueueConnectionFactory" : "ContainerXATopicConnectionFactory";
            }
            JmsWrapperFactory jmsWrapperFactory = JmsWrapperFactory.getFactoryForContainer();
            if (this.isQueue()) {
                this.connectionFactory_ = jmsWrapperFactory.createQueueConnectionFactoryWrapper(xaFactoryName);
                this.connection_ = ((QueueConnectionFactory)this.connectionFactory_).createQueueConnection();
            } else {
                this.connectionFactory_ = jmsWrapperFactory.createTopicConnectionFactoryWrapper(xaFactoryName);
                this.connection_ = ((TopicConnectionFactory)this.connectionFactory_).createTopicConnection();
            }
            this.connection_.setExceptionListener(new CnxExceptionListener());
            this.doSetup(container);
        }
        catch (Exception e10) {
            if (this.connection_ != null) {
                try {
                    this.connection_.close();
                    this.connection_ = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e10;
        }
    }

    public Session createSession() throws Exception {
        return this.isQueue() ? this.createQueueSession() : this.createTopicSession();
    }

    protected int getMaxServerSessionMessages() {
        int maxMessages = 1;
        String maxMessagesProp = this.serverConfig_.getProperty(MAX_MESSAGES_PROP_NAME);
        if (maxMessagesProp != null) {
            int value = Integer.parseInt(maxMessagesProp);
            if (value > 0) {
                maxMessages = value;
            } else {
                System.err.println("Error -- invalid maxMsgs prop = " + value);
            }
        }
        return maxMessages;
    }

    protected int getPoolSize() {
        int poolSize = 5;
        String poolSizeProp = this.serverConfig_.getProperty(POOL_SIZE_PROP_NAME);
        if (poolSizeProp != null) {
            int value = Integer.parseInt(poolSizeProp);
            if (value > 0 && value < 100) {
                poolSize = value;
            } else {
                System.err.println("Error -- invalid msg bean pool size = " + value);
            }
        }
        return poolSize;
    }

    protected boolean isQueue() {
        return this.msgStyle_ == 0;
    }

    protected QueueConnectionFactory getQueueConnectionFactory() throws Exception {
        return (QueueConnectionFactory)this.connectionFactory_;
    }

    protected TopicConnectionFactory getTopicConnectionFactory() throws Exception {
        return (TopicConnectionFactory)this.connectionFactory_;
    }

    protected QueueConnection getQueueConnection() {
        return (QueueConnection)this.connection_;
    }

    protected TopicConnection getTopicConnection() {
        return (TopicConnection)this.connection_;
    }

    protected QueueSession createQueueSession() throws Exception {
        int jmsAckMode = this.descriptor_.getJmsAcknowledgeMode();
        return this.getQueueConnection().createQueueSession(false, jmsAckMode);
    }

    protected TopicSession createTopicSession() throws Exception {
        int jmsAckMode = this.descriptor_.getJmsAcknowledgeMode();
        return this.getTopicConnection().createTopicSession(false, jmsAckMode);
    }

    protected Destination getDestination() {
        return this.msgBeanDestination_;
    }

    protected Queue getQueueDestination() {
        return (Queue)this.getDestination();
    }

    protected Topic getTopicDestination() {
        return (Topic)this.getDestination();
    }

    private void onException(JMSException jmse) {
        Log.err.println("Connection exception listener event for " + this.connection_ + " , " + this.getDescriptor());
        Log.err.println(jmse);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CnxExceptionListener
    implements ExceptionListener {
        private CnxExceptionListener() {
        }

        public void onException(JMSException jmse) {
            MessageBeanHelperBase.this.onException(jmse);
        }
    }
}

