/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.Container;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.Partition;
import com.sun.ejb.PersistenceManager;
import com.sun.ejb.PersistentInstance;
import com.sun.ejb.persistence.PMDeployerImpl;
import com.sun.ejb.persistence.PersistenceManagerImpl;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public final class PersistenceUtils {
    private static Hashtable pms = new Hashtable();
    private static Hashtable pmDeployers = new Hashtable();
    private static JarManagerImpl jarManager;

    public static Partition getPartition(PersistentInstance pi) {
        return PersistenceUtils.getPersistenceManager(pi).getPartition(pi);
    }

    public static PersistenceManager getPersistenceManager(PersistentInstance pi) {
        EjbBundleDescriptor ebd;
        PersistenceManager pm;
        if (pi == null) {
            throw new EJBException("Internal Error: instance is null");
        }
        PersistenceDescriptor pers = pi.__getPersistenceDescriptor();
        if (pers == null) {
            if (jarManager == null) {
                jarManager = Switch.getSwitch().getEJBJarManager();
            }
            Class<?> pClass = pi.getClass();
            Application app = jarManager.getApplication(pClass.getClassLoader());
            EjbCMPEntityDescriptor desc = app.getCMPDescriptorFor(pClass.getName());
            pers = desc.getPersistenceDescriptor();
            pi.__setPersistenceDescriptor(pers);
        }
        if ((pm = (PersistenceManager)pms.get(ebd = ((EjbCMPEntityDescriptor)pers.getParentDescriptor()).getEjbBundleDescriptor())) == null) {
            pm = new PersistenceManagerImpl(ebd);
            pms.put(ebd, pm);
        }
        return pm;
    }

    public static void removePersistenceManager(EjbBundleDescriptor ebd) {
        pms.remove(ebd);
    }

    public static PMDeployer getPMDeployer(EjbBundleDescriptor ebd) {
        PMDeployer pmDeployer = (PMDeployer)pmDeployers.get(ebd);
        if (pmDeployer == null) {
            pmDeployer = new PMDeployerImpl(ebd);
            pmDeployers.put(ebd, pmDeployer);
        }
        return pmDeployer;
    }

    public static void removePMDeployer(EjbBundleDescriptor ebd) {
        pmDeployers.remove(ebd);
    }

    public static EJBObject getEJBObject(EjbCMPEntityDescriptor desc, Object pkey, PersistentInstance bean) {
        try {
            if (bean != null) {
                return bean.__getEntityContext().getEJBObject();
            }
            Container container = jarManager.getContainer(desc);
            return container.getEJBObjectForPrimaryKey(pkey);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
            return null;
        }
    }

    public static EJBLocalObject getEJBLocalObject(EjbCMPEntityDescriptor desc, Object pkey, PersistentInstance bean) {
        try {
            if (bean != null) {
                return bean.__getEntityContext().getEJBLocalObject();
            }
            Container container = jarManager.getContainer(desc);
            return container.getEJBLocalObjectForPrimaryKey(pkey);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
            return null;
        }
    }

    public static void removeBean(EjbCMPEntityDescriptor desc, EJBLocalObject bean) {
        try {
            Container container = jarManager.getContainer(desc);
            container.removeBeanUnchecked(bean);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    public static void removeBean(EjbCMPEntityDescriptor desc, Object pkey) {
        try {
            Container container = jarManager.getContainer(desc);
            container.removeBeanUnchecked(pkey);
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    public static Object deepCopyValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return EJBUtils.deserializeObject(EJBUtils.serializeObject(value), Thread.currentThread().getContextClassLoader());
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
            return null;
        }
    }
}

