/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.exceptions;

/**
 *
 */
public class SQLExceptionSapDB
    extends java.sql.SQLException
{
    private static final String prefix_C = "SAP DBTech JDBC:";
    /**
     * @serial
     */
    protected String prefix = "";
    /**
     * @serial
     */
    private int errorPos = -10899;
    /**
     * SapDBTechException constructor comment.
     */
    public
    SQLExceptionSapDB()
    {
        super();
    }
    /**
     * SapDBTechException constructor comment.
     * @param reason java.lang.String
     */
    public
    SQLExceptionSapDB(
            String reason)
    {
        super(reason);
    }
    /**
     * SapDBTechException constructor comment.
     * @param reason java.lang.String
     * @param sQLState java.lang.String
     */
    public
    SQLExceptionSapDB(
            String reason,
            String sqlState)
    {
        super(reason, sqlState);
    }
    /**
     * SapDBTechException constructor comment.
     * @param reason java.lang.String
     * @param sQLState java.lang.String
     * @param vendorCode int
     */
    public
    SQLExceptionSapDB(
            String reason,
            String sqlState,
            int vendorCode)
    {
        super(reason, sqlState, vendorCode);
    }
    /**
     * SapDBTechException constructor comment.
     * @param reason java.lang.String
     * @param sQLState java.lang.String
     * @param vendorCode int
     */
    public
    SQLExceptionSapDB(
            String reason,
            String sqlState,
            int vendorCode,
            int errpos)
    {
        super(reason, sqlState, vendorCode);
        this.errorPos = errpos;
    }
    /**
     *
     * @return int
     */
    public int
    getErrorPos ()
    {
        return this.errorPos;
    }
    /**
     *
     * @return java.lang.String
     */
    public String
    getMessage ()
    {
        return this.prefix + super.getMessage ();
    }

    /**
     * Gets whether the connection is closed implicitely because of this exception.
     * @return <code>true</code> if this exception is one of these few special
     *  cases that close the connection, <code>false</code> otherwise.
     */
    public boolean isConnectionReleasing()
    {
        int err=getErrorCode();
        switch(err) {
        case -904:  // Space for result tables exhausted
        case -708:  // SERVERDB system not available
        case +700:  // Session inactivity timeout (work rolled back)
        case -70:   // Session inactivity timeout (work rolled back)
        case +710:  // Session terminated by shutdown (work rolled back)
        case -71:   // Session terminated by shutdown (work rolled back)
        case +750:  // Too many SQL statements (work rolled back)
        case -75:   // Too many SQL statements (work rolled back)
            return true;
        }
        return false;
    }

}
