/*!******************************************************************************

  @file         hsp80.h

  ------------------------------------------------------------------------------

  @author       

  @brief        RTE-Extension-80

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HSP80_H
#define HSP80_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x07\x94\x43\xde\x98\x63\x6a\x19\x01\x61\xea\xde\x9d\x88\xdd\x29'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "vsp008.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void s80uni_trans (
    const void *                         src_ptr,
    tsp00_Int4                           src_len,
    tsp00_Int2                           src_codeset,
    void *                               dest_ptr,
    tsp00_Int4            VAR_VALUE_REF  dest_len,
    tsp00_Int2                           dest_codeset,
    tsp8_uni_opt_set      VAR_ARRAY_REF  trans_options,
    tsp8_uni_error        VAR_VALUE_REF  rc,
    tsp00_Int4            VAR_VALUE_REF  err_char_no);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 s80uni_get_srcpos (
    tsp00_Int4                           dest_pos,
    tsp00_MoveObjPtr                     src_ptr,
    tsp00_Int4                           src_len,
    tsp00_Int2                           src_codeset,
    tsp8_uni_error        VAR_VALUE_REF  rc,
    tsp00_Int4            VAR_VALUE_REF  err_char_no);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp8_uni_error_Param s80uni_chartype (
    tsp00_MoveObjPtr                     str_ptr,
    tsp00_Int4            VAR_VALUE_REF  str_len,
    tsp00_Int2                           str_codeset);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s80uni_charlayout (
    tsp00_MoveObjPtr                     src_ptr,
    tsp00_Int4                           src_len,
    tsp00_Int2                           src_codeset,
    tsp00_MoveObjPtr                     dest_ptr,
    tsp8_uni_error        VAR_VALUE_REF  rc,
    tsp00_Int4            VAR_VALUE_REF  err_char_no);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s80uni_error (
    tsp8_uni_error_Param                 rc,
    tsp00_C40             VAR_ARRAY_REF  msg);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s80ascii_check (
    tsp00_MoveObjPtr                     src_ptr,
    tsp00_Int4                           src_len,
    tsp00_Int2                           src_codeset,
    tsp00_MoveObjPtr                     dest_ptr,
    tsp00_Int4            VAR_VALUE_REF  dest_len,
    tsp8_uni_error        VAR_VALUE_REF  rc,
    tsp00_Int4            VAR_VALUE_REF  err_char_no);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

