/*!******************************************************************************

  @file         hbd50.h

  ------------------------------------------------------------------------------

  @author       <unknown>

  @brief        <unknown topic>

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD50_H
#define HBD50_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x48\x40\x3a\xc1\xe1\x73\x2d\xaf\x5c\x60\xa8\x9c\x36\x50\x18\x8d'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void bd50CalculatePageCount (
    tbd_current_tree      &  current,
    tgg00_Lkey            &  startSep,
    tgg00_Lkey            &  stopSep,
    tsp00_Int4            &  pageCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50CheckSubTree (
    tsp00_PageNo             subRoot,
    tsp00_PageNo             right,
    tsp00_Int2               longColCnt,
    tsp00_Int2               newLongColCnt,
    tsp00_Int4            &  scanCount,
    tsp00_PageNo          &  boundNeighborLeaf,
    pasbool               &  bDumpParent,
    pasbool               &  bLongIsBad,
    tgg00_Lkey            &  reEntranceKey,
    tgg00_Lkey            &  checkKey,
    tbd_current_tree      &  current,
    tbd00_TreeStatistic   &  treeStatistic,
    pasbool                  bWithExtendedCheck,
    pasbool                  bCheckLongExistence,
    pasbool                  bUpdateLeaves);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50DetermineKeyRangeForServer (
    tbd_current_tree      &  PrimCurrent,
    tsp00_KeyPtr             StartPrimKey,
    tsp00_Int4            &  StartPrimKeyLen,
    tsp00_KeyPtr             StopPrimKey,
    tsp00_Int4            &  StopPrimKeyLen,
    tsp00_Int4            &  NumLeavesToScan,
    tsp00_Int4            &  AvgRecordsPerLeaf,
    pasbool               &  bFinish);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50DetermineLeafNode (
    tbd_current_tree      &  current,
    tsp00_KeyAddr            pSepKey,
    tsp00_Int4               keyLen,
    tsp00_Int4            &  recIndex,
    tsp00_PageNo          &  leaf,
    tsp00_PageNo          &  leftLeaf);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50DropSubTree (
    tsp00_PageNo             subRoot,
    integer                  numberOfLongs,
    pasbool                  bOnlyEmpty,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50EvalPageCount (
    tgg00_Lkey            &  start_key,
    tgg00_Lkey            &  stop_key,
    pasbool                  count_records,
    tsp00_Int4            &  page_count,
    tsp00_Int4            &  all_page_cnt,
    tsp00_Int4            &  record_cnt,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_RecPtr bd50GetRecPtr (
    tbd_current_tree      &  Current,
    tbd_node_ptrs         &  Nptr,
    tsp00_Int4               RecIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50ExtractForeignKey (
    tgg00_MessBlock       &  m,
    tbd_current_tree      &  current,
    tbd_current_tree      &  tempCurrent);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50ExtractTable (
    tbd_current_tree      &  current,
    tsp00_VFilename       &  hostFileName);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50FindBranchNode (
    tsp00_Key             &  sepkey,
    tsp00_Int4               keyLen,
    tsp00_Int2               wantedLevel,
    tbd_node_ptrs         &  nptrs,
    tbd_neighbors         &  neighbs,
    pasbool               &  bWantedLevelFound,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50FindFirstLevelIndexNode (
    tsp00_Key             &  sepkey,
    tsp00_Int4               keyLen,
    tbd_node_ptrs         &  nptrs,
    tbd_neighbors         &  neighbs,
    pasbool               &  bFound,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50FindLeaf (
    tsp00_KeyPtr             sepKey,
    tsp00_Int4               keyLen,
    pasbool                  bLockLeafExcl,
    tbd_node_ptrs         &  nptrs,
    tbd_neighbors         &  neighbs,
    tsp00_Int4            &  recIndexForLeaf,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50PositionLeaf (
    tsp00_Int4               leafpos,
    tsp00_Int4               leafnodes,
    tsp00_Int4            &  left_estimate,
    tsp00_Int4            &  rightestimate,
    tbd_node_ptrs         &  nptrs,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd50IndexNodeIsSaveForDelete (
    tbd_current_tree      &  current,
    tsp00_Int4               recIndex,
    tsp00_Int4               maximumKeyLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd50IndexNodeIsSaveForInsert (
    tbd_current_tree      &  current,
    tsp00_Int4               recIndex,
    tsp00_Int4               newKeyLen,
    tsp00_Int4               maximumKeyLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd50IndexNodeIsSaveForReplace (
    tbd_current_tree      &  current,
    pasbool                  bIsGrowing,
    tsp00_Int4               recIndex,
    tsp00_Int4               newKeyLen,
    tsp00_Int4               maximumKeyLen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50MoveFileContent (
    tbd_current_tree      &  sourceCurrent,
    tbd_current_tree      &  destCurrent,
    tsp00_PageNo          &  subRoot);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50ReorgTreeIndex (
    tgg00_Lkey            &  truncRecKey,
    integer                  longColCnt,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd50VerifySubTree (
    tsp00_PageNo             subRoot,
    tsp00_PageNo             right,
    pasbool                  bUpdateConverter,
    pasbool                  bWithExtendedCheck,
    pasbool                  bCheckLongExistence,
    tsp00_Int2               longColCnt,
    tgg00_Lkey            &  reEntranceKey,
    tgg00_Lkey            &  checkKey,
    tsp00_PageNo          &  boundNeighborLeaf,
    pasbool               &  bDumpParent,
    tbd_current_tree      &  current,
    tbd00_TreeStatistic   &  treeStatistic,
    tsp00_Int4            &  scanCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

