/*!******************************************************************************

  @file         hbd35.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        entryhandling

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HBD35_H
#define HBD35_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xdc\x27\xa4\x29\x79\xe6\xda\x64\x72\xfb\x88\x5d\xce\xfb\x43\x5c'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void b35add_space (
    tbd_nodeptr           VAR_VALUE_REF  nptr,
    tsp00_Int4                           pos,
    tsp00_Int4                           plus,
    tgg00_TransContextPtr                 t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b35del_space (
    tbd_nodeptr           VAR_VALUE_REF  nptr,
    tsp00_Int4                           pos,
    tsp00_Int4                           minus,
    tgg00_TransContextPtr                 t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b35get_entrykey (
    tbd_nodeptr           VAR_VALUE_REF  nptr,
    integer                              index,
    tgg00_Lkey            VAR_VALUE_REF  sep,
    tgg00_TransContextPtr                 t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b35next_entry (
    tbd_nodeptr           VAR_VALUE_REF  nptr,
    integer               VAR_VALUE_REF  index,
    pasbool               VAR_VALUE_REF  last);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b35lkey_assign (
    tgg00_Lkey            VAR_VALUE_REF  source_key,
    tgg00_Lkey            VAR_VALUE_REF  target_key,
    tgg00_BasisError      VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

