/*
        ========== licence begin  GPL
        Copyright (c) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end

*/

#ifndef SDBMSG_SRVTASKS_H
#define SDBMSG_SRVTASKS_H
/*
This header file was generated by buildmsg.pl
--- Do not edit....
*/
#ifdef __cplusplus
#ifndef MSG_LIST_HPP
#include "SAPDB/Messages/Msg_List.hpp"
#endif
#ifndef MSG_ARG_HPP
#include "SAPDB/Messages/Msg_Arg.hpp"
#endif
#ifndef MSG_SIMPLEARG_HPP
#include "SAPDB/Messages/Msg_SimpleArg.hpp"
#endif
#endif

#ifndef SDB_RELEASE_070600  /* don't merge this define - only this date: 2005-06-07 13:45:55 */
#error SDBMsg_SrvTasks.h was probably integrated between releases, do not integrate this header file, \
use buildmsg
#endif


#define SDBMSG_SRVTASKS_COMPONENT "SrvTasks"
/* Begin of all message defines for component SrvTasks -> */
/* Begin of defines for message WRONG_TASK_TYPE: ID = 2, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_WRONG_TASK_TYPE 2, "SrvTasks", __FILE__, __LINE__, "The expected task type is &quoteServerTask&quote but it is &quote$TYPE$&quote", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_WRONG_TASK_TYPE__TYPE "TYPE"
/* <- End of defines for message WRONG_TASK_TYPE */
/* Begin of defines for message TASK_STARTED_WITHOUT_JOB: ID = 3, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_TASK_STARTED_WITHOUT_JOB 3, "SrvTasks", __FILE__, __LINE__, "The server task $TASK_ID$ was started but there is no job for it.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TASK_STARTED_WITHOUT_JOB__TASK_ID "TASK_ID"
/* <- End of defines for message TASK_STARTED_WITHOUT_JOB */
/* Begin of defines for message JOB_ALREADY_EXISTS: ID = 4, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_JOB_ALREADY_EXISTS 4, "SrvTasks", __FILE__, __LINE__, "A Servertask should execute a job but is already executing another job.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message JOB_ALREADY_EXISTS */
/* Begin of defines for message NO_MORE_MEMORY_FOR_COORDINATOR: ID = 5, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_NO_MORE_MEMORY_FOR_COORDINATOR 5, "SrvTasks", __FILE__, __LINE__, "The Servertask Coordinator cannot be allocated. No more heap memory available.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NO_MORE_MEMORY_FOR_COORDINATOR */
/* Begin of defines for message NO_MORE_MEMORY_TO_REGISTER_TASK: ID = 7, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_NO_MORE_MEMORY_TO_REGISTER_TASK 7, "SrvTasks", __FILE__, __LINE__, "There is not enough heap memory to register a new servertask.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NO_MORE_MEMORY_TO_REGISTER_TASK */
/* Begin of defines for message AVAILABLE_SERVERTASKS: ID = 9, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_AVAILABLE_SERVERTASKS 9, "SrvTasks", __FILE__, __LINE__, "Available Servertasks: $UINT4$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_AVAILABLE_SERVERTASKS__UINT4 "UINT4"
/* <- End of defines for message AVAILABLE_SERVERTASKS */
/* Begin of defines for message JOB_INFO: ID = 10, VERSION = 1, TAGS = 6 -> */
#define SDBMSG_SRVTASKS_JOB_INFO 10, "SrvTasks", __FILE__, __LINE__, "Job $JOB_ID$ ($DESCRIPTION$) [$JOB_STATE$] WaitingT$JOB_WAITING_TASKID$ Result=$JOB_RESULT$", (Msg_Has6Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_JOB_INFO__DESCRIPTION "DESCRIPTION"
#define SDBMSGTAG_SRVTASKS_JOB_INFO__JOB_ID "JOB_ID"
#define SDBMSGTAG_SRVTASKS_JOB_INFO__JOB_RESULT "JOB_RESULT"
#define SDBMSGTAG_SRVTASKS_JOB_INFO__JOB_STATE "JOB_STATE"
#define SDBMSGTAG_SRVTASKS_JOB_INFO__JOB_WAITING_TASKID "JOB_WAITING_TASKID"
/* <- End of defines for message JOB_INFO */
/* Begin of defines for message JOB_COLLECTION_INFO: ID = 11, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_JOB_COLLECTION_INFO 11, "SrvTasks", __FILE__, __LINE__, "Job Type: '$DESCRIPTION$'", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_JOB_COLLECTION_INFO__DESCRIPTION "DESCRIPTION"
/* <- End of defines for message JOB_COLLECTION_INFO */
/* Begin of defines for message ALLOCATION_FAILED: ID = 13, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_ALLOCATION_FAILED 13, "SrvTasks", __FILE__, __LINE__, "Not enough heap memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message ALLOCATION_FAILED */
/* Begin of defines for message JOB_INFO_TITLE: ID = 17, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_JOB_INFO_TITLE 17, "SrvTasks", __FILE__, __LINE__, "Servertask Info: because $DESCRIPTION$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_JOB_INFO_TITLE__DESCRIPTION "DESCRIPTION"
/* <- End of defines for message JOB_INFO_TITLE */
/* Begin of defines for message RELEASE_TASK_FAILED: ID = 19, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_RELEASE_TASK_FAILED 19, "SrvTasks", __FILE__, __LINE__, "The servertask T$JOB_TASKID$ with index #$INDEX$ could not be released.", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_RELEASE_TASK_FAILED__INDEX "INDEX"
#define SDBMSGTAG_SRVTASKS_RELEASE_TASK_FAILED__JOB_TASKID "JOB_TASKID"
/* <- End of defines for message RELEASE_TASK_FAILED */
/* Begin of defines for message TASK_NOT_PROPERLY_REGISTERED: ID = 20, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_TASK_NOT_PROPERLY_REGISTERED 20, "SrvTasks", __FILE__, __LINE__, "The servertask T$JOB_TASKID$ is not registered properly.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TASK_NOT_PROPERLY_REGISTERED__JOB_TASKID "JOB_TASKID"
/* <- End of defines for message TASK_NOT_PROPERLY_REGISTERED */
/* Begin of defines for message ERRLIST_NOT_EMPTY: ID = 21, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_ERRLIST_NOT_EMPTY 21, "SrvTasks", __FILE__, __LINE__, "The errorlist is not empty but result is OK after executing the job.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message ERRLIST_NOT_EMPTY */
/* Begin of defines for message INTERNAL_ERROR: ID = 23, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_INTERNAL_ERROR 23, "SrvTasks", __FILE__, __LINE__, "INTERNAL PROGRAMMING ERROR: $DESCRIPTION$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_INTERNAL_ERROR__DESCRIPTION "DESCRIPTION"
/* <- End of defines for message INTERNAL_ERROR */
/* Begin of defines for message WRONG_JOB_STATE: ID = 24, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_WRONG_JOB_STATE 24, "SrvTasks", __FILE__, __LINE__, "The job has state $STATE$ but this is not expected.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_WRONG_JOB_STATE__STATE "STATE"
/* <- End of defines for message WRONG_JOB_STATE */
/* Begin of defines for message WRONG_WAITING_CONTEXT: ID = 25, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_WRONG_WAITING_CONTEXT 25, "SrvTasks", __FILE__, __LINE__, "The waiting task is different between job and caller.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message WRONG_WAITING_CONTEXT */
/* Begin of defines for message DROP_AUX_FILE_EXECUTED_DIRECTLY: ID = 27, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_DROP_AUX_FILE_EXECUTED_DIRECTLY 27, "SrvTasks", __FILE__, __LINE__, "Auxiliary Files can not be dropped asynchronously.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DROP_AUX_FILE_EXECUTED_DIRECTLY */
/* Begin of defines for message JOB_HAS_UNEXPECTED_STATE: ID = 29, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_JOB_HAS_UNEXPECTED_STATE 29, "SrvTasks", __FILE__, __LINE__, "A job in the joblist has an unexpected state: $JOB_STATE$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_JOB_HAS_UNEXPECTED_STATE__JOB_STATE "JOB_STATE"
/* <- End of defines for message JOB_HAS_UNEXPECTED_STATE */
/* Begin of defines for message WAIT_BUT_ALL_JOBS_ARE_CONFIRMED: ID = 30, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_SRVTASKS_WAIT_BUT_ALL_JOBS_ARE_CONFIRMED 30, "SrvTasks", __FILE__, __LINE__, "A caller should wait for a job but all jobs are confirmed.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message WAIT_BUT_ALL_JOBS_ARE_CONFIRMED */
/* Begin of defines for message SERVERTASKS_PERMANENTLY_RESERVED: ID = 31, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_SERVERTASKS_PERMANENTLY_RESERVED 31, "SrvTasks", __FILE__, __LINE__, "Permanently reserved $TASKS_WANTED$ servertasks for '$DESCRIPTION$'.", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_SERVERTASKS_PERMANENTLY_RESERVED__DESCRIPTION "DESCRIPTION"
#define SDBMSGTAG_SRVTASKS_SERVERTASKS_PERMANENTLY_RESERVED__TASKS_WANTED "TASKS_WANTED"
/* <- End of defines for message SERVERTASKS_PERMANENTLY_RESERVED */
/* Begin of defines for message SERVER_TASK_INFO: ID = 32, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_SRVTASKS_SERVER_TASK_INFO 32, "SrvTasks", __FILE__, __LINE__, "Server T$SERVER_TASK_ID$ Id$SERVER_TASK_INDEX$ $SERVER_TASK_KIND$: '$DESCRIPTION$'", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_SERVER_TASK_INFO__DESCRIPTION "DESCRIPTION"
#define SDBMSGTAG_SRVTASKS_SERVER_TASK_INFO__SERVER_TASK_ID "SERVER_TASK_ID"
#define SDBMSGTAG_SRVTASKS_SERVER_TASK_INFO__SERVER_TASK_INDEX "SERVER_TASK_INDEX"
#define SDBMSGTAG_SRVTASKS_SERVER_TASK_INFO__SERVER_TASK_KIND "SERVER_TASK_KIND"
/* <- End of defines for message SERVER_TASK_INFO */
/* Begin of defines for message SERVERTASKS_COORDINATOR_INFO: ID = 33, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_SERVERTASKS_COORDINATOR_INFO 33, "SrvTasks", __FILE__, __LINE__, "ServerTask Coordinator: Max=$MAX_SERVER_TASKS$, Used=$SERVER_TASKS_USED$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_SERVERTASKS_COORDINATOR_INFO__MAX_SERVER_TASKS "MAX_SERVER_TASKS"
#define SDBMSGTAG_SRVTASKS_SERVERTASKS_COORDINATOR_INFO__SERVER_TASKS_USED "SERVER_TASKS_USED"
/* <- End of defines for message SERVERTASKS_COORDINATOR_INFO */
/* Begin of defines for message SERVERTASK_CONTROL_INFO: ID = 34, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_SRVTASKS_SERVERTASK_CONTROL_INFO 34, "SrvTasks", __FILE__, __LINE__, "ServertaskControl #$SERVER_TASK_INDEX$, $SRVTASK_ASSIGNED$, $SRVTASKS_RESERVED$", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_SERVERTASK_CONTROL_INFO__SERVER_TASK_INDEX "SERVER_TASK_INDEX"
#define SDBMSGTAG_SRVTASKS_SERVERTASK_CONTROL_INFO__SRVTASKS_RESERVED "SRVTASKS_RESERVED"
#define SDBMSGTAG_SRVTASKS_SERVERTASK_CONTROL_INFO__SRVTASK_ASSIGNED "SRVTASK_ASSIGNED"
/* <- End of defines for message SERVERTASK_CONTROL_INFO */
/* Begin of defines for message TABLESTATISTICS_REQUESTFILE_NOT_FOUND: ID = 35, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_REQUESTFILE_NOT_FOUND 35, "SrvTasks", __FILE__, __LINE__, "Request file $FILENO$ could not be found", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_REQUESTFILE_NOT_FOUND__FILENO "FILENO"
/* <- End of defines for message TABLESTATISTICS_REQUESTFILE_NOT_FOUND */
/* Begin of defines for message TABLESTATISTICS_TABLEKEY_NOT_FOUND: ID = 36, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_TABLEKEY_NOT_FOUND 36, "SrvTasks", __FILE__, __LINE__, "Table key $KEYASHEX$ not found in request file $FILENO$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_TABLEKEY_NOT_FOUND__FILENO "FILENO"
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_TABLEKEY_NOT_FOUND__KEYASHEX "KEYASHEX"
/* <- End of defines for message TABLESTATISTICS_TABLEKEY_NOT_FOUND */
/* Begin of defines for message TABLESTATISTICS_TEMPFILE_NOT_FOUND: ID = 37, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_TEMPFILE_NOT_FOUND 37, "SrvTasks", __FILE__, __LINE__, "Temporary file $FILENO$ could not be found", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_TEMPFILE_NOT_FOUND__FILENO "FILENO"
/* <- End of defines for message TABLESTATISTICS_TEMPFILE_NOT_FOUND */
/* Begin of defines for message TABLESTATISTICS_GETTREE_FAILED: ID = 38, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_GETTREE_FAILED 38, "SrvTasks", __FILE__, __LINE__, "Locking of table $FILENO$ failed; error $RETURNCODE$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_GETTREE_FAILED__FILENO "FILENO"
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_GETTREE_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message TABLESTATISTICS_GETTREE_FAILED */
/* Begin of defines for message TABLESTATISTICS_GETTEMP_FAILED: ID = 39, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_GETTEMP_FAILED 39, "SrvTasks", __FILE__, __LINE__, "Locking of temporary file $FILENO$ failed; error $RETURNCODE$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_GETTEMP_FAILED__FILENO "FILENO"
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_GETTEMP_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message TABLESTATISTICS_GETTEMP_FAILED */
/* Begin of defines for message TABLESTATISTICS_OUT_OF_MEMORY: ID = 40, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_OUT_OF_MEMORY 40, "SrvTasks", __FILE__, __LINE__, "Out of memory: $ALLOC_SIZE$ bytes requested", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_OUT_OF_MEMORY__ALLOC_SIZE "ALLOC_SIZE"
/* <- End of defines for message TABLESTATISTICS_OUT_OF_MEMORY */
/* Begin of defines for message TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED: ID = 41, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED 41, "SrvTasks", __FILE__, __LINE__, "Initialization of sampling iterator failed for table $FILENO$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED__FILENO "FILENO"
/* <- End of defines for message TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED */
/* Begin of defines for message TABLESTATISTICS_COLLECT_FAILED: ID = 42, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_COLLECT_FAILED 42, "SrvTasks", __FILE__, __LINE__, "Error while collecting statistics for table $FILENO$;  error $RETURNCODE$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_COLLECT_FAILED__FILENO "FILENO"
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_COLLECT_FAILED__RETURNCODE "RETURNCODE"
/* <- End of defines for message TABLESTATISTICS_COLLECT_FAILED */
/* Begin of defines for message TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED: ID = 43, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED 43, "SrvTasks", __FILE__, __LINE__, "Could not update entry for table $FILENO$ in request file $FILENO1$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED__FILENO "FILENO"
#define SDBMSGTAG_SRVTASKS_TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED__FILENO1 "FILENO1"
/* <- End of defines for message TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED */
/* Begin of defines for message BACKUP_JOB_INFO: ID = 44, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_SRVTASKS_BACKUP_JOB_INFO 44, "SrvTasks", __FILE__, __LINE__, "BackupJob: autosave=$IS_AUTOSAVE$ taskNo=$BACKUP_TASK_NO$ mediaNo=$BACKUP_MEDIA_NO$ volumeNo=$BACKUP_VOLUME_NO$", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_BACKUP_JOB_INFO__BACKUP_MEDIA_NO "BACKUP_MEDIA_NO"
#define SDBMSGTAG_SRVTASKS_BACKUP_JOB_INFO__BACKUP_TASK_NO "BACKUP_TASK_NO"
#define SDBMSGTAG_SRVTASKS_BACKUP_JOB_INFO__BACKUP_VOLUME_NO "BACKUP_VOLUME_NO"
#define SDBMSGTAG_SRVTASKS_BACKUP_JOB_INFO__IS_AUTOSAVE "IS_AUTOSAVE"
/* <- End of defines for message BACKUP_JOB_INFO */
/* Begin of defines for message SELF_TEST_ERROR: ID = 45, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_SRVTASKS_SELF_TEST_ERROR 45, "SrvTasks", __FILE__, __LINE__, "SelfTest of Servertasks generated error '$ERRORTEXT$' $NO$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_SELF_TEST_ERROR__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_SRVTASKS_SELF_TEST_ERROR__NO "NO"
/* <- End of defines for message SELF_TEST_ERROR */
/* Begin of defines for message JOB_HOLDS_MEMORY_OF_SERVERTASK: ID = 46, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_SRVTASKS_JOB_HOLDS_MEMORY_OF_SERVERTASK 46, "SrvTasks", __FILE__, __LINE__, "After Job execution the job is still allocating $BYTES_USED$ bytes.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_SRVTASKS_JOB_HOLDS_MEMORY_OF_SERVERTASK__BYTES_USED "BYTES_USED"
/* <- End of defines for message JOB_HOLDS_MEMORY_OF_SERVERTASK */
/* <- End of message defines for component SrvTasks */

/* some helpful enumerations (created by buildmsg.pl) -> */

#define SDBMSG_SRVTASKS_ENUMERATION \
                    SrvTasks_WRONG_TASK_TYPE=2, \
                    SrvTasks_TASK_STARTED_WITHOUT_JOB=3, \
                    SrvTasks_JOB_ALREADY_EXISTS=4, \
                    SrvTasks_NO_MORE_MEMORY_FOR_COORDINATOR=5, \
                    SrvTasks_NO_MORE_MEMORY_TO_REGISTER_TASK=7, \
                    SrvTasks_AVAILABLE_SERVERTASKS=9, \
                    SrvTasks_JOB_INFO=10, \
                    SrvTasks_JOB_COLLECTION_INFO=11, \
                    SrvTasks_ALLOCATION_FAILED=13, \
                    SrvTasks_JOB_INFO_TITLE=17, \
                    SrvTasks_RELEASE_TASK_FAILED=19, \
                    SrvTasks_TASK_NOT_PROPERLY_REGISTERED=20, \
                    SrvTasks_ERRLIST_NOT_EMPTY=21, \
                    SrvTasks_INTERNAL_ERROR=23, \
                    SrvTasks_WRONG_JOB_STATE=24, \
                    SrvTasks_WRONG_WAITING_CONTEXT=25, \
                    SrvTasks_DROP_AUX_FILE_EXECUTED_DIRECTLY=27, \
                    SrvTasks_JOB_HAS_UNEXPECTED_STATE=29, \
                    SrvTasks_WAIT_BUT_ALL_JOBS_ARE_CONFIRMED=30, \
                    SrvTasks_SERVERTASKS_PERMANENTLY_RESERVED=31, \
                    SrvTasks_SERVER_TASK_INFO=32, \
                    SrvTasks_SERVERTASKS_COORDINATOR_INFO=33, \
                    SrvTasks_SERVERTASK_CONTROL_INFO=34, \
                    SrvTasks_TABLESTATISTICS_REQUESTFILE_NOT_FOUND=35, \
                    SrvTasks_TABLESTATISTICS_TABLEKEY_NOT_FOUND=36, \
                    SrvTasks_TABLESTATISTICS_TEMPFILE_NOT_FOUND=37, \
                    SrvTasks_TABLESTATISTICS_GETTREE_FAILED=38, \
                    SrvTasks_TABLESTATISTICS_GETTEMP_FAILED=39, \
                    SrvTasks_TABLESTATISTICS_OUT_OF_MEMORY=40, \
                    SrvTasks_TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED=41, \
                    SrvTasks_TABLESTATISTICS_COLLECT_FAILED=42, \
                    SrvTasks_TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED=43, \
                    SrvTasks_BACKUP_JOB_INFO=44, \
                    SrvTasks_SELF_TEST_ERROR=45, \
                    SrvTasks_JOB_HOLDS_MEMORY_OF_SERVERTASK=46
#define SDBMSG_SRVTASKS_INITIALIZATIONLIST(x) \
                    x(SDBMSG_SRVTASKS_WRONG_TASK_TYPE, "WRONG_TASK_TYPE"), \
                    x(SDBMSG_SRVTASKS_TASK_STARTED_WITHOUT_JOB, "TASK_STARTED_WITHOUT_JOB"), \
                    x(SDBMSG_SRVTASKS_JOB_ALREADY_EXISTS, "JOB_ALREADY_EXISTS"), \
                    x(SDBMSG_SRVTASKS_NO_MORE_MEMORY_FOR_COORDINATOR, "NO_MORE_MEMORY_FOR_COORDINATOR"), \
                    x(SDBMSG_SRVTASKS_NO_MORE_MEMORY_TO_REGISTER_TASK, "NO_MORE_MEMORY_TO_REGISTER_TASK"), \
                    x(SDBMSG_SRVTASKS_AVAILABLE_SERVERTASKS, "AVAILABLE_SERVERTASKS"), \
                    x(SDBMSG_SRVTASKS_JOB_INFO, "JOB_INFO"), \
                    x(SDBMSG_SRVTASKS_JOB_COLLECTION_INFO, "JOB_COLLECTION_INFO"), \
                    x(SDBMSG_SRVTASKS_ALLOCATION_FAILED, "ALLOCATION_FAILED"), \
                    x(SDBMSG_SRVTASKS_JOB_INFO_TITLE, "JOB_INFO_TITLE"), \
                    x(SDBMSG_SRVTASKS_RELEASE_TASK_FAILED, "RELEASE_TASK_FAILED"), \
                    x(SDBMSG_SRVTASKS_TASK_NOT_PROPERLY_REGISTERED, "TASK_NOT_PROPERLY_REGISTERED"), \
                    x(SDBMSG_SRVTASKS_ERRLIST_NOT_EMPTY, "ERRLIST_NOT_EMPTY"), \
                    x(SDBMSG_SRVTASKS_INTERNAL_ERROR, "INTERNAL_ERROR"), \
                    x(SDBMSG_SRVTASKS_WRONG_JOB_STATE, "WRONG_JOB_STATE"), \
                    x(SDBMSG_SRVTASKS_WRONG_WAITING_CONTEXT, "WRONG_WAITING_CONTEXT"), \
                    x(SDBMSG_SRVTASKS_DROP_AUX_FILE_EXECUTED_DIRECTLY, "DROP_AUX_FILE_EXECUTED_DIRECTLY"), \
                    x(SDBMSG_SRVTASKS_JOB_HAS_UNEXPECTED_STATE, "JOB_HAS_UNEXPECTED_STATE"), \
                    x(SDBMSG_SRVTASKS_WAIT_BUT_ALL_JOBS_ARE_CONFIRMED, "WAIT_BUT_ALL_JOBS_ARE_CONFIRMED"), \
                    x(SDBMSG_SRVTASKS_SERVERTASKS_PERMANENTLY_RESERVED, "SERVERTASKS_PERMANENTLY_RESERVED"), \
                    x(SDBMSG_SRVTASKS_SERVER_TASK_INFO, "SERVER_TASK_INFO"), \
                    x(SDBMSG_SRVTASKS_SERVERTASKS_COORDINATOR_INFO, "SERVERTASKS_COORDINATOR_INFO"), \
                    x(SDBMSG_SRVTASKS_SERVERTASK_CONTROL_INFO, "SERVERTASK_CONTROL_INFO"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_REQUESTFILE_NOT_FOUND, "TABLESTATISTICS_REQUESTFILE_NOT_FOUND"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_TABLEKEY_NOT_FOUND, "TABLESTATISTICS_TABLEKEY_NOT_FOUND"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_TEMPFILE_NOT_FOUND, "TABLESTATISTICS_TEMPFILE_NOT_FOUND"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_GETTREE_FAILED, "TABLESTATISTICS_GETTREE_FAILED"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_GETTEMP_FAILED, "TABLESTATISTICS_GETTEMP_FAILED"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_OUT_OF_MEMORY, "TABLESTATISTICS_OUT_OF_MEMORY"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED, "TABLESTATISTICS_INITSAMPLINGITERATOR_FAILED"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_COLLECT_FAILED, "TABLESTATISTICS_COLLECT_FAILED"), \
                    x(SDBMSG_SRVTASKS_TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED, "TABLESTATISTICS_UPDATE_REQUESTFILE_FAILED"), \
                    x(SDBMSG_SRVTASKS_BACKUP_JOB_INFO, "BACKUP_JOB_INFO"), \
                    x(SDBMSG_SRVTASKS_SELF_TEST_ERROR, "SELF_TEST_ERROR"), \
                    x(SDBMSG_SRVTASKS_JOB_HOLDS_MEMORY_OF_SERVERTASK, "JOB_HOLDS_MEMORY_OF_SERVERTASK")
/* <- some helpful enumerations */

#endif /* SDBMSG_SRVTASKS_H */
