/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef RTE_MESSAGES_HPP
#define RTE_MESSAGES_HPP

// Generated Header file RTE_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define RTEERR_TLS_KEY_CREATE                          SAPDBErr_MessageList::Error,20000,"Thread local storage key create failed",0
#define RTEERR_TLS_KEY_CREATE_ID 20000
#define RTEERR_TLS_KEY_DELETE                          SAPDBErr_MessageList::Error,20001,"Thread local storage key %s delete failed",1
#define RTEERR_TLS_KEY_DELETE_ID 20001
#define RTEERR_TLS_GET                                 SAPDBErr_MessageList::Error,20002,"Thread local storage key %s get value failed",1
#define RTEERR_TLS_GET_ID 20002
#define RTEERR_TLS_SET                                 SAPDBErr_MessageList::Error,20003,"Thread local storage key %s set value %s failed",2
#define RTEERR_TLS_SET_ID 20003
#define RTEERR_ALLOCATION_FAILED                       SAPDBErr_MessageList::Error,20004,"Allocation of %s failed",1
#define RTEERR_ALLOCATION_FAILED_ID 20004
#define RTEERR_FORMATTING_FAILED                       SAPDBErr_MessageList::Error,20005,"Formatting failed :%s",1
#define RTEERR_FORMATTING_FAILED_ID 20005
#define RTEERR_SYS_LOAD_DLL                            SAPDBErr_MessageList::Error,20006,"Loading DLL %s failed",1
#define RTEERR_SYS_LOAD_DLL_ID 20006
#define RTEERR_SYS_ALLOC_INST                          SAPDBErr_MessageList::Error,20007,"No more memory for %s instance available",1
#define RTEERR_SYS_ALLOC_INST_ID 20007
#define RTEERR_SYS_ALLOC_ARRAY_INST                    SAPDBErr_MessageList::Error,20008,"No more memory for array of %s %s instances available",2
#define RTEERR_SYS_ALLOC_ARRAY_INST_ID 20008
#define RTEERR_SYS_FREE_DLL                            SAPDBErr_MessageList::Error,20009,"Release DLL %s failed",1
#define RTEERR_SYS_FREE_DLL_ID 20009
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_READ       SAPDBErr_MessageList::Error,20010,"Could not open file %s for read, rc = %s",2
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_READ_ID 20010
#define RTEERR_CONF_COULD_NOT_READ_FROM_FILE           SAPDBErr_MessageList::Error,20011,"Could not read from file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_READ_FROM_FILE_ID 20011
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_WRITE      SAPDBErr_MessageList::Error,20012,"Could not open file %s for write, rc = %s",2
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_WRITE_ID 20012
#define RTEERR_CONF_COULD_NOT_WRITE_TO_FILE            SAPDBErr_MessageList::Error,20013,"Could not write to file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_WRITE_TO_FILE_ID 20013
#define RTEERR_CONF_COULD_NOT_SEEK_IN_FILE             SAPDBErr_MessageList::Error,20014,"Could not seek in file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_SEEK_IN_FILE_ID 20014
#define RTEERR_CONF_COULD_NOT_CLOSE_FILE               SAPDBErr_MessageList::Error,20015,"Could not close file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_CLOSE_FILE_ID 20015
#define RTEERR_CONF_UNKNOWN_FILETYPE                   SAPDBErr_MessageList::Error,20016,"file %s has unknown type",1
#define RTEERR_CONF_UNKNOWN_FILETYPE_ID 20016
#define RTEERR_CONF_PARAMETER_NAME_TOO_LONG            SAPDBErr_MessageList::Error,20017,"Length of Parameter name %s exceeds maximum length of %s characters",2
#define RTEERR_CONF_PARAMETER_NAME_TOO_LONG_ID 20017
#define RTEERR_CONF_STRING_VALUE_TOO_LONG              SAPDBErr_MessageList::Error,20018,"Length of string value %s exceeds maximum length of %s characters",2
#define RTEERR_CONF_STRING_VALUE_TOO_LONG_ID 20018
#define RTEERR_CONF_PARAMFILE_NOT_FOUND                SAPDBErr_MessageList::Error,20019,"Parameter file for database %s not found, rc = %s",2
#define RTEERR_CONF_PARAMFILE_NOT_FOUND_ID 20019
#define RTEERR_CONF_PARAMNAME_LENGTH_TOO_BIG           SAPDBErr_MessageList::Error,20020,"length of parameter names in parameter file (%s) exceeds length configured for kernel (%s)",2
#define RTEERR_CONF_PARAMNAME_LENGTH_TOO_BIG_ID 20020
#define RTEERR_CONF_PARAMVALUE_LENGTH_TOO_BIG          SAPDBErr_MessageList::Error,20021,"length of parameter string values in parameter file (%s) exceeds length configured for kernel (%s)",2
#define RTEERR_CONF_PARAMVALUE_LENGTH_TOO_BIG_ID 20021
#define RTEERR_CONF_NOT_ENOUGH_SPACE_FOR_STRING_PARAM  SAPDBErr_MessageList::Error,20022,"not enough space for string parameter: found %s bytes, needed %s bytes",2
#define RTEERR_CONF_NOT_ENOUGH_SPACE_FOR_STRING_PARAM_ID 20022
#define RTEERR_CONF_TYPE_MISMATCH                      SAPDBErr_MessageList::Error,20023,"parameter type mismatch: found %s, needed %s",2
#define RTEERR_CONF_TYPE_MISMATCH_ID 20023
#define RTEERR_CONF_INCONSISTENT_HSS_CONFIG            SAPDBErr_MessageList::Error,20024,"the list of configured HotStandBy nodes is not consistent",0
#define RTEERR_CONF_INCONSISTENT_HSS_CONFIG_ID 20024
#define RTEERR_CONF_LOCAL_NODE_NOT_FOUND_IN_HSS_CONFIG SAPDBErr_MessageList::Error,20025,"the local node name (%s) could not be found in the list of configured HotStandBy nodes",1
#define RTEERR_CONF_LOCAL_NODE_NOT_FOUND_IN_HSS_CONFIG_ID 20025
#define RTEERR_CONF_MISSING_DEFAULT_HSS_NODE           SAPDBErr_MessageList::Error,20026,"there are HotStandBy nodes configured, but the default node (node #1) is missing",0
#define RTEERR_CONF_MISSING_DEFAULT_HSS_NODE_ID 20026
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT1              SAPDBErr_MessageList::Error,20027,"The configured volume size of %s MB for %s %s exceeds the limit set by ulimits (%s MB).",4
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT1_ID 20027
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT2              SAPDBErr_MessageList::Error,20028,"Please adjust the volume size or the ulimit.",0
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT2_ID 20028
#define RTEERR_CONF_INVALID_VALUE_FOR_PARAM            SAPDBErr_MessageList::Error,20029,"Invalid value %s for parameter %s",2
#define RTEERR_CONF_INVALID_VALUE_FOR_PARAM_ID 20029
#define RTEERR_CONF_INVALID_CACHE_SIZE                 SAPDBErr_MessageList::Error,20030,"Invalid value %s for parameter CACHE_SIZE, must be at least 800",1
#define RTEERR_CONF_INVALID_CACHE_SIZE_ID 20030
#define RTEERR_CONF_INVALID_VALUE_FOR_PARAM_EXPECTED_X SAPDBErr_MessageList::Error,20031,"Invalid value %s for parameter %s, expected %s",3
#define RTEERR_CONF_INVALID_VALUE_FOR_PARAM_EXPECTED_X_ID 20031
#define RTEERR_CONF_DUPLICATE_VOLUME_NAME              SAPDBErr_MessageList::Error,20032,"Duplicate volume name found: %s",1
#define RTEERR_CONF_DUPLICATE_VOLUME_NAME_ID 20032
#define RTEERR_CONF_CHANGEABLE_BUT_NO_UPDATE_FUNC      SAPDBErr_MessageList::Error,20033,"parameter %s can be changed in online mode but has no update function",1
#define RTEERR_CONF_CHANGEABLE_BUT_NO_UPDATE_FUNC_ID 20033
#define RTEERR_CONF_UPDATE_FUNC_BUT_NOT_CHANGEABLE     SAPDBErr_MessageList::Error,20034,"parameter %s has update function but cannot be changed in online mode",1
#define RTEERR_CONF_UPDATE_FUNC_BUT_NOT_CHANGEABLE_ID 20034
#define RTEERR_CONF_NOT_FOUND                          SAPDBErr_MessageList::Error,20035,"Parameter %s not found",1
#define RTEERR_CONF_NOT_FOUND_ID 20035
#define RTEERR_CONF_WRONG_TYPE                         SAPDBErr_MessageList::Error,20036,"Parameter %s: wrong type (expected: %s, found: %s)",3
#define RTEERR_CONF_WRONG_TYPE_ID 20036
#define RTEERR_CONF_INCOMPATIBLE_VERSIONS              SAPDBErr_MessageList::Error,20037,"incompatible versions:",0
#define RTEERR_CONF_INCOMPATIBLE_VERSIONS_ID 20037
#define RTEERR_CONF_RUNNING_KERNEL_VERSION             SAPDBErr_MessageList::Error,20038,"  Running kernel %s",1
#define RTEERR_CONF_RUNNING_KERNEL_VERSION_ID 20038
#define RTEERR_CONF_PARAMFILE_VERSION                  SAPDBErr_MessageList::Error,20039,"  Param file     %s",1
#define RTEERR_CONF_PARAMFILE_VERSION_ID 20039
#define RTEERR_CONF_PARAMETER_ALREADY_EXISTS           SAPDBErr_MessageList::Error,20040,"Parameter %s already exists",1
#define RTEERR_CONF_PARAMETER_ALREADY_EXISTS_ID 20040
#define RTEERR_ACCESS_DENIED_ON_XX                     SAPDBErr_MessageList::Error,20041,"Access on '%s' denied",1
#define RTEERR_ACCESS_DENIED_ON_XX_ID 20041
#define RTEERR_ACCESS_DENIED                           SAPDBErr_MessageList::Error,20042,"Access denied",0
#define RTEERR_ACCESS_DENIED_ID 20042
#define RTEERR_SETTING_THRD_PRIO                       SAPDBErr_MessageList::Error,20043,"Could not set the thread priority, TID:0x%s",1
#define RTEERR_SETTING_THRD_PRIO_ID 20043
#define RTEERR_LOCAL_NODE_TOO_LONG                     SAPDBErr_MessageList::Error,20044,"Local node name '%s' too long",1
#define RTEERR_LOCAL_NODE_TOO_LONG_ID 20044
#define RTEERR_ITEMREGISTER_CORRUPT                    SAPDBErr_MessageList::Error,20045,"RTE_ItemRegister is corrupt! Presumably the item '%s' has been deleted but not deregistered, item is %s, should be %s. ElementCounter is %s",4
#define RTEERR_ITEMREGISTER_CORRUPT_ID 20045
#define RTEERR_SYS_LOAD_SHARED_LIB                     SAPDBErr_MessageList::Error,20046,"Loading DLL %s failed %s",2
#define RTEERR_SYS_LOAD_SHARED_LIB_ID 20046
#define RTEERR_SYS_UNLOAD_SHARED_LIB                   SAPDBErr_MessageList::Error,20047,"Unloading DLL %s failed %s",2
#define RTEERR_SYS_UNLOAD_SHARED_LIB_ID 20047
#define RTEERR_SYS_GET_PROC_ADDRESS                    SAPDBErr_MessageList::Error,20048,"Get address for procedure %s from DLL %s failed %s",3
#define RTEERR_SYS_GET_PROC_ADDRESS_ID 20048
#define RTEERR_HSS_API_DLL_NOT_USABLE                  SAPDBErr_MessageList::Error,20049,"Call to %s failed since RTEHSS_Api is not usable",1
#define RTEERR_HSS_API_DLL_NOT_USABLE_ID 20049
#define RTEERR_HSS_APICALL_FAILED                      SAPDBErr_MessageList::Error,20050,"Call to %s failed: Reported result code %s(%s)",3
#define RTEERR_HSS_APICALL_FAILED_ID 20050
#define RTEERR_XP_INVALID_FORMATTING_MODE              SAPDBErr_MessageList::Error,20051,"Invalid formatting mode '%s'",1
#define RTEERR_XP_INVALID_FORMATTING_MODE_ID 20051
#define RTEERR_XP_TOO_MANY_DEVSPACES                   SAPDBErr_MessageList::Error,20052,"Too many volumes, type='%s', allowed=%s",2
#define RTEERR_XP_TOO_MANY_DEVSPACES_ID 20052
#define RTEERR_MALLOC_FAILED_FOR                       SAPDBErr_MessageList::Error,20053,"memory allocation failed for '%s'",1
#define RTEERR_MALLOC_FAILED_FOR_ID 20053
#define RTEERR_XP_TOO_MANY_TASKCLUSTER                 SAPDBErr_MessageList::Error,20054,"Too many Taskclusters, wanted=%s, allowed=%s",2
#define RTEERR_XP_TOO_MANY_TASKCLUSTER_ID 20054
#define RTEERR_ILLEGAL_XP_TYPE                         SAPDBErr_MessageList::Error,20055,"Illegal xp_type %s   ",1
#define RTEERR_ILLEGAL_XP_TYPE_ID 20055
#define RTEERR_DEVSPACE_ALREADY_EXISTS                 SAPDBErr_MessageList::Error,20056,"Volume '%s' already exists",1
#define RTEERR_DEVSPACE_ALREADY_EXISTS_ID 20056
#define RTEERR_XP_UNKNOWN_PARAM                        SAPDBErr_MessageList::Error,20057,"unknown Parameter %s",1
#define RTEERR_XP_UNKNOWN_PARAM_ID 20057
#define RTEERR_CANT_CHANGE_PARAMETER_ONLINE            SAPDBErr_MessageList::Error,20058,"cannot change parameter %s while database is running",1
#define RTEERR_CANT_CHANGE_PARAMETER_ONLINE_ID 20058
#define RTEERR_NO_CHANGE_PERMISSION                    SAPDBErr_MessageList::Error,20059,"parameter %s can only be changed by sysdba",1
#define RTEERR_NO_CHANGE_PERMISSION_ID 20059
#define RTEERR_ITERATION_HAD_NOT_BEEN_STARTED          SAPDBErr_MessageList::Error,20060,"iteration through the parameter set had not been started",0
#define RTEERR_ITERATION_HAD_NOT_BEEN_STARTED_ID 20060
#define RTEERR_INVALID_NODE_NAME_ENTRY                 SAPDBErr_MessageList::Error,20061,"invalid HSS_NODE_NAME entry in parameter file: %s=%s",2
#define RTEERR_INVALID_NODE_NAME_ENTRY_ID 20061
#define RTEERR_GENERAL                                 SAPDBErr_MessageList::Error,20062,"RTE error %s",1
#define RTEERR_GENERAL_ID 20062
#define RTEERR_DBREG_COULD_NOT_READ_RELEASE_VERSION    SAPDBErr_MessageList::Error,20063,"could not read release version for installation from registry",0
#define RTEERR_DBREG_COULD_NOT_READ_RELEASE_VERSION_ID 20063
#define RTEERR_DBREG_COULD_NOT_WRITE_TO_REGISTRY       SAPDBErr_MessageList::Error,20064,"could not write to registry, error message: %s",1
#define RTEERR_DBREG_COULD_NOT_WRITE_TO_REGISTRY_ID 20064
#define RTEERR_DBREG_COULD_NOT_READ_FROM_REGISTRY      SAPDBErr_MessageList::Error,20065,"could not read from registry, error message: %s",1
#define RTEERR_DBREG_COULD_NOT_READ_FROM_REGISTRY_ID 20065
#define RTEERR_DBREG_COULD_NOT_REMOVE_FROM_REGISTRY    SAPDBErr_MessageList::Error,20066,"could not remove entry from registry, error message: %s",1
#define RTEERR_DBREG_COULD_NOT_REMOVE_FROM_REGISTRY_ID 20066
#define RTEERR_DBREG_COULD_NOT_GET_KERNEL_STATE        SAPDBErr_MessageList::Error,20067,"Getting Kernel state failed: %s",1
#define RTEERR_DBREG_COULD_NOT_GET_KERNEL_STATE_ID 20067
#define RTEERR_DBREG_SERVICE_DB_LOCKED                 SAPDBErr_MessageList::Error,20068,"Service database has been locked by another process",0
#define RTEERR_DBREG_SERVICE_DB_LOCKED_ID 20068
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED_CORRECTLY   SAPDBErr_MessageList::Error,20069,"Service has not been installed correctly",0
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED_CORRECTLY_ID 20069
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED             SAPDBErr_MessageList::Error,20070,"Service '%s%s (%s)' not installed",3
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED_ID 20070
#define RTEERR_DBREG_SERVERDB_NOT_RESPONDING           SAPDBErr_MessageList::Error,20071,"Time out, SERVERDB is not responding",0
#define RTEERR_DBREG_SERVERDB_NOT_RESPONDING_ID 20071
#define RTEERR_DBREG_SERVICE_LOGON_FAILURE             SAPDBErr_MessageList::Error,20072,"'%s%s (%s)' did not start due to a service logon failure",3
#define RTEERR_DBREG_SERVICE_LOGON_FAILURE_ID 20072
#define RTEERR_DBREG_COULD_NOT_START                   SAPDBErr_MessageList::Error,20073,"'%s' could not be started, rc = %s",2
#define RTEERR_DBREG_COULD_NOT_START_ID 20073
#define RTEERR_DBREG_DB_NOT_STARTED                    SAPDBErr_MessageList::Error,20074,"Database '%s' has not been started",1
#define RTEERR_DBREG_DB_NOT_STARTED_ID 20074
#define RTEERR_DBREG_NAME_TOO_LONG                     SAPDBErr_MessageList::Error,20075,"Database name %s too long",1
#define RTEERR_DBREG_NAME_TOO_LONG_ID 20075
#define RTEERR_DBREG_ALREADY_STARTED                   SAPDBErr_MessageList::Error,20076,"Database %s already started",1
#define RTEERR_DBREG_ALREADY_STARTED_ID 20076
#define RTEERR_DBREG_CANNOT_CREATE_IPC_DB_DIR          SAPDBErr_MessageList::Error,20077,"Cannot create ipc db directories for %s",1
#define RTEERR_DBREG_CANNOT_CREATE_IPC_DB_DIR_ID 20077
#define RTEERR_DBREG_CANNOT_CREATE_IPC_US_DIR          SAPDBErr_MessageList::Error,20078,"Cannot create ipc us directories for %s",1
#define RTEERR_DBREG_CANNOT_CREATE_IPC_US_DIR_ID 20078
#define RTEERR_DBREG_IPC_DIR_STILL_EXISTS              SAPDBErr_MessageList::Error,20079,"IPC directory '%s' still exists",1
#define RTEERR_DBREG_IPC_DIR_STILL_EXISTS_ID 20079
#define RTEERR_DBREG_CANNOT_REMOVE_IPC_RESOURCES       SAPDBErr_MessageList::Error,20080,"cannot remove IPC resources: %s",1
#define RTEERR_DBREG_CANNOT_REMOVE_IPC_RESOURCES_ID 20080
#define RTEERR_DBREG_CANNOT_CATCH_SIGCLD               SAPDBErr_MessageList::Error,20081,"cannot catch SIGCLD, %s",1
#define RTEERR_DBREG_CANNOT_CATCH_SIGCLD_ID 20081
#define RTEERR_DBREG_CANNOT_IGNORE_SIGWINCH            SAPDBErr_MessageList::Error,20082,"cannot ignore SIGWINCH, %s",1
#define RTEERR_DBREG_CANNOT_IGNORE_SIGWINCH_ID 20082
#define RTEERR_DBREG_CANNOT_WAIT_FOR_STARTER           SAPDBErr_MessageList::Error,20083,"Cannot wait for kernel starter: %s",1
#define RTEERR_DBREG_CANNOT_WAIT_FOR_STARTER_ID 20083
#define RTEERR_DBREG_STARTER_DID_NOT_EXIT_NORMALLY     SAPDBErr_MessageList::Error,20084,"Kernel starter process did not exit normally: %s",1
#define RTEERR_DBREG_STARTER_DID_NOT_EXIT_NORMALLY_ID 20084
#define RTEERR_DBREG_CANNOT_REDIRECT_STDOUT            SAPDBErr_MessageList::Error,20085,"Cannot redirect stdout to '/dev/null'",0
#define RTEERR_DBREG_CANNOT_REDIRECT_STDOUT_ID 20085
#define RTEERR_DBREG_CANNOT_REDIRECT_STDERR            SAPDBErr_MessageList::Error,20086,"Cannot redirect stderr to '/dev/null'",0
#define RTEERR_DBREG_CANNOT_REDIRECT_STDERR_ID 20086
#define RTEERR_DBREG_CANNOT_OPEN_DEV_NULL              SAPDBErr_MessageList::Error,20087,"Cannot open '/dev/null' for redirection",0
#define RTEERR_DBREG_CANNOT_OPEN_DEV_NULL_ID 20087
#define RTEERR_DBREG_CANNOT_FORK                       SAPDBErr_MessageList::Error,20088,"Cannot fork to start kernel",0
#define RTEERR_DBREG_CANNOT_FORK_ID 20088
#define RTEERR_DBREG_KERNEL_DIED_BEFORE_ADMIN          SAPDBErr_MessageList::Error,20089,"Check knldiag! Kernel died before reaching ADMIN state",0
#define RTEERR_DBREG_KERNEL_DIED_BEFORE_ADMIN_ID 20089
#define RTEERR_DBREG_KERNEL_EXITED_BEFORE_ADMIN        SAPDBErr_MessageList::Error,20090,"Check knldiag! Kernel exited with '%s' before reaching ADMIN state",1
#define RTEERR_DBREG_KERNEL_EXITED_BEFORE_ADMIN_ID 20090
#define RTEERR_DBREG_KILL_FAILED                       SAPDBErr_MessageList::Error,20091,"STOP: Kill failed: %s",1
#define RTEERR_DBREG_KILL_FAILED_ID 20091
#define RTEERR_DBREG_SLEEP_FAILED                      SAPDBErr_MessageList::Error,20092,"Sleep failed: %s",1
#define RTEERR_DBREG_SLEEP_FAILED_ID 20092
#define RTEERR_DBREG_COULD_NOT_KILL_KERNEL             SAPDBErr_MessageList::Error,20093,"The database kernel process could not be killed (the process is still alive %s seconds after the kill command has been issued)",1
#define RTEERR_DBREG_COULD_NOT_KILL_KERNEL_ID 20093
#define RTEERR_DBREG_WAITPID_FAILED                    SAPDBErr_MessageList::Error,20094,"Waitpid failed: %s",1
#define RTEERR_DBREG_WAITPID_FAILED_ID 20094
#define RTEERR_DBREG_KERNEL_EXE_MISSING                SAPDBErr_MessageList::Error,20095,"kernel program missing '%s'",1
#define RTEERR_DBREG_KERNEL_EXE_MISSING_ID 20095
#define RTEERR_DBREG_KERNEL_NOT_EXECUTABLE             SAPDBErr_MessageList::Error,20096,"kernel program not executable '%s'",1
#define RTEERR_DBREG_KERNEL_NOT_EXECUTABLE_ID 20096
#define RTEERR_DBREG_NO_RWX_PERMISSION                 SAPDBErr_MessageList::Error,20097,"You don't have read+write+execute permission on the run-directory '%s'",1
#define RTEERR_DBREG_NO_RWX_PERMISSION_ID 20097
#define RTEERR_DBREG_NO_DBROOT                         SAPDBErr_MessageList::Error,20098,"Internal usage error: No dbroot given for '%s'",1
#define RTEERR_DBREG_NO_DBROOT_ID 20098
#define RTEERR_DBREG_STOPPED_EV_LOG                    SAPDBErr_MessageList::Error,20099,"'%s' has stopped unexpectedly, (view 'Application Event Log')",1
#define RTEERR_DBREG_STOPPED_EV_LOG_ID 20099
#define RTEERR_DBREG_SERVICE_ACCOUNT_INVALID           SAPDBErr_MessageList::Error,20100,"The account name is invalid or does not exist",0
#define RTEERR_DBREG_SERVICE_ACCOUNT_INVALID_ID 20100
#define RTEERR_DBREG_SERVER_NODE_UNKNOWN               SAPDBErr_MessageList::Error,20101,"Server node '%s' not available",1
#define RTEERR_DBREG_SERVER_NODE_UNKNOWN_ID 20101
#define RTEERR_DBREG_CREAT_SERVICE_NO_ACCESS           SAPDBErr_MessageList::Error,20102,"Could not create/update/delete service entry, access denied",0
#define RTEERR_DBREG_CREAT_SERVICE_NO_ACCESS_ID 20102
#define RTEERR_DBREG_SERVICE_ERROR                     SAPDBErr_MessageList::Error,20103,"Could not install/remove service, rc = %s",1
#define RTEERR_DBREG_SERVICE_ERROR_ID 20103
#define RTEERR_DBREG_WRONG_DB_VERSION                  SAPDBErr_MessageList::Error,20104,"Incompatible version of running kernel and console!\nRunning kernel-version is: %s\nActual console-version is: %s",2
#define RTEERR_DBREG_WRONG_DB_VERSION_ID 20104
#define RTEERR_DBREG_COULD_NOT_CREATE_SERVER_KEY       SAPDBErr_MessageList::Error,20105,"Server key not creatable",0
#define RTEERR_DBREG_COULD_NOT_CREATE_SERVER_KEY_ID 20105
#define RTEERR_DBREG_SERVER_KEY_INVALID                SAPDBErr_MessageList::Error,20106,"Server key file invalid",0
#define RTEERR_DBREG_SERVER_KEY_INVALID_ID 20106
#define RTEERR_DBREG_NO_KERNEL_EXE                     SAPDBErr_MessageList::Error,20107,"no kernel executable found",0
#define RTEERR_DBREG_NO_KERNEL_EXE_ID 20107
#define RTEERR_GET_DBROOT_PGM_PATH                     SAPDBErr_MessageList::Error,20108,"Determination of kernel executable path failed: OS_ERROR  %s, RTE_ERROR %s",2
#define RTEERR_GET_DBROOT_PGM_PATH_ID 20108
#define RTEERR_DBREG_OPEN_KERNEL_PROCESS               SAPDBErr_MessageList::Error,20109,"Open kernel process failed, rc = %s",1
#define RTEERR_DBREG_OPEN_KERNEL_PROCESS_ID 20109
#define RTEERR_DBREG_WAIT_FOR_KERNEL                   SAPDBErr_MessageList::Error,20110,"Wait for kernel process failed, rc = %s",1
#define RTEERR_DBREG_WAIT_FOR_KERNEL_ID 20110
#define RTEERR_SYNC_RWREGION_ID_ZERO                   SAPDBErr_MessageList::Error,20111,"task %s called %s for region 0",2
#define RTEERR_SYNC_RWREGION_ID_ZERO_ID 20111
#define RTEERR_SYNC_RWREGION_ALREADY_ENTERED           SAPDBErr_MessageList::Error,20112,"task %s called enter(), but is already in region %s",2
#define RTEERR_SYNC_RWREGION_ALREADY_ENTERED_ID 20112
#define RTEERR_SYNC_RWREGION_LEAVE_WITHOUT_ENTER       SAPDBErr_MessageList::Error,20113,"task %s called leave(), but region %s is free",2
#define RTEERR_SYNC_RWREGION_LEAVE_WITHOUT_ENTER_ID 20113
#define RTEERR_SYNC_RWREGION_INCONSISTENCY             SAPDBErr_MessageList::Error,20114,"incosistent state of rw-region %s",1
#define RTEERR_SYNC_RWREGION_INCONSISTENCY_ID 20114
#define RTEERR_SYNC_VISEXCL_INVALID_REGION             SAPDBErr_MessageList::Error,20115,"task %s called visexcl() for invalid region %s",2
#define RTEERR_SYNC_VISEXCL_INVALID_REGION_ID 20115
#define RTEERR_SYNC_RWREGION_INDEFINITE_LOOP           SAPDBErr_MessageList::Error,20116,"indefinite loops on region %s",1
#define RTEERR_SYNC_RWREGION_INDEFINITE_LOOP_ID 20116
#define RTEERR_SYNC_RWREGION_TASKID_MISMATCH           SAPDBErr_MessageList::Error,20117,"given taskId (%s) is not id of current task (%s) in RWRegion::%s",3
#define RTEERR_SYNC_RWREGION_TASKID_MISMATCH_ID 20117
#define RTEERR_CREATE_THREAD                           SAPDBErr_MessageList::Error,20118,"Failed to create thread '%s':(%s)%s",3
#define RTEERR_CREATE_THREAD_ID 20118
#define RTEERR_RESUME_THREAD                           SAPDBErr_MessageList::Error,20119,"Failed to resume thread '%s':(%s)%s",3
#define RTEERR_RESUME_THREAD_ID 20119
#define RTEERR_COMMAND_PIPE_OPEN                       SAPDBErr_MessageList::Error,20120,"Opening command pipe for '%s' failed [%s]",2
#define RTEERR_COMMAND_PIPE_OPEN_ID 20120
#define RTEERR_COMMAND_PIPE_CLOSE                      SAPDBErr_MessageList::Error,20121,"Closing command pipe for '%s' failed [%s]",2
#define RTEERR_COMMAND_PIPE_CLOSE_ID 20121
#define RTEERR_OPEN_OUTPUT_PIPE                        SAPDBErr_MessageList::Error,20122,"Open output pipe '%s' failed [%s]",2
#define RTEERR_OPEN_OUTPUT_PIPE_ID 20122
#define RTEERR_OUTPUT_PIPE_READ                        SAPDBErr_MessageList::Error,20123,"Read output pipe failed [%s]",1
#define RTEERR_OUTPUT_PIPE_READ_ID 20123
#define RTEERR_UNEXPECTED_REPLY                        SAPDBErr_MessageList::Error,20124,"Command '%s' got unexpected reply '%s'",2
#define RTEERR_UNEXPECTED_REPLY_ID 20124
#define RTEERR_AUTOMATIC_RESTART_FAILED                SAPDBErr_MessageList::Error,20125,"Database automatic restart failed",0
#define RTEERR_AUTOMATIC_RESTART_FAILED_ID 20125
#define RTEERR_AUTOMATIC_SHUTDOWN_FAILED               SAPDBErr_MessageList::Error,20126,"Database automatic shutdown failed",0
#define RTEERR_AUTOMATIC_SHUTDOWN_FAILED_ID 20126
#define RTEERR_DEPENDEND_PROGRAMPATH_NOT_FOUND         SAPDBErr_MessageList::Error,20127,"Installation dependend program path not found ([%s]%s[%s]%s)",4
#define RTEERR_DEPENDEND_PROGRAMPATH_NOT_FOUND_ID 20127
#define RTEERR_CREATING_THREAD                         SAPDBErr_MessageList::Error,20128,"Creating thread '%s' failed [%s]:%s",3
#define RTEERR_CREATING_THREAD_ID 20128
#define RTEERR_RESUMING_THREAD                         SAPDBErr_MessageList::Error,20129,"Resuming thread '%s' failed [%s]:%s",3
#define RTEERR_RESUMING_THREAD_ID 20129
#define RTEERR_USER_UNKNOWN                            SAPDBErr_MessageList::Error,20130,"UNIX user '%s' unknown",1
#define RTEERR_USER_UNKNOWN_ID 20130
#define RTEERR_USERNAME_TOO_LONG                       SAPDBErr_MessageList::Error,20131,"UNIX user name [%s] -> '%s' too long",2
#define RTEERR_USERNAME_TOO_LONG_ID 20131
#define RTEERR_USERID_UNKNOWN                          SAPDBErr_MessageList::Error,20132,"UNIX user id [%s] unknown",1
#define RTEERR_USERID_UNKNOWN_ID 20132
#define RTEERR_GROUP_UNKNOWN                           SAPDBErr_MessageList::Error,20133,"UNIX group '%s' unknown",1
#define RTEERR_GROUP_UNKNOWN_ID 20133
#define RTEERR_GROUPNAME_TOO_LONG                      SAPDBErr_MessageList::Error,20134,"UNIX group name [%s] -> '%s' too long",2
#define RTEERR_GROUPNAME_TOO_LONG_ID 20134
#define RTEERR_GROUPID_UNKNOWN                         SAPDBErr_MessageList::Error,20135,"UNIX group id [%s] unknown",1
#define RTEERR_GROUPID_UNKNOWN_ID 20135
#define RTEERR_SETGID_FAILED                           SAPDBErr_MessageList::Error,20136,"UNIX group id setting with setgid(%s) call failed: %s",2
#define RTEERR_SETGID_FAILED_ID 20136
#define RTEERR_SETUID_FAILED                           SAPDBErr_MessageList::Error,20137,"UNIX user id setting with setuid(%s) call failed: %s",2
#define RTEERR_SETUID_FAILED_ID 20137
#define RTEERR_REGISTRY_KEY_NOT_FOUND                  SAPDBErr_MessageList::Error,20138,"UNIX installation registry key %s not found: %s",2
#define RTEERR_REGISTRY_KEY_NOT_FOUND_ID 20138
#define RTEERR_OWNERNAME_MISMATCH                      SAPDBErr_MessageList::Error,20139,"UNIX owner name mismatch: %s != %s",2
#define RTEERR_OWNERNAME_MISMATCH_ID 20139
#define RTEERR_PATH_TOO_LONG                           SAPDBErr_MessageList::Error,20140,"UNIX path too long: %s",1
#define RTEERR_PATH_TOO_LONG_ID 20140
#define RTEERR_DATABASE_NOT_FOUND                      SAPDBErr_MessageList::Error,20141,"UNIX database '%s' not found: %s",2
#define RTEERR_DATABASE_NOT_FOUND_ID 20141
#define RTEERR_CHOWN_FAILED                            SAPDBErr_MessageList::Error,20142,"UNIX change owner with chown(%s,%s,%s) failed: %s",4
#define RTEERR_CHOWN_FAILED_ID 20142
#define RTEERR_STAT_FAILED                             SAPDBErr_MessageList::Error,20143,"UNIX getting file status with stat(%s) failed: %s",2
#define RTEERR_STAT_FAILED_ID 20143
#define RTEERR_FSTAT_FAILED                            SAPDBErr_MessageList::Error,20144,"UNIX getting file status with fstat(%s) failed: %s",2
#define RTEERR_FSTAT_FAILED_ID 20144
#define RTEERR_PASSWORD_MISMATCH                       SAPDBErr_MessageList::Error,20145,"UNIX password mismatch",0
#define RTEERR_PASSWORD_MISMATCH_ID 20145
#define RTEERR_USER_NOT_MEMBER_IN_GROUP                SAPDBErr_MessageList::Error,20146,"UNIX user %s not member in group %s",2
#define RTEERR_USER_NOT_MEMBER_IN_GROUP_ID 20146
#define RTEERR_CHMOD_FAILED                            SAPDBErr_MessageList::Error,20147,"UNIX change mode with chmod(%s,%s) failed: %s",3
#define RTEERR_CHMOD_FAILED_ID 20147
#define RTEERR_SECURITY_INIT_ATTRIBUTES                SAPDBErr_MessageList::Error,20148,"Initialization of security attributes failed",0
#define RTEERR_SECURITY_INIT_ATTRIBUTES_ID 20148
#define RTEERR_SECURITY_SET_SYNCHRONIZE_ACCESS         SAPDBErr_MessageList::Error,20149,"Setting synchronized access failed, rc = %s",1
#define RTEERR_SECURITY_SET_SYNCHRONIZE_ACCESS_ID 20149
#define RTEERR_SECURITY_INIT_DESCRIPTOR                SAPDBErr_MessageList::Error,20150,"Initialization of security descriptor for %s failed, rc = %s",2
#define RTEERR_SECURITY_INIT_DESCRIPTOR_ID 20150
#define RTEERR_TAG_GET_FILENAME                        SAPDBErr_MessageList::Error,20151,"Get IPC file name for %s resource %s failed, database: %s, id: %s",4
#define RTEERR_TAG_GET_FILENAME_ID 20151
#define RTEERR_TAG_UNLINK_FILE                         SAPDBErr_MessageList::Error,20152,"Unlink IPC file %s failed, rc: %s",2
#define RTEERR_TAG_UNLINK_FILE_ID 20152
#define RTEERR_TAG_UNKNOWN_USER_TYPE                   SAPDBErr_MessageList::Error,20153,"Unknown user type: %s",1
#define RTEERR_TAG_UNKNOWN_USER_TYPE_ID 20153
#define RTEERR_TAG_UNKNOWN_RESOURCE_TYPE               SAPDBErr_MessageList::Error,20154,"Unknown resource type: %s",1
#define RTEERR_TAG_UNKNOWN_RESOURCE_TYPE_ID 20154
#define RTEERR_TAG_CHECK_IPC_DIRECTORY                 SAPDBErr_MessageList::Error,20155,"Check IPC directory failed",0
#define RTEERR_TAG_CHECK_IPC_DIRECTORY_ID 20155
#define RTEERR_TAG_MISSING_DIRECTOY                    SAPDBErr_MessageList::Error,20156,"Directory %s is missing, rc: %s",2
#define RTEERR_TAG_MISSING_DIRECTOY_ID 20156
#define RTEERR_TAG_MAKE_DIRECTORY                      SAPDBErr_MessageList::Error,20157,"Make directory %s failed, rc: %s",2
#define RTEERR_TAG_MAKE_DIRECTORY_ID 20157
#define RTEERR_TAG_GET_COMMON_DATA_PATH                SAPDBErr_MessageList::Error,20158,"Get common data path failed: %s",1
#define RTEERR_TAG_GET_COMMON_DATA_PATH_ID 20158
#define RTEERR_TAG_GET_IPC_DIRECTORY                   SAPDBErr_MessageList::Error,20159,"Get IPC directory failed",0
#define RTEERR_TAG_GET_IPC_DIRECTORY_ID 20159
#define RTEERR_CANNOT_GET_PROCESS_GROUP_LIST           SAPDBErr_MessageList::Error,20160,"UNIX get process group list with getgroups(%s) failed:%s",2
#define RTEERR_CANNOT_GET_PROCESS_GROUP_LIST_ID 20160
#define RTEERR_ILLEGAL_VOLUME_TYPE                     SAPDBErr_MessageList::Error,20161,"Illegal volume type (%s) given",1
#define RTEERR_ILLEGAL_VOLUME_TYPE_ID 20161
#define RTEERR_EXPANDED_PATH_TOO_LONG                  SAPDBErr_MessageList::Error,20162,"Expanded path would be too long: %s(%s)",2
#define RTEERR_EXPANDED_PATH_TOO_LONG_ID 20162
#define RTEERR_MEDIUM_LIMIT_REACHED                    SAPDBErr_MessageList::Error,20163,"Medium limit reached (MAXBACKUPDEVS)",0
#define RTEERR_MEDIUM_LIMIT_REACHED_ID 20163
#define RTEERR_MEDIUM_NOT_FOUND                        SAPDBErr_MessageList::Error,20164,"Medium %s not found",1
#define RTEERR_MEDIUM_NOT_FOUND_ID 20164
#define RTEERR_DUPLICATE_MEDIUM_FOUND                  SAPDBErr_MessageList::Error,20165,"Medium %s already in use",1
#define RTEERR_DUPLICATE_MEDIUM_FOUND_ID 20165
#define RTEERR_VOLUME_NOT_CONFIGURED                   SAPDBErr_MessageList::Error,20166,"Volume not configured",0
#define RTEERR_VOLUME_NOT_CONFIGURED_ID 20166
#define RTEERR_MEDIUM_NOT_CONFIGURED                   SAPDBErr_MessageList::Error,20167,"Medium invalid",0
#define RTEERR_MEDIUM_NOT_CONFIGURED_ID 20167
#define RTEERR_CLUSTER_DB_ONLINE                       SAPDBErr_MessageList::Error,20168,"MSCS failed to bring database resource online:[%s]%s",2
#define RTEERR_CLUSTER_DB_ONLINE_ID 20168
#define RTEERR_CLUSTER_DB_OFFLINE                      SAPDBErr_MessageList::Error,20169,"MSCS failed to take database resource offline:[%s]%s",2
#define RTEERR_CLUSTER_DB_OFFLINE_ID 20169
#define RTEERR_SYS_LOADQUERY                           SAPDBErr_MessageList::Error,20170,"> %s",1
#define RTEERR_SYS_LOADQUERY_ID 20170
#define RTEERR_OUT_OF_RTE_MEMORY                       SAPDBErr_MessageList::Error,20171,"Out of runtime memory",0
#define RTEERR_OUT_OF_RTE_MEMORY_ID 20171
#define RTEERR_WRNG_CONTAINER_PAGE_TYPE                SAPDBErr_MessageList::Error,20172,"Wrong profile container page type: %s, expected: %s",2
#define RTEERR_WRNG_CONTAINER_PAGE_TYPE_ID 20172
#define RTEERR_WRNG_CONTAINER_VERSION                  SAPDBErr_MessageList::Error,20173,"Wrong profile container version: %s, max: %s",2
#define RTEERR_WRNG_CONTAINER_VERSION_ID 20173
#define RTEERR_SURPRISING_CURR_PAGE                    SAPDBErr_MessageList::Error,20174,"Surprising 'current page no': %s, expected: %s",2
#define RTEERR_SURPRISING_CURR_PAGE_ID 20174
#define RTEERR_SURPRISING_NEXT_PAGE                    SAPDBErr_MessageList::Error,20175,"Surprising 'next page no': %s",1
#define RTEERR_SURPRISING_NEXT_PAGE_ID 20175
#define RTEERR_SURPRISING_PROF_DATA_LEN                SAPDBErr_MessageList::Error,20176,"Surprising profile data length: %s, expected: %s",2
#define RTEERR_SURPRISING_PROF_DATA_LEN_ID 20176
#define RTEERR_INSUFFICIENT_BUFFER_SPACE               SAPDBErr_MessageList::Error,20177,"Insufficient buffer space",0
#define RTEERR_INSUFFICIENT_BUFFER_SPACE_ID 20177
#define RTEERR_PROFILE_NOT_FOUND                       SAPDBErr_MessageList::Error,20178,"Profile for %s not found",1
#define RTEERR_PROFILE_NOT_FOUND_ID 20178
#define RTEERR_INVALID_PROFILE_TOKEN                   SAPDBErr_MessageList::Error,20179,"Invalid profile token: %s",1
#define RTEERR_INVALID_PROFILE_TOKEN_ID 20179
#define RTEERR_OPEN_PROFILE_CONTAINER                  SAPDBErr_MessageList::Error,20180,"Could not open profile container: %s, rc = %s",2
#define RTEERR_OPEN_PROFILE_CONTAINER_ID 20180
#define RTEERR_DELETE_PROFILE_CONTAINER                SAPDBErr_MessageList::Error,20181,"Could not delete profile container: %s, rc = %s",2
#define RTEERR_DELETE_PROFILE_CONTAINER_ID 20181
#define RTEERR_GET_PROFILE_CONTAINER_OWNER             SAPDBErr_MessageList::Error,20182,"Could not get profile container owner for %s",1
#define RTEERR_GET_PROFILE_CONTAINER_OWNER_ID 20182
#define RTEERR_GET_PROFILE_CONTAINER_GROUP             SAPDBErr_MessageList::Error,20183,"Could not get profile container group for %s",1
#define RTEERR_GET_PROFILE_CONTAINER_GROUP_ID 20183
#define RTEERR_SET_PROFILE_CONTAINER_GROUP             SAPDBErr_MessageList::Error,20184,"Could not set profile container group for %s",1
#define RTEERR_SET_PROFILE_CONTAINER_GROUP_ID 20184
#define RTEERR_CANT_SEEK_ON_PROFILE_CONTAINER          SAPDBErr_MessageList::Error,20185,"Could not seek on profile container '%s', rc = %s",2
#define RTEERR_CANT_SEEK_ON_PROFILE_CONTAINER_ID 20185
#define RTEERR_CANT_READ_FROM_PROFILE_CONTAINER        SAPDBErr_MessageList::Error,20186,"Could not read from profile container '%s', rc = %s",2
#define RTEERR_CANT_READ_FROM_PROFILE_CONTAINER_ID 20186
#define RTEERR_CANT_WRITE_TO_PROFILE_CONTAINER         SAPDBErr_MessageList::Error,20187,"Could not write to profile container '%s', rc = %s",2
#define RTEERR_CANT_WRITE_TO_PROFILE_CONTAINER_ID 20187
#define RTEERR_NOT_ALL_BYTES_READ_FROM_PROF_CONTAINER  SAPDBErr_MessageList::Error,20188,"Could not read from '%s', bytes read: %s, bytes wanted: %s",3
#define RTEERR_NOT_ALL_BYTES_READ_FROM_PROF_CONTAINER_ID 20188
#define RTEERR_NOT_ALL_BYTES_WRITTEN_TO_PROF_CONTAINER SAPDBErr_MessageList::Error,20189,"Could not write to '%s', bytes written: %s, bytes wanted: %s",3
#define RTEERR_NOT_ALL_BYTES_WRITTEN_TO_PROF_CONTAINER_ID 20189
#define RTEWARN_UNEXPECTED_TIMER_LEAPS                 SAPDBErr_MessageList::Warning,20190,"Unexpected %s timer leaps, timer type ignored",1
#define RTEWARN_UNEXPECTED_TIMER_LEAPS_ID 20190
#define RTEWARN_IO_GET_DEV_ID                          SAPDBErr_MessageList::Warning,20191,"Physical device for %s could not be determined: %s [%s]",3
#define RTEWARN_IO_GET_DEV_ID_ID 20191
#define RTEWARN_CONF_ENDMARKER_NOT_FOUND               SAPDBErr_MessageList::Warning,20192,"End marker in xparam file not found. Contents may be corrupt!",0
#define RTEWARN_CONF_ENDMARKER_NOT_FOUND_ID 20192
#define RTEWARN_CONF_UNKNOWN_VOLUME_ACCESS_MODE        SAPDBErr_MessageList::Warning,20193,"Unknown volume access mode %s [data volume %s]",2
#define RTEWARN_CONF_UNKNOWN_VOLUME_ACCESS_MODE_ID 20193
#define RTEWARN_GENERAL                                SAPDBErr_MessageList::Warning,20194,"RTE warning %s",1
#define RTEWARN_GENERAL_ID 20194
#define RTEWARN_PHYSICAL_MEMORY_EXCEEDED               SAPDBErr_MessageList::Warning,20195,"Used memory exceeds physical memory installed (%s MByte)",1
#define RTEWARN_PHYSICAL_MEMORY_EXCEEDED_ID 20195
#define RTEWARN_VERY_LITTLE_PHYSICAL_MEMORY_LEFT       SAPDBErr_MessageList::Warning,20196,"Very little physical memory left (%s MByte)",1
#define RTEWARN_VERY_LITTLE_PHYSICAL_MEMORY_LEFT_ID 20196
#define RTEWARN_CONF_UNKNOWN_FILE_SYSTEM_ACCESS_TYPE   SAPDBErr_MessageList::Warning,20197,"Unknown volume type %s [volume type='%s' volume index %s]",3
#define RTEWARN_CONF_UNKNOWN_FILE_SYSTEM_ACCESS_TYPE_ID 20197
#define RTEWARN_PROF_CONTAINER_MODIFIED                SAPDBErr_MessageList::Warning,20198,"Profile container modified during repeated scan activities",0
#define RTEWARN_PROF_CONTAINER_MODIFIED_ID 20198
#define RTEINFO_ANY_ERROR_TEXT                         SAPDBErr_MessageList::Info,20199,"Error: %s",1
#define RTEINFO_ANY_ERROR_TEXT_ID 20199
#define RTEINFO_TIMER_LEAP_DETECTED                    SAPDBErr_MessageList::Info,20200,"%s timer leap detected (val: %s, expected: 'val' >= %s)",3
#define RTEINFO_TIMER_LEAP_DETECTED_ID 20200
#define RTEINFO_START_FORMATTING                       SAPDBErr_MessageList::Info,20201,"Formatting started",0
#define RTEINFO_START_FORMATTING_ID 20201
#define RTEINFO_FORMATTING_DONE                        SAPDBErr_MessageList::Info,20202,"Formatting done",0
#define RTEINFO_FORMATTING_DONE_ID 20202
#define RTEINFO_SYS_CALL_DLL_FUNC                      SAPDBErr_MessageList::Info,20203,"Error by calling DLL function: %s",1
#define RTEINFO_SYS_CALL_DLL_FUNC_ID 20203
#define RTEINFO_INCONSISTENCIES_WHILE_WRITING          SAPDBErr_MessageList::Info,20204,"The following inconsistencies occurred while writing the parameter file %s",1
#define RTEINFO_INCONSISTENCIES_WHILE_WRITING_ID 20204
#define RTEINFO_CONF_NO_MORE_PARAMETERS                SAPDBErr_MessageList::Info,20205,"No more parameters found",0
#define RTEINFO_CONF_NO_MORE_PARAMETERS_ID 20205
#define RTEINFO_CONF_DATA_VOLUME_MODE                  SAPDBErr_MessageList::Info,20206,"Using mode %s for data volume %s",2
#define RTEINFO_CONF_DATA_VOLUME_MODE_ID 20206
#define RTEINFO_DBREG_SERVICE_ALREADY_INST             SAPDBErr_MessageList::Info,20207,"Service '%s' is already installed",1
#define RTEINFO_DBREG_SERVICE_ALREADY_INST_ID 20207
#define RTEINFO_DBREG_SERVICE_NOT_INSTALLED            SAPDBErr_MessageList::Info,20208,"Service '%s' is not installed",1
#define RTEINFO_DBREG_SERVICE_NOT_INSTALLED_ID 20208
#define RTEINFO_DBREG_SERVICE_DELETE_MARKED            SAPDBErr_MessageList::Info,20209,"Service has been marked for delete",0
#define RTEINFO_DBREG_SERVICE_DELETE_MARKED_ID 20209
#define RTEINFO_DBREG_UPDATING_SERVICE                 SAPDBErr_MessageList::Info,20210,"One or more values are different, updating service: '%s'",1
#define RTEINFO_DBREG_UPDATING_SERVICE_ID 20210
#define RTEINFO_DBREG_SERVICE_NOT_INST_CORR            SAPDBErr_MessageList::Info,20211,"Service has not been installed correctly",0
#define RTEINFO_DBREG_SERVICE_NOT_INST_CORR_ID 20211
#define RTEINFO_DBREG_KERNEL_STARTUP_MESSAGE           SAPDBErr_MessageList::Info,20212,"startup message from kernel:%s",1
#define RTEINFO_DBREG_KERNEL_STARTUP_MESSAGE_ID 20212
#define RTEINFO_KERNEL_THREAD_STARTED                  SAPDBErr_MessageList::Info,20213,"%s thread started",1
#define RTEINFO_KERNEL_THREAD_STARTED_ID 20213
#define RTEINFO_KERNEL_THREAD_STOPPED                  SAPDBErr_MessageList::Info,20214,"%s thread stopped",1
#define RTEINFO_KERNEL_THREAD_STOPPED_ID 20214
#define RTEINFO_GENERAL                                SAPDBErr_MessageList::Info,20215,"RTE info %s",1
#define RTEINFO_GENERAL_ID 20215
#define RTEINFO_KERNEL_STATE_CHANGED                   SAPDBErr_MessageList::Info,20216,"Kernel state changed from %s to %s",2
#define RTEINFO_KERNEL_STATE_CHANGED_ID 20216
#define RTEINFO_PHYSICAL_MEMORY_USED                   SAPDBErr_MessageList::Info,20217,"Used physical memory %s MByte",1
#define RTEINFO_PHYSICAL_MEMORY_USED_ID 20217
#define RTEINFO_CONF_MEMORY_ALLOCATION_LIMIT           SAPDBErr_MessageList::Info,20218,"Memory allocation limited to %s KByte",1
#define RTEINFO_CONF_MEMORY_ALLOCATION_LIMIT_ID 20218
#define RTEINFO_CONF_MEMORY_ALLOCATION_UNLIMITED       SAPDBErr_MessageList::Info,20219,"Memory allocation not limited",0
#define RTEINFO_CONF_MEMORY_ALLOCATION_UNLIMITED_ID 20219
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_ENABLED         SAPDBErr_MessageList::Info,20220,"System page cache usage enabled",0
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_ENABLED_ID 20220
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_DISABLED        SAPDBErr_MessageList::Info,20221,"System page cache usage disabled",0
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_DISABLED_ID 20221
#define RTEINFO_SYNC_RWREGION_TW_SLEEPING              SAPDBErr_MessageList::Info,20222,"tas_coll - TW is sleeping for 1 sec ...",0
#define RTEINFO_SYNC_RWREGION_TW_SLEEPING_ID 20222
#define RTEINFO_AUTOMATIC_RESTART_INITIATED            SAPDBErr_MessageList::Info,20223,"Database tries automatic restart",0
#define RTEINFO_AUTOMATIC_RESTART_INITIATED_ID 20223
#define RTEINFO_AUTOMATIC_RESTART_DONE                 SAPDBErr_MessageList::Info,20224,"Database automatic restart reported ok",0
#define RTEINFO_AUTOMATIC_RESTART_DONE_ID 20224
#define RTEINFO_AUTOMATIC_SHUTDOWN_INITIATED           SAPDBErr_MessageList::Info,20225,"Database tries automatic shutdown",0
#define RTEINFO_AUTOMATIC_SHUTDOWN_INITIATED_ID 20225
#define RTEINFO_AUTOMATIC_SHUTDOWN_DONE                SAPDBErr_MessageList::Info,20226,"Database automatic shutdown reported ok",0
#define RTEINFO_AUTOMATIC_SHUTDOWN_DONE_ID 20226
#define RTEINFO_ARGUMENT_UNEXPECTED                    SAPDBErr_MessageList::Info,20227,"Argument '%s' unexpected",1
#define RTEINFO_ARGUMENT_UNEXPECTED_ID 20227
#define RTEINFO_ARGUMENT_MISSING                       SAPDBErr_MessageList::Info,20228,"Argument '%s' missing",1
#define RTEINFO_ARGUMENT_MISSING_ID 20228
#define RTEINFO_ARGUMENT_UNKNOWN                       SAPDBErr_MessageList::Info,20229,"Argument '%s' unknown",1
#define RTEINFO_ARGUMENT_UNKNOWN_ID 20229
#define RTEINFO_ARGUMENT_COLLISION                     SAPDBErr_MessageList::Info,20230,"Argument '%s' collides with '%s'",2
#define RTEINFO_ARGUMENT_COLLISION_ID 20230
#define RTEINFO_STOP_SUCCESSFUL                        SAPDBErr_MessageList::Info,20231,"'%s' stopped successfully",1
#define RTEINFO_STOP_SUCCESSFUL_ID 20231
#define RTEINFO_PROCESSSTATE                           SAPDBErr_MessageList::Info,20232,"process state: %s is %s",2
#define RTEINFO_PROCESSSTATE_ID 20232
#define RTEINFO_BEGIN_OF_STARTUP_ARGUMENTS             SAPDBErr_MessageList::Info,20233,"Dump of all kernel parameters start",0
#define RTEINFO_BEGIN_OF_STARTUP_ARGUMENTS_ID 20233
#define RTEINFO_STARTUP_ARGUMENT                       SAPDBErr_MessageList::Info,20234," %s=%s",2
#define RTEINFO_STARTUP_ARGUMENT_ID 20234
#define RTEINFO_END_OF_STARTUP_ARGUMENTS               SAPDBErr_MessageList::Info,20235,"Dump of all kernel parameters done",0
#define RTEINFO_END_OF_STARTUP_ARGUMENTS_ID 20235

#endif /* RTE_MESSAGES_HPP */
