/*!***************************************************************************

  module      : RTEDiag_ClientCrashHist.h

  -------------------------------------------------------------------------

  responsible : StefanP

  special area: Diagnostic files
  description : Saving of diagnostic files at restart if the database
                was shutting down abnormally the last time.
                Functions for the client site.

  last changed: 2001-02-07  14:36
  see also    : http://pwww/Doku/rel-7.4/SAPDB/RunTime/Diagnose/CrashHistory.doc

  -------------------------------------------------------------------------

  copyright:    Copyright (c) 2001-2005 SAP AG

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/



#ifndef RTEDIAG_CLIENTCRASHHIST_H
#define RTEDIAG_CLIENTCRASHHIST_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/
/*!
  Chapter: RTE Diagnostic (Client)
 */

/*!
  Function:     RTEDiag_DropAllCrashHist
  description:  Deletes all history directories of the named database and tries to delete
                the main directory 'crashHistoryPath' itself. The function will fail if 
                the 'DiagHistoryPath' contains files or directories which were not automatically 
                generated by the database at restart after an abnormal database shutdown..
                
  arguments:
    dbname              [in] Name of the database
    crashHistoryPath    [in] Path of the crash history (XParam: DIAG_HISTORY_PATH) 

  return value: true:   Deleting of crashHistoryPath succeeded
                false:  Deleting of crashHistoryPath failed
 */
externC	SAPDB_Bool	RTEDiag_DropAllCrashHist       (RTE_DBName    dbname,
                                                    RTE_Path      crashHistoryPath);

/*!
  EndChapter: RTE Diagnostic (Client)
 */
#endif  /* RTEDIAG_CLIENTCRASHHIST_H */
