/*!
    \file    DBMSrvMsg_Info.hpp
    \author  MarcW
    \brief   message info class

    \if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

    \endif
*/

#include "Messages/Msg_List.hpp"
#include "DBM/Srv/Message/DBMSrvMsg_Base.hpp"

#if !defined(DBMSRVMSG_INFO_HPP)
#define DBMSRVMSG_INFO_HPP

/*!
    @brief information message
*/
class DBMSrvMsg_Info : public Msg_List, public DBMSrvMsg_Base {
public:

    /*! @brief default constructor
    
        use this constructor to create an empty info list */
    DBMSrvMsg_Info();

    /*!
        @brief constructor

        Takes a string that is handeled as a format string (like printf), the number of
        arguments used and up to 10 string arguments.
        @param aText [IN] format string
        @param arg0 [IN] string argument 0
        @param arg1 [IN] string argument 1
        @param arg2 [IN] string argument 2
        @param arg3 [IN] string argument 3
        @param arg4 [IN] string argument 4
        @param arg5 [IN] string argument 5
        @param arg6 [IN] string argument 6
        @param arg7 [IN] string argument 7
        @param arg8 [IN] string argument 8
        @param arg9 [IN] string argument 9
    */
    DBMSrvMsg_Info(
        const char* aText,
        const char* const arg0 = NULL,
        const char* const arg1 = NULL,
        const char* const arg2 = NULL,
        const char* const arg3 = NULL,
        const char* const arg4 = NULL,
        const char* const arg5 = NULL,
        const char* const arg6 = NULL,
        const char* const arg7 = NULL,
        const char* const arg8 = NULL,
        const char* const arg9 = NULL);

    /*! \brief constructor

        Takes the arguments of the SDB-Define and 1 mandatory and up to 7 optional tag-
        arguments. For messages of component DBMSrv the message ID is
        changed to a classical DBM-Server error number. A supplied Msg_List is
        added as sub message of the newly created info message.
        
        \param subMessage [IN] message to be used as sub message
        \param aID       [IN] ID of the error message (generated by buildmsg)
        \param component [IN] component reporting the error (generated by buildmsg)
        \param file      [IN] file reporting the error (generated by buildmsg + preprocessor)
        \param line      [IN] line reporting the error (generated by buildmsg + preprocessor)
        \param aText     [IN] message text (generated by buildmsg)
        \param argCheck  [IN] parameter used for aargument check (generated by buildmsg)
        \param messageVersion [IN] version of the message (generated by buildmsg)
        \param arg0      [IN] mandatory tag 0
        \param arg1      [IN] optional tag 1
        \param arg2      [IN] optional tag 2
        \param arg3      [IN] optional tag 3
        \param arg4      [IN] optional tag 4
        \param arg5      [IN] optional tag 5
        \param arg6      [IN] optional tag 6
        \param arg7      [IN] optional tag 7
        \param arg8      [IN] optional tag 8 */
    DBMSrvMsg_Info(
        const Msg_List    & subMessage,
        int                 aID,
        const char        * component,
        const char        * file,
        int                 line,
        const char        * aText,
        Msg_Has2Args      * argCheck,
        const Msg_IArg    * messageVersion,
        Msg_IArg const    * arg0,
        Msg_IOptArg const * arg1=0,
        Msg_IOptArg const * arg2=0,
        Msg_IOptArg const * arg3=0,
        Msg_IOptArg const * arg4=0,
        Msg_IOptArg const * arg5=0,
        Msg_IOptArg const * arg6=0,
        Msg_IOptArg const * arg7=0,
        Msg_IOptArg const * arg8=0);

    /*! \brief constructor

        Takes the arguments of the SDB-Define and 2 mandatory and up to 6 optional tag-
        arguments. For messages of component DBMSrv the message ID is
        changed to a classical DBM-Server error number. A supplied Msg_List is
        added as sub message of the newly created info message.
        
        \param subMessage [IN] message to be used as sub message
        \param aID       [IN] ID of the error message (generated by buildmsg)
        \param component [IN] component reporting the error (generated by buildmsg)
        \param file      [IN] file reporting the error (generated by buildmsg + preprocessor)
        \param line      [IN] line reporting the error (generated by buildmsg + preprocessor)
        \param aText     [IN] message text (generated by buildmsg)
        \param argCheck  [IN] parameter used for aargument check (generated by buildmsg)
        \param messageVersion [IN] version of the message (generated by buildmsg)
        \param arg0      [IN] mandatory tag 0
        \param arg1      [IN] mandatory tag 1
        \param arg2      [IN] optional tag 2
        \param arg3      [IN] optional tag 3
        \param arg4      [IN] optional tag 4
        \param arg5      [IN] optional tag 5
        \param arg6      [IN] optional tag 6
        \param arg7      [IN] optional tag 7
        \param arg8      [IN] optional tag 8 */
    DBMSrvMsg_Info(
        const Msg_List    & subMessage,
        int                 aID,
        const char        * component,
        const char        * file,
        int                 line,
        const char        * aText,
        Msg_Has3Args      * argCheck,
        const Msg_IArg    * messageVersion,
        Msg_IArg const    * arg0,
        Msg_IArg const    * arg1,
        Msg_IOptArg const * arg2 = 0,
        Msg_IOptArg const * arg3 = 0,
        Msg_IOptArg const * arg4 = 0,
        Msg_IOptArg const * arg5 = 0,
        Msg_IOptArg const * arg6 = 0,
        Msg_IOptArg const * arg7 = 0,
        Msg_IOptArg const * arg8 = 0);

    /*! @brief copy constructor */
    DBMSrvMsg_Info( DBMSrvMsg_Info const &aInfo )
         : Msg_List(aInfo) {}

    /*! @brief empty destructor */
    virtual ~DBMSrvMsg_Info() {}

    /*! \brief specialised Overrule to prevent type mixing */
    void Overrule(const DBMSrvMsg_Info & info);

private:
    /*! \brief operator for easy addition of errors
 
        As Msg_List changed the behaviour of its operator+ more than once
        before Overrule() was invented, the operator+ is declared private and
        not implemented. */
    Msg_List operator+ (const Msg_List& otherList) const;

    /*! \brief private Overrule to prevent type mixing
    
        This function is declared private and not implemented to ensure, that
        the first message of an DBMSrvMsg_Info object contains an info */
    void Overrule(Msg_List & error);
};

#endif //DBMSrvMsg_Info_hpp
