/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver.test;

import com.sap.dbtech.udeserver.ProcServer;
import com.sap.dbtech.udeserver.test.TestConnection;

public abstract class UdeAllInOne {
    protected TestConnection sqlConnection;
    protected int socketPort = 9876;
    protected Thread serverThread;
    protected String procClass = "TESTSQLJ";

    public UdeAllInOne(TestConnection testConnection) {
        this.sqlConnection = testConnection;
    }

    protected void run(String string, String string2, String string3, Object[] objectArray) {
        this.runAll(string, string2, string3, new Object[][]{objectArray});
    }

    protected void runAll(String string, String string2, String string3, Object[][] objectArray) {
        this.startServer();
        this.register();
        this.createProc(string, string2, string3);
        this.callProc(string, objectArray);
        this.stopServer();
    }

    public void startServer() {
        ProcServer procServer = new ProcServer();
        this.serverThread = procServer.runAsServerInThread(this.socketPort);
    }

    public void register() {
        System.out.println("\n===== register UDE server =================");
        this.sqlConnection.sql("CALL SYSUDE.DEFINE_DEBUGSERVER ('" + this.procClass + "', " + this.socketPort + ", 'local server to test db procedures')", "SELECT * FROM SYSUDE.SERVER_CONFIG");
    }

    public void createProc(String string, String string2, String string3) {
        System.out.println("\n===== create DBPROC =======================");
        this.sqlConnection.safeSQL("DROP DBPROC " + string, -4016);
        if (string2.trim().length() > 0) {
            string2 = "(" + string2 + ")";
        }
        this.sqlConnection.sql("CREATE DBPROC " + string + string2 + " AS LANGUAGE " + this.procClass + " NAME '" + string3 + "'", "select * from dbprocedures where dbprocname = '" + string + "'");
    }

    public void callProc(String string, Object[][] objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        System.out.println("\n===== call DBProc =========================");
        int n = objectArray[0] == null ? 0 : objectArray[0].length;
        String string2 = "?";
        String string3 = "CALL " + string;
        if (n > 0) {
            string3 = string3 + " (";
            for (int i = 0; i < n; ++i) {
                string3 = string3 + string2;
                string2 = ",?";
            }
            string3 = string3 + ")";
        }
        this.sqlConnection.sqlX(string3, objectArray);
    }

    public void stopServer() {
        this.sqlConnection.commit();
        this.sqlConnection.close();
        this.serverThread.stop();
    }
}

