/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.udeserver.ClassLoaderError;
import com.sap.dbtech.udeserver.Command;
import com.sap.dbtech.udeserver.Log;
import com.sap.dbtech.udeserver.MethodFromString;
import com.sap.dbtech.udeserver.ProcServerSession;
import com.sap.dbtech.udeserver.SocketComm;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class ProcServer
implements Runnable {
    private boolean isRunning;
    private Dictionary commandTable;
    private Vector runningThreads;
    private int socketPort;

    public ProcServer() {
        this.installCommands();
    }

    protected void installCommands() {
        this.commandTable = new Hashtable();
        Command command = new Command(){

            public String run(String[] stringArray) {
                return "";
            }
        };
        this.commandTable.put("ping", command);
        Command command2 = new Command(){

            public String run(String[] stringArray) {
                ProcServer.this.isRunning = false;
                return "";
            }
        };
        this.commandTable.put("stop", command2);
        Command command3 = new Command(){

            public String run(String[] stringArray) throws ProcServerSession.Exception {
                Log.log("main thread: newsession.run");
                new ProcServerSession(stringArray[1]).start();
                Log.log("main thread: continued newsession.run");
                return "";
            }
        };
        this.commandTable.put("newsession", command3);
    }

    void runAsClient(int n) throws RTEException, IOException {
        SocketComm socketComm = new SocketComm(n, 8192);
        this.run(socketComm);
    }

    protected void runAsServer(int n) throws RTEException, IOException {
        this.socketPort = n;
        ServerSocket serverSocket = new ServerSocket(n);
        Log.log("waiting for connection ...");
        Socket socket = serverSocket.accept();
        Log.log("accepted connection");
        SocketComm socketComm = new SocketComm(socket, 8192);
        this.run(socketComm);
    }

    protected void run(SocketComm socketComm) throws RTEException, IOException {
        this.isRunning = true;
        while (this.isRunning) {
            String string = socketComm.recvString();
            String[] stringArray = this.parseCommand(string);
            Log.log("cmd: " + string);
            Command command = (Command)this.commandTable.get(stringArray[0]);
            if (command == null) {
                Log.logErr("command " + stringArray[0] + " not defined");
                socketComm.sendString("ERR unknown command");
                continue;
            }
            try {
                String string2 = command.run(stringArray);
                Log.log(" ==> '" + string2 + "'");
                socketComm.sendString("OK  " + string2);
            }
            catch (Throwable throwable) {
                Log.traceException(throwable);
                socketComm.sendString("ERR Exception " + throwable.toString());
            }
        }
    }

    public Thread runAsServerInThread(int n) {
        this.socketPort = n;
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    public void run() {
        try {
            this.runAsServer(this.socketPort);
        }
        catch (RTEException rTEException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String[] parseCommand(String string) {
        String string2;
        Vector<String> vector = new Vector<String>(10);
        int n = string.length();
        char[] cArray = string.toCharArray();
        char c = '\u0000';
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        char[] cArray2 = new char[cArray.length];
        block8: for (int i = 0; i < n; ++i) {
            char c2 = cArray[i];
            if (Character.isWhitespace(c2)) {
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (bl) {
                            cArray2[n3] = c2;
                            ++n3;
                            break;
                        }
                        string2 = String.copyValueOf(cArray2, 0, n3);
                        vector.addElement(string2);
                        n3 = 0;
                    }
                }
                continue;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    if (bl) {
                        if (c == c2) {
                            bl = false;
                            continue block8;
                        }
                        cArray2[n3] = c2;
                        ++n3;
                        continue block8;
                    }
                    bl = true;
                    c = c2;
                    n2 = 1;
                    continue block8;
                }
                case '\\': {
                    cArray2[n3] = c2 = cArray[++i];
                    ++n3;
                    n2 = 1;
                    continue block8;
                }
                default: {
                    cArray2[n3] = c2;
                    ++n3;
                    n2 = 1;
                }
            }
        }
        if (n2 == 1) {
            string2 = String.copyValueOf(cArray2, 0, n3);
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected static void searchForMethod(String[] stringArray, int n) {
        MethodFromString methodFromString = new MethodFromString(stringArray[n]);
        try {
            Method method = methodFromString.findMethod();
            System.out.println(method);
        }
        catch (ClassLoaderError classLoaderError) {
            System.out.println(classLoaderError);
            Method[] methodArray = methodFromString.findCandidates();
            if (methodArray.length == 0) {
                methodArray = methodFromString.allMethods();
            }
            System.out.println("Candidates are:");
            for (int i = 0; i < methodArray.length; ++i) {
                System.out.println(methodArray[i]);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.out.println("need argument to connect to MaxDB kernel");
            System.exit(0);
        }
        Log.open();
        try {
            Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
            if (stringArray[0].equals("-T")) {
                ProcServer.searchForMethod(stringArray, 1);
            } else if (stringArray[0].equals("-S")) {
                int n = Integer.parseInt(stringArray[1]);
                Log.log("waiting on port " + n);
                new ProcServer().runAsServer(n);
            } else {
                int n = Integer.parseInt(stringArray[0]);
                Log.log("connecting to port " + n);
                new ProcServer().runAsClient(n);
            }
        }
        catch (Throwable throwable) {
            Log.traceException(throwable);
        }
        System.exit(0);
    }
}

