/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBClassLoader
extends ClassLoader {
    private Connection session;
    private PreparedStatement cachedSelect;

    public DBClassLoader(Connection connection) {
        this.session = connection;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray;
        try {
            PreparedStatement preparedStatement = this.getSelect();
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                throw new ClassNotFoundException(string);
            }
            Blob blob = resultSet.getBlob(1);
            byArray = blob.getBytes(0L, (int)blob.length());
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new ClassNotFoundException(string, sQLException);
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        return clazz;
    }

    protected PreparedStatement getSelect() throws SQLException {
        if (this.cachedSelect == null) {
            this.cachedSelect = this.session.prepareStatement("select code from JavaClasses where classname = ?");
        }
        return this.cachedSelect;
    }

    public static void main(String[] stringArray) throws SQLException, ClassNotFoundException {
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        Connection connection = DriverManager.getConnection("jdbc:sapdb:DB76", "DANIEL", "DANIEL");
        connection.createStatement().execute("drop table JavaClasses");
        DBClassLoader dBClassLoader = new DBClassLoader(connection);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                System.out.println("trying " + stringArray[i]);
                Class<?> clazz = dBClassLoader.loadClass(stringArray[i]);
                System.out.println(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Throwable throwable = classNotFoundException.getCause();
                if (throwable != null) {
                    throwable.printStackTrace();
                    continue;
                }
                System.out.println(classNotFoundException);
            }
        }
    }
}

