/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.AbstractSimpleGetval;
import com.sap.dbtech.util.MessageTranslator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class GetvalCharByte
extends AbstractSimpleGetval
implements Blob {
    byte[] data;

    public GetvalCharByte(byte[] byArray) {
        this.data = byArray;
    }

    public long length() throws SQLException {
        return this.data.length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if ((long)n + l - 1L > (long)this.data.length) {
            throw new SQLException(MessageTranslator.translate("error.invalid.blob.position", String.valueOf(l)));
        }
        byte[] byArray = new byte[n];
        try {
            System.arraycopy(this.data, (int)l - 1, byArray, 0, n);
        }
        catch (Exception exception) {
            throw new SQLException(MessageTranslator.translate("error.invalid.blob.position", String.valueOf(l)));
        }
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }
}

