 /*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.util.StructuredMem;

/**
 * Information sent back in abap_ostream or abap_istream parts of
 * DB procedures.
 */
public class StreamInfo
{
    private boolean       input;
    private int           tabid;
    private short         rowcount;
    private byte[]        mask;
    private StructuredMem data;
    
    public StreamInfo(boolean input, int tabid, short rowcount)
    {
        this.input = input;
        this.tabid = tabid;
        this.rowcount = rowcount;
    }
    
    boolean isInput()
    {
        return input;
    }
    
    
    public int getTabId() 
    {
        return tabid;
    }
    
    public short getRowCount() 
    {
    	return rowcount;
    }
}
