#
# =====================================================
# @(#) 
# =====================================================
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2002-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

from tutoriallib import *


def install (session,options):

    switchToDefaultUser (session, options)
    
    #stopIfSqlNotErr(session, -7048, 'DROP   USER MONA')
    stopIfSqlNotErr (session, -6006, 'CREATE USER MONA PASSWORD RED DBA NOT EXCLUSIVE')  
    
    loaderCmd(session, 'USE USER MONA RED')
    loaderCmd(session, 'SET FORMAT ISO')

    dropTable (session,"city")
    dropTable (session,"customer")
    dropTable (session,"hotel")
    dropTable (session,"room")
    dropTable (session,"reservation")
    dropTable (session,"employee")
    dropView  (session,"customer_addr")
    dropView  (session,"hotel_addr")
    dropView  (session,"custom_hotel")

    stopIfSqlNotErr (session, -6006, "CREATE SCHEMA HOTEL")
    switchToSchema(session, 'HOTEL')

    dropTable (session,"city")
    dropTable (session,"customer")
    dropTable (session,"hotel")
    dropTable (session,"room")
    dropTable (session,"reservation")
    dropTable (session,"employee")
    dropView  (session,"customer_addr")
    dropView  (session,"hotel_addr")
    dropView  (session,"custom_hotel")
    
    stopIfSqlNotOK(session, """CREATE TABLE city ( 
                      zip    CHAR(5)   PRIMARY KEY CONSTRAINT zip_cons CHECK 
                                       SUBSTR(zip,1,1) BETWEEN '0' AND '9' AND
                                       SUBSTR(zip,2,1) BETWEEN '0' AND '9' AND
                                       SUBSTR(zip,3,1) BETWEEN '0' AND '9' AND
                                       SUBSTR(zip,4,1) BETWEEN '0' AND '9' AND
                                       SUBSTR(zip,5,1) BETWEEN '0' AND '9',
                      name   CHAR(30)  NOT NULL,
                      state  CHAR(2)   NOT NULL)""")
    stopIfSqlNotOK(session, "CREATE INDEX city_state ON city (state)")

    stopIfSqlNotOK(session, 
                   """CREATE TABLE customer (
                      cno        FIXED(4)   PRIMARY KEY CONSTRAINT cno_cons CHECK cno > 0,
                      title      CHAR(7)    CONSTRAINT title_cons CHECK title IN ('Mr', 'Mrs', 'Company'),
                      firstname  CHAR(20),
                      name       CHAR(40)   NOT NULL,
                      zip        CHAR(5)    CONSTRAINT zip_cons CHECK 
                                            SUBSTR(zip,1,1) BETWEEN '0' AND '9' AND
                                            SUBSTR(zip,2,1) BETWEEN '0' AND '9' AND
                                            SUBSTR(zip,3,1) BETWEEN '0' AND '9' AND
                                            SUBSTR(zip,4,1) BETWEEN '0' AND '9' AND
                                            SUBSTR(zip,5,1) BETWEEN '0' AND '9',
                      address    CHAR (40)  NOT NULL,
                      FOREIGN KEY customer_zip_in_city (zip) REFERENCES city ON DELETE RESTRICT)""")
    stopIfSqlNotOK(session, "CREATE INDEX full_name_index ON customer (name,firstname)")

    stopIfSqlNotOK(session,
                   """CREATE TABLE hotel (
                      hno      FIXED(4)    PRIMARY KEY CONSTRAINT hno_cons CHECK hno > 0,
                      name     CHAR(50)    NOT NULL,
                      zip      CHAR(5)     CONSTRAINT zip_cons CHECK
                                           SUBSTR(zip,1,1) BETWEEN '0' AND '9' AND
                                           SUBSTR(zip,2,1) BETWEEN '0' AND '9' AND
                                           SUBSTR(zip,3,1) BETWEEN '0' AND '9' AND
                                           SUBSTR(zip,4,1) BETWEEN '0' AND '9' AND
                                           SUBSTR(zip,5,1) BETWEEN '0' AND '9',
                      address  CHAR(40)    NOT NULL,
                      info     LONG,
                      FOREIGN KEY hotel_zip_in_city (zip) REFERENCES city ON DELETE RESTRICT)""")

    stopIfSqlNotOK(session,
                   """CREATE TABLE room (
                      hno     FIXED(4)    CONSTRAINT hno_cons CHECK hno > 0,
                      type    CHAR(6)     CONSTRAINT type_cons CHECK type IN ('single','double','suite'), PRIMARY KEY (hno, type),
                      free    FIXED(3,0)  CONSTRAINT free_cons CHECK free >= 0,
                      price   FIXED(6,2)  CONSTRAINT price_cons CHECK price BETWEEN 0.00 AND 5000.00,
                      FOREIGN KEY room_hno_in_hotel (hno) REFERENCES hotel ON DELETE CASCADE)""")

    stopIfSqlNotOK(session,
                   """CREATE TABLE reservation (
                      rno         FIXED(4)   PRIMARY KEY CONSTRAINT rno_cons CHECK rno > 0,
                      cno         FIXED(4)   CONSTRAINT cno_cons CHECK cno > 0,
                      hno         FIXED(4)   CONSTRAINT hno_cons CHECK hno > 0,
                      type        CHAR(6)    CONSTRAINT type_cons CHECK type IN ('single','double','suite'),
                      arrival     DATE       NOT NULL,
                      departure   DATE       NOT NULL,
                      CONSTRAINT  staying CHECK departure > arrival,
                      FOREIGN KEY reservation_cno_in_customer (cno)      REFERENCES customer ON DELETE CASCADE,
                      FOREIGN KEY reservation_info_in_room    (hno,type) REFERENCES room     ON DELETE CASCADE)""")

    stopIfSqlNotOK(session,
                  """CREATE TABLE employee (
                     hno           FIXED(4)    KEY,     
                     eno           FIXED(4)    KEY,
                     title         CHAR(7)     CONSTRAINT title_cons CHECK title IN ('Mr', 'Mrs'),
                     firstname     CHAR(20),
                     name          CHAR(20)    NOT NULL,
                     manager_eno   FIXED(4),
                     FOREIGN KEY employee_in_hotel (hno) REFERENCES hotel ON DELETE CASCADE)""")
    #
    #  Create views
    #
    stopIfSqlNotOK(session,
                   """CREATE VIEW customer_addr (cno, title, name, zip, city, state, address)
                      AS SELECT customer.cno, customer.title, customer.name, customer.zip,
                                city.name, city.state, customer.address
                         FROM   customer, city
                         WHERE  customer.zip = city.zip
                         WITH CHECK OPTION""")

    stopIfSqlNotOK(session,
                   """CREATE VIEW hotel_addr (hno, name, zip, city, state, address)
                      AS SELECT hotel.hno, hotel.name, hotel.zip, city.name, city.state, hotel.address
                         FROM   hotel, city
                         WHERE  hotel.zip = city.zip
                         WITH CHECK OPTION""")

    stopIfSqlNotOK(session,
                   """CREATE VIEW custom_hotel (customname, customcity, hotelname, hotelcity)
                      AS SELECT   customer_addr.name, customer_addr.city, hotel_addr.name, hotel_addr.city
                         FROM  customer_addr, hotel_addr, reservation
                         WHERE customer_addr.cno = reservation.cno AND hotel_addr.hno = reservation.hno""")

    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12203','Albany' ,'NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60601','Chicago','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60615','Chicago','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45211','Cincinnati','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('33575','Clearwater','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75243','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('32018','Daytona Beach','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('33441','Deerfield Beach','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48226','Detroit','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90029','Hollywood','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92714','Irvine','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90804','Long Beach','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11788','Long Island','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90018','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70112','New Orleans','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10580','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10019','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92262','Palm Springs','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97213','Portland','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60018','Rosemont','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95054','Santa Clara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20903','Silver Spring','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20037','Seattle','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20005','Seattle','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20019','Seattle','WA')")
    
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3000,'Mrs','Jenny','Porter','10580','1340 N. Ash Street, #3')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3100,'Mr','Peter','Brown','48226','1001 34th St., APT.3')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3200,'Company',NULL,'Datasoft','90018','486 Maple St.')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3300,'Mrs','Rose','Brian','75243','500 Yellowstone Drive, #2')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3400,'Mrs','Mary','Griffith', '20005','3401 Elder Lane')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3500,'Mr','Martin','Randolph','60615','340 MAIN STREET, #7')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3600,'Mrs','Sally','Smith','75243','250 Curtis Street')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3700,'Mr','Mike','Jackson','45211','133 BROADWAY APT. 1')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3800,'Mrs','Rita','Doe','97213','2000 Humboldt St., #6')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (3900,'Mr','George','Howe','75243','111 B Parkway, #23')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (4000,'Mr','Frank','Miller','95054','27 5th St., 76')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (4100,'Mrs','Susan','Baker','90018','200 MAIN STREET, #94')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (4200,'Mr','Joseph','Peters','92714','700 S. Ash St., APT.12')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (4300,'Company',NULL,'TOOLware','20019','410 Mariposa St., #10')")
    stopIfSqlNotOK(session, "INSERT INTO customer VALUES (4400,'Mr','Antony','Jenkins','20903','55 A Parkway, #15')")
    
    stopIfSqlNotOK(session, """INSERT INTO hotel VALUES (10,'Congress','20005','155 Beechwood St.','Sports and Games
    - - - - - - - - - - - -

    solaria in separate relaxation rooms
    sauna, free of charge, individual booking if you 
    prefer to sweat alone
    a playroom for our small guests
    bicycles for our health-conscious guests
    storeroom for bicycles in the house
    various activities and events every night
    broad selection of board games available
    indoor swimming pool and fitness center


    Teaching and Learning
    - - - - - - - - - - - -

    Enjoy it. In an absolutely quiet place. The person in charge is available 
    during the whole meeting. Consistently high standards providing the ideal 
    working environment for you to have a successful meeting.
    Telefax and copy machines, even for transparencies.
    Daylit rooms creatively arranged.
    Aroma lamps with blends of fragrances to improve 
    concentration and learning capabilities.
    Music in the meeting rooms whenever you like.

    Are you curious?  We are waiting for you!
    ')""")
    stopIfSqlNotOK(session, """INSERT INTO hotel VALUES (30,'Regency','20037','477 17th Avenue','Our hotel is situated in the city centre in the direct vicinity of the shopping mall.
    Our rooms offer you the maximal facilities of a modern middleclass hotel.')""")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (20,'Long Island','11788','1499 Grove Street',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (70,'Empire State','12203','65 Yellowstone Dr.',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (80,'Midtown','10019','12 Barnard St.',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (40,'Eighth Avenue','10019','112 8th Avenue',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (50,'Lake Michigan','60601','354 OAK Terrace',NULL)")
    stopIfSqlNotOK(session, """INSERT INTO hotel VALUES (60,'Airport','60018','650 C Parkway','Welcome in the Airport Hotel.
    - - - - - - - - - - - - - - -
     
    The Airport Hotel is situated right in the city centre.
    Our hotel has spacious, comfortable rooms at attractive prices.
    All rooms are with bath/shower, toilet, radio, colour TV, 
    video, telephone, minibar and desk.')""")

    stopIfSqlNotOK(session, """INSERT INTO hotel VALUES (90,'Sunshine','33575','200 Yellowstone Dr.','The Sunshine is located in the centre of the city.
    489 rooms, suites and facilities for the disabled, with 
    superb furnishings and genuine elegance are only some of the
    features which make this hotel something special.
    Individual service ensures personal comfort for all our guests 24 hours a day -
    more than just mere luxury.

    11 function rooms accommodating up to 300 persons are 
    available for all types of events.

    For relaxation and recreation there are a swimming pool with
    whirlpool, a sauna, steam bath and solarium.
    500 parking spaces are available in the hotel garage.')""")

    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (100,'Beach','32018','1980 34th St.',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (110,'Atlantic','33441','111 78th St.',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (120,'Long Beach','90804','35 Broadway',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (150,'Indian Horse','92262','16 MAIN STREET',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (130,'Star','90029','13 Beechwood Place',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (140,'River Boat','70112','788 MAIN STREET',NULL)")
    
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (10,'single',20,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (10,'double',45,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (30,'single',12,45.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (30,'double',15,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (20,'single',10,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (20,'double',13,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (70,'single',4,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (70,'double',11,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (80,'single',15,90.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (80,'double',19,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (80,'suite',5,400.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (40,'single',20,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (40,'double',35,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (50,'single',50,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (50,'double',230,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (50,'suite',12,500.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (60,'single',10,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (60,'double',39,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (60,'suite',20,500.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (90,'single',45,90.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (90,'double',145,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (90,'suite',60,300.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (100,'single',11,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (100,'double',24,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (110,'single',2,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (110,'double',10,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (120,'single',34,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (120,'double',78,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (120,'suite',55,350.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (150,'single',44,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (150,'double',115,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (150,'suite',6,450.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (130,'single',89,160.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (130,'double',300,270.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (130,'suite',100,700.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (140,'single',10,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (140,'double',9,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (140,'suite',78,600.00)")
    
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (100,3000,80,'single','2004-11-13','2004-11-15')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (110,3000,100,'double','2004-12-24','2005-01-06')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (120,3200,50,'suite','2004-11-14','2004-11-18')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (130,3900,110,'single','2005-02-01','2005-02-03')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (150,3600,70,'double','2005-03-14','2005-03-24')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (140,4300,80,'double','2004-04-12','2004-04-30')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (160,4100,70,'single','2004-04-12','2004-04-15')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (170,4400,150,'suite','2004-09-01','2004-09-03')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (180,3100,120,'double','2004-12-23','2005-01-08')")
    stopIfSqlNotOK(session, "INSERT INTO reservation VALUES (190,4300,140,'double','2004-11-14','2004-11-17')")
    
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 1, 'Mrs','Martina','Bender',  NULL)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 2, 'Mr', 'Martin', 'Bender',  NULL)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 3, 'Mrs','Claudia','Randolph',1)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 4, 'Mr', 'Mark',   'Nober',   1)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 5, 'Mrs','Phyllis','Manger',  3)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 6, 'Mrs','Francis','Nick',    2)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 7, 'Mr', 'Peter',  'Carley',  2)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 8, 'Mr' ,'Ian',    'Wolf',    NULL)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 9, 'Mr', 'Bill',   'Tucker',  8)")
    stopIfSqlNotOK(session, "INSERT INTO employee VALUES (10, 10,'Mrs','Diana',  'Corner',  1)")

    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00618','Barranquitas','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00620','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00622','Boqueron','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00651','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00673','Luquillo','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00742','Quebradillas','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00752','San Antonio','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00753','San German','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00754','San Lorenzo','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00755','San Sebastian','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00757','Santa Isabel','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00765','Vieques','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00922','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00938','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00940','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00950','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('00975','San Juan','PR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01240','Lenox','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01242','Lenox Dale','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01537','North Oxford','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01538','North Uxbridge','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01540','Oxford','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01569','Uxbridge','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01808','Middlesex Essex Gmf','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01813','Middlesex Essex Gmf','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01885','West Boxford','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01889','Middlesex Essex Gmf','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01921','Boxford','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('01929','Essex','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02035','Foxboro','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02169','Quincy','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02171','North Quincy','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02173','Lexington','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02269','Quincy','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02332','Duxbury','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02338','Halifax','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02637','Cummaquid','MA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('02822','Exeter','RI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('03289','Winnisquam','NH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('03833','Exeter','NH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('03907','Ogunquit','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04093','West Buxton','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04224','Dixfield','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04227','East Dixfield','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04257','Mexico','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04270','Oxford','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04275','Roxbury','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04426','Dover-Foxcroft','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04435','Exeter','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04558','Pemaquid','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04570','Squirrel Island','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04764','Oxbow','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04769','Presque Isle','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04770','Quimby','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04930','Dexter','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04932','Dixmont','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('04964','Oquossoc','ME')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05059','Quechee','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05154','Saxtons River','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05358','West Halifax','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05451','Essex','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05453','Essex Junction','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05454','Fairfax','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('05669','Roxbury','VT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('06064','Poquonock','CT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('06262','Quinebaug','CT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('06375','Quaker Hill','CT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('06426','Essex','CT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('06781','Pequabuck','CT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('06783','Roxbury','CT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07021','Essex Fells','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07088','Vauxhall','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07440','Pequannock','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07461','Sussex','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07465','Wanaque','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07624','Closter','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07863','Oxford','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('07879','Tranquility','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('08072','Quinton','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('08736','Manasquan','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('08846','Middlesex','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('08868','Quakertown','NJ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10096','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10099','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10124','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10126','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10132','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10138','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10178','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10185','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10197','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10199','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10203','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10213','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10242','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10249','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10261','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10282','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10286','New York','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10400','Bronx','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10475','Bronx','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10514','Chappaqua','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('10987','Tuxedo Park','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11010','Franklin Square','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11758','Massapequa','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11762','Massapequa Park','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11931','Aquebogue','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11942','East Quogue','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('11959','Quogue','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12008','Rexford','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12042','Climax','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12051','Coxsackie','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12087','Hannacroix','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12107','Knox','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12141','Quaker Street','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12148','Rexford','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12192','Coxsackie','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12452','Lexington','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12474','Roxbury','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12570','Poughquag','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('12936','Essex','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13036','Central Square','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13114','Mexico','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13135','Phoenix','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13158','Truxton','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13308','Blossvale','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13362','Knoxboro','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13436','Raquette Lake','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13456','Sauquoit','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13487','West Exeter','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13607','Alexandria Bay','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13634','Dexter','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13673','Philadelphia','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13826','Ouaquaga','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('13830','Oxford','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('14005','Alexander','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('14507','Middlesex','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('14722','Chautauqua','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('14877','Rexville','NY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15001','Aliquippa','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15090','Wexford','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15110','Duquesne','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15376','West Alexander','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15555','Quecreek','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15632','Export','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15662','Luxor','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15670','New Alexandria','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15730','Punxsutawney','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15734','Dixonville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15740','Punxsutawney','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15763','Punxsutawney','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15767','Punxsutawney','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15776','Punxsutawney','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15847','Knox Dale','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15870','Wilcox','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('15952','Salix','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16027','Connoquenessing','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16036','Foxburg','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16056','Saxonburg','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16159','West Middlesex','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16216','Climax','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16232','Knox','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16611','Alexandria','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16670','Queen','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16678','Saxton','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16679','Six Mile Run','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16745','Rixford','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16912','Blossburg','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16918','Cowanesque','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('16928','Knoxville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17032','Halifax','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17056','Mexico','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17085','Rexmont','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17247','Quincy','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17251','Roxbury','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17350','New Oxford','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17561','Quarryville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17565','Pequea','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17566','Quarryville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17825','Excelsior','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17860','Paxinos','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17861','Paxtonville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17882','Troxelville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17946','Lost Creek','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('17959','New Philadelphia','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18012','Aquashicola','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18032','Catasauqua','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18046','East Texas','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18087','Trexlertown','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18240','Nesquehoning','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18245','Quakake','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18252','Tamaqua','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18417','Equinunk','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18435','Lackawaxen','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18441','Lenoxville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18636','Noxen','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18847','Susquehanna','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18854','Wysox','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18932','Line Lexington','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18935','Milford Square','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18951','Quakertown','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('18979','Woxall','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19026','Drexel Hill','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19073','Newtown Square','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19093','Philadelphia','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19341','Exton','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19348','Kennett Square','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19353','Exton','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19363','Oxford','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19452','Miquon','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19453','Phoenixville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19460','Phoenixville','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('19538','Maxatawny','PA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20608','Aquasco','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20653','Lexington Park','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('20670','Patuxent River','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21131','Phoenix','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21654','Oxford','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21657','Queen Anne','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21658','Queenstown','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21758','Knoxville','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21820','Dames Quarter','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('21856','Quantico','MD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22021','Fairfax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22033','Fairfax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22035','Fairfax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22039','Fairfax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22125','Occoquan','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22135','Quantico','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22314','Alexandria','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22320','Alexandria','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22334','Alexandria','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22336','Alexandria','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22737','Rixeyville','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22847','Quicksburg','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('22965','Quinque','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23089','Lanexa','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23106','Manquin','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23122','Naxera','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23141','Quinton','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23308','Bloxom','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23350','Exmore','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23413','Nassawadox','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23423','Quinby','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23427','Saxis','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23884','Sussex','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23920','Brodnax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23959','Phenix','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('23967','Saxe','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24054','Axton','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24174','Thaxton','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24249','Exeter','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24333','Galax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24360','Max Meadows','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24450','Lexington','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24522','Appomattox','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24558','Halifax','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24628','Maxie','VA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24884','Squire','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('24957','Maxwelton','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('25059','Dixie','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('25180','Saxon','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('25904','Pax','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('25910','Quinnimont','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('25981','Quinwood','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('26342','Coxs Mills','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('26385','Lost Creek','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('26566','Colfax','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('26619','Exchange','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('26810','Lost City','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('26811','Lost River','WV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27233','Climax','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27235','Colfax','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27294','Lexington','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27340','Saxapahaw','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27502','Apex','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27526','Fuquay-Varina','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27557','Middlesex','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27565','Oxford','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27573','Roxboro','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27839','Halifax','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27869','Rich Square','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27872','Roxobel','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27885','Swanquarter','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('27920','Buxton','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28006','Alexis','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28072','Granite Quarry','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28173','Waxhaw','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28364','Maxton','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28378','Rex','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28521','Chinquapin','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28619','Drexel','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28701','Alexander','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28703','Aquone','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28747','Lake Toxaway','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('28784','Tuxedo','NC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('29072','Lexington','SC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('29377','Startex','SC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('29666','Ninety Six','SC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('29682','Six Mile','SC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('29827','Fairfax','SC')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('30212','Experiment','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('30267','Oxford','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('30273','Rex','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('30417','Claxton','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('30648','Lexington','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31019','Dexter','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31050','Knoxville','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31513','Baxley','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31519','Broxton','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31624','Axson','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31629','Dixie','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31637','Lenox','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31643','Quitman','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31734','Climax','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31737','Colquitt','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('31801','Box Springs','GA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('32088','San Mateo','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('32352','Quincy','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('32410','Mexico Beach','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('32459','Santa Rosa Beach','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('32684','Oxford','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('33470','Loxahatchee','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('33576','San Antonio','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('33925','Chokoloskee','FL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('35010','Alexander City','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('35059','Dixiana','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('35130','Quinton','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('35469','Knoxville','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('35648','Lexington','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36026','Equality','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36250','Alexandria','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36439','Excel','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36454','Lenox','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36458','Mexia','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36505','Axis','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36543','Huxford','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36551','Loxley','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36736','Dixons Mills','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36868','Phenix City','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('36921','Toxey','AL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37012','Alexandria','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37025','Bon Aqua','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37057','Dixon Springs','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37343','Hixson','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37374','Sequatchie','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37902','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37909','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37912','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37924','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37933','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37940','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37950','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37990','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('37998','Knoxville','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38047','Lenox','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38351','Lexington','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38482','Santa Fe','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38544','Baxter','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38579','Quebeck','TN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38655','Oxford','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('38871','Thaxton','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39044','Braxton','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39095','Lexington','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39346','Noxapater','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39355','Quitman','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39361','Shuqualak','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39483','Foxworth','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39535','Biloxi','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39638','Gloster','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('39661','Roxie','MS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40013','Coxs Creek','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40049','Nerinx','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40103','Axtel','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40121','Fort Knox','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40153','Mc Quady','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40413','Climax','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40432','Foxtown','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40516','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40524','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40526','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40533','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40536','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40544','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40546','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40555','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40596','Lexington','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40806','Baxter','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40927','Closplint','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('40983','Sextons Creek','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41001','Alexandria','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41127','Camp Dix','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41166','Quincy','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41331','Haddix','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41348','Lost Creek','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41363','Quicksand','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41447','Lenox','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41510','Aflex','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41602','Auxier','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41764','Smilax','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41847','Redfox','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('41848','Roxana','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('42036','Dexter','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('42268','Quality','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('42409','Dixon','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('42787','Wax','KY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('43001','Alexandria','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('43343','Quincy','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('43761','Moxahala','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('43764','New Lexington','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('43773','Quaker City','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('44650','Maximo','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45056','Oxford','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45356','Piqua','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45381','West Alexandria','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45385','Xenia','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45650','Lynx','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45727','Dexter City','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('45871','New Knoxville','OH')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('46001','Alexandria','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('46035','Colfax','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('46154','Maxwell','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('46374','San Pierre','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('46534','Knox','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('46958','Mexico','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47138','Lexington','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47354','Losantville','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47456','Quincy','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47576','Saint Croix','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47579','Santa Claus','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47865','Paxton','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('47971','Oxford','IN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48051','Oxford','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48096','Wixom','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48130','Dexter','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48413','Bad Axe','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48450','Lexington','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48732','Essexville','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('48886','Six Lakes','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49034','Climax','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49082','Quincy','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49641','Hoxeyville','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49711','Charlevoix','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49720','Charlevoix','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49775','Pointe Aux Pins','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49777','Presque Isle','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49854','Manistique','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49855','Marquette','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('49876','Quinnesec','MI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50028','Baxter','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50040','Boxholm','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50054','Colfax','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50070','Dexter','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50076','Exira','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50124','Huxley','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50138','Knoxville','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50161','Maxwell','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50420','Alexander','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50585','Sioux Rapids','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('50851','Lenox','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('51049','Quimby','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('51052','Salix','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('51111','Sioux City','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('51250','Sioux Center','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('51545','Little Sioux','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('51638','Essex','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52001','Dubuque','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52004','Dubuque','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52056','Luxemburg','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52060','Maquoketa','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52158','Marquette','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52228','Fairfax','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52254','Lost Nation','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52322','Oxford','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52323','Oxford Junction','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52326','Quasqueton','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52555','Exline','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52565','Keosauqua','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('52745','Dixon','IA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('53036','Ixonia','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('53089','Sussex','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('53584','Sextonville','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('53933','Fox Lake','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('53947','Marquette','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('53952','Oxford','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54024','Saint Croix Falls','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54217','Luxemburg','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54464','Phlox','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54548','Minocqua','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54557','Presque Isle','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54559','Saxon','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54635','Hixton','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54665','Viroqua','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54730','Colfax','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54835','Exeland','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('54976','Saxeville','WI')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('55331','Excelsior','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('55332','Fairfax','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('55720','Cloquet','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('55926','Dexter','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56053','Klossner','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56308','Alexandria','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56319','Carlos','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56472','Pequot Lakes','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56502','Detroit Lakes','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56523','Climax','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56543','Foxhome','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56659','Max','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56681','Squaw Lake','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('56758','Strandquist','MN')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57039','Lennox','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57049','North Sioux City','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57107','Sioux Falls','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57118','Sioux Falls','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57198','Sioux Falls','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57311','Alexandria','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57335','Fairfax','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57353','Iroquois','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57719','Box Elder','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('57775','Quinn','SD')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58018','Colfax','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58218','Buxton','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58343','Knox','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58371','San Haven','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58737','Flaxton','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58738','Foxholm','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58759','Max','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58760','Maxbass','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('58831','Alexander','ND')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59075','Saint Xavier','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59222','Flaxville','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59353','Wibaux','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59521','Box Elder','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59831','Dixon','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59853','Noxon','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('59930','Rexford','MT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60020','Fox Lake','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60021','Fox River Grove','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60102','Algonquin','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60147','Lafox','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60422','Flossmoor','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60451','New Lenox','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60463','Palos Heights','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60465','Palos Park','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60488','Flossmoor','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60935','Essex','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60945','Iroquois','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('60957','Paxton','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61021','Dixon','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61025','East Dubuque','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61334','Lostant','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61412','Alexis','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61448','Knoxville','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61454','Lomax','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61458','Maquon','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61469','Oquawka','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61728','Colfax','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('61753','Lexington','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62084','Roxana','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62087','South Roxana','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62301','Quincy','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62306','Quincy','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62332','Detroit','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62550','Moweaqua','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62601','Alexander','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62682','San Jose','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62830','Dix','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62832','Du Quoin','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62889','Texico','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62899','Xenia','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('62934','Equality','IL')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63373','Portage Des Sioux','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63377','Silex','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63381','Truxton','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63430','Alexandria','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63446','Knox City','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63561','Queen City','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63655','Marquand','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63841','Dexter','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63846','Essex','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63955','Oxly','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63960','Puxico','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('63961','Qulin','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('64024','Excelsior Springs','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('64067','Lexington','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('64446','Fairfax','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('64478','Quitman','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('64742','Drexel','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('64862','Sarcoxie','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65231','Auxvasse','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65247','Excello','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65265','Mexico','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65282','Santa Fe','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65324','Climax Springs','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65439','Bixby','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65459','Dixon','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65534','Laquey','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65541','Lenox','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65618','Brixey','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65647','Exeter','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65714','Nixa','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65735','Quincy','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('65755','Squires','MO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66086','Tonganoxie','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66403','Axtell','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66526','Paxico','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66528','Quenemo','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66713','Baxter Springs','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66761','Piqua','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('66859','Lost Springs','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67027','Climax','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67038','Dexter','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67119','Oxford','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67121','Penalosa','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67334','Chautauqua','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67464','Marquette','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67476','Roxbury','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67513','Alexander','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67740','Hoxie','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67752','Quinter','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('67753','Rexford','KS')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68303','Alexandria','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68351','Exeter','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68732','Dixon','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68776','South Sioux City','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68850','Lexington','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68854','Marquette','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68924','Axtell','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68967','Oxford','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('68982','Wilcox','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('69037','Max','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('69133','Dix','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('69151','Maxwell','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('69155','Paxton','NE')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70075','Meraux','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70302','Thibodaux','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70310','Thibodaux','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70517','Breaux Bridge','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70633','De Quincy','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('70765','Plaquemine','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71030','Gloster','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71239','Extension','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71268','Quitman','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71303','Alexandria','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71307','Alexandria','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71309','Alexandria','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71311','Alexandria','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71315','Alexandria','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71417','Colfax','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71479','Tullos','LA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('71832','De Queen','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72002','Alexander','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72011','Bauxite','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72051','Fox','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72131','Quitman','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72355','Lexa','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72358','Luxora','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72433','Hoxie','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72515','Bexar','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72565','Oxford','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72820','Alix','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('72845','Knoxville','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73002','Alex','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73051','Lexington','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73301','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73344','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73435','Fox','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73540','Faxon','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73668','Texola','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('73949','Texhoma','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74008','Bixby','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74363','Quapaw','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74465','Tahlequah','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74561','Quinton','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74637','Fairfax','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74741','Hendrix','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('74943','Lequire','OK')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75001','Addison','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75002','Allen','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75003','Anna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75004','Blue Ridge','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75005','Caddo Mills','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75008','Carrollton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75009','Celina','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75011','Carrollton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75016','Irving','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75018','Copeville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75019','Coppell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75021','Denison','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75026','Plano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75029','Lewisville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75031','Farmersville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75032','Fate','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75034','Frisco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75039','Irving','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75044','Garland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75048','Garland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75053','Grand Prairie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75057','Lewisville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75058','Gunter','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75059','Howe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75063','Irving','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75064','Josephine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75065','Lake Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75066','Lavon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75067','Lewisville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75068','Little Elm','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75070','Mc Kinney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75071','Melissa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75072','Merit','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75073','Nevada','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75075','Plano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75076','Pottsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75077','Princeton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75078','Prosper','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75085','Richardson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75086','Plano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75087','Rockwall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75088','Rowlett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75089','Royse City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75091','Sherman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75094','Plano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75095','Van Alstyne','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75096','Westminster','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75097','Weston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75098','Wylie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75101','Bardwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75102','Barry','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75103','Canton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75104','Cedar Hill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75105','Chatfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75110','Corsicana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75114','Crandall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75115','De Soto','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75116','Duncanville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75117','Edgewood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75118','Elmo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75120','Ennis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75124','Eustace','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75125','Ferris','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75126','Forney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75127','Fruitvale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75134','Lancaster','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75138','Duncanville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75140','Grand Saline','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75141','Hutchins','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75142','Kaufman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75143','Kemp','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75144','Kerens','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75146','Lancaster','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75147','Mabank','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75148','Malakoff','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75150','Mesquite','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75151','Corsicana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75152','Palmer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75153','Powell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75154','Red Oak','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75155','Rice','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75157','Rosser','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75158','Scurry','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75159','Seagoville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75160','Terrell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75163','Trinidad','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75165','Waxahachie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75169','Wills Point','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75172','Wilmer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75182','Mesquite','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75185','Mesquite','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75212','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75253','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75258','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75266','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75270','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75275','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75277','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75287','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75295','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75303','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75310','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75323','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75326','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75339','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75346','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75356','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75359','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75364','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75368','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75371','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75374','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75376','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75382','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75394','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75398','Dallas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75401','Greenville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75410','Alba','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75411','Arthur City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75412','Bagwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75413','Bailey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75414','Bells','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75415','Ben Franklin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75416','Blossom','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75417','Bogata','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75418','Bonham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75420','Brashear','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75421','Brookston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75422','Campbell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75423','Celeste','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75425','Chicota','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75426','Clarksville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75428','Commerce','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75431','Como','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75432','Cooper','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75433','Cumby','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75434','Cunningham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75435','Deport','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75436','Detroit','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75437','Dike','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75438','Dodd City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75439','Ector','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75440','Emory','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75441','Enloe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75443','Gober','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75444','Golden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75446','Honey Grove','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75447','Ivanhoe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75448','Klondike','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75449','Ladonia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75450','Lake Creek','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75451','Leesburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75452','Leonard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75453','Lone Oak','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75455','Mount Pleasant','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75457','Mount Vernon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75461','Paris','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75468','Pattonville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75469','Pecan Gap','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75470','Petty','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75471','Pickton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75472','Point','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75473','Powderly','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75474','Quinlan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75475','Randolph','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75476','Ravenna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75477','Roxton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75478','Saltillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75479','Savoy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75480','Scroggins','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75481','Sulphur Bluff','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75482','Sulphur Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75486','Sumner','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75487','Talco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75488','Telephone','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75489','Tom Bean','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75490','Trenton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75491','Whitewright','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75492','Windom','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75493','Winfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75494','Winnsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75496','Wolfe City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75497','Yantis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75501','Texarkana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75502','Texarkana','AR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75505','Texarkana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75507','Texarkana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75550','Annona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75551','Atlanta','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75554','Avery','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75555','Bivins','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75556','Bloomburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75557','Boston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75558','Cookville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75559','De Kalb','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75560','Douglassville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75561','Hooks','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75562','Kildare','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75563','Linden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75564','Lodi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75565','Mc Leod','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75566','Marietta','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75567','Maud','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75568','Naples','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75569','Nash','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75570','New Boston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75571','Omaha','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75572','Queen City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75573','Redwater','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75574','Simms','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75608','Longview','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75630','Avinger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75631','Beckville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75633','Carthage','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75636','Cason','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75637','Clayton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75638','Daingerfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75639','De Berry','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75640','Diana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75641','Easton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75642','Elysian Fields','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75643','Gary','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75644','Gilmer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75647','Gladewater','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75650','Hallsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75651','Harleton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75653','Henderson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75656','Hughes Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75657','Jefferson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75658','Joinerville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75659','Jonesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75660','Judson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75661','Karnack','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75663','Kilgore','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75666','Laird Hill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75667','Laneville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75668','Lone Star','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75669','Long Branch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75671','Marshall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75680','Minden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75681','Mount Enterprise','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75682','New London','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75683','Ore City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75684','Overton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75685','Panola','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75686','Pittsburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75687','Price','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75688','Scottsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75689','Selman City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75691','Tatum','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75692','Waskom','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75693','White Oak','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75694','Woodlawn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75713','Tyler','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75750','Arp','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75751','Athens','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75754','Ben Wheeler','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75755','Big Sandy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75756','Brownsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75757','Bullard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75758','Chandler','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75759','Cuney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75760','Cushing','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75762','Flint','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75763','Frankston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75764','Gallatin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75765','Hawkins','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75766','Jacksonville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75770','Larue','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75771','Lindale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75772','Maydelle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75773','Mineola','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75778','Murchison','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75779','Neches','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75780','New Summerfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75782','Poynor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75783','Quitman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75784','Reklaw','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75785','Rusk','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75788','Sacul','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75789','Troup','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75790','Van','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75791','Whitehouse','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75792','Winona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75802','Palestine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75831','Buffalo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75832','Cayuga','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75833','Centerville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75834','Centralia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75835','Crockett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75838','Donie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75839','Elkhart','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75840','Fairfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75844','Grapeland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75845','Groveton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75846','Jewett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75847','Kennard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75848','Kirvin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75849','Latexo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75850','Leona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75851','Lovelady','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75852','Midway','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75853','Montalba','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75855','Oakwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75856','Pennington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75858','Ratcliff','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75859','Streetman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75860','Teague','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75861','Tennessee Colony','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75862','Trinity','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75865','Woodlake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75903','Lufkin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75925','Alto','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75926','Apple Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75928','Bon Wier','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75929','Broaddus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75930','Bronson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75931','Brookeland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75932','Burkeville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75933','Call','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75934','Camden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75935','Center','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75936','Chester','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75937','Chireno','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75938','Colmesneil','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75939','Corrigan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75941','Diboll','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75942','Doucette','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75943','Douglass','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75944','Etoile','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75946','Garrison','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75947','Geneva','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75948','Hemphill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75949','Huntington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75951','Jasper','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75954','Joaquin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75956','Kirbyville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75957','Magnolia Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75958','Martinsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75959','Milam','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75960','Moscow','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75963','Nacogdoches','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75966','Newton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75968','Pineland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75969','Pollok','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75970','Rockland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75972','San Augustine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75973','Shelbyville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75974','Tenaha','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75975','Timpson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75976','Wells','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75977','Wiergate','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75978','Woden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75979','Woodville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('75980','Zavalla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76007','Arlington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76008','Aledo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76009','Alvarado','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76019','Arlington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76020','Azle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76022','Bedford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76023','Boyd','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76024','Breckenridge','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76026','Bridgeport','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76027','Bryson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76028','Burleson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76029','Caddo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76030','Chico','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76031','Cleburne','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76033','Cleburne','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76034','Colleyville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76035','Cresson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76036','Crowley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76037','Dennis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76038','Eliasville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76040','Euless','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76041','Forreston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76043','Glen Rose','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76044','Godley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76045','Graford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76046','Graham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76048','Granbury','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76050','Grandview','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76051','Grapevine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76052','Haslet','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76054','Hurst','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76055','Itasca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76056','Jacksboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76057','Jermyn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76058','Joshua','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76059','Keene','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76060','Kennedale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76061','Lillian','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76062','Loving','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76063','Mansfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76064','Maypearl','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76065','Midlothian','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76066','Millsap','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76067','Mineral Wells','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76070','Nemo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76071','Newark','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76072','Palo Pinto','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76073','Paradise','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76074','Peaster','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76075','Perrin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76076','Poolville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76077','Rainbow','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76078','Rhome','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76081','South Bend','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76082','Springtown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76083','Throckmorton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76084','Venus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76087','Weatherford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76090','Whitt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76091','Woodson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76092','Grapevine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76093','Rio Vista','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76094','Arlington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76095','Bedford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76119','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76124','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76127','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76137','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76140','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76148','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76150','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76155','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76163','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76181','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76185','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76199','Fort Worth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76206','Denton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76225','Alvord','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76226','Argyle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76227','Aubrey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76228','Bellevue','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76230','Bowie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76233','Collinsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76234','Decatur','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76238','Era','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76239','Forestburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76240','Gainesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76245','Gordonville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76246','Greenwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76247','Justin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76248','Keller','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76249','Krum','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76250','Lindsay','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76251','Montague','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76252','Muenster','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76253','Myra','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76254','Newport','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76255','Nocona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76258','Pilot Point','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76259','Ponder','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76261','Ringgold','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76262','Roanoke','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76263','Rosston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76264','Sadler','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76265','Saint Jo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76266','Sanger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76267','Slidell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76268','Southmayd','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76270','Sunset','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76271','Tioga','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76272','Valley View','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76273','Whitesboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76299','Roanoke','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76311','Wichita Falls','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76350','Antelope','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76351','Archer City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76352','Bluegrove','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76354','Burkburnett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76357','Byers','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76359','Elbert','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76360','Electra','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76363','Goree','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76364','Harrold','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76365','Henrietta','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76366','Holliday','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76367','Iowa Park','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76369','Kamay','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76370','Megargel','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76371','Munday','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76372','Newcastle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76373','Oklaunion','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76374','Olney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76377','Petrolia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76378','Red Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76379','Scotland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76380','Seymour','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76383','Vera','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76384','Vernon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76388','Weinert','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76389','Windthorst','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76402','Stephenville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76430','Albany','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76432','Blanket','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76433','Bluff Dale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76435','Carbon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76436','Carlton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76437','Cisco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76442','Comanche','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76443','Cross Plains','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76444','De Leon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76445','Desdemona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76446','Dublin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76447','Duffau','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76448','Eastland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76452','Energy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76453','Gordon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76454','Gorman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76455','Gustine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76456','Hasse','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76457','Hico','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76461','Lingleville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76462','Lipan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76463','Mingus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76464','Moran','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76465','Morgan Mill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76466','Olden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76467','Paluxy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76468','Proctor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76469','Putnam','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76470','Ranger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76471','Rising Star','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76472','Santo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76474','Sidney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76475','Strawn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76476','Tolar','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76505','Temple','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76508','Temple','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76511','Bartlett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76512','Bee House','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76513','Belton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76517','Ben Arnold','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76518','Buckholts','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76519','Burlington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76520','Cameron','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76522','Copperas Cove','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76523','Davilla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76524','Eddy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76525','Evant','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76526','Flat','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76527','Florence','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76528','Gatesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76530','Granger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76531','Hamilton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76533','Heidenheimer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76534','Holland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76537','Jarrell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76538','Jonesboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76539','Kempner','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76547','Killeen','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76550','Lampasas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76552','Leon Junction','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76554','Little River','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76555','Maysfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76556','Milano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76557','Moody','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76558','Mound','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76559','Nolanville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76561','Oglesby','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76564','Pendleton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76565','Pottsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76566','Purmela','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76567','Rockdale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76569','Rogers','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76570','Rosebud','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76571','Salado','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76573','Schwertner','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76574','Taylor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76576','Gatesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76577','Thorndale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76578','Thrall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76579','Troy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76580','Turnersville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76599','Gatesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76621','Abbott','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76622','Aquilla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76623','Avalon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76624','Axtell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76625','Birome','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76626','Blooming Grove','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76627','Blum','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76628','Brandon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76629','Bremond','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76630','Bruceville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76631','Bynum','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76632','Chilton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76633','China Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76634','Clifton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76635','Coolidge','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76636','Covington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76637','Cranfills Gap','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76638','Crawford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76639','Dawson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76640','Elm Mott','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76641','Frost','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76642','Groesbeck','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76643','Hewitt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76645','Hillsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76648','Hubbard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76649','Iredell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76650','Irene','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76651','Italy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76652','Kopperl','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76653','Kosse','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76654','Leroy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76655','Lorena','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76656','Lott','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76657','Mc Gregor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76660','Malone','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76661','Marlin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76664','Mart','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76665','Meridian','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76666','Mertens','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76667','Mexia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76670','Milford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76671','Morgan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76673','Mount Calm','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76675','Otto','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76676','Penelope','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76677','Perry','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76678','Prairie Hill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76679','Purdon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76680','Reagan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76681','Richland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76682','Riesel','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76684','Ross','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76685','Satin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76686','Tehuacana','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76687','Thornton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76689','Valley Mills','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76690','Walnut Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76691','West','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76692','Whitney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76693','Wortham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76708','Waco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76712','Waco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76714','Waco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76716','Waco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76799','Waco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76801','Brownwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76804','Brownwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76820','Art','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76821','Ballinger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76823','Bangs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76824','Bend','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76825','Brady','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76827','Brookesmith','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76828','Burkett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76831','Castell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76832','Cherokee','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76834','Coleman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76836','Doole','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76837','Eden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76839','Fife','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76841','Fort Mc Kavett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76842','Fredonia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76844','Goldthwaite','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76845','Gouldbusk','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76848','Hext','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76849','Junction','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76850','Katemcy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76851','Leaday','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76852','Lohn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76853','Lometa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76854','London','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76855','Lowake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76856','Mason','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76857','May','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76858','Melvin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76859','Menard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76861','Miles','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76862','Millersview','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76864','Mullin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76865','Norton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76866','Paint Rock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76867','Pear Valley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76869','Pontotoc','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76870','Priddy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76871','Richland Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76872','Rochelle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76873','Rockwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76874','Roosevelt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76875','Rowena','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76877','San Saba','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76878','Santa Anna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76880','Star','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76882','Talpa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76883','Telegraph','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76884','Valera','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76885','Valley Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76886','Veribest','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76887','Voca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76888','Voss','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76889','Whon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76890','Zephyr','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76906','San Angelo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76909','San Angelo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76930','Barnhart','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76931','Best','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76932','Big Lake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76933','Bronte','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76934','Carlsbad','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76935','Christoval','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76936','Eldorado','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76937','Eola','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76939','Knickerbocker','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76940','Mereta','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76941','Mertzon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76943','Ozona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76945','Robert Lee','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76949','Silver','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76950','Sonora','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76951','Sterling City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76953','Tennyson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76954','Texon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76955','Vancourt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76957','Wall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('76958','Water Valley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77099','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77213','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77231','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77238','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77245','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77263','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77275','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77277','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77282','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77284','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77293','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77299','Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77305','Conroe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77325','Humble','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77326','Ace','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77328','Cleveland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77331','Coldspring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77332','Dallardsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77333','Dobbin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77334','Dodge','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77335','Goodrich','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77336','Huffman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77337','Tomball','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77339','Humble','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77344','Huntsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77347','Humble','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77349','Huntsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77350','Leggett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77351','Livingston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77355','Magnolia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77356','Montgomery','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77357','New Caney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77358','New Waverly','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77359','Oakhurst','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77360','Onalaska','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77362','Pinehurst','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77363','Plantersville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77364','Pointblank','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77365','Porter','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77367','Riverside','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77368','Romayor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77369','Rye','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77371','Shepherd','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77372','Splendora','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77373','Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77374','Thicket','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77375','Tomball','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77376','Votaw','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77378','Willis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77383','Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77385','Conroe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77389','Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77391','Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77396','Humble','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77402','Bellaire','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77404','Bay City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77411','Alief','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77412','Altair','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77413','Barker','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77414','Bay City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77415','Cedar Lane','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77417','Beasley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77418','Bellville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77419','Blessing','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77420','Boling','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77422','Brazoria','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77423','Brookshire','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77426','Chappell Hill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77428','Collegeport','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77429','Cypress','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77430','Damon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77431','Danciger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77432','Danevang','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77433','Cypress','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77434','Eagle Lake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77435','East Bernard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77436','Egypt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77437','El Campo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77440','Elmaton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77441','Fulshear','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77442','Garwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77443','Glen Flora','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77444','Guy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77445','Hempstead','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77446','Prairie View','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77447','Hockley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77448','Hungerford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77450','Katy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77451','Kendleton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77452','Kenney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77453','Lane City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77454','Lissie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77455','Louise','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77456','Markham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77457','Matagorda','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77458','Midfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77459','Missouri City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77460','Nada','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77461','Needville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77462','Newgulf','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77463','Old Ocean','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77464','Orchard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77465','Palacios','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77466','Pattison','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77467','Pierce','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77468','Pledger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77469','Richmond','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77470','Rock Island','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77471','Rosenberg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77473','San Felipe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77474','Sealy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77475','Sheridan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77476','Simonton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77477','Stafford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77479','Sugar Land','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77480','Sweeny','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77481','Thompsons','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77482','Van Vleck','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77483','Wadsworth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77484','Waller','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77485','Wallis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77486','West Columbia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77487','Sugar Land','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77488','Wharton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77489','Missouri City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77494','Katy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77508','Pasadena','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77510','Santa Fe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77512','Alvin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77514','Anahuac','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77516','Angleton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77517','Santa Fe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77518','Bacliff','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77519','Batson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77522','Baytown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77530','Channelview','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77531','Clute','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77532','Crosby','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77533','Daisetta','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77534','Danbury','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77535','Dayton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77536','Deer Park','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77538','Devers','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77539','Dickinson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77541','Freeport','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77545','Fresno','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77546','Friendswood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77547','Galena Park','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77554','Galveston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77560','Hankamer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77561','Hardin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77562','Highlands','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77563','Hitchcock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77564','Hull','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77565','Kemah','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77566','Lake Jackson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77568','La Marque','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77572','La Porte','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77574','League City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77575','Liberty','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77577','Liverpool','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77578','Manvel','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77579','Monroe City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77580','Mont Belvieu','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77581','Pearland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77582','Raywood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77583','Rosharon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77584','Pearland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77585','Saratoga','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77586','Seabrook','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77587','South Houston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77588','Pearland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77592','Texas City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77597','Wallisville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77598','Webster','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77611','Bridge City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77612','Buna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77613','China','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77614','Deweyville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77615','Evadale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77616','Fred','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77617','Gilchrist','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77619','Groves','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77622','Hamshire','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77623','High Island','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77624','Hillister','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77625','Kountze','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77626','Mauriceville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77627','Nederland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77629','Nome','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77631','Orange','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77639','Orangefield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77640','Port Acres','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77643','Port Arthur','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77650','Port Bolivar','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77651','Port Neches','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77655','Sabine Pass','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77656','Silsbee','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77659','Sour Lake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77660','Spurger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77661','Stowell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77662','Vidor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77663','Village Mills','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77664','Warren','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77665','Winnie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77711','Beaumont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77713','Beaumont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77720','Beaumont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77726','Beaumont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77803','Bryan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77806','Bryan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77830','Anderson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77831','Bedias','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77833','Brenham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77835','Burton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77836','Caldwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77837','Calvert','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77838','Chriesman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77839','Somerville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77844','College Station','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77850','Concord','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77852','Deanville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77853','Dime Box','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77855','Flynn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77856','Franklin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77857','Gause','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77859','Hearne','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77861','Iola','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77862','Kurten','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77863','Lyons','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77864','Madisonville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77865','Marquez','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77866','Millican','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77867','Mumford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77869','Navasota','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77870','New Baden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77871','Normangee','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77872','North Zulch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77873','Richards','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77875','Anderson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77876','Shiro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77878','Snook','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77879','Somerville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77880','Washington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77881','Wellborn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77882','Wheelock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77905','Victoria','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77950','Austwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77951','Bloomington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77952','Cheapside','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77954','Cuero','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77957','Edna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77960','Fannin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77961','Francitas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77962','Ganado','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77963','Goliad','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77964','Hallettsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77967','Hochheim','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77968','Inez','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77969','La Salle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77970','La Ward','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77971','Lolita','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77972','Port Lavaca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77973','Mc Faddin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77974','Meyersville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77975','Moulton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77976','Nursery','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77977','Placedo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77978','Point Comfort','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77979','Port Lavaca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77983','Seadrift','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77984','Shiner','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77985','Speaks','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77986','Sublime','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77987','Sweet Home','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77988','Telferner','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77989','Thomaston','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77990','Tivoli','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77991','Vanderbilt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77993','Weesatche','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77994','Westhoff','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('77995','Yoakum','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78001','Cotulla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78002','Atascosa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78003','Bandera','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78004','Boerne','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78005','Bigfoot','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78006','Boerne','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78007','Calliham','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78008','Campbellton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78009','Castroville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78010','Center Point','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78011','Charlotte','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78012','Christine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78013','Comfort','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78014','Cotulla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78016','Devine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78017','Dilley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78019','Encinal','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78020','Fashing','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78021','Fowlerton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78022','George West','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78023','Helotes','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78024','Hunt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78025','Ingram','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78026','Jourdanton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78027','Kendalia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78029','Kerrville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78039','La Coste','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78044','Laredo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78050','Leming','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78052','Lytle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78053','Mc Coy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78054','Macdona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78055','Medina','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78056','Castroville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78057','Moore','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78058','Mountain Home','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78059','Natalia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78060','Three Rivers','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78061','Pearsall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78062','Peggy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78063','Pipe Creek','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78064','Pleasanton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78065','Poteet','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78066','Riomedina','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78067','San Ygnacio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78069','Somerset','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78070','Spring Branch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78071','Three Rivers','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78072','Tilden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78073','Von Ormy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78074','Waring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78075','Whitsett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78076','Zapata','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78101','Adkins','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78104','Beeville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78107','Berclair','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78108','Cibolo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78109','Converse','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78111','Gillett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78112','Elmendorf','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78113','Falls City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78114','Floresville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78115','Geronimo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78116','Gillett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78117','Hobson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78118','Karnes City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78119','Kenedy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78121','La Vernia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78122','Leesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78123','Mc Queeney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78124','Marion','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78125','Kenedy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78133','New Braunfels','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78140','Nixon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78141','Nordheim','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78142','Normanna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78143','Pandora','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78144','Panna Maria','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78145','Pawnee','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78146','Pettus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78147','Poth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78148','Universal City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78150','Universal City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78151','Runge','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78152','Saint Hedwig','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78153','Saspamco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78154','Schertz','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78156','Seguin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78159','Smiley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78160','Stockdale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78161','Sutherland Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78162','Tuleta','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78163','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78164','Yorktown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78245','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78265','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78270','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78275','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78280','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78289','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78299','San Antonio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78330','Agua Dulce','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78333','Alice','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78336','Aransas Pass','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78338','Armstrong','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78339','Banquete','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78340','Bayside','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78341','Benavides','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78342','Alice','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78343','Bishop','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78344','Bruni','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78347','Chapman Ranch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78349','Concepcion','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78350','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78351','Driscoll','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78352','Edroy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78353','Encino','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78355','Falfurrias','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78357','Freer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78358','Fulton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78359','Gregory','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78360','Guerra','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78361','Hebbronville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78362','Ingleside','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78364','Kingsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78368','Mathis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78369','Mirando City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78370','Odem','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78371','Oilton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78372','Orange Grove','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78373','Port Aransas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78374','Portland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78375','Premont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78376','Realitos','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78377','Refugio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78379','Riviera','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78380','Robstown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78382','Rockport','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78383','Sandia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78384','San Diego','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78385','Sarita','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78387','Sinton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78389','Skidmore','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78390','Taft','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78391','Tynan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78393','Woodsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78419','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78427','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78461','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78463','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78478','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78480','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78482','Corpus Christi','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78504','Mc Allen','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78516','Alamo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78523','Brownsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78526','Brownsville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78535','Combes','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78536','Delmita','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78537','Donna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78538','Edcouch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78540','Edinburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78543','Elsa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78545','Falcon Heights','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78547','Garciasville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78548','Grulla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78549','Hargill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78552','Harlingen','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78557','Hidalgo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78558','La Blanca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78559','La Feria','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78560','La Joya','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78561','Lasara','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78562','La Villa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78563','Linn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78564','Lopeno','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78565','Los Ebanos','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78566','Los Fresnos','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78567','Los Indios','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78568','Lozano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78569','Lyford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78570','Mercedes','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78572','Mission','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78575','Olmito','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78576','Penitas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78577','Pharr','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78578','Port Isabel','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78579','Progreso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78580','Raymondville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78582','Rio Grande City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78583','Rio Hondo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78584','Roma','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78585','Salineno','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78586','San Benito','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78588','San Isidro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78589','San Juan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78590','San Perlita','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78591','Santa Elena','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78592','Santa Maria','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78593','Santa Rosa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78594','Sebastian','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78595','Sullivan City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78596','Weslaco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78597','Port Isabel','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78598','Raymondville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78601','Albert','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78602','Bastrop','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78603','Bebe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78604','Belmont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78605','Bertram','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78606','Blanco','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78607','Bluffton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78608','Briggs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78609','Buchanan Dam','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78610','Buda','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78611','Burnet','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78612','Cedar Creek','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78613','Cedar Park','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78614','Cost','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78615','Coupland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78616','Dale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78617','Del Valle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78618','Doss','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78619','Driftwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78620','Dripping Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78621','Elgin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78622','Fentress','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78623','Fischer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78624','Fredericksburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78628','Georgetown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78629','Gonzales','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78631','Harper','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78632','Harwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78634','Hutto','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78635','Hye','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78636','Johnson City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78638','Kingsbury','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78639','Kingsland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78640','Kyle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78641','Leander','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78642','Liberty Hill','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78643','Llano','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78644','Lockhart','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78645','Leander','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78648','Luling','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78650','Mc Dade','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78651','Mc Neil','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78652','Manchaca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78653','Manor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78654','Marble Falls','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78655','Martindale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78656','Maxwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78658','Ottine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78659','Paige','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78660','Pflugerville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78661','Prairie Lea','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78662','Red Rock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78663','Round Mountain','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78664','Round Rock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78665','Sandy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78667','San Marcos','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78669','Spicewood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78670','Staples','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78671','Stonewall','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78672','Tow','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78673','Walburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78674','Weir','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78675','Willow City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78676','Wimberley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78677','Wrightsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78681','Round Rock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78705','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78714','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78739','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78769','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78774','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78776','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78789','Austin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78802','Uvalde','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78827','Asherton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78828','Barksdale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78829','Batesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78830','Big Wells','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78832','Brackettville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78833','Camp Wood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78834','Carrizo Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78835','Del Rio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78836','Catarina','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78837','Comstock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78838','Concan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78839','Crystal City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78843','Del Rio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78847','Del Rio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78851','Dryden','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78853','Eagle Pass','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78860','El Indio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78861','Hondo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78870','Knippa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78871','Langtry','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78872','La Pryor','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78873','Leakey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78877','Quemado','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78879','Rio Frio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78880','Rocksprings','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78881','Sabinal','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78883','Tarpley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78884','Utopia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78885','Vanderpool','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78886','Yancey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78931','Bleiblerville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78932','Carmine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78933','Cat Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78935','Columbus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78938','Ellinger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78940','Fayetteville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78941','Flatonia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78942','Giddings','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78943','Columbus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78944','Industry','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78945','La Grange','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78946','Ledbetter','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78947','Lexington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78948','Lincoln','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78949','Muldoon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78950','New Ulm','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78951','Oakland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78952','Plum','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78953','Rosanky','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78954','Round Top','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78956','Schulenburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78957','Smithville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78959','Waelder','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78960','Warda','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78961','Round Top','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78962','Weimar','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78963','West Point','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('78964','Winchester','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79001','Adrian','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79002','Alanreed','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79003','Allison','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79005','Booker','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79008','Borger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79009','Bovina','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79010','Boys Ranch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79011','Briscoe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79012','Bushland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79013','Cactus','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79014','Canadian','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79016','Canyon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79018','Channing','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79019','Claude','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79021','Cotton Center','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79022','Dalhart','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79024','Darrouzett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79025','Dawn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79027','Dimmitt','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79029','Dumas','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79031','Earth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79032','Edmonson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79033','Farnsworth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79034','Follett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79035','Friona','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79036','Fritch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79039','Groom','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79040','Gruver','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79041','Hale Center','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79042','Happy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79043','Hart','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79044','Hartley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79045','Hereford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79046','Higgins','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79051','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79052','Kress','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79053','Lazbuddie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79054','Lefors','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79056','Lipscomb','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79057','Mc Lean','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79058','Channing','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79059','Miami','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79061','Mobeetie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79062','Morse','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79063','Nazareth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79064','Olton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79066','Pampa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79068','Panhandle','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79070','Perryton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79073','Plainview','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79077','Samnorwood','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79078','Sanford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79079','Shamrock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79080','Skellytown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79081','Spearman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79082','Springlake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79083','Stinnett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79084','Stratford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79085','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79086','Sunray','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79087','Texline','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79088','Tulia','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79090','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79091','Umbarger','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79092','Vega','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79093','Waka','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79094','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79095','Wellington','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79096','Wheeler','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79097','White Deer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79098','Wildorado','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79111','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79114','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79121','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79124','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79161','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79178','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79182','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79189','Amarillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79201','Childress','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79220','Afton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79221','Aiken','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79222','Carey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79223','Cee Vee','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79224','Chalk','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79225','Chillicothe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79226','Clarendon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79227','Crowell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79229','Dickens','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79230','Dodson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79231','Dougherty','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79232','Dumont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79233','Estelline','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79234','Flomot','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79235','Floydada','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79236','Guthrie','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79237','Hedley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79238','Kirkland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79239','Lakeview','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79240','Lelia Lake','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79241','Lockney','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79243','Mc Adoo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79244','Matador','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79245','Memphis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79246','Northfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79247','Odell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79248','Paducah','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79250','Petersburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79251','Quail','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79252','Quanah','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79255','Quitaque','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79256','Roaring Springs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79257','Silverton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79258','South Plains','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79259','Tell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79260','Truscott','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79261','Turkey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79311','Abernathy','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79312','Amherst','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79313','Anton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79314','Bledsoe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79316','Brownfield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79320','Bula','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79321','Cone','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79322','Crosbyton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79323','Denver City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79324','Enochs','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79325','Farwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79326','Fieldton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79327','Sudan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79329','Idalou','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79330','Justiceburg','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79331','Lamesa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79336','Levelland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79338','Levelland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79339','Littlefield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79342','Loop','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79343','Lorenzo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79344','Maple','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79345','Meadow','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79346','Morton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79347','Muleshoe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79350','New Deal','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79353','Pep','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79354','Pettit','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79355','Plains','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79356','Post','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79357','Ralls','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79358','Ropesville','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79359','Seagraves','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79360','Seminole','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79363','Shallowater','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79364','Slaton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79366','Slaton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79367','Smyer','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79368','Slaton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79369','Spade','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79370','Spur','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79371','Sudan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79372','Sundown','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79373','Tahoka','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79376','Tokio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79377','Welch','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79378','Wellman','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79379','Whiteface','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79380','Whitharral','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79381','Wilson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79382','Wolfforth','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79383','Wilson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79417','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79424','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79430','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79453','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79457','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79464','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79491','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79493','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79499','Lubbock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79501','Anson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79502','Aspermont','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79503','Stamford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79504','Baird','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79505','Benjamin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79506','Blackwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79508','Buffalo Gap','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79510','Clyde','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79511','Coahoma','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79512','Colorado City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79515','Dermott','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79516','Dunn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79517','Fluvanna','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79518','Girard','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79519','Goldsboro','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79520','Hamlin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79521','Haskell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79525','Hawley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79526','Hermleigh','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79527','Ira','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79528','Jayton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79529','Knox City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79530','Lawn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79532','Loraine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79533','Lueders','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79534','Mc Caulley','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79535','Maryneal','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79536','Merkel','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79537','Nolan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79538','Novice','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79540','Old Glory','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79541','Ovalo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79542','Peacock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79543','Roby','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79544','Rochester','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79545','Roscoe','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79546','Rotan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79547','Rule','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79548','Stamford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79549','Snyder','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79553','Stamford','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79556','Sweetwater','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79560','Sylvester','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79561','Trent','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79562','Tuscola','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79563','Tye','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79565','Westbrook','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79566','Wingate','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79567','Winters','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79608','Abilene','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79699','Abilene','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79712','Midland','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79713','Ackerly','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79714','Andrews','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79718','Balmorhea','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79719','Barstow','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79721','Big Spring','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79730','Coyanosa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79731','Crane','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79733','Forsan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79734','Fort Davis','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79735','Fort Stockton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79738','Gail','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79739','Garden City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79740','Girvin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79741','Goldsmith','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79742','Grandfalls','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79743','Imperial','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79744','Iraan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79745','Kermit','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79748','Knott','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79749','Lenorah','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79752','Mc Camey','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79754','Mentone','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79755','Midkiff','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79756','Monahans','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79758','Gardendale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79759','Notrees','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79768','Odessa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79770','Orla','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79772','Pecos','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79776','Penwell','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79777','Pyote','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79778','Rankin','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79779','Royalty','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79780','Saragosa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79781','Sheffield','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79782','Stanton','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79783','Tarzan','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79785','Toyah','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79786','Toyahvale','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79788','Wickett','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79789','Wink','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79821','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79832','Alpine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79835','Canutillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79836','Clint','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79837','Dell City','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79838','Fabens','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79839','Fort Hancock','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79842','Marathon','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79843','Marfa','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79846','Presidio','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79847','Salt Flat','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79848','Sanderson','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79849','San Elizario','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79850','Shafter','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79851','Sierra Blanca','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79852','Terlingua','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79853','Tornillo','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79854','Valentine','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79855','Van Horn','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79908','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79910','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79918','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79920','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79927','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79932','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79937','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79955','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79958','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79961','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79966','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79968','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79978','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79980','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('79999','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('80441','Foxton','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('80731','Haxtun','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81134','San Luis','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81150','San Acacio','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81152','San Luis','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81153','San Pablo','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81223','Cotopaxi','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81250','Texas Creek','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81429','Paradox','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('81630','De Beque','CO')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('82057','Foxpark','WY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('82224','Lost Springs','WY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('82323','Dixon','WY')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('83441','Rexburg','ID')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('83534','Headquarters','ID')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('84531','Mexican Hat','UT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('84621','Axtell','UT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('84655','Santaquin','UT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('84765','Santa Clara','UT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('84774','Toquerville','UT')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85041','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85044','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85046','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85051','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85055','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85069','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85080','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85082','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85099','Phoenix','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85242','Queen Creek','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85346','Quartzsite','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85349','San Luis','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85359','Quartzsite','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85550','San Carlos','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85631','San Manuel','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85632','San Simon','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('85644','Willcox','AZ')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87006','Bosque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87010','Cerrillos','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87030','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87031','Los Lunas','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87049','San Fidel','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87050','San Mateo','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87051','San Rafael','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87053','San Ysidro','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87120','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87125','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87131','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87140','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87154','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87158','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87174','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87176','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87180','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87185','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87192','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87199','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87201','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87320','Mexican Springs','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87506','Santa Fe','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87509','Santa Fe','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87510','Abiquiu','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87527','Dixon','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87538','Santa Fe','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87540','Santa Fe','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87542','Albuquerque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87545','Los Alamos','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87551','Los Ojos','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87556','Questa','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87564','San Cristobal','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87565','San Jose','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87566','San Juan Pueblo','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87567','Santa Cruz','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87574','Tesuque','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87725','Ledoux','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87728','Maxwell','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87733','Mosquero','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87829','Quemado','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87831','San Acacia','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('87832','San Antonio','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88008','Las Cruces','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88048','Mesquite','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88058','San Miguel','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88135','Texico','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88230','Dexter','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88348','San Patricio','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88432','Santa Rosa','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88433','Quay','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88434','San Jon','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88435','Santa Rosa','NM')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88521','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88536','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88550','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88563','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('88589','El Paso','TX')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('89024','Mesquite','NV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('89199','Las Vegas','NV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('89424','Nixon','NV')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90080','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90084','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90089','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90091','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90094','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90097','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90099','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90101','Los Angeles','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90406','Santa Monica','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90671','Santa Fe Springs','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90721','Los Alamitos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('90734','San Pedro','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91310','Santa Clarita','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91322','Santa Clarita','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91341','San Fernando','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91346','San Fernando','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91351','Santa Clarita','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91386','Santa Clarita','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91773','San Dimas','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91776','San Gabriel','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('91778','San Gabriel','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92067','Rancho Santa Fe','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92068','San Luis Rey','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92069','San Marcos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92070','Santa Ysabel','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92073','San Ysidro','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92117','San Diego','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92124','San Diego','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92140','San Diego','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92143','San Ysidro','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92145','San Diego','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92231','Calexico','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92253','La Quinta','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92332','Essex','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92707','Santa Ana','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92712','Santa Ana','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('92799','Santa Ana','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93035','Oxnard','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93039','Oxnard','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93060','Santa Paula','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93103','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93111','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93118','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93121','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93130','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93140','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93150','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93160','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93190','Santa Barbara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93221','Exeter','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93249','Lost Hills','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93255','Onyx','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93256','Pixley','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93440','Los Alamos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93441','Los Olivos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93453','Santa Margarita','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93456','Santa Maria','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93460','Santa Ynez','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93553','Pearblossom','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93620','Dos Palos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93635','Los Banos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93660','San Joaquin','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93661','Santa Rita Park','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93665','South Dos Palos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93668','Tranquillity','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('93675','Squaw Valley','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94023','Los Altos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94070','San Carlos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94083','South San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94096','San Bruno','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94099','San Bruno','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94112','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94146','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94156','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94164','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94171','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94175','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94188','San Francisco','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94404','San Mateo','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94497','San Mateo','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94579','San Leandro','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94580','San Lorenzo','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94583','San Ramon','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94901','San Rafael','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94904','San Rafael','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94915','San Rafael','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94930','Fairfax','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94960','San Anselmo','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94963','San Geronimo','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94964','San Quentin','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('94974','San Quentin','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95032','Los Gatos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95045','San Juan Bautista','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95046','San Martin','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95055','Santa Clara','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95066','Santa Cruz','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95073','Soquel','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95103','San Jose','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95106','San Jose','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95142','San Jose','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95148','San Jose','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95409','Santa Rosa','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95543','Gasquet','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95620','Dixon','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95713','Colfax','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95955','Maxwell','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('95971','Quincy','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('96055','Los Molinos','CA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97109','Buxton','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97342','Detroit','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97423','Coquille','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97431','Dexter','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97476','Sixes','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97486','Umpqua','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97535','Phoenix','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97624','Chiloquin','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97639','Chiloquin','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97831','Fox','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97835','Helix','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97840','Oxbow','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('97857','Lostine','OR')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98027','Issaquah','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98065','Snoqualmie','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98256','Index','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98333','Fox Island','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98334','Sequim','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98376','Quilcene','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98382','Sequim','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98392','Suquamish','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98550','Hoquiam','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98575','Quinault','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98824','Quincy','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98848','Quincy','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('98936','Moxee','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('99111','Colfax','WA')")
    stopIfSqlNotOK(session, "INSERT INTO city VALUES ('99329','Dixie','WA')")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (141,'Petra Farmhouse','26811','6 Sycamore Blvd,#4',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (149,'City Center Motel','59075','24 Eighth Avenue,#109',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (163,'Crowne Plaza Hotel','27869','254 Broadway Blvd,#80',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (175,'Hialeah Motel','10580','399 Poplar Boulevard,#106',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (177,'Stateline','72820','439 Spruce Ave,#95',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (187,'Ninth Street Motel','79257','348 Adams Square,#20',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (201,'Lucky Motel','00922','476 Broadway Avenue,#137',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (213,'Harbor Island Apts.','76556','316 Sixth Boulevard,#155',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (231,'Silverton Hotel','78062','20 Laurel Street,#35',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (246,'Comfort Inn','31801','397 Sunset Boulevard,#66',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (248,'MGM Grand Hotel','78361','445 Washington St.,#175',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (262,'Motel Regency','75640','168 Davis Square,#174',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (268,'Friendship Inn','23350','346 Wilson Ave,#190',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (284,'King Albert Motel','75947','261 Forest Walk,#8',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (297,'Thunderbird Hotel','76936','362 Eleventh Street,#133',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (311,'Motel Vegas Verdes','75491','234 Green Place,#167',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (324,'Fiesta Henderson','40526','237 Hill Road,#43',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (342,'Desert Star Motel','88433','196 Smith Square,#17',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (345,'Palace Station Hotel','78336','189 Fifth Parkway,#200',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (363,'Ogden House Motel','75094','240 Fourteenth Walk,#197',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (382,'Glass Pool Inn','79064','356 Hickory Drive,#21',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (401,'Golden Inn Motel','75933','297 Ninth Square,#38',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (407,'Diamond Inn Motel','00755','142 Jefferson Blvd,#126',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (408,'Wild Wild West Gambling Hall and Hotel','78579','470 View Square,#79',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (426,'Fairfield Inn By Marriott','75448','141 Jefferson Avenue,#153',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (430,'Indian Springs Motor Hotel','79221','389 Center Place,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (448,'Tal Fanal Village','79546','39 Woodland Boulevard,#197',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (449,'Royal Hotel','75075','229 Poplar Boulevard,#46',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (461,'Econo Lodge','76467','315 Sunset Parkway,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (468,'Town House Motor Lodge','75978','193 Tenth Street,#187',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (474,'Motel 8','13456','258 Taylor Walk,#40',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (479,'Panorama Hotel','79511','450 Sixth St.,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (489,'Knotty Pine Motel','75426','349 Ninth Ave,#75',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (495,'Nylen Motel','76934','177 Center Drive,#14',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (508,'Motel Royal','18046','260 Madison Avenue,#165',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (518,'Sam''s Town Hotel and Gambling Hall','66859','344 Smith Ave,#117',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (520,'Edgewater Hotel','76571','364 Highland Road,#50',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (534,'Riverside Resort Hotel','75713','224 Spring Blvd,#112',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (551,'Best Western Main Street Inn','79719','262 Lake Parkway,#139',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (561,'Comfort Inn','75016','406 Franklin Avenue,#193',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (569,'Ogden House Motel','53584','472 Madison Road,#20',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (587,'Peter Pan Motel','41847','189 Hickory Place,#34',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (606,'Town House Motor Lodge','77582','271 Lake Lane,#143',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (612,'Silver Sands Motel','75970','32 Wilson Drive,#87',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (628,'Downtowner Budget Apt. Motel','79324','112 Fifth Walk,#42',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (631,'E-Z 8 Motel','76561','275 Taylor Parkway,#22',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (642,'Best View Parkview Inn','60601','37 Sycamore Boulevard,#13',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (650,'Comet Motel','75762','392 Jefferson Parkway,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (653,'Western Inn','78650','440 Hill Lane,#62',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (657,'Tod Motor Motel','75764','289 Thirteenth Boulevard,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (660,'Virgin River Hotel','87049','270 Williams Road,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (664,'Uptown Motel','78478','228 Meadow Walk,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (669,'Main Street Station Brewery Hotel','08736','496 Smith Blvd,#141',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (681,'Extended StayAmerica','77586','17 Lakeview St.,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (682,'Carriage House','67334','5 Willow Boulevard,#35',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (695,'Lee Motel','78373','278 Highland Street,#52',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (714,'Fortina Spa A la Carte','77238','195 Poplar Boulevard,#5',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (718,'HomeGate Studios & Suites','79752','379 Church Walk,#31',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (732,'Corinthia Jerma Palace','76850','189 Davis Lane,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (741,'King Albert Motel','59222','78 Seventh Road,#12',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (751,'Silver Queen Motel','23141','497 Fourth Blvd,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (766,'Desert Moon Motel','79178','428 Center Street,#62',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (780,'Sunset Station Hotel','98065','2 Smith Road,#72',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (782,'Sportsman''s Manor','75295','122 Davis Avenue,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (786,'Fremont Hotel','76957','399 West Avenue,#113',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (791,'Riviera Hotel','79848','433 Willow Ave,#12',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (796,'La Palm Motel','79776','46 Forest Blvd,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (800,'Rangler Motel','75065','229 Park Square,#115',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (806,'Warren Motel','79336','238 Hickory St.,#78',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (813,'Strip Hotel','76649','357 Forest Ave,#197',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (824,'Holiday Royale','77857','408 Valley Street,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (831,'Grand Hotel','66086','235 South Walk,#152',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (843,'Grand Hotel','93453','59 Fifth Avenue,#43',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (860,'Nellis Lodge Motel','76839','201 Cherry Road,#74',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (861,'Motel Vegas Verdes','76839','252 Center Drive,#157',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (862,'Blair House Hotel','54635','117 River Lane,#109',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (863,'Corinthia Marina Resort','78839','461 Lakeview Boulevard,#150',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (878,'La Paloma Apt. Motel','95955','202 Poplar Square,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (895,'Super 8 Motel at Nellis AFB','75630','110 North Drive,#116',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (913,'Topaz Hotel & Studios','16159','492 Center Blvd,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (919,'Colorado Belle Hotel','75426','244 Davis Street,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (921,'Towne and Country Motel','75765','303 Hickory Lane,#1',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (937,'Golden Nugget Hotel','10126','197 Jefferson Drive,#87',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (946,'Desert Hills Motel','78638','52 Hillcrest Lane,#115',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (964,'Imperial Palace Hotel','75339','142 Walnut Road,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (972,'Nevada Hotel','93660','222 Smith Walk,#121',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (982,'Warren House East','79383','356 Meadow Ave,#181',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1001,'Comfort Inn','75972','426 Twelfth Ave,#126',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1021,'St. Patrick''s Hotel','78119','461 Forest Place,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1039,'Diamond Inn Motel','76009','350 Spring Square,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1049,'Texas Station Gambling Hall','78642','413 River Road,#112',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1055,'Villager Lodge Inn & Suites','50851','424 Fourth Boulevard,#53',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1061,'Park Hotel','56472','397 Railroad Road,#128',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1070,'Buffalo Bill''s Resort','41848','58 Davis Blvd,#129',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1077,'Fairfield Inn By Marriott','76448','342 Elm Place,#147',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1096,'Town & Country Manor','78620','401 Fifteenth Square,#150',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1102,'Thai Royal Motel','77347','212 Wilson Parkway,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1103,'Hialeah Motel','75840','371 Miller Drive,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1120,'Bella Vista Farmhaeuser','79383','93 Pine Boulevard,#168',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1130,'Desert Palms Motel','75928','357 North Lane,#174',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1149,'Hitchin'' Post','78545','379 Hickory Square,#168',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1166,'Hotel Santana','78960','201 Laurel Road,#101',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1175,'Grand Hotel','85242','47 College Street,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1195,'Castaways','79098','95 Sycamore Drive,#185',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1196,'Airport Inn','49720','123 East Parkway,#18',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1197,'Jackpot Motel','75098','324 Birch Boulevard,#137',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1206,'Budget Inn','79329','257 Laurel Place,#53',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1214,'Bellagio','67027','249 Park Place,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1220,'Fortina Spa A la Carte','57107','278 Walnut Parkway,#15',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1226,'Henderson Town House Motor Lodge','75115','379 Oak Square,#103',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1239,'Apache Motel','11762','447 Highland Square,#107',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1253,'Primera Hotel','75163','426 Hill Place,#153',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1254,'Fremont Hotel','78011','84 Fourteenth Walk,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1261,'Holiday Royale','65459','21 Central Avenue,#107',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1270,'Park Hotel','78384','491 Sycamore Walk,#17',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1285,'Uptown Motel','70765','174 Cherry Boulevard,#134',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1294,'Sixth and Carson Hotel','73668','315 Hillcrest Boulevard,#112',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1300,'Silver Spur Hotel','78579','79 Green Street,#140',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1320,'Cornucopia Hotel & Bungalows','30417','158 River Lane,#15',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1334,'Hilton Grand Vacations Club at the LV Hilton','58759','12 Fifteenth Lane,#18',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1342,'Motel 6 - West','78112','139 Meadow Street,#51',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1360,'La Quinta Inn - Convention Center','78338','451 First Place,#134',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1372,'Venetian Resort Hotel','75103','182 Fifteenth Street,#88',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1385,'Harrah''s Laughlin','79257','273 Park Lane,#164',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1399,'Friendship Inn','76564','474 Taylor Lane,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1400,'Cheyenne Motel','78004','283 Willow Ave,#168',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1406,'Diamond Inn Motel','18435','28 Jackson Walk,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1411,'CasaBlanca Hotel, Casino, Golf and Spa','79920','29 Highland Avenue,#58',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1413,'La Quinta Inn - Strip','76628','247 View Road,#46',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1427,'Cornucopia Hotel & Bungalows','75270','500 Thirteenth Lane,#147',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1437,'Knotty Pine Motel','75779','373 Willow Boulevard,#86',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1449,'Flamingo Laughlin','78956','432 Forest Street,#3',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1452,'La Vallette Resort','78025','246 Ash Road,#180',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1456,'Courtyard Las Vegas Green Valley','95971','62 Laurel Place,#92',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1468,'Capri Motel','57719','444 Smith Square,#102',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1488,'RIU Seabank Hotel','49775','41 Birch Street,#90',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1495,'City Center Motel','76007','213 Mill Avenue,#103',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1500,'El Rancho Boulder Motel','76679','132 Hill Lane,#184',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1510,'Texas Station Gambling Hall','22033','498 South Drive,#107',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1515,'Henderson Courtyard','04932','204 Lake St.,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1524,'Vegas Motel','57353','442 Walnut Walk,#169',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1533,'InterContinental Malta','76824','216 Green Ave,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1549,'Bellagio','77624','258 Eleventh Walk,#72',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1553,'Park Hotel','79233','29 College St.,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1570,'Paradise Bay','77231','178 Wilson Walk,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1582,'La Quinta Inn - Northwest Tech Center','78017','276 Chestnut Boulevard,#82',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1592,'Boulder Palms Luxury Suites','78330','308 Tenth Blvd,#105',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1596,'Radisson SAS Bay Point Resort','76508','385 Williams Ave,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1610,'Desert Moon Motel','78942','458 Park Ave,#99',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1626,'Yucca Motel','76628','48 Fifth Street,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1631,'Royal Hotel','77371','133 Park Street,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1645,'Suncoast Hotel','31629','222 Fourteenth Ave,#67',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1661,'Palace Station Hotel','76034','476 Maple Blvd,#77',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1670,'Crest Budget Apt. Motel','79239','28 Miller Avenue,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1685,'Indian Springs Motor Hotel','76574','209 Sunset Square,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1689,'Boulder Dam Hotel - Bed & Breakfast','79735','155 Church Square,#55',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1709,'Maritim Antonine Hotel & Spa','79530','336 Johnson Drive,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1711,'Boulder Manor','78549','480 Sixth Parkway,#144',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1724,'Fremont Hotel','22035','122 Jackson Ave,#164',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1735,'Towne and Country Motel','04764','220 Fifteenth Lane,#78',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1740,'Days Inn - Downtown','75850','150 Sunset Place,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1741,'Rodeway Inn Suites - Nellis','76649','151 Oak Blvd,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1743,'Oasis Motel','75152','485 Railroad Square,#102',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1757,'Golden Inn Motel','76073','362 South Avenue,#135',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1761,'Del Mar Resort Motel','27573','440 Sunset St.,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1772,'Thriftlodge Motel','87831','49 Cedar Blvd,#24',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1774,'Bourbon Street Hotel','75683','388 Forest Walk,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1786,'Gozo Farmhaeuser','15763','186 West Square,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1790,'Blue Angel Motel','79730','453 Franklin Parkway,#52',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1799,'Royal Hotel','76075','281 First St.,#140',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1811,'Palace Station Hotel','75560','18 Park Street,#122',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1817,'Monterey Motel','76823','388 Highland Ave,#148',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1833,'Silver Queen Motel','12570','182 Laurel Road,#174',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1841,'Main Street Inn','18636','418 Ninth Road,#115',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1847,'Hotel Plevna','75847','58 Pine Ave,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1853,'El Rancho Boulder Motel','77347','287 Williams Parkway,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1863,'Western Hotel','56543','300 Taylor Avenue,#155',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1879,'Hitchin'' Post','77433','463 Dogwood Ave,#88',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1891,'Klondike Inn Hotel','93441','95 Oak Avenue,#73',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1901,'Westward Ho Hotel','64067','202 Birch Lane,#31',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1919,'Holiday Inn Express','77973','175 Park Ave,#106',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1939,'Gateway Motel','76270','317 Main Drive,#77',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1955,'Silverton Hotel','76263','33 Green Drive,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1971,'Whiskey Pete''s Hotel','75939','241 View St.,#21',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (1987,'Comfort Inn','75569','30 Wilson Blvd,#109',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2001,'Barbary Coast Hotel','75422','253 Lakeview Avenue,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2021,'Hotel San Remo Resort','76027','258 Oak Drive,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2026,'Indian Springs Motor Hotel','77535','150 Pine Avenue,#57',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2028,'Monterey Motel','76253','76 Park Place,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2038,'Texas Station Gambling Hall','25180','383 Elm Walk,#69',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2039,'Super 8 Motel','78610','199 Williams Place,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2053,'Bella Vista Hotel','24957','98 Maple Boulevard,#103',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2067,'Comfort Inn-South','76255','155 Locust Walk,#116',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2076,'Lake Mead Resort Marina','78336','457 Madison Drive,#131',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2093,'Hotel Bayview','78358','166 Poplar Parkway,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2105,'Terrible''s Hotel','18252','396 Davis Boulevard,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2106,'Rio Suite Hotel','61469','492 Franklin Square,#88',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2125,'Paradise Bay','77411','63 Locust Parkway,#123',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2133,'Suncrest Hotel','41363','213 Center Drive,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2140,'Town & Country Manor','77369','151 Mill Avenue,#178',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2150,'Nylen Motel','78559','191 Cherry St.,#159',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2164,'Howard Johnson - Airport','76839','340 Davis Avenue,#66',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2180,'Lucky Cuss Motel','77445','270 Forest Place,#159',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2181,'Four Seasons Hotel','36868','11 Sunset Square,#22',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2182,'Traveler''s Motel','78578','317 Sunset Drive,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2185,'Cheyenne Motel','79364','102 Maple Walk,#46',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2200,'Fiesta Henderson','78877','395 Davis Road,#89',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2209,'Sportsman''s Manor','78623','218 Second Walk,#72',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2212,'Best Western Lighthouse','76020','44 Elm Parkway,#10',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2215,'Comfort Inn','18245','135 Jackson Street,#99',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2225,'Qawra Palace Hotel','75689','245 Jefferson Boulevard,#86',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2228,'Tal Fanal Village','10197','324 Fourth Road,#22',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2231,'Vacation Village','60935','119 Highland Avenue,#152',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2246,'Nellis Oasis Exec. Suites','77987','374 Third Boulevard,#197',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2254,'Black Jack Motel','12192','188 Ridge Avenue,#103',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2274,'Carriage House','76402','345 Lakeview Boulevard,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2289,'Park Hotel','35010','287 Fourth Street,#89',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2302,'Oasis Motel','76882','401 Willow Walk,#25',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2307,'Polo Towers','78569','485 Hill Boulevard,#92',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2309,'Harrah''s Laughlin','78275','104 Eleventh Street,#181',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2319,'Qawra Palace Hotel','79782','346 Fourteenth Square,#198',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2322,'Vagabond Inn','78059','321 Spruce Lane,#11',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2331,'Mi Residential Hotel','79520','144 Woodland Lane,#90',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2337,'Dolmen Resort Hotel','76880','381 Eleventh Lane,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2355,'Park Hotel','78069','359 Highland Parkway,#4',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2357,'Karanne Hotel & Suites','11942','306 South Street,#77',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2362,'River Palms Resort','75574','284 Poplar Ave,#175',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2368,'Beverly Palms Hotel','77861','485 View Ave,#135',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2382,'Fez Motel','48096','87 College Street,#40',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2394,'Grand Hotel','77483','342 Green Place,#81',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2408,'Vista Motel','77470','429 Maple Boulevard,#54',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2418,'Nevada Hotel','79014','233 Meadow Blvd,#49',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2431,'Imperial Hotel','79847','39 First Ave,#11',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2434,'Riverside Resort Hotel','10178','144 Fifteenth Road,#76',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2452,'Main Street Inn','46374','254 Lakeview Square,#110',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2456,'Corinthia Palace Hotel','76841','204 Elm Street,#40',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2458,'Super 8 Motel','78118','127 Ridge St.,#80',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2459,'Sportsman''s Manor','75447','406 South St.,#137',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2478,'Comino Hotels & Suiten','79313','338 Mill Square,#46',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2481,'Olympian Palms Resort','79032','423 Davis Square,#58',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2486,'Vegas Motel','28006','296 Fifteenth Parkway,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2491,'Osborne Hotel','76374','271 Eighth Ave,#110',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2511,'Paradise Bay Hotel','76056','433 Jackson Boulevard,#20',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2517,'Golden Tulip Vivaldi','75694','59 West Avenue,#48',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2536,'Quality Inn Hotel','78351','257 Poplar Avenue,#193',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2537,'Terrible''s Hotel','30273','39 Jefferson Square,#118',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2552,'Del Mar Resort Motel','79417','79 Maple Road,#179',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2565,'Outpost Motel','77402','254 Washington Place,#111',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2567,'Comfort Inn','76052','309 Birch Road,#4',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2574,'Stardust Resort','78677','425 Willow St.,#26',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2580,'Circus Circus Hotel*Casino*Theme Park','77985','409 Hickory Street,#186',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2589,'Desert Star Motel','77656','379 Willow Square,#200',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2608,'Sea Mountain Inn & Spa B&B','03907','124 Birch Avenue,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2618,'Treasure Island','60018','435 Elm Lane,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2629,'Green Valley Ranch','28378','255 Ninth Road,#169',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2631,'Nellis Oasis Exec. Suites','76051','471 Green Lane,#54',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2640,'Gozo Farmhaeuser','66713','426 Oak St.,#105',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2648,'Hotel Juliani','79754','9 Fifteenth Ave,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2665,'Boulder Manor','36505','150 Fourth St.,#87',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2681,'Extended StayAmerica','37990','369 Spring Square,#116',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2684,'Sky Motel','77961','95 Wilson Street,#186',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2693,'Park Hotel','00940','176 Cedar Ave,#95',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2709,'Stardust Resort','77510','227 Sycamore Lane,#72',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2717,'Cornucopia Hotel & Bungalows','79329','471 North Blvd,#16',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2724,'Fortina Hotel','73949','57 Taylor Place,#75',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2736,'Grand Hotel','77489','390 Ridge Lane,#32',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2752,'Oasis Resort Hotel','76692','393 Williams Walk,#155',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2761,'Osborne Hotel','22336','80 Fourteenth Drive,#159',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2764,'Edgewater Hotel','40153','317 Poplar Place,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2779,'El Cid Hotel','77546','31 Meadow Road,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2792,'Rodeway Inn & Suites','78372','105 East Boulevard,#104',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2808,'Casino Royale Hotel','40432','13 Jackson Street,#118',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2828,'Panorama Hotel','79853','121 Sycamore St.,#52',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2839,'Courtyard Las Vegas Summerlin','78588','312 River Parkway,#117',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2850,'Hitchin'' Post','77861','196 Maple Drive,#6',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2864,'Desert Palms Motel','78591','351 Miller Lane,#139',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2876,'RIU Seabank Hotel','78843','290 West Parkway,#74',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2885,'Aztec Inn','84621','40 Taylor Blvd,#52',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2892,'Hampton Inn','10096','47 Fifteenth Avenue,#178',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2908,'Center Strip Inn','52254','488 Fourteenth Road,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2925,'Laughing Jackalope Motel','76867','470 Maple Place,#49',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2944,'Tropicana Resort','76250','164 Green Lane,#43',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2954,'Desert Palms Motel','76137','138 Washington Boulevard,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2966,'Paradise Bay','22320','146 North Ave,#111',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2984,'Silver Queen Motel','03907','156 Second Drive,#140',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2994,'Crest Budget Apt. Motel','77450','479 College Place,#24',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2996,'Caesars Palace','76627','181 Ninth Road,#108',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (2998,'Cornucopia Hotel & Bungalows','65265','273 Pine Walk,#68',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3001,'Town Palms Hotel','91346','269 Jefferson Street,#89',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3013,'Monte Carlo Resort','78946','262 Main Road,#78',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3015,'Hotel San Remo Resort','54665','489 Spruce Ave,#67',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3034,'Avi Hotel','79338','445 Twelfth St.,#191',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3050,'Excalibur Hotel','77284','171 Forest Place,#153',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3070,'Vegas Chalet Motel','78026','219 Smith St.,#49',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3088,'Suncrest Hotel','97109','75 Fifth Ave,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3094,'Hawthorn Lakes Ft Apache','73435','263 Lake Street,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3100,'Arizona Charlie''s Boulder','75507','109 Spruce Walk,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3114,'French Quarter Suites','76074','398 Maple Street,#17',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3130,'Golden Nugget Hotel','76454','217 Williams Road,#89',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3140,'Towne and Country Motel','78351','149 Fifth Parkway,#96',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3142,'Barcelona Hotel','78837','103 College Blvd,#164',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3159,'Hampton Inn','76556','450 Church Drive,#50',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3178,'Indian Springs Motor Hotel','78963','226 West Ave,#43',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3185,'Riviera Hotel','78383','146 Cherry Ave,#129',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3188,'Fiesta Rancho','79718','439 Johnson Parkway,#88',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3208,'St. Tropez All Suite Hotel','79226','221 Meadow Place,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3219,'Paradise Resort Inn','85055','122 View Lane,#89',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3236,'Econo Lodge - Downtown','75287','201 Fifth Boulevard,#33',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3256,'Fishers Ari-Avada Motel','97423','41 Spring Street,#87',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3264,'Thai Royal Motel','79357','121 Jefferson Road,#4',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3269,'Mi Residential Hotel','77494','115 Hickory Road,#66',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3281,'El Rancho Boulder Motel','78362','90 Ninth Road,#182',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3288,'Motel Regency','99111','187 Tenth Parkway,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3289,'Luna Holiday Complex','78055','263 Fifteenth Drive,#159',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3298,'Crowne Plaza','78109','170 Jackson Boulevard,#86',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3311,'Best Western Lake Mead','94974','197 First Ave,#140',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3324,'Uptown Motel','76940','262 Johnson Avenue,#65',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3344,'Texas Station Gambling Hall','95148','175 Oak Street,#128',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3354,'Shalimar Hotel','77541','315 Central Walk,#183',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3357,'Paradise Bay Hotel','76038','135 Ash Lane,#102',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3376,'Hop''s Motel','54976','130 Cedar Square,#183',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3393,'Fez Motel','78674','394 Laurel St.,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3407,'Circus Circus Hotel*Casino*Theme Park','77517','349 Fifteenth Drive,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3420,'Carriage House','75762','19 Maple Place,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3426,'Ta''Cenc Hotel','76680','172 Johnson St.,#74',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3441,'Econo Lodge - Downtown','47971','69 Smith Boulevard,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3452,'Sands Motel of Boulder City','76448','422 Laurel Drive,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3468,'Extended StayAmerica','77626','274 Ash Lane,#91',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3482,'Harbor Island Apts.','33470','82 Cherry Avenue,#68',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3485,'Excalibur Hotel','76083','223 Fourth Blvd,#155',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3491,'Strip Hotel','24522','495 Wilson Lane,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3496,'Paradise Bay','79357','177 Fourth Walk,#189',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3500,'Full Moon Motel','78585','247 Highland St.,#60',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3519,'Riviera Hotel','79027','41 River Road,#32',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3522,'Paradise Bay','75968','95 River Walk,#27',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3535,'St. Tropez All Suite Hotel','78523','328 Williams Place,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3546,'Desert Paradise Resort','78370','494 Elm Road,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3554,'Town Lodge Motel','77967','183 View Ave,#183',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3560,'Desert Hills Motel','61469','55 Elm St.,#25',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3574,'Travelodge South Strip','77726','316 Chestnut Drive,#191',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3589,'Hard Rock Hotel','78145','238 Meadow Walk,#155',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3595,'River Palms Resort','75436','66 Johnson Place,#146',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3604,'Travelodge South Strip','79713','346 Center Avenue,#78',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3606,'Venetian Resort Hotel','48051','229 Wilson Parkway,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3611,'Motel 6 - Southeast','75501','132 Second Avenue,#190',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3624,'Howard Johnson - Strip','70310','445 Cedar Street,#154',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3636,'Purple Sage Motel','75766','327 Jackson Avenue,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3643,'Hilton Malta','77720','253 West Parkway,#108',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3660,'Sea Mountain Inn & Spa B&B','58831','205 Meadow Ave,#52',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3661,'Fez Motel','77431','45 Birch Parkway,#80',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3675,'Osborne Hotel','76827','476 Laurel Ave,#76',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3679,'Alpine Apartment Motel','77566','324 Sixth Street,#129',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3685,'Desert Star Motel','79259','269 Thirteenth Drive,#79',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3704,'St. Tropez All Suite Hotel','78118','53 Seventh Square,#119',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3713,'Westward Ho Hotel','76886','337 Lee Parkway,#130',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3716,'Tod Motor Motel','77597','481 Dogwood Boulevard,#190',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3736,'Black Jack Motel','79256','41 Woodland St.,#49',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3751,'Suncoast Hotel','76861','445 Fifteenth Walk,#56',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3760,'Fitzgeralds Hotel','75138','14 Broadway Avenue,#132',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3773,'Best Western Main Street Inn','05669','220 Thirteenth Blvd,#176',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3778,'Barcelona Hotel','76092','358 West Walk,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3795,'Cornucopia Hotel & Bungalows','76378','366 Lincoln Avenue,#11',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3796,'Cimmaron Motel','94930','262 Mill Walk,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3812,'Golden Nugget - Laughlin Hotel','75147','248 Seventh Boulevard,#51',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3826,'Ramada Express','54635','19 First Square,#17',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3839,'Holiday Inn Express Hotel & Suites','27839','406 Central Lane,#181',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3846,'Westward Ho Hotel','78674','246 Pine Blvd,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3863,'Flamingo Laughlin','79511','256 Green Parkway,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3883,'Casino Royale Hotel','79849','214 Main Boulevard,#87',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3890,'Lucky Cuss Motel','77726','197 Lee Square,#107',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3893,'Casablanca Motel','78245','118 Hillcrest Road,#178',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3901,'Beverly Palms Hotel','79759','120 Oak Avenue,#121',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3912,'St. Patrick''s Hotel','76060','454 Hickory Place,#19',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3915,'Greek Isles Hotel','58218','496 Willow Avenue,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3930,'Roulette Motel','73668','186 Twelfth Square,#187',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3935,'Harbor Island Apts.','19348','477 Davis Ave,#26',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3942,'Mt Charleston Hotel','79734','189 Jackson Drive,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3950,'Calypso Hotel','78516','331 Broadway Lane,#121',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3960,'Barcelona Hotel','76666','37 Thirteenth Blvd,#81',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3977,'Desert Moon Motel','77539','1 Church Boulevard,#107',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (3992,'Hilton Grand Vacations Club at the LV Strip','76095','273 Railroad Ave,#34',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4006,'Hilton Malta','76092','487 Franklin Boulevard,#165',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4017,'City Center Motel','87192','40 Pine Place,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4031,'Holiday Inn Express Hotel & Suites','03833','194 Madison Road,#24',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4046,'Ninth Street Motel','76258','368 Third St.,#117',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4065,'Mandalay Bay','78931','162 Mill St.,#15',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4067,'Paradise Bay','75452','246 Sixth Drive,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4068,'Oasis Motel','79785','299 Third Boulevard,#155',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4081,'White Sands Motel','78150','355 Jackson Place,#25',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4093,'Walden Motel','61025','478 Main Road,#21',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4103,'Grand Hotel','04257','277 Tenth St.,#79',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4112,'Boby Motel','17251','205 Elm Ave,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4121,'Aztec Inn','78026','435 Ash Place,#121',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4133,'Primera Hotel','40013','50 West Road,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4138,'Capri Motel','78608','100 Mill Blvd,#40',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4148,'White Sands Motel','79021','4 Lee Ave,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4151,'Imperial Hotel','78387','151 Center Parkway,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4157,'Hotel Sunflower','87574','63 Ash Avenue,#133',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4158,'Carriage House','79511','314 Dogwood Street,#156',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4170,'Fremont Hotel','79781','202 Madison Boulevard,#23',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4171,'Purple Sage Motel','53947','231 Green Place,#42',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4173,'A Fisher''s Inn','78390','476 Hill Blvd,#170',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4180,'Le Meridien St. Julians','76841','68 Birch Street,#144',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4185,'Sands Motel of Boulder City','93668','233 Park Walk,#75',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4194,'Arubu Hotel & Spa','77862','340 Jackson Road,#18',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4197,'Silver Sands Motel','77443','281 Jackson Boulevard,#143',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4204,'Mesquite Springs Motel','72051','15 Madison Street,#195',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4206,'Friendship Inn','75253','97 Spruce St.,#6',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4218,'California Hotel','11762','290 South Lane,#55',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4227,'Town Lodge Motel','78650','1 West Place,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4235,'Primera Hotel','75757','46 Ninth Boulevard,#170',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4244,'Panorama Hotel','40983','321 Eleventh Drive,#189',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4250,'Northwinds Motel','79961','171 Eighth Road,#23',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4256,'Econo Lodge','04764','439 Lincoln Lane,#42',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4270,'Bay Street Hotel','79344','375 River St.,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4271,'St. Patrick''s Hotel','72515','319 Mill Street,#136',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4286,'The Strand Apart/Hotel','75141','326 Woodland Road,#61',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4298,'Lucky Lady Motel','78662','394 Laurel St.,#58',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4299,'Mesquite Springs Motel','77440','296 Ridge Square,#100',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4307,'Best Western Lake Mead','78570','359 Lake Blvd,#21',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4314,'El Cid Hotel','10019','44 Smith Drive,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4327,'Green Valley Ranch','78144','318 Park Lane,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4339,'Harbor Island Apts.','56319','414 Jackson Avenue,#116',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4340,'Jackpot Motel','76367','373 Sunset St.,#83',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4342,'Nylen Motel','76531','438 Eleventh Parkway,#54',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4360,'Osborne Hotel','76357','395 Ninth Avenue,#113',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4375,'Avi Hotel','21856','165 Third Walk,#53',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4381,'Waterfront Hotel','68982','459 Miller Drive,#185',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4392,'Tod Motor Motel','78851','70 Oak Ave,#113',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4399,'Crowne Plaza Hotel','75070','70 Cedar St.,#187',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4401,'La Quinta Inn - Strip','87832','439 Williams Road,#180',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4414,'Sky Ranch Motel','76555','281 Spruce Square,#115',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4421,'Lucky Cuss Motel','79008','476 Twelfth Parkway,#14',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4437,'Best Western Lake Mead','54665','443 Birch Place,#194',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4449,'Jackpot Motel','79565','148 North Street,#62',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4461,'Silver Sands Motel','85055','456 Church Street,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4475,'Vista Motel','78347','137 Cherry Place,#101',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4476,'RIU Seabank Hotel','76804','290 Fifteenth Boulevard,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4481,'Daisy Motel & Apartments','75461','299 Hillcrest Road,#132',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4485,'Best Western Mardi Gras Inn','78339','347 Valley Place,#132',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4486,'Golden Tulip Vivaldi','76841','251 Lincoln Drive,#79',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4494,'Ramada Express','79019','430 Highland Place,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4503,'Glass Pool Inn','52565','312 Main Lane,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4517,'Rangler Motel','49034','445 Fourth Square,#189',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4527,'Lake Mead Resort Marina','79039','106 View Blvd,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4543,'Riverside Resort Hotel','79316','379 Chestnut St.,#164',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4544,'Hard Rock Hotel','88589','405 Williams Walk,#161',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4556,'Treasure Island','76525','364 Lincoln Square,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4562,'Knotty Pine Motel','76804','171 Park Boulevard,#195',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4576,'Vagabond Inn','79094','92 Valley Square,#10',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4578,'Main Street Station Brewery Hotel','41847','118 Adams Avenue,#106',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4588,'Canifor Hotel','04570','475 West Avenue,#65',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4602,'Amerisuties','10400','223 Green Street,#69',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4609,'Santa Fe Hotel','78021','428 Eighth Avenue,#126',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4614,'Victory Hotel-Motel','76576','69 Miller Boulevard,#152',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4615,'Budget Inn and Suites','37025','235 Smith Street,#2',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4616,'Hilton Malta','22737','412 Smith Walk,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4625,'Fun City Motel','87506','347 South Drive,#7',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4639,'Motel Royal','78330','370 Lakeview Avenue,#169',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4657,'Atlantis Hotel','76824','288 Johnson Place,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4659,'Villa Inn Hotel Motel','88432','116 Sycamore Lane,#132',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4671,'Waterfront Hotel','79546','410 Central Road,#12',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4686,'Yucca Motel','21658','198 Ninth Drive,#178',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4695,'Casablanca Motel','40413','91 Thirteenth Road,#2',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4700,'Hotel Plevna','76889','439 Jackson Walk,#141',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4709,'Bellagio','91346','423 Eleventh Square,#6',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4726,'Grand Flamingo Resort Club','93553','219 Miller St.,#178',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4727,'Rodeway Inn & Suites','76466','392 Central Lane,#23',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4732,'Vegas Motel','77585','364 Willow Walk,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4739,'Golden Nugget Hotel','75446','175 Third Blvd,#139',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4756,'Nellis Lodge Motel','77627','148 Ridge Road,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4768,'Osborne Hotel','57335','281 Green Walk,#47',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4769,'Alpine Apartment Motel','78653','339 Meadow Parkway,#83',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4786,'Fiesta Rancho','78880','454 Franklin Road,#47',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4799,'Greek Isles Hotel','79544','255 Maple Blvd,#120',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4806,'Golden Nugget - Laughlin Hotel','04435','394 Sunset Drive,#185',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4813,'Ninth Street Motel','84774','430 Franklin Parkway,#27',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4816,'Imperial Hotel','77859','285 Wilson Boulevard,#135',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4825,'Peter Pan Motel','75959','391 Center Place,#139',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4845,'Plaza/Plaza Regency Hotel','91776','145 Chestnut Street,#128',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4856,'Center Strip Inn','77876','234 Church Parkway,#123',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4861,'Vacation Village','41348','121 Second Road,#12',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4867,'Aztec Inn','75401','269 Ninth Drive,#122',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4872,'Whiskey Pete''s Hotel','41848','374 Lincoln Square,#140',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4880,'Boby Motel','76034','390 Ninth Blvd,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4886,'Motel Regency','75496','56 Miller Drive,#18',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4900,'Fergusons Motel','75029','362 Adams Walk,#118',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4908,'La Palm Motel','49711','76 Ridge Place,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4910,'Indian Springs Motor Hotel','75376','211 Ridge Road,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4918,'Barcelo Riviera Resort & Spa','75088','215 Dogwood Square,#147',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4929,'Park Hotel','78116','407 Hill Drive,#142',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4946,'Traveler''s Motel','79027','27 Chestnut Square,#132',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4950,'Paradise Bay Hotel','76064','402 Davis Avenue,#67',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4966,'Daisy Motel & Apartments','77960','62 Maple Place,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4968,'Tal Fanal Village','15001','113 Poplar Parkway,#97',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4971,'Crowne Plaza Hotel','77952','54 Lee Blvd,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4980,'Courtyard Las Vegas Green Valley','76890','50 Green Road,#45',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (4994,'Boulder Palms Luxury Suites','76850','488 Central Blvd,#130',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5009,'Jackpot Motel','75783','465 Eleventh Avenue,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5025,'Grand Hotel','58371','354 Center Square,#25',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5042,'Hitchin'' Post','20670','377 Park Drive,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5061,'Sands Motel of Boulder City','76367','380 Birch Avenue,#185',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5072,'Comfort Inn','27565','216 Tenth Lane,#183',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5089,'City Center Motel','22336','96 Fifteenth Avenue,#60',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5107,'The New Alexandra Palace Hotel','76233','84 Willow Ave,#142',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5124,'Bellagio','83441','326 Ninth Square,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5125,'Park Hotel','75972','21 Ash Blvd,#77',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5127,'Ambassador East Motel','18252','163 Walnut Boulevard,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5128,'Glass Pool Inn','79835','160 Thirteenth Drive,#27',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5140,'Thriftlodge Motel','06262','39 Sycamore Avenue,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5142,'Rancho Mesquite Holiday Inn','75561','391 Birch Walk,#61',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5146,'Ambassador East Motel','31801','157 Davis Square,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5161,'Motel Regency','79734','177 Fifteenth St.,#121',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5179,'Laughing Jackalope Motel','79560','404 Sixth Avenue,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5180,'Del Mar Resort Motel','51111','220 Cherry Parkway,#193',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5195,'Dixie Motel','04426','413 Fifth Place,#88',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5205,'Holiday Inn Express Hotel & Suites','75094','93 Willow Lane,#128',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5215,'Thriftlodge Motel','27294','9 Sycamore St.,#101',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5226,'Residence Inn by Marriot','77457','17 Mill St.,#66',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5229,'Grand Hotel','75481','236 Ridge Drive,#39',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5234,'Klondike Inn Hotel','76430','208 Park Place,#62',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5246,'Bourbon Street Hotel','65265','462 Church Street,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5258,'Riverside Resort Hotel','41166','28 Park Ave,#25',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5277,'Motel Regency','15670','461 Fourth Walk,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5282,'Comfort Inn','66086','359 Lake Road,#19',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5299,'Colorado Belle Hotel','79237','368 Willow St.,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5311,'Stateline','72011','314 Sixth Avenue,#53',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5315,'Best Western Main Street Inn','77839','11 Elm St.,#47',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5335,'Crowne Plaza','91386','179 Woodland Blvd,#152',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5341,'Caesars Palace','76019','289 Hill Drive,#34',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5346,'Topaz Hotel & Studios','77231','353 Williams Street,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5355,'Palace Station Hotel','76654','72 Poplar Ave,#82',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5367,'Carriage House','95103','481 Forest Ave,#58',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5380,'Aladdin Resort','35469','62 Taylor Walk,#133',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5394,'Little Hotel','75169','221 Fifteenth Square,#145',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5402,'Normandie Motel','77446','400 River Walk,#38',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5420,'Arizona Charlie''s Boulder','27294','164 Smith Street,#132',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5427,'Texas Station Gambling Hall','10096','226 Lincoln Drive,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5447,'The Strand Apart/Hotel','78943','48 College St.,#109',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5465,'US Motel','78963','76 Park Walk,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5466,'Hampton Inn','13362','476 Poplar Boulevard,#90',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5469,'Grand Flamingo Resort Club','76687','128 View Walk,#103',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5489,'Steven Motel and Apartments','79182','371 Laurel Place,#115',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5497,'Traveler''s Motel','75444','46 Fourteenth Road,#50',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5507,'MGM Grand Hotel','78638','462 Hillcrest Avenue,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5527,'Monterey Motel','75143','446 Pine Ave,#152',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5533,'Convention Center Lodge','72565','29 Hill Parkway,#178',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5542,'La Paloma Apt. Motel','95713','127 Madison Place,#74',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5551,'Pergola Club Hotel & Spa','76640','472 Lee Avenue,#139',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5562,'Kempinski HotelSan Lawrence','76259','81 Pine Boulevard,#4',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5574,'Courtyard By Marriott','79548','90 Franklin Drive,#120',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5583,'Motel Vegas Verdes','78931','6 Broadway Square,#68',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5592,'Walden Motel','46001','295 Spruce Blvd,#120',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5599,'Bay Street Hotel','39535','497 College Lane,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5619,'Dolmen Resort Hotel','78655','164 Main Street,#197',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5627,'Knotty Pine Motel','65647','113 Taylor Parkway,#2',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5637,'US Motel','16216','151 Broadway Avenue,#39',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5654,'Radisson SAS Golden Sands Resort & Spa','15776','139 Third Drive,#199',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5658,'Grand Hotel Mercure Selmun Palace','67752','452 Davis Place,#114',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5670,'Qawra Palace Hotel','75401','385 Maple Boulevard,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5671,'Sunrise Vista Executive Suites','81223','12 Lincoln Road,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5684,'Park Hotel','77423','162 Smith Lane,#83',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5692,'Comfort Inn','70517','64 Sycamore Square,#152',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5704,'Fortina Hotel','53036','136 Lake Walk,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5714,'Orleans Hotel','75368','291 Second Square,#3',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5733,'Pioneer Hotel & Gambling Hall','77460','23 Maple Walk,#154',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5749,'Hop''s Motel','64862','398 Thirteenth Lane,#83',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5758,'Edgewater Hotel','77856','480 Seventh Ave,#161',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5771,'Calypso Hotel','52060','305 Forest Drive,#33',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5775,'Best Western Main Street Inn','40546','197 Birch Walk,#137',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5785,'Hotel Juliani','77572','256 Poplar Avenue,#93',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5796,'Longhorn Hotel','78012','390 Birch Avenue,#110',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5813,'Best Western Lighthouse','18032','432 Maple Ave,#3',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5828,'Grand Hotel','76444','80 Hickory Drive,#52',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5843,'Park Hotel','75762','26 Ridge Ave,#47',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5861,'King Albert Motel','75779','350 Eleventh Drive,#88',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5864,'Corinthia San Gorg','76886','54 Ash Place,#119',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5876,'Western Hotel','78954','302 Sixth Road,#57',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5881,'Uptown Motel','79220','298 Sixth Parkway,#11',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5897,'El Cortez Hotel','52322','448 Fifth Drive,#46',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5909,'Budget Suites Of America','75064','88 Broadway Lane,#128',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5929,'Daisy Motel & Apartments','78379','187 Johnson Drive,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5942,'Stateline','71832','122 Church St.,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5949,'Super 8 Motel','40555','20 College Boulevard,#40',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5964,'Walden Motel','23089','68 East Avenue,#143',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5967,'HomeGate Studios & Suites','69151','135 College Place,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5968,'Casa Malaga Motel','52001','64 Green Place,#56',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5980,'Fairfield Inn By Marriott','61334','79 Second Place,#86',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (5997,'Ingle''s Motel','75558','203 Davis Ave,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6006,'Silver Spur Hotel','79121','362 Birch Ave,#35',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6022,'Park Hotel','68776','139 Jefferson Parkway,#101',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6024,'Motel 6 - Tropicana','17561','114 Taylor Square,#77',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6038,'Travel Inn Motel','17882','286 College Square,#107',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6041,'Jackpot Motel','76050','104 Woodland Walk,#127',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6052,'New York-New York Hotel','95971','62 Johnson Boulevard,#102',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6061,'Qawra Palace Hotel','79377','177 Eighth Street,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6078,'The New Alexandra Palace Hotel','78463','248 Fifteenth Ave,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6089,'Diamond Inn Motel','76950','196 Main Drive,#189',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6104,'Amerisuties','15555','327 Sixth Square,#90',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6107,'Excalibur Hotel','40516','449 Jackson Place,#66',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6115,'Capri Motel','79096','285 Fifth Street,#177',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6121,'Fiesta Henderson','90101','187 East Square,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6137,'Westin Dragonara Resort','93456','150 Highland Ave,#89',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6146,'Karanne Hotel & Suites','77263','468 Hickory Walk,#141',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6149,'Tuscany Hotel','75657','98 Ridge Walk,#99',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6159,'Mandalay Bay','78557','334 Sixth Place,#65',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6165,'St. Tropez All Suite Hotel','78579','472 Highland Place,#15',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6180,'Valley Inn Motel','91346','286 Ridge Road,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6191,'Royal Hotel','75928','269 Hickory Lane,#176',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6199,'Gold Spike Hotel','78648','365 Railroad Place,#156',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6206,'Bay Street Hotel','75095','95 Ash Avenue,#150',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6216,'E-Z 8 Motel','36026','112 North Parkway,#168',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6235,'El Cortez Hotel','76050','413 Park Boulevard,#11',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6242,'City Center Motel','78938','471 First Avenue,#46',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6260,'Henderson Courtyard','75766','444 Twelfth Parkway,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6264,'Best Western Lake Mead','53089','248 Tenth St.,#136',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6275,'Purple Sage Motel','76461','350 First Drive,#143',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6279,'Motel 4 Kings','75966','242 Central St.,#22',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6298,'City Center Motel','77578','8 West Ave,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6312,'Fez Motel','79527','224 Center Place,#123',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6316,'Hotel Juliani','75065','183 Fourth Street,#118',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6317,'Palace Station Hotel','76465','491 Mill Avenue,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6328,'Motel 4 Kings','28784','183 Cherry Avenue,#49',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6334,'Thunderbird Hotel','52555','116 Eleventh Walk,#28',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6342,'Casa Malaga Motel','95971','201 Smith St.,#67',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6351,'Flamingo Laughlin','40432','111 Eleventh Walk,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6365,'Calypso Hotel','93111','298 Center Place,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6369,'El Rancho Boulder Motel','77660','248 First Walk,#39',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6383,'Super 8 Motel at Nellis AFB','78107','139 Walnut Avenue,#191',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6401,'Motel Vegas Verdes','51545','266 Center Avenue,#122',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6409,'Le Meridien Phoenicia Hotel','76513','185 Twelfth Drive,#40',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6411,'Howard Johnson - Strip','94146','347 Jackson Avenue,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6414,'Four Seasons Hotel','75095','417 Railroad Street,#168',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6433,'Kennedy Nova Hotel','19341','385 Mill Place,#37',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6447,'Topaz Hotel & Studios','75169','366 Ninth Street,#133',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6467,'Imperial Motel','65439','450 Tenth Drive,#91',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6477,'Imperial Hotel','76517','126 Madison Walk,#125',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6487,'Del Mar Resort Motel','75846','416 Eighth Avenue,#187',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6494,'Holiday Inn - Emerald Springs','79520','157 Fifth Walk,#38',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6512,'Grand Hotel Mercure Selmun Palace','77533','101 Ninth Walk,#72',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6530,'Dixie Motel','50070','419 Woodland Boulevard,#142',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6548,'Great Western Hotel','81223','358 Third Parkway,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6563,'Imperial Hotel','79052','241 Jefferson Lane,#136',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6572,'Best Western Nellis Motor Inn','20670','380 Oak Parkway,#188',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6590,'Tal Fanal Village','95543','141 Spruce Drive,#55',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6608,'Imperial Motel','79932','49 Seventh Square,#64',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6627,'La Quinta Inn - Strip','94171','319 Smith Boulevard,#113',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6644,'Nevada Palace Hotel','79032','87 Meadow Boulevard,#8',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6656,'Pioneer Hotel & Gambling Hall','77574','27 Mill Avenue,#12',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6676,'Grand Hotel','79338','246 Ash Drive,#160',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6686,'Vegas Motel','78162','39 First Place,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6698,'Paradise Resort Inn','78644','231 Lake Avenue,#190',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6712,'El Rancho Boulder Motel','78769','250 Tenth Ave,#104',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6724,'High Hat Regency Regency','79005','485 Spruce Walk,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6737,'Best Western Main Street Inn','46374','24 Green Drive,#50',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6754,'Atlantis Hotel','78151','100 Lakeview Parkway,#53',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6756,'Grand Hotel Mercure San Antonio','75778','53 Spring Square,#199',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6766,'Capri Motel','94960','466 Walnut Parkway,#21',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6780,'Osborne Hotel','76043','209 Franklin Boulevard,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6797,'Silverton Hotel','77660','131 Davis Lane,#72',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6799,'Tod Motor Motel','46374','181 Fourth Blvd,#106',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6803,'Starview Motel','76035','75 Mill Drive,#29',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6822,'Gold Spike Hotel','79061','378 Jackson Lane,#19',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6829,'Motel Royal','75556','454 First Walk,#36',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6843,'Pioneer Hotel & Gambling Hall','76871','29 Pine Square,#162',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6845,'Osborne Hotel','79517','27 Main Parkway,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6859,'Blue Angel Motel','76634','308 Mill Blvd,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6863,'Valley Motel','79311','309 Hickory Place,#92',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6881,'Comfort Inn','78670','79 Washington Drive,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6897,'Great Western Hotel','77396','377 West Avenue,#6',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6898,'Best Western Lighthouse','75431','154 Lee St.,#73',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6915,'City Center Motel','76448','225 Williams Ave,#115',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6926,'Treasure Island','56502','280 Thirteenth Blvd,#158',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6927,'Nellis Lodge Motel','10282','294 West Street,#185',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6936,'Travel Inn Motel','77880','380 Poplar Road,#61',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6952,'Villa Roma Motel','75277','206 Church Square,#109',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6953,'Hotel Juliani','01885','59 South Blvd,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6970,'Virgin River Hotel','72002','181 Eighth St.,#22',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6989,'Boulder Station Hotel','13362','74 Sycamore Avenue,#161',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (6998,'Courtyard Las Vegas Green Valley','75118','405 North Walk,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7017,'Best View Parkview Inn','94964','362 Central Ave,#10',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7022,'Econo Lodge - Downtown','91773','460 Sunset Place,#175',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7029,'Holiday Royale','77293','130 Center Ave,#122',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7038,'Budget Inn and Suites','79066','116 Chestnut Parkway,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7049,'Virgin River Hotel','75658','56 Tenth St.,#38',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7061,'Park Hotel','76680','404 Lakeview Avenue,#173',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7070,'Boulder Palms Luxury Suites','76519','363 Johnson Avenue,#45',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7077,'Airport Inn','63430','466 Sunset Place,#76',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7087,'Atlantis Hotel','41166','34 Church Street,#91',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7097,'Pergola Club Hotel & Spa','77837','226 Ridge Place,#86',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7115,'Somerset House Motel','76443','271 East Place,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7131,'Bugibba Holiday Complex','79087','252 Hill Drive,#69',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7139,'Del Mar Resort Motel','93620','33 Ninth Square,#153',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7148,'Bay Shore Inn','76567','405 Forest St.,#121',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7157,'Desert Moon Motel','15870','112 Walnut Avenue,#78',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7167,'Crowne Plaza','04770','210 Hill Lane,#165',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7179,'Desert Palms Motel','72051','469 Maple Parkway,#164',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7191,'Grand Hotel','00922','76 Twelfth St.,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7202,'Starlite Motel','76649','115 View Ave,#35',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7211,'Travelodge South Strip','87510','319 Fourteenth Street,#180',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7226,'Motel Royal','28378','437 Fourth Lane,#9',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7234,'Comfort Inn','00618','449 Twelfth Street,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7249,'Venetian Resort Hotel','76508','413 Meadow Square,#122',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7261,'Purple Sage Motel','75005','284 Walnut Blvd,#2',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7268,'Golden Nugget Hotel','79124','316 Franklin Parkway,#4',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7270,'Lucky Lady Motel','78714','141 Cherry Street,#162',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7284,'Lee Motel','68982','424 Chestnut St.,#56',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7290,'Hilton Grand Vacations Club at the LV Strip','77333','469 Woodland Avenue,#129',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7294,'Starview Motel','79838','240 Second Ave,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7304,'Canifor Hotel','38655','83 Broadway Walk,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7312,'Gateway Motel','75003','162 Lee Street,#111',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7317,'Golden Inn Motel','77335','81 Sycamore Drive,#117',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7332,'Alpine Apartment Motel','93660','90 Fourteenth Street,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7342,'Golden City Motel','77350','343 Adams Walk,#143',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7356,'Fairfield Inn By Marriott','04764','269 Wilson Ave,#124',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7361,'Downtowner Budget Apt. Motel','75975','223 Lee Avenue,#129',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7365,'Imperial Hotel','19026','269 Miller Street,#157',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7384,'Lucky Lady Motel','97109','164 Sycamore Lane,#180',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7388,'Grand Hotel Mercure San Antonio','79713','298 Twelfth Boulevard,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7399,'Alexis Park Resort','77376','210 Pine Parkway,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7416,'Silver Sands Motel','79786','44 Cherry Place,#194',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7430,'Little Hotel','63430','150 Fifth Lane,#51',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7441,'Pergola Club Hotel & Spa','75681','31 Ash Lane,#111',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7450,'Flamingo Laughlin','76874','131 Meadow Square,#18',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7458,'Howard Johnson Hotel','97624','3 Walnut Street,#176',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7478,'Tropicana Resort','77803','122 River Ave,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7486,'La Paloma Apt. Motel','75497','313 Sycamore Drive,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7496,'Bay Street Hotel','77389','270 College Avenue,#139',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7506,'Mesquite Springs Motel','77328','469 Hickory St.,#184',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7522,'Western Hotel','75980','117 North Parkway,#151',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7524,'Palace Station Hotel','59521','368 Lake Ave,#174',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7539,'Royal Manor','77563','146 West Lane,#119',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7541,'Boulder Dam Hotel - Bed & Breakfast','14507','489 College Parkway,#82',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7550,'Branding Iron Motel','63373','468 Central Drive,#6',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7556,'Nevada Landing Hotel','78360','144 Lake Walk,#55',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7560,'Courtyard Las Vegas Green Valley','93620','215 Lee Walk,#106',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7574,'Hotel Juliani','76864','243 Dogwood Avenue,#109',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7577,'Villa Inn Hotel Motel','76685','302 Madison Road,#110',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7579,'Villa Inn Hotel Motel','04558','300 Twelfth Drive,#167',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7580,'Ambassador East Motel','25180','286 Oak St.,#99',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7584,'Downtowner Budget Apt. Motel','75479','346 Eleventh Walk,#165',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7599,'Four Queens Hotel','75660','315 Valley Place,#100',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7616,'French Quarter Suites','00754','232 Broadway Street,#103',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7628,'Binion''s Gambling Hall and Hotel','75148','457 Madison Place,#18',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7633,'Beverly Palms Hotel','78861','36 Maple Blvd,#42',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7641,'HomeGate Studios & Suites','76935','384 Elm Street,#180',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7651,'Carolina Hotel','75444','367 Willow Ave,#31',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7671,'Silver Sands Motel','22039','13 Green Lane,#74',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7686,'Best Western McCarran Inn','78419','90 Railroad Lane,#161',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7700,'Hialeah Motel','78568','468 Washington Boulevard,#193',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7715,'Somerset House Motel','79368','423 First Road,#14',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7725,'Nellis Lodge Motel','75143','315 Taylor Place,#175',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7731,'Ninth Street Motel','77979','191 Ridge Square,#138',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7732,'Cimmaron Motel','49876','183 Eighth Road,#184',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7752,'Motel 6 - Southeast','76670','90 Laurel Drive,#58',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7764,'Ta''Cenc Hotel','81223','302 Meadow Drive,#99',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7782,'La Quinta Inn - Northwest Tech Center','63377','167 Sycamore Road,#58',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7784,'Santa Fe Hotel','79053','240 East Street,#54',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7804,'La Vallette Resort','76022','11 Jefferson Boulevard,#70',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7812,'Tuscany Hotel','75935','96 East Blvd,#59',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7827,'Silverton Hotel','75559','417 Jefferson Avenue,#123',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7829,'Stardust Resort','76033','117 Second St.,#156',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7830,'Ta''Cenc Hotel','76580','199 Spring Street,#153',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7840,'City Center Motel','78543','229 Lakeview Avenue,#41',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7853,'Park Hotel','27340','322 Sycamore Walk,#159',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7861,'Royal Hotel','75766','302 Miller Ave,#26',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7864,'Fortina Hotel','79073','206 College Square,#84',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7868,'Best Western Mardi Gras Inn','77536','242 Sunset St.,#94',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7879,'El Cortez Hotel','12008','73 Railroad Square,#123',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7885,'Ambassador East Motel','75959','253 Sycamore Blvd,#8',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7896,'Arizona Charlie''s Boulder','77423','441 East Street,#100',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7899,'Suncoast Hotel','76906','363 Highland Road,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7907,'Golden City Motel','28378','12 Ridge Boulevard,#159',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7920,'Imperial Hotel','79547','457 College Boulevard,#85',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7921,'Silver Sands Motel','77475','333 Cherry Square,#166',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7924,'Grand Hotel','78945','419 Twelfth Street,#199',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7929,'Grand Hotel','26810','409 Jackson Boulevard,#163',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7942,'Boulder Palms Luxury Suites','77831','419 College Street,#123',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7961,'Rancho Mesquite Holiday Inn','75929','445 Elm Parkway,#128',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7975,'Comfort Inn','75077','316 Spring St.,#71',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7977,'King Albert Motel','78125','51 East Square,#149',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7993,'Bonanza Lodge Motel','75138','130 Franklin Street,#120',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (7997,'Super 8 Motel','10286','445 Fifteenth Drive,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8004,'Bonnie Springs Motel','57107','478 Woodland Place,#25',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8019,'Vegas Chalet Motel','76371','190 Mill Parkway,#54',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8034,'Jackpot Motel','75009','84 Elm Blvd,#154',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8039,'Villa Inn Hotel Motel','79111','280 Seventh Street,#129',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8041,'Bourbon Street Hotel','76877','419 Madison Place,#196',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8047,'Riviera Hotel','79506','419 Mill Boulevard,#3',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8066,'Pergola Club Hotel & Spa','66528','161 Spring Blvd,#63',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8081,'Desert Palms Motel','78588','17 Jefferson Ave,#98',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8088,'Flamingo Laughlin','83534','378 Eleventh Street,#168',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8100,'La Vallette Resort','78828','361 View Boulevard,#49',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8118,'Cannery Hotel','75969','257 Mill Boulevard,#143',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8138,'Maritim Antonine Hotel & Spa','75138','191 Fourteenth Blvd,#16',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8148,'Barcelona Hotel','81153','341 Dogwood Ave,#30',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8158,'Yucca Motel','75154','465 Johnson Place,#42',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8163,'The Strand Apart/Hotel','76853','310 Valley Lane,#200',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8167,'Daisy Motel & Apartments','20653','295 Center Street,#187',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO hotel VALUES (8168,'Monte Carlo Resort','75478','148 Valley Square,#130',NULL)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (141,'single',78,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (141,'double',128,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (149,'single',190,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (149,'double',76,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (163,'single',187,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (163,'double',240,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (163,'suite',97,334.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (175,'single',84,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (175,'double',21,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (175,'suite',34,316.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (177,'single',168,87.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (177,'double',142,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (177,'suite',22,256.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (187,'single',83,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (187,'double',75,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (187,'suite',76,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (201,'single',143,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (201,'double',125,248.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (213,'single',122,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (213,'double',295,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (213,'suite',33,197.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (231,'single',151,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (231,'double',275,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (246,'single',98,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (246,'double',282,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (246,'suite',80,373.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (248,'single',110,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (248,'double',50,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (248,'suite',81,401.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (262,'single',104,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (262,'double',113,195.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (262,'suite',46,370.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (268,'single',103,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (268,'double',286,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (284,'single',169,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (284,'double',39,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (297,'single',182,61.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (297,'double',64,160.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (297,'suite',23,470.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (311,'single',171,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (311,'double',181,188.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (324,'single',35,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (324,'double',153,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (324,'suite',74,431.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (342,'single',157,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (342,'double',101,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (345,'single',111,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (345,'double',150,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (345,'suite',33,374.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (363,'single',96,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (363,'double',28,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (382,'single',155,96.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (382,'double',264,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (382,'suite',83,453.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (401,'single',80,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (401,'double',95,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (407,'single',184,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (407,'double',135,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (407,'suite',68,238.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (408,'single',119,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (408,'double',143,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (408,'suite',38,292.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (426,'single',34,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (426,'double',278,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (430,'single',83,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (430,'double',127,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (448,'single',97,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (448,'double',126,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (448,'suite',80,479.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (449,'single',42,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (449,'double',244,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (449,'suite',27,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (461,'single',133,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (461,'double',135,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (468,'single',164,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (468,'double',72,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (474,'single',147,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (474,'double',92,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (479,'single',151,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (479,'double',152,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (479,'suite',35,285.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (489,'single',179,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (489,'double',256,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (489,'suite',45,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (495,'single',127,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (495,'double',290,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (495,'suite',63,211.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (508,'single',137,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (508,'double',50,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (518,'single',43,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (518,'double',264,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (518,'suite',94,292.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (520,'single',104,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (520,'double',33,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (534,'single',196,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (534,'double',76,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (551,'single',43,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (551,'double',23,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (561,'single',73,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (561,'double',65,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (561,'suite',77,331.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (569,'single',29,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (569,'double',168,199.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (587,'single',172,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (587,'double',166,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (587,'suite',34,347.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (606,'single',89,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (606,'double',175,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (612,'single',186,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (612,'double',173,220.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (628,'single',105,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (628,'double',318,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (628,'suite',98,334.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (631,'single',71,88.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (631,'double',75,167.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (642,'single',87,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (642,'double',43,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (650,'single',162,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (650,'double',241,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (653,'single',108,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (653,'double',243,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (657,'single',22,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (657,'double',132,220.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (660,'single',20,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (660,'double',87,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (660,'suite',82,403.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (664,'single',164,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (664,'double',93,214.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (669,'single',61,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (669,'double',75,173.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (681,'single',41,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (681,'double',36,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (682,'single',62,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (682,'double',228,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (695,'single',27,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (695,'double',78,212.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (714,'single',148,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (714,'double',105,189.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (718,'single',85,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (718,'double',238,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (732,'single',168,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (732,'double',225,207.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (732,'suite',46,444.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (741,'single',186,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (741,'double',312,174.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (751,'single',107,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (751,'double',268,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (766,'single',178,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (766,'double',305,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (766,'suite',69,454.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (780,'single',131,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (780,'double',236,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (782,'single',89,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (782,'double',132,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (782,'suite',75,455.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (786,'single',103,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (786,'double',124,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (791,'single',21,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (791,'double',135,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (791,'suite',77,466.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (796,'single',55,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (796,'double',77,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (796,'suite',49,263.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (800,'single',127,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (800,'double',237,235.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (800,'suite',36,252.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (806,'single',42,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (806,'double',187,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (813,'single',138,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (813,'double',119,178.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (813,'suite',67,344.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (824,'single',20,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (824,'double',84,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (824,'suite',67,269.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (831,'single',198,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (831,'double',157,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (831,'suite',38,215.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (843,'single',112,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (843,'double',288,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (843,'suite',63,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (860,'single',128,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (860,'double',237,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (860,'suite',55,395.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (861,'single',31,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (861,'double',248,176.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (861,'suite',24,227.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (862,'single',34,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (862,'double',150,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (862,'suite',69,370.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (863,'single',58,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (863,'double',126,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (878,'single',42,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (878,'double',126,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (878,'suite',84,458.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (895,'single',35,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (895,'double',123,186.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (895,'suite',57,440.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (913,'single',199,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (913,'double',127,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (913,'suite',40,273.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (919,'single',58,95.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (919,'double',215,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (919,'suite',69,358.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (921,'single',44,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (921,'double',296,227.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (937,'single',102,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (937,'double',178,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (946,'single',58,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (946,'double',306,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (946,'suite',38,370.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (964,'single',199,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (964,'double',263,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (964,'suite',40,316.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (972,'single',55,95.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (972,'double',271,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (982,'single',184,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (982,'double',116,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1001,'single',80,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1001,'double',305,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1001,'suite',45,328.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1021,'single',106,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1021,'double',160,235.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1039,'single',135,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1039,'double',120,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1039,'suite',90,416.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1049,'single',137,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1049,'double',272,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1055,'single',136,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1055,'double',185,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1055,'suite',34,336.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1061,'single',108,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1061,'double',57,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1061,'suite',75,399.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1070,'single',189,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1070,'double',134,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1077,'single',181,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1077,'double',284,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1077,'suite',74,306.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1096,'single',38,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1096,'double',255,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1102,'single',160,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1102,'double',29,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1103,'single',77,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1103,'double',277,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1103,'suite',61,269.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1120,'single',149,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1120,'double',170,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1130,'single',136,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1130,'double',206,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1149,'single',92,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1149,'double',140,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1166,'single',176,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1166,'double',292,201.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1166,'suite',28,473.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1175,'single',31,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1175,'double',80,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1175,'suite',77,346.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1195,'single',131,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1195,'double',174,212.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1195,'suite',52,310.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1196,'single',140,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1196,'double',293,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1197,'single',134,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1197,'double',224,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1206,'single',73,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1206,'double',267,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1206,'suite',82,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1214,'single',189,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1214,'double',26,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1220,'single',172,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1220,'double',24,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1226,'single',188,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1226,'double',270,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1226,'suite',35,199.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1239,'single',45,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1239,'double',34,160.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1239,'suite',59,276.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1253,'single',62,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1253,'double',56,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1254,'single',37,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1254,'double',46,204.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1261,'single',114,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1261,'double',274,211.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1261,'suite',68,372.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1270,'single',147,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1270,'double',133,166.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1285,'single',26,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1285,'double',166,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1294,'single',30,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1294,'double',173,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1294,'suite',34,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1300,'single',23,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1300,'double',85,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1300,'suite',26,361.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1320,'single',121,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1320,'double',176,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1320,'suite',24,271.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1334,'single',176,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1334,'double',279,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1334,'suite',33,371.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1342,'single',21,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1342,'double',46,216.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1360,'single',49,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1360,'double',108,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1372,'single',69,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1372,'double',137,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1385,'single',47,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1385,'double',316,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1385,'suite',58,286.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1399,'single',157,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1399,'double',309,214.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1399,'suite',77,318.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1400,'single',24,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1400,'double',71,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1406,'single',126,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1406,'double',57,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1411,'single',153,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1411,'double',128,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1411,'suite',31,279.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1413,'single',110,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1413,'double',116,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1427,'single',55,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1427,'double',237,179.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1427,'suite',32,256.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1437,'single',108,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1437,'double',268,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1449,'single',129,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1449,'double',89,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1452,'single',45,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1452,'double',235,176.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1456,'single',127,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1456,'double',253,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1468,'single',114,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1468,'double',69,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1488,'single',138,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1488,'double',107,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1495,'single',135,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1495,'double',214,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1500,'single',170,93.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1500,'double',156,170.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1510,'single',90,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1510,'double',263,175.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1510,'suite',79,347.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1515,'single',137,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1515,'double',274,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1524,'single',128,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1524,'double',234,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1524,'suite',42,476.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1533,'single',126,93.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1533,'double',181,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1533,'suite',56,454.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1549,'single',31,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1549,'double',245,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1549,'suite',98,462.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1553,'single',103,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1553,'double',314,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1570,'single',168,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1570,'double',95,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1582,'single',158,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1582,'double',27,189.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1582,'suite',72,329.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1592,'single',52,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1592,'double',295,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1592,'suite',22,365.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1596,'single',50,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1596,'double',204,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1596,'suite',91,319.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1610,'single',191,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1610,'double',283,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1626,'single',37,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1626,'double',158,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1631,'single',44,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1631,'double',89,167.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1645,'single',100,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1645,'double',107,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1661,'single',35,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1661,'double',112,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1661,'suite',29,317.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1670,'single',167,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1670,'double',122,192.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1685,'single',26,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1685,'double',72,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1685,'suite',98,443.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1689,'single',119,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1689,'double',244,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1689,'suite',87,342.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1709,'single',168,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1709,'double',319,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1711,'single',45,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1711,'double',87,179.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1711,'suite',41,404.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1724,'single',44,74.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1724,'double',55,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1724,'suite',30,338.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1735,'single',136,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1735,'double',35,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1740,'single',69,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1740,'double',35,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1741,'single',181,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1741,'double',313,169.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1743,'single',97,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1743,'double',253,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1743,'suite',44,327.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1757,'single',142,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1757,'double',319,204.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1761,'single',145,90.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1761,'double',280,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1772,'single',73,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1772,'double',199,173.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1774,'single',40,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1774,'double',42,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1774,'suite',69,218.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1786,'single',113,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1786,'double',277,216.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1786,'suite',39,259.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1790,'single',78,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1790,'double',250,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1790,'suite',74,292.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1799,'single',86,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1799,'double',65,240.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1811,'single',53,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1811,'double',249,194.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1811,'suite',59,186.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1817,'single',103,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1817,'double',71,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1833,'single',104,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1833,'double',223,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1833,'suite',49,478.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1841,'single',169,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1841,'double',294,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1847,'single',152,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1847,'double',279,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1853,'single',57,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1853,'double',127,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1863,'single',173,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1863,'double',170,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1863,'suite',37,310.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1879,'single',125,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1879,'double',299,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1879,'suite',93,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1891,'single',166,61.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1891,'double',232,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1891,'suite',64,329.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1901,'single',157,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1901,'double',259,246.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1901,'suite',97,239.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1919,'single',196,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1919,'double',142,162.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1939,'single',74,95.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1939,'double',32,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1939,'suite',64,342.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1955,'single',37,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1955,'double',82,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1955,'suite',72,298.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1971,'single',90,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1971,'double',206,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1987,'single',25,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (1987,'double',129,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2001,'single',164,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2001,'double',71,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2021,'single',188,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2021,'double',292,220.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2021,'suite',25,265.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2026,'single',40,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2026,'double',168,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2026,'suite',41,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2028,'single',143,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2028,'double',244,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2038,'single',159,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2038,'double',84,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2038,'suite',65,360.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2039,'single',120,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2039,'double',256,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2039,'suite',20,463.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2053,'single',181,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2053,'double',277,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2053,'suite',74,264.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2067,'single',163,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2067,'double',119,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2067,'suite',25,463.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2076,'single',125,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2076,'double',110,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2093,'single',176,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2093,'double',189,216.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2093,'suite',84,363.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2105,'single',54,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2105,'double',131,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2106,'single',49,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2106,'double',105,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2125,'single',150,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2125,'double',222,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2125,'suite',79,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2133,'single',156,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2133,'double',253,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2133,'suite',68,254.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2140,'single',90,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2140,'double',44,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2150,'single',108,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2150,'double',149,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2164,'single',132,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2164,'double',20,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2164,'suite',46,443.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2180,'single',84,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2180,'double',291,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2181,'single',39,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2181,'double',50,179.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2182,'single',130,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2182,'double',107,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2182,'suite',97,397.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2185,'single',170,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2185,'double',153,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2200,'single',118,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2200,'double',107,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2209,'single',146,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2209,'double',197,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2209,'suite',20,390.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2212,'single',134,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2212,'double',44,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2215,'single',133,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2215,'double',41,222.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2225,'single',122,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2225,'double',162,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2228,'single',108,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2228,'double',263,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2231,'single',77,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2231,'double',249,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2231,'suite',42,222.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2246,'single',191,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2246,'double',274,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2246,'suite',88,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2254,'single',76,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2254,'double',269,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2274,'single',141,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2274,'double',55,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2274,'suite',85,317.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2289,'single',56,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2289,'double',27,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2302,'single',135,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2302,'double',189,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2307,'single',197,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2307,'double',29,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2309,'single',129,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2309,'double',234,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2309,'suite',98,321.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2319,'single',111,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2319,'double',115,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2322,'single',198,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2322,'double',274,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2331,'single',93,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2331,'double',55,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2337,'single',121,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2337,'double',38,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2355,'single',118,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2355,'double',308,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2355,'suite',47,389.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2357,'single',182,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2357,'double',100,239.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2362,'single',61,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2362,'double',250,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2368,'single',161,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2368,'double',156,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2382,'single',74,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2382,'double',112,173.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2382,'suite',69,391.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2394,'single',142,90.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2394,'double',168,203.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2394,'suite',88,313.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2408,'single',82,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2408,'double',251,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2418,'single',91,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2418,'double',85,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2418,'suite',88,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2431,'single',169,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2431,'double',193,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2434,'single',175,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2434,'double',272,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2452,'single',118,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2452,'double',107,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2452,'suite',40,306.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2456,'single',166,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2456,'double',271,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2456,'suite',83,401.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2458,'single',126,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2458,'double',157,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2459,'single',179,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2459,'double',167,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2478,'single',77,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2478,'double',91,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2481,'single',87,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2481,'double',151,225.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2481,'suite',49,445.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2486,'single',159,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2486,'double',64,194.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2486,'suite',40,449.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2491,'single',108,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2491,'double',100,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2511,'single',196,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2511,'double',120,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2517,'single',106,87.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2517,'double',169,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2517,'suite',72,306.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2536,'single',80,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2536,'double',205,227.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2537,'single',153,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2537,'double',191,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2552,'single',189,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2552,'double',302,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2552,'suite',42,189.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2565,'single',121,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2565,'double',24,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2565,'suite',44,368.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2567,'single',137,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2567,'double',261,219.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2567,'suite',31,415.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2574,'single',24,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2574,'double',290,182.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2574,'suite',41,267.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2580,'single',70,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2580,'double',107,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2589,'single',66,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2589,'double',75,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2589,'suite',30,376.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2608,'single',118,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2608,'double',89,203.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2608,'suite',96,427.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2618,'single',99,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2618,'double',109,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2629,'single',24,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2629,'double',212,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2629,'suite',75,324.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2631,'single',65,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2631,'double',137,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2631,'suite',85,373.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2640,'single',118,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2640,'double',58,246.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2648,'single',101,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2648,'double',202,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2665,'single',138,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2665,'double',277,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2665,'suite',76,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2681,'single',26,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2681,'double',205,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2681,'suite',95,354.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2684,'single',102,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2684,'double',285,167.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2693,'single',79,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2693,'double',105,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2709,'single',186,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2709,'double',79,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2717,'single',182,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2717,'double',152,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2717,'suite',99,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2724,'single',46,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2724,'double',242,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2736,'single',121,66.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2736,'double',46,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2736,'suite',83,298.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2752,'single',47,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2752,'double',96,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2752,'suite',82,361.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2761,'single',47,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2761,'double',71,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2764,'single',198,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2764,'double',145,207.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2779,'single',133,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2779,'double',223,162.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2779,'suite',37,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2792,'single',109,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2792,'double',226,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2792,'suite',63,441.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2808,'single',33,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2808,'double',186,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2828,'single',185,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2828,'double',207,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2828,'suite',77,350.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2839,'single',50,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2839,'double',163,235.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2850,'single',125,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2850,'double',204,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2864,'single',125,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2864,'double',198,166.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2864,'suite',66,458.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2876,'single',159,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2876,'double',257,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2885,'single',104,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2885,'double',312,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2892,'single',63,117.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2892,'double',246,165.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2892,'suite',80,421.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2908,'single',83,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2908,'double',207,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2925,'single',178,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2925,'double',175,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2944,'single',21,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2944,'double',299,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2944,'suite',86,407.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2954,'single',75,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2954,'double',182,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2966,'single',46,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2966,'double',75,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2984,'single',77,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2984,'double',45,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2984,'suite',57,400.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2994,'single',87,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2994,'double',74,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2996,'single',176,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2996,'double',140,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2996,'suite',91,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2998,'single',183,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (2998,'double',23,248.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3001,'single',62,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3001,'double',305,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3001,'suite',70,474.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3013,'single',46,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3013,'double',123,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3015,'single',129,95.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3015,'double',86,219.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3015,'suite',87,471.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3034,'single',64,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3034,'double',101,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3050,'single',113,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3050,'double',46,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3050,'suite',90,352.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3070,'single',89,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3070,'double',100,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3088,'single',137,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3088,'double',62,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3094,'single',132,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3094,'double',51,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3100,'single',184,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3100,'double',47,186.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3114,'single',47,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3114,'double',316,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3130,'single',63,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3130,'double',140,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3140,'single',178,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3140,'double',60,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3140,'suite',79,402.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3142,'single',139,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3142,'double',88,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3142,'suite',86,339.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3159,'single',85,88.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3159,'double',66,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3159,'suite',66,257.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3178,'single',132,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3178,'double',186,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3178,'suite',66,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3185,'single',148,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3185,'double',98,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3185,'suite',76,386.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3188,'single',163,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3188,'double',66,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3188,'suite',40,434.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3208,'single',151,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3208,'double',56,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3219,'single',188,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3219,'double',46,216.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3236,'single',143,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3236,'double',47,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3256,'single',170,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3256,'double',198,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3264,'single',20,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3264,'double',211,194.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3269,'single',57,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3269,'double',29,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3269,'suite',65,379.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3281,'single',139,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3281,'double',137,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3281,'suite',36,405.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3288,'single',51,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3288,'double',75,192.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3288,'suite',59,336.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3289,'single',48,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3289,'double',107,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3298,'single',185,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3298,'double',84,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3298,'suite',48,322.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3311,'single',68,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3311,'double',27,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3311,'suite',79,419.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3324,'single',57,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3324,'double',216,170.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3324,'suite',65,448.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3344,'single',89,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3344,'double',29,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3354,'single',127,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3354,'double',265,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3354,'suite',91,358.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3357,'single',75,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3357,'double',313,246.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3357,'suite',30,273.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3376,'single',46,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3376,'double',60,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3393,'single',70,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3393,'double',243,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3407,'single',194,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3407,'double',315,166.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3407,'suite',60,359.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3420,'single',22,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3420,'double',113,173.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3426,'single',63,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3426,'double',183,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3426,'suite',95,406.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3441,'single',21,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3441,'double',190,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3441,'suite',59,293.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3452,'single',81,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3452,'double',148,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3468,'single',195,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3468,'double',197,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3468,'suite',71,386.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3482,'single',190,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3482,'double',179,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3482,'suite',28,442.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3485,'single',90,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3485,'double',266,246.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3491,'single',194,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3491,'double',21,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3496,'single',118,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3496,'double',38,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3500,'single',125,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3500,'double',187,246.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3519,'single',65,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3519,'double',72,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3522,'single',149,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3522,'double',189,207.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3522,'suite',51,209.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3535,'single',114,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3535,'double',308,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3535,'suite',94,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3546,'single',94,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3546,'double',214,219.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3554,'single',150,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3554,'double',305,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3554,'suite',74,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3560,'single',156,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3560,'double',44,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3560,'suite',68,268.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3574,'single',93,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3574,'double',216,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3574,'suite',65,449.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3589,'single',129,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3589,'double',58,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3595,'single',181,95.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3595,'double',184,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3595,'suite',58,248.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3604,'single',103,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3604,'double',27,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3606,'single',119,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3606,'double',24,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3611,'single',68,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3611,'double',54,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3611,'suite',42,369.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3624,'single',156,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3624,'double',209,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3636,'single',66,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3636,'double',212,160.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3643,'single',64,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3643,'double',69,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3643,'suite',76,294.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3660,'single',84,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3660,'double',171,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3660,'suite',64,305.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3661,'single',44,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3661,'double',277,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3675,'single',159,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3675,'double',233,179.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3675,'suite',79,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3679,'single',131,66.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3679,'double',258,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3685,'single',169,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3685,'double',244,199.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3704,'single',74,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3704,'double',165,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3713,'single',110,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3713,'double',157,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3713,'suite',56,326.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3716,'single',88,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3716,'double',261,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3736,'single',73,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3736,'double',140,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3751,'single',22,82.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3751,'double',290,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3760,'single',33,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3760,'double',242,188.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3773,'single',60,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3773,'double',265,227.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3773,'suite',36,461.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3778,'single',25,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3778,'double',187,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3778,'suite',33,251.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3795,'single',182,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3795,'double',99,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3796,'single',164,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3796,'double',225,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3812,'single',95,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3812,'double',223,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3826,'single',94,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3826,'double',52,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3839,'single',190,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3839,'double',166,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3839,'suite',84,292.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3846,'single',155,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3846,'double',57,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3863,'single',46,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3863,'double',102,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3863,'suite',29,304.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3883,'single',136,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3883,'double',75,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3883,'suite',68,331.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3890,'single',88,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3890,'double',102,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3893,'single',23,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3893,'double',137,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3901,'single',95,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3901,'double',52,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3912,'single',74,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3912,'double',139,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3915,'single',60,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3915,'double',204,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3930,'single',52,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3930,'double',228,161.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3935,'single',80,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3935,'double',303,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3942,'single',26,117.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3942,'double',202,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3942,'suite',90,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3950,'single',60,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3950,'double',263,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3960,'single',195,98.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3960,'double',212,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3977,'single',162,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3977,'double',205,233.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3977,'suite',39,279.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3992,'single',126,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (3992,'double',196,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4006,'single',52,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4006,'double',124,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4006,'suite',23,320.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4017,'single',66,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4017,'double',186,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4017,'suite',37,330.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4031,'single',154,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4031,'double',73,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4046,'single',56,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4046,'double',127,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4046,'suite',40,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4065,'single',98,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4065,'double',110,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4065,'suite',75,455.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4067,'single',174,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4067,'double',183,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4067,'suite',63,328.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4068,'single',178,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4068,'double',183,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4081,'single',132,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4081,'double',179,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4081,'suite',62,345.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4093,'single',64,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4093,'double',75,117.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4103,'single',124,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4103,'double',25,240.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4103,'suite',83,382.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4112,'single',36,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4112,'double',23,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4121,'single',147,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4121,'double',170,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4133,'single',179,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4133,'double',263,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4138,'single',67,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4138,'double',94,176.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4148,'single',116,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4148,'double',165,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4151,'single',170,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4151,'double',298,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4151,'suite',46,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4157,'single',134,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4157,'double',250,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4157,'suite',31,473.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4158,'single',129,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4158,'double',126,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4158,'suite',28,444.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4170,'single',48,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4170,'double',91,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4171,'single',95,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4171,'double',220,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4173,'single',145,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4173,'double',177,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4180,'single',125,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4180,'double',147,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4185,'single',42,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4185,'double',74,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4194,'single',183,90.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4194,'double',261,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4197,'single',123,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4197,'double',130,175.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4204,'single',24,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4204,'double',110,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4204,'suite',46,466.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4206,'single',106,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4206,'double',265,220.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4218,'single',109,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4218,'double',89,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4227,'single',43,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4227,'double',152,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4227,'suite',88,268.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4235,'single',83,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4235,'double',43,179.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4235,'suite',52,257.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4244,'single',92,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4244,'double',228,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4250,'single',55,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4250,'double',86,219.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4250,'suite',70,332.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4256,'single',147,87.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4256,'double',97,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4270,'single',97,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4270,'double',122,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4271,'single',73,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4271,'double',277,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4271,'suite',37,473.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4286,'single',145,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4286,'double',67,195.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4298,'single',25,98.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4298,'double',287,246.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4298,'suite',64,398.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4299,'single',37,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4299,'double',164,174.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4299,'suite',90,306.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4307,'single',47,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4307,'double',77,204.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4314,'single',121,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4314,'double',241,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4314,'suite',67,354.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4327,'single',135,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4327,'double',83,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4327,'suite',21,456.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4339,'single',89,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4339,'double',223,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4340,'single',29,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4340,'double',39,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4342,'single',31,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4342,'double',267,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4342,'suite',30,352.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4360,'single',27,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4360,'double',30,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4375,'single',197,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4375,'double',270,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4381,'single',48,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4381,'double',187,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4381,'suite',51,367.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4392,'single',197,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4392,'double',38,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4399,'single',103,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4399,'double',290,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4399,'suite',79,272.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4401,'single',160,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4401,'double',310,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4401,'suite',74,472.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4414,'single',32,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4414,'double',93,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4414,'suite',27,311.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4421,'single',117,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4421,'double',279,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4421,'suite',32,366.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4437,'single',149,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4437,'double',41,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4449,'single',81,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4449,'double',154,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4449,'suite',89,456.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4461,'single',158,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4461,'double',160,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4461,'suite',42,454.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4475,'single',191,75.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4475,'double',316,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4476,'single',191,96.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4476,'double',53,232.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4481,'single',61,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4481,'double',25,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4481,'suite',53,289.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4485,'single',113,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4485,'double',143,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4486,'single',83,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4486,'double',200,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4486,'suite',42,473.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4494,'single',78,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4494,'double',290,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4503,'single',173,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4503,'double',103,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4517,'single',115,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4517,'double',154,178.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4517,'suite',45,334.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4527,'single',38,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4527,'double',121,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4527,'suite',45,417.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4543,'single',183,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4543,'double',227,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4544,'single',197,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4544,'double',319,182.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4544,'suite',45,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4556,'single',197,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4556,'double',107,225.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4556,'suite',98,305.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4562,'single',49,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4562,'double',198,248.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4576,'single',100,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4576,'double',152,187.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4578,'single',60,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4578,'double',220,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4588,'single',114,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4588,'double',135,186.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4602,'single',52,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4602,'double',257,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4602,'suite',48,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4609,'single',48,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4609,'double',209,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4609,'suite',36,255.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4614,'single',144,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4614,'double',312,170.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4614,'suite',91,437.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4615,'single',25,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4615,'double',132,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4615,'suite',97,336.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4616,'single',67,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4616,'double',155,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4625,'single',98,90.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4625,'double',239,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4639,'single',143,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4639,'double',103,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4657,'single',136,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4657,'double',26,222.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4659,'single',87,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4659,'double',63,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4659,'suite',31,476.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4671,'single',176,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4671,'double',134,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4686,'single',160,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4686,'double',45,233.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4695,'single',140,98.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4695,'double',250,248.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4695,'suite',88,425.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4700,'single',104,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4700,'double',207,214.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4709,'single',199,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4709,'double',312,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4726,'single',166,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4726,'double',196,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4727,'single',48,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4727,'double',219,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4732,'single',102,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4732,'double',229,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4739,'single',186,95.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4739,'double',192,215.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4756,'single',133,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4756,'double',58,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4768,'single',128,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4768,'double',259,201.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4768,'suite',46,315.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4769,'single',41,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4769,'double',143,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4769,'suite',77,415.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4786,'single',131,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4786,'double',267,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4786,'suite',48,400.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4799,'single',101,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4799,'double',214,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4799,'suite',73,280.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4806,'single',148,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4806,'double',55,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4806,'suite',70,440.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4813,'single',183,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4813,'double',126,225.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4813,'suite',87,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4816,'single',93,66.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4816,'double',186,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4825,'single',130,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4825,'double',96,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4845,'single',120,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4845,'double',125,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4856,'single',136,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4856,'double',54,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4856,'suite',82,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4861,'single',88,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4861,'double',297,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4867,'single',85,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4867,'double',21,179.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4872,'single',119,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4872,'double',24,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4880,'single',105,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4880,'double',181,211.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4886,'single',117,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4886,'double',301,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4900,'single',131,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4900,'double',128,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4908,'single',181,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4908,'double',34,214.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4908,'suite',53,402.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4910,'single',100,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4910,'double',110,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4918,'single',185,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4918,'double',278,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4918,'suite',53,374.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4929,'single',138,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4929,'double',91,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4929,'suite',86,395.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4946,'single',98,74.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4946,'double',113,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4950,'single',161,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4950,'double',27,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4966,'single',171,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4966,'double',169,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4968,'single',176,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4968,'double',49,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4971,'single',104,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4971,'double',180,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4980,'single',100,75.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4980,'double',145,178.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4994,'single',74,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4994,'double',240,165.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (4994,'suite',84,385.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5009,'single',79,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5009,'double',193,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5009,'suite',99,341.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5025,'single',85,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5025,'double',245,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5042,'single',48,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5042,'double',152,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5042,'suite',77,306.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5061,'single',56,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5061,'double',265,182.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5072,'single',27,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5072,'double',195,248.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5089,'single',180,96.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5089,'double',100,176.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5089,'suite',79,309.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5107,'single',113,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5107,'double',146,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5107,'suite',88,445.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5124,'single',122,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5124,'double',106,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5125,'single',27,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5125,'double',65,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5125,'suite',95,370.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5127,'single',63,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5127,'double',129,215.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5127,'suite',49,408.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5128,'single',44,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5128,'double',54,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5140,'single',53,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5140,'double',52,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5142,'single',165,93.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5142,'double',31,240.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5146,'single',137,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5146,'double',166,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5146,'suite',39,427.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5161,'single',114,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5161,'double',213,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5161,'suite',68,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5179,'single',122,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5179,'double',271,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5180,'single',163,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5180,'double',282,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5195,'single',45,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5195,'double',76,188.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5195,'suite',27,439.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5205,'single',169,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5205,'double',251,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5215,'single',192,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5215,'double',62,204.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5226,'single',183,87.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5226,'double',156,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5229,'single',160,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5229,'double',251,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5234,'single',74,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5234,'double',98,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5246,'single',178,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5246,'double',95,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5258,'single',39,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5258,'double',50,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5277,'single',50,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5277,'double',87,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5282,'single',33,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5282,'double',172,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5282,'suite',73,222.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5299,'single',74,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5299,'double',106,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5299,'suite',84,454.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5311,'single',106,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5311,'double',63,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5311,'suite',85,430.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5315,'single',48,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5315,'double',307,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5335,'single',98,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5335,'double',135,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5341,'single',66,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5341,'double',227,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5341,'suite',21,423.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5346,'single',80,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5346,'double',244,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5355,'single',157,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5355,'double',63,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5355,'suite',94,431.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5367,'single',53,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5367,'double',21,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5380,'single',133,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5380,'double',35,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5394,'single',121,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5394,'double',158,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5394,'suite',39,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5402,'single',149,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5402,'double',81,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5402,'suite',86,197.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5420,'single',138,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5420,'double',278,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5427,'single',196,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5427,'double',318,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5447,'single',114,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5447,'double',258,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5447,'suite',50,388.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5465,'single',30,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5465,'double',38,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5466,'single',71,75.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5466,'double',173,228.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5469,'single',138,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5469,'double',227,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5469,'suite',93,320.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5489,'single',27,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5489,'double',232,175.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5489,'suite',83,479.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5497,'single',139,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5497,'double',127,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5497,'suite',25,432.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5507,'single',61,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5507,'double',299,244.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5527,'single',43,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5527,'double',218,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5533,'single',154,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5533,'double',264,211.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5533,'suite',44,308.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5542,'single',159,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5542,'double',46,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5551,'single',66,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5551,'double',98,219.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5551,'suite',28,376.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5562,'single',179,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5562,'double',167,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5562,'suite',94,475.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5574,'single',78,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5574,'double',278,238.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5583,'single',189,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5583,'double',156,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5583,'suite',44,317.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5592,'single',126,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5592,'double',318,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5599,'single',83,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5599,'double',179,170.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5619,'single',143,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5619,'double',134,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5627,'single',71,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5627,'double',62,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5627,'suite',85,212.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5637,'single',80,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5637,'double',146,210.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5637,'suite',80,303.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5654,'single',198,75.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5654,'double',229,221.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5654,'suite',58,305.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5658,'single',193,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5658,'double',40,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5670,'single',35,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5670,'double',65,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5671,'single',156,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5671,'double',46,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5671,'suite',79,378.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5684,'single',118,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5684,'double',132,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5684,'suite',98,322.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5692,'single',31,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5692,'double',236,195.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5704,'single',54,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5704,'double',231,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5704,'suite',91,302.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5714,'single',116,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5714,'double',89,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5714,'suite',43,194.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5733,'single',52,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5733,'double',204,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5733,'suite',39,207.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5749,'single',75,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5749,'double',89,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5749,'suite',31,350.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5758,'single',140,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5758,'double',220,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5758,'suite',99,406.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5771,'single',74,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5771,'double',49,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5771,'suite',30,400.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5775,'single',21,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5775,'double',258,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5785,'single',57,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5785,'double',87,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5785,'suite',49,383.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5796,'single',138,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5796,'double',114,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5796,'suite',42,387.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5813,'single',151,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5813,'double',84,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5828,'single',75,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5828,'double',25,176.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5828,'suite',55,420.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5843,'single',72,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5843,'double',57,170.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5843,'suite',22,346.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5861,'single',105,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5861,'double',229,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5864,'single',154,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5864,'double',37,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5876,'single',153,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5876,'double',74,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5881,'single',141,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5881,'double',86,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5897,'single',186,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5897,'double',79,201.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5909,'single',127,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5909,'double',243,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5929,'single',47,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5929,'double',30,212.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5929,'suite',79,422.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5942,'single',36,96.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5942,'double',308,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5949,'single',160,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5949,'double',99,188.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5964,'single',65,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5964,'double',289,212.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5964,'suite',20,448.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5967,'single',37,92.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5967,'double',178,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5968,'single',25,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5968,'double',268,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5968,'suite',51,441.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5980,'single',113,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5980,'double',260,235.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5980,'suite',37,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5997,'single',166,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5997,'double',315,198.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (5997,'suite',54,422.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6006,'single',35,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6006,'double',282,240.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6006,'suite',73,234.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6022,'single',93,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6022,'double',242,166.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6024,'single',122,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6024,'double',145,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6038,'single',64,93.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6038,'double',293,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6041,'single',146,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6041,'double',313,174.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6052,'single',49,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6052,'double',156,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6052,'suite',67,374.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6061,'single',163,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6061,'double',262,247.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6061,'suite',21,404.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6078,'single',179,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6078,'double',195,195.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6078,'suite',59,376.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6089,'single',47,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6089,'double',108,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6089,'suite',36,408.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6104,'single',81,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6104,'double',252,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6107,'single',140,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6107,'double',198,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6107,'suite',70,440.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6115,'single',82,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6115,'double',219,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6115,'suite',48,204.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6121,'single',198,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6121,'double',268,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6121,'suite',90,357.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6137,'single',80,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6137,'double',53,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6146,'single',38,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6146,'double',69,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6149,'single',190,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6149,'double',49,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6149,'suite',77,227.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6159,'single',87,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6159,'double',292,191.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6159,'suite',68,350.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6165,'single',169,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6165,'double',188,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6180,'single',163,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6180,'double',260,219.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6191,'single',171,85.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6191,'double',216,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6199,'single',47,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6199,'double',104,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6199,'suite',96,377.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6206,'single',114,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6206,'double',148,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6216,'single',90,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6216,'double',292,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6216,'suite',20,421.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6235,'single',37,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6235,'double',53,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6242,'single',52,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6242,'double',158,173.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6242,'suite',35,362.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6260,'single',148,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6260,'double',311,189.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6260,'suite',89,214.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6264,'single',98,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6264,'double',140,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6275,'single',36,61.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6275,'double',212,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6275,'suite',57,371.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6279,'single',142,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6279,'double',281,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6298,'single',56,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6298,'double',84,194.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6312,'single',159,112.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6312,'double',178,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6316,'single',80,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6316,'double',181,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6316,'suite',88,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6317,'single',124,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6317,'double',209,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6328,'single',129,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6328,'double',102,166.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6328,'suite',78,358.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6334,'single',51,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6334,'double',285,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6342,'single',100,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6342,'double',87,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6351,'single',157,68.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6351,'double',130,182.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6365,'single',175,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6365,'double',268,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6365,'suite',78,446.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6369,'single',102,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6369,'double',87,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6383,'single',110,74.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6383,'double',62,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6383,'suite',54,288.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6401,'single',96,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6401,'double',268,182.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6401,'suite',24,280.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6409,'single',105,66.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6409,'double',97,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6411,'single',104,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6411,'double',113,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6411,'suite',77,374.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6414,'single',48,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6414,'double',118,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6414,'suite',60,437.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6433,'single',105,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6433,'double',177,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6433,'suite',37,215.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6447,'single',176,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6447,'double',235,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6447,'suite',72,326.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6467,'single',116,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6467,'double',179,174.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6477,'single',22,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6477,'double',66,129.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6487,'single',33,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6487,'double',238,187.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6487,'suite',79,356.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6494,'single',86,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6494,'double',125,162.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6512,'single',111,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6512,'double',25,180.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6530,'single',87,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6530,'double',85,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6548,'single',195,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6548,'double',274,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6563,'single',20,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6563,'double',60,164.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6563,'suite',94,425.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6572,'single',89,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6572,'double',179,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6572,'suite',81,195.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6590,'single',123,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6590,'double',63,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6608,'single',80,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6608,'double',40,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6608,'suite',62,254.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6627,'single',146,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6627,'double',69,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6644,'single',112,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6644,'double',84,204.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6644,'suite',29,377.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6656,'single',75,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6656,'double',211,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6656,'suite',96,296.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6676,'single',79,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6676,'double',116,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6676,'suite',82,471.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6686,'single',42,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6686,'double',184,188.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6698,'single',75,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6698,'double',228,211.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6712,'single',127,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6712,'double',103,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6724,'single',20,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6724,'double',231,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6724,'suite',48,356.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6737,'single',130,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6737,'double',73,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6754,'single',169,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6754,'double',128,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6754,'suite',48,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6756,'single',177,61.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6756,'double',129,117.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6766,'single',99,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6766,'double',86,220.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6766,'suite',92,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6780,'single',60,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6780,'double',307,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6780,'suite',65,294.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6797,'single',152,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6797,'double',150,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6797,'suite',24,374.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6799,'single',159,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6799,'double',89,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6799,'suite',56,327.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6803,'single',36,91.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6803,'double',149,165.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6822,'single',155,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6822,'double',292,214.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6829,'single',194,83.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6829,'double',248,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6843,'single',151,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6843,'double',116,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6845,'single',191,64.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6845,'double',148,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6859,'single',101,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6859,'double',49,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6859,'suite',79,380.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6863,'single',91,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6863,'double',121,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6881,'single',74,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6881,'double',316,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6897,'single',21,74.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6897,'double',145,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6898,'single',143,87.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6898,'double',316,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6915,'single',112,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6915,'double',194,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6915,'suite',48,231.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6926,'single',68,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6926,'double',174,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6927,'single',49,94.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6927,'double',295,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6936,'single',184,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6936,'double',50,187.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6936,'suite',44,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6952,'single',44,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6952,'double',203,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6953,'single',103,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6953,'double',204,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6953,'suite',23,417.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6970,'single',127,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6970,'double',243,162.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6970,'suite',92,445.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6989,'single',160,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6989,'double',125,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6998,'single',80,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6998,'double',239,203.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (6998,'suite',82,379.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7017,'single',35,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7017,'double',152,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7017,'suite',75,276.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7022,'single',35,97.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7022,'double',55,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7029,'single',37,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7029,'double',44,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7038,'single',65,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7038,'double',240,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7038,'suite',88,189.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7049,'single',126,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7049,'double',125,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7061,'single',99,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7061,'double',98,199.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7070,'single',57,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7070,'double',210,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7077,'single',26,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7077,'double',261,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7077,'suite',57,392.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7087,'single',160,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7087,'double',44,229.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7087,'suite',41,260.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7097,'single',127,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7097,'double',131,110.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7097,'suite',28,278.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7115,'single',130,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7115,'double',304,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7131,'single',191,133.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7131,'double',231,218.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7139,'single',25,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7139,'double',293,116.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7139,'suite',35,457.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7148,'single',157,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7148,'double',252,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7157,'single',106,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7157,'double',173,232.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7167,'single',109,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7167,'double',28,205.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7179,'single',61,81.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7179,'double',198,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7179,'suite',91,472.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7191,'single',89,117.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7191,'double',225,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7191,'suite',70,383.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7202,'single',41,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7202,'double',151,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7202,'suite',24,263.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7211,'single',58,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7211,'double',244,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7211,'suite',81,259.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7226,'single',171,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7226,'double',173,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7226,'suite',65,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7234,'single',150,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7234,'double',161,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7249,'single',162,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7249,'double',166,249.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7249,'suite',39,358.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7261,'single',61,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7261,'double',268,211.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7268,'single',118,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7268,'double',164,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7270,'single',37,67.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7270,'double',30,167.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7270,'suite',35,329.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7284,'single',70,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7284,'double',124,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7284,'suite',42,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7290,'single',150,86.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7290,'double',90,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7294,'single',160,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7294,'double',233,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7304,'single',62,131.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7304,'double',122,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7312,'single',169,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7312,'double',171,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7317,'single',120,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7317,'double',155,202.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7317,'suite',52,271.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7332,'single',82,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7332,'double',258,159.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7332,'suite',34,375.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7342,'single',45,62.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7342,'double',91,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7356,'single',81,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7356,'double',303,107.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7356,'suite',32,407.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7361,'single',141,105.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7361,'double',164,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7365,'single',87,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7365,'double',238,218.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7384,'single',145,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7384,'double',72,100.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7384,'suite',69,382.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7388,'single',63,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7388,'double',246,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7399,'single',151,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7399,'double',34,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7399,'suite',59,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7416,'single',147,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7416,'double',158,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7416,'suite',28,298.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7430,'single',118,108.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7430,'double',118,236.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7430,'suite',88,258.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7441,'single',33,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7441,'double',87,118.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7450,'single',95,73.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7450,'double',318,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7450,'suite',48,218.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7458,'single',71,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7458,'double',109,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7458,'suite',30,403.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7478,'single',101,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7478,'double',31,141.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7486,'single',96,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7486,'double',22,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7486,'suite',76,368.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7496,'single',26,138.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7496,'double',39,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7506,'single',59,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7506,'double',59,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7522,'single',115,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7522,'double',319,151.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7522,'suite',66,238.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7524,'single',29,103.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7524,'double',24,235.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7539,'single',37,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7539,'double',72,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7539,'suite',95,390.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7541,'single',65,128.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7541,'double',106,172.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7550,'single',48,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7550,'double',220,243.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7550,'suite',64,339.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7556,'single',171,80.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7556,'double',196,167.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7556,'suite',96,237.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7560,'single',162,70.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7560,'double',137,165.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7574,'single',168,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7574,'double',164,186.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7577,'single',119,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7577,'double',145,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7579,'single',163,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7579,'double',60,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7579,'suite',50,424.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7580,'single',73,157.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7580,'double',28,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7584,'single',54,132.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7584,'double',224,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7584,'suite',24,414.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7599,'single',41,156.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7599,'double',26,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7616,'single',111,144.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7616,'double',204,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7628,'single',173,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7628,'double',211,120.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7628,'suite',54,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7633,'single',34,153.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7633,'double',173,150.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7633,'suite',91,335.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7641,'single',63,147.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7641,'double',219,187.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7641,'suite',35,319.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7651,'single',28,61.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7651,'double',217,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7651,'suite',22,264.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7671,'single',91,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7671,'double',283,122.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7671,'suite',86,348.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7686,'single',29,69.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7686,'double',154,195.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7686,'suite',66,326.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7700,'single',133,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7700,'double',232,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7700,'suite',91,463.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7715,'single',70,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7715,'double',259,177.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7715,'suite',50,468.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7725,'single',107,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7725,'double',56,218.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7731,'single',188,113.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7731,'double',129,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7731,'suite',24,230.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7732,'single',77,109.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7732,'double',60,127.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7752,'single',194,84.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7752,'double',50,215.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7752,'suite',79,196.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7764,'single',112,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7764,'double',171,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7764,'suite',87,267.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7782,'single',32,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7782,'double',60,242.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7782,'suite',35,302.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7784,'single',129,134.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7784,'double',286,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7804,'single',63,89.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7804,'double',257,222.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7812,'single',77,106.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7812,'double',83,225.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7827,'single',130,98.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7827,'double',50,217.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7829,'single',177,96.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7829,'double',166,226.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7829,'suite',96,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7830,'single',91,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7830,'double',306,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7840,'single',124,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7840,'double',34,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7853,'single',155,158.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7853,'double',152,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7861,'single',47,126.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7861,'double',67,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7861,'suite',35,370.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7864,'single',185,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7864,'double',96,168.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7864,'suite',73,380.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7868,'single',74,63.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7868,'double',120,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7868,'suite',86,476.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7879,'single',168,121.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7879,'double',141,192.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7879,'suite',65,277.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7885,'single',109,137.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7885,'double',209,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7896,'single',42,76.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7896,'double',227,101.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7896,'suite',21,241.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7899,'single',146,88.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7899,'double',44,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7907,'single',123,136.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7907,'double',209,139.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7907,'suite',94,413.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7920,'single',89,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7920,'double',274,183.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7920,'suite',95,206.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7921,'single',133,77.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7921,'double',131,165.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7921,'suite',34,213.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7924,'single',145,124.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7924,'double',202,225.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7929,'single',182,152.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7929,'double',122,190.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7929,'suite',58,181.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7942,'single',155,111.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7942,'double',275,143.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7942,'suite',65,389.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7961,'single',99,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7961,'double',42,171.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7975,'single',62,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7975,'double',146,193.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7975,'suite',32,225.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7977,'single',133,155.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7977,'double',205,146.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7993,'single',136,61.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7993,'double',316,102.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7997,'single',30,135.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7997,'double',79,145.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (7997,'suite',30,329.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8004,'single',156,115.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8004,'double',41,104.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8019,'single',63,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8019,'double',183,200.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8019,'suite',27,223.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8034,'single',179,78.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8034,'double',124,224.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8034,'suite',28,468.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8039,'single',195,60.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8039,'double',57,149.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8039,'suite',49,184.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8041,'single',56,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8041,'double',23,123.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8047,'single',45,79.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8047,'double',228,245.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8066,'single',148,74.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8066,'double',208,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8066,'suite',97,279.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8081,'single',120,65.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8081,'double',206,232.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8081,'suite',51,382.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8088,'single',24,130.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8088,'double',306,208.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8088,'suite',70,445.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8100,'single',51,142.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8100,'double',43,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8100,'suite',85,315.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8118,'single',71,71.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8118,'double',155,238.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8138,'single',161,119.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8138,'double',281,185.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8148,'single',184,125.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8148,'double',224,215.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8148,'suite',72,262.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8158,'single',59,140.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8158,'double',304,207.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8158,'suite',35,378.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8163,'single',87,72.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8163,'double',60,148.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8163,'suite',87,285.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8167,'single',181,114.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8167,'double',60,154.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8167,'suite',80,399.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8168,'single',57,99.00)")
    stopIfSqlNotOK(session, "INSERT INTO room VALUES (8168,'double',318,241.00)")
    stopIfSqlNotOK(session, "insert into customer values(4401,'Company',NULL,'MagicStrawberry','78146','76 Highland Road,#120')")
    stopIfSqlNotOK(session, "insert into customer values(4402,'Company',NULL,'OrangeHand','78609','212 Oak Avenue,#30')")
    stopIfSqlNotOK(session, "insert into customer values(4403,'Company',NULL,'IndigoPath','78614','210 Willow Avenue,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4404,'Company',NULL,'BionicBat','78107','352 East Place,#88')")
    stopIfSqlNotOK(session, "insert into customer values(4405,'Company',NULL,'MetalFalcon','18636','451 Fourth Square,#191')")
    stopIfSqlNotOK(session, "insert into customer values(4406,'Company',NULL,'HighGoldfish','76837','122 Cherry Parkway,#24')")
    stopIfSqlNotOK(session, "insert into customer values(4407,'Company',NULL,'ThirstyOxygen','71832','377 Jefferson Parkway,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4408,'Company',NULL,'PurpleCrush','79018','21 Washington Ave,#52')")
    stopIfSqlNotOK(session, "insert into customer values(4409,'Company',NULL,'BlackDoor','77446','32 Hickory Street,#123')")
    stopIfSqlNotOK(session, "insert into customer values(4410,'Company',NULL,'KeyNet','26810','107 Williams Walk,#182')")
    stopIfSqlNotOK(session, "insert into customer values(4411,'Company',NULL,'BigTrout','76885','445 Church Avenue,#15')")
    stopIfSqlNotOK(session, "insert into customer values(4412,'Company',NULL,'GreyFish','26811','450 Highland Road,#51')")
    stopIfSqlNotOK(session, "insert into customer values(4413,'Company',NULL,'IndigoRobot','76046','356 Main Street,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4414,'Company',NULL,'InteractivePath','46154','90 Hickory Blvd,#20')")
    stopIfSqlNotOK(session, "insert into customer values(4415,'Company',NULL,'NewMessage','22021','46 Eighth Blvd,#78')")
    stopIfSqlNotOK(session, "insert into customer values(4416,'Company',NULL,'RedLight','78535','220 Sycamore Street,#95')")
    stopIfSqlNotOK(session, "insert into customer values(4417,'Company',NULL,'MotionPool','50124','445 North Boulevard,#71')")
    stopIfSqlNotOK(session, "insert into customer values(4418,'Company',NULL,'WildCommerce','77990','219 Highland Square,#44')")
    stopIfSqlNotOK(session, "insert into customer values(4419,'Company',NULL,'MagicPixel','77836','485 Hillcrest Road,#135')")
    stopIfSqlNotOK(session, "insert into customer values(4420,'Company',NULL,'PinkSystems','77231','173 Lake Ave,#15')")
    stopIfSqlNotOK(session, "insert into customer values(4421,'Company',NULL,'PurpleRooster','78336','452 Highland Lane,#104')")
    stopIfSqlNotOK(session, "insert into customer values(4422,'Company',NULL,'SolidDragon','78360','315 Fourth Boulevard,#95')")
    stopIfSqlNotOK(session, "insert into customer values(4423,'Company',NULL,'MetalVoice','40153','300 Pine Walk,#96')")
    stopIfSqlNotOK(session, "insert into customer values(4424,'Company',NULL,'AND Incorporated','77564','291 Third St.,#172')")
    stopIfSqlNotOK(session, "insert into customer values(4425,'Company',NULL,'Lsiliand Partners','79503','210 View Lane,#47')")
    stopIfSqlNotOK(session, "insert into customer values(4426,'Company',NULL,'Silicro','76512','381 Mill Square,#23')")
    stopIfSqlNotOK(session, "insert into customer values(4427,'Company',NULL,'Dent Capital','78153','351 Thirteenth Blvd,#134')")
    stopIfSqlNotOK(session, "insert into customer values(4428,'Company',NULL,'Apple Research','27233','6 Church Square,#80')")
    stopIfSqlNotOK(session, "insert into customer values(4429,'Company',NULL,'Unitign Capital','02822','186 East Drive,#30')")
    stopIfSqlNotOK(session, "insert into customer values(4430,'Company',NULL,'Gracle Corporation','65231','230 Spruce Lane,#104')")
    stopIfSqlNotOK(session, "insert into customer values(4431,'Company',NULL,'Aperam Partners','77385','456 Eighth Walk,#141')")
    stopIfSqlNotOK(session, "insert into customer values(4432,'Company',NULL,'Ateppe','75492','14 Wilson Ave,#114')")
    stopIfSqlNotOK(session, "insert into customer values(4433,'Company',NULL,'Vany Development','71239','485 Eleventh Road,#31')")
    stopIfSqlNotOK(session, "insert into customer values(4434,'Company',NULL,'Alpineag Manufacturing','75104','80 Hillcrest Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(4435,'Company',NULL,'Iners, Inc','78877','66 Sunset Lane,#114')")
    stopIfSqlNotOK(session, "insert into customer values(4436,'Company',NULL,'RES Manufacturing','76245','278 Elm Place,#5')")
    stopIfSqlNotOK(session, "insert into customer values(4437,'Company',NULL,'Miceres Consulting','76363','412 View Square,#107')")
    stopIfSqlNotOK(session, "insert into customer values(4438,'Company',NULL,'Boole Devices','76691','111 Lake Parkway,#151')")
    stopIfSqlNotOK(session, "insert into customer values(4439,'Company',NULL,'Cypref Europe','79327','480 Central Square,#97')")
    stopIfSqlNotOK(session, "insert into customer values(4440,'Company',NULL,'ING Capital','75663','235 Oak Road,#174')")
    stopIfSqlNotOK(session, "insert into customer values(4441,'Company',NULL,'Aper Incorporated','76650','111 Broadway Ave,#12')")
    stopIfSqlNotOK(session, "insert into customer values(4442,'Company',NULL,'Therickard Consulting','12452','140 College Place,#97')")
    stopIfSqlNotOK(session, "insert into customer values(4443,'Company',NULL,'Matems','76857','380 Hill Parkway,#176')")
    stopIfSqlNotOK(session, "insert into customer values(4444,'Company',NULL,'Alsigrosys Devices','61458','275 Park Ave,#61')")
    stopIfSqlNotOK(session, "insert into customer values(4445,'Company',NULL,'Coraterne','76673','251 Tenth Lane,#187')")
    stopIfSqlNotOK(session, "insert into customer values(4446,'Company',NULL,'TED Design','78383','200 Twelfth Ave,#33')")
    stopIfSqlNotOK(session, "insert into customer values(4447,'Company',NULL,'Sology, Inc','18032','4 Thirteenth St.,#111')")
    stopIfSqlNotOK(session, "insert into customer values(4448,'Company',NULL,'ELE','76378','401 Washington Lane,#91')")
    stopIfSqlNotOK(session, "insert into customer values(4449,'Company',NULL,'ALLALL, Inc','78552','329 Willow Street,#142')")
    stopIfSqlNotOK(session, "insert into customer values(4450,'Company',NULL,'BUS','00622','497 Laurel Blvd,#79')")
    stopIfSqlNotOK(session, "insert into customer values(4451,'Company',NULL,'Sile Germany','19453','83 Sixth Drive,#34')")
    stopIfSqlNotOK(session, "insert into customer values(4452,'Company',NULL,'Seare Incorporated','87201','483 Spring Drive,#11')")
    stopIfSqlNotOK(session, "insert into customer values(4453,'Company',NULL,'Inear, Inc','75772','290 River Road,#194')")
    stopIfSqlNotOK(session, "insert into customer values(4454,'Company',NULL,'Atelectoran GmbH','39346','223 Lincoln Square,#120')")
    stopIfSqlNotOK(session, "insert into customer values(4455,'Company',NULL,'CON USA','76057','264 Miller Road,#68')")
    stopIfSqlNotOK(session, "insert into customer values(4456,'Company',NULL,'Solog Investments','77623','444 Cedar Lane,#116')")
    stopIfSqlNotOK(session, "insert into customer values(4457,'Company',NULL,'Alsiling Research','79044','115 Broadway Walk,#89')")
    stopIfSqlNotOK(session, "insert into customer values(4458,'Company',NULL,'Sperites Consulting','75364','126 Willow Square,#29')")
    stopIfSqlNotOK(session, "insert into customer values(4459,'Company',NULL,'Systech Incorporated','79054','463 Tenth Parkway,#193')")
    stopIfSqlNotOK(session, "insert into customer values(4460,'Company',NULL,'Xilogilice Asia','75651','445 Center Road,#75')")
    stopIfSqlNotOK(session, "insert into customer values(4461,'Company',NULL,'Cons','83534','233 Willow Place,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4462,'Company',NULL,'Aspincons Partners','77995','203 East Parkway,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4463,'Company',NULL,'Ling Development','91386','205 View St.,#56')")
    stopIfSqlNotOK(session, "insert into customer values(4464,'Company',NULL,'Atmentech Partners','78270','470 Lee Drive,#190')")
    stopIfSqlNotOK(session, "insert into customer values(4465,'Company',NULL,'Searitas','33470','34 Central Parkway,#39')")
    stopIfSqlNotOK(session, "insert into customer values(4466,'Company',NULL,'Mickar Incorporated','28703','110 Cherry Avenue,#26')")
    stopIfSqlNotOK(session, "insert into customer values(4467,'Company',NULL,'Redessoftwor Devices','60463','94 Dogwood Place,#19')")
    stopIfSqlNotOK(session, "insert into customer values(4468,'Company',NULL,'BAY Manufacturing','76366','145 Center Drive,#139')")
    stopIfSqlNotOK(session, "insert into customer values(4469,'Company',NULL,'NAL Systems, Inc','75005','164 Central Blvd,#85')")
    stopIfSqlNotOK(session, "insert into customer values(4470,'Company',NULL,'Sear','89424','43 Twelfth Parkway,#55')")
    stopIfSqlNotOK(session, "insert into customer values(4471,'Company',NULL,'Elett Partners','78594','102 Fifth Parkway,#44')")
    stopIfSqlNotOK(session, "insert into customer values(4472,'Company',NULL,'Oratascor Technology','32088','99 Church Ave,#88')")
    stopIfSqlNotOK(session, "insert into customer values(4473,'Company',NULL,'Applies Investments','75833','99 Poplar Avenue,#95')")
    stopIfSqlNotOK(session, "insert into customer values(4474,'Company',NULL,'INK Capital','76887','249 Maple Blvd,#7')")
    stopIfSqlNotOK(session, "insert into customer values(4475,'Company',NULL,'AGE Germany','77446','453 Fourteenth Parkway,#133')")
    stopIfSqlNotOK(session, "insert into customer values(4476,'Company',NULL,'Softwarti Capital','79532','136 Williams Street,#53')")
    stopIfSqlNotOK(session, "insert into customer values(4477,'Company',NULL,'Tegracoman Asia','67740','39 Park Square,#173')")
    stopIfSqlNotOK(session, "insert into customer values(4478,'Company',NULL,'Gativera Ventures','50070','373 Fourth Place,#58')")
    stopIfSqlNotOK(session, "insert into customer values(4479,'Company',NULL,'Piebell Manufacturing','77326','221 Taylor Drive,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4480,'Company',NULL,'Systel Japan','77957','213 Sycamore Street,#124')")
    stopIfSqlNotOK(session, "insert into customer values(4481,'Company',NULL,'Siess Development','77964','287 Main Boulevard,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4482,'Company',NULL,'Spex Corporation','75755','267 Walnut Street,#186')")
    stopIfSqlNotOK(session, "insert into customer values(4483,'Company',NULL,'Caeramr Investments','65618','102 Cherry Road,#2')")
    stopIfSqlNotOK(session, "insert into customer values(4484,'Company',NULL,'Zitionata Consulting','76883','184 Lake Place,#65')")
    stopIfSqlNotOK(session, "insert into customer values(4485,'Company',NULL,'Comp Group','78116','292 Broadway St.,#37')")
    stopIfSqlNotOK(session, "insert into customer values(4486,'Company',NULL,'Ines Incorporated','75765','452 Lee Ave,#19')")
    stopIfSqlNotOK(session, "insert into customer values(4487,'Company',NULL,'Aterts Manufacturing','78114','433 Madison Square,#142')")
    stopIfSqlNotOK(session, "insert into customer values(4488,'Company',NULL,'Forpor Incorporated','79739','132 Oak Boulevard,#101')")
    stopIfSqlNotOK(session, "insert into customer values(4489,'Company',NULL,'DES Germany','77993','59 Jefferson Road,#31')")
    stopIfSqlNotOK(session, "insert into customer values(4490,'Company',NULL,'ING Germany','78375','267 Green Square,#7')")
    stopIfSqlNotOK(session, "insert into customer values(4491,'Company',NULL,'Sology Investments','63373','346 Sycamore Road,#162')")
    stopIfSqlNotOK(session, "insert into customer values(4492,'Company',NULL,'Nology Corporation','76351','264 Twelfth Square,#13')")
    stopIfSqlNotOK(session, "insert into customer values(4493,'Company',NULL,'Xilices Germany','76067','234 Cherry St.,#179')")
    stopIfSqlNotOK(session, "insert into customer values(4494,'Company',NULL,'Systrant Research','77430','297 Hill Lane,#184')")
    stopIfSqlNotOK(session, "insert into customer values(4495,'Company',NULL,'Ciscon Technology','77530','159 Park St.,#193')")
    stopIfSqlNotOK(session, "insert into customer values(4496,'Company',NULL,'Cadobe Consulting','76448','267 Hill St.,#9')")
    stopIfSqlNotOK(session, "insert into customer values(4497,'Company',NULL,'Semicrese PLC','79035','95 Jefferson Parkway,#93')")
    stopIfSqlNotOK(session, "insert into customer values(4498,'Company',NULL,'Maginc PLC','78146','433 Cedar Ave,#63')")
    stopIfSqlNotOK(session, "insert into customer values(4499,'Company',NULL,'ALS PLC','76084','18 Meadow Blvd,#67')")
    stopIfSqlNotOK(session, "insert into customer values(4500,'Company',NULL,'Ellied Japan','79061','65 Ash Ave,#119')")
    stopIfSqlNotOK(session, "insert into customer values(4501,'Company',NULL,'Dentechic GmbH','78144','66 Madison Avenue,#1')")
    stopIfSqlNotOK(session, "insert into customer values(4502,'Company',NULL,'Teless Development','77994','149 Cherry Walk,#10')")
    stopIfSqlNotOK(session, "insert into customer values(4503,'Company',NULL,'INC','78596','336 Thirteenth Lane,#183')")
    stopIfSqlNotOK(session, "insert into customer values(4504,'Company',NULL,'AME','91322','129 Dogwood Parkway,#6')")
    stopIfSqlNotOK(session, "insert into customer values(4505,'Company',NULL,'Intury Japan','78620','68 West Ave,#2')")
    stopIfSqlNotOK(session, "insert into customer values(4506,'Company',NULL,'COR Japan','76137','137 First Ave,#155')")
    stopIfSqlNotOK(session, "insert into customer values(4507,'Company',NULL,'Systed Manufacturing','79312','332 Elm Street,#91')")
    stopIfSqlNotOK(session, "insert into customer values(4508,'Company',NULL,'Mics, Inc','77838','462 Ash Ave,#7')")
    stopIfSqlNotOK(session, "insert into customer values(4509,'Company',NULL,'INX Devices','76650','345 Hillcrest Boulevard,#66')")
    stopIfSqlNotOK(session, "insert into customer values(4510,'Company',NULL,'TED','49855','313 Wilson Boulevard,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4511,'Company',NULL,'Seas Research','96055','330 Willow Drive,#146')")
    stopIfSqlNotOK(session, "insert into customer values(4512,'Company',NULL,'Micons Europe','76206','168 Taylor Walk,#62')")
    stopIfSqlNotOK(session, "insert into customer values(4513,'Company',NULL,'Syster Germany','01569','232 Chestnut Boulevard,#20')")
    stopIfSqlNotOK(session, "insert into customer values(4514,'Company',NULL,'Aclechnology Systems, Inc','78480','397 Fourth St.,#88')")
    stopIfSqlNotOK(session, "insert into customer values(4515,'Company',NULL,'Cisk','78631','380 Eleventh Blvd,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4516,'Company',NULL,'Alpiess Devices','78624','212 Cedar Road,#119')")
    stopIfSqlNotOK(session, "insert into customer values(4517,'Company',NULL,'Elgg Investments','79376','11 Wilson Street,#51')")
    stopIfSqlNotOK(session, "insert into customer values(4518,'Company',NULL,'Babbas Capital','75140','357 Elm Street,#187')")
    stopIfSqlNotOK(session, "insert into customer values(4519,'Company',NULL,'Systems Manufacturing','19341','51 Jefferson Drive,#146')")
    stopIfSqlNotOK(session, "insert into customer values(4520,'Company',NULL,'Nett Systems, Inc','78385','208 Lee Avenue,#61')")
    stopIfSqlNotOK(session, "insert into customer values(4521,'Company',NULL,'Systed Technology Partners','78675','222 Ash Boulevard,#198')")
    stopIfSqlNotOK(session, "insert into customer values(4522,'Company',NULL,'Tems Investments','79520','146 Broadway Lane,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4523,'Company',NULL,'INX Devices','94112','17 Miller Drive,#108')")
    stopIfSqlNotOK(session, "insert into customer values(4524,'Company',NULL,'Search Incorporated','77960','370 Meadow Parkway,#12')")
    stopIfSqlNotOK(session, "insert into customer values(4525,'Company',NULL,'Equan','92262','488 Thirteenth Avenue,#147')")
    stopIfSqlNotOK(session, "insert into customer values(4526,'Company',NULL,'Systems','12192','93 Lake St.,#189')")
    stopIfSqlNotOK(session, "insert into customer values(4527,'Company',NULL,'Sunional Japan','79521','367 Dogwood Boulevard,#149')")
    stopIfSqlNotOK(session, "insert into customer values(4528,'Company',NULL,'Sunicorpor Manufacturing','78951','340 Lake Square,#183')")
    stopIfSqlNotOK(session, "insert into customer values(4529,'Company',NULL,'PRE Devices','75310','436 Tenth Ave,#13')")
    stopIfSqlNotOK(session, "insert into customer values(4530,'Company',NULL,'MIC Technology','78117','143 Taylor Ave,#170')")
    stopIfSqlNotOK(session, "insert into customer values(4531,'Company',NULL,'MIX Partners','75451','446 Birch Parkway,#149')")
    stopIfSqlNotOK(session, "insert into customer values(4532,'Company',NULL,'Miceratecury Corporation','85631','143 Taylor Avenue,#36')")
    stopIfSqlNotOK(session, "insert into customer values(4533,'Company',NULL,'Sems Design','32684','46 Railroad Square,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4534,'Company',NULL,'Ategra','76667','378 Birch Walk,#116')")
    stopIfSqlNotOK(session, "insert into customer values(4535,'Company',NULL,'Tegram Incorporated','78670','379 South Square,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4536,'Company',NULL,'INS Group','15740','336 Taylor Avenue,#124')")
    stopIfSqlNotOK(session, "insert into customer values(4537,'Company',NULL,'INT Development','07624','366 Sunset Road,#190')")
    stopIfSqlNotOK(session, "insert into customer values(4538,'Company',NULL,'Asology Asia','17247','295 Sixth Road,#41')")
    stopIfSqlNotOK(session, "insert into customer values(4539,'Company',NULL,'DIA Manufacturing','88135','483 Valley Drive,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4540,'Company',NULL,'Dentec Development','76360','250 First Ave,#135')")
    stopIfSqlNotOK(session, "insert into customer values(4541,'Company',NULL,'JTS Incorporated','76055','220 Central St.,#55')")
    stopIfSqlNotOK(session, "insert into customer values(4542,'Company',NULL,'Comagiekeres Development','16928','453 Jefferson Lane,#194')")
    stopIfSqlNotOK(session, "insert into customer values(4543,'Company',NULL,'Systrum Investments','97109','383 Sycamore St.,#148')")
    stopIfSqlNotOK(session, "insert into customer values(4544,'Company',NULL,'Systectorla Capital','77566','497 Meadow Lane,#5')")
    stopIfSqlNotOK(session, "insert into customer values(4545,'Company',NULL,'Grosys','92714','422 Walnut Avenue,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4546,'Company',NULL,'ING','78947','423 Woodland Parkway,#12')")
    stopIfSqlNotOK(session, "insert into customer values(4547,'Company',NULL,'Systed Group','75001','420 Madison Blvd,#176')")
    stopIfSqlNotOK(session, "insert into customer values(4548,'Company',NULL,'TED Devices','00757','300 Lake Ave,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4549,'Company',NULL,'Licor Japan','75751','342 Spruce Square,#74')")
    stopIfSqlNotOK(session, "insert into customer values(4550,'Company',NULL,'Telling PLC','76637','234 Forest Street,#4')")
    stopIfSqlNotOK(session, "insert into customer values(4551,'Company',NULL,'Coratere USA','75951','382 Smith Drive,#139')")
    stopIfSqlNotOK(session, "insert into customer values(4552,'Company',NULL,'Tions','75979','216 Mill Lane,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4553,'Company',NULL,'Systems USA','77545','392 Fifteenth Lane,#74')")
    stopIfSqlNotOK(session, "insert into customer values(4554,'Company',NULL,'Inetcs USA','75310','249 Forest Parkway,#176')")
    stopIfSqlNotOK(session, "insert into customer values(4555,'Company',NULL,'CON','78069','414 Jefferson Road,#53')")
    stopIfSqlNotOK(session, "insert into customer values(4556,'Company',NULL,'Sign Corporation','79320','73 Smith Road,#155')")
    stopIfSqlNotOK(session, "insert into customer values(4557,'Company',NULL,'Cisk','75440','415 Fourteenth Road,#69')")
    stopIfSqlNotOK(session, "insert into customer values(4558,'Company',NULL,'Systrum Development','18854','146 Cedar Square,#145')")
    stopIfSqlNotOK(session, "insert into customer values(4559,'Company',NULL,'Dess Research','25904','50 Central Walk,#118')")
    stopIfSqlNotOK(session, "insert into customer values(4560,'Company',NULL,'INT USA','75833','455 Fourth Street,#107')")
    stopIfSqlNotOK(session, "insert into customer values(4561,'Company',NULL,'Asoft Technology','77482','413 Poplar St.,#179')")
    stopIfSqlNotOK(session, "insert into customer values(4562,'Company',NULL,'Aution Devices','76474','278 College Blvd,#133')")
    stopIfSqlNotOK(session, "insert into customer values(4563,'Company',NULL,'Socirructor Capital','79323','131 Center Boulevard,#143')")
    stopIfSqlNotOK(session, "insert into customer values(4564,'Company',NULL,'Devicoak Group','76550','185 Birch Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(4565,'Company',NULL,'Exxon Technology','75637','349 Ridge Avenue,#184')")
    stopIfSqlNotOK(session, "insert into customer values(4566,'Company',NULL,'SPE Design','78391','349 Lincoln Parkway,#42')")
    stopIfSqlNotOK(session, "insert into customer values(4567,'Company',NULL,'Natices Devices','79908','174 Wilson Avenue,#97')")
    stopIfSqlNotOK(session, "insert into customer values(4568,'Company',NULL,'Citems Incorporated','76524','469 Poplar Square,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4569,'Company',NULL,'Comagated Research','76580','373 Seventh Street,#74')")
    stopIfSqlNotOK(session, "insert into customer values(4570,'Company',NULL,'Pacle','98065','305 Eighth Boulevard,#149')")
    stopIfSqlNotOK(session, "insert into customer values(4571,'Company',NULL,'Orporpork Research','78379','20 Adams Boulevard,#61')")
    stopIfSqlNotOK(session, "insert into customer values(4572,'Company',NULL,'Tems','76637','461 Eleventh Blvd,#146')")
    stopIfSqlNotOK(session, "insert into customer values(4573,'Company',NULL,'Sems','76627','6 Pine St.,#23')")
    stopIfSqlNotOK(session, "insert into customer values(4574,'Company',NULL,'Antegration','78074','105 Laurel Avenue,#1')")
    stopIfSqlNotOK(session, "insert into customer values(4575,'Company',NULL,'Vlsigro Development','77284','335 Elm St.,#87')")
    stopIfSqlNotOK(session, "insert into customer values(4576,'Company',NULL,'Arch','77364','313 Pine Lane,#76')")
    stopIfSqlNotOK(session, "insert into customer values(4577,'Company',NULL,'Sign Group','76051','418 Cherry St.,#8')")
    stopIfSqlNotOK(session, "insert into customer values(4578,'Company',NULL,'Systems Investments','78371','381 Lakeview Drive,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4579,'Company',NULL,'Equita Asia','76034','270 Davis Blvd,#183')")
    stopIfSqlNotOK(session, "insert into customer values(4580,'Company',NULL,'Techs GmbH','88536','475 Ridge Avenue,#128')")
    stopIfSqlNotOK(session, "insert into customer values(4581,'Company',NULL,'Adobellenic Germany','36026','38 Davis Place,#197')")
    stopIfSqlNotOK(session, "insert into customer values(4582,'Company',NULL,'MIC','59831','140 Birch Street,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4583,'Company',NULL,'Bron Corporation','76574','98 Dogwood Blvd,#53')")
    stopIfSqlNotOK(session, "insert into customer values(4584,'Company',NULL,'Cohewle Europe','76026','464 Church Boulevard,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4585,'Company',NULL,'Chnologilog, Inc','75482','185 Cedar Ave,#134')")
    stopIfSqlNotOK(session, "insert into customer values(4586,'Company',NULL,'Digratel Research','75444','466 Seventh Place,#191')")
    stopIfSqlNotOK(session, "insert into customer values(4587,'Company',NULL,'Zita Design','02822','23 Wilson Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(4588,'Company',NULL,'Stor Design','76092','424 Spring St.,#14')")
    stopIfSqlNotOK(session, "insert into customer values(4589,'Company',NULL,'Phoo Systems, Inc','33576','328 Railroad Blvd,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4590,'Company',NULL,'Denetcsi','31513','5 Twelfth St.,#80')")
    stopIfSqlNotOK(session, "insert into customer values(4591,'Company',NULL,'Cohernal Group','78549','33 Railroad Ave,#107')")
    stopIfSqlNotOK(session, "insert into customer values(4592,'Company',NULL,'Systed Investments','76253','34 Lake Walk,#146')")
    stopIfSqlNotOK(session, "insert into customer values(4593,'Company',NULL,'Probeletwork','35010','34 Hillcrest Walk,#34')")
    stopIfSqlNotOK(session, "insert into customer values(4594,'Company',NULL,'Ationersa','78566','367 Jefferson Avenue,#22')")
    stopIfSqlNotOK(session, "insert into customer values(4595,'Company',NULL,'Dents PLC','75057','112 Cedar Place,#132')")
    stopIfSqlNotOK(session, "insert into customer values(4596,'Company',NULL,'Daphoo, Inc','76052','469 Ridge Blvd,#66')")
    stopIfSqlNotOK(session, "insert into customer values(4597,'Company',NULL,'Ciantum Ventures','77561','259 Second Avenue,#187')")
    stopIfSqlNotOK(session, "insert into customer values(4598,'Company',NULL,'Aphips','75474','423 Lakeview Ave,#15')")
    stopIfSqlNotOK(session, "insert into customer values(4599,'Company',NULL,'Saclec Research','76060','119 Jefferson Walk,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4600,'Company',NULL,'Entech Systems, Inc','62306','208 Meadow St.,#6')")
    stopIfSqlNotOK(session, "insert into customer values(4601,'Company',NULL,'Quiphipmenc Research','78062','429 Dogwood Boulevard,#24')")
    stopIfSqlNotOK(session, "insert into customer values(4602,'Company',NULL,'Pexxon','79029','381 Cherry Square,#171')")
    stopIfSqlNotOK(session, "insert into customer values(4603,'Company',NULL,'MIC Europe','75489','170 Miller Street,#90')")
    stopIfSqlNotOK(session, "insert into customer values(4604,'Company',NULL,'Anics Ventures','78124','353 West Drive,#139')")
    stopIfSqlNotOK(session, "insert into customer values(4605,'Company',NULL,'Technologity Research','79005','363 Dogwood Lane,#173')")
    stopIfSqlNotOK(session, "insert into customer values(4606,'Company',NULL,'Corology Incorporated','77418','275 Willow Parkway,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4607,'Company',NULL,'Gram','14877','327 Green Ave,#158')")
    stopIfSqlNotOK(session, "insert into customer values(4608,'Company',NULL,'Asocirrus USA','77660','180 Smith St.,#152')")
    stopIfSqlNotOK(session, "insert into customer values(4609,'Company',NULL,'Mcafee USA','18087','465 Davis Blvd,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4610,'Company',NULL,'Ultrosys Research','28072','306 Cherry Square,#27')")
    stopIfSqlNotOK(session, "insert into customer values(4611,'Company',NULL,'Teridisced Technology Partners','18979','199 Main Square,#178')")
    stopIfSqlNotOK(session, "insert into customer values(4612,'Company',NULL,'Aphal USA','40153','45 Fifteenth St.,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4613,'Company',NULL,'Siliata Investments','76029','127 South Walk,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4614,'Company',NULL,'Ness Incorporated','76626','34 Adams Drive,#108')")
    stopIfSqlNotOK(session, "insert into customer values(4615,'Company',NULL,'Inetwor','75057','278 Park Place,#45')")
    stopIfSqlNotOK(session, "insert into customer values(4616,'Company',NULL,'Graltroup, Inc','75834','411 Seventh Street,#181')")
    stopIfSqlNotOK(session, "insert into customer values(4617,'Company',NULL,'Atieberese Technology','77957','53 Fourth St.,#191')")
    stopIfSqlNotOK(session, "insert into customer values(4618,'Company',NULL,'Systems','75076','199 Eighth Parkway,#41')")
    stopIfSqlNotOK(session, "insert into customer values(4619,'Company',NULL,'ELL PLC','95046','32 Pine Lane,#64')")
    stopIfSqlNotOK(session, "insert into customer values(4620,'Company',NULL,'Altd Consulting','05154','188 Chestnut Parkway,#122')")
    stopIfSqlNotOK(session, "insert into customer values(4621,'Company',NULL,'Miced Technology Partners','22737','295 Pine Street,#60')")
    stopIfSqlNotOK(session, "insert into customer values(4622,'Company',NULL,'Babbay Incorporated','78075','261 Lakeview Avenue,#37')")
    stopIfSqlNotOK(session, "insert into customer values(4623,'Company',NULL,'Ints','75064','103 Maple St.,#189')")
    stopIfSqlNotOK(session, "insert into customer values(4624,'Company',NULL,'INE Corporation','75435','133 Ash Blvd,#200')")
    stopIfSqlNotOK(session, "insert into customer values(4625,'Company',NULL,'Devicernatio','75423','147 Fifteenth Walk,#79')")
    stopIfSqlNotOK(session, "insert into customer values(4626,'Company',NULL,'Systerit Devices','75144','286 Oak Walk,#104')")
    stopIfSqlNotOK(session, "insert into customer values(4627,'Company',NULL,'Cyprogy PLC','16611','461 Main St.,#103')")
    stopIfSqlNotOK(session, "insert into customer values(4628,'Company',NULL,'Ness','78960','82 Ridge Parkway,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4629,'Company',NULL,'Solutechs Technology Partners','78526','327 Park Place,#32')")
    stopIfSqlNotOK(session, "insert into customer values(4630,'Company',NULL,'Intems Systems, Inc','75784','187 Jefferson Blvd,#160')")
    stopIfSqlNotOK(session, "insert into customer values(4631,'Company',NULL,'RED','76234','212 Williams Drive,#162')")
    stopIfSqlNotOK(session, "insert into customer values(4632,'Company',NULL,'Velgg Manufacturing','31513','456 Hill Square,#155')")
    stopIfSqlNotOK(session, "insert into customer values(4633,'Company',NULL,'Adevice Technology Partners','76578','146 South Place,#157')")
    stopIfSqlNotOK(session, "insert into customer values(4634,'Company',NULL,'Mics Systems, Inc','85550','276 Willow St.,#71')")
    stopIfSqlNotOK(session, "insert into customer values(4635,'Company',NULL,'Ronlic Consulting','04764','54 Spruce Road,#198')")
    stopIfSqlNotOK(session, "insert into customer values(4636,'Company',NULL,'Zitand Asia','75031','156 Second Walk,#78')")
    stopIfSqlNotOK(session, "insert into customer values(4637,'Company',NULL,'Pincohewley Devices','79316','332 Pine St.,#79')")
    stopIfSqlNotOK(session, "insert into customer values(4638,'Company',NULL,'Inceneasoft, Inc','77231','377 Elm Drive,#105')")
    stopIfSqlNotOK(session, "insert into customer values(4639,'Company',NULL,'COR Technology','76072','471 Eleventh Walk,#5')")
    stopIfSqlNotOK(session, "insert into customer values(4640,'Company',NULL,'Soluton Japan','29682','385 Fourteenth Boulevard,#29')")
    stopIfSqlNotOK(session, "insert into customer values(4641,'Company',NULL,'LAM Devices','43761','93 Willow Drive,#122')")
    stopIfSqlNotOK(session, "insert into customer values(4642,'Company',NULL,'Systed Germany','78351','432 Green Blvd,#100')")
    stopIfSqlNotOK(session, "insert into customer values(4643,'Company',NULL,'CON Technology Partners','75636','414 Lakeview Avenue,#23')")
    stopIfSqlNotOK(session, "insert into customer values(4644,'Company',NULL,'Archicrogy Group','91773','426 Adams Place,#63')")
    stopIfSqlNotOK(session, "insert into customer values(4645,'Company',NULL,'Tems','50138','375 Eleventh Square,#120')")
    stopIfSqlNotOK(session, "insert into customer values(4646,'Company',NULL,'Devicor PLC','88058','69 Birch Boulevard,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4647,'Company',NULL,'Leadevicroup','75861','91 Jackson Walk,#46')")
    stopIfSqlNotOK(session, "insert into customer values(4648,'Company',NULL,'Logy Japan','77404','117 Fourteenth Ave,#19')")
    stopIfSqlNotOK(session, "insert into customer values(4649,'Company',NULL,'Generisk','79527','144 Sycamore Square,#121')")
    stopIfSqlNotOK(session, "insert into customer values(4650,'Company',NULL,'Caerizonix USA','30273','341 Davis Place,#172')")
    stopIfSqlNotOK(session, "insert into customer values(4651,'Company',NULL,'NAL PLC','56543','299 Meadow Ave,#58')")
    stopIfSqlNotOK(session, "insert into customer values(4652,'Company',NULL,'Lsiley','97486','15 Third Blvd,#106')")
    stopIfSqlNotOK(session, "insert into customer values(4653,'Company',NULL,'Pinces Investments','62306','423 Sunset Square,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4654,'Company',NULL,'Afee Technology','78150','334 Eighth Square,#133')")
    stopIfSqlNotOK(session, "insert into customer values(4655,'Company',NULL,'Sintediatems Corporation','75980','230 Franklin Boulevard,#122')")
    stopIfSqlNotOK(session, "insert into customer values(4656,'Company',NULL,'Exascon Incorporated','76233','321 Thirteenth Square,#193')")
    stopIfSqlNotOK(session, "insert into customer values(4657,'Company',NULL,'Gration Systems, Inc','75903','112 Fifth Street,#141')")
    stopIfSqlNotOK(session, "insert into customer values(4658,'Company',NULL,'Vanic Ventures','98027','191 Center Lane,#31')")
    stopIfSqlNotOK(session, "insert into customer values(4659,'Company',NULL,'Nology Research','76640','319 Franklin Road,#29')")
    stopIfSqlNotOK(session, "insert into customer values(4660,'Company',NULL,'ARE Design','61412','192 Seventh Parkway,#165')")
    stopIfSqlNotOK(session, "insert into customer values(4661,'Company',NULL,'Tany','15376','226 Pine Blvd,#147')")
    stopIfSqlNotOK(session, "insert into customer values(4662,'Company',NULL,'Meriaa Consulting','79031','77 Adams Drive,#129')")
    stopIfSqlNotOK(session, "insert into customer values(4663,'Company',NULL,'Dems Manufacturing','17032','379 Spring Avenue,#101')")
    stopIfSqlNotOK(session, "insert into customer values(4664,'Company',NULL,'Aridia Development','85349','350 Sunset Place,#143')")
    stopIfSqlNotOK(session, "insert into customer values(4665,'Company',NULL,'Ratmerianc','75120','152 Fourth Boulevard,#116')")
    stopIfSqlNotOK(session, "insert into customer values(4666,'Company',NULL,'Ations Consulting','75491','75 Main St.,#30')")
    stopIfSqlNotOK(session, "insert into customer values(4667,'Company',NULL,'Silintumed Investments','75450','291 Ridge Ave,#175')")
    stopIfSqlNotOK(session, "insert into customer values(4668,'Company',NULL,'Denear','79095','353 Jefferson Blvd,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4669,'Company',NULL,'OAK Devices','76666','96 Second Blvd,#32')")
    stopIfSqlNotOK(session, "insert into customer values(4670,'Company',NULL,'GRA','77489','431 Willow Ave,#177')")
    stopIfSqlNotOK(session, "insert into customer values(4671,'Company',NULL,'Soft GmbH','79343','307 Lincoln Blvd,#97')")
    stopIfSqlNotOK(session, "insert into customer values(4672,'Company',NULL,'Hewlechs Germany','79549','90 Ash Road,#175')")
    stopIfSqlNotOK(session, "insert into customer values(4673,'Company',NULL,'Sint','93160','88 Twelfth Walk,#183')")
    stopIfSqlNotOK(session, "insert into customer values(4674,'Company',NULL,'Ation Incorporated','65714','437 Maple Road,#141')")
    stopIfSqlNotOK(session, "insert into customer values(4675,'Company',NULL,'SAN USA','79246','287 Jefferson Place,#80')")
    stopIfSqlNotOK(session, "insert into customer values(4676,'Company',NULL,'Devickarchs Corporation','85346','342 Williams Walk,#13')")
    stopIfSqlNotOK(session, "insert into customer values(4677,'Company',NULL,'Etconlicro GmbH','79734','17 Broadway Street,#184')")
    stopIfSqlNotOK(session, "insert into customer values(4678,'Company',NULL,'Softward Consulting','47971','328 Fifth Ave,#66')")
    stopIfSqlNotOK(session, "insert into customer values(4679,'Company',NULL,'Yahl Group','91351','233 Williams Drive,#52')")
    stopIfSqlNotOK(session, "insert into customer values(4680,'Company',NULL,'Mcate PLC','76028','360 Seventh Street,#83')")
    stopIfSqlNotOK(session, "insert into customer values(4681,'Company',NULL,'Systed Ventures','87556','338 Walnut Ave,#55')")
    stopIfSqlNotOK(session, "insert into customer values(4682,'Company',NULL,'Micro Ventures','79002','257 Lincoln Lane,#59')")
    stopIfSqlNotOK(session, "insert into customer values(4683,'Company',NULL,'Cented Germany','92253','442 Elm Place,#18')")
    stopIfSqlNotOK(session, "insert into customer values(4684,'Company',NULL,'Adiancork Manufacturing','22021','7 Eleventh Avenue,#90')")
    stopIfSqlNotOK(session, "insert into customer values(4685,'Company',NULL,'Cropre Japan','16918','293 Twelfth Blvd,#143')")
    stopIfSqlNotOK(session, "insert into customer values(4686,'Company',NULL,'Mated Corporation','90091','405 Madison Parkway,#155')")
    stopIfSqlNotOK(session, "insert into customer values(4687,'Company',NULL,'Corporne','76661','312 Third Street,#38')")
    stopIfSqlNotOK(session, "insert into customer values(4688,'Company',NULL,'Quicomputems Group','76675','142 Center Parkway,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4689,'Company',NULL,'TEL Development','78665','169 Sunset Road,#1')")
    stopIfSqlNotOK(session, "insert into customer values(4690,'Company',NULL,'Ulte Incorporated','75147','306 Jefferson Road,#70')")
    stopIfSqlNotOK(session, "insert into customer values(4691,'Company',NULL,'Yahoenuspe Group','61753','341 Valley Place,#59')")
    stopIfSqlNotOK(session, "insert into customer values(4692,'Company',NULL,'Atincenus Ventures','50054','99 Thirteenth Parkway,#28')")
    stopIfSqlNotOK(session, "insert into customer values(4693,'Company',NULL,'Incoak Japan','77830','307 Elm Blvd,#192')")
    stopIfSqlNotOK(session, "insert into customer values(4694,'Company',NULL,'Systems Manufacturing','75847','102 Poplar Square,#133')")
    stopIfSqlNotOK(session, "insert into customer values(4695,'Company',NULL,'Systemic USA','79502','360 Spruce Walk,#200')")
    stopIfSqlNotOK(session, "insert into customer values(4696,'Company',NULL,'Lsil Germany','76155','194 Willow St.,#120')")
    stopIfSqlNotOK(session, "insert into customer values(4697,'Company',NULL,'Corapple Technology Partners','89024','459 Chestnut Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(4698,'Company',NULL,'Tech','79745','80 Eleventh Drive,#66')")
    stopIfSqlNotOK(session, "insert into customer values(4699,'Company',NULL,'Quitems Manufacturing','64862','173 Lee Road,#136')")
    stopIfSqlNotOK(session, "insert into customer values(4700,'Company',NULL,'PROPRO','77855','64 Third St.,#91')")
    stopIfSqlNotOK(session, "insert into customer values(4701,'Company',NULL,'Cisk','18435','292 Twelfth Place,#13')")
    stopIfSqlNotOK(session, "insert into customer values(4702,'Company',NULL,'Catems PLC','76547','236 Jefferson Place,#114')")
    stopIfSqlNotOK(session, "insert into customer values(4703,'Company',NULL,'Elechnovel Investments','87574','415 Valley Parkway,#37')")
    stopIfSqlNotOK(session, "insert into customer values(4704,'Company',NULL,'Entech Systems, Inc','07461','60 Sycamore Boulevard,#89')")
    stopIfSqlNotOK(session, "insert into customer values(4705,'Company',NULL,'Quiphipmenc Research','78652','316 Ridge Drive,#60')")
    stopIfSqlNotOK(session, "insert into customer values(4706,'Company',NULL,'Pexxon','79508','307 Green St.,#177')")
    stopIfSqlNotOK(session, "insert into customer values(4707,'Company',NULL,'MIC Europe','79955','438 Central Lane,#130')")
    stopIfSqlNotOK(session, "insert into customer values(4708,'Company',NULL,'Anics Ventures','75833','333 Adams Lane,#3')")
    stopIfSqlNotOK(session, "insert into customer values(4709,'Company',NULL,'Technologity Research','56523','423 Chestnut St.,#43')")
    stopIfSqlNotOK(session, "insert into customer values(4710,'Company',NULL,'Corology Incorporated','66403','103 Poplar Road,#64')")
    stopIfSqlNotOK(session, "insert into customer values(4711,'Company',NULL,'Gram','83441','28 Wilson Square,#60')")
    stopIfSqlNotOK(session, "insert into customer values(4712,'Company',NULL,'Asocirrus USA','78072','214 Cedar Lane,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4713,'Company',NULL,'Mcafee USA','76525','451 Railroad Street,#198')")
    stopIfSqlNotOK(session, "insert into customer values(4714,'Company',NULL,'Ultrosys Research','92073','29 Eighth Drive,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4715,'Company',NULL,'Teridisced Technology Partners','08868','20 Seventh Lane,#4')")
    stopIfSqlNotOK(session, "insert into customer values(4716,'Company',NULL,'Aphal USA','62682','70 Washington Road,#166')")
    stopIfSqlNotOK(session, "insert into customer values(4717,'Company',NULL,'Siliata Investments','78568','104 Spring Parkway,#178')")
    stopIfSqlNotOK(session, "insert into customer values(4718,'Company',NULL,'Ness Incorporated','75968','317 Thirteenth Ave,#164')")
    stopIfSqlNotOK(session, "insert into customer values(4719,'Company',NULL,'Inetwor','78620','103 Ridge Street,#140')")
    stopIfSqlNotOK(session, "insert into customer values(4720,'Company',NULL,'Graltroup, Inc','77598','488 River Street,#91')")
    stopIfSqlNotOK(session, "insert into customer values(4721,'Company',NULL,'Atieberese Technology','50040','366 South Blvd,#39')")
    stopIfSqlNotOK(session, "insert into customer values(4722,'Company',NULL,'Systems','78343','191 Main St.,#35')")
    stopIfSqlNotOK(session, "insert into customer values(4723,'Company',NULL,'ELL PLC','24054','367 Poplar Square,#35')")
    stopIfSqlNotOK(session, "insert into customer values(4724,'Company',NULL,'Altd Consulting','78537','340 Lakeview Square,#117')")
    stopIfSqlNotOK(session, "insert into customer values(4725,'Company',NULL,'Miced Technology Partners','88521','83 Second Street,#163')")
    stopIfSqlNotOK(session, "insert into customer values(4726,'Company',NULL,'Babbay Incorporated','29666','345 Green Ave,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4727,'Company',NULL,'Ints','75005','457 Woodland Blvd,#166')")
    stopIfSqlNotOK(session, "insert into customer values(4728,'Company',NULL,'INE Corporation','76631','131 Madison Walk,#176')")
    stopIfSqlNotOK(session, "insert into customer values(4729,'Company',NULL,'Devicernatio','78362','412 Pine Place,#67')")
    stopIfSqlNotOK(session, "insert into customer values(4730,'Company',NULL,'Systerit Devices','77426','360 Forest Parkway,#168')")
    stopIfSqlNotOK(session, "insert into customer values(4731,'Company',NULL,'Cyprogy PLC','79045','500 River Place,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4732,'Company',NULL,'Ness','07021','46 Laurel Place,#13')")
    stopIfSqlNotOK(session, "insert into customer values(4733,'Company',NULL,'Solutechs Technology Partners','97431','404 River Blvd,#64')")
    stopIfSqlNotOK(session, "insert into customer values(4734,'Company',NULL,'Intems Systems, Inc','78144','76 Laurel St.,#56')")
    stopIfSqlNotOK(session, "insert into customer values(4735,'Company',NULL,'RED','77611','230 Fifteenth Square,#110')")
    stopIfSqlNotOK(session, "insert into customer values(4736,'Company',NULL,'Velgg Manufacturing','77597','490 Fourth Square,#81')")
    stopIfSqlNotOK(session, "insert into customer values(4737,'Company',NULL,'Adevice Technology Partners','12192','311 Highland Square,#172')")
    stopIfSqlNotOK(session, "insert into customer values(4738,'Company',NULL,'Mics Systems, Inc','72355','184 Davis Lane,#60')")
    stopIfSqlNotOK(session, "insert into customer values(4739,'Company',NULL,'Ronlic Consulting','78618','340 Mill Boulevard,#9')")
    stopIfSqlNotOK(session, "insert into customer values(4740,'Company',NULL,'Zitand Asia','04769','23 Tenth Avenue,#52')")
    stopIfSqlNotOK(session, "insert into customer values(4741,'Company',NULL,'Pincohewley Devices','76442','317 Twelfth Square,#191')")
    stopIfSqlNotOK(session, "insert into customer values(4742,'Company',NULL,'Inceneasoft, Inc','14005','139 First Place,#174')")
    stopIfSqlNotOK(session, "insert into customer values(4743,'Company',NULL,'COR Technology','77598','103 Lee Ave,#17')")
    stopIfSqlNotOK(session, "insert into customer values(4744,'Company',NULL,'Soluton Japan','41510','195 Spruce Lane,#160')")
    stopIfSqlNotOK(session, "insert into customer values(4745,'Company',NULL,'LAM Devices','78880','355 Lakeview Ave,#106')")
    stopIfSqlNotOK(session, "insert into customer values(4746,'Company',NULL,'Systed Germany','76526','18 Ash Street,#132')")
    stopIfSqlNotOK(session, "insert into customer values(4747,'Company',NULL,'CON Technology Partners','75851','266 Lincoln Boulevard,#108')")
    stopIfSqlNotOK(session, "insert into customer values(4748,'Company',NULL,'Archicrogy Group','77665','462 Cherry St.,#99')")
    stopIfSqlNotOK(session, "insert into customer values(4749,'Company',NULL,'Tems','78645','289 West Street,#7')")
    stopIfSqlNotOK(session, "insert into customer values(4750,'Company',NULL,'Devicor PLC','48226','299 Ridge St.,#11')")
    stopIfSqlNotOK(session, "insert into customer values(4751,'Company',NULL,'Leadevicroup','33441','343 Laurel Walk,#136')")
    stopIfSqlNotOK(session, "insert into customer values(4752,'Company',NULL,'Logy Japan','76517','258 Railroad Ave,#28')")
    stopIfSqlNotOK(session, "insert into customer values(4753,'Company',NULL,'Generisk','66086','331 Thirteenth Square,#58')")
    stopIfSqlNotOK(session, "insert into customer values(4754,'Company',NULL,'Caerizonix USA','76859','366 Davis Square,#89')")
    stopIfSqlNotOK(session, "insert into customer values(4755,'Company',NULL,'NAL PLC','87527','1 Park Place,#186')")
    stopIfSqlNotOK(session, "insert into customer values(4756,'Company',NULL,'Lsiley','95142','389 Smith Lane,#138')")
    stopIfSqlNotOK(session, "insert into customer values(4757,'Company',NULL,'Pinces Investments','15776','153 Second Square,#56')")
    stopIfSqlNotOK(session, "insert into customer values(4758,'Company',NULL,'Afee Technology','78564','130 Church Ave,#8')")
    stopIfSqlNotOK(session, "insert into customer values(4759,'Company',NULL,'Sintediatems Corporation','00754','320 Ash Blvd,#43')")
    stopIfSqlNotOK(session, "insert into customer values(4760,'Company',NULL,'Exascon Incorporated','76534','486 Oak Blvd,#12')")
    stopIfSqlNotOK(session, "insert into customer values(4761,'Company',NULL,'Gration Systems, Inc','60488','277 Hill Boulevard,#139')")
    stopIfSqlNotOK(session, "insert into customer values(4762,'Company',NULL,'Vanic Ventures','69155','87 Forest Parkway,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4763,'Company',NULL,'Nology Research','38047','296 Oak Lane,#9')")
    stopIfSqlNotOK(session, "insert into customer values(4764,'Company',NULL,'ARE Design','77664','337 Walnut Road,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4765,'Company',NULL,'Tany','16027','19 Washington Walk,#87')")
    stopIfSqlNotOK(session, "insert into customer values(4766,'Company',NULL,'Meriaa Consulting','77844','392 South Square,#166')")
    stopIfSqlNotOK(session, "insert into customer values(4767,'Company',NULL,'Dems Manufacturing','75140','129 Sycamore Boulevard,#63')")
    stopIfSqlNotOK(session, "insert into customer values(4768,'Company',NULL,'Aridia Development','74008','398 Walnut Boulevard,#65')")
    stopIfSqlNotOK(session, "insert into customer values(4769,'Company',NULL,'Ratmerianc','97213','272 Lakeview St.,#140')")
    stopIfSqlNotOK(session, "insert into customer values(4770,'Company',NULL,'Ations Consulting','38579','93 Lincoln Drive,#153')")
    stopIfSqlNotOK(session, "insert into customer values(4771,'Company',NULL,'Silintumed Investments','75563','116 Cherry Ave,#1')")
    stopIfSqlNotOK(session, "insert into customer values(4772,'Company',NULL,'Denear','66859','309 Cherry Parkway,#116')")
    stopIfSqlNotOK(session, "insert into customer values(4773,'Company',NULL,'OAK Devices','14507','164 Broadway Drive,#31')")
    stopIfSqlNotOK(session, "insert into customer values(4774,'Company',NULL,'GRA','78370','319 Franklin Boulevard,#11')")
    stopIfSqlNotOK(session, "insert into customer values(4775,'Company',NULL,'Soft GmbH','75958','319 Second Lane,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4776,'Company',NULL,'Hewlechs Germany','75560','276 First Blvd,#174')")
    stopIfSqlNotOK(session, "insert into customer values(4777,'Company',NULL,'Sint','77473','359 Fifteenth Blvd,#158')")
    stopIfSqlNotOK(session, "insert into customer values(4778,'Company',NULL,'Ation Incorporated','78954','271 Central Place,#47')")
    stopIfSqlNotOK(session, "insert into customer values(4779,'Company',NULL,'SAN USA','95055','342 Locust Boulevard,#118')")
    stopIfSqlNotOK(session, "insert into customer values(4780,'Company',NULL,'Devickarchs Corporation','79937','442 Third Ave,#36')")
    stopIfSqlNotOK(session, "insert into customer values(4781,'Company',NULL,'Etconlicro GmbH','87125','3 North Avenue,#192')")
    stopIfSqlNotOK(session, "insert into customer values(4782,'Company',NULL,'Softward Consulting','78393','190 East Walk,#165')")
    stopIfSqlNotOK(session, "insert into customer values(4783,'Company',NULL,'Yahl Group','60935','82 Poplar Lane,#135')")
    stopIfSqlNotOK(session, "insert into customer values(4784,'Company',NULL,'Mcate PLC','78839','225 Broadway Street,#96')")
    stopIfSqlNotOK(session, "insert into customer values(4785,'Company',NULL,'Systed Ventures','76140','288 Walnut Street,#80')")
    stopIfSqlNotOK(session, "insert into customer values(4786,'Company',NULL,'Micro Ventures','75561','451 Hill Lane,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4787,'Company',NULL,'Cented Germany','78548','392 North Place,#148')")
    stopIfSqlNotOK(session, "insert into customer values(4788,'Company',NULL,'Adiancork Manufacturing','76037','476 Thirteenth Place,#42')")
    stopIfSqlNotOK(session, "insert into customer values(4789,'Company',NULL,'Cropre Japan','17860','482 Madison Blvd,#92')")
    stopIfSqlNotOK(session, "insert into customer values(4790,'Company',NULL,'Mated Corporation','31019','226 Birch Road,#22')")
    stopIfSqlNotOK(session, "insert into customer values(4791,'Company',NULL,'Corporne','78526','354 Second Street,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4792,'Company',NULL,'Quicomputems Group','75428','135 Fourth St.,#112')")
    stopIfSqlNotOK(session, "insert into customer values(4793,'Company',NULL,'TEL Development','77357','343 Pine Drive,#77')")
    stopIfSqlNotOK(session, "insert into customer values(4794,'Company',NULL,'Ulte Incorporated','76254','272 View Road,#34')")
    stopIfSqlNotOK(session, "insert into customer values(4795,'Company',NULL,'Yahoenuspe Group','38579','338 Eighth Boulevard,#17')")
    stopIfSqlNotOK(session, "insert into customer values(4796,'Company',NULL,'Atincenus Ventures','75631','215 Wilson Lane,#45')")
    stopIfSqlNotOK(session, "insert into customer values(4797,'Company',NULL,'Incoak Japan','18847','117 Chestnut Ave,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4798,'Company',NULL,'Systems Manufacturing','56319','483 Spruce Street,#200')")
    stopIfSqlNotOK(session, "insert into customer values(4799,'Company',NULL,'Systemic USA','77376','68 Sycamore Avenue,#156')")
    stopIfSqlNotOK(session, "insert into customer values(4800,'Company',NULL,'Lsil Germany','78631','264 Washington Road,#118')")
    stopIfSqlNotOK(session, "insert into customer values(4801,'Company',NULL,'Corapple Technology Partners','04275','170 Johnson Walk,#15')")
    stopIfSqlNotOK(session, "insert into customer values(4802,'Company',NULL,'Tech','91778','251 Walnut Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(4803,'Company',NULL,'Quitems Manufacturing','76045','194 Park Blvd,#190')")
    stopIfSqlNotOK(session, "insert into customer values(4804,'Company',NULL,'PROPRO','93160','250 Fourth Lane,#55')")
    stopIfSqlNotOK(session, "insert into customer values(4805,'Company',NULL,'Cisk','61753','92 Lake Road,#31')")
    stopIfSqlNotOK(session, "insert into customer values(4806,'Company',NULL,'Catems PLC','78714','28 Johnson Lane,#185')")
    stopIfSqlNotOK(session, "insert into customer values(4807,'Company',NULL,'Elechnovel Investments','78931','88 Davis Lane,#60')")
    stopIfSqlNotOK(session, "insert into customer values(4808,'Company',NULL,'Devicor PLC','76875','309 Adams Parkway,#77')")
    stopIfSqlNotOK(session, "insert into customer values(4809,'Company',NULL,'Leadevicroup','77533','317 Washington Road,#15')")
    stopIfSqlNotOK(session, "insert into customer values(4810,'Company',NULL,'Logy Japan','94070','302 Second Walk,#21')")
    stopIfSqlNotOK(session, "insert into customer values(4811,'Company',NULL,'Generisk','78016','442 Madison Avenue,#150')")
    stopIfSqlNotOK(session, "insert into customer values(4812,'Company',NULL,'Caerizonix USA','97213','351 Cherry Avenue,#141')")
    stopIfSqlNotOK(session, "insert into customer values(4813,'Company',NULL,'NAL PLC','15662','215 Birch Blvd,#115')")
    stopIfSqlNotOK(session, "insert into customer values(4814,'Company',NULL,'Lsiley','78652','282 Sixth Parkway,#70')")
    stopIfSqlNotOK(session, "insert into customer values(4815,'Company',NULL,'Pinces Investments','45727','206 Mill Drive,#12')")
    stopIfSqlNotOK(session, "insert into customer values(4816,'Company',NULL,'Afee Technology','77655','276 Poplar Lane,#43')")
    stopIfSqlNotOK(session, "insert into customer values(4817,'Company',NULL,'Sintediatems Corporation','76455','473 View Avenue,#130')")
    stopIfSqlNotOK(session, "insert into customer values(4818,'Company',NULL,'Exascon Incorporated','77984','33 Willow Blvd,#160')")
    stopIfSqlNotOK(session, "insert into customer values(4819,'Company',NULL,'Gration Systems, Inc','79958','203 Maple Drive,#189')")
    stopIfSqlNotOK(session, "insert into customer values(4820,'Company',NULL,'Vanic Ventures','98392','120 East Boulevard,#198')")
    stopIfSqlNotOK(session, "insert into customer values(4821,'Company',NULL,'Nology Research','75417','45 Johnson Blvd,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4822,'Company',NULL,'ARE Design','65439','189 Twelfth Boulevard,#184')")
    stopIfSqlNotOK(session, "insert into customer values(4823,'Company',NULL,'Tany','76866','159 Miller Drive,#53')")
    stopIfSqlNotOK(session, "insert into customer values(4824,'Company',NULL,'Meriaa Consulting','22314','9 Spring Street,#135')")
    stopIfSqlNotOK(session, "insert into customer values(4825,'Company',NULL,'Dems Manufacturing','78677','418 Wilson Place,#118')")
    stopIfSqlNotOK(session, "insert into customer values(4826,'Company',NULL,'Aridia Development','78656','449 Wilson St.,#103')")
    stopIfSqlNotOK(session, "insert into customer values(4827,'Company',NULL,'Ratmerianc','77985','393 Chestnut Square,#162')")
    stopIfSqlNotOK(session, "insert into customer values(4828,'Company',NULL,'Ations Consulting','93553','50 Williams Place,#9')")
    stopIfSqlNotOK(session, "insert into customer values(4829,'Company',NULL,'Silintumed Investments','77485','163 Broadway Drive,#101')")
    stopIfSqlNotOK(session, "insert into customer values(4830,'Company',NULL,'Denear','40806','238 Taylor Drive,#28')")
    stopIfSqlNotOK(session, "insert into customer values(4831,'Company',NULL,'OAK Devices','77626','379 View Street,#114')")
    stopIfSqlNotOK(session, "insert into customer values(4832,'Company',NULL,'GRA','75850','250 Fifth Road,#155')")
    stopIfSqlNotOK(session, "insert into customer values(4833,'Company',NULL,'Soft GmbH','78886','279 Spring Square,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4834,'Company',NULL,'Hewlechs Germany','76641','92 Chestnut Parkway,#78')")
    stopIfSqlNotOK(session, "insert into customer values(4835,'Company',NULL,'Sint','98824','303 Chestnut Lane,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4836,'Company',NULL,'Ation Incorporated','01885','474 Meadow Boulevard,#186')")
    stopIfSqlNotOK(session, "insert into customer values(4837,'Company',NULL,'SAN USA','75422','268 Hillcrest Ave,#44')")
    stopIfSqlNotOK(session, "insert into customer values(4838,'Company',NULL,'Devickarchs Corporation','77453','101 Smith Street,#84')")
    stopIfSqlNotOK(session, "insert into customer values(4839,'Company',NULL,'Etconlicro GmbH','78549','18 Railroad Place,#130')")
    stopIfSqlNotOK(session, "insert into customer values(4840,'Company',NULL,'Softward Consulting','78951','418 Poplar Ave,#26')")
    stopIfSqlNotOK(session, "insert into customer values(4841,'Company',NULL,'Yahl Group','76621','42 Johnson Street,#41')")
    stopIfSqlNotOK(session, "insert into customer values(4842,'Company',NULL,'Mcate PLC','79019','478 Johnson Blvd,#156')")
    stopIfSqlNotOK(session, "insert into customer values(4843,'Company',NULL,'Systed Ventures','60463','450 Hillcrest Street,#48')")
    stopIfSqlNotOK(session, "insert into customer values(4844,'Company',NULL,'Micro Ventures','75573','39 Second Place,#171')")
    stopIfSqlNotOK(session, "insert into customer values(4845,'Company',NULL,'Cented Germany','78577','320 Laurel St.,#179')")
    stopIfSqlNotOK(session, "insert into customer values(4846,'Company',NULL,'Adiancork Manufacturing','70302','132 East Blvd,#41')")
    stopIfSqlNotOK(session, "insert into customer values(4847,'Company',NULL,'Cropre Japan','78639','248 Willow Place,#91')")
    stopIfSqlNotOK(session, "insert into customer values(4848,'Company',NULL,'Mated Corporation','12148','32 Central Road,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4849,'Company',NULL,'Corporne','77994','258 Lakeview Ave,#191')")
    stopIfSqlNotOK(session, "insert into customer values(4850,'Company',NULL,'Quicomputems Group','04093','294 Third Drive,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4851,'Company',NULL,'TEL Development','75980','62 Miller Road,#33')")
    stopIfSqlNotOK(session, "insert into customer values(4852,'Company',NULL,'Ulte Incorporated','76471','301 Third Lane,#68')")
    stopIfSqlNotOK(session, "insert into customer values(4853,'Company',NULL,'Yahoenuspe Group','76555','179 View Drive,#62')")
    stopIfSqlNotOK(session, "insert into customer values(4854,'Company',NULL,'Atincenus Ventures','76436','154 Railroad Lane,#146')")
    stopIfSqlNotOK(session, "insert into customer values(4855,'Company',NULL,'Incoak Japan','94904','399 North Place,#200')")
    stopIfSqlNotOK(session, "insert into customer values(4856,'Company',NULL,'Systems Manufacturing','76626','261 Laurel Square,#111')")
    stopIfSqlNotOK(session, "insert into customer values(4857,'Company',NULL,'Systemic USA','77554','299 Sycamore Walk,#25')")
    stopIfSqlNotOK(session, "insert into customer values(4858,'Company',NULL,'Lsil Germany','95713','209 Sunset Boulevard,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4859,'Company',NULL,'Corapple Technology Partners','98824','202 Jackson Place,#54')")
    stopIfSqlNotOK(session, "insert into customer values(4860,'Company',NULL,'Tech','75490','440 Lakeview Lane,#77')")
    stopIfSqlNotOK(session, "insert into customer values(4861,'Company',NULL,'Quitems Manufacturing','76377','137 First Road,#101')")
    stopIfSqlNotOK(session, "insert into customer values(4862,'Company',NULL,'PROPRO','77447','484 First Parkway,#99')")
    stopIfSqlNotOK(session, "insert into customer values(4863,'Company',NULL,'Cisk','75944','381 Willow St.,#36')")
    stopIfSqlNotOK(session, "insert into customer values(4864,'Company',NULL,'Catems PLC','58371','50 River Place,#118')")
    stopIfSqlNotOK(session, "insert into customer values(4865,'Company',NULL,'Elechnovel Investments','77374','94 Lakeview Drive,#57')")
    stopIfSqlNotOK(session, "insert into customer values(4866,'Company',NULL,'TEL Development','78001','393 Valley St.,#69')")
    stopIfSqlNotOK(session, "insert into customer values(4867,'Company',NULL,'Ulte Incorporated','97423','22 Jefferson Street,#63')")
    stopIfSqlNotOK(session, "insert into customer values(4868,'Company',NULL,'Yahoenuspe Group','76078','397 Madison Boulevard,#168')")
    stopIfSqlNotOK(session, "insert into customer values(4869,'Company',NULL,'Atincenus Ventures','75125','333 Pine Place,#80')")
    stopIfSqlNotOK(session, "insert into customer values(4870,'Company',NULL,'Incoak Japan','79346','211 Broadway Blvd,#121')")
    stopIfSqlNotOK(session, "insert into customer values(4871,'Company',NULL,'Systems Manufacturing','76254','321 Washington Drive,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4872,'Company',NULL,'Systemic USA','71832','150 Mill Lane,#41')")
    stopIfSqlNotOK(session, "insert into customer values(4873,'Company',NULL,'Lsil Germany','77581','111 Franklin Avenue,#7')")
    stopIfSqlNotOK(session, "insert into customer values(4874,'Company',NULL,'Corapple Technology Partners','77522','314 Fifteenth Lane,#119')")
    stopIfSqlNotOK(session, "insert into customer values(4875,'Company',NULL,'Tech','78372','108 Hill Street,#152')")
    stopIfSqlNotOK(session, "insert into customer values(4876,'Company',NULL,'Quitems Manufacturing','78873','95 Eighth Square,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4877,'Company',NULL,'PROPRO','77453','335 Maple Ave,#148')")
    stopIfSqlNotOK(session, "insert into customer values(4878,'Company',NULL,'Cisk','13158','75 South St.,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4879,'Company',NULL,'Catems PLC','73051','472 Third Blvd,#57')")
    stopIfSqlNotOK(session, "insert into customer values(4880,'Company',NULL,'Elechnovel Investments','79730','81 River Avenue,#149')")
    stopIfSqlNotOK(session, "insert into customer values(4881,'Mrs','Candice','Moore','44650','300 Sunset Parkway,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4882,'Mr','Ray','Taylor','79052','447 Maple Parkway,#23')")
    stopIfSqlNotOK(session, "insert into customer values(4883,'Mr','David','Davis','76360','325 Center Street,#47')")
    stopIfSqlNotOK(session, "insert into customer values(4884,'Mr','David','Moore','47971','283 Eleventh Parkway,#98')")
    stopIfSqlNotOK(session, "insert into customer values(4885,'Mrs','Sandra','Mercer','77629','75 Ash Parkway,#185')")
    stopIfSqlNotOK(session, "insert into customer values(4886,'Mrs','Sharon','Taylor','78881','404 Twelfth Blvd,#74')")
    stopIfSqlNotOK(session, "insert into customer values(4887,'Mr','Adrian','Williams','76267','421 Ash Blvd,#76')")
    stopIfSqlNotOK(session, "insert into customer values(4888,'Mrs','Sherrie','Moore','75754','432 East Street,#89')")
    stopIfSqlNotOK(session, "insert into customer values(4889,'Mrs','Sandra','Williams','22737','106 Walnut Road,#63')")
    stopIfSqlNotOK(session, "insert into customer values(4890,'Mrs','Jessica','Dennis','75502','103 Taylor Drive,#109')")
    stopIfSqlNotOK(session, "insert into customer values(4891,'Mr','Theodore','Moore','75848','264 Smith Square,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4892,'Mr','Jaime','Moore','13634','154 Poplar Place,#157')")
    stopIfSqlNotOK(session, "insert into customer values(4893,'Mr','Francis','Jones','76078','32 Ninth Walk,#58')")
    stopIfSqlNotOK(session, "insert into customer values(4894,'Mr','Joseph','Mccall','38482','404 View Avenue,#59')")
    stopIfSqlNotOK(session, "insert into customer values(4895,'Mrs','Betty','Smith','75833','216 Spring Walk,#62')")
    stopIfSqlNotOK(session, "insert into customer values(4896,'Mr','Alexander','Johnson','76225','235 Fifteenth Street,#76')")
    stopIfSqlNotOK(session, "insert into customer values(4897,'Mrs','Jennifer','Williams','79224','265 North Place,#49')")
    stopIfSqlNotOK(session, "insert into customer values(4898,'Mr','Thomas','Kerr','36543','198 Elm Avenue,#91')")
    stopIfSqlNotOK(session, "insert into customer values(4899,'Mrs','Sandra','Wilson','75021','206 Cherry Drive,#196')")
    stopIfSqlNotOK(session, "insert into customer values(4900,'Mrs','Letha','Davis','76637','478 Cherry Lane,#197')")
    stopIfSqlNotOK(session, "insert into customer values(4901,'Mrs','Kerry','Hardin','76082','237 Elm St.,#88')")
    stopIfSqlNotOK(session, "insert into customer values(4902,'Mrs','Susanne','Taylor','64478','135 Smith Avenue,#22')")
    stopIfSqlNotOK(session, "insert into customer values(4903,'Mr','Thomas','Strong','78017','30 Thirteenth Street,#40')")
    stopIfSqlNotOK(session, "insert into customer values(4904,'Mr','Darryl','King','76445','1 Wilson Parkway,#153')")
    stopIfSqlNotOK(session, "insert into customer values(4905,'Mr','Richard','Mitchell','75438','342 Fifteenth Street,#160')")
    stopIfSqlNotOK(session, "insert into customer values(4906,'Mr','Thomas','Santos','02338','41 Jackson Lane,#125')")
    stopIfSqlNotOK(session, "insert into customer values(4907,'Mr','Charles','Sampson','25904','315 Second Place,#152')")
    stopIfSqlNotOK(session, "insert into customer values(4908,'Mrs','Essie','Moore','00622','410 Elm Road,#51')")
    stopIfSqlNotOK(session, "insert into customer values(4909,'Mrs','Adeline','Johnson','27869','326 Fifth Boulevard,#129')")
    stopIfSqlNotOK(session, "insert into customer values(4910,'Mr','Clifford','Williams','77611','257 Fourth Parkway,#5')")
    stopIfSqlNotOK(session, "insert into customer values(4911,'Mrs','Susan','Taylor','04426','266 Taylor St.,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4912,'Mrs','Sandra','Meyers','05358','53 Third Blvd,#82')")
    stopIfSqlNotOK(session, "insert into customer values(4913,'Mrs','Corinne','Jones','18252','119 Ash Blvd,#49')")
    stopIfSqlNotOK(session, "insert into customer values(4914,'Mrs','Josefina','Davis','87506','251 Pine Square,#21')")
    stopIfSqlNotOK(session, "insert into customer values(4915,'Mr','Clifford','Davis','38047','326 Elm Walk,#124')")
    stopIfSqlNotOK(session, "insert into customer values(4916,'Mrs','Carolyn','Ortiz','75661','223 North Ave,#27')")
    stopIfSqlNotOK(session, "insert into customer values(4917,'Mr','Charles','Taylor','77622','221 Fifteenth Ave,#36')")
    stopIfSqlNotOK(session, "insert into customer values(4918,'Mr','William','Shepard','64024','167 Eighth Parkway,#196')")
    stopIfSqlNotOK(session, "insert into customer values(4919,'Mrs','Tammi','Holmes','77662','446 Oak Ave,#86')")
    stopIfSqlNotOK(session, "insert into customer values(4920,'Mrs','Frankie','Brown','75448','13 Madison Ave,#98')")
    stopIfSqlNotOK(session, "insert into customer values(4921,'Mr','David','Brown','79837','55 West St.,#68')")
    stopIfSqlNotOK(session, "insert into customer values(4922,'Mr','Phillip','Morse','75954','469 West Avenue,#101')")
    stopIfSqlNotOK(session, "insert into customer values(4923,'Mr','James','Hensley','91778','73 Sycamore Square,#193')")
    stopIfSqlNotOK(session, "insert into customer values(4924,'Mrs','Muriel','Johnson','75693','337 Taylor Road,#39')")
    stopIfSqlNotOK(session, "insert into customer values(4925,'Mrs','Maryellen','Wilson','76519','145 Ridge Lane,#48')")
    stopIfSqlNotOK(session, "insert into customer values(4926,'Mr','Alfred','Herrera','79730','210 Oak Boulevard,#164')")
    stopIfSqlNotOK(session, "insert into customer values(4927,'Mrs','Angelia','Williams','79371','61 Franklin Parkway,#94')")
    stopIfSqlNotOK(session, "insert into customer values(4928,'Mr','Charles','Moody','78660','500 Willow Lane,#74')")
    stopIfSqlNotOK(session, "insert into customer values(4929,'Mrs','Janine','Williams','75507','71 College Drive,#7')")
    stopIfSqlNotOK(session, "insert into customer values(4930,'Mrs','Sandra','Miller','14005','12 Cherry Lane,#176')")
    stopIfSqlNotOK(session, "insert into customer values(4931,'Mr','Charles','Harrison','94974','261 Fifteenth Drive,#164')")
    stopIfSqlNotOK(session, "insert into customer values(4932,'Mrs','Ellen','Williams','75491','153 Johnson Street,#170')")
    stopIfSqlNotOK(session, "insert into customer values(4933,'Mrs','Tonia','Jones','76685','24 Center Square,#90')")
    stopIfSqlNotOK(session, "insert into customer values(4934,'Mrs','Rosella','Wilson','76066','174 Broadway Square,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4935,'Mr','Thomas','Peters','52745','278 South Parkway,#135')")
    stopIfSqlNotOK(session, "insert into customer values(4936,'Mrs','Bertha','Moore','78380','104 Main Square,#55')")
    stopIfSqlNotOK(session, "insert into customer values(4937,'Mrs','Carol','Davis','79016','144 Dogwood Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(4938,'Mrs','Nancy','Cash','75356','133 Ash Street,#168')")
    stopIfSqlNotOK(session, "insert into customer values(4939,'Mrs','Latonya','Jones','00673','85 South Place,#164')")
    stopIfSqlNotOK(session, "insert into customer values(4940,'Mr','Zachary','Davis','48226','200 Lee Boulevard,#133')")
    stopIfSqlNotOK(session, "insert into customer values(4941,'Mr','Richard','Munoz','85055','126 Willow Lane,#123')")
    stopIfSqlNotOK(session, "insert into customer values(4942,'Mrs','Juliana','Terry','59353','267 Smith Parkway,#115')")
    stopIfSqlNotOK(session, "insert into customer values(4943,'Mrs','Sylvia','Ortega','19353','338 Walnut Street,#1')")
    stopIfSqlNotOK(session, "insert into customer values(4944,'Mr','Terrence','Williams','78341','311 Adams St.,#58')")
    stopIfSqlNotOK(session, "insert into customer values(4945,'Mrs','Patricia','Davis','88230','201 West Drive,#189')")
    stopIfSqlNotOK(session, "insert into customer values(4946,'Mrs','Sabrina','Davis','78004','395 Willow Road,#64')")
    stopIfSqlNotOK(session, "insert into customer values(4947,'Mrs','Lindsay','Williams','75789','150 Pine St.,#144')")
    stopIfSqlNotOK(session, "insert into customer values(4948,'Mr','Charles','Johnson','31624','29 Fifteenth Square,#100')")
    stopIfSqlNotOK(session, "insert into customer values(4949,'Mrs','Luella','Jones','77984','70 Forest Boulevard,#103')")
    stopIfSqlNotOK(session, "insert into customer values(4950,'Mr','Tyrone','Curry','78161','106 Jackson Place,#47')")
    stopIfSqlNotOK(session, "insert into customer values(4951,'Mr','Thomas','Frye','18252','481 Oak Avenue,#178')")
    stopIfSqlNotOK(session, "insert into customer values(4952,'Mrs','Nancy','Brown','79843','217 Laurel Parkway,#133')")
    stopIfSqlNotOK(session, "insert into customer values(4953,'Mrs','Juliana','Brown','62550','184 Central Avenue,#45')")
    stopIfSqlNotOK(session, "insert into customer values(4954,'Mrs','Dorothy','Miller','78351','332 College Square,#170')")
    stopIfSqlNotOK(session, "insert into customer values(4955,'Mr','Ross','Hernandez','76660','96 Ridge Square,#37')")
    stopIfSqlNotOK(session, "insert into customer values(4956,'Mrs','Carol','Sexton','76249','350 Jefferson Parkway,#49')")
    stopIfSqlNotOK(session, "insert into customer values(4957,'Mrs','Dominique','Mcclain','31519','291 Hill Place,#198')")
    stopIfSqlNotOK(session, "insert into customer values(4958,'Mrs','Margarita','Davis','58760','180 Fifth Boulevard,#70')")
    stopIfSqlNotOK(session, "insert into customer values(4959,'Mrs','Nancy','Williams','76627','16 Broadway Street,#111')")
    stopIfSqlNotOK(session, "insert into customer values(4960,'Mrs','Sharon','Martinez','10580','87 First Walk,#164')")
    stopIfSqlNotOK(session, "insert into customer values(4961,'Mr','Andy','Harding','65439','445 Lakeview Road,#8')")
    stopIfSqlNotOK(session, "insert into customer values(4962,'Mr','Robert','Moore','22021','123 Pine Walk,#137')")
    stopIfSqlNotOK(session, "insert into customer values(4963,'Mrs','Patricia','Wilson','53089','401 Williams Street,#99')")
    stopIfSqlNotOK(session, "insert into customer values(4964,'Mrs','Nancy','Gillespie','98333','427 Fourteenth Parkway,#198')")
    stopIfSqlNotOK(session, "insert into customer values(4965,'Mr','Joseph','Taylor','75434','439 Church Road,#157')")
    stopIfSqlNotOK(session, "insert into customer values(4966,'Mrs','Claudia','Guerra','75755','349 West Walk,#172')")
    stopIfSqlNotOK(session, "insert into customer values(4967,'Mrs','Nancy','Shields','76046','176 River Road,#97')")
    stopIfSqlNotOK(session, "insert into customer values(4968,'Mrs','Jamie','Morton','75555','353 Birch Square,#96')")
    stopIfSqlNotOK(session, "insert into customer values(4969,'Mrs','Julianne','Wilson','87053','48 Park Walk,#114')")
    stopIfSqlNotOK(session, "insert into customer values(4970,'Mr','Dennis','Patel','51545','162 Fifth Lane,#112')")
    stopIfSqlNotOK(session, "insert into customer values(4971,'Mr','Ernest','Page','26385','256 Hill St.,#127')")
    stopIfSqlNotOK(session, "insert into customer values(4972,'Mrs','Nina','Parrish','53933','213 Oak Road,#102')")
    stopIfSqlNotOK(session, "insert into customer values(4973,'Mr','Clyde','Brown','75009','265 Forest Ave,#141')")
    stopIfSqlNotOK(session, "insert into customer values(4974,'Mrs','Jennifer','Cortez','27885','318 Birch Avenue,#178')")
    stopIfSqlNotOK(session, "insert into customer values(4975,'Mr','Bob','Wilson','78065','96 Hillcrest Place,#188')")
    stopIfSqlNotOK(session, "insert into customer values(4976,'Mr','Cory','Miller','76859','152 Meadow St.,#165')")
    stopIfSqlNotOK(session, "insert into customer values(4977,'Mrs','Yvette','Wilson','41764','287 Adams Boulevard,#156')")
    stopIfSqlNotOK(session, "insert into customer values(4978,'Mr','William','Brown','38655','176 Forest Street,#8')")
    stopIfSqlNotOK(session, "insert into customer values(4979,'Mrs','Sharon','Williams','16679','406 Valley Boulevard,#161')")
    stopIfSqlNotOK(session, "insert into customer values(4980,'Mr','Julio','Vance','77969','63 Fifteenth Road,#68')")
    stopIfSqlNotOK(session, "insert into customer values(4981,'Mr','Harry','Johnson','77347','131 Johnson Road,#74')")
    stopIfSqlNotOK(session, "insert into customer values(4982,'Mrs','Sharon','Johnson','75569','18 Madison Drive,#195')")
    stopIfSqlNotOK(session, "insert into customer values(4983,'Mrs','Aurelia','Watkins','03289','373 Highland Road,#96')")
    stopIfSqlNotOK(session, "insert into customer values(4984,'Mr','Kevin','Smith','77979','368 Woodland Road,#116')")
    stopIfSqlNotOK(session, "insert into customer values(4985,'Mr','Charles','George','76642','145 North Blvd,#131')")
    stopIfSqlNotOK(session, "insert into customer values(4986,'Mrs','Iva','Johnson','75032','175 Lee Boulevard,#93')")
    stopIfSqlNotOK(session, "insert into customer values(4987,'Mrs','Susan','Bender','76055','44 Mill Place,#15')")
    stopIfSqlNotOK(session, "insert into customer values(4988,'Mr','John','Smith','40049','311 Spruce Blvd,#113')")
    stopIfSqlNotOK(session, "insert into customer values(4989,'Mr','Thomas','Rodriguez','77508','488 Sunset Lane,#180')")
    stopIfSqlNotOK(session, "insert into customer values(4990,'Mr','William','Wilson','79499','351 Poplar Ave,#138')")
    stopIfSqlNotOK(session, "insert into customer values(4991,'Mrs','Jenny','Smith','79493','433 College Road,#59')")
    stopIfSqlNotOK(session, "insert into customer values(4992,'Mrs','Pearl','Johnson','76056','45 Ash Place,#105')")
    stopIfSqlNotOK(session, "insert into customer values(4993,'Mrs','Nancy','Simpson','52001','467 Mill Walk,#13')")
    stopIfSqlNotOK(session, "insert into customer values(4994,'Mrs','Cecile','Taylor','60601','138 Chestnut Square,#128')")
    stopIfSqlNotOK(session, "insert into customer values(4995,'Mr','Oscar','Wilson','78632','130 Meadow Road,#175')")
    stopIfSqlNotOK(session, "insert into customer values(4996,'Mrs','Adrienne','Miller','77803','276 Twelfth St.,#50')")
    stopIfSqlNotOK(session, "insert into customer values(4997,'Mr','Guy','Boyle','75032','190 Railroad Square,#16')")
    stopIfSqlNotOK(session, "insert into customer values(4998,'Mrs','Elinor','Jones','87725','381 Oak Drive,#200')")
    stopIfSqlNotOK(session, "insert into customer values(4999,'Mrs','Barbara','Welch','17946','55 Washington Place,#196')")
    stopIfSqlNotOK(session, "insert into customer values(5000,'Mr','Charles','Jones','76890','93 Oak St.,#189')")
    stopIfSqlNotOK(session, "insert into customer values(5001,'Mr','Ramon','Wilson','79325','437 Cherry Place,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5002,'Mrs','Sandra','Gillespie','78643','335 Lakeview Square,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5003,'Mrs','Alicia','Moore','77389','85 Broadway Avenue,#136')")
    stopIfSqlNotOK(session, "insert into customer values(5004,'Mr','David','Miller','79545','72 Laurel Road,#134')")
    stopIfSqlNotOK(session, "insert into customer values(5005,'Mrs','Sandra','Miller','78644','444 Chestnut St.,#31')")
    stopIfSqlNotOK(session, "insert into customer values(5006,'Mr','Richard','Smith','75473','13 Elm Parkway,#122')")
    stopIfSqlNotOK(session, "insert into customer values(5007,'Mr','Herman','Moore','77426','107 Lee Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(5008,'Mrs','Leanne','Ballard','78572','319 Cherry Boulevard,#115')")
    stopIfSqlNotOK(session, "insert into customer values(5009,'Mrs','Sandra','Miller','77457','416 Tenth Drive,#87')")
    stopIfSqlNotOK(session, "insert into customer values(5010,'Mrs','Jewell','Taylor','78656','202 Smith Lane,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5011,'Mr','Tommy','Scott','77839','413 Madison Lane,#104')")
    stopIfSqlNotOK(session, "insert into customer values(5012,'Mr','Robert','Brown','79316','19 Elm Avenue,#115')")
    stopIfSqlNotOK(session, "insert into customer values(5013,'Mrs','Gilda','Ochoa','19363','196 Williams Drive,#77')")
    stopIfSqlNotOK(session, "insert into customer values(5014,'Mrs','Carol','Reed','76624','167 Ash Lane,#8')")
    stopIfSqlNotOK(session, "insert into customer values(5015,'Mr','Frank','Davis','93249','487 Birch Walk,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5016,'Mr','Michael','Farley','38579','137 Spruce Walk,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5017,'Mr','Rodney','Taylor','78836','345 Johnson Lane,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5018,'Mr','Ian','Smith','76525','43 Twelfth Place,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5019,'Mrs','Vilma','Smith','22035','194 River Avenue,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5020,'Mrs','Marie','Jones','75932','345 Valley Street,#161')")
    stopIfSqlNotOK(session, "insert into customer values(5021,'Mr','David','Morin','79070','300 Sixth St.,#90')")
    stopIfSqlNotOK(session, "insert into customer values(5022,'Mrs','Jewell','Herrera','76230','115 Hillcrest Lane,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5023,'Mr','Marshall','Shelton','79517','23 Madison St.,#41')")
    stopIfSqlNotOK(session, "insert into customer values(5024,'Mrs','Nancy','Smith','76570','374 Johnson Parkway,#121')")
    stopIfSqlNotOK(session, "insert into customer values(5025,'Mrs','Susan','Jones','79918','488 Jackson Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5026,'Mr','Darrell','Miller','78376','202 Fifteenth Parkway,#124')")
    stopIfSqlNotOK(session, "insert into customer values(5027,'Mrs','Kimberley','Bonner','31643','202 Thirteenth Road,#1')")
    stopIfSqlNotOK(session, "insert into customer values(5028,'Mr','Frederick','Moody','78118','299 West Street,#52')")
    stopIfSqlNotOK(session, "insert into customer values(5029,'Mrs','Teri','Johnson','93453','101 Central Drive,#100')")
    stopIfSqlNotOK(session, "insert into customer values(5030,'Mrs','Sandra','Johnson','60945','194 Woodland Blvd,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5031,'Mrs','Betty','Spence','79024','7 Ash Parkway,#106')")
    stopIfSqlNotOK(session, "insert into customer values(5032,'Mr','Thomas','Hubbard','98550','79 Jackson Parkway,#37')")
    stopIfSqlNotOK(session, "insert into customer values(5033,'Mr','John','Moore','78964','129 Locust Blvd,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5034,'Mrs','Ina','Smith','79247','381 Sycamore Parkway,#143')")
    stopIfSqlNotOK(session, "insert into customer values(5035,'Mr','Thomas','Williamson','92799','400 Second St.,#199')")
    stopIfSqlNotOK(session, "insert into customer values(5036,'Mrs','Sandra','Smith','76635','226 Hickory St.,#54')")
    stopIfSqlNotOK(session, "insert into customer values(5037,'Mrs','Rosella','Floyd','76259','322 Twelfth St.,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5038,'Mr','Joseph','Douglas','46534','341 West Lane,#115')")
    stopIfSqlNotOK(session, "insert into customer values(5039,'Mr','Jim','Miller','77431','304 Elm Road,#112')")
    stopIfSqlNotOK(session, "insert into customer values(5040,'Mr','Manuel','Brown','77643','301 Elm Ave,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5041,'Mrs','Jennifer','Macdonald','75833','77 Eleventh Walk,#15')")
    stopIfSqlNotOK(session, "insert into customer values(5042,'Mrs','Karla','Dixon','77539','480 Adams Blvd,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5043,'Mr','Charles','Pierce','52001','297 Cherry Parkway,#62')")
    stopIfSqlNotOK(session, "insert into customer values(5044,'Mrs','Dorothy','Higgins','22965','18 East Walk,#121')")
    stopIfSqlNotOK(session, "insert into customer values(5045,'Mr','William','Palmer','76625','116 Lincoln Parkway,#192')")
    stopIfSqlNotOK(session, "insert into customer values(5046,'Mrs','Kay','Davis','61334','396 Washington Drive,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5047,'Mr','Jay','Hobbs','01240','395 Wilson Street,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5048,'Mr','John','Moore','12203','405 Franklin Road,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5049,'Mrs','Jeannette','Chase','79966','245 Elm Ave,#97')")
    stopIfSqlNotOK(session, "insert into customer values(5050,'Mr','James','Jones','79311','451 Thirteenth Drive,#81')")
    stopIfSqlNotOK(session, "insert into customer values(5051,'Mr','Shawn','Vinson','20653','14 Railroad Walk,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5052,'Mrs','Luella','Johnson','77331','63 Franklin Walk,#136')")
    stopIfSqlNotOK(session, "insert into customer values(5053,'Mrs','Sharon','Wilson','76935','356 Twelfth Drive,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5054,'Mr','Michael','Miller','79772','7 Maple Lane,#36')")
    stopIfSqlNotOK(session, "insert into customer values(5055,'Mr','Jonathan','Cooley','76054','71 Franklin Ave,#97')")
    stopIfSqlNotOK(session, "insert into customer values(5056,'Mrs','Irene','Smith','92799','305 Jackson Parkway,#28')")
    stopIfSqlNotOK(session, "insert into customer values(5057,'Mrs','Carol','Phillips','77578','393 Chestnut Walk,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5058,'Mrs','Susan','Davis','75152','363 Ridge Blvd,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5059,'Mr','James','Davis','00754','319 Forest Blvd,#170')")
    stopIfSqlNotOK(session, "insert into customer values(5060,'Mr','Tyrone','Smith','87154','313 Seventh Square,#14')")
    stopIfSqlNotOK(session, "insert into customer values(5061,'Mrs','Betty','Wilson','79786','187 Ninth Drive,#167')")
    stopIfSqlNotOK(session, "insert into customer values(5062,'Mrs','Opal','Giles','78368','308 Third Place,#13')")
    stopIfSqlNotOK(session, "insert into customer values(5063,'Mr','Thomas','Peterson','65714','154 Meadow Square,#89')")
    stopIfSqlNotOK(session, "insert into customer values(5064,'Mrs','Dorothy','Johnson','63430','344 Highland Blvd,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5065,'Mr','Ryan','Moore','77624','481 Fourteenth Walk,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5066,'Mrs','Melisa','Fuentes','76834','352 Eighth Parkway,#38')")
    stopIfSqlNotOK(session, "insert into customer values(5067,'Mr','Ted','Taylor','01885','156 Lakeview Drive,#60')")
    stopIfSqlNotOK(session, "insert into customer values(5068,'Mrs','Carol','Melton','78020','11 Park St.,#68')")
    stopIfSqlNotOK(session, "insert into customer values(5069,'Mrs','Flossie','Lyons','79025','432 West Drive,#3')")
    stopIfSqlNotOK(session, "insert into customer values(5070,'Mr','Joseph','Davis','79371','94 Valley St.,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5071,'Mrs','Lupe','Sweet','87565','11 Lee Parkway,#121')")
    stopIfSqlNotOK(session, "insert into customer values(5072,'Mr','Thomas','Sanchez','76852','446 Twelfth Road,#193')")
    stopIfSqlNotOK(session, "insert into customer values(5073,'Mrs','Florine','Williams','76518','450 Davis Street,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5074,'Mr','Marcus','Romero','49720','419 Second Square,#47')")
    stopIfSqlNotOK(session, "insert into customer values(5075,'Mr','Erik','Wilson','75115','335 Maple Ave,#154')")
    stopIfSqlNotOK(session, "insert into customer values(5076,'Mr','Jose','Williams','79535','11 Railroad Avenue,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5077,'Mr','Richard','Kemp','78563','180 View Walk,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5078,'Mr','Hugh','Jones','74465','302 Johnson Parkway,#110')")
    stopIfSqlNotOK(session, "insert into customer values(5079,'Mrs','Dorothy','Brown','78614','388 Locust Blvd,#88')")
    stopIfSqlNotOK(session, "insert into customer values(5080,'Mr','Ruben','Jones','75563','331 Jackson Avenue,#12')")
    stopIfSqlNotOK(session, "insert into customer values(5081,'Mrs','Susan','Mcgowan','78598','29 Fourteenth Drive,#163')")
    stopIfSqlNotOK(session, "insert into customer values(5082,'Mr','Glenn','Wilson','67476','84 Franklin Place,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5083,'Mrs','Nancy','Atkins','79855','351 Central Walk,#153')")
    stopIfSqlNotOK(session, "insert into customer values(5084,'Mr','Leroy','Delacruz','75053','6 Lakeview Drive,#78')")
    stopIfSqlNotOK(session, "insert into customer values(5085,'Mrs','Lana','Bullock','85099','316 Center Place,#142')")
    stopIfSqlNotOK(session, "insert into customer values(5086,'Mr','Richard','Melendez','75076','132 River Avenue,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5087,'Mr','Michael','Dotson','75772','445 Park Ave,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5088,'Mr','Justin','Moore','05454','291 Lakeview Road,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5089,'Mr','Charles','Holloway','75564','233 Seventh Parkway,#158')")
    stopIfSqlNotOK(session, "insert into customer values(5090,'Mrs','Ina','Wolfe','76091','500 View Street,#115')")
    stopIfSqlNotOK(session, "insert into customer values(5091,'Mr','Joseph','Huber','76692','381 Ash Blvd,#25')")
    stopIfSqlNotOK(session, "insert into customer values(5092,'Mr','Norman','Adkins','75339','74 Willow Lane,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5093,'Mr','Charles','Berger','75157','348 Broadway Ave,#194')")
    stopIfSqlNotOK(session, "insert into customer values(5094,'Mr','Troy','Pollard','75685','438 Meadow Drive,#181')")
    stopIfSqlNotOK(session, "insert into customer values(5095,'Mr','Michael','Davis','87154','434 Eighth St.,#163')")
    stopIfSqlNotOK(session, "insert into customer values(5096,'Mr','Michael','Taylor','79756','268 Railroad Street,#77')")
    stopIfSqlNotOK(session, "insert into customer values(5097,'Mr','Chad','Wilkinson','78056','428 Cherry Square,#24')")
    stopIfSqlNotOK(session, "insert into customer values(5098,'Mr','Charles','Mccarthy','78552','304 Railroad Drive,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5099,'Mrs','Patricia','Love','76074','462 Hillcrest Street,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5100,'Mrs','Bonnie','Hernandez','47354','422 Adams Boulevard,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5101,'Mrs','Sandra','Taylor','78011','425 Jefferson Boulevard,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5102,'Mrs','Barbara','Jacobs','77539','71 North Street,#184')")
    stopIfSqlNotOK(session, "insert into customer values(5103,'Mr','Milton','Kirk','78133','108 Cherry Ave,#117')")
    stopIfSqlNotOK(session, "insert into customer values(5104,'Mr','Thomas','Brown','79529','469 South Road,#137')")
    stopIfSqlNotOK(session, "insert into customer values(5105,'Mrs','Dorothy','Todd','52745','174 Locust Walk,#130')")
    stopIfSqlNotOK(session, "insert into customer values(5106,'Mr','William','Gates','76678','35 Broadway Place,#12')")
    stopIfSqlNotOK(session, "insert into customer values(5107,'Mrs','Jennifer','Moore','88048','474 Fourteenth Place,#11')")
    stopIfSqlNotOK(session, "insert into customer values(5108,'Mrs','Barbara','Pace','76552','47 Sycamore Place,#82')")
    stopIfSqlNotOK(session, "insert into customer values(5109,'Mrs','Fanny','Taylor','97857','472 Dogwood Ave,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5110,'Mrs','Earline','Williams','21758','408 Eleventh Blvd,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5111,'Mrs','Janice','Moore','79043','143 Highland Lane,#31')")
    stopIfSqlNotOK(session, "insert into customer values(5112,'Mr','William','Davis','54557','448 Tenth Avenue,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5113,'Mr','Thomas','Bullock','85631','188 Sixth Avenue,#49')")
    stopIfSqlNotOK(session, "insert into customer values(5114,'Mr','Ruben','Johnson','76957','346 Woodland Blvd,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5115,'Mrs','Nancy','Davis','78662','294 Pine Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(5116,'Mr','John','Moore','78644','357 Seventh Road,#155')")
    stopIfSqlNotOK(session, "insert into customer values(5117,'Mrs','Nancy','Hanson','10178','12 Green Place,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5118,'Mrs','Morgan','Herman','81152','218 Main Drive,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5119,'Mr','Glen','Daugherty','76875','244 Hill Place,#104')")
    stopIfSqlNotOK(session, "insert into customer values(5120,'Mr','John','Jensen','38544','404 Pine Walk,#67')")
    stopIfSqlNotOK(session, "insert into customer values(5121,'Mr','Dan','Brown','78839','333 Wilson Boulevard,#163')")
    stopIfSqlNotOK(session, "insert into customer values(5122,'Mr','Albert','Mcbride','76262','222 River Ave,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5123,'Mrs','Dorothy','Miller','75085','365 Johnson Walk,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5124,'Mrs','Leanne','Brown','75451','321 First Walk,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5125,'Mrs','Amanda','Rice','77468','418 Railroad Lane,#110')")
    stopIfSqlNotOK(session, "insert into customer values(5126,'Mr','Allan','Johnson','76554','452 Second Avenue,#134')")
    stopIfSqlNotOK(session, "insert into customer values(5127,'Mrs','Felecia','Maxwell','10178','459 Central St.,#167')")
    stopIfSqlNotOK(session, "insert into customer values(5128,'Mrs','Shelly','Ramsey','87030','434 Third Drive,#142')")
    stopIfSqlNotOK(session, "insert into customer values(5129,'Mr','Michael','Crosby','76684','499 Lake St.,#40')")
    stopIfSqlNotOK(session, "insert into customer values(5130,'Mr','Robert','Miller','77664','16 Seventh Walk,#180')")
    stopIfSqlNotOK(session, "insert into customer values(5131,'Mr','Greg','Smith','76887','106 Mill St.,#177')")
    stopIfSqlNotOK(session, "insert into customer values(5132,'Mr','John','Smith','76199','264 River Blvd,#102')")
    stopIfSqlNotOK(session, "insert into customer values(5133,'Mrs','Allie','Miller','78387','143 Ninth Parkway,#168')")
    stopIfSqlNotOK(session, "insert into customer values(5134,'Mrs','Denise','Clark','94156','325 Jefferson Ave,#37')")
    stopIfSqlNotOK(session, "insert into customer values(5135,'Mr','Troy','Johnson','75951','234 Eighth Avenue,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5136,'Mrs','Enid','Franks','75323','451 Willow Lane,#140')")
    stopIfSqlNotOK(session, "insert into customer values(5137,'Mr','Charles','Barry','75415','326 Oak Street,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5138,'Mrs','Sharon','Brown','13456','275 Ash St.,#30')")
    stopIfSqlNotOK(session, "insert into customer values(5139,'Mrs','Barbara','Macias','05154','495 East Drive,#51')")
    stopIfSqlNotOK(session, "insert into customer values(5140,'Mr','Thomas','Rojas','87733','389 Cedar Walk,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5141,'Mr','Reginald','Harrington','76462','367 Laurel Road,#187')")
    stopIfSqlNotOK(session, "insert into customer values(5142,'Mr','Jamie','Banks','77426','163 East Blvd,#16')")
    stopIfSqlNotOK(session, "insert into customer values(5143,'Mr','Alvin','Sampson','76137','407 Mill Drive,#144')")
    stopIfSqlNotOK(session, "insert into customer values(5144,'Mr','Rene','Potter','76866','148 Central Square,#158')")
    stopIfSqlNotOK(session, "insert into customer values(5145,'Mr','David','Brown','87574','259 Walnut Road,#179')")
    stopIfSqlNotOK(session, "insert into customer values(5146,'Mr','Nicholas','Obrien','77531','324 Taylor Place,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5147,'Mr','Darren','Cummings','77978','274 Poplar Boulevard,#188')")
    stopIfSqlNotOK(session, "insert into customer values(5148,'Mrs','Barbara','Johnson','48226','394 Madison Avenue,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5149,'Mrs','Nita','Taylor','76866','203 Jefferson Walk,#188')")
    stopIfSqlNotOK(session, "insert into customer values(5150,'Mr','Donald','Frank','77882','216 Broadway Lane,#19')")
    stopIfSqlNotOK(session, "insert into customer values(5151,'Mr','Corey','Miller','76834','193 Spruce Lane,#142')")
    stopIfSqlNotOK(session, "insert into customer values(5152,'Mrs','Jennifer','Boyd','52004','295 Johnson Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(5153,'Mr','Robert','Moore','78003','433 Twelfth Avenue,#109')")
    stopIfSqlNotOK(session, "insert into customer values(5154,'Mrs','Jennifer','Brown','76940','117 First Walk,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5155,'Mr','Wallace','Kaufman','79314','391 Eleventh Parkway,#49')")
    stopIfSqlNotOK(session, "insert into customer values(5156,'Mr','John','Herring','77305','199 First Boulevard,#165')")
    stopIfSqlNotOK(session, "insert into customer values(5157,'Mr','Marshall','Whitley','77803','231 Ridge St.,#154')")
    stopIfSqlNotOK(session, "insert into customer values(5158,'Mr','Dennis','Woodward','33575','408 Ash Avenue,#49')")
    stopIfSqlNotOK(session, "insert into customer values(5159,'Mrs','Sharon','Jones','40546','223 Ridge Place,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5160,'Mr','John','Williams','78006','471 Ninth Drive,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5161,'Mrs','Sandra','Moore','78579','238 Sunset Boulevard,#36')")
    stopIfSqlNotOK(session, "insert into customer values(5162,'Mrs','Laurie','Wilson','94112','200 Spring Street,#3')")
    stopIfSqlNotOK(session, "insert into customer values(5163,'Mrs','Charlene','Hart','84621','163 Fourth Avenue,#24')")
    stopIfSqlNotOK(session, "insert into customer values(5164,'Mr','Mathew','Hyde','79039','336 Locust Boulevard,#146')")
    stopIfSqlNotOK(session, "insert into customer values(5165,'Mr','Don','Hampton','75481','148 Franklin Road,#131')")
    stopIfSqlNotOK(session, "insert into customer values(5166,'Mr','Justin','Burke','76799','75 Oak Road,#34')")
    stopIfSqlNotOK(session, "insert into customer values(5167,'Mrs','Helena','Bond','17251','185 Washington Avenue,#10')")
    stopIfSqlNotOK(session, "insert into customer values(5168,'Mr','Michael','Barry','76524','20 Main St.,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5169,'Mr','Richard','Ayers','75374','158 Second Ave,#158')")
    stopIfSqlNotOK(session, "insert into customer values(5170,'Mrs','Sandra','Yang','78537','16 Jackson Street,#173')")
    stopIfSqlNotOK(session, "insert into customer values(5171,'Mrs','Alma','Guthrie','78117','62 College Drive,#193')")
    stopIfSqlNotOK(session, "insert into customer values(5172,'Mr','Joseph','Taylor','90101','274 Williams Lane,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5173,'Mr','Jorge','Davis','76630','422 College Drive,#143')")
    stopIfSqlNotOK(session, "insert into customer values(5174,'Mr','William','Blake','78598','199 Cedar Blvd,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5175,'Mr','John','Wilson','78463','341 Twelfth Parkway,#11')")
    stopIfSqlNotOK(session, "insert into customer values(5176,'Mr','Richard','Williams','78953','6 Eighth Parkway,#112')")
    stopIfSqlNotOK(session, "insert into customer values(5177,'Mr','Martin','Ball','79346','377 Fifteenth Ave,#1')")
    stopIfSqlNotOK(session, "insert into customer values(5178,'Mr','Seth','Morales','30267','167 Ash Avenue,#135')")
    stopIfSqlNotOK(session, "insert into customer values(5179,'Mrs','Jennifer','Miller','78645','104 Pine Avenue,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5180,'Mr','Peter','Davis','87125','190 College Square,#107')")
    stopIfSqlNotOK(session, "insert into customer values(5181,'Mr','Chad','Wagner','75903','133 Fourth Ave,#2')")
    stopIfSqlNotOK(session, "insert into customer values(5182,'Mr','Alberto','Williams','28364','295 Eighth Ave,#6')")
    stopIfSqlNotOK(session, "insert into customer values(5183,'Mrs','Barbara','Wilson','77414','351 Thirteenth St.,#95')")
    stopIfSqlNotOK(session, "insert into customer values(5184,'Mrs','Carol','Maldonado','75150','237 Woodland Ave,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5185,'Mr','David','Brown','76233','172 Washington Lane,#51')")
    stopIfSqlNotOK(session, "insert into customer values(5186,'Mr','Tyrone','Rutledge','75688','28 Meadow Square,#140')")
    stopIfSqlNotOK(session, "insert into customer values(5187,'Mr','Clinton','Dotson','79755','279 Tenth Square,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5188,'Mr','Oscar','Kelley','43764','420 Hill Boulevard,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5189,'Mr','Michael','Yates','76009','55 Broadway Drive,#5')")
    stopIfSqlNotOK(session, "insert into customer values(5190,'Mrs','Dorothy','Johnson','01538','328 Willow Street,#164')")
    stopIfSqlNotOK(session, "insert into customer values(5191,'Mr','Robert','Brown','93121','179 Center Blvd,#197')")
    stopIfSqlNotOK(session, "insert into customer values(5192,'Mr','Ronald','Lyons','79567','83 Taylor Boulevard,#2')")
    stopIfSqlNotOK(session, "insert into customer values(5193,'Mrs','Tracie','Blankenship','07879','244 Third St.,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5194,'Mr','James','Brown','79096','10 Fourth Walk,#103')")
    stopIfSqlNotOK(session, "insert into customer values(5195,'Mr','Salvador','Wilson','98027','442 North Drive,#110')")
    stopIfSqlNotOK(session, "insert into customer values(5196,'Mrs','Susan','Brown','78769','351 Hillcrest Lane,#53')")
    stopIfSqlNotOK(session, "insert into customer values(5197,'Mrs','Mildred','Moore','75959','324 Twelfth Drive,#6')")
    stopIfSqlNotOK(session, "insert into customer values(5198,'Mrs','Betty','Williams','78601','298 Fourth Avenue,#161')")
    stopIfSqlNotOK(session, "insert into customer values(5199,'Mr','Norman','Davis','68850','295 Johnson Ave,#123')")
    stopIfSqlNotOK(session, "insert into customer values(5200,'Mr','Seth','Williams','50161','467 Poplar Street,#131')")
    stopIfSqlNotOK(session, "insert into customer values(5201,'Mrs','Dorothy','Taylor','75943','101 Broadway Parkway,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5202,'Mr','William','Smith','75790','393 Birch Street,#113')")
    stopIfSqlNotOK(session, "insert into customer values(5203,'Mr','Richard','Brown','22135','410 Eleventh Lane,#158')")
    stopIfSqlNotOK(session, "insert into customer values(5204,'Mr','Jordan','Williams','78156','298 Main Drive,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5205,'Mrs','Julie','Brown','75756','136 Valley Street,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5206,'Mrs','Patricia','Mclaughlin','13362','447 Fourteenth Place,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5207,'Mr','Richard','Rios','76363','29 Hickory Avenue,#32')")
    stopIfSqlNotOK(session, "insert into customer values(5208,'Mrs','Essie','Levy','79382','391 Taylor Drive,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5209,'Mr','Thomas','Smith','78950','451 Woodland Boulevard,#171')")
    stopIfSqlNotOK(session, "insert into customer values(5210,'Mrs','Barbara','Sutton','05453','279 Meadow Lane,#54')")
    stopIfSqlNotOK(session, "insert into customer values(5211,'Mr','Richard','Taylor','94904','16 Walnut Avenue,#119')")
    stopIfSqlNotOK(session, "insert into customer values(5212,'Mr','Rene','Hester','76955','397 Tenth Place,#29')")
    stopIfSqlNotOK(session, "insert into customer values(5213,'Mrs','Betty','Miller','77470','408 Dogwood Street,#177')")
    stopIfSqlNotOK(session, "insert into customer values(5214,'Mr','Francis','Johnson','75095','242 Fourth Lane,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5215,'Mrs','Michele','Miller','77213','387 North Square,#82')")
    stopIfSqlNotOK(session, "insert into customer values(5216,'Mrs','Deann','Smith','76577','498 Park Street,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5217,'Mrs','Cora','Smith','93103','263 Chestnut Square,#6')")
    stopIfSqlNotOK(session, "insert into customer values(5218,'Mr','Enrique','Davis','15730','372 Maple Place,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5219,'Mr','Michael','Williams','79064','496 Hillcrest Road,#41')")
    stopIfSqlNotOK(session, "insert into customer values(5220,'Mr','Marshall','Ross','75930','99 Madison Avenue,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5221,'Mrs','Sandra','Hewitt','30417','283 Adams Square,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5222,'Mrs','Kelley','Savage','76007','64 Chestnut Parkway,#25')")
    stopIfSqlNotOK(session, "insert into customer values(5223,'Mrs','Susan','Salinas','79533','486 Eighth Square,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5224,'Mrs','Sandra','Olson','77415','213 Chestnut Square,#196')")
    stopIfSqlNotOK(session, "insert into customer values(5225,'Mr','John','Davis','75862','218 Maple Drive,#25')")
    stopIfSqlNotOK(session, "insert into customer values(5226,'Mrs','Jennifer','Wilson','08846','343 Ridge Parkway,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5227,'Mr','John','Hudson','79226','470 Willow Blvd,#154')")
    stopIfSqlNotOK(session, "insert into customer values(5228,'Mr','Victor','Hernandez','04093','261 River Lane,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5229,'Mr','Richard','Miller','78638','272 Park Avenue,#177')")
    stopIfSqlNotOK(session, "insert into customer values(5230,'Mrs','Reyna','Davis','76828','410 Fourteenth Drive,#185')")
    stopIfSqlNotOK(session, "insert into customer values(5231,'Mr','Joseph','Jones','75667','333 Hillcrest Drive,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5232,'Mrs','Carla','Davis','78006','313 Smith Street,#127')")
    stopIfSqlNotOK(session, "insert into customer values(5233,'Mrs','Kristie','Brown','75002','480 Maple Drive,#18')")
    stopIfSqlNotOK(session, "insert into customer values(5234,'Mr','Sidney','Spencer','76716','383 Hillcrest Road,#50')")
    stopIfSqlNotOK(session, "insert into customer values(5235,'Mr','Carl','Wilson','98376','224 Lee Road,#104')")
    stopIfSqlNotOK(session, "insert into customer values(5236,'Mr','Salvador','Taylor','78025','349 View Blvd,#67')")
    stopIfSqlNotOK(session, "insert into customer values(5237,'Mr','Sean','Mcdaniel','58738','426 Williams Place,#38')")
    stopIfSqlNotOK(session, "insert into customer values(5238,'Mrs','Susan','Yates','78147','428 Lee Road,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5239,'Mr','Ross','Taylor','77879','346 Locust Ave,#191')")
    stopIfSqlNotOK(session, "insert into customer values(5240,'Mr','Theodore','Miller','78836','166 Center Drive,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5241,'Mr','Chad','Brown','84655','189 Valley Boulevard,#9')")
    stopIfSqlNotOK(session, "insert into customer values(5242,'Mr','William','Miller','31050','463 Ash Walk,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5243,'Mrs','Graciela','Wilson','75980','409 Highland Boulevard,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5244,'Mrs','Patricia','Moses','75125','2 Miller Street,#55')")
    stopIfSqlNotOK(session, "insert into customer values(5245,'Mr','Richard','Farmer','75855','334 South Lane,#176')")
    stopIfSqlNotOK(session, "insert into customer values(5246,'Mr','Thomas','Williams','76377','302 Highland Drive,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5247,'Mr','James','Lang','76250','409 Miller Blvd,#15')")
    stopIfSqlNotOK(session, "insert into customer values(5248,'Mr','Rene','Duncan','77598','149 Ninth Parkway,#183')")
    stopIfSqlNotOK(session, "insert into customer values(5249,'Mr','Kent','Smith','93111','94 Spruce Square,#76')")
    stopIfSqlNotOK(session, "insert into customer values(5250,'Mr','Robert','Miller','79517','496 Sycamore Blvd,#95')")
    stopIfSqlNotOK(session, "insert into customer values(5251,'Mrs','Jennifer','Wilson','93453','482 South Road,#30')")
    stopIfSqlNotOK(session, "insert into customer values(5252,'Mr','Bill','Sargent','17251','152 Sycamore Ave,#85')")
    stopIfSqlNotOK(session, "insert into customer values(5253,'Mrs','Sandra','Williams','53036','275 Willow Square,#109')")
    stopIfSqlNotOK(session, "insert into customer values(5254,'Mr','Lee','Davis','93221','197 Spruce Avenue,#102')")
    stopIfSqlNotOK(session, "insert into customer values(5255,'Mrs','Savannah','Langley','79189','294 Taylor Avenue,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5256,'Mrs','Ruby','Barry','47576','106 Hill Parkway,#10')")
    stopIfSqlNotOK(session, "insert into customer values(5257,'Mr','Billy','Miller','59521','120 Miller St.,#137')")
    stopIfSqlNotOK(session, "insert into customer values(5258,'Mrs','Patricia','Jones','58760','202 Fifth Street,#86')")
    stopIfSqlNotOK(session, "insert into customer values(5259,'Mr','William','Jones','75671','264 West Road,#84')")
    stopIfSqlNotOK(session, "insert into customer values(5260,'Mrs','Carol','Russo','78604','498 Forest Place,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5261,'Mrs','Dorothy','Hebert','87556','340 Fourteenth Place,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5262,'Mr','Jesus','Williams','65247','122 Church Blvd,#10')")
    stopIfSqlNotOK(session, "insert into customer values(5263,'Mr','Tyler','Cantu','79730','442 Second Walk,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5264,'Mrs','Jennifer','Miller','75411','98 Church Place,#134')")
    stopIfSqlNotOK(session, "insert into customer values(5265,'Mrs','Noemi','Riley','51049','282 Cedar Ave,#199')")
    stopIfSqlNotOK(session, "insert into customer values(5266,'Mrs','Susan','York','76547','366 Willow Drive,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5267,'Mrs','Allie','Davis','37998','35 Sunset Square,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5268,'Mrs','Jennifer','Moon','65755','262 Cherry Lane,#139')")
    stopIfSqlNotOK(session, "insert into customer values(5269,'Mrs','Nancy','Jensen','76645','360 Railroad Blvd,#179')")
    stopIfSqlNotOK(session, "insert into customer values(5270,'Mr','Nathan','Davis','76066','485 Ninth Walk,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5271,'Mr','Douglas','Hartman','12141','93 Hill Place,#81')")
    stopIfSqlNotOK(session, "insert into customer values(5272,'Mrs','Maryellen','Sharpe','78270','124 Broadway Parkway,#96')")
    stopIfSqlNotOK(session, "insert into customer values(5273,'Mrs','Nadia','Davis','76230','390 Wilson Parkway,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5274,'Mrs','Betty','Carey','78594','444 Smith Lane,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5275,'Mrs','Nell','Brown','78872','68 Broadway Road,#11')")
    stopIfSqlNotOK(session, "insert into customer values(5276,'Mrs','Alyssa','Landry','79238','201 Birch St.,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5277,'Mrs','Lily','Lowe','76471','67 Smith Avenue,#128')")
    stopIfSqlNotOK(session, "insert into customer values(5278,'Mrs','Tommie','Warren','51545','347 Highland Ave,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5279,'Mrs','Autumn','Miller','78145','24 Washington Parkway,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5280,'Mr','Michael','Hess','78648','175 Miller Square,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5281,'Mr','Chester','Miles','75850','336 Tenth Place,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5282,'Mr','Joshua','Williams','46035','25 Woodland Street,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5283,'Mrs','Reva','Carney','75713','70 Dogwood Ave,#74')")
    stopIfSqlNotOK(session, "insert into customer values(5284,'Mrs','Lelia','Smith','17861','161 Seventh Avenue,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5285,'Mr','Sergio','Miller','77546','191 Sunset Drive,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5286,'Mr','David','Davis','76528','127 Madison Place,#13')")
    stopIfSqlNotOK(session, "insert into customer values(5287,'Mrs','Claudia','Boyer','15730','424 Highland Ave,#10')")
    stopIfSqlNotOK(session, "insert into customer values(5288,'Mr','Thomas','Bush','87829','441 View Drive,#66')")
    stopIfSqlNotOK(session, "insert into customer values(5289,'Mr','Jacob','Miller','78830','1 Birch Road,#5')")
    stopIfSqlNotOK(session, "insert into customer values(5290,'Mr','Julian','Jones','75064','169 Miller Lane,#33')")
    stopIfSqlNotOK(session, "insert into customer values(5291,'Mr','Michael','Wade','76465','436 Green Place,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5292,'Mrs','Barbara','Wilson','87176','365 Laurel Ave,#113')")
    stopIfSqlNotOK(session, "insert into customer values(5293,'Mrs','Julianne','Miller','76446','47 Poplar Street,#183')")
    stopIfSqlNotOK(session, "insert into customer values(5294,'Mrs','Debora','Berg','75443','155 Eighth Drive,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5295,'Mrs','Ramona','Taylor','76077','392 View Lane,#181')")
    stopIfSqlNotOK(session, "insert into customer values(5296,'Mrs','Dorothy','Padilla','78044','361 Johnson Blvd,#153')")
    stopIfSqlNotOK(session, "insert into customer values(5297,'Mrs','Joan','Wilson','76564','12 Railroad Street,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5298,'Mr','Joseph','Miller','79424','213 Forest Square,#76')")
    stopIfSqlNotOK(session, "insert into customer values(5299,'Mrs','Jennifer','Petersen','76456','296 Fourth Lane,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5300,'Mrs','Pearl','Johnson','53584','337 Jefferson Road,#122')")
    stopIfSqlNotOK(session, "insert into customer values(5301,'Mrs','Kristine','Mcconnell','78853','101 Willow Street,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5302,'Mr','Charles','Hopper','62306','251 Willow Place,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5303,'Mrs','Marisol','Reynolds','78829','38 Third Boulevard,#92')")
    stopIfSqlNotOK(session, "insert into customer values(5304,'Mr','Mark','English','78011','161 Ninth Place,#182')")
    stopIfSqlNotOK(session, "insert into customer values(5305,'Mr','Howard','Brown','88435','299 Williams Road,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5306,'Mr','Joseph','Smith','76087','241 Willow Blvd,#135')")
    stopIfSqlNotOK(session, "insert into customer values(5307,'Mrs','Corrine','Taylor','42036','196 Eighth Walk,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5308,'Mr','Carlos','Moore','76530','424 Lincoln Ave,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5309,'Mr','Wesley','Williams','79012','428 Eleventh Ave,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5310,'Mr','Vernon','Rodriguez','78938','332 Adams St.,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5311,'Mr','Miguel','Jones','77334','441 Sycamore Road,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5312,'Mr','Joseph','Lang','76651','307 Jefferson Road,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5313,'Mrs','Sharon','Santos','79541','58 Sixth Boulevard,#5')")
    stopIfSqlNotOK(session, "insert into customer values(5314,'Mr','Milton','Wilson','10203','227 Elm Blvd,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5315,'Mr','Eugene','Wilson','78357','392 Ninth Blvd,#35')")
    stopIfSqlNotOK(session, "insert into customer values(5316,'Mr','Michael','Calhoun','75253','384 Spruce Blvd,#59')")
    stopIfSqlNotOK(session, "insert into customer values(5317,'Mrs','Lesa','Dickson','76227','454 Hill Blvd,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5318,'Mrs','Billie','Gilbert','81134','150 Second Blvd,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5319,'Mr','Johnny','Cortez','76539','335 Main Drive,#179')")
    stopIfSqlNotOK(session, "insert into customer values(5320,'Mr','Joseph','Smith','76058','71 Elm Avenue,#6')")
    stopIfSqlNotOK(session, "insert into customer values(5321,'Mr','William','Davis','79849','82 Ridge Square,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5322,'Mr','Willard','Moore','76380','421 Wilson Road,#153')")
    stopIfSqlNotOK(session, "insert into customer values(5323,'Mrs','Betty','Ray','02173','397 Hillcrest Walk,#50')")
    stopIfSqlNotOK(session, "insert into customer values(5324,'Mrs','Viola','Davis','77429','102 Johnson Street,#72')")
    stopIfSqlNotOK(session, "insert into customer values(5325,'Mr','James','Miller','37924','182 Cherry Avenue,#59')")
    stopIfSqlNotOK(session, "insert into customer values(5326,'Mr','Thomas','Huff','77623','29 Spring Boulevard,#55')")
    stopIfSqlNotOK(session, "insert into customer values(5327,'Mr','Thomas','Craft','17032','192 Sycamore Parkway,#135')")
    stopIfSqlNotOK(session, "insert into customer values(5328,'Mr','Derek','Wilson','79314','18 Smith Parkway,#62')")
    stopIfSqlNotOK(session, "insert into customer values(5329,'Mrs','Diana','Miller','75068','230 Jackson Lane,#28')")
    stopIfSqlNotOK(session, "insert into customer values(5330,'Mr','Troy','Jones','19453','141 Valley Drive,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5331,'Mrs','Carly','Miller','12936','195 Johnson Avenue,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5332,'Mrs','Marcy','Downs','75212','172 Wilson Place,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5333,'Mrs','Sharon','Melton','67027','174 Jefferson St.,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5334,'Mr','James','Wilson','76648','262 Fourth Blvd,#74')")
    stopIfSqlNotOK(session, "insert into customer values(5335,'Mr','Charles','Vinson','75860','428 Park Drive,#18')")
    stopIfSqlNotOK(session, "insert into customer values(5336,'Mrs','Sharon','Brown','77389','180 Cedar Ave,#199')")
    stopIfSqlNotOK(session, "insert into customer values(5337,'Mrs','Nancy','Richardson','69155','480 Hickory Lane,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5338,'Mrs','Nancy','Johnson','75840','16 Church Parkway,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5339,'Mrs','Joy','Wilson','77519','198 Lakeview Place,#7')")
    stopIfSqlNotOK(session, "insert into customer values(5340,'Mrs','Kristine','Smith','77461','81 Meadow St.,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5341,'Mr','James','Barnett','78523','277 Sycamore Boulevard,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5342,'Mr','William','Adkins','79014','406 Jackson Square,#57')")
    stopIfSqlNotOK(session, "insert into customer values(5343,'Mrs','Lucia','Whitfield','75420','240 Locust Square,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5344,'Mr','David','Christensen','65247','458 Lee Place,#67')")
    stopIfSqlNotOK(session, "insert into customer values(5345,'Mr','James','Morris','85099','268 Cherry Avenue,#72')")
    stopIfSqlNotOK(session, "insert into customer values(5346,'Mr','Adam','Williams','75101','53 First Blvd,#181')")
    stopIfSqlNotOK(session, "insert into customer values(5347,'Mr','Vernon','Flores','12192','328 Central Street,#43')")
    stopIfSqlNotOK(session, "insert into customer values(5348,'Mrs','Robert','Johnson','78664','449 Tenth Drive,#141')")
    stopIfSqlNotOK(session, "insert into customer values(5349,'Mrs','Jacquelyn','Alvarez','65265','205 Park Street,#18')")
    stopIfSqlNotOK(session, "insert into customer values(5350,'Mr','Edwin','Bolton','27872','261 Fourth Street,#134')")
    stopIfSqlNotOK(session, "insert into customer values(5351,'Mrs','Dorothy','Jacobs','75003','216 Ridge Square,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5352,'Mr','Joseph','Gould','92124','480 Spruce Blvd,#181')")
    stopIfSqlNotOK(session, "insert into customer values(5353,'Mrs','Dorothy','Stevens','75147','462 Cedar Road,#179')")
    stopIfSqlNotOK(session, "insert into customer values(5354,'Mrs','Nancy','Taylor','35010','109 Seventh Place,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5355,'Mr','William','Smith','55720','384 Mill St.,#30')")
    stopIfSqlNotOK(session, "insert into customer values(5356,'Mrs','Sharon','Wilson','69037','122 Seventh Street,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5357,'Mrs','Nancy','Smith','61454','457 Green Street,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5358,'Mr','Johnny','Smith','98392','339 Third Blvd,#3')")
    stopIfSqlNotOK(session, "insert into customer values(5359,'Mr','Richard','Lopez','77665','285 Williams Street,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5360,'Mrs','Krista','Cooley','75125','19 Seventh Ave,#167')")
    stopIfSqlNotOK(session, "insert into customer values(5361,'Mrs','Patricia','Rojas','43001','227 Meadow Square,#148')")
    stopIfSqlNotOK(session, "insert into customer values(5362,'Mrs','Nancy','Williams','75855','66 Williams St.,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5363,'Mr','David','Ochoa','41127','291 Fourth Boulevard,#102')")
    stopIfSqlNotOK(session, "insert into customer values(5364,'Mrs','Carolyn','Jacobson','04932','33 Sycamore Walk,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5365,'Mrs','Teresa','Farrell','78631','230 Birch Street,#72')")
    stopIfSqlNotOK(session, "insert into customer values(5366,'Mrs','Diann','Brown','97342','42 Ninth Ave,#148')")
    stopIfSqlNotOK(session, "insert into customer values(5367,'Mrs','Nancy','Mullen','75461','156 Locust Avenue,#66')")
    stopIfSqlNotOK(session, "insert into customer values(5368,'Mrs','Eleanor','Norton','64478','354 Broadway Place,#124')")
    stopIfSqlNotOK(session, "insert into customer values(5369,'Mr','Antonio','Blevins','76716','288 Woodland Blvd,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5370,'Mr','Thomas','Snow','79347','358 Laurel Avenue,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5371,'Mr','William','Gross','23423','334 Jackson Place,#163')")
    stopIfSqlNotOK(session, "insert into customer values(5372,'Mr','Henry','Moore','75631','324 Wilson Lane,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5373,'Mrs','Dorothy','Williams','17251','245 Chestnut Place,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5374,'Mr','William','Haley','75651','281 Walnut Avenue,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5375,'Mrs','Alicia','Williams','79022','168 Hill Lane,#55')")
    stopIfSqlNotOK(session, "insert into customer values(5376,'Mrs','Patricia','Davis','76889','324 College Parkway,#54')")
    stopIfSqlNotOK(session, "insert into customer values(5377,'Mr','James','Johnson','77583','201 Elm Road,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5378,'Mrs','Mamie','Taylor','37912','72 West Boulevard,#161')")
    stopIfSqlNotOK(session, "insert into customer values(5379,'Mrs','Nancy','Brown','77962','421 Hill St.,#113')")
    stopIfSqlNotOK(session, "insert into customer values(5380,'Mr','Robert','Davis','76227','102 Dogwood Lane,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5381,'Mrs','Cleo','Adkins','77541','291 Sixth Place,#103')")
    stopIfSqlNotOK(session, "insert into customer values(5382,'Mrs','Sandra','Snyder','63446','373 Ridge Road,#72')")
    stopIfSqlNotOK(session, "insert into customer values(5383,'Mr','Jimmie','Jones','77592','187 Williams Avenue,#75')")
    stopIfSqlNotOK(session, "insert into customer values(5384,'Mrs','Sharon','Smith','52158','195 Central Road,#87')")
    stopIfSqlNotOK(session, "insert into customer values(5385,'Mrs','Jacquelyn','Freeman','78835','318 Washington St.,#43')")
    stopIfSqlNotOK(session, "insert into customer values(5386,'Mrs','Joy','Franks','42268','378 West Lane,#185')")
    stopIfSqlNotOK(session, "insert into customer values(5387,'Mr','William','Davis','65439','189 Seventh Ave,#200')")
    stopIfSqlNotOK(session, "insert into customer values(5388,'Mr','James','Travis','75117','229 Maple Drive,#92')")
    stopIfSqlNotOK(session, "insert into customer values(5389,'Mr','Randall','Miller','37012','131 View Road,#194')")
    stopIfSqlNotOK(session, "insert into customer values(5390,'Mr','Robert','Walton','79018','318 Park Street,#25')")
    stopIfSqlNotOK(session, "insert into customer values(5391,'Mrs','Jolene','Brown','78645','368 Chestnut Road,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5392,'Mr','Anthony','Bruce','78161','486 Lakeview Walk,#187')")
    stopIfSqlNotOK(session, "insert into customer values(5393,'Mrs','Jennifer','Williams','75694','40 Forest Walk,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5394,'Mrs','Nancy','Davis','75482','187 Pine Drive,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5395,'Mrs','Tamra','Bush','78101','121 Williams Avenue,#103')")
    stopIfSqlNotOK(session, "insert into customer values(5396,'Mrs','Sandra','Ford','75371','92 River Boulevard,#154')")
    stopIfSqlNotOK(session, "insert into customer values(5397,'Mr','James','English','75556','138 Lincoln Street,#124')")
    stopIfSqlNotOK(session, "insert into customer values(5398,'Mrs','Angel','William','22334','394 South Boulevard,#142')")
    stopIfSqlNotOK(session, "insert into customer values(5399,'Mrs','April','Jones','78121','93 Sixth Place,#188')")
    stopIfSqlNotOK(session, "insert into customer values(5400,'Mr','Richard','Sanford','77429','295 Williams Road,#139')")
    stopIfSqlNotOK(session, "insert into customer values(5401,'Mrs','Briana','Booth','78675','368 Second Boulevard,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5402,'Mrs','Caroline','Brown','77950','370 Hill Boulevard,#191')")
    stopIfSqlNotOK(session, "insert into customer values(5403,'Mrs','Deirdre','Moreno','91778','140 Lee Blvd,#52')")
    stopIfSqlNotOK(session, "insert into customer values(5404,'Mr','Thomas','Santana','62550','306 Pine Walk,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5405,'Mrs','Carol','Lott','76508','197 Main Ave,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5406,'Mr','Gene','Moore','78861','368 Thirteenth Street,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5407,'Mrs','Pearlie','Rivas','26810','478 Hill Street,#87')")
    stopIfSqlNotOK(session, "insert into customer values(5408,'Mr','Charles','Hancock','87728','48 Miller Street,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5409,'Mrs','Diana','Davis','77964','190 Fourth Road,#161')")
    stopIfSqlNotOK(session, "insert into customer values(5410,'Mr','Reginald','Richards','78121','331 Chestnut Boulevard,#106')")
    stopIfSqlNotOK(session, "insert into customer values(5411,'Mr','Jorge','English','78598','468 Center Parkway,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5412,'Mrs','Sandra','Davis','02338','304 Third Parkway,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5413,'Mrs','Sharon','Miller','79019','249 Madison Boulevard,#148')")
    stopIfSqlNotOK(session, "insert into customer values(5414,'Mr','Tyler','Taylor','65265','385 Eleventh Street,#83')")
    stopIfSqlNotOK(session, "insert into customer values(5415,'Mr','Manuel','Moore','79372','155 Lee Street,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5416,'Mr','William','Moore','76517','129 Twelfth Ave,#180')")
    stopIfSqlNotOK(session, "insert into customer values(5417,'Mr','Andrew','Brown','18847','86 Willow Walk,#64')")
    stopIfSqlNotOK(session, "insert into customer values(5418,'Mr','Bernard','Jimenez','76842','276 Smith Walk,#57')")
    stopIfSqlNotOK(session, "insert into customer values(5419,'Mrs','Sharon','Williams','00938','7 College Place,#49')")
    stopIfSqlNotOK(session, "insert into customer values(5420,'Mrs','Dorothy','Rosa','71309','235 Spruce St.,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5421,'Mrs','Helena','Buckner','93661','437 Williams Ave,#13')")
    stopIfSqlNotOK(session, "insert into customer values(5422,'Mrs','Jennifer','Fletcher','75561','158 Sixth Boulevard,#47')")
    stopIfSqlNotOK(session, "insert into customer values(5423,'Mrs','Lucia','Freeman','18854','321 Third Blvd,#138')")
    stopIfSqlNotOK(session, "insert into customer values(5424,'Mr','Richard','Jones','76034','51 Madison St.,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5425,'Mrs','Lupe','Jarvis','75685','153 Central Lane,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5426,'Mr','Gerald','Floyd','76430','317 Oak Square,#141')")
    stopIfSqlNotOK(session, "insert into customer values(5427,'Mr','Richard','Cote','79236','65 Hill Boulevard,#142')")
    stopIfSqlNotOK(session, "insert into customer values(5428,'Mr','Maurice','Brown','75415','254 Pine Street,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5429,'Mr','Richard','Alston','04227','278 Ash Road,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5430,'Mrs','Jennifer','Wyatt','78057','366 South Avenue,#82')")
    stopIfSqlNotOK(session, "insert into customer values(5431,'Mrs','Laura','Taylor','77562','488 Locust Drive,#168')")
    stopIfSqlNotOK(session, "insert into customer values(5432,'Mrs','Candice','Knapp','61448','398 Valley Place,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5433,'Mr','Leonard','Lambert','75401','59 Center Boulevard,#21')")
    stopIfSqlNotOK(session, "insert into customer values(5434,'Mrs','Lacey','Taylor','76448','330 East Place,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5435,'Mrs','Sharon','Bryan','75172','147 Broadway Walk,#76')")
    stopIfSqlNotOK(session, "insert into customer values(5436,'Mr','John','Elliott','64862','19 Jackson Ave,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5437,'Mr','Michael','Benjamin','79084','137 Spring Avenue,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5438,'Mr','Edward','Taylor','90029','124 Thirteenth Drive,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5439,'Mrs','Sharon','Smith','78020','397 Chestnut Street,#64')")
    stopIfSqlNotOK(session, "insert into customer values(5440,'Mr','Anthony','Foley','76882','299 Twelfth Square,#171')")
    stopIfSqlNotOK(session, "insert into customer values(5441,'Mr','Richard','Jackson','32018','218 Fourteenth Drive,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5442,'Mrs','Barbara','Jones','91776','171 Birch Ave,#41')")
    stopIfSqlNotOK(session, "insert into customer values(5443,'Mrs','Dorothy','Jones','06262','52 Smith Place,#183')")
    stopIfSqlNotOK(session, "insert into customer values(5444,'Mrs','Gilda','Sanders','65265','222 Seventh Walk,#133')")
    stopIfSqlNotOK(session, "insert into customer values(5445,'Mrs','Susan','Moore','00950','470 Taylor Drive,#176')")
    stopIfSqlNotOK(session, "insert into customer values(5446,'Mr','Justin','Johnson','76250','430 Highland Parkway,#144')")
    stopIfSqlNotOK(session, "insert into customer values(5447,'Mrs','Margarita','Conway','78620','457 Lee Blvd,#147')")
    stopIfSqlNotOK(session, "insert into customer values(5448,'Mr','William','Fuller','92714','350 Lee Avenue,#141')")
    stopIfSqlNotOK(session, "insert into customer values(5449,'Mr','Charles','Gibbs','40413','297 Cedar Blvd,#9')")
    stopIfSqlNotOK(session, "insert into customer values(5450,'Mr','Luis','Smith','23427','150 North Road,#182')")
    stopIfSqlNotOK(session, "insert into customer values(5451,'Mrs','Dorothy','Williams','81250','143 Valley Place,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5452,'Mrs','Doreen','Brown','77461','411 Center Street,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5453,'Mr','Robert','Wood','97840','26 Broadway Parkway,#137')")
    stopIfSqlNotOK(session, "insert into customer values(5454,'Mr','Charlie','Johnson','59831','374 Washington Place,#103')")
    stopIfSqlNotOK(session, "insert into customer values(5455,'Mr','Mathew','Miller','75212','143 Forest Walk,#165')")
    stopIfSqlNotOK(session, "insert into customer values(5456,'Mrs','Bettye','Jones','57775','27 Pine Blvd,#84')")
    stopIfSqlNotOK(session, "insert into customer values(5457,'Mr','Thomas','Taylor','75852','241 Franklin Parkway,#175')")
    stopIfSqlNotOK(session, "insert into customer values(5458,'Mr','William','Wilson','23920','379 Ridge Lane,#130')")
    stopIfSqlNotOK(session, "insert into customer values(5459,'Mr','William','Adkins','41363','402 Wilson Place,#76')")
    stopIfSqlNotOK(session, "insert into customer values(5460,'Mrs','Kay','Brown','64742','267 Elm Parkway,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5461,'Mr','Thomas','Martin','76082','101 Fourth St.,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5462,'Mrs','Olive','Le','41848','460 Tenth Drive,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5463,'Mr','Joseph','Strong','78593','69 Williams Street,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5464,'Mr','Mathew','Rowe','78705','228 Tenth Walk,#164')")
    stopIfSqlNotOK(session, "insert into customer values(5465,'Mrs','Carol','Taylor','79371','106 Meadow Boulevard,#121')")
    stopIfSqlNotOK(session, "insert into customer values(5466,'Mr','Christian','Pruitt','92253','190 Church Ave,#1')")
    stopIfSqlNotOK(session, "insert into customer values(5467,'Mr','Darrell','Abbott','75640','479 Washington Boulevard,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5468,'Mr','Jordan','Stone','79772','139 View St.,#90')")
    stopIfSqlNotOK(session, "insert into customer values(5469,'Mr','Brent','Brown','78652','380 Church Street,#85')")
    stopIfSqlNotOK(session, "insert into customer values(5470,'Mrs','Hollie','George','52228','416 Dogwood Avenue,#107')")
    stopIfSqlNotOK(session, "insert into customer values(5471,'Mrs','Sandra','Miller','70075','142 Sycamore Walk,#28')")
    stopIfSqlNotOK(session, "insert into customer values(5472,'Mrs','Chris','Huffman','68967','460 Elm Ave,#15')")
    stopIfSqlNotOK(session, "insert into customer values(5473,'Mr','Freddie','Hall','75469','466 Lakeview Avenue,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5474,'Mr','Joseph','Bender','75755','208 Park Square,#165')")
    stopIfSqlNotOK(session, "insert into customer values(5475,'Mrs','Betty','Lynch','75364','458 Sixth Blvd,#183')")
    stopIfSqlNotOK(session, "insert into customer values(5476,'Mr','Aaron','Washington','75931','442 Central Street,#59')")
    stopIfSqlNotOK(session, "insert into customer values(5477,'Mr','Richard','Williams','76712','396 Center Ave,#189')")
    stopIfSqlNotOK(session, "insert into customer values(5478,'Mrs','Sandra','Williams','79755','415 Birch Drive,#133')")
    stopIfSqlNotOK(session, "insert into customer values(5479,'Mr','Peter','Brown','79549','184 Johnson Avenue,#38')")
    stopIfSqlNotOK(session, "insert into customer values(5480,'Mrs','Nancy','Morgan','75770','413 Pine Square,#56')")
    stopIfSqlNotOK(session, "insert into customer values(5481,'Mrs','Dorothy','Hinton','77651','124 Cedar Ave,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5482,'Mr','William','Maxwell','14722','477 North Parkway,#167')")
    stopIfSqlNotOK(session, "insert into customer values(5483,'Mrs','Maura','Jones','78653','440 Green Street,#108')")
    stopIfSqlNotOK(session, "insert into customer values(5484,'Mr','David','Jones','45650','170 River Blvd,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5485,'Mrs','Betty','Taylor','75958','331 West Street,#125')")
    stopIfSqlNotOK(session, "insert into customer values(5486,'Mrs','Patricia','Donaldson','75401','362 Laurel Drive,#16')")
    stopIfSqlNotOK(session, "insert into customer values(5487,'Mrs','Janice','Parrish','78941','415 North Drive,#50')")
    stopIfSqlNotOK(session, "insert into customer values(5488,'Mrs','Barbara','Smith','27885','470 Walnut Avenue,#153')")
    stopIfSqlNotOK(session, "insert into customer values(5489,'Mrs','Betty','Smith','78347','441 Fourteenth Ave,#177')")
    stopIfSqlNotOK(session, "insert into customer values(5490,'Mr','Dwayne','Gomez','75692','230 Miller Parkway,#116')")
    stopIfSqlNotOK(session, "insert into customer values(5491,'Mr','Dave','Williams','72002','173 View St.,#55')")
    stopIfSqlNotOK(session, "insert into customer values(5492,'Mrs','Meredith','Jones','25180','42 Smith Road,#18')")
    stopIfSqlNotOK(session, "insert into customer values(5493,'Mrs','Frankie','Gill','76556','456 Jefferson Parkway,#59')")
    stopIfSqlNotOK(session, "insert into customer values(5494,'Mrs','Sandra','Taylor','90671','117 Smith Avenue,#69')")
    stopIfSqlNotOK(session, "insert into customer values(5495,'Mrs','Terri','Leon','79029','467 River Parkway,#78')")
    stopIfSqlNotOK(session, "insert into customer values(5496,'Mrs','Nancy','Berg','11788','241 Eighth Blvd,#77')")
    stopIfSqlNotOK(session, "insert into customer values(5497,'Mrs','Kimberley','Williams','94579','149 First Street,#64')")
    stopIfSqlNotOK(session, "insert into customer values(5498,'Mr','Elmer','Miller','78563','423 Franklin Lane,#13')")
    stopIfSqlNotOK(session, "insert into customer values(5499,'Mrs','Carol','Taylor','79036','453 Tenth Blvd,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5500,'Mr','Lee','Johnson','76885','373 Ninth Boulevard,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5501,'Mrs','Susan','Taylor','77580','251 Willow Parkway,#77')")
    stopIfSqlNotOK(session, "insert into customer values(5502,'Mrs','Barbara','Ross','76677','341 Seventh Place,#137')")
    stopIfSqlNotOK(session, "insert into customer values(5503,'Mr','Richard','Williams','78636','361 Poplar Road,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5504,'Mr','Charles','Johnson','48096','477 Birch Blvd,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5505,'Mrs','Betty','Brown','61728','6 Sunset Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(5506,'Mr','Alvin','Battle','76064','321 Washington Place,#141')")
    stopIfSqlNotOK(session, "insert into customer values(5507,'Mr','Marion','Sweeney','28364','86 Thirteenth Avenue,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5508,'Mrs','Jennifer','Taylor','78621','485 Meadow Avenue,#89')")
    stopIfSqlNotOK(session, "insert into customer values(5509,'Mr','Charles','Waters','15555','24 Spring Square,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5510,'Mr','Arnold','Gross','78621','94 Seventh Ave,#116')")
    stopIfSqlNotOK(session, "insert into customer values(5511,'Mr','Curtis','Taylor','75844','37 Highland Road,#43')")
    stopIfSqlNotOK(session, "insert into customer values(5512,'Mr','William','Williams','77976','403 Franklin Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5513,'Mr','Robert','Johnson','79343','242 Pine Lane,#8')")
    stopIfSqlNotOK(session, "insert into customer values(5514,'Mr','Dwayne','Lane','76064','45 Adams Lane,#119')")
    stopIfSqlNotOK(session, "insert into customer values(5515,'Mr','Greg','Padilla','10282','107 Hickory Drive,#183')")
    stopIfSqlNotOK(session, "insert into customer values(5516,'Mrs','Sandra','Vincent','78027','99 Maple Ave,#66')")
    stopIfSqlNotOK(session, "insert into customer values(5517,'Mrs','Sharon','Johnson','76680','76 Spring Street,#1')")
    stopIfSqlNotOK(session, "insert into customer values(5518,'Mrs','Sharon','Estrada','78947','144 Woodland Drive,#138')")
    stopIfSqlNotOK(session, "insert into customer values(5519,'Mr','Joseph','Mcmahon','75763','465 Walnut Place,#33')")
    stopIfSqlNotOK(session, "insert into customer values(5520,'Mr','Jason','Moore','75791','156 Dogwood Blvd,#9')")
    stopIfSqlNotOK(session, "insert into customer values(5521,'Mr','Michael','Quinn','78538','268 Sycamore Square,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5522,'Mrs','Ella','Meyers','41363','222 Forest Square,#68')")
    stopIfSqlNotOK(session, "insert into customer values(5523,'Mrs','Sandra','Simpson','56053','409 Center Boulevard,#152')")
    stopIfSqlNotOK(session, "insert into customer values(5524,'Mr','James','Griffin','76844','369 Locust Square,#67')")
    stopIfSqlNotOK(session, "insert into customer values(5525,'Mr','Thomas','Barron','75683','267 Birch Avenue,#168')")
    stopIfSqlNotOK(session, "insert into customer values(5526,'Mrs','Lucinda','Williams','75932','168 Fourteenth Street,#29')")
    stopIfSqlNotOK(session, "insert into customer values(5527,'Mr','William','Miller','78380','443 Highland Ave,#73')")
    stopIfSqlNotOK(session, "insert into customer values(5528,'Mrs','Kari','Gaines','75001','400 Adams Boulevard,#25')")
    stopIfSqlNotOK(session, "insert into customer values(5529,'Mrs','Betty','Moore','78620','459 Meadow Street,#51')")
    stopIfSqlNotOK(session, "insert into customer values(5530,'Mrs','Betty','Jones','76634','393 Franklin Drive,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5531,'Mrs','Patricia','Dillard','36736','497 Fifteenth Walk,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5532,'Mr','William','Burks','75436','37 Ridge Parkway,#38')")
    stopIfSqlNotOK(session, "insert into customer values(5533,'Mrs','Stacy','Taylor','79252','22 Pine Blvd,#29')")
    stopIfSqlNotOK(session, "insert into customer values(5534,'Mr','Billy','Fischer','97476','63 Fourth Road,#95')")
    stopIfSqlNotOK(session, "insert into customer values(5535,'Mrs','Martha','Webster','76955','377 Spruce St.,#10')")
    stopIfSqlNotOK(session, "insert into customer values(5536,'Mrs','Betty','Brewer','79057','127 Fourteenth Avenue,#200')")
    stopIfSqlNotOK(session, "insert into customer values(5537,'Mr','William','Wilson','71309','205 Pine Street,#86')")
    stopIfSqlNotOK(session, "insert into customer values(5538,'Mrs','Ellen','Powers','37912','223 Park Road,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5539,'Mr','Joseph','Jones','12474','483 Davis St.,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5540,'Mr','Joel','Alvarado','78880','54 Pine Parkway,#189')")
    stopIfSqlNotOK(session, "insert into customer values(5541,'Mr','David','Smith','79508','173 Third Ave,#56')")
    stopIfSqlNotOK(session, "insert into customer values(5542,'Mrs','Dorothy','Park','76082','132 Second Walk,#196')")
    stopIfSqlNotOK(session, "insert into customer values(5543,'Mr','John','Tyson','28784','144 Washington Road,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5544,'Mr','Robert','Tate','77879','439 Elm Lane,#192')")
    stopIfSqlNotOK(session, "insert into customer values(5545,'Mrs','Betty','Moore','77866','109 Locust Lane,#37')")
    stopIfSqlNotOK(session, "insert into customer values(5546,'Mrs','Yvette','Jones','78373','197 Elm St.,#139')")
    stopIfSqlNotOK(session, "insert into customer values(5547,'Mr','Albert','Horne','75834','268 Thirteenth Street,#144')")
    stopIfSqlNotOK(session, "insert into customer values(5548,'Mrs','Sharon','Wilson','79759','467 Hickory Place,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5549,'Mrs','Dorothy','Williams','78837','16 Green Road,#5')")
    stopIfSqlNotOK(session, "insert into customer values(5550,'Mr','Aaron','Wilson','78069','482 Main Drive,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5551,'Mr','Charles','Durham','31050','244 Johnson Drive,#66')")
    stopIfSqlNotOK(session, "insert into customer values(5552,'Mrs','Patricia','Campos','76635','192 Spruce Place,#173')")
    stopIfSqlNotOK(session, "insert into customer values(5553,'Mr','William','Moore','76836','471 Birch Square,#47')")
    stopIfSqlNotOK(session, "insert into customer values(5554,'Mrs','Dominique','Moore','79849','494 Woodland Boulevard,#168')")
    stopIfSqlNotOK(session, "insert into customer values(5555,'Mr','Jim','Moore','63960','355 Johnson Square,#168')")
    stopIfSqlNotOK(session, "insert into customer values(5556,'Mrs','Susan','Moore','76227','369 Eleventh Blvd,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5557,'Mrs','Elba','Davis','79735','385 Thirteenth Parkway,#13')")
    stopIfSqlNotOK(session, "insert into customer values(5558,'Mrs','Sandra','Walker','50076','435 Cedar Lane,#109')")
    stopIfSqlNotOK(session, "insert into customer values(5559,'Mrs','Amparo','Wilson','78959','393 Willow Drive,#21')")
    stopIfSqlNotOK(session, "insert into customer values(5560,'Mr','Charles','Brown','77857','465 College Parkway,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5561,'Mr','Melvin','Brown','75785','497 Davis Road,#163')")
    stopIfSqlNotOK(session, "insert into customer values(5562,'Mrs','Sandra','Wilson','76454','324 North Road,#182')")
    stopIfSqlNotOK(session, "insert into customer values(5563,'Mrs','Ella','Jones','78956','371 Miller Street,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5564,'Mr','Samuel','Williams','32352','489 Miller Square,#175')")
    stopIfSqlNotOK(session, "insert into customer values(5565,'Mrs','Whitney','Johnson','76877','488 Oak Boulevard,#78')")
    stopIfSqlNotOK(session, "insert into customer values(5566,'Mr','Robert','Smith','98936','453 Jefferson Street,#7')")
    stopIfSqlNotOK(session, "insert into customer values(5567,'Mr','Charles','Smith','76254','255 Hillcrest Place,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5568,'Mr','Arthur','Santos','75783','289 North Street,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5569,'Mr','Samuel','Sparks','48096','248 Fifteenth Place,#70')")
    stopIfSqlNotOK(session, "insert into customer values(5570,'Mr','David','Williams','77859','158 Adams Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5571,'Mrs','Nancy','Wilson','04224','234 Birch Drive,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5572,'Mrs','Diane','Davis','76364','110 Mill St.,#193')")
    stopIfSqlNotOK(session, "insert into customer values(5573,'Mrs','Carol','Bonner','75556','105 View Lane,#69')")
    stopIfSqlNotOK(session, "insert into customer values(5574,'Mr','John','Battle','76379','212 Meadow St.,#173')")
    stopIfSqlNotOK(session, "insert into customer values(5575,'Mr','Harry','Morrison','79025','329 Pine Lane,#148')")
    stopIfSqlNotOK(session, "insert into customer values(5576,'Mrs','Patricia','Hurley','78342','486 Jefferson Square,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5577,'Mrs','Carol','Moore','75490','294 Poplar Lane,#7')")
    stopIfSqlNotOK(session, "insert into customer values(5578,'Mrs','Betsy','Spencer','75802','342 Oak Lane,#148')")
    stopIfSqlNotOK(session, "insert into customer values(5579,'Mr','Bryan','Davis','78667','18 Cherry Street,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5580,'Mr','William','Page','76299','174 Lee Parkway,#180')")
    stopIfSqlNotOK(session, "insert into customer values(5581,'Mrs','Bertha','Brown','75853','424 College Street,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5582,'Mrs','Susan','Pittman','76691','64 Fourteenth Avenue,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5583,'Mrs','Nancy','Williams','79243','264 West Parkway,#149')")
    stopIfSqlNotOK(session, "insert into customer values(5584,'Mrs','Patricia','Torres','76255','410 Lee Blvd,#35')")
    stopIfSqlNotOK(session, "insert into customer values(5585,'Mr','Calvin','Moore','77333','422 Park Square,#181')")
    stopIfSqlNotOK(session, "insert into customer values(5586,'Mr','Jeffery','Mays','77581','271 North Blvd,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5587,'Mr','Joseph','Hewitt','60020','43 Sycamore Parkway,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5588,'Mrs','Diana','Miller','85069','244 Green Blvd,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5589,'Mrs','Victoria','Jones','75757','151 Chestnut Square,#139')")
    stopIfSqlNotOK(session, "insert into customer values(5590,'Mr','Jeremy','Miller','92067','447 Ash Street,#94')")
    stopIfSqlNotOK(session, "insert into customer values(5591,'Mrs','Nancy','Benson','10099','248 Hickory Boulevard,#4')")
    stopIfSqlNotOK(session, "insert into customer values(5592,'Mrs','Patricia','Davis','58760','250 Wilson Square,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5593,'Mrs','Tricia','Ewing','77988','231 Wilson Avenue,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5594,'Mr','David','Branch','76642','51 Maple Drive,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5595,'Mrs','Kimberley','Miller','77494','410 Franklin Walk,#69')")
    stopIfSqlNotOK(session, "insert into customer values(5596,'Mrs','Patricia','Shaw','75415','263 Lee Ave,#143')")
    stopIfSqlNotOK(session, "insert into customer values(5597,'Mrs','Velma','Bowers','78389','30 Park Place,#6')")
    stopIfSqlNotOK(session, "insert into customer values(5598,'Mrs','Lori','Sweet','49876','460 West Place,#31')")
    stopIfSqlNotOK(session, "insert into customer values(5599,'Mr','Wayne','Villarreal','47971','15 Willow Parkway,#200')")
    stopIfSqlNotOK(session, "insert into customer values(5600,'Mrs','Barbara','Jacobson','75415','145 Lee Street,#21')")
    stopIfSqlNotOK(session, "insert into customer values(5601,'Mr','Danny','Flynn','77431','122 Sixth Parkway,#153')")
    stopIfSqlNotOK(session, "insert into customer values(5602,'Mrs','Barbara','Hodges','97840','497 Dogwood Road,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5603,'Mrs','Tracy','Wilson','77574','223 Fourth Lane,#70')")
    stopIfSqlNotOK(session, "insert into customer values(5604,'Mr','Ricardo','Jones','54464','261 View Blvd,#84')")
    stopIfSqlNotOK(session, "insert into customer values(5605,'Mr','Franklin','Shelton','57311','225 Seventh Ave,#194')")
    stopIfSqlNotOK(session, "insert into customer values(5606,'Mr','Robert','Bullock','76940','12 Sixth Walk,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5607,'Mrs','Jennifer','Martin','75977','107 Hickory Drive,#200')")
    stopIfSqlNotOK(session, "insert into customer values(5608,'Mr','Brandon','Williams','72515','296 Adams Street,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5609,'Mrs','Nell','Miller','76082','328 Lakeview Avenue,#189')")
    stopIfSqlNotOK(session, "insert into customer values(5610,'Mr','Craig','Williams','75574','223 Wilson Place,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5611,'Mr','Joseph','Romero','75789','450 Railroad Blvd,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5612,'Mrs','Sharon','Wilson','78591','191 North Ave,#35')")
    stopIfSqlNotOK(session, "insert into customer values(5613,'Mr','David','Brown','67027','4 Tenth Boulevard,#70')")
    stopIfSqlNotOK(session, "insert into customer values(5614,'Mr','Thomas','Caldwell','31734','244 Tenth Drive,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5615,'Mr','Willie','Wong','79001','171 Davis Place,#170')")
    stopIfSqlNotOK(session, "insert into customer values(5616,'Mr','Felix','Jones','93121','396 Wilson Walk,#141')")
    stopIfSqlNotOK(session, "insert into customer values(5617,'Mrs','Nancy','Jones','77456','32 Twelfth Street,#95')")
    stopIfSqlNotOK(session, "insert into customer values(5618,'Mr','Carl','Moore','78828','33 Central Place,#96')")
    stopIfSqlNotOK(session, "insert into customer values(5619,'Mrs','Betty','Williams','76859','225 Cedar St.,#145')")
    stopIfSqlNotOK(session, "insert into customer values(5620,'Mrs','Amy','Fowler','93665','90 Lincoln Lane,#145')")
    stopIfSqlNotOK(session, "insert into customer values(5621,'Mr','Tom','Jones','75117','161 River Ave,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5622,'Mrs','Sandra','Moore','77535','335 Maple Lane,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5623,'Mr','John','Cortez','29827','345 Jackson Avenue,#85')")
    stopIfSqlNotOK(session, "insert into customer values(5624,'Mr','Warren','Mcdaniel','75565','209 Walnut Boulevard,#176')")
    stopIfSqlNotOK(session, "insert into customer values(5625,'Mr','Darren','Pollard','22039','108 Cedar Lane,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5626,'Mr','Thomas','Davis','26566','314 Ash Road,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5627,'Mrs','Lorie','Lancaster','76652','35 River Drive,#138')")
    stopIfSqlNotOK(session, "insert into customer values(5628,'Mrs','Terri','Brown','45356','479 Oak Walk,#110')")
    stopIfSqlNotOK(session, "insert into customer values(5629,'Mrs','Kimberley','Martinez','77512','67 Hillcrest Blvd,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5630,'Mrs','Nancy','Miller','77879','331 Woodland Place,#73')")
    stopIfSqlNotOK(session, "insert into customer values(5631,'Mrs','Barbara','Taylor','77587','428 Ninth Road,#199')")
    stopIfSqlNotOK(session, "insert into customer values(5632,'Mrs','Marlene','Harper','75359','215 Hill Drive,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5633,'Mrs','Herminia','Robbins','76030','260 North Parkway,#185')")
    stopIfSqlNotOK(session, "insert into customer values(5634,'Mr','Claude','Hebert','87564','377 South Lane,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5635,'Mrs','Jewell','Jones','15376','197 Spruce Ave,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5636,'Mr','Edgar','Miller','78580','398 Eighth Boulevard,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5637,'Mrs','Sharon','Miller','78005','32 Mill St.,#152')")
    stopIfSqlNotOK(session, "insert into customer values(5638,'Mrs','April','Wilson','54559','393 Williams Road,#50')")
    stopIfSqlNotOK(session, "insert into customer values(5639,'Mrs','Delores','Davis','07440','334 Madison Drive,#102')")
    stopIfSqlNotOK(session, "insert into customer values(5640,'Mr','Lewis','Sweet','79955','484 Lake Street,#176')")
    stopIfSqlNotOK(session, "insert into customer values(5641,'Mrs','Darcy','Flynn','75935','21 Birch Blvd,#183')")
    stopIfSqlNotOK(session, "insert into customer values(5642,'Mrs','Kathie','Moore','77517','309 Lakeview Place,#62')")
    stopIfSqlNotOK(session, "insert into customer values(5643,'Mr','Michael','Brown','79491','236 Meadow Blvd,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5644,'Mr','Michael','Miller','64742','135 Pine Walk,#74')")
    stopIfSqlNotOK(session, "insert into customer values(5645,'Mr','John','Mathews','72011','459 Taylor Ave,#131')")
    stopIfSqlNotOK(session, "insert into customer values(5646,'Mrs','Sandra','Wilson','77430','391 East Ave,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5647,'Mr','Philip','Holt','77357','183 Oak Walk,#138')")
    stopIfSqlNotOK(session, "insert into customer values(5648,'Mr','Charles','Davis','77355','164 Hickory Ave,#34')")
    stopIfSqlNotOK(session, "insert into customer values(5649,'Mr','Antonio','Taylor','76626','286 Hillcrest Lane,#29')")
    stopIfSqlNotOK(session, "insert into customer values(5650,'Mrs','Patrice','Smith','75489','171 Wilson Drive,#140')")
    stopIfSqlNotOK(session, "insert into customer values(5651,'Mrs','Patricia','Taylor','65541','124 Woodland Road,#75')")
    stopIfSqlNotOK(session, "insert into customer values(5652,'Mr','David','Johnson','75852','75 Chestnut Street,#86')")
    stopIfSqlNotOK(session, "insert into customer values(5653,'Mr','Jonathan','Jones','76670','206 Poplar Drive,#118')")
    stopIfSqlNotOK(session, "insert into customer values(5654,'Mr','Bill','Mack','54559','460 Franklin Walk,#77')")
    stopIfSqlNotOK(session, "insert into customer values(5655,'Mrs','Kimberley','Brown','77656','407 Spruce Place,#40')")
    stopIfSqlNotOK(session, "insert into customer values(5656,'Mr','Michael','Taylor','03907','338 Maple Blvd,#128')")
    stopIfSqlNotOK(session, "insert into customer values(5657,'Mr','Charles','Wilson','75951','313 Oak Street,#50')")
    stopIfSqlNotOK(session, "insert into customer values(5658,'Mr','Thomas','Johnson','76632','75 Poplar Street,#57')")
    stopIfSqlNotOK(session, "insert into customer values(5659,'Mr','Bernard','Forbes','78598','353 Ash Road,#84')")
    stopIfSqlNotOK(session, "insert into customer values(5660,'Mrs','Betty','Holden','78052','418 View Lane,#68')")
    stopIfSqlNotOK(session, "insert into customer values(5661,'Mrs','Cheri','Sykes','40544','240 Adams Place,#31')")
    stopIfSqlNotOK(session, "insert into customer values(5662,'Mrs','Sylvia','Mayo','79009','140 Fifth Avenue,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5663,'Mrs','Celina','Brown','33470','207 Laurel Boulevard,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5664,'Mrs','Susan','Hinton','53036','485 Birch Walk,#78')")
    stopIfSqlNotOK(session, "insert into customer values(5665,'Mr','James','Mccarty','75481','406 First Ave,#197')")
    stopIfSqlNotOK(session, "insert into customer values(5666,'Mr','James','Larsen','79003','154 Franklin Avenue,#94')")
    stopIfSqlNotOK(session, "insert into customer values(5667,'Mrs','Sharon','Gentry','24558','97 Willow Drive,#146')")
    stopIfSqlNotOK(session, "insert into customer values(5668,'Mr','Bobby','Snyder','78681','118 Lake St.,#87')")
    stopIfSqlNotOK(session, "insert into customer values(5669,'Mr','Clifton','Davis','08846','83 Center Road,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5670,'Mrs','Vonda','Williams','75550','2 Cedar Lane,#94')")
    stopIfSqlNotOK(session, "insert into customer values(5671,'Mr','Keith','Horn','76070','415 Jefferson Parkway,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5672,'Mrs','Jody','Taylor','75105','151 Tenth Street,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5673,'Mr','James','Bates','79968','225 Jefferson Drive,#21')")
    stopIfSqlNotOK(session, "insert into customer values(5674,'Mrs','Ilene','Osborn','74741','128 Chestnut Boulevard,#39')")
    stopIfSqlNotOK(session, "insert into customer values(5675,'Mr','Charles','Miller','75144','67 Franklin Parkway,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5676,'Mr','Dale','Harmon','17561','177 Fourteenth Walk,#24')")
    stopIfSqlNotOK(session, "insert into customer values(5677,'Mr','David','Roberson','15776','66 Lincoln Ave,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5678,'Mrs','Jo','Durham','76623','112 Pine Square,#52')")
    stopIfSqlNotOK(session, "insert into customer values(5679,'Mr','Charles','Wilson','75681','345 Hillcrest Square,#11')")
    stopIfSqlNotOK(session, "insert into customer values(5680,'Mrs','Dorothy','Johnson','30648','310 Fifteenth Road,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5681,'Mr','Phillip','Davis','71309','72 East St.,#191')")
    stopIfSqlNotOK(session, "insert into customer values(5682,'Mrs','Leticia','Nash','72355','246 Cedar Drive,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5683,'Mr','Michael','Randall','85242','100 Center Drive,#155')")
    stopIfSqlNotOK(session, "insert into customer values(5684,'Mrs','Patricia','Robertson','87564','82 Sixth Blvd,#3')")
    stopIfSqlNotOK(session, "insert into customer values(5685,'Mr','David','Brown','76072','15 Elm Road,#36')")
    stopIfSqlNotOK(session, "insert into customer values(5686,'Mr','Tony','Williams','79372','134 Twelfth Avenue,#154')")
    stopIfSqlNotOK(session, "insert into customer values(5687,'Mrs','Lou','Wilson','78384','147 Central Walk,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5688,'Mrs','Shawna','Brown','79002','295 Meadow Lane,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5689,'Mrs','Tabitha','Delaney','87031','210 Lee Blvd,#170')")
    stopIfSqlNotOK(session, "insert into customer values(5690,'Mr','Zachary','Wiggins','79980','500 Hickory Walk,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5691,'Mr','Eddie','Mcneil','78025','401 Maple Parkway,#133')")
    stopIfSqlNotOK(session, "insert into customer values(5692,'Mrs','Sandra','Miller','13456','396 Lakeview Boulevard,#1')")
    stopIfSqlNotOK(session, "insert into customer values(5693,'Mrs','Carol','Hyde','70517','393 Tenth Avenue,#192')")
    stopIfSqlNotOK(session, "insert into customer values(5694,'Mrs','Laurie','Carpenter','37057','440 Broadway Drive,#160')")
    stopIfSqlNotOK(session, "insert into customer values(5695,'Mr','Wade','Taylor','32352','271 Dogwood St.,#146')")
    stopIfSqlNotOK(session, "insert into customer values(5696,'Mr','Robert','Williams','75681','477 Madison Street,#112')")
    stopIfSqlNotOK(session, "insert into customer values(5697,'Mr','Richard','Mercado','15110','319 Seventh Avenue,#101')")
    stopIfSqlNotOK(session, "insert into customer values(5698,'Mrs','Wilma','Gallegos','78942','419 Church St.,#133')")
    stopIfSqlNotOK(session, "insert into customer values(5699,'Mr','Robert','Bright','90029','258 Hickory St.,#165')")
    stopIfSqlNotOK(session, "insert into customer values(5700,'Mrs','Nancy','Trevino','84655','180 Highland Lane,#167')")
    stopIfSqlNotOK(session, "insert into customer values(5701,'Mr','Charles','Pace','75561','325 Lakeview Ave,#139')")
    stopIfSqlNotOK(session, "insert into customer values(5702,'Mrs','Alma','Boyd','78358','428 Taylor Ave,#35')")
    stopIfSqlNotOK(session, "insert into customer values(5703,'Mr','Michael','Jones','61753','442 Johnson Parkway,#120')")
    stopIfSqlNotOK(session, "insert into customer values(5704,'Mrs','Nancy','Williams','76862','189 Eighth Boulevard,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5705,'Mr','Virgil','Malone','87542','134 Thirteenth St.,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5706,'Mr','Joseph','Mccarthy','76538','35 Wilson Lane,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5707,'Mrs','Nancy','Rios','94023','380 Thirteenth Parkway,#73')")
    stopIfSqlNotOK(session, "insert into customer values(5708,'Mrs','Susan','Moore','59353','407 Poplar Road,#37')")
    stopIfSqlNotOK(session, "insert into customer values(5709,'Mr','Joseph','Mccray','87733','233 Hickory Blvd,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5710,'Mr','Angel','Landry','75550','273 Johnson St.,#53')")
    stopIfSqlNotOK(session, "insert into customer values(5711,'Mrs','Sharon','Mitchell','60451','460 Cedar Ave,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5712,'Mrs','Staci','Johnson','76033','220 Twelfth St.,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5713,'Mrs','Lorie','Petersen','76943','389 Chestnut Drive,#125')")
    stopIfSqlNotOK(session, "insert into customer values(5714,'Mrs','Wilma','Wiggins','76633','21 College Road,#75')")
    stopIfSqlNotOK(session, "insert into customer values(5715,'Mr','Clarence','Davis','77351','22 Sycamore St.,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5716,'Mr','Nelson','Stanley','17861','268 Cedar Lane,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5717,'Mr','Robert','Fletcher','78060','423 Smith Drive,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5718,'Mr','Richard','Moore','79563','32 Tenth Boulevard,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5719,'Mrs','Patricia','Byrd','77457','17 Seventh Avenue,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5720,'Mr','Jeffery','Johnston','31734','298 Willow Boulevard,#99')")
    stopIfSqlNotOK(session, "insert into customer values(5721,'Mr','Joel','Griffin','77508','14 Spruce Boulevard,#142')")
    stopIfSqlNotOK(session, "insert into customer values(5722,'Mr','Cody','Alvarez','76446','289 Fifteenth Drive,#84')")
    stopIfSqlNotOK(session, "insert into customer values(5723,'Mrs','Sandra','Williams','75287','423 Washington Road,#116')")
    stopIfSqlNotOK(session, "insert into customer values(5724,'Mr','Steven','Barker','87051','313 Eleventh Parkway,#118')")
    stopIfSqlNotOK(session, "insert into customer values(5725,'Mrs','Dorothy','Romero','76077','281 Madison Square,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5726,'Mr','Jessie','Johnson','19452','178 Spruce Blvd,#110')")
    stopIfSqlNotOK(session, "insert into customer values(5727,'Mr','William','Leblanc','79369','170 Lake Avenue,#158')")
    stopIfSqlNotOK(session, "insert into customer values(5728,'Mrs','Lora','Jones','75160','187 Church Street,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5729,'Mr','Ricky','Tucker','75573','432 Lakeview Parkway,#25')")
    stopIfSqlNotOK(session, "insert into customer values(5730,'Mr','Melvin','Davis','79080','188 Spruce Ave,#90')")
    stopIfSqlNotOK(session, "insert into customer values(5731,'Mrs','Sharon','Patton','77432','157 West St.,#14')")
    stopIfSqlNotOK(session, "insert into customer values(5732,'Mr','Charles','Moran','76557','309 Johnson Street,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5733,'Mr','Thomas','Davis','94497','180 Locust Avenue,#81')")
    stopIfSqlNotOK(session, "insert into customer values(5734,'Mr','John','Garza','85046','242 Johnson Walk,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5735,'Mrs','Audra','Crawford','77360','171 Thirteenth Ave,#197')")
    stopIfSqlNotOK(session, "insert into customer values(5736,'Mrs','Shauna','Taylor','79182','261 Mill Avenue,#60')")
    stopIfSqlNotOK(session, "insert into customer values(5737,'Mrs','Lorie','Burgess','40524','470 Fourteenth St.,#93')")
    stopIfSqlNotOK(session, "insert into customer values(5738,'Mrs','Bertie','Moore','76831','283 Taylor Avenue,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5739,'Mrs','Lauri','Wilson','75146','358 Green Ave,#119')")
    stopIfSqlNotOK(session, "insert into customer values(5740,'Mrs','Sharon','Holcomb','75663','394 Spruce Blvd,#81')")
    stopIfSqlNotOK(session, "insert into customer values(5741,'Mrs','Patricia','Williams','27872','191 Franklin Place,#137')")
    stopIfSqlNotOK(session, "insert into customer values(5742,'Mrs','Veronica','Moore','67038','99 Meadow Blvd,#127')")
    stopIfSqlNotOK(session, "insert into customer values(5743,'Mrs','Carol','Miller','76378','441 Center Street,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5744,'Mrs','Sandra','Smith','79061','127 Main Avenue,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5745,'Mrs','Betty','Davis','79366','414 Broadway Street,#127')")
    stopIfSqlNotOK(session, "insert into customer values(5746,'Mrs','Patricia','Hurley','88563','229 Locust Drive,#70')")
    stopIfSqlNotOK(session, "insert into customer values(5747,'Mr','Sean','Barlow','77466','254 Ash Drive,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5748,'Mr','Joseph','Williams','76667','416 Meadow Walk,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5749,'Mrs','Patricia','Juarez','07440','383 Railroad Drive,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5750,'Mr','Harry','Williams','00755','427 Smith Walk,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5751,'Mr','Ben','Jackson','79789','76 Fourth Avenue,#173')")
    stopIfSqlNotOK(session, "insert into customer values(5752,'Mrs','Blanca','Forbes','78009','447 Johnson Boulevard,#157')")
    stopIfSqlNotOK(session, "insert into customer values(5753,'Mr','Richard','Stokes','10400','173 Tenth Walk,#126')")
    stopIfSqlNotOK(session, "insert into customer values(5754,'Mr','Richard','Jones','76932','488 Ash St.,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5755,'Mr','John','Gates','92073','230 Jefferson Ave,#112')")
    stopIfSqlNotOK(session, "insert into customer values(5756,'Mr','Charles','Valenzuela','59853','204 Fourteenth Place,#82')")
    stopIfSqlNotOK(session, "insert into customer values(5757,'Mrs','Briana','Moore','05154','269 Third Boulevard,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5758,'Mr','Dale','Hopper','10138','56 Fifth Boulevard,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5759,'Mr','Ricky','Lee','75432','409 Poplar Drive,#197')")
    stopIfSqlNotOK(session, "insert into customer values(5760,'Mr','Kurt','Cox','79779','244 Railroad Lane,#52')")
    stopIfSqlNotOK(session, "insert into customer values(5761,'Mr','Corey','Obrien','76872','469 Jefferson Walk,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5762,'Mr','Ricky','Wilson','76432','187 Fifth St.,#180')")
    stopIfSqlNotOK(session, "insert into customer values(5763,'Mrs','Sharon','Williams','93190','30 Twelfth Boulevard,#85')")
    stopIfSqlNotOK(session, "insert into customer values(5764,'Mrs','Elvia','Ratliff','69155','273 Jackson Walk,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5765,'Mrs','Jan','Bell','75790','105 Seventh St.,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5766,'Mrs','Susan','Taylor','91310','218 Seventh Street,#138')")
    stopIfSqlNotOK(session, "insert into customer values(5767,'Mr','Jimmie','Serrano','77376','281 Lee Avenue,#123')")
    stopIfSqlNotOK(session, "insert into customer values(5768,'Mrs','Jennifer','Steele','76883','252 Twelfth Ave,#163')")
    stopIfSqlNotOK(session, "insert into customer values(5769,'Mrs','Muriel','Clark','75566','205 Washington Blvd,#175')")
    stopIfSqlNotOK(session, "insert into customer values(5770,'Mrs','Katelyn','Sloan','76857','351 Twelfth Road,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5771,'Mrs','Kelli','Johnson','76664','278 Central Boulevard,#19')")
    stopIfSqlNotOK(session, "insert into customer values(5772,'Mr','Jamie','Rose','76248','345 Green Lane,#36')")
    stopIfSqlNotOK(session, "insert into customer values(5773,'Mrs','Sharon','Jones','78613','324 Railroad Square,#159')")
    stopIfSqlNotOK(session, "insert into customer values(5774,'Mr','Eddie','Ford','79788','25 View Parkway,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5775,'Mrs','Ava','Miranda','75570','31 Thirteenth Lane,#141')")
    stopIfSqlNotOK(session, "insert into customer values(5776,'Mr','Charles','Johnson','76048','118 Lakeview Drive,#20')")
    stopIfSqlNotOK(session, "insert into customer values(5777,'Mr','James','Marquez','77445','122 Franklin Parkway,#189')")
    stopIfSqlNotOK(session, "insert into customer values(5778,'Mrs','Susanne','Contreras','79744','154 First Avenue,#175')")
    stopIfSqlNotOK(session, "insert into customer values(5779,'Mrs','Rosemary','Waller','78117','260 Sixth Parkway,#48')")
    stopIfSqlNotOK(session, "insert into customer values(5780,'Mrs','Jennifer','Miller','15952','23 Woodland Square,#51')")
    stopIfSqlNotOK(session, "insert into customer values(5781,'Mrs','Betty','Burnett','76691','107 Poplar Road,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5782,'Mr','John','Moore','77639','35 Davis Square,#167')")
    stopIfSqlNotOK(session, "insert into customer values(5783,'Mr','Maurice','Jones','75790','237 Railroad Walk,#185')")
    stopIfSqlNotOK(session, "insert into customer values(5784,'Mr','Joseph','Miller','10475','283 Eleventh Square,#170')")
    stopIfSqlNotOK(session, "insert into customer values(5785,'Mrs','Dorothy','Dillon','77586','13 Locust Road,#59')")
    stopIfSqlNotOK(session, "insert into customer values(5786,'Mrs','Barbara','Jones','60945','150 Center Square,#164')")
    stopIfSqlNotOK(session, "insert into customer values(5787,'Mrs','Lacey','Brown','77413','363 Fourteenth Ave,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5788,'Mr','Nelson','Jones','87540','409 Tenth Lane,#76')")
    stopIfSqlNotOK(session, "insert into customer values(5789,'Mr','Willie','Davis','87174','381 Woodland Boulevard,#155')")
    stopIfSqlNotOK(session, "insert into customer values(5790,'Mrs','Marci','Mcknight','79322','378 Cedar Drive,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5791,'Mr','John','Stevenson','75489','167 Third Square,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5792,'Mrs','Carol','Webster','79789','164 Davis Walk,#15')")
    stopIfSqlNotOK(session, "insert into customer values(5793,'Mr','Harold','Daugherty','77474','277 South Walk,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5794,'Mrs','Sandra','Gardner','77441','6 Walnut Boulevard,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5795,'Mr','Ramon','Smith','50124','16 Cherry Parkway,#67')")
    stopIfSqlNotOK(session, "insert into customer values(5796,'Mrs','Dorothy','Dejesus','75126','303 Lincoln Avenue,#154')")
    stopIfSqlNotOK(session, "insert into customer values(5797,'Mrs','Betty','Oliver','75639','155 Ash Boulevard,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5798,'Mr','Tracy','Wilson','79528','250 Seventh Drive,#178')")
    stopIfSqlNotOK(session, "insert into customer values(5799,'Mr','Miguel','Brown','79537','29 Wilson Drive,#139')")
    stopIfSqlNotOK(session, "insert into customer values(5800,'Mr','Lonnie','Moreno','75382','13 Eleventh Avenue,#86')")
    stopIfSqlNotOK(session, "insert into customer values(5801,'Mrs','Beulah','Williams','39535','76 Spring Square,#22')")
    stopIfSqlNotOK(session, "insert into customer values(5802,'Mr','Arnold','Buchanan','52745','249 Washington St.,#108')")
    stopIfSqlNotOK(session, "insert into customer values(5803,'Mr','Lonnie','Preston','18417','356 Church Avenue,#85')")
    stopIfSqlNotOK(session, "insert into customer values(5804,'Mrs','Lorna','Dillon','76679','134 Main Lane,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5805,'Mr','Thomas','Jones','78618','298 Twelfth Place,#92')")
    stopIfSqlNotOK(session, "insert into customer values(5806,'Mrs','Susana','Vinson','76469','208 Cherry Ave,#182')")
    stopIfSqlNotOK(session, "insert into customer values(5807,'Mrs','Marian','Hartman','79424','35 Ash Avenue,#143')")
    stopIfSqlNotOK(session, "insert into customer values(5808,'Mrs','Claire','Rosa','87551','103 Franklin Street,#97')")
    stopIfSqlNotOK(session, "insert into customer values(5809,'Mr','Richard','Wilson','33575','178 Maple Walk,#152')")
    stopIfSqlNotOK(session, "insert into customer values(5810,'Mrs','Diann','Lancaster','75432','255 Forest Place,#76')")
    stopIfSqlNotOK(session, "insert into customer values(5811,'Mr','Charles','Jones','02332','303 Railroad Parkway,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5812,'Mr','Wesley','Nichols','73949','89 Pine Boulevard,#12')")
    stopIfSqlNotOK(session, "insert into customer values(5813,'Mr','David','Johnson','05358','214 Adams St.,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5814,'Mrs','Tanisha','Miles','11931','219 Cherry Road,#96')")
    stopIfSqlNotOK(session, "insert into customer values(5815,'Mr','John','Johnson','78371','492 Sunset Ave,#30')")
    stopIfSqlNotOK(session, "insert into customer values(5816,'Mrs','Nancy','Rojas','75954','186 Pine Ave,#170')")
    stopIfSqlNotOK(session, "insert into customer values(5817,'Mrs','Vera','Johnson','18012','380 View Road,#27')")
    stopIfSqlNotOK(session, "insert into customer values(5818,'Mrs','Cheri','Rocha','19026','314 Center Square,#180')")
    stopIfSqlNotOK(session, "insert into customer values(5819,'Mr','Joseph','Hewitt','76456','125 Oak Road,#68')")
    stopIfSqlNotOK(session, "insert into customer values(5820,'Mr','John','Dennis','75134','210 Railroad Square,#158')")
    stopIfSqlNotOK(session, "insert into customer values(5821,'Mr','David','Mueller','75421','208 Maple Road,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5822,'Mr','Harold','Wheeler','50040','394 Poplar Lane,#196')")
    stopIfSqlNotOK(session, "insert into customer values(5823,'Mr','David','Petty','76577','34 Miller Parkway,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5824,'Mr','Joseph','Moore','76377','38 College Ave,#197')")
    stopIfSqlNotOK(session, "insert into customer values(5825,'Mrs','Dominique','Wilson','60463','33 Highland Boulevard,#47')")
    stopIfSqlNotOK(session, "insert into customer values(5826,'Mrs','Janelle','Smith','78344','177 Thirteenth Place,#7')")
    stopIfSqlNotOK(session, "insert into customer values(5827,'Mrs','Rena','Smith','64862','232 Walnut Road,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5828,'Mrs','Jennifer','Nichols','78379','372 Lakeview Boulevard,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5829,'Mr','Richard','Miller','79022','364 North Street,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5830,'Mr','Harvey','Williams','27565','250 Eighth Parkway,#188')")
    stopIfSqlNotOK(session, "insert into customer values(5831,'Mrs','Sharon','Mcclain','58759','238 West Walk,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5832,'Mr','Eduardo','Johnson','75479','489 Johnson Place,#116')")
    stopIfSqlNotOK(session, "insert into customer values(5833,'Mrs','Susan','Wolfe','38544','179 Lakeview Place,#184')")
    stopIfSqlNotOK(session, "insert into customer values(5834,'Mrs','Sharon','Mcclain','79042','462 Davis Blvd,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5835,'Mrs','Rebecca','Barron','37912','99 River Place,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5836,'Mr','Ray','Burgess','76649','429 Sixth Blvd,#8')")
    stopIfSqlNotOK(session, "insert into customer values(5837,'Mrs','Betty','Williams','75477','151 Lakeview Road,#57')")
    stopIfSqlNotOK(session, "insert into customer values(5838,'Mr','Thomas','Taylor','37902','464 Fifth Avenue,#131')")
    stopIfSqlNotOK(session, "insert into customer values(5839,'Mr','Tony','Williams','76949','457 Maple Street,#43')")
    stopIfSqlNotOK(session, "insert into customer values(5840,'Mr','Jeffrey','Brown','75493','439 Eleventh Place,#88')")
    stopIfSqlNotOK(session, "insert into customer values(5841,'Mr','Anthony','Dudley','78643','346 Madison Avenue,#6')")
    stopIfSqlNotOK(session, "insert into customer values(5842,'Mrs','Aurora','Johnson','90804','373 Broadway St.,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5843,'Mr','James','Williams','28784','487 Central Avenue,#87')")
    stopIfSqlNotOK(session, "insert into customer values(5844,'Mr','Virgil','Smith','60021','469 Lincoln Place,#36')")
    stopIfSqlNotOK(session, "insert into customer values(5845,'Mrs','Carol','Greene','65618','237 Mill Street,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5846,'Mr','Mike','Johnson','78883','459 Lake Blvd,#99')")
    stopIfSqlNotOK(session, "insert into customer values(5847,'Mr','Shawn','Taylor','78884','36 Cherry Drive,#70')")
    stopIfSqlNotOK(session, "insert into customer values(5848,'Mrs','Mamie','Moore','75559','19 Hillcrest Place,#14')")
    stopIfSqlNotOK(session, "insert into customer values(5849,'Mrs','Maryellen','Wilson','78624','226 Valley Parkway,#72')")
    stopIfSqlNotOK(session, "insert into customer values(5850,'Mrs','Sandra','Benson','77662','190 Hillcrest Drive,#89')")
    stopIfSqlNotOK(session, "insert into customer values(5851,'Mrs','Barbara','Dorsey','77655','13 Broadway Avenue,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5852,'Mr','Thomas','Maldonado','70633','169 Lakeview St.,#191')")
    stopIfSqlNotOK(session, "insert into customer values(5853,'Mr','Robert','Olsen','79499','491 Locust Drive,#86')")
    stopIfSqlNotOK(session, "insert into customer values(5854,'Mrs','Stacy','Wilson','79044','254 Lakeview Parkway,#150')")
    stopIfSqlNotOK(session, "insert into customer values(5855,'Mrs','Shelly','Taylor','28784','402 Adams Boulevard,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5856,'Mrs','Lorene','Davis','28173','207 Hillcrest Place,#118')")
    stopIfSqlNotOK(session, "insert into customer values(5857,'Mr','John','Lynch','78122','433 Center Road,#75')")
    stopIfSqlNotOK(session, "insert into customer values(5858,'Mr','Ronnie','Scott','22334','342 Johnson Blvd,#40')")
    stopIfSqlNotOK(session, "insert into customer values(5859,'Mrs','Esperanza','Kirk','78572','145 Spring Square,#88')")
    stopIfSqlNotOK(session, "insert into customer values(5860,'Mr','Alan','Lambert','78614','8 North Square,#26')")
    stopIfSqlNotOK(session, "insert into customer values(5861,'Mrs','Carol','Miller','57118','481 Laurel Avenue,#74')")
    stopIfSqlNotOK(session, "insert into customer values(5862,'Mr','Joseph','Jones','75476','191 Third Street,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5863,'Mr','James','Moore','75437','129 Fourth Square,#19')")
    stopIfSqlNotOK(session, "insert into customer values(5864,'Mr','John','Davis','17946','436 College Avenue,#165')")
    stopIfSqlNotOK(session, "insert into customer values(5865,'Mrs','Betty','Smith','76465','309 Woodland Drive,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5866,'Mr','Thomas','Walton','07465','141 Adams Boulevard,#30')")
    stopIfSqlNotOK(session, "insert into customer values(5867,'Mr','Dale','Allison','02822','184 Second Avenue,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5868,'Mr','David','Maynard','79543','464 North Parkway,#24')")
    stopIfSqlNotOK(session, "insert into customer values(5869,'Mr','Fernando','Jones','75642','307 Eleventh Parkway,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5870,'Mrs','Deirdre','Taylor','79114','248 Center Avenue,#33')")
    stopIfSqlNotOK(session, "insert into customer values(5871,'Mr','Troy','Randolph','97535','461 Adams Square,#193')")
    stopIfSqlNotOK(session, "insert into customer values(5872,'Mr','Wade','Figueroa','95066','397 Hillcrest Boulevard,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5873,'Mrs','Harriet','Smith','91386','89 Mill Walk,#129')")
    stopIfSqlNotOK(session, "insert into customer values(5874,'Mrs','Tameka','Smith','84621','492 Valley Walk,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5875,'Mr','Eddie','Garner','43773','486 Locust Street,#172')")
    stopIfSqlNotOK(session, "insert into customer values(5876,'Mr','Robert','Johnson','43773','288 Fourth Boulevard,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5877,'Mr','John','Mcdaniel','76866','443 Fifth Lane,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5878,'Mr','John','Taylor','78050','289 Eighth Drive,#30')")
    stopIfSqlNotOK(session, "insert into customer values(5879,'Mr','William','Davis','78280','173 Tenth Walk,#64')")
    stopIfSqlNotOK(session, "insert into customer values(5880,'Mr','Charles','Coffey','87538','39 Ridge Walk,#28')")
    stopIfSqlNotOK(session, "insert into customer values(5881,'Mrs','Ebony','Jones','78940','376 Locust Square,#129')")
    stopIfSqlNotOK(session, "insert into customer values(5882,'Mr','Byron','Davis','39361','367 West Boulevard,#107')")
    stopIfSqlNotOK(session, "insert into customer values(5883,'Mr','Ronnie','Velazquez','79321','427 Eighth Walk,#105')")
    stopIfSqlNotOK(session, "insert into customer values(5884,'Mrs','Jeanie','Johnson','75303','334 Church Boulevard,#135')")
    stopIfSqlNotOK(session, "insert into customer values(5885,'Mrs','Lindsay','Davis','78482','349 Hillcrest Boulevard,#31')")
    stopIfSqlNotOK(session, "insert into customer values(5886,'Mr','Russell','Gibson','74741','386 River Ave,#57')")
    stopIfSqlNotOK(session, "insert into customer values(5887,'Mr','Michael','Whitehead','75005','296 South St.,#14')")
    stopIfSqlNotOK(session, "insert into customer values(5888,'Mrs','Ofelia','Dyer','77358','327 Madison Square,#162')")
    stopIfSqlNotOK(session, "insert into customer values(5889,'Mrs','Sharon','Taylor','76820','184 Locust Blvd,#92')")
    stopIfSqlNotOK(session, "insert into customer values(5890,'Mr','John','Williams','93620','107 East Avenue,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5891,'Mr','David','Merrill','77584','85 Forest Lane,#192')")
    stopIfSqlNotOK(session, "insert into customer values(5892,'Mr','John','Johnson','78622','414 Meadow Ave,#109')")
    stopIfSqlNotOK(session, "insert into customer values(5893,'Mr','Tyler','Brown','21131','477 Wilson Square,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5894,'Mr','Joseph','Fuentes','79035','377 Fifth Boulevard,#195')")
    stopIfSqlNotOK(session, "insert into customer values(5895,'Mrs','Sandra','Haley','40121','317 Adams Blvd,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5896,'Mrs','Dorothy','Gillespie','79001','277 Eleventh Place,#161')")
    stopIfSqlNotOK(session, "insert into customer values(5897,'Mr','Thomas','Jimenez','78463','383 Seventh Avenue,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5898,'Mrs','Savannah','Kirby','78634','16 South Ave,#187')")
    stopIfSqlNotOK(session, "insert into customer values(5899,'Mr','Richard','Williams','53584','39 Sycamore Drive,#80')")
    stopIfSqlNotOK(session, "insert into customer values(5900,'Mrs','Carol','Nixon','77662','272 Spruce Boulevard,#32')")
    stopIfSqlNotOK(session, "insert into customer values(5901,'Mr','Dean','Wilson','78639','440 Wilson Road,#132')")
    stopIfSqlNotOK(session, "insert into customer values(5902,'Mrs','Elvia','Williams','87031','125 Cherry Avenue,#129')")
    stopIfSqlNotOK(session, "insert into customer values(5903,'Mrs','Trina','Garcia','76230','74 Walnut Blvd,#73')")
    stopIfSqlNotOK(session, "insert into customer values(5904,'Mr','John','Wilson','77882','494 Eleventh Boulevard,#153')")
    stopIfSqlNotOK(session, "insert into customer values(5905,'Mr','James','Wallace','78065','12 Ash Boulevard,#64')")
    stopIfSqlNotOK(session, "insert into customer values(5906,'Mrs','Cecile','Johnson','79021','211 Eighth Ave,#83')")
    stopIfSqlNotOK(session, "insert into customer values(5907,'Mrs','Melissa','Johnson','79741','234 Railroad Street,#191')")
    stopIfSqlNotOK(session, "insert into customer values(5908,'Mrs','Susan','Brown','76008','22 Fifteenth Square,#186')")
    stopIfSqlNotOK(session, "insert into customer values(5909,'Mr','Scott','Smith','76565','73 Railroad Blvd,#151')")
    stopIfSqlNotOK(session, "insert into customer values(5910,'Mr','Manuel','Smith','76456','287 Oak Square,#11')")
    stopIfSqlNotOK(session, "insert into customer values(5911,'Mr','Allan','Davis','00975','469 Ridge Lane,#4')")
    stopIfSqlNotOK(session, "insert into customer values(5912,'Mrs','Paige','Hebert','79837','214 Twelfth Road,#54')")
    stopIfSqlNotOK(session, "insert into customer values(5913,'Mrs','Frankie','Brown','78152','78 Oak Ave,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5914,'Mrs','Patricia','Dean','77371','124 Ridge Blvd,#18')")
    stopIfSqlNotOK(session, "insert into customer values(5915,'Mrs','Patricia','Strickland','30267','183 Hillcrest Lane,#92')")
    stopIfSqlNotOK(session, "insert into customer values(5916,'Mr','Glenn','Davis','79961','462 First Avenue,#198')")
    stopIfSqlNotOK(session, "insert into customer values(5917,'Mr','Sean','Miller','75449','391 Sunset Street,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5918,'Mr','Chris','Rodriquez','00618','335 Johnson Street,#37')")
    stopIfSqlNotOK(session, "insert into customer values(5919,'Mrs','Jaime','Albert','78160','412 Jackson Blvd,#103')")
    stopIfSqlNotOK(session, "insert into customer values(5920,'Mrs','Susan','Williams','76867','477 Davis Road,#170')")
    stopIfSqlNotOK(session, "insert into customer values(5921,'Mr','Byron','Meyers','48051','466 Willow Blvd,#145')")
    stopIfSqlNotOK(session, "insert into customer values(5922,'Mrs','Carol','Taylor','64862','188 Hill Avenue,#193')")
    stopIfSqlNotOK(session, "insert into customer values(5923,'Mrs','Ines','Taylor','32088','417 Lee St.,#166')")
    stopIfSqlNotOK(session, "insert into customer values(5924,'Mr','John','Mccall','75771','315 Maple Blvd,#79')")
    stopIfSqlNotOK(session, "insert into customer values(5925,'Mr','Gary','Jones','78622','213 Davis Lane,#144')")
    stopIfSqlNotOK(session, "insert into customer values(5926,'Mrs','Betty','Blevins','76447','459 Fourth Avenue,#65')")
    stopIfSqlNotOK(session, "insert into customer values(5927,'Mr','Calvin','Durham','00975','488 Sixth Avenue,#155')")
    stopIfSqlNotOK(session, "insert into customer values(5928,'Mrs','Sandra','Willis','76043','445 Church Lane,#152')")
    stopIfSqlNotOK(session, "insert into customer values(5929,'Mr','David','Miller','77535','453 Chestnut Lane,#121')")
    stopIfSqlNotOK(session, "insert into customer values(5930,'Mrs','Susan','Sykes','79344','111 Fourteenth Ave,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5931,'Mr','Kelly','Miller','60021','339 Sunset Lane,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5932,'Mr','Robert','Hodges','76558','292 Tenth St.,#47')")
    stopIfSqlNotOK(session, "insert into customer values(5933,'Mrs','Lilly','Johnson','97535','299 Railroad Lane,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5934,'Mrs','Sherrie','Bell','60147','366 Maple Drive,#17')")
    stopIfSqlNotOK(session, "insert into customer values(5935,'Mrs','Nancy','Middleton','79560','84 Dogwood Place,#44')")
    stopIfSqlNotOK(session, "insert into customer values(5936,'Mr','Thomas','Alston','75856','490 Park Road,#194')")
    stopIfSqlNotOK(session, "insert into customer values(5937,'Mr','Scott','Rich','75374','339 Church Lane,#123')")
    stopIfSqlNotOK(session, "insert into customer values(5938,'Mr','Luis','Ramirez','77514','335 Elm Parkway,#45')")
    stopIfSqlNotOK(session, "insert into customer values(5939,'Mr','Isaac','Jensen','78829','59 Wilson Avenue,#120')")
    stopIfSqlNotOK(session, "insert into customer values(5940,'Mr','Stephen','Morgan','75479','86 Dogwood Blvd,#56')")
    stopIfSqlNotOK(session, "insert into customer values(5941,'Mrs','Diann','Martinez','45871','191 Walnut Parkway,#70')")
    stopIfSqlNotOK(session, "insert into customer values(5942,'Mr','Robert','Johnson','75639','229 View Boulevard,#57')")
    stopIfSqlNotOK(session, "insert into customer values(5943,'Mr','Robert','Avery','76556','418 Broadway Square,#42')")
    stopIfSqlNotOK(session, "insert into customer values(5944,'Mr','Ron','Norris','76087','475 Third Walk,#66')")
    stopIfSqlNotOK(session, "insert into customer values(5945,'Mr','Robert','Fletcher','77467','448 Walnut Avenue,#71')")
    stopIfSqlNotOK(session, "insert into customer values(5946,'Mrs','Wilma','Davis','77299','162 River Boulevard,#86')")
    stopIfSqlNotOK(session, "insert into customer values(5947,'Mrs','Carol','Steele','78830','196 Ash Place,#190')")
    stopIfSqlNotOK(session, "insert into customer values(5948,'Mr','Richard','Gardner','92070','97 Seventh Street,#5')")
    stopIfSqlNotOK(session, "insert into customer values(5949,'Mrs','Bobbie','Estes','78114','121 Park Blvd,#51')")
    stopIfSqlNotOK(session, "insert into customer values(5950,'Mr','Derrick','Booth','79847','105 Maple Place,#82')")
    stopIfSqlNotOK(session, "insert into customer values(5951,'Mrs','Nancy','Irwin','79224','498 Lakeview Place,#115')")
    stopIfSqlNotOK(session, "insert into customer values(5952,'Mrs','Shawna','Robles','98333','386 Third Walk,#68')")
    stopIfSqlNotOK(session, "insert into customer values(5953,'Mrs','Lou','Wilson','21654','157 Fifteenth Parkway,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5954,'Mrs','Nancy','Lawrence','77485','186 Second St.,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5955,'Mrs','Margo','Smith','76877','200 Ninth Square,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5956,'Mrs','Sandra','Smith','97213','26 Ridge Square,#120')")
    stopIfSqlNotOK(session, "insert into customer values(5957,'Mr','Milton','Bray','76226','216 Johnson Boulevard,#94')")
    stopIfSqlNotOK(session, "insert into customer values(5958,'Mr','Vernon','Robbins','78714','238 View Blvd,#111')")
    stopIfSqlNotOK(session, "insert into customer values(5959,'Mr','Philip','Page','79518','364 Central Parkway,#174')")
    stopIfSqlNotOK(session, "insert into customer values(5960,'Mr','Nathan','Torres','78881','60 Forest Road,#34')")
    stopIfSqlNotOK(session, "insert into customer values(5961,'Mr','Jerry','Cervantes','67038','98 South Road,#156')")
    stopIfSqlNotOK(session, "insert into customer values(5962,'Mr','Michael','Beck','68982','140 Main Blvd,#171')")
    stopIfSqlNotOK(session, "insert into customer values(5963,'Mrs','Lucinda','Holden','78879','417 Elm Walk,#131')")
    stopIfSqlNotOK(session, "insert into customer values(5964,'Mr','Danny','Moore','79040','422 Sycamore Drive,#77')")
    stopIfSqlNotOK(session, "insert into customer values(5965,'Mrs','Susan','Jones','87551','75 Railroad Square,#64')")
    stopIfSqlNotOK(session, "insert into customer values(5966,'Mrs','Diane','Miller','75001','392 North Blvd,#3')")
    stopIfSqlNotOK(session, "insert into customer values(5967,'Mrs','Susan','Craft','76446','420 Willow Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(5968,'Mrs','Christina','Jones','16232','392 Jefferson Square,#118')")
    stopIfSqlNotOK(session, "insert into customer values(5969,'Mr','Michael','Brown','87158','473 Fifth Drive,#2')")
    stopIfSqlNotOK(session, "insert into customer values(5970,'Mrs','Nancy','Jones','75772','19 Fourth Street,#52')")
    stopIfSqlNotOK(session, "insert into customer values(5971,'Mr','William','Woodard','75029','387 Smith Blvd,#63')")
    stopIfSqlNotOK(session, "insert into customer values(5972,'Mr','James','Johnson','47971','189 Jefferson Avenue,#61')")
    stopIfSqlNotOK(session, "insert into customer values(5973,'Mr','Richard','Langley','78067','485 Washington Boulevard,#117')")
    stopIfSqlNotOK(session, "insert into customer values(5974,'Mrs','Susan','Davis','77360','373 Valley Boulevard,#168')")
    stopIfSqlNotOK(session, "insert into customer values(5975,'Mr','Adrian','Sargent','79096','277 Lakeview St.,#58')")
    stopIfSqlNotOK(session, "insert into customer values(5976,'Mr','William','Williams','92067','399 Seventh Ave,#98')")
    stopIfSqlNotOK(session, "insert into customer values(5977,'Mrs','Delores','Brown','35130','401 Wilson St.,#124')")
    stopIfSqlNotOK(session, "insert into customer values(5978,'Mr','Travis','Crawford','78565','389 Madison Blvd,#23')")
    stopIfSqlNotOK(session, "insert into customer values(5979,'Mrs','Nancy','Taylor','67740','206 Mill Lane,#118')")
    stopIfSqlNotOK(session, "insert into customer values(5980,'Mrs','Dorothy','Hopper','79837','119 Third St.,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5981,'Mr','Robert','Brown','76716','314 Sunset Walk,#181')")
    stopIfSqlNotOK(session, "insert into customer values(5982,'Mr','Michael','Powers','76436','120 Lake Square,#120')")
    stopIfSqlNotOK(session, "insert into customer values(5983,'Mr','Michael','Madden','43343','401 Lakeview Walk,#161')")
    stopIfSqlNotOK(session, "insert into customer values(5984,'Mrs','Sharon','Taylor','79082','418 Second Blvd,#90')")
    stopIfSqlNotOK(session, "insert into customer values(5985,'Mrs','Elvira','Wiggins','77430','147 Lee Walk,#87')")
    stopIfSqlNotOK(session, "insert into customer values(5986,'Mrs','Jacqueline','Brown','76842','69 Lakeview Parkway,#128')")
    stopIfSqlNotOK(session, "insert into customer values(5987,'Mrs','Sharon','Valencia','28619','32 Eleventh Avenue,#68')")
    stopIfSqlNotOK(session, "insert into customer values(5988,'Mr','James','Wise','79504','53 Birch Blvd,#169')")
    stopIfSqlNotOK(session, "insert into customer values(5989,'Mrs','Lorena','Williams','77859','172 Hickory Ave,#13')")
    stopIfSqlNotOK(session, "insert into customer values(5990,'Mr','Robert','Robbins','92799','150 North Walk,#39')")
    stopIfSqlNotOK(session, "insert into customer values(5991,'Mr','Joseph','Holmes','79350','93 Hill Walk,#155')")
    stopIfSqlNotOK(session, "insert into customer values(5992,'Mrs','Nola','Singleton','75932','297 Ridge Square,#119')")
    stopIfSqlNotOK(session, "insert into customer values(5993,'Mr','Wallace','Wilson','75482','323 Ash Place,#43')")
    stopIfSqlNotOK(session, "insert into customer values(5994,'Mr','Sergio','Fleming','76388','181 Adams Avenue,#119')")
    stopIfSqlNotOK(session, "insert into customer values(5995,'Mr','Charles','Davis','78125','432 Walnut Road,#114')")
    stopIfSqlNotOK(session, "insert into customer values(5996,'Mr','Thomas','Armstrong','78616','151 Sunset Walk,#74')")
    stopIfSqlNotOK(session, "insert into customer values(5997,'Mr','Michael','Moore','79201','82 Lee St.,#134')")
    stopIfSqlNotOK(session, "insert into customer values(5998,'Mr','Michael','Roberts','39661','67 Jefferson Ave,#46')")
    stopIfSqlNotOK(session, "insert into customer values(5999,'Mrs','Della','Haynes','87829','406 Hickory Boulevard,#79')")
    stopIfSqlNotOK(session, "insert into customer values(6000,'Mrs','Joan','Johnson','76137','429 Poplar Lane,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6001,'Mrs','Patricia','Harvey','79091','155 Pine Lane,#197')")
    stopIfSqlNotOK(session, "insert into customer values(6002,'Mrs','Barbara','Moore','79843','36 Ash Lane,#24')")
    stopIfSqlNotOK(session, "insert into customer values(6003,'Mrs','Betty','Fleming','79064','39 Central Walk,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6004,'Mr','John','Weber','78391','446 Cedar Lane,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6005,'Mrs','Nancy','Ingram','54548','146 Fourth Road,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6006,'Mr','Charles','Bonner','75117','369 Taylor Walk,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6007,'Mrs','Katelyn','Miller','78071','317 Ridge Place,#165')")
    stopIfSqlNotOK(session, "insert into customer values(6008,'Mrs','Deann','Mann','77539','373 Mill Boulevard,#77')")
    stopIfSqlNotOK(session, "insert into customer values(6009,'Mr','Thomas','Holmes','73301','422 River Square,#21')")
    stopIfSqlNotOK(session, "insert into customer values(6010,'Mr','William','Williams','75637','176 Washington Avenue,#126')")
    stopIfSqlNotOK(session, "insert into customer values(6011,'Mr','Greg','Mcmillan','78566','102 Cedar Place,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6012,'Mrs','June','Smith','53036','35 Walnut Road,#127')")
    stopIfSqlNotOK(session, "insert into customer values(6013,'Mrs','Carol','French','76627','455 Ninth Avenue,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6014,'Mr','Michael','Jones','76852','447 South Place,#55')")
    stopIfSqlNotOK(session, "insert into customer values(6015,'Mrs','Hester','Harper','76557','125 Valley Boulevard,#33')")
    stopIfSqlNotOK(session, "insert into customer values(6016,'Mr','Charles','Wall','78478','436 Forest Square,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6017,'Mr','Vincent','Wyatt','79955','208 Elm Ave,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6018,'Mr','Richard','Davis','75147','104 Valley Blvd,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6019,'Mrs','Barbara','Smith','78330','269 Johnson Street,#109')")
    stopIfSqlNotOK(session, "insert into customer values(6020,'Mr','David','Dodson','76557','369 Davis Place,#192')")
    stopIfSqlNotOK(session, "insert into customer values(6021,'Mrs','Tracey','Davis','79344','170 Valley Ave,#84')")
    stopIfSqlNotOK(session, "insert into customer values(6022,'Mrs','Shawna','Jacobson','75433','242 Jefferson Avenue,#183')")
    stopIfSqlNotOK(session, "insert into customer values(6023,'Mrs','Lindsay','Wilson','79367','8 Willow Place,#130')")
    stopIfSqlNotOK(session, "insert into customer values(6024,'Mrs','Sandra','Ford','79505','393 River Avenue,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6025,'Mrs','Jeannette','Davis','24628','68 Green Lane,#174')")
    stopIfSqlNotOK(session, "insert into customer values(6026,'Mrs','Gretchen','Stuart','68303','310 Sunset Ave,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6027,'Mrs','Marilyn','Spears','78575','309 Jackson Square,#23')")
    stopIfSqlNotOK(session, "insert into customer values(6028,'Mr','Leo','Moore','76045','350 Williams Ave,#166')")
    stopIfSqlNotOK(session, "insert into customer values(6029,'Mrs','Patricia','Tanner','75127','37 Williams Drive,#132')")
    stopIfSqlNotOK(session, "insert into customer values(6030,'Mrs','Sharon','Brown','19026','182 Jefferson Drive,#122')")
    stopIfSqlNotOK(session, "insert into customer values(6031,'Mr','Fernando','Miller','76476','486 Ash St.,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6032,'Mrs','Dorothy','Johnson','78009','228 Mill Boulevard,#135')")
    stopIfSqlNotOK(session, "insert into customer values(6033,'Mrs','Susan','Petersen','76077','48 Twelfth Street,#5')")
    stopIfSqlNotOK(session, "insert into customer values(6034,'Mrs','Glenda','Davis','76854','394 Smith Lane,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6035,'Mr','Charles','Jones','76181','234 Thirteenth Ave,#24')")
    stopIfSqlNotOK(session, "insert into customer values(6036,'Mr','John','Copeland','76857','114 Third Lane,#147')")
    stopIfSqlNotOK(session, "insert into customer values(6037,'Mr','Robert','Johnson','77446','402 Oak Avenue,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6038,'Mr','Marc','Burgess','78641','21 Cherry Blvd,#153')")
    stopIfSqlNotOK(session, "insert into customer values(6039,'Mrs','Nancy','Williams','75569','71 Sixth St.,#185')")
    stopIfSqlNotOK(session, "insert into customer values(6040,'Mrs','Kerry','Cain','79381','31 Lake Parkway,#27')")
    stopIfSqlNotOK(session, "insert into customer values(6041,'Mr','Thomas','Bailey','40596','114 Fourteenth Place,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6042,'Mrs','Maura','Mcdowell','76093','268 Woodland Square,#10')")
    stopIfSqlNotOK(session, "insert into customer values(6043,'Mr','Charles','Brown','77973','468 Miller Lane,#8')")
    stopIfSqlNotOK(session, "insert into customer values(6044,'Mr','Antonio','Williams','15730','21 First St.,#115')")
    stopIfSqlNotOK(session, "insert into customer values(6045,'Mr','Alfredo','Weaver','76534','195 Hill Avenue,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6046,'Mrs','Julianne','Chavez','77640','82 Williams Place,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6047,'Mr','Johnny','Trujillo','37924','372 Johnson Ave,#163')")
    stopIfSqlNotOK(session, "insert into customer values(6048,'Mr','Robert','Reese','95409','301 Johnson Drive,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6049,'Mrs','Olivia','Brown','79541','490 Ridge Drive,#62')")
    stopIfSqlNotOK(session, "insert into customer values(6050,'Mr','William','Smith','16232','76 Smith Place,#74')")
    stopIfSqlNotOK(session, "insert into customer values(6051,'Mr','Richard','Avila','77460','113 Hill Square,#115')")
    stopIfSqlNotOK(session, "insert into customer values(6052,'Mr','Michael','Johnson','79240','493 Cedar St.,#102')")
    stopIfSqlNotOK(session, "insert into customer values(6053,'Mr','John','Willis','73435','285 Ridge Lane,#100')")
    stopIfSqlNotOK(session, "insert into customer values(6054,'Mr','Richard','Roman','78010','339 Pine Square,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6055,'Mr','Michael','Woodward','76556','185 View Place,#100')")
    stopIfSqlNotOK(session, "insert into customer values(6056,'Mr','Thomas','Wall','79330','187 Park Avenue,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6057,'Mrs','Nancy','Michael','75064','132 Second Avenue,#14')")
    stopIfSqlNotOK(session, "insert into customer values(6058,'Mrs','Gabriela','Davis','76227','400 Pine Street,#38')")
    stopIfSqlNotOK(session, "insert into customer values(6059,'Mrs','Susan','Jackson','76823','28 Hill Walk,#58')")
    stopIfSqlNotOK(session, "insert into customer values(6060,'Mrs','Sharon','Johnson','24522','464 Sixth St.,#121')")
    stopIfSqlNotOK(session, "insert into customer values(6061,'Mr','Nicholas','Brown','52004','295 Hill Walk,#10')")
    stopIfSqlNotOK(session, "insert into customer values(6062,'Mrs','Doreen','Ferrell','76246','450 Oak Drive,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6063,'Mr','Joseph','Bean','76836','339 Sunset Boulevard,#67')")
    stopIfSqlNotOK(session, "insert into customer values(6064,'Mrs','Janie','Jones','45871','22 South Ave,#101')")
    stopIfSqlNotOK(session, "insert into customer values(6065,'Mr','Michael','Norton','41127','165 Elm Road,#8')")
    stopIfSqlNotOK(session, "insert into customer values(6066,'Mr','William','Mueller','31519','276 Highland Ave,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6067,'Mr','Robert','Leblanc','77866','390 Mill Road,#106')")
    stopIfSqlNotOK(session, "insert into customer values(6068,'Mr','Willard','Davis','79560','473 Lakeview Parkway,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6069,'Mr','Erik','Wilson','37374','463 Dogwood Street,#82')")
    stopIfSqlNotOK(session, "insert into customer values(6070,'Mr','Brian','Galloway','78164','490 West Walk,#147')")
    stopIfSqlNotOK(session, "insert into customer values(6071,'Mr','William','Randolph','28701','410 View Ave,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6072,'Mrs','Sharon','Smith','76230','218 North Parkway,#133')")
    stopIfSqlNotOK(session, "insert into customer values(6073,'Mr','Thomas','Wilson','23122','294 Meadow Avenue,#28')")
    stopIfSqlNotOK(session, "insert into customer values(6074,'Mr','Robert','Preston','75689','268 Johnson Blvd,#82')")
    stopIfSqlNotOK(session, "insert into customer values(6075,'Mrs','Jan','Brown','76823','472 Jefferson Street,#122')")
    stopIfSqlNotOK(session, "insert into customer values(6076,'Mr','Jack','Schwartz','75094','187 North Boulevard,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6077,'Mrs','Dorothy','Dodson','79759','356 Park Street,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6078,'Mr','Joseph','Smith','79324','351 Oak Square,#146')")
    stopIfSqlNotOK(session, "insert into customer values(6079,'Mrs','Inez','Curry','78114','396 Lee Street,#135')")
    stopIfSqlNotOK(session, "insert into customer values(6080,'Mrs','Sara','Davis','59853','408 First Lane,#6')")
    stopIfSqlNotOK(session, "insert into customer values(6081,'Mr','Rick','Wilson','78833','91 Spring Walk,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6082,'Mr','Ben','Jones','68776','393 Sunset Square,#119')")
    stopIfSqlNotOK(session, "insert into customer values(6083,'Mr','Rene','Miller','76028','198 Miller Square,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6084,'Mr','Alvin','Roberson','79058','347 Eleventh Blvd,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6085,'Mr','Joseph','Davis','22125','495 Chestnut Avenue,#171')")
    stopIfSqlNotOK(session, "insert into customer values(6086,'Mrs','Dorothy','Brown','72845','340 West Lane,#60')")
    stopIfSqlNotOK(session, "insert into customer values(6087,'Mr','William','Moore','99111','63 Lake Lane,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6088,'Mr','Tim','Jones','79978','452 Eighth Drive,#154')")
    stopIfSqlNotOK(session, "insert into customer values(6089,'Mr','David','Moore','78339','364 Cedar Street,#193')")
    stopIfSqlNotOK(session, "insert into customer values(6090,'Mrs','Jennifer','Davis','78662','479 College Parkway,#26')")
    stopIfSqlNotOK(session, "insert into customer values(6091,'Mrs','Susan','Smith','60102','440 Fifteenth Ave,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6092,'Mr','James','Gonzalez','79338','425 Spruce Drive,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6093,'Mr','Danny','Davis','40413','41 Seventh Walk,#8')")
    stopIfSqlNotOK(session, "insert into customer values(6094,'Mr','Charles','Johnson','71832','459 Hickory Ave,#181')")
    stopIfSqlNotOK(session, "insert into customer values(6095,'Mr','Guy','Macias','75078','42 Davis Square,#113')")
    stopIfSqlNotOK(session, "insert into customer values(6096,'Mr','Thomas','Roberts','91341','391 Hill St.,#181')")
    stopIfSqlNotOK(session, "insert into customer values(6097,'Mr','Thomas','Willis','25981','186 Madison St.,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6098,'Mr','Phillip','Rasmussen','79082','395 First Blvd,#12')")
    stopIfSqlNotOK(session, "insert into customer values(6099,'Mr','Gilbert','Brown','78578','208 Spring Drive,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6100,'Mr','Robert','Camacho','63561','234 North Road,#199')")
    stopIfSqlNotOK(session, "insert into customer values(6101,'Mrs','Patricia','Hughes','38047','482 Woodland Boulevard,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6102,'Mr','Michael','Davis','72820','260 Locust Place,#31')")
    stopIfSqlNotOK(session, "insert into customer values(6103,'Mrs','Sandra','Bush','78054','172 Hill Place,#168')")
    stopIfSqlNotOK(session, "insert into customer values(6104,'Mr','Clifton','Wilson','77665','405 Meadow Place,#65')")
    stopIfSqlNotOK(session, "insert into customer values(6105,'Mr','Duane','Smith','79178','125 Birch Road,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6106,'Mr','Richard','Williams','78644','465 Church Boulevard,#56')")
    stopIfSqlNotOK(session, "insert into customer values(6107,'Mr','James','Powers','79246','349 Lakeview Blvd,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6108,'Mr','Roger','West','75444','471 Smith Road,#16')")
    stopIfSqlNotOK(session, "insert into customer values(6109,'Mrs','Tracy','Brown','47354','355 Sunset Street,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6110,'Mr','John','Taylor','75417','160 Lee Ave,#12')")
    stopIfSqlNotOK(session, "insert into customer values(6111,'Mrs','Nina','Odom','23122','485 Pine Square,#117')")
    stopIfSqlNotOK(session, "insert into customer values(6112,'Mrs','Theresa','Fitzpatrick','87320','326 Lee Avenue,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6113,'Mrs','Barbara','Davis','75956','439 Eleventh Ave,#45')")
    stopIfSqlNotOK(session, "insert into customer values(6114,'Mr','Dwight','Wilson','75790','182 Railroad Ave,#113')")
    stopIfSqlNotOK(session, "insert into customer values(6115,'Mr','Charles','Dale','78020','100 Third Lane,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6116,'Mr','Victor','Kidd','64446','99 View Boulevard,#121')")
    stopIfSqlNotOK(session, "insert into customer values(6117,'Mr','Thomas','Taylor','75956','325 Park Lane,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6118,'Mr','Gordon','Avery','79749','358 East Blvd,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6119,'Mrs','Susan','Huff','77357','499 First Drive,#197')")
    stopIfSqlNotOK(session, "insert into customer values(6120,'Mrs','Eula','Wheeler','88521','260 Spruce Boulevard,#28')")
    stopIfSqlNotOK(session, "insert into customer values(6121,'Mrs','Lorie','Harris','76384','203 Fourteenth Place,#145')")
    stopIfSqlNotOK(session, "insert into customer values(6122,'Mr','Stanley','Rivera','77664','242 Meadow Ave,#10')")
    stopIfSqlNotOK(session, "insert into customer values(6123,'Mr','Richard','Lynn','10242','34 Woodland Walk,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6124,'Mr','Michael','Gentry','28173','184 Wilson Drive,#93')")
    stopIfSqlNotOK(session, "insert into customer values(6125,'Mr','Robert','Moore','60935','443 Adams Boulevard,#47')")
    stopIfSqlNotOK(session, "insert into customer values(6126,'Mr','Sam','Tucker','89424','80 Seventh Boulevard,#196')")
    stopIfSqlNotOK(session, "insert into customer values(6127,'Mr','David','Lee','95713','302 Mill Blvd,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6128,'Mr','Michael','Potter','75686','50 First Road,#1')")
    stopIfSqlNotOK(session, "insert into customer values(6129,'Mrs','Sandra','Davenport','00673','206 Valley St.,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6130,'Mrs','Sandra','Ramsey','79039','143 Chestnut Blvd,#180')")
    stopIfSqlNotOK(session, "insert into customer values(6131,'Mrs','Sandra','Le','77871','155 Tenth St.,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6132,'Mr','William','Quinn','75832','158 Meadow Drive,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6133,'Mr','William','Wong','77587','482 Pine Road,#17')")
    stopIfSqlNotOK(session, "insert into customer values(6134,'Mrs','Barbara','Davis','78376','222 Fifth Boulevard,#147')")
    stopIfSqlNotOK(session, "insert into customer values(6135,'Mr','Antonio','Waller','79525','410 Oak Avenue,#11')")
    stopIfSqlNotOK(session, "insert into customer values(6136,'Mrs','Fannie','Leach','27869','494 Sycamore Walk,#120')")
    stopIfSqlNotOK(session, "insert into customer values(6137,'Mr','Clifford','Miller','67027','185 North Blvd,#155')")
    stopIfSqlNotOK(session, "insert into customer values(6138,'Mr','John','Williams','78104','255 Ninth Walk,#179')")
    stopIfSqlNotOK(session, "insert into customer values(6139,'Mrs','Malinda','Smith','89024','116 Fourteenth St.,#104')")
    stopIfSqlNotOK(session, "insert into customer values(6140,'Mr','Michael','Jones','78143','253 Valley Avenue,#1')")
    stopIfSqlNotOK(session, "insert into customer values(6141,'Mrs','Shawna','Fields','90094','3 Green Walk,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6142,'Mr','Edgar','Cohen','79257','429 Maple Parkway,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6143,'Mr','William','Sweet','75974','88 Center St.,#5')")
    stopIfSqlNotOK(session, "insert into customer values(6144,'Mr','Howard','Jones','37940','491 Washington Drive,#45')")
    stopIfSqlNotOK(session, "insert into customer values(6145,'Mr','Ben','Wilson','76262','451 Jackson Parkway,#119')")
    stopIfSqlNotOK(session, "insert into customer values(6146,'Mr','Hugh','Taylor','94963','464 Lee Place,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6147,'Mrs','Bridgett','Johnson','56502','104 West Drive,#83')")
    stopIfSqlNotOK(session, "insert into customer values(6148,'Mrs','Sandra','Montoya','75444','206 Pine Square,#45')")
    stopIfSqlNotOK(session, "insert into customer values(6149,'Mr','David','Woods','78380','446 College St.,#66')")
    stopIfSqlNotOK(session, "insert into customer values(6150,'Mrs','Briana','Moore','77968','101 Center Walk,#109')")
    stopIfSqlNotOK(session, "insert into customer values(6151,'Mr','Michael','Williams','76351','301 Church Lane,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6152,'Mrs','Dorothy','Medina','78353','134 Hillcrest Square,#177')")
    stopIfSqlNotOK(session, "insert into customer values(6153,'Mrs','Gloria','Higgins','72820','250 Third Avenue,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6154,'Mrs','Susan','Hyde','75858','54 Thirteenth Blvd,#176')")
    stopIfSqlNotOK(session, "insert into customer values(6155,'Mrs','Lauri','Davis','90101','222 Maple Lane,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6156,'Mr','Michael','Lindsey','77284','342 North Place,#150')")
    stopIfSqlNotOK(session, "insert into customer values(6157,'Mr','Perry','Davis','77577','220 Park Place,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6158,'Mr','Jay','Winters','00673','66 Jefferson Street,#76')")
    stopIfSqlNotOK(session, "insert into customer values(6159,'Mr','Victor','Jones','78886','240 Adams Avenue,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6160,'Mrs','Vonda','Baxter','28747','216 Main Walk,#200')")
    stopIfSqlNotOK(session, "insert into customer values(6161,'Mr','Ron','Ewing','78832','178 Cherry Drive,#107')")
    stopIfSqlNotOK(session, "insert into customer values(6162,'Mrs','Marjorie','Williams','77560','379 Cherry Boulevard,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6163,'Mr','William','Davis','76352','16 Pine Place,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6164,'Mrs','Holly','Roberson','85082','228 Tenth Ave,#166')")
    stopIfSqlNotOK(session, "insert into customer values(6165,'Mrs','Susana','Chambers','76865','433 Tenth Avenue,#177')")
    stopIfSqlNotOK(session, "insert into customer values(6166,'Mrs','Betty','Knapp','78152','469 East Road,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6167,'Mrs','Nancy','Simon','75630','147 Wilson Walk,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6168,'Mr','Manuel','Wilson','92117','293 Maple St.,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6169,'Mr','Gregory','Reilly','75505','159 Washington Road,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6170,'Mrs','Kelli','Taylor','75153','233 Elm Parkway,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6171,'Mrs','Patricia','Glenn','79260','468 Dogwood Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(6172,'Mr','Jeffrey','Davis','37998','22 Hill Place,#57')")
    stopIfSqlNotOK(session, "insert into customer values(6173,'Mr','Allen','Blankenship','78960','194 Green Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6174,'Mr','William','Miller','75428','171 Dogwood Road,#173')")
    stopIfSqlNotOK(session, "insert into customer values(6175,'Mrs','Adele','Day','78339','77 Fifteenth Boulevard,#32')")
    stopIfSqlNotOK(session, "insert into customer values(6176,'Mrs','Sandra','Miller','76357','130 Madison Place,#197')")
    stopIfSqlNotOK(session, "insert into customer values(6177,'Mr','Sidney','Merrill','85044','471 First Parkway,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6178,'Mr','Charles','Guzman','75979','127 Willow Square,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6179,'Mrs','Callie','Miller','77429','234 Lee Lane,#18')")
    stopIfSqlNotOK(session, "insert into customer values(6180,'Mrs','Carol','Kerr','76673','276 Main Square,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6181,'Mrs','Katelyn','Smith','00975','251 Poplar Boulevard,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6182,'Mrs','Barbara','Taylor','76238','424 Laurel Ave,#107')")
    stopIfSqlNotOK(session, "insert into customer values(6183,'Mr','Joseph','Williams','75439','104 Sycamore Drive,#63')")
    stopIfSqlNotOK(session, "insert into customer values(6184,'Mrs','Noemi','Williams','77857','299 Ninth St.,#1')")
    stopIfSqlNotOK(session, "insert into customer values(6185,'Mrs','Betty','Brown','75398','133 Wilson Blvd,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6186,'Mr','Warren','Miller','18435','23 Chestnut Road,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6187,'Mrs','Faith','Rowe','79786','187 Railroad Boulevard,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6188,'Mrs','Maureen','Johnson','88563','354 Railroad Avenue,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6189,'Mr','Warren','Brown','70112','385 Forest Street,#76')")
    stopIfSqlNotOK(session, "insert into customer values(6190,'Mrs','Shelia','Salas','76044','113 First Boulevard,#134')")
    stopIfSqlNotOK(session, "insert into customer values(6191,'Mr','Theodore','Perkins','87053','60 Maple Ave,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6192,'Mrs','Carol','Johnson','76523','365 Eleventh Walk,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6193,'Mr','Tyrone','Woodard','76453','94 Tenth Avenue,#167')")
    stopIfSqlNotOK(session, "insert into customer values(6194,'Mr','David','Johnson','76848','56 Jackson St.,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6195,'Mrs','Rachael','Logan','77539','55 Church Parkway,#21')")
    stopIfSqlNotOK(session, "insert into customer values(6196,'Mr','Thomas','Sargent','92712','94 Taylor Boulevard,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6197,'Mr','William','Brown','76234','352 Railroad Walk,#169')")
    stopIfSqlNotOK(session, "insert into customer values(6198,'Mr','Raul','Houston','77615','53 Second Parkway,#24')")
    stopIfSqlNotOK(session, "insert into customer values(6199,'Mrs','Wilda','Jackson','78245','353 Madison Parkway,#55')")
    stopIfSqlNotOK(session, "insert into customer values(6200,'Mr','Richard','Smith','79003','99 Hickory Lane,#185')")
    stopIfSqlNotOK(session, "insert into customer values(6201,'Mrs','Barbara','Jones','77960','202 Dogwood Boulevard,#83')")
    stopIfSqlNotOK(session, "insert into customer values(6202,'Mr','Joseph','Mayer','79718','92 Center Street,#160')")
    stopIfSqlNotOK(session, "insert into customer values(6203,'Mr','Aaron','Jones','78598','226 Park Walk,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6204,'Mrs','Patricia','Gonzales','40544','102 River Blvd,#56')")
    stopIfSqlNotOK(session, "insert into customer values(6205,'Mrs','Sharon','Davis','76045','25 Third Ave,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6206,'Mr','Brent','Moore','75641','94 Elm Place,#171')")
    stopIfSqlNotOK(session, "insert into customer values(6207,'Mr','John','Oneil','75438','440 Hickory Drive,#172')")
    stopIfSqlNotOK(session, "insert into customer values(6208,'Mrs','Tina','Wilson','76869','228 Sycamore St.,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6209,'Mrs','Barbara','Fitzpatrick','60020','458 Second Drive,#151')")
    stopIfSqlNotOK(session, "insert into customer values(6210,'Mr','Manuel','Baldwin','76518','330 Spruce Place,#127')")
    stopIfSqlNotOK(session, "insert into customer values(6211,'Mr','Michael','Palmer','78053','50 Wilson Square,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6212,'Mrs','Sandra','Campos','76849','289 Jefferson Boulevard,#186')")
    stopIfSqlNotOK(session, "insert into customer values(6213,'Mrs','Sharon','Taylor','75067','76 Washington Ave,#58')")
    stopIfSqlNotOK(session, "insert into customer values(6214,'Mrs','Martha','Salazar','79544','392 Davis Road,#163')")
    stopIfSqlNotOK(session, "insert into customer values(6215,'Mrs','Serena','Wilson','95409','493 Pine Square,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6216,'Mrs','Barbara','Davis','77844','303 Pine Street,#45')")
    stopIfSqlNotOK(session, "insert into customer values(6217,'Mr','James','Davis','75778','47 Main Avenue,#41')")
    stopIfSqlNotOK(session, "insert into customer values(6218,'Mrs','Deana','Perry','01921','176 River Street,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6219,'Mrs','Eleanor','Savage','73051','442 Elm Road,#21')")
    stopIfSqlNotOK(session, "insert into customer values(6220,'Mrs','Clare','Swanson','79161','190 Jackson Avenue,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6221,'Mr','Joseph','Dale','76084','77 Lincoln Ave,#27')")
    stopIfSqlNotOK(session, "insert into customer values(6222,'Mrs','Naomi','Jones','18417','152 Dogwood Walk,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6223,'Mrs','Patricia','Gibson','95045','245 Valley Ave,#195')")
    stopIfSqlNotOK(session, "insert into customer values(6224,'Mr','Jerry','Davis','77532','32 Eleventh St.,#167')")
    stopIfSqlNotOK(session, "insert into customer values(6225,'Mrs','Aurelia','Williams','77713','81 Ninth Ave,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6226,'Mr','William','Smith','40121','125 Washington Road,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6227,'Mr','Jerome','Johnson','76874','387 Walnut Lane,#77')")
    stopIfSqlNotOK(session, "insert into customer values(6228,'Mr','Jimmy','Williams','10019','121 Hillcrest Avenue,#27')")
    stopIfSqlNotOK(session, "insert into customer values(6229,'Mr','Casey','Blankenship','38047','62 Spring Parkway,#48')")
    stopIfSqlNotOK(session, "insert into customer values(6230,'Mr','Jimmy','Miller','00950','305 Twelfth Street,#40')")
    stopIfSqlNotOK(session, "insert into customer values(6231,'Mr','Andrew','Moore','75068','57 Ridge Street,#200')")
    stopIfSqlNotOK(session, "insert into customer values(6232,'Mr','Dustin','Wilson','78075','304 Willow Square,#34')")
    stopIfSqlNotOK(session, "insert into customer values(6233,'Mr','Robert','Bartlett','90671','304 East Blvd,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6234,'Mrs','Helena','Yates','78062','148 Pine Parkway,#83')")
    stopIfSqlNotOK(session, "insert into customer values(6235,'Mrs','Tasha','Johnson','92070','114 Main Parkway,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6236,'Mrs','Betty','Davis','76383','201 Fourth Avenue,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6237,'Mrs','Barbara','Moore','98392','19 Fifteenth Avenue,#168')")
    stopIfSqlNotOK(session, "insert into customer values(6238,'Mrs','Susan','Wilson','77437','301 Central Square,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6239,'Mr','Alvin','Howell','95066','16 Sunset Road,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6240,'Mr','David','Wilson','78619','328 Spring Drive,#87')")
    stopIfSqlNotOK(session, "insert into customer values(6241,'Mr','Phillip','Johnson','76225','161 Chestnut Boulevard,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6242,'Mr','John','Lowery','78641','341 Washington Ave,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6243,'Mr','James','Cochran','90018','447 Mill Street,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6244,'Mrs','Betty','Shaw','78605','228 Green Ave,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6245,'Mr','Salvador','Smith','75563','392 Fourth Blvd,#81')")
    stopIfSqlNotOK(session, "insert into customer values(6246,'Mrs','Luz','Knowles','75977','61 Maple Square,#163')")
    stopIfSqlNotOK(session, "insert into customer values(6247,'Mr','John','Finley','76022','143 Broadway Lane,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6248,'Mr','Michael','Moore','77428','441 Main Road,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6249,'Mr','Aaron','Johnson','58737','357 Main Drive,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6250,'Mrs','Jennifer','Sellers','68351','122 Wilson Drive,#199')")
    stopIfSqlNotOK(session, "insert into customer values(6251,'Mrs','Sharon','Beach','75253','498 Railroad Street,#117')")
    stopIfSqlNotOK(session, "insert into customer values(6252,'Mrs','Nancy','Williams','65265','7 Fifth Parkway,#51')")
    stopIfSqlNotOK(session, "insert into customer values(6253,'Mrs','Inez','Horton','77563','73 Third Walk,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6254,'Mrs','Hollie','Tanner','77445','423 Franklin Parkway,#117')")
    stopIfSqlNotOK(session, "insert into customer values(6255,'Mr','John','Wilson','79070','112 Davis Place,#66')")
    stopIfSqlNotOK(session, "insert into customer values(6256,'Mrs','Sandra','Brown','95055','138 Williams Avenue,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6257,'Mr','James','Davis','79036','80 Jackson Ave,#12')")
    stopIfSqlNotOK(session, "insert into customer values(6258,'Mrs','Imelda','Diaz','42787','395 Hillcrest Parkway,#130')")
    stopIfSqlNotOK(session, "insert into customer values(6259,'Mrs','Susan','Williams','78932','321 Ninth Parkway,#4')")
    stopIfSqlNotOK(session, "insert into customer values(6260,'Mrs','Ada','Luna','76476','312 Jackson Street,#79')")
    stopIfSqlNotOK(session, "insert into customer values(6261,'Mr','John','Miller','79541','224 Jackson Walk,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6262,'Mrs','Sharon','Spencer','12203','366 Green Avenue,#57')")
    stopIfSqlNotOK(session, "insert into customer values(6263,'Mr','Thomas','Jimenez','76712','26 Cherry Street,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6264,'Mrs','Sandra','Banks','87567','192 Poplar Drive,#198')")
    stopIfSqlNotOK(session, "insert into customer values(6265,'Mr','Ralph','Conley','77983','214 Walnut Blvd,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6266,'Mrs','Christa','Miller','79232','448 Seventh Road,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6267,'Mrs','Sandra','Williams','37909','415 Highland Square,#183')")
    stopIfSqlNotOK(session, "insert into customer values(6268,'Mrs','Jennifer','Ryan','78070','462 College Drive,#188')")
    stopIfSqlNotOK(session, "insert into customer values(6269,'Mrs','Sandra','Nichols','85644','361 North Blvd,#51')")
    stopIfSqlNotOK(session, "insert into customer values(6270,'Mr','Todd','Smith','32352','482 Fourteenth Square,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6271,'Mrs','Stacy','Jones','79713','126 Miller Avenue,#164')")
    stopIfSqlNotOK(session, "insert into customer values(6272,'Mr','Calvin','Harrington','76848','324 North Lane,#177')")
    stopIfSqlNotOK(session, "insert into customer values(6273,'Mr','Charles','Miller','24054','164 Thirteenth Place,#167')")
    stopIfSqlNotOK(session, "insert into customer values(6274,'Mrs','Dorothy','Wiggins','76643','230 Franklin Parkway,#17')")
    stopIfSqlNotOK(session, "insert into customer values(6275,'Mrs','Betty','Davis','28784','481 Third Place,#132')")
    stopIfSqlNotOK(session, "insert into customer values(6276,'Mrs','Barbara','Cantu','75969','182 Ninth Lane,#76')")
    stopIfSqlNotOK(session, "insert into customer values(6277,'Mr','John','Allen','75359','208 Lakeview Blvd,#146')")
    stopIfSqlNotOK(session, "insert into customer values(6278,'Mr','Charlie','Buckner','20608','102 Mill Place,#133')")
    stopIfSqlNotOK(session, "insert into customer values(6279,'Mrs','Reyna','Ferrell','75502','212 Twelfth Parkway,#162')")
    stopIfSqlNotOK(session, "insert into customer values(6280,'Mr','Charles','Powell','76639','298 Eleventh Avenue,#189')")
    stopIfSqlNotOK(session, "insert into customer values(6281,'Mr','Justin','Bush','45385','198 Hill Street,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6282,'Mrs','Mable','Henderson','75008','289 Valley Parkway,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6283,'Mr','Jim','Wilson','13308','304 View Road,#178')")
    stopIfSqlNotOK(session, "insert into customer values(6284,'Mrs','Fanny','Smith','76801','196 South Place,#120')")
    stopIfSqlNotOK(session, "insert into customer values(6285,'Mrs','Nancy','Walls','64742','57 College Lane,#41')")
    stopIfSqlNotOK(session, "insert into customer values(6286,'Mrs','Tracie','Daugherty','93441','148 West St.,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6287,'Mrs','Nannie','Brown','75966','124 Ninth Ave,#180')")
    stopIfSqlNotOK(session, "insert into customer values(6288,'Mr','William','Johnson','33575','166 Tenth Lane,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6289,'Mrs','Carol','Johnson','79961','262 View Ave,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6290,'Mr','Shawn','Miller','78025','58 Willow Place,#37')")
    stopIfSqlNotOK(session, "insert into customer values(6291,'Mr','Michael','Johnson','76261','404 Miller Parkway,#104')")
    stopIfSqlNotOK(session, "insert into customer values(6292,'Mrs','Susan','Taylor','75182','233 Second Parkway,#115')")
    stopIfSqlNotOK(session, "insert into customer values(6293,'Mr','David','Johnson','88434','106 Taylor Boulevard,#113')")
    stopIfSqlNotOK(session, "insert into customer values(6294,'Mrs','Amy','Miller','78839','180 Franklin St.,#83')")
    stopIfSqlNotOK(session, "insert into customer values(6295,'Mrs','Celina','Stanley','50076','437 Valley Blvd,#169')")
    stopIfSqlNotOK(session, "insert into customer values(6296,'Mr','Michael','Robertson','75951','278 Fourth Parkway,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6297,'Mrs','Janine','Davis','78676','339 Fourteenth St.,#122')")
    stopIfSqlNotOK(session, "insert into customer values(6298,'Mrs','Susan','Ortega','18435','237 Elm Drive,#119')")
    stopIfSqlNotOK(session, "insert into customer values(6299,'Mr','David','Sanchez','78063','338 Laurel Blvd,#196')")
    stopIfSqlNotOK(session, "insert into customer values(6300,'Mrs','Harriet','Mccarthy','76249','189 South Road,#49')")
    stopIfSqlNotOK(session, "insert into customer values(6301,'Mrs','Betty','Stark','77450','354 Wilson Street,#135')")
    stopIfSqlNotOK(session, "insert into customer values(6302,'Mrs','Yvette','Blackburn','76384','374 Sunset Street,#188')")
    stopIfSqlNotOK(session, "insert into customer values(6303,'Mr','Roberto','Cross','49854','277 Mill Drive,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6304,'Mrs','Betty','Jarvis','75440','25 Sycamore Ave,#166')")
    stopIfSqlNotOK(session, "insert into customer values(6305,'Mr','Frederick','Jones','78372','198 Willow Road,#38')")
    stopIfSqlNotOK(session, "insert into customer values(6306,'Mr','John','Baird','15662','171 Jefferson Parkway,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6307,'Mrs','Patricia','Taylor','81429','345 Willow Ave,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6308,'Mr','Richard','Wilson','75169','150 Fifth Parkway,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6309,'Mrs','Jennifer','Gray','76578','343 Johnson Square,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6310,'Mrs','Arline','Fuller','77417','376 Poplar Drive,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6311,'Mrs','Betty','Jones','78006','469 Third Avenue,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6312,'Mr','Frederick','Davis','59831','13 Taylor Street,#193')")
    stopIfSqlNotOK(session, "insert into customer values(6313,'Mr','Robert','Moore','76874','164 Twelfth Boulevard,#166')")
    stopIfSqlNotOK(session, "insert into customer values(6314,'Mrs','Patricia','Mckinney','77545','168 Main Square,#168')")
    stopIfSqlNotOK(session, "insert into customer values(6315,'Mr','Charles','Smith','48096','388 Elm Place,#126')")
    stopIfSqlNotOK(session, "insert into customer values(6316,'Mrs','Elvira','Smith','79356','467 Church Walk,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6317,'Mrs','Sharon','Greene','78616','100 Lakeview Ave,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6318,'Mr','Alexander','Horne','93661','33 Third Drive,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6319,'Mr','David','Davis','27920','179 Oak Drive,#168')")
    stopIfSqlNotOK(session, "insert into customer values(6320,'Mrs','Jennifer','Davis','75557','313 Park Parkway,#193')")
    stopIfSqlNotOK(session, "insert into customer values(6321,'Mr','Miguel','Williams','43001','124 Hillcrest Ave,#73')")
    stopIfSqlNotOK(session, "insert into customer values(6322,'Mrs','Sharon','Williams','07021','277 Poplar Ave,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6323,'Mrs','Sandra','Barrera','15730','89 Sycamore St.,#27')")
    stopIfSqlNotOK(session, "insert into customer values(6324,'Mrs','Angeline','Alford','77612','497 Lincoln Boulevard,#119')")
    stopIfSqlNotOK(session, "insert into customer values(6325,'Mr','Alfred','Johnson','93249','491 River Blvd,#105')")
    stopIfSqlNotOK(session, "insert into customer values(6326,'Mrs','Sharon','Downs','77443','106 Lee Square,#182')")
    stopIfSqlNotOK(session, "insert into customer values(6327,'Mrs','Yvette','Patel','06781','473 Fourth Parkway,#57')")
    stopIfSqlNotOK(session, "insert into customer values(6328,'Mrs','Harriet','Mcclain','76251','135 Highland Walk,#151')")
    stopIfSqlNotOK(session, "insert into customer values(6329,'Mr','Dustin','Williams','75968','100 Second Lane,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6330,'Mrs','Rachelle','King','78163','330 Locust Parkway,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6331,'Mrs','Nancy','Woodward','75066','494 Tenth Walk,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6332,'Mr','Micheal','Johnson','75001','76 Davis Square,#85')")
    stopIfSqlNotOK(session, "insert into customer values(6333,'Mrs','Allison','Rodgers','60020','275 Sixth Street,#114')")
    stopIfSqlNotOK(session, "insert into customer values(6334,'Mr','Joseph','Macias','51638','431 Cherry Road,#151')")
    stopIfSqlNotOK(session, "insert into customer values(6335,'Mrs','Hillary','Davis','76712','62 Davis Square,#140')")
    stopIfSqlNotOK(session, "insert into customer values(6336,'Mrs','Abby','Winters','78065','242 Jefferson Square,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6337,'Mrs','Rosalind','Fowler','78596','312 Broadway Boulevard,#88')")
    stopIfSqlNotOK(session, "insert into customer values(6338,'Mrs','Maura','Warren','77482','112 Ninth Road,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6339,'Mr','Frederick','Poole','97423','367 Center Parkway,#57')")
    stopIfSqlNotOK(session, "insert into customer values(6340,'Mrs','Carol','Smith','76667','469 Fifteenth Blvd,#10')")
    stopIfSqlNotOK(session, "insert into customer values(6341,'Mr','Eric','Davis','79090','98 Locust Road,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6342,'Mrs','Barbara','Taylor','78835','470 Lee Road,#68')")
    stopIfSqlNotOK(session, "insert into customer values(6343,'Mrs','Sandra','Travis','63446','257 Poplar Lane,#105')")
    stopIfSqlNotOK(session, "insert into customer values(6344,'Mr','Wallace','Shepherd','76436','331 East Square,#49')")
    stopIfSqlNotOK(session, "insert into customer values(6345,'Mrs','Nancy','Johnson','78606','80 Ninth Drive,#178')")
    stopIfSqlNotOK(session, "insert into customer values(6346,'Mr','Dwayne','Simmons','75065','472 Maple Ave,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6347,'Mr','Richard','Taylor','77566','265 Park Lane,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6348,'Mrs','Dolly','Johnson','79224','476 East Place,#56')")
    stopIfSqlNotOK(session, "insert into customer values(6349,'Mr','Michael','Davis','80731','55 Second Street,#104')")
    stopIfSqlNotOK(session, "insert into customer values(6350,'Mrs','Sandra','Miller','77580','398 Park Parkway,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6351,'Mr','David','Taylor','93150','38 Franklin St.,#86')")
    stopIfSqlNotOK(session, "insert into customer values(6352,'Mr','Bob','Beard','29827','343 Ash Street,#10')")
    stopIfSqlNotOK(session, "insert into customer values(6353,'Mrs','Neva','Wilson','02332','286 Franklin Drive,#49')")
    stopIfSqlNotOK(session, "insert into customer values(6354,'Mr','John','Sargent','76036','281 River Walk,#105')")
    stopIfSqlNotOK(session, "insert into customer values(6355,'Mr','Tim','Brown','97476','104 Sunset Parkway,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6356,'Mrs','Crystal','Davis','75501','131 Sunset Ave,#169')")
    stopIfSqlNotOK(session, "insert into customer values(6357,'Mrs','Alexandra','Hendricks','00753','332 Seventh Place,#81')")
    stopIfSqlNotOK(session, "insert into customer values(6358,'Mr','William','Moore','22125','185 Willow Street,#107')")
    stopIfSqlNotOK(session, "insert into customer values(6359,'Mrs','Kimberly','Moore','70765','135 Laurel Ave,#26')")
    stopIfSqlNotOK(session, "insert into customer values(6360,'Mrs','Mari','Moore','79565','294 Eighth Street,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6361,'Mr','James','Moore','77383','45 Miller Square,#27')")
    stopIfSqlNotOK(session, "insert into customer values(6362,'Mr','James','Moore','23106','108 Poplar Square,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6363,'Mrs','Charlotte','Hawkins','78837','292 Johnson Avenue,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6364,'Mrs','Patricia','Jones','79084','45 Smith Street,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6365,'Mr','Michael','Anderson','26566','156 Hickory Ave,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6366,'Mr','Michael','Pena','79024','73 Fourth Street,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6367,'Mrs','Jennifer','Reid','75077','40 Green Boulevard,#35')")
    stopIfSqlNotOK(session, "insert into customer values(6368,'Mr','Armando','Johnson','85349','413 Jefferson Walk,#121')")
    stopIfSqlNotOK(session, "insert into customer values(6369,'Mr','Robert','Taylor','75975','449 Lincoln Drive,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6370,'Mrs','Barbara','Guerrero','27340','407 Center Parkway,#147')")
    stopIfSqlNotOK(session, "insert into customer values(6371,'Mrs','Pearl','Riley','78608','311 Pine St.,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6372,'Mrs','Dee','Smith','56502','238 Sunset Lane,#31')")
    stopIfSqlNotOK(session, "insert into customer values(6373,'Mr','Richard','Little','97840','149 River Place,#162')")
    stopIfSqlNotOK(session, "insert into customer values(6374,'Mr','Victor','Burks','78953','245 Spruce Walk,#17')")
    stopIfSqlNotOK(session, "insert into customer values(6375,'Mrs','Susan','Foley','30417','238 Ash Boulevard,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6376,'Mrs','Rosemary','Randolph','75359','248 Williams Parkway,#44')")
    stopIfSqlNotOK(session, "insert into customer values(6377,'Mr','Chris','Randall','79019','261 Fourth Boulevard,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6378,'Mrs','Marianne','Franks','31737','460 Thirteenth Place,#6')")
    stopIfSqlNotOK(session, "insert into customer values(6379,'Mrs','Patricia','Johnson','31643','168 Ash Lane,#73')")
    stopIfSqlNotOK(session, "insert into customer values(6380,'Mrs','Earline','Crane','16232','245 Taylor Boulevard,#66')")
    stopIfSqlNotOK(session, "insert into customer values(6381,'Mrs','Esperanza','Miller','76627','266 Williams Ave,#127')")
    stopIfSqlNotOK(session, "insert into customer values(6382,'Mrs','Sharon','Larson','71307','233 Poplar St.,#143')")
    stopIfSqlNotOK(session, "insert into customer values(6383,'Mr','Bernard','Campos','51638','444 Mill Place,#151')")
    stopIfSqlNotOK(session, "insert into customer values(6384,'Mrs','Claudia','Jones','33441','263 Oak Blvd,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6385,'Mr','Thomas','Wilson','76444','55 Sixth Street,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6386,'Mrs','Sandra','Morgan','78588','330 Ash Square,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6387,'Mr','William','Wilson','79366','88 Cedar Place,#178')")
    stopIfSqlNotOK(session, "insert into customer values(6388,'Mr','Thomas','Owen','78478','28 Lake Street,#178')")
    stopIfSqlNotOK(session, "insert into customer values(6389,'Mr','Johnny','Moore','76472','128 Willow Street,#114')")
    stopIfSqlNotOK(session, "insert into customer values(6390,'Mr','Gordon','Carroll','84531','368 Sixth Lane,#56')")
    stopIfSqlNotOK(session, "insert into customer values(6391,'Mr','Joseph','Davis','90406','163 Fourth Blvd,#54')")
    stopIfSqlNotOK(session, "insert into customer values(6392,'Mrs','Tonia','Collins','75039','8 Center Blvd,#181')")
    stopIfSqlNotOK(session, "insert into customer values(6393,'Mrs','Bobbie','Williams','75780','229 Ash St.,#174')")
    stopIfSqlNotOK(session, "insert into customer values(6394,'Mrs','Jannie','Willis','63961','363 Pine Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6395,'Mrs','Jacquelyn','Grimes','76508','480 Mill Boulevard,#175')")
    stopIfSqlNotOK(session, "insert into customer values(6396,'Mr','Jeremy','Smith','76520','360 Maple Square,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6397,'Mrs','Caroline','Cantrell','18951','369 Central Street,#97')")
    stopIfSqlNotOK(session, "insert into customer values(6398,'Mrs','Susan','Hutchinson','76030','412 Cherry Square,#168')")
    stopIfSqlNotOK(session, "insert into customer values(6399,'Mr','Douglas','Moore','77951','277 Seventh Ave,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6400,'Mr','Leon','Swanson','75482','214 Ash Square,#63')")
    stopIfSqlNotOK(session, "insert into customer values(6401,'Mrs','Barbara','Powell','76872','55 Hickory Walk,#178')")
    stopIfSqlNotOK(session, "insert into customer values(6402,'Mr','Gregory','Terrell','76885','206 Fifth Parkway,#155')")
    stopIfSqlNotOK(session, "insert into customer values(6403,'Mrs','Daphne','Holt','76060','496 Fourteenth Avenue,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6404,'Mr','Cecil','Carver','77639','331 Spruce Blvd,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6405,'Mrs','Lorna','Jones','77415','447 Johnson Square,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6406,'Mr','Thomas','Weber','75844','309 Johnson Road,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6407,'Mr','Richard','Anderson','78562','344 Eleventh Boulevard,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6408,'Mr','Martin','Jenkins','75935','439 Pine Avenue,#194')")
    stopIfSqlNotOK(session, "insert into customer values(6409,'Mr','Manuel','Joyner','76090','365 Hickory Place,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6410,'Mr','Byron','Davis','77861','217 Lake Ave,#140')")
    stopIfSqlNotOK(session, "insert into customer values(6411,'Mr','Richard','Smith','19363','425 Central Boulevard,#175')")
    stopIfSqlNotOK(session, "insert into customer values(6412,'Mrs','Jennifer','Best','75011','44 Spring Parkway,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6413,'Mrs','Rachelle','Moore','78164','136 Church Square,#135')")
    stopIfSqlNotOK(session, "insert into customer values(6414,'Mr','Thomas','Taylor','90734','27 Mill Street,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6415,'Mrs','Patricia','Moore','76955','427 East Walk,#185')")
    stopIfSqlNotOK(session, "insert into customer values(6416,'Mrs','Corinne','Taylor','76445','394 Miller Street,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6417,'Mr','Charles','Walter','37912','460 Washington Square,#79')")
    stopIfSqlNotOK(session, "insert into customer values(6418,'Mr','Jacob','Cruz','78044','243 Dogwood Ave,#161')")
    stopIfSqlNotOK(session, "insert into customer values(6419,'Mr','Mario','Davis','79058','50 Jackson Parkway,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6420,'Mrs','Alissa','Davis','13362','83 Cedar Avenue,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6421,'Mrs','Patricia','Miller','76038','257 Davis Blvd,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6422,'Mrs','Susan','Hodge','25904','220 Willow Square,#151')")
    stopIfSqlNotOK(session, "insert into customer values(6423,'Mrs','Sharon','Williams','78606','261 North St.,#76')")
    stopIfSqlNotOK(session, "insert into customer values(6424,'Mr','Joseph','Ayers','76936','273 Washington Avenue,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6425,'Mr','Robert','Taylor','78108','213 Laurel Place,#93')")
    stopIfSqlNotOK(session, "insert into customer values(6426,'Mrs','Dorothy','Bean','58218','170 Fourteenth Boulevard,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6427,'Mr','Alex','Cross','77547','122 Franklin Drive,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6428,'Mr','Jessie','Moore','77833','238 Ridge Place,#67')")
    stopIfSqlNotOK(session, "insert into customer values(6429,'Mrs','Lakeisha','Bonner','76267','177 Cedar Blvd,#101')")
    stopIfSqlNotOK(session, "insert into customer values(6430,'Mr','Pedro','Miller','79521','183 Seventh Boulevard,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6431,'Mrs','Shelly','James','41602','378 South Place,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6432,'Mrs','Jan','Butler','77457','371 Fifteenth St.,#41')")
    stopIfSqlNotOK(session, "insert into customer values(6433,'Mr','Thomas','Miller','38351','123 Chestnut Street,#41')")
    stopIfSqlNotOK(session, "insert into customer values(6434,'Mr','Kenneth','Williams','76036','361 Adams Square,#169')")
    stopIfSqlNotOK(session, "insert into customer values(6435,'Mrs','Brandy','Smith','77446','331 Birch Drive,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6436,'Mr','Andrew','Mcgowan','63961','290 Green Place,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6437,'Mrs','Sharon','Moore','79937','497 Jackson Ave,#164')")
    stopIfSqlNotOK(session, "insert into customer values(6438,'Mrs','Marilyn','Justice','79251','181 Spruce Walk,#46')")
    stopIfSqlNotOK(session, "insert into customer values(6439,'Mrs','Barbara','Finley','93039','244 Railroad Walk,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6440,'Mrs','Angeline','Brown','76454','177 Miller Blvd,#59')")
    stopIfSqlNotOK(session, "insert into customer values(6441,'Mr','Richard','Williams','87566','380 Second Walk,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6442,'Mr','Floyd','Ellison','76626','99 Center Walk,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6443,'Mr','Brian','Melton','36736','251 Meadow Blvd,#52')")
    stopIfSqlNotOK(session, "insert into customer values(6444,'Mrs','Jennifer','Johnson','75974','49 South Blvd,#5')")
    stopIfSqlNotOK(session, "insert into customer values(6445,'Mr','Craig','Jones','89024','202 Lee Drive,#174')")
    stopIfSqlNotOK(session, "insert into customer values(6446,'Mr','David','Moore','35010','215 Maple Avenue,#67')")
    stopIfSqlNotOK(session, "insert into customer values(6447,'Mr','Joe','Mullen','77487','391 Main Road,#86')")
    stopIfSqlNotOK(session, "insert into customer values(6448,'Mr','Chester','Williams','76831','184 Highland Drive,#186')")
    stopIfSqlNotOK(session, "insert into customer values(6449,'Mr','Casey','Goodman','79366','81 Sycamore Drive,#100')")
    stopIfSqlNotOK(session, "insert into customer values(6450,'Mr','Donald','Taylor','75846','25 Pine Walk,#93')")
    stopIfSqlNotOK(session, "insert into customer values(6451,'Mr','Charles','Francis','78851','270 Spring Square,#146')")
    stopIfSqlNotOK(session, "insert into customer values(6452,'Mrs','Lorena','Vaughan','77436','433 Lincoln Drive,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6453,'Mrs','Kim','Brown','75258','172 Washington Square,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6454,'Mr','Bobby','Taylor','50161','417 Locust Drive,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6455,'Mrs','Barbra','Irwin','79756','48 Lee Lane,#188')")
    stopIfSqlNotOK(session, "insert into customer values(6456,'Mr','Lewis','Delaney','76076','208 Meadow Ave,#55')")
    stopIfSqlNotOK(session, "insert into customer values(6457,'Mrs','Dorothy','Taylor','37998','412 Cherry Boulevard,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6458,'Mrs','Betty','Williams','77561','210 South Lane,#59')")
    stopIfSqlNotOK(session, "insert into customer values(6459,'Mrs','Sandra','Rocha','79499','169 Chestnut Lane,#104')")
    stopIfSqlNotOK(session, "insert into customer values(6460,'Mr','Keith','Ortiz','78109','243 Mill Walk,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6461,'Mrs','Erika','Cross','75085','144 Elm Place,#176')")
    stopIfSqlNotOK(session, "insert into customer values(6462,'Mr','Michael','Davis','95103','147 South Road,#181')")
    stopIfSqlNotOK(session, "insert into customer values(6463,'Mr','Albert','Smith','41848','118 Lee Road,#142')")
    stopIfSqlNotOK(session, "insert into customer values(6464,'Mr','Joseph','Moore','76466','82 Birch Place,#133')")
    stopIfSqlNotOK(session, "insert into customer values(6465,'Mr','Shane','Jones','75094','224 Chestnut Boulevard,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6466,'Mrs','Dominique','Gallegos','78609','497 Dogwood Walk,#107')")
    stopIfSqlNotOK(session, "insert into customer values(6467,'Mrs','Lorene','Norman','78549','403 Second Walk,#173')")
    stopIfSqlNotOK(session, "insert into customer values(6468,'Mr','Robert','Brown','78265','255 View Blvd,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6469,'Mrs','Kathrine','Davis','58759','319 Mill Lane,#53')")
    stopIfSqlNotOK(session, "insert into customer values(6470,'Mr','Thomas','Williams','78161','186 Green Boulevard,#198')")
    stopIfSqlNotOK(session, "insert into customer values(6471,'Mrs','Kathrine','Richardson','76887','258 Church Avenue,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6472,'Mr','William','Davis','78658','137 Twelfth Drive,#103')")
    stopIfSqlNotOK(session, "insert into customer values(6473,'Mr','Michael','Jensen','87185','144 Poplar St.,#62')")
    stopIfSqlNotOK(session, "insert into customer values(6474,'Mr','Joseph','Jones','78393','297 Tenth Walk,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6475,'Mr','James','Smith','75569','67 Laurel Blvd,#135')")
    stopIfSqlNotOK(session, "insert into customer values(6476,'Mrs','Dorothy','Newton','29827','201 Johnson Parkway,#100')")
    stopIfSqlNotOK(session, "insert into customer values(6477,'Mr','Salvador','Williams','75758','192 Valley Place,#174')")
    stopIfSqlNotOK(session, "insert into customer values(6478,'Mrs','Sharon','Johnson','78063','475 Oak Avenue,#143')")
    stopIfSqlNotOK(session, "insert into customer values(6479,'Mr','Dave','Macdonald','56053','106 First Parkway,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6480,'Mrs','Barbara','Brown','36921','396 Center Street,#192')")
    stopIfSqlNotOK(session, "insert into customer values(6481,'Mrs','Kari','Workman','87053','461 Dogwood Ave,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6482,'Mrs','Leah','Taylor','75563','475 Sycamore Avenue,#38')")
    stopIfSqlNotOK(session, "insert into customer values(6483,'Mrs','Mabel','Wilson','75487','135 Willow Street,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6484,'Mrs','Brianna','Johnson','77369','158 Third St.,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6485,'Mr','Anthony','Cunningham','78614','64 Fifteenth Road,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6486,'Mrs','Susan','Howard','78161','270 Broadway Boulevard,#40')")
    stopIfSqlNotOK(session, "insert into customer values(6487,'Mrs','Patricia','Miller','76036','164 Ash Square,#86')")
    stopIfSqlNotOK(session, "insert into customer values(6488,'Mrs','Denise','Williams','68732','370 Fifteenth Avenue,#49')")
    stopIfSqlNotOK(session, "insert into customer values(6489,'Mr','Robert','Smith','75185','419 Lakeview Ave,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6490,'Mr','Randall','Sandoval','78112','315 Highland Lane,#118')")
    stopIfSqlNotOK(session, "insert into customer values(6491,'Mrs','Stacie','Williams','75478','149 Main Blvd,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6492,'Mrs','Susan','Davis','76854','463 Dogwood Ave,#99')")
    stopIfSqlNotOK(session, "insert into customer values(6493,'Mrs','Barbara','Ashley','78802','272 Elm Walk,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6494,'Mrs','Janelle','Lester','77882','399 Fourteenth Road,#165')")
    stopIfSqlNotOK(session, "insert into customer values(6495,'Mrs','Blanca','Brown','78072','295 Woodland Street,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6496,'Mrs','Sharon','Rutledge','77882','215 Second Drive,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6497,'Mr','Richard','Moore','98333','484 Madison Road,#51')")
    stopIfSqlNotOK(session, "insert into customer values(6498,'Mr','Joseph','Jones','83441','290 Fourth Road,#131')")
    stopIfSqlNotOK(session, "insert into customer values(6499,'Mrs','Susan','Taylor','76437','189 Sixth Road,#65')")
    stopIfSqlNotOK(session, "insert into customer values(6500,'Mr','David','Francis','93160','299 Franklin Walk,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6501,'Mrs','Lynn','Hancock','50040','400 Lee Ave,#45')")
    stopIfSqlNotOK(session, "insert into customer values(6502,'Mr','Thomas','Gross','75756','460 Willow Blvd,#56')")
    stopIfSqlNotOK(session, "insert into customer values(6503,'Mrs','Hallie','Robertson','76832','262 Forest Lane,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6504,'Mr','Joseph','Good','57118','437 Oak Boulevard,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6505,'Mr','Tommy','Johnson','75359','255 Sunset Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(6506,'Mrs','Carol','Evans','78774','56 Woodland Street,#15')")
    stopIfSqlNotOK(session, "insert into customer values(6507,'Mr','Michael','Bruce','76537','464 Pine Place,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6508,'Mr','Thomas','Moore','75683','384 View St.,#11')")
    stopIfSqlNotOK(session, "insert into customer values(6509,'Mr','Dennis','Hoover','71239','69 Ash Parkway,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6510,'Mr','Jordan','Hendrix','01240','348 Sixth Street,#107')")
    stopIfSqlNotOK(session, "insert into customer values(6511,'Mr','Rafael','Head','31019','50 Mill Blvd,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6512,'Mrs','Bonnie','Taylor','15847','399 Ash Blvd,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6513,'Mrs','Dorothy','Hunt','79837','209 Hickory Avenue,#26')")
    stopIfSqlNotOK(session, "insert into customer values(6514,'Mr','Andre','Flores','76667','194 Poplar Avenue,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6515,'Mr','William','Jones','79243','314 Williams St.,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6516,'Mr','Reginald','Jones','76931','46 East Lane,#31')")
    stopIfSqlNotOK(session, "insert into customer values(6517,'Mrs','Carol','Miller','93620','231 Cherry St.,#77')")
    stopIfSqlNotOK(session, "insert into customer values(6518,'Mrs','Natalie','Mason','15662','460 Fourteenth Walk,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6519,'Mrs','Gretchen','Day','78880','139 First Walk,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6520,'Mr','Ernest','Osborne','78549','342 Forest Avenue,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6521,'Mr','Marshall','Whitley','75835','326 Smith Walk,#130')")
    stopIfSqlNotOK(session, "insert into customer values(6522,'Mrs','Madeline','Willis','75980','260 Spring Walk,#199')")
    stopIfSqlNotOK(session, "insert into customer values(6523,'Mr','William','Chambers','37012','231 Tenth Avenue,#114')")
    stopIfSqlNotOK(session, "insert into customer values(6524,'Mr','Jesus','Kirk','79756','377 Fourth St.,#90')")
    stopIfSqlNotOK(session, "insert into customer values(6525,'Mr','Vernon','Edwards','78162','23 Lincoln St.,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6526,'Mrs','Carol','Stanley','95543','392 Jefferson Avenue,#22')")
    stopIfSqlNotOK(session, "insert into customer values(6527,'Mrs','Sharon','Brown','77973','478 East Road,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6528,'Mr','Roger','Francis','76454','3 Sixth Boulevard,#136')")
    stopIfSqlNotOK(session, "insert into customer values(6529,'Mrs','Leanna','Kent','78836','231 Maple Drive,#54')")
    stopIfSqlNotOK(session, "insert into customer values(6530,'Mr','Charles','Wilson','79932','307 Fourth Road,#15')")
    stopIfSqlNotOK(session, "insert into customer values(6531,'Mrs','Carol','Davis','75933','117 Seventh Place,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6532,'Mr','Thomas','Blackburn','77546','174 Fourteenth Boulevard,#103')")
    stopIfSqlNotOK(session, "insert into customer values(6533,'Mr','Thomas','Gordon','74008','97 East Blvd,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6534,'Mr','Fernando','Merritt','93255','350 West Avenue,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6535,'Mr','Charles','Mcclure','12148','75 Lincoln Road,#178')")
    stopIfSqlNotOK(session, "insert into customer values(6536,'Mr','David','Hoover','32352','170 Elm Lane,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6537,'Mrs','Barbara','Smith','76388','477 Willow Parkway,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6538,'Mr','Chad','Justice','58738','356 Railroad Square,#154')")
    stopIfSqlNotOK(session, "insert into customer values(6539,'Mrs','Barbara','Munoz','68351','143 Johnson Square,#22')")
    stopIfSqlNotOK(session, "insert into customer values(6540,'Mr','Charles','Stewart','78880','53 Laurel Blvd,#66')")
    stopIfSqlNotOK(session, "insert into customer values(6541,'Mrs','Raquel','Smith','75834','9 Thirteenth Drive,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6542,'Mr','Henry','Burgess','76057','217 Sycamore Ave,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6543,'Mrs','Patricia','Wells','79754','343 Ninth Drive,#200')")
    stopIfSqlNotOK(session, "insert into customer values(6544,'Mr','Freddie','Jones','65541','84 Green Ave,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6545,'Mrs','Susan','Smith','77277','492 Second Avenue,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6546,'Mrs','Sandra','Bowen','72131','110 Thirteenth Blvd,#104')")
    stopIfSqlNotOK(session, "insert into customer values(6547,'Mrs','Johanna','Taylor','76842','266 Miller Avenue,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6548,'Mr','Julian','Williams','76823','176 Hickory Drive,#180')")
    stopIfSqlNotOK(session, "insert into customer values(6549,'Mr','Kyle','Brown','76258','413 Williams Avenue,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6550,'Mr','Joseph','Hicks','75658','178 Lake Boulevard,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6551,'Mrs','Sharon','Davis','24450','427 Cedar Square,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6552,'Mr','Jessie','Booker','75759','133 Broadway Square,#6')")
    stopIfSqlNotOK(session, "insert into customer values(6553,'Mr','Glen','Dixon','87565','276 Maple Road,#58')")
    stopIfSqlNotOK(session, "insert into customer values(6554,'Mrs','Carol','Smith','75339','342 West Drive,#52')")
    stopIfSqlNotOK(session, "insert into customer values(6555,'Mrs','Patricia','Moore','75029','419 Ash Parkway,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6556,'Mr','Phillip','Davis','77369','377 Mill Parkway,#31')")
    stopIfSqlNotOK(session, "insert into customer values(6557,'Mrs','Carol','Davis','13456','377 Walnut Avenue,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6558,'Mr','Thomas','Donaldson','63430','218 Twelfth Walk,#121')")
    stopIfSqlNotOK(session, "insert into customer values(6559,'Mrs','Carol','Smith','87545','358 Valley Boulevard,#171')")
    stopIfSqlNotOK(session, "insert into customer values(6560,'Mr','Robert','Gibson','18935','410 Hillcrest Road,#158')")
    stopIfSqlNotOK(session, "insert into customer values(6561,'Mr','Ross','Brown','46374','11 Forest Road,#46')")
    stopIfSqlNotOK(session, "insert into customer values(6562,'Mr','Robert','Taylor','79248','373 Cherry Avenue,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6563,'Mrs','Barbara','Sims','75831','6 Sunset Square,#84')")
    stopIfSqlNotOK(session, "insert into customer values(6564,'Mrs','Lucy','Burks','76087','415 Poplar Avenue,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6565,'Mrs','Sandra','Campbell','77428','297 Laurel Place,#176')")
    stopIfSqlNotOK(session, "insert into customer values(6566,'Mrs','Rachelle','Johnson','18847','101 Taylor Road,#30')")
    stopIfSqlNotOK(session, "insert into customer values(6567,'Mrs','Lori','Smith','75694','134 Davis Walk,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6568,'Mrs','Bettye','Davis','62550','367 Poplar Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(6569,'Mrs','Susan','Miller','23920','423 Fifteenth Road,#14')")
    stopIfSqlNotOK(session, "insert into customer values(6570,'Mrs','Dorothy','Campbell','33470','360 Johnson Walk,#34')")
    stopIfSqlNotOK(session, "insert into customer values(6571,'Mr','David','Odom','50054','56 Green Drive,#59')")
    stopIfSqlNotOK(session, "insert into customer values(6572,'Mrs','Nicole','Wilson','79321','149 Wilson Lane,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6573,'Mr','David','Wilson','19073','234 Forest Lane,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6574,'Mr','Barry','Lott','58760','247 Elm Walk,#56')")
    stopIfSqlNotOK(session, "insert into customer values(6575,'Mr','Thomas','Fitzpatrick','75936','270 North Street,#101')")
    stopIfSqlNotOK(session, "insert into customer values(6576,'Mr','John','Walsh','76664','16 Smith Road,#109')")
    stopIfSqlNotOK(session, "insert into customer values(6577,'Mr','Leo','Johnson','78776','407 Woodland Walk,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6578,'Mr','David','Mathis','79511','214 Hickory Boulevard,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6579,'Mr','Hector','Elliott','76360','500 View Ave,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6580,'Mrs','Nancy','Bridges','76457','100 Cedar Boulevard,#192')")
    stopIfSqlNotOK(session, "insert into customer values(6581,'Mr','Charles','Garrett','76233','496 Washington Parkway,#199')")
    stopIfSqlNotOK(session, "insert into customer values(6582,'Mr','John','Acevedo','00754','185 Woodland Parkway,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6583,'Mrs','Adeline','Stevenson','78658','400 East Square,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6584,'Mr','James','Miller','04435','239 Elm Drive,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6585,'Mrs','Christi','Moore','75339','466 Hickory Avenue,#197')")
    stopIfSqlNotOK(session, "insert into customer values(6586,'Mrs','Jo','Miller','71307','493 Meadow Place,#191')")
    stopIfSqlNotOK(session, "insert into customer values(6587,'Mr','Erik','Davis','76638','53 Hickory Ave,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6588,'Mrs','Sharon','Sanders','79744','89 Twelfth Boulevard,#188')")
    stopIfSqlNotOK(session, "insert into customer values(6589,'Mrs','Shauna','Riddle','76651','351 Mill Square,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6590,'Mrs','Susan','Ramsey','97423','360 Hickory Street,#20')")
    stopIfSqlNotOK(session, "insert into customer values(6591,'Mrs','Sandra','Combs','75481','92 Green Avenue,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6592,'Mrs','Barbara','Duncan','79546','355 Center Ave,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6593,'Mrs','Mallory','Brennan','76622','45 Hill Lane,#1')")
    stopIfSqlNotOK(session, "insert into customer values(6594,'Mr','David','Thompson','79367','324 Locust Ave,#40')")
    stopIfSqlNotOK(session, "insert into customer values(6595,'Mrs','Sharron','Davis','76842','197 Oak Street,#99')")
    stopIfSqlNotOK(session, "insert into customer values(6596,'Mr','Thomas','Ferguson','79932','175 West Road,#15')")
    stopIfSqlNotOK(session, "insert into customer values(6597,'Mr','Danny','Johnson','79538','405 Locust Square,#33')")
    stopIfSqlNotOK(session, "insert into customer values(6598,'Mr','John','Snyder','47138','96 Eighth Ave,#3')")
    stopIfSqlNotOK(session, "insert into customer values(6599,'Mr','Brandon','Kirk','10475','462 Sycamore Lane,#147')")
    stopIfSqlNotOK(session, "insert into customer values(6600,'Mrs','Patricia','Fields','94404','258 Oak Parkway,#120')")
    stopIfSqlNotOK(session, "insert into customer values(6601,'Mrs','Carol','Delaney','75470','425 Lakeview Lane,#28')")
    stopIfSqlNotOK(session, "insert into customer values(6602,'Mrs','Dorothy','Grant','78364','73 Meadow Blvd,#7')")
    stopIfSqlNotOK(session, "insert into customer values(6603,'Mr','Charles','Dominguez','91351','370 Oak Street,#30')")
    stopIfSqlNotOK(session, "insert into customer values(6604,'Mrs','Herminia','Conway','76094','48 Oak Walk,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6605,'Mr','Richard','Davis','48450','342 Smith Place,#127')")
    stopIfSqlNotOK(session, "insert into customer values(6606,'Mrs','Patricia','Smith','75763','246 View Parkway,#137')")
    stopIfSqlNotOK(session, "insert into customer values(6607,'Mr','Richard','Moore','77839','215 Third Lane,#68')")
    stopIfSqlNotOK(session, "insert into customer values(6608,'Mr','Joseph','Jones','75436','195 Davis Street,#95')")
    stopIfSqlNotOK(session, "insert into customer values(6609,'Mr','David','Terrell','94583','298 Center Square,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6610,'Mr','Maurice','Wood','77430','63 Sunset Road,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6611,'Mrs','Susana','Sandoval','76206','500 Elm Avenue,#117')")
    stopIfSqlNotOK(session, "insert into customer values(6612,'Mrs','Leanna','Moore','78146','160 Sycamore Square,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6613,'Mrs','Susana','Brown','78606','158 Third Boulevard,#153')")
    stopIfSqlNotOK(session, "insert into customer values(6614,'Mr','Michael','Davis','78566','129 South Avenue,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6615,'Mr','James','Johnson','77477','7 Elm Square,#44')")
    stopIfSqlNotOK(session, "insert into customer values(6616,'Mr','Franklin','Davis','76574','307 South Boulevard,#15')")
    stopIfSqlNotOK(session, "insert into customer values(6617,'Mr','Travis','Taylor','55332','408 Lakeview Street,#85')")
    stopIfSqlNotOK(session, "insert into customer values(6618,'Mr','Jorge','Johnson','79768','384 Meadow Walk,#63')")
    stopIfSqlNotOK(session, "insert into customer values(6619,'Mrs','Nancy','Brown','74637','180 Laurel Street,#142')")
    stopIfSqlNotOK(session, "insert into customer values(6620,'Mrs','Maryellen','Coleman','23967','471 Cherry St.,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6621,'Mr','Michael','Washington','68351','465 Walnut Square,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6622,'Mr','John','Johnson','76388','303 Fifteenth Ave,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6623,'Mr','Thomas','Taylor','54557','147 Fourth Walk,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6624,'Mrs','Bobbie','Johnson','78833','259 Hillcrest Square,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6625,'Mrs','Kristie','Jenkins','79053','376 Seventh Street,#105')")
    stopIfSqlNotOK(session, "insert into customer values(6626,'Mrs','Patricia','Byrd','90671','47 Taylor Avenue,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6627,'Mrs','Patricia','Johnson','76076','426 Fourth Road,#151')")
    stopIfSqlNotOK(session, "insert into customer values(6628,'Mr','David','Dickerson','75478','94 South Boulevard,#78')")
    stopIfSqlNotOK(session, "insert into customer values(6629,'Mr','Michael','Carlson','19453','477 Wilson Lane,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6630,'Mr','William','Jones','10286','496 Pine Place,#177')")
    stopIfSqlNotOK(session, "insert into customer values(6631,'Mr','David','Morin','67753','260 Center Avenue,#107')")
    stopIfSqlNotOK(session, "insert into customer values(6632,'Mrs','Lacy','Schultz','45381','260 Sunset Walk,#60')")
    stopIfSqlNotOK(session, "insert into customer values(6633,'Mr','Charles','Moore','90094','246 Jackson Lane,#53')")
    stopIfSqlNotOK(session, "insert into customer values(6634,'Mrs','Abby','Jones','75860','110 Central Parkway,#130')")
    stopIfSqlNotOK(session, "insert into customer values(6635,'Mrs','Marla','Patton','75243','382 Sunset Parkway,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6636,'Mrs','Susan','Johnson','22334','93 Locust Avenue,#119')")
    stopIfSqlNotOK(session, "insert into customer values(6637,'Mrs','Elisabeth','Gregory','75557','229 Washington Street,#167')")
    stopIfSqlNotOK(session, "insert into customer values(6638,'Mr','Alfred','Battle','87567','313 Davis St.,#50')")
    stopIfSqlNotOK(session, "insert into customer values(6639,'Mr','Ricardo','Bartlett','78613','325 Lakeview Parkway,#158')")
    stopIfSqlNotOK(session, "insert into customer values(6640,'Mrs','Betty','Morgan','77880','268 East Blvd,#61')")
    stopIfSqlNotOK(session, "insert into customer values(6641,'Mrs','Lilly','Moore','16036','264 View Street,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6642,'Mrs','Patricia','Moore','95054','484 Wilson Walk,#192')")
    stopIfSqlNotOK(session, "insert into customer values(6643,'Mr','Derrick','Moore','93665','362 Birch St.,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6644,'Mr','Eric','Brown','61021','486 Spring Boulevard,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6645,'Mrs','Ilene','Miller','92231','107 Pine Street,#66')")
    stopIfSqlNotOK(session, "insert into customer values(6646,'Mr','Michael','Bonner','39535','278 Center Street,#14')")
    stopIfSqlNotOK(session, "insert into customer values(6647,'Mr','Tyler','Bond','75376','492 Pine Square,#97')")
    stopIfSqlNotOK(session, "insert into customer values(6648,'Mr','Michael','Taylor','06064','342 Hillcrest Place,#113')")
    stopIfSqlNotOK(session, "insert into customer values(6649,'Mrs','Lucinda','Johnson','23308','69 Locust Parkway,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6650,'Mrs','Jennifer','Kirk','77339','163 Ninth Avenue,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6651,'Mrs','Patricia','Beasley','70310','121 Poplar Road,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6652,'Mr','Richard','Moore','75839','223 Lee Parkway,#35')")
    stopIfSqlNotOK(session, "insert into customer values(6653,'Mr','Joseph','Miller','77969','178 Johnson Lane,#186')")
    stopIfSqlNotOK(session, "insert into customer values(6654,'Mrs','Young','Miller','78653','51 Eighth Walk,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6655,'Mrs','Jennifer','Mcintyre','78565','321 Third Lane,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6656,'Mrs','Tasha','Taylor','07465','34 Third Boulevard,#74')")
    stopIfSqlNotOK(session, "insert into customer values(6657,'Mr','Terrence','Brown','32018','350 Eighth St.,#173')")
    stopIfSqlNotOK(session, "insert into customer values(6658,'Mr','Matthew','Miller','76366','119 Park Square,#182')")
    stopIfSqlNotOK(session, "insert into customer values(6659,'Mr','Joseph','Moore','77973','72 North Drive,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6660,'Mrs','Lynn','Jarvis','76051','455 Third Street,#164')")
    stopIfSqlNotOK(session, "insert into customer values(6661,'Mrs','Judith','Davis','78591','472 Williams Avenue,#188')")
    stopIfSqlNotOK(session, "insert into customer values(6662,'Mr','Richard','Smith','78941','213 Ridge Square,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6663,'Mr','Thomas','Smith','79114','460 Main Avenue,#12')")
    stopIfSqlNotOK(session, "insert into customer values(6664,'Mrs','Victoria','Jones','78653','160 Adams St.,#59')")
    stopIfSqlNotOK(session, "insert into customer values(6665,'Mrs','Dorothy','Taylor','75096','243 Cedar Avenue,#115')")
    stopIfSqlNotOK(session, "insert into customer values(6666,'Mr','Ted','Jones','75558','440 Willow Walk,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6667,'Mr','Herman','Quinn','78608','212 Williams Walk,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6668,'Mrs','Susan','Boone','78579','281 Hickory Avenue,#90')")
    stopIfSqlNotOK(session, "insert into customer values(6669,'Mr','Joseph','Moore','78111','305 Davis Boulevard,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6670,'Mr','Joseph','Davis','76866','345 Walnut Walk,#76')")
    stopIfSqlNotOK(session, "insert into customer values(6671,'Mrs','Jody','Beach','78681','125 Third St.,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6672,'Mr','David','Harper','78141','324 Meadow Avenue,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6673,'Mrs','Latonya','Smith','15376','434 Dogwood Avenue,#186')")
    stopIfSqlNotOK(session, "insert into customer values(6674,'Mrs','Mable','Brown','24174','107 Jackson Road,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6675,'Mrs','Sharon','Watts','79036','341 Second Parkway,#83')")
    stopIfSqlNotOK(session, "insert into customer values(6676,'Mr','Richard','Smith','75835','438 Adams Square,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6677,'Mr','Robert','Ellison','77450','204 Ridge Drive,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6678,'Mrs','Raquel','Williams','76246','15 First Parkway,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6679,'Mrs','Amanda','Jones','71311','175 Jackson Ave,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6680,'Mrs','Sherrie','Hansen','76890','228 Thirteenth Ave,#93')")
    stopIfSqlNotOK(session, "insert into customer values(6681,'Mr','Marshall','Taylor','75956','258 Wilson Blvd,#161')")
    stopIfSqlNotOK(session, "insert into customer values(6682,'Mrs','Nikki','Moore','77477','236 Sixth Road,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6683,'Mr','Nathan','Perry','88435','127 River Square,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6684,'Mr','Francisco','Mccormick','76265','454 Tenth Parkway,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6685,'Mrs','Nancy','Brown','77412','204 Williams Street,#150')")
    stopIfSqlNotOK(session, "insert into customer values(6686,'Mr','Johnny','Smith','79240','319 Green Lane,#94')")
    stopIfSqlNotOK(session, "insert into customer values(6687,'Mr','Michael','Knapp','87556','296 Hillcrest Street,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6688,'Mr','John','Abbott','79221','359 Taylor Street,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6689,'Mrs','Jennifer','Wilson','50076','140 Valley Parkway,#141')")
    stopIfSqlNotOK(session, "insert into customer values(6690,'Mrs','Susan','Marquez','78342','315 Highland Road,#28')")
    stopIfSqlNotOK(session, "insert into customer values(6691,'Mr','Charles','Alvarez','76066','8 Birch Avenue,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6692,'Mrs','Ester','Moore','76435','143 Ash Street,#193')")
    stopIfSqlNotOK(session, "insert into customer values(6693,'Mr','Richard','Johnson','87545','383 Meadow Blvd,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6694,'Mr','Joseph','Odom','75660','278 Broadway Place,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6695,'Mr','Shawn','Carver','77349','285 Pine Avenue,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6696,'Mr','Thomas','Taylor','04426','423 Madison Drive,#53')")
    stopIfSqlNotOK(session, "insert into customer values(6697,'Mr','Nathan','Gross','28521','176 Washington Lane,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6698,'Mrs','Grace','Miller','35648','219 South Square,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6699,'Mr','Michael','Davis','19341','39 Poplar Blvd,#181')")
    stopIfSqlNotOK(session, "insert into customer values(6700,'Mr','Kenneth','Miller','10286','412 Hickory Boulevard,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6701,'Mrs','Hazel','Jones','77617','467 Elm Street,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6702,'Mr','Richard','Larsen','79837','245 Cedar Street,#192')")
    stopIfSqlNotOK(session, "insert into customer values(6703,'Mr','Joseph','Whitaker','77985','447 Highland Drive,#55')")
    stopIfSqlNotOK(session, "insert into customer values(6704,'Mrs','Staci','Johnson','76057','427 Smith Ave,#186')")
    stopIfSqlNotOK(session, "insert into customer values(6705,'Mr','Milton','Smith','75850','111 Cedar Lane,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6706,'Mrs','Dorothy','Duke','79541','445 Ridge Road,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6707,'Mrs','Lupe','Glass','78516','17 Dogwood Avenue,#31')")
    stopIfSqlNotOK(session, "insert into customer values(6708,'Mr','Lester','Williams','76267','45 East Square,#87')")
    stopIfSqlNotOK(session, "insert into customer values(6709,'Mrs','Imelda','Barry','78957','369 Lakeview St.,#46')")
    stopIfSqlNotOK(session, "insert into customer values(6710,'Mrs','Rosella','Riggs','67119','396 Sycamore Boulevard,#86')")
    stopIfSqlNotOK(session, "insert into customer values(6711,'Mrs','Candice','Williams','10185','51 South Boulevard,#185')")
    stopIfSqlNotOK(session, "insert into customer values(6712,'Mrs','Barbara','Forbes','75685','368 Tenth St.,#93')")
    stopIfSqlNotOK(session, "insert into customer values(6713,'Mrs','Nancy','Miller','81150','178 Ninth Boulevard,#149')")
    stopIfSqlNotOK(session, "insert into customer values(6714,'Mrs','Estela','Merrill','78886','25 Fourth Square,#173')")
    stopIfSqlNotOK(session, "insert into customer values(6715,'Mr','Allen','Guzman','75608','363 Seventh Drive,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6716,'Mrs','Sandra','Finch','04930','56 Sunset Square,#47')")
    stopIfSqlNotOK(session, "insert into customer values(6717,'Mrs','Robert','Gilmore','75065','356 Hill Blvd,#195')")
    stopIfSqlNotOK(session, "insert into customer values(6718,'Mrs','Bernice','Joseph','77839','176 Thirteenth Place,#134')")
    stopIfSqlNotOK(session, "insert into customer values(6719,'Mrs','Susan','Johnson','76030','244 Thirteenth Ave,#127')")
    stopIfSqlNotOK(session, "insert into customer values(6720,'Mr','Wade','Wallace','78390','203 Center Parkway,#74')")
    stopIfSqlNotOK(session, "insert into customer values(6721,'Mr','Bill','Williams','76578','205 Center Place,#33')")
    stopIfSqlNotOK(session, "insert into customer values(6722,'Mrs','Barbara','Wiggins','32352','277 Sixth Walk,#88')")
    stopIfSqlNotOK(session, "insert into customer values(6723,'Mrs','Nina','Taylor','29666','429 Ash Walk,#162')")
    stopIfSqlNotOK(session, "insert into customer values(6724,'Mrs','Serena','Smith','01813','213 Adams Avenue,#77')")
    stopIfSqlNotOK(session, "insert into customer values(6725,'Mr','Manuel','Bray','93190','494 Main Place,#120')")
    stopIfSqlNotOK(session, "insert into customer values(6726,'Mrs','Sharon','Olsen','62332','88 Eleventh Parkway,#50')")
    stopIfSqlNotOK(session, "insert into customer values(6727,'Mr','Phillip','Miles','79842','428 Spring Drive,#191')")
    stopIfSqlNotOK(session, "insert into customer values(6728,'Mrs','Deirdre','Brown','94583','460 Hillcrest Boulevard,#146')")
    stopIfSqlNotOK(session, "insert into customer values(6729,'Mrs','Irene','Johnson','77451','212 Meadow Walk,#195')")
    stopIfSqlNotOK(session, "insert into customer values(6730,'Mr','Maurice','Alexander','78672','354 Tenth Street,#8')")
    stopIfSqlNotOK(session, "insert into customer values(6731,'Mr','Brian','Anderson','79530','420 South Road,#24')")
    stopIfSqlNotOK(session, "insert into customer values(6732,'Mrs','Kari','Brown','76580','301 Taylor Ave,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6733,'Mr','Harry','Williams','76026','58 Hillcrest Parkway,#50')")
    stopIfSqlNotOK(session, "insert into customer values(6734,'Mrs','Barbara','Sosa','13036','14 Smith Avenue,#5')")
    stopIfSqlNotOK(session, "insert into customer values(6735,'Mr','Michael','Miller','79325','14 View Street,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6736,'Mr','Michael','Valentine','75754','28 East Street,#153')")
    stopIfSqlNotOK(session, "insert into customer values(6737,'Mr','Ian','Craig','78019','373 College Avenue,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6738,'Mr','Richard','Mccarty','52745','497 Tenth Parkway,#79')")
    stopIfSqlNotOK(session, "insert into customer values(6739,'Mrs','Lakisha','Johnson','02035','167 West Road,#73')")
    stopIfSqlNotOK(session, "insert into customer values(6740,'Mrs','Lorie','Mccoy','74465','151 Ninth Parkway,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6741,'Mrs','Jamie','Rhodes','77993','381 Seventh Square,#88')")
    stopIfSqlNotOK(session, "insert into customer values(6742,'Mr','Johnny','Jones','78853','323 South Blvd,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6743,'Mrs','Ina','Davis','87053','396 Ash Lane,#132')")
    stopIfSqlNotOK(session, "insert into customer values(6744,'Mrs','Justine','Gentry','79512','479 Miller Street,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6745,'Mrs','Betty','Dalton','15767','102 Fifteenth Drive,#101')")
    stopIfSqlNotOK(session, "insert into customer values(6746,'Mrs','Susan','Brown','76230','226 Third Blvd,#81')")
    stopIfSqlNotOK(session, "insert into customer values(6747,'Mr','Casey','Watts','77467','93 Second St.,#52')")
    stopIfSqlNotOK(session, "insert into customer values(6748,'Mr','David','Smith','27872','161 Sycamore Lane,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6749,'Mrs','Nancy','Chen','23141','284 Central Drive,#32')")
    stopIfSqlNotOK(session, "insert into customer values(6750,'Mr','Darrell','Taylor','75855','205 Cherry Lane,#31')")
    stopIfSqlNotOK(session, "insert into customer values(6751,'Mrs','Dorothy','Brown','76248','62 Walnut Place,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6752,'Mr','David','Frederick','93249','310 Mill Boulevard,#34')")
    stopIfSqlNotOK(session, "insert into customer values(6753,'Mr','Jared','Lowery','14005','430 Johnson Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(6754,'Mr','Theodore','Johnson','78002','138 Smith Road,#200')")
    stopIfSqlNotOK(session, "insert into customer values(6755,'Mrs','Nancy','Mcfarland','72051','268 Oak Place,#136')")
    stopIfSqlNotOK(session, "insert into customer values(6756,'Mrs','Louisa','Brown','78659','378 Wilson Blvd,#168')")
    stopIfSqlNotOK(session, "insert into customer values(6757,'Mr','David','Hudson','77414','36 Mill Road,#129')")
    stopIfSqlNotOK(session, "insert into customer values(6758,'Mr','Armando','Smith','75689','3 Sycamore Square,#5')")
    stopIfSqlNotOK(session, "insert into customer values(6759,'Mr','Jacob','Kerr','76626','340 North Ave,#103')")
    stopIfSqlNotOK(session, "insert into customer values(6760,'Mrs','Nelda','Marquez','79502','465 Spruce Street,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6761,'Mr','John','Wilson','76873','212 Elm Blvd,#133')")
    stopIfSqlNotOK(session, "insert into customer values(6762,'Mrs','Sandra','Sharpe','97109','74 Eighth Square,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6763,'Mrs','Barbara','Smith','78639','106 Williams Road,#18')")
    stopIfSqlNotOK(session, "insert into customer values(6764,'Mrs','Nancy','Cervantes','79848','256 Madison Road,#68')")
    stopIfSqlNotOK(session, "insert into customer values(6765,'Mr','Charles','Smith','79529','456 Poplar St.,#90')")
    stopIfSqlNotOK(session, "insert into customer values(6766,'Mr','Bernard','Wilson','37902','80 Fifth St.,#154')")
    stopIfSqlNotOK(session, "insert into customer values(6767,'Mr','Jack','Zamora','78960','311 Washington Square,#16')")
    stopIfSqlNotOK(session, "insert into customer values(6768,'Mr','Eric','Sears','76570','292 Fourth Boulevard,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6769,'Mr','James','Franco','50420','481 Sixth Square,#193')")
    stopIfSqlNotOK(session, "insert into customer values(6770,'Mr','Richard','Taylor','78776','409 Fourteenth St.,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6771,'Mrs','Letha','Miller','72565','307 Johnson Street,#18')")
    stopIfSqlNotOK(session, "insert into customer values(6772,'Mr','Enrique','Dudley','78830','235 East Avenue,#142')")
    stopIfSqlNotOK(session, "insert into customer values(6773,'Mr','Richard','Mccall','79010','261 Central St.,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6774,'Mr','Marion','Hancock','62601','361 Main Avenue,#75')")
    stopIfSqlNotOK(session, "insert into customer values(6775,'Mrs','Betty','Burch','22965','136 Willow Place,#82')")
    stopIfSqlNotOK(session, "insert into customer values(6776,'Mr','Charles','Smith','79097','405 Ninth Boulevard,#86')")
    stopIfSqlNotOK(session, "insert into customer values(6777,'Mr','Thomas','Davis','66713','398 Willow Place,#81')")
    stopIfSqlNotOK(session, "insert into customer values(6778,'Mr','James','Mcclain','75048','304 Chestnut Parkway,#179')")
    stopIfSqlNotOK(session, "insert into customer values(6779,'Mr','Alvin','Taylor','76950','188 Central St.,#101')")
    stopIfSqlNotOK(session, "insert into customer values(6780,'Mr','John','Davis','76299','284 Cherry Street,#7')")
    stopIfSqlNotOK(session, "insert into customer values(6781,'Mr','Frank','Johnson','77432','460 Seventh Walk,#85')")
    stopIfSqlNotOK(session, "insert into customer values(6782,'Mrs','Susan','Pierce','78610','231 Park Walk,#162')")
    stopIfSqlNotOK(session, "insert into customer values(6783,'Mr','Randy','Taylor','75440','294 College Walk,#19')")
    stopIfSqlNotOK(session, "insert into customer values(6784,'Mrs','Aurelia','Shaffer','77665','303 Taylor Road,#198')")
    stopIfSqlNotOK(session, "insert into customer values(6785,'Mrs','Dorothy','Lee','13826','319 Elm Parkway,#117')")
    stopIfSqlNotOK(session, "insert into customer values(6786,'Mr','David','Davis','75785','77 Spring Street,#110')")
    stopIfSqlNotOK(session, "insert into customer values(6787,'Mr','Richard','May','59222','405 Hickory Parkway,#195')")
    stopIfSqlNotOK(session, "insert into customer values(6788,'Mrs','Annmarie','Hines','77835','458 Cedar Blvd,#35')")
    stopIfSqlNotOK(session, "insert into customer values(6789,'Mrs','Irene','Church','90029','90 Hillcrest Blvd,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6790,'Mr','Thomas','Cline','77477','154 Forest Blvd,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6791,'Mr','Richard','Brown','75845','30 Forest Road,#25')")
    stopIfSqlNotOK(session, "insert into customer values(6792,'Mr','James','Taylor','78163','187 Poplar Place,#78')")
    stopIfSqlNotOK(session, "insert into customer values(6793,'Mrs','Laura','Roach','78886','296 Highland Lane,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6794,'Mrs','Susan','Smith','79063','18 Wilson Square,#51')")
    stopIfSqlNotOK(session, "insert into customer values(6795,'Mr','Felix','Miller','75070','426 College Avenue,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6796,'Mrs','Carol','Cruz','62830','411 East Walk,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6797,'Mrs','Adrienne','Smith','78636','58 Center Street,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6798,'Mrs','Carol','Smith','76463','154 North Walk,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6799,'Mr','Matthew','Smith','13487','434 Locust Street,#140')")
    stopIfSqlNotOK(session, "insert into customer values(6800,'Mrs','Nancy','Smith','77358','218 Thirteenth Parkway,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6801,'Mrs','Betty','Brown','95106','422 Sycamore Parkway,#195')")
    stopIfSqlNotOK(session, "insert into customer values(6802,'Mrs','Dorothy','Jones','01929','250 Lake Blvd,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6803,'Mr','Rodney','Wilson','79847','333 Pine Lane,#24')")
    stopIfSqlNotOK(session, "insert into customer values(6804,'Mr','Bradley','Stuart','11942','442 Lakeview Walk,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6805,'Mrs','Pearlie','Davis','78538','301 Spring Avenue,#68')")
    stopIfSqlNotOK(session, "insert into customer values(6806,'Mrs','Alexandra','Davis','42268','5 Thirteenth Lane,#167')")
    stopIfSqlNotOK(session, "insert into customer values(6807,'Mrs','Sharon','Miller','67119','380 Wilson Drive,#49')")
    stopIfSqlNotOK(session, "insert into customer values(6808,'Mrs','Susan','Sosa','61458','141 Sycamore Drive,#175')")
    stopIfSqlNotOK(session, "insert into customer values(6809,'Mrs','Jolene','Smith','54217','321 Cherry Lane,#81')")
    stopIfSqlNotOK(session, "insert into customer values(6810,'Mr','Alfred','Giles','94146','455 Green Road,#105')")
    stopIfSqlNotOK(session, "insert into customer values(6811,'Mrs','Lakeisha','Brown','50851','437 Central Avenue,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6812,'Mrs','Carol','Miller','76552','105 Fifth Street,#70')")
    stopIfSqlNotOK(session, "insert into customer values(6813,'Mrs','Sandra','Chavez','67121','324 East Boulevard,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6814,'Mrs','Leila','Eaton','61334','250 Dogwood Drive,#37')")
    stopIfSqlNotOK(session, "insert into customer values(6815,'Mr','Alex','Vaughn','75421','339 Lincoln Blvd,#48')")
    stopIfSqlNotOK(session, "insert into customer values(6816,'Mrs','Corrine','Taylor','75642','203 Adams Street,#133')")
    stopIfSqlNotOK(session, "insert into customer values(6817,'Mr','Charles','Peck','78122','251 Wilson Blvd,#46')")
    stopIfSqlNotOK(session, "insert into customer values(6818,'Mrs','Janie','Fischer','75694','60 South Street,#121')")
    stopIfSqlNotOK(session, "insert into customer values(6819,'Mr','Francis','Landry','78003','107 Seventh Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(6820,'Mrs','Deann','Hunt','06262','428 Wilson Lane,#132')")
    stopIfSqlNotOK(session, "insert into customer values(6821,'Mrs','Joan','Jones','19353','395 North St.,#118')")
    stopIfSqlNotOK(session, "insert into customer values(6822,'Mrs','Patricia','Smith','94112','426 Mill St.,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6823,'Mrs','Jennifer','Jones','75681','382 West Lane,#166')")
    stopIfSqlNotOK(session, "insert into customer values(6824,'Mrs','Concepcion','Mckinney','56659','209 Lee Parkway,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6825,'Mrs','Sharon','Jones','77572','267 East Square,#182')")
    stopIfSqlNotOK(session, "insert into customer values(6826,'Mr','Alvin','Smith','78060','75 Birch Boulevard,#60')")
    stopIfSqlNotOK(session, "insert into customer values(6827,'Mrs','Pearl','Mcguire','47354','336 Davis St.,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6828,'Mr','Morris','Miller','77331','428 Highland Road,#186')")
    stopIfSqlNotOK(session, "insert into customer values(6829,'Mrs','Carol','Guzman','79843','107 South Blvd,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6830,'Mrs','Cecilia','Jones','04093','205 North Boulevard,#33')")
    stopIfSqlNotOK(session, "insert into customer values(6831,'Mr','Alberto','Schultz','76571','430 Birch Road,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6832,'Mr','Michael','Wilson','04435','52 College Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(6833,'Mr','Russell','Cole','43343','26 Oak Lane,#33')")
    stopIfSqlNotOK(session, "insert into customer values(6834,'Mr','Javier','Williams','77518','243 Poplar Square,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6835,'Mrs','Betty','Wilson','58760','240 Eighth Ave,#109')")
    stopIfSqlNotOK(session, "insert into customer values(6836,'Mr','Darryl','Williams','75105','168 Fourteenth Parkway,#81')")
    stopIfSqlNotOK(session, "insert into customer values(6837,'Mr','John','Jones','87733','8 Walnut Square,#118')")
    stopIfSqlNotOK(session, "insert into customer values(6838,'Mrs','Tracey','Moore','75416','317 Madison Drive,#21')")
    stopIfSqlNotOK(session, "insert into customer values(6839,'Mr','Brett','Jones','77964','215 Williams Street,#163')")
    stopIfSqlNotOK(session, "insert into customer values(6840,'Mr','Tommy','Brown','18932','363 Seventh Boulevard,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6841,'Mr','Salvador','Schroeder','77612','220 Ninth St.,#198')")
    stopIfSqlNotOK(session, "insert into customer values(6842,'Mrs','Cecile','Brown','85359','335 Hillcrest Place,#77')")
    stopIfSqlNotOK(session, "insert into customer values(6843,'Mrs','Dorothy','Johnson','77572','375 Jackson Walk,#65')")
    stopIfSqlNotOK(session, "insert into customer values(6844,'Mr','Michael','Holman','77564','438 Taylor Street,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6845,'Mrs','Rosario','Vega','06262','451 Lincoln Parkway,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6846,'Mrs','Audra','Dorsey','79244','181 Central Ave,#90')")
    stopIfSqlNotOK(session, "insert into customer values(6847,'Mr','Gerald','Taylor','94175','54 Williams Street,#15')")
    stopIfSqlNotOK(session, "insert into customer values(6848,'Mrs','Jennifer','Cruz','78022','445 Thirteenth Street,#175')")
    stopIfSqlNotOK(session, "insert into customer values(6849,'Mrs','Justine','Frank','95409','355 Adams Street,#170')")
    stopIfSqlNotOK(session, "insert into customer values(6850,'Mr','Charles','Johnson','52323','67 Chestnut Blvd,#9')")
    stopIfSqlNotOK(session, "insert into customer values(6851,'Mrs','Rosemary','Taylor','76508','419 Fifteenth Avenue,#84')")
    stopIfSqlNotOK(session, "insert into customer values(6852,'Mr','Sam','Brown','15952','457 Birch Ave,#5')")
    stopIfSqlNotOK(session, "insert into customer values(6853,'Mrs','Carol','Moore','10185','132 Jefferson Square,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6854,'Mrs','Betty','Weiss','78374','494 Railroad Street,#83')")
    stopIfSqlNotOK(session, "insert into customer values(6855,'Mr','Rick','Head','54730','275 Poplar Ave,#52')")
    stopIfSqlNotOK(session, "insert into customer values(6856,'Mr','Robert','Taylor','78280','97 Smith Street,#63')")
    stopIfSqlNotOK(session, "insert into customer values(6857,'Mr','Rodney','Davis','75275','302 Spring Place,#61')")
    stopIfSqlNotOK(session, "insert into customer values(6858,'Mrs','Jayne','Wilson','48413','241 Jackson Place,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6859,'Mr','Scott','Conway','79036','475 Wilson Boulevard,#116')")
    stopIfSqlNotOK(session, "insert into customer values(6860,'Mr','Thomas','Norton','76577','11 Hillcrest Drive,#119')")
    stopIfSqlNotOK(session, "insert into customer values(6861,'Mr','John','Williams','76657','32 East Street,#30')")
    stopIfSqlNotOK(session, "insert into customer values(6862,'Mr','James','Barrett','78870','81 Sycamore Place,#35')")
    stopIfSqlNotOK(session, "insert into customer values(6863,'Mr','Clifford','Atkinson','67027','88 Washington St.,#34')")
    stopIfSqlNotOK(session, "insert into customer values(6864,'Mr','James','Wood','90406','23 Pine Place,#44')")
    stopIfSqlNotOK(session, "insert into customer values(6865,'Mr','Marshall','Haynes','71315','238 South Boulevard,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6866,'Mrs','Patricia','Ingram','79721','269 Meadow Walk,#19')")
    stopIfSqlNotOK(session, "insert into customer values(6867,'Mrs','Sharon','Williams','77866','496 Center Place,#47')")
    stopIfSqlNotOK(session, "insert into customer values(6868,'Mr','Theodore','Wilson','78390','468 Valley Ave,#173')")
    stopIfSqlNotOK(session, "insert into customer values(6869,'Mrs','Charmaine','Jones','75855','223 Chestnut Drive,#32')")
    stopIfSqlNotOK(session, "insert into customer values(6870,'Mrs','Patricia','Wilson','77837','458 River Avenue,#43')")
    stopIfSqlNotOK(session, "insert into customer values(6871,'Mr','Ian','Brown','77422','263 Woodland Ave,#54')")
    stopIfSqlNotOK(session, "insert into customer values(6872,'Mr','Robert','Moore','77245','93 Fourth Ave,#131')")
    stopIfSqlNotOK(session, "insert into customer values(6873,'Mr','Jesus','Bass','78004','355 Lake Avenue,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6874,'Mrs','Guadalupe','Wilson','97639','403 Ridge St.,#158')")
    stopIfSqlNotOK(session, "insert into customer values(6875,'Mr','Arnold','Davis','79084','327 Sixth Place,#28')")
    stopIfSqlNotOK(session, "insert into customer values(6876,'Mrs','Barbara','Smith','79178','33 Fourth Avenue,#89')")
    stopIfSqlNotOK(session, "insert into customer values(6877,'Mrs','Susan','Wilson','78830','282 Laurel Street,#61')")
    stopIfSqlNotOK(session, "insert into customer values(6878,'Mr','Joseph','Ramirez','85051','273 Fifteenth Walk,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6879,'Mrs','Lorrie','Jones','28521','283 River Parkway,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6880,'Mrs','Tina','Miller','77363','130 Taylor Drive,#60')")
    stopIfSqlNotOK(session, "insert into customer values(6881,'Mr','John','Kirk','76857','290 Jefferson Walk,#155')")
    stopIfSqlNotOK(session, "insert into customer values(6882,'Mr','John','Moore','88563','224 Woodland Avenue,#142')")
    stopIfSqlNotOK(session, "insert into customer values(6883,'Mr','Michael','Kerr','27235','164 Highland Parkway,#42')")
    stopIfSqlNotOK(session, "insert into customer values(6884,'Mr','Mark','Dennis','78677','129 Hill Boulevard,#37')")
    stopIfSqlNotOK(session, "insert into customer values(6885,'Mr','Joseph','Wilson','97535','317 Main Walk,#163')")
    stopIfSqlNotOK(session, "insert into customer values(6886,'Mr','James','Mueller','76357','75 Elm Ave,#2')")
    stopIfSqlNotOK(session, "insert into customer values(6887,'Mr','John','Hodge','78140','378 Wilson Square,#189')")
    stopIfSqlNotOK(session, "insert into customer values(6888,'Mrs','Kathryn','Johnson','01242','240 Ninth Lane,#51')")
    stopIfSqlNotOK(session, "insert into customer values(6889,'Mr','Joseph','Bates','77650','288 Lincoln Parkway,#23')")
    stopIfSqlNotOK(session, "insert into customer values(6890,'Mrs','Abby','Williams','75067','152 Railroad St.,#181')")
    stopIfSqlNotOK(session, "insert into customer values(6891,'Mrs','Betty','Davis','78832','340 Lincoln Boulevard,#14')")
    stopIfSqlNotOK(session, "insert into customer values(6892,'Mr','Herbert','Moore','77238','382 Mill Drive,#44')")
    stopIfSqlNotOK(session, "insert into customer values(6893,'Mr','William','Miller','07021','9 Lake Drive,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6894,'Mr','Stanley','Mcknight','78547','249 River Walk,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6895,'Mr','Joseph','Smith','75757','339 Fourteenth Square,#92')")
    stopIfSqlNotOK(session, "insert into customer values(6896,'Mrs','Nikki','Duke','75929','234 Davis Road,#19')")
    stopIfSqlNotOK(session, "insert into customer values(6897,'Mrs','Milagros','Brown','75165','473 Laurel Parkway,#11')")
    stopIfSqlNotOK(session, "insert into customer values(6898,'Mrs','Sharon','Logan','78073','331 Miller Square,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6899,'Mr','James','Solomon','79966','327 Center Place,#16')")
    stopIfSqlNotOK(session, "insert into customer values(6900,'Mr','Nathan','Taylor','91776','267 Highland Road,#96')")
    stopIfSqlNotOK(session, "insert into customer values(6901,'Mrs','Sandra','Ratliff','76716','386 Poplar Walk,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6902,'Mr','Lewis','Gates','75487','415 Lakeview Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6903,'Mr','James','Mueller','78570','205 Forest St.,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6904,'Mr','James','Jones','52326','433 Fourteenth Street,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6905,'Mr','Cody','Taylor','18032','425 North Place,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6906,'Mr','Thomas','Miller','75152','124 College Drive,#148')")
    stopIfSqlNotOK(session, "insert into customer values(6907,'Mr','Michael','Haley','75103','209 Sunset Road,#102')")
    stopIfSqlNotOK(session, "insert into customer values(6908,'Mrs','Muriel','Raymond','76463','374 Walnut Parkway,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6909,'Mrs','Sonia','Fox','40596','296 Birch Drive,#98')")
    stopIfSqlNotOK(session, "insert into customer values(6910,'Mrs','Patricia','Williams','77213','382 Jefferson Blvd,#150')")
    stopIfSqlNotOK(session, "insert into customer values(6911,'Mrs','Jamie','Moore','75759','337 Lincoln Parkway,#139')")
    stopIfSqlNotOK(session, "insert into customer values(6912,'Mrs','Susan','Brown','75339','366 Central Place,#172')")
    stopIfSqlNotOK(session, "insert into customer values(6913,'Mr','Christopher','Moore','72820','297 Broadway Boulevard,#192')")
    stopIfSqlNotOK(session, "insert into customer values(6914,'Mrs','Rosalind','Miller','65231','488 Franklin Ave,#16')")
    stopIfSqlNotOK(session, "insert into customer values(6915,'Mr','Joel','Little','75860','420 Valley Drive,#94')")
    stopIfSqlNotOK(session, "insert into customer values(6916,'Mr','Joseph','Combs','79033','43 Railroad Avenue,#124')")
    stopIfSqlNotOK(session, "insert into customer values(6917,'Mr','John','Gilbert','19452','349 Church Parkway,#69')")
    stopIfSqlNotOK(session, "insert into customer values(6918,'Mr','Charles','Avery','93121','289 Railroad Avenue,#34')")
    stopIfSqlNotOK(session, "insert into customer values(6919,'Mrs','Diana','Smith','16745','351 Lee Place,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6920,'Mr','Thomas','Graham','78066','89 Fifth Ave,#156')")
    stopIfSqlNotOK(session, "insert into customer values(6921,'Mrs','Hazel','Snider','75680','450 Ridge Drive,#86')")
    stopIfSqlNotOK(session, "insert into customer values(6922,'Mrs','Augusta','Mcmahon','13036','303 Hickory Drive,#174')")
    stopIfSqlNotOK(session, "insert into customer values(6923,'Mr','Thomas','Lott','20653','71 Ninth Square,#15')")
    stopIfSqlNotOK(session, "insert into customer values(6924,'Mr','Jim','Boyd','23122','15 Cherry St.,#167')")
    stopIfSqlNotOK(session, "insert into customer values(6925,'Mr','Enrique','Ashley','78480','381 College Boulevard,#113')")
    stopIfSqlNotOK(session, "insert into customer values(6926,'Mrs','Betty','Dixon','04770','210 River St.,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6927,'Mrs','Sharon','Levy','72131','428 View Place,#153')")
    stopIfSqlNotOK(session, "insert into customer values(6928,'Mr','Jose','Moore','68850','331 Ridge Avenue,#149')")
    stopIfSqlNotOK(session, "insert into customer values(6929,'Mr','Lloyd','Brown','79376','244 Fourteenth St.,#174')")
    stopIfSqlNotOK(session, "insert into customer values(6930,'Mr','Ian','Johnson','77358','271 Hillcrest Boulevard,#159')")
    stopIfSqlNotOK(session, "insert into customer values(6931,'Mrs','Sandra','Wilson','76631','167 Lakeview Square,#111')")
    stopIfSqlNotOK(session, "insert into customer values(6932,'Mr','Robert','Davis','75475','145 Taylor Road,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6933,'Mrs','Sandra','Diaz','79036','272 Chestnut Lane,#125')")
    stopIfSqlNotOK(session, "insert into customer values(6934,'Mr','Lester','Gould','21654','297 Williams Boulevard,#148')")
    stopIfSqlNotOK(session, "insert into customer values(6935,'Mrs','Jennifer','Johnson','75147','352 Madison Lane,#28')")
    stopIfSqlNotOK(session, "insert into customer values(6936,'Mrs','Jennifer','Williams','77442','115 Madison Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(6937,'Mr','Isaac','Johnson','31734','419 Laurel Road,#36')")
    stopIfSqlNotOK(session, "insert into customer values(6938,'Mrs','Barbara','Fletcher','65714','225 Third Ave,#71')")
    stopIfSqlNotOK(session, "insert into customer values(6939,'Mr','Erik','Hebert','77512','41 Green Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(6940,'Mrs','Sandra','Davis','76462','163 Franklin Drive,#24')")
    stopIfSqlNotOK(session, "insert into customer values(6941,'Mr','Richard','Jones','77598','178 Seventh Drive,#144')")
    stopIfSqlNotOK(session, "insert into customer values(6942,'Mr','Walter','Smith','79343','347 Ash Road,#38')")
    stopIfSqlNotOK(session, "insert into customer values(6943,'Mrs','Barbara','Johnson','79380','149 Spring Place,#57')")
    stopIfSqlNotOK(session, "insert into customer values(6944,'Mr','Michael','Stanley','76370','488 Highland Street,#88')")
    stopIfSqlNotOK(session, "insert into customer values(6945,'Mr','Michael','Harrison','40013','396 Central Walk,#105')")
    stopIfSqlNotOK(session, "insert into customer values(6946,'Mrs','Dorothy','Hyde','77238','410 Hickory Road,#64')")
    stopIfSqlNotOK(session, "insert into customer values(6947,'Mr','Clinton','Miller','76140','44 Johnson Street,#184')")
    stopIfSqlNotOK(session, "insert into customer values(6948,'Mr','William','Moore','79835','328 Chestnut Lane,#146')")
    stopIfSqlNotOK(session, "insert into customer values(6949,'Mr','Roberto','Smith','76456','177 Fourth Walk,#16')")
    stopIfSqlNotOK(session, "insert into customer values(6950,'Mrs','Elisabeth','Williams','76067','83 Jackson Place,#19')")
    stopIfSqlNotOK(session, "insert into customer values(6951,'Mr','Charles','Baker','91778','201 Meadow St.,#29')")
    stopIfSqlNotOK(session, "insert into customer values(6952,'Mr','Robert','Jones','05669','409 Miller Square,#47')")
    stopIfSqlNotOK(session, "insert into customer values(6953,'Mr','Robert','Johnson','77326','12 Twelfth Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(6954,'Mr','Julio','Jones','78548','202 Seventh Avenue,#100')")
    stopIfSqlNotOK(session, "insert into customer values(6955,'Mr','Thomas','Davis','85242','187 Madison Walk,#157')")
    stopIfSqlNotOK(session, "insert into customer values(6956,'Mrs','Jennifer','Johnson','79258','34 Franklin Blvd,#66')")
    stopIfSqlNotOK(session, "insert into customer values(6957,'Mrs','Bethany','Preston','76579','85 Fifth Lane,#187')")
    stopIfSqlNotOK(session, "insert into customer values(6958,'Mr','Robert','Wilson','77661','300 Dogwood St.,#13')")
    stopIfSqlNotOK(session, "insert into customer values(6959,'Mr','Armando','Johnson','67513','139 Central Square,#55')")
    stopIfSqlNotOK(session, "insert into customer values(6960,'Mr','Roger','Johnson','76934','454 Valley Blvd,#114')")
    stopIfSqlNotOK(session, "insert into customer values(6961,'Mr','Michael','Dotson','77429','250 Seventh Walk,#61')")
    stopIfSqlNotOK(session, "insert into customer values(6962,'Mr','John','Robles','76022','314 Fifteenth Place,#117')")
    stopIfSqlNotOK(session, "insert into customer values(6963,'Mr','Tyler','Moore','77411','272 View Lane,#68')")
    stopIfSqlNotOK(session, "insert into customer values(6964,'Mrs','Carol','Freeman','76854','369 Laurel Walk,#108')")
    stopIfSqlNotOK(session, "insert into customer values(6965,'Mrs','Gretchen','Mckee','79019','290 Meadow Drive,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6966,'Mrs','Jennifer','Shelton','27839','92 Lee Blvd,#45')")
    stopIfSqlNotOK(session, "insert into customer values(6967,'Mr','Charles','Wilson','32352','305 Eleventh Parkway,#102')")
    stopIfSqlNotOK(session, "insert into customer values(6968,'Mr','Guy','Moore','75158','325 Miller Walk,#195')")
    stopIfSqlNotOK(session, "insert into customer values(6969,'Mr','Clarence','Ballard','76862','57 Hillcrest Blvd,#17')")
    stopIfSqlNotOK(session, "insert into customer values(6970,'Mr','Edgar','Moore','79779','187 Meadow Blvd,#39')")
    stopIfSqlNotOK(session, "insert into customer values(6971,'Mr','Charles','Williams','63841','426 Williams Road,#99')")
    stopIfSqlNotOK(session, "insert into customer values(6972,'Mr','Leroy','Smith','94171','133 Woodland Walk,#114')")
    stopIfSqlNotOK(session, "insert into customer values(6973,'Mr','William','Miller','65735','20 First Blvd,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6974,'Mr','Robert','Moore','77987','153 Locust St.,#72')")
    stopIfSqlNotOK(session, "insert into customer values(6975,'Mrs','Stacy','Lewis','18032','130 Chestnut Lane,#152')")
    stopIfSqlNotOK(session, "insert into customer values(6976,'Mr','Gregory','Buck','16159','229 Miller Lane,#94')")
    stopIfSqlNotOK(session, "insert into customer values(6977,'Mrs','Betty','Rivas','77582','19 Lincoln Parkway,#190')")
    stopIfSqlNotOK(session, "insert into customer values(6978,'Mr','Ivan','Castro','75933','252 Lakeview St.,#44')")
    stopIfSqlNotOK(session, "insert into customer values(6979,'Mrs','Patricia','Banks','19452','71 Cherry Lane,#80')")
    stopIfSqlNotOK(session, "insert into customer values(6980,'Mrs','Ella','Johnson','78338','8 First Blvd,#79')")
    stopIfSqlNotOK(session, "insert into customer values(6981,'Mr','John','Jackson','62832','337 Mill Avenue,#163')")
    stopIfSqlNotOK(session, "insert into customer values(6982,'Mrs','Monique','Smith','63430','478 Highland Square,#118')")
    stopIfSqlNotOK(session, "insert into customer values(6983,'Mrs','Janice','Miller','78769','221 Forest Parkway,#164')")
    stopIfSqlNotOK(session, "insert into customer values(6984,'Mrs','Jennifer','Foster','69151','399 Sunset Square,#85')")
    stopIfSqlNotOK(session, "insert into customer values(6985,'Mr','Roberto','Avila','77582','89 Second St.,#8')")
    stopIfSqlNotOK(session, "insert into customer values(6986,'Mrs','Dorothy','Davis','87006','379 Jefferson Street,#150')")
    stopIfSqlNotOK(session, "insert into customer values(6987,'Mr','Joseph','Juarez','77880','461 Center Walk,#138')")
    stopIfSqlNotOK(session, "insert into customer values(6988,'Mrs','Jennifer','Miller','76855','36 Fifth Lane,#196')")
    stopIfSqlNotOK(session, "insert into customer values(6989,'Mrs','Patricia','Davis','78161','300 Fifth Street,#109')")
    stopIfSqlNotOK(session, "insert into customer values(6990,'Mrs','Corina','Moore','79032','482 Seventh Parkway,#106')")
    stopIfSqlNotOK(session, "insert into customer values(6991,'Mrs','Patricia','Taylor','76468','491 College Parkway,#120')")
    stopIfSqlNotOK(session, "insert into customer values(6992,'Mrs','Barbara','Marks','79755','444 Adams St.,#50')")
    stopIfSqlNotOK(session, "insert into customer values(6993,'Mrs','Susan','Hurst','71307','385 Davis Ave,#128')")
    stopIfSqlNotOK(session, "insert into customer values(6994,'Mr','Nicholas','Hoffman','74637','115 Chestnut Avenue,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6995,'Mr','Victor','Wallace','76007','444 Davis Ave,#7')")
    stopIfSqlNotOK(session, "insert into customer values(6996,'Mrs','Marcia','Bradley','85359','304 Dogwood Ave,#37')")
    stopIfSqlNotOK(session, "insert into customer values(6997,'Mr','Herman','Mercado','51049','95 Taylor Drive,#91')")
    stopIfSqlNotOK(session, "insert into customer values(6998,'Mrs','Sharon','Le','75008','135 Thirteenth Road,#112')")
    stopIfSqlNotOK(session, "insert into customer values(6999,'Mr','Charles','Smith','78946','56 Fifth Lane,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7000,'Mrs','Robert','Moore','76627','45 Hickory Drive,#135')")
    stopIfSqlNotOK(session, "insert into customer values(7001,'Mr','Calvin','Johnson','68850','74 Center St.,#138')")
    stopIfSqlNotOK(session, "insert into customer values(7002,'Mrs','Nancy','Howe','77640','417 Main Blvd,#69')")
    stopIfSqlNotOK(session, "insert into customer values(7003,'Mrs','Jennifer','Reid','75903','92 Green Road,#151')")
    stopIfSqlNotOK(session, "insert into customer values(7004,'Mrs','Carol','Moore','79958','255 Hickory Boulevard,#28')")
    stopIfSqlNotOK(session, "insert into customer values(7005,'Mr','Terrance','Johnson','78601','253 Fourth St.,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7006,'Mr','Phillip','Mcdowell','75694','275 Hickory Blvd,#66')")
    stopIfSqlNotOK(session, "insert into customer values(7007,'Mrs','Sandra','Williams','75573','93 Laurel Ave,#170')")
    stopIfSqlNotOK(session, "insert into customer values(7008,'Mrs','Kari','Mayo','78383','20 Railroad Road,#176')")
    stopIfSqlNotOK(session, "insert into customer values(7009,'Mr','William','Davis','78847','33 Park Square,#151')")
    stopIfSqlNotOK(session, "insert into customer values(7010,'Mr','William','Terry','24884','459 Valley Walk,#94')")
    stopIfSqlNotOK(session, "insert into customer values(7011,'Mr','Lawrence','Dennis','76055','115 Green Parkway,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7012,'Mrs','Karina','Moore','76855','338 Green Street,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7013,'Mrs','Ella','Hines','77566','32 College Blvd,#118')")
    stopIfSqlNotOK(session, "insert into customer values(7014,'Mrs','Leila','Pena','77375','110 Davis Lane,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7015,'Mrs','Jody','Taylor','35648','315 Lee Road,#165')")
    stopIfSqlNotOK(session, "insert into customer values(7016,'Mrs','Fern','Pate','78061','176 Hickory Drive,#126')")
    stopIfSqlNotOK(session, "insert into customer values(7017,'Mrs','Nancy','Jones','77598','234 Chestnut Square,#4')")
    stopIfSqlNotOK(session, "insert into customer values(7018,'Mr','Michael','Brown','24450','3 West Street,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7019,'Mrs','Rosemary','Day','94930','476 East Lane,#77')")
    stopIfSqlNotOK(session, "insert into customer values(7020,'Mrs','Faith','Kerr','94960','453 Jefferson Parkway,#133')")
    stopIfSqlNotOK(session, "insert into customer values(7021,'Mrs','Marion','Estrada','46534','107 Lake Boulevard,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7022,'Mr','Byron','Smith','75172','180 Willow Road,#161')")
    stopIfSqlNotOK(session, "insert into customer values(7023,'Mrs','Barbara','Bonner','79504','385 Jackson Road,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7024,'Mrs','Maryellen','Brown','22334','165 Third Blvd,#173')")
    stopIfSqlNotOK(session, "insert into customer values(7025,'Mrs','Hollie','Wise','06781','90 Fourth Walk,#191')")
    stopIfSqlNotOK(session, "insert into customer values(7026,'Mrs','Marilyn','Jones','79772','364 Dogwood Avenue,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7027,'Mrs','Sandra','Leon','79331','12 Cherry Place,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7028,'Mrs','Trina','Smith','77429','321 Sunset Boulevard,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7029,'Mrs','Sandra','Miller','52254','452 Adams Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(7030,'Mrs','Diann','Taylor','92253','343 Pine Avenue,#132')")
    stopIfSqlNotOK(session, "insert into customer values(7031,'Mrs','Susan','Jones','77983','300 Lee Lane,#145')")
    stopIfSqlNotOK(session, "insert into customer values(7032,'Mr','Matthew','Abbott','76527','79 Birch Drive,#30')")
    stopIfSqlNotOK(session, "insert into customer values(7033,'Mrs','Dorothy','Williams','76272','82 Woodland Square,#32')")
    stopIfSqlNotOK(session, "insert into customer values(7034,'Mrs','Stacie','Miller','05154','269 Sycamore Walk,#167')")
    stopIfSqlNotOK(session, "insert into customer values(7035,'Mrs','Nancy','Smith','75660','196 Birch Walk,#8')")
    stopIfSqlNotOK(session, "insert into customer values(7036,'Mr','Lester','Hobbs','79235','187 Birch Boulevard,#124')")
    stopIfSqlNotOK(session, "insert into customer values(7037,'Mr','Claude','Miller','76234','30 Seventh Parkway,#138')")
    stopIfSqlNotOK(session, "insert into customer values(7038,'Mrs','Patricia','Campos','77626','314 Lake Ave,#29')")
    stopIfSqlNotOK(session, "insert into customer values(7039,'Mr','Thomas','Williams','78061','286 Dogwood Avenue,#158')")
    stopIfSqlNotOK(session, "insert into customer values(7040,'Mrs','Nancy','Martin','02338','79 Oak Blvd,#53')")
    stopIfSqlNotOK(session, "insert into customer values(7041,'Mr','Francisco','Johnson','75865','494 Spruce St.,#164')")
    stopIfSqlNotOK(session, "insert into customer values(7042,'Mrs','Nancy','Williams','37902','366 Lakeview Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7043,'Mr','Charles','Smith','78961','88 Park Drive,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7044,'Mr','Richard','Roth','77962','406 Davis Drive,#38')")
    stopIfSqlNotOK(session, "insert into customer values(7045,'Mr','David','Caldwell','93140','387 Fourth Road,#129')")
    stopIfSqlNotOK(session, "insert into customer values(7046,'Mrs','Althea','Mckinney','78005','298 East Street,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7047,'Mrs','Sharon','Keith','78380','110 Madison Walk,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7048,'Mr','Joseph','Tucker','76634','108 Eighth Avenue,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7049,'Mrs','Jennifer','Williams','79731','151 Spruce Avenue,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7050,'Mr','Phillip','Williams','75011','373 Forest Lane,#171')")
    stopIfSqlNotOK(session, "insert into customer values(7051,'Mrs','Nancy','Davis','76268','325 Seventh Avenue,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7052,'Mrs','Nancy','Davis','00651','200 Cherry St.,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7053,'Mr','David','Payne','77850','146 Maple Street,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7054,'Mrs','Jennifer','Jacobson','95543','340 Taylor Drive,#9')")
    stopIfSqlNotOK(session, "insert into customer values(7055,'Mr','David','Brown','11762','380 Washington Avenue,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7056,'Mrs','Susan','Carlson','75762','185 South Square,#35')")
    stopIfSqlNotOK(session, "insert into customer values(7057,'Mr','Jared','Smith','76828','248 Locust Boulevard,#146')")
    stopIfSqlNotOK(session, "insert into customer values(7058,'Mrs','Jennifer','Brown','51111','174 Franklin Walk,#126')")
    stopIfSqlNotOK(session, "insert into customer values(7059,'Mr','James','Duke','78064','95 Lake Lane,#16')")
    stopIfSqlNotOK(session, "insert into customer values(7060,'Mr','James','Jones','85051','89 Dogwood Ave,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7061,'Mrs','Angelica','Smith','77534','81 Madison Street,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7062,'Mrs','Patricia','Williams','79368','208 Sunset Street,#162')")
    stopIfSqlNotOK(session, "insert into customer values(7063,'Mrs','Bertie','Dillard','60488','34 North Place,#65')")
    stopIfSqlNotOK(session, "insert into customer values(7064,'Mr','Harvey','Frazier','79968','168 Locust St.,#48')")
    stopIfSqlNotOK(session, "insert into customer values(7065,'Mr','Thomas','Jones','76844','383 Hill Walk,#129')")
    stopIfSqlNotOK(session, "insert into customer values(7066,'Mrs','Betty','Smith','78245','445 Sixth Lane,#175')")
    stopIfSqlNotOK(session, "insert into customer values(7067,'Mr','Ernest','Wilson','78017','130 Thirteenth Parkway,#120')")
    stopIfSqlNotOK(session, "insert into customer values(7068,'Mrs','Elvia','Hooper','27839','98 Jefferson Avenue,#84')")
    stopIfSqlNotOK(session, "insert into customer values(7069,'Mrs','Nancy','Moore','76054','183 Fourth Blvd,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7070,'Mrs','Betty','Davis','76845','370 Central Ave,#186')")
    stopIfSqlNotOK(session, "insert into customer values(7071,'Mrs','Betty','Wilson','76476','396 Meadow Blvd,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7072,'Mrs','Glenda','Smith','78543','31 Fourteenth Square,#125')")
    stopIfSqlNotOK(session, "insert into customer values(7073,'Mr','Javier','Vinson','78614','347 Spruce Street,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7074,'Mrs','Nora','Taylor','79699','194 River St.,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7075,'Mrs','Serena','Johnson','75078','288 Lincoln Lane,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7076,'Mrs','Tameka','Jones','78164','386 River Street,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7077,'Mrs','Nancy','Brown','75496','425 Miller Square,#92')")
    stopIfSqlNotOK(session, "insert into customer values(7078,'Mr','Jerry','Carroll','19341','471 Center Avenue,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7079,'Mrs','Jennifer','Donovan','10178','462 Second Avenue,#158')")
    stopIfSqlNotOK(session, "insert into customer values(7080,'Mr','Dave','English','79382','27 Woodland Road,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7081,'Mr','Jesse','Johnson','77586','119 Sunset Road,#134')")
    stopIfSqlNotOK(session, "insert into customer values(7082,'Mr','William','Williams','75138','3 Green Blvd,#173')")
    stopIfSqlNotOK(session, "insert into customer values(7083,'Mrs','Nancy','Shields','75414','492 Spring Road,#133')")
    stopIfSqlNotOK(session, "insert into customer values(7084,'Mrs','Earline','Gregory','90101','218 Fourteenth Street,#149')")
    stopIfSqlNotOK(session, "insert into customer values(7085,'Mr','James','Dixon','76850','264 Church Avenue,#187')")
    stopIfSqlNotOK(session, "insert into customer values(7086,'Mrs','Barbara','Price','87567','284 Locust Square,#90')")
    stopIfSqlNotOK(session, "insert into customer values(7087,'Mr','James','Rowe','78593','369 Ash Avenue,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7088,'Mrs','Joan','Moore','78564','367 Oak Street,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7089,'Mr','Nicholas','Williams','65534','153 Madison Blvd,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7090,'Mr','Matthew','Smith','79222','52 Fifth Street,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7091,'Mr','John','Odom','95955','51 Jefferson Street,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7092,'Mrs','Patricia','Potts','78942','344 Highland Boulevard,#146')")
    stopIfSqlNotOK(session, "insert into customer values(7093,'Mr','William','Taylor','37025','397 Elm Lane,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7094,'Mrs','Barbara','Williams','72820','353 River Parkway,#8')")
    stopIfSqlNotOK(session, "insert into customer values(7095,'Mrs','Marcy','Johnson','06262','134 Valley Drive,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7096,'Mr','Richard','Acosta','78343','72 Dogwood Place,#150')")
    stopIfSqlNotOK(session, "insert into customer values(7097,'Mrs','Carol','Walker','75946','203 Laurel Walk,#39')")
    stopIfSqlNotOK(session, "insert into customer values(7098,'Mrs','Jayne','Wilson','15740','377 Washington Lane,#179')")
    stopIfSqlNotOK(session, "insert into customer values(7099,'Mrs','Susan','Lang','19348','114 Taylor Road,#174')")
    stopIfSqlNotOK(session, "insert into customer values(7100,'Mrs','Patricia','Miller','85550','243 Eighth St.,#115')")
    stopIfSqlNotOK(session, "insert into customer values(7101,'Mrs','Elba','Williams','42036','279 Walnut Parkway,#158')")
    stopIfSqlNotOK(session, "insert into customer values(7102,'Mrs','Barbara','Smith','76799','202 Forest Road,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7103,'Mr','Raymond','Potts','78008','356 Johnson St.,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7104,'Mrs','Ellen','Hoover','94156','87 West Place,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7105,'Mrs','Sonia','Williams','75058','204 Pine Avenue,#163')")
    stopIfSqlNotOK(session, "insert into customer values(7106,'Mrs','Jennifer','Boyd','76872','267 Twelfth Road,#33')")
    stopIfSqlNotOK(session, "insert into customer values(7107,'Mr','Tyler','Perkins','77613','133 Hill Lane,#158')")
    stopIfSqlNotOK(session, "insert into customer values(7108,'Mrs','Ann','Johnson','16670','364 Birch Walk,#99')")
    stopIfSqlNotOK(session, "insert into customer values(7109,'Mrs','Annmarie','Pratt','79383','35 Fourteenth Drive,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7110,'Mrs','Dorothy','Houston','93255','500 Laurel Place,#43')")
    stopIfSqlNotOK(session, "insert into customer values(7111,'Mr','Charles','Haney','76475','189 Center Place,#94')")
    stopIfSqlNotOK(session, "insert into customer values(7112,'Mr','Richard','Davis','78652','36 Central Place,#157')")
    stopIfSqlNotOK(session, "insert into customer values(7113,'Mrs','Teri','Bates','77485','126 View Ave,#94')")
    stopIfSqlNotOK(session, "insert into customer values(7114,'Mrs','Gabriela','Mcguire','75448','342 First St.,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7115,'Mrs','Johanna','Velez','22737','20 Jefferson Boulevard,#58')")
    stopIfSqlNotOK(session, "insert into customer values(7116,'Mrs','Carol','Newton','59075','91 Chestnut St.,#43')")
    stopIfSqlNotOK(session, "insert into customer values(7117,'Mr','Tyrone','Moore','75636','94 Church Boulevard,#125')")
    stopIfSqlNotOK(session, "insert into customer values(7118,'Mrs','Marguerite','Miller','78881','100 Church Blvd,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7119,'Mrs','Barbara','Dunn','79098','68 Franklin Avenue,#40')")
    stopIfSqlNotOK(session, "insert into customer values(7120,'Mrs','Willa','Taylor','19538','339 Washington Drive,#97')")
    stopIfSqlNotOK(session, "insert into customer values(7121,'Mr','Charles','Lamb','79546','430 View Blvd,#37')")
    stopIfSqlNotOK(session, "insert into customer values(7122,'Mrs','Marla','Taylor','77830','15 Walnut Drive,#56')")
    stopIfSqlNotOK(session, "insert into customer values(7123,'Mr','John','Brown','06783','209 Broadway Street,#89')")
    stopIfSqlNotOK(session, "insert into customer values(7124,'Mr','Charles','Johnson','40524','113 Second Drive,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7125,'Mrs','Lorena','Smith','75756','425 Walnut Walk,#152')")
    stopIfSqlNotOK(session, "insert into customer values(7126,'Mr','Tyler','Williams','85069','2 Park Walk,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7127,'Mr','Kevin','Williams','87829','127 Center Avenue,#105')")
    stopIfSqlNotOK(session, "insert into customer values(7128,'Mr','Cody','Jones','79081','326 Ninth Walk,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7129,'Mr','Lee','Miller','37012','130 View Road,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7130,'Mrs','Sandra','Daugherty','18854','70 River Walk,#125')")
    stopIfSqlNotOK(session, "insert into customer values(7131,'Mrs','Adrienne','Valentine','36439','123 Sixth Lane,#107')")
    stopIfSqlNotOK(session, "insert into customer values(7132,'Mrs','Barbara','Calhoun','75146','15 Ninth Parkway,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7133,'Mrs','Carol','Davis','78107','147 Hill Place,#141')")
    stopIfSqlNotOK(session, "insert into customer values(7134,'Mrs','Patricia','Villarreal','75571','227 First Avenue,#182')")
    stopIfSqlNotOK(session, "insert into customer values(7135,'Mrs','Yolanda','Marquez','36026','466 Washington Ave,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7136,'Mr','Raymond','Cleveland','57335','225 Fourteenth Square,#134')")
    stopIfSqlNotOK(session, "insert into customer values(7137,'Mrs','Letitia','Brown','79735','129 Chestnut Drive,#117')")
    stopIfSqlNotOK(session, "insert into customer values(7138,'Mr','Robert','Kent','60601','52 Fifth Boulevard,#192')")
    stopIfSqlNotOK(session, "insert into customer values(7139,'Mr','Tyrone','Moore','15670','319 Chestnut Avenue,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7140,'Mrs','Betty','Miller','07440','216 Wilson Place,#139')")
    stopIfSqlNotOK(session, "insert into customer values(7141,'Mrs','Sharon','Small','77957','69 Davis Street,#43')")
    stopIfSqlNotOK(session, "insert into customer values(7142,'Mr','John','Jones','60102','359 Pine St.,#187')")
    stopIfSqlNotOK(session, "insert into customer values(7143,'Mr','Richard','Townsend','27233','5 Hickory Ave,#136')")
    stopIfSqlNotOK(session, "insert into customer values(7144,'Mr','Richard','Davis','49854','455 Maple Square,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7145,'Mr','John','Parker','78549','470 Davis Parkway,#138')")
    stopIfSqlNotOK(session, "insert into customer values(7146,'Mrs','Leah','Caldwell','00938','337 Maple Walk,#57')")
    stopIfSqlNotOK(session, "insert into customer values(7147,'Mr','James','Davidson','60018','482 Birch Parkway,#85')")
    stopIfSqlNotOK(session, "insert into customer values(7148,'Mrs','Freda','Savage','67476','170 Ridge Avenue,#81')")
    stopIfSqlNotOK(session, "insert into customer values(7149,'Mrs','Sandra','Smith','76937','172 Fourteenth Street,#192')")
    stopIfSqlNotOK(session, "insert into customer values(7150,'Mr','Dave','Fischer','07021','86 Woodland Blvd,#144')")
    stopIfSqlNotOK(session, "insert into customer values(7151,'Mr','Ronnie','Gutierrez','76364','421 Center Square,#27')")
    stopIfSqlNotOK(session, "insert into customer values(7152,'Mrs','Patsy','Holt','01808','151 Seventh Parkway,#129')")
    stopIfSqlNotOK(session, "insert into customer values(7153,'Mrs','Debora','Mullins','75117','334 Walnut Drive,#77')")
    stopIfSqlNotOK(session, "insert into customer values(7154,'Mrs','Madeleine','Wilson','01813','34 Wilson Drive,#181')")
    stopIfSqlNotOK(session, "insert into customer values(7155,'Mr','Brandon','Peterson','79364','56 Jackson Road,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7156,'Mrs','Francisca','Wilson','73949','369 Forest Road,#115')")
    stopIfSqlNotOK(session, "insert into customer values(7157,'Mrs','Rachael','Burton','97535','416 Laurel Walk,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7158,'Mr','Jeffery','Brown','87180','65 Hillcrest Parkway,#136')")
    stopIfSqlNotOK(session, "insert into customer values(7159,'Mr','Kevin','Smith','79567','154 Jefferson Place,#191')")
    stopIfSqlNotOK(session, "insert into customer values(7160,'Mrs','Patricia','Serrano','76350','151 Oak Ave,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7161,'Mr','Robert','Vaughn','61448','325 Woodland Ave,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7162,'Mrs','Rachelle','Kramer','15767','300 Fourteenth Drive,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7163,'Mrs','Nancy','Brown','77277','194 Locust Parkway,#93')")
    stopIfSqlNotOK(session, "insert into customer values(7164,'Mr','Charles','Wilson','79377','493 East Lane,#30')")
    stopIfSqlNotOK(session, "insert into customer values(7165,'Mr','Kirk','Moore','77479','70 Jefferson Street,#115')")
    stopIfSqlNotOK(session, "insert into customer values(7166,'Mr','John','Ramirez','77863','500 Johnson Boulevard,#126')")
    stopIfSqlNotOK(session, "insert into customer values(7167,'Mr','William','Johnson','98376','281 Hill Parkway,#115')")
    stopIfSqlNotOK(session, "insert into customer values(7168,'Mr','Richard','Brown','75439','5 Church Boulevard,#135')")
    stopIfSqlNotOK(session, "insert into customer values(7169,'Mrs','Sharon','Cross','75359','369 Mill Ave,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7170,'Mrs','Grace','Hammond','87510','390 Williams Avenue,#171')")
    stopIfSqlNotOK(session, "insert into customer values(7171,'Mrs','Charlene','Johnson','79329','495 College Street,#113')")
    stopIfSqlNotOK(session, "insert into customer values(7172,'Mr','Joseph','Johnson','76060','320 Highland Road,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7173,'Mr','Charles','Bennett','75667','186 Tenth Place,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7174,'Mrs','Claire','Moore','79077','129 College Parkway,#196')")
    stopIfSqlNotOK(session, "insert into customer values(7175,'Mr','Joseph','Miller','76708','322 Sycamore Street,#148')")
    stopIfSqlNotOK(session, "insert into customer values(7176,'Mrs','Milagros','Cleveland','93255','250 Second Ave,#44')")
    stopIfSqlNotOK(session, "insert into customer values(7177,'Mr','Peter','Davis','37902','469 Johnson Road,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7178,'Mr','Randall','Carpenter','77575','121 Elm Lane,#139')")
    stopIfSqlNotOK(session, "insert into customer values(7179,'Mrs','Betty','Shields','77664','62 Oak Ave,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7180,'Mr','Michael','Davis','78379','56 Jackson Road,#117')")
    stopIfSqlNotOK(session, "insert into customer values(7181,'Mr','Raymond','Davis','76466','301 Willow St.,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7182,'Mrs','Carol','Moody','76433','339 South Square,#164')")
    stopIfSqlNotOK(session, "insert into customer values(7183,'Mrs','Nancy','Wilson','78652','119 Smith Avenue,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7184,'Mr','Charles','Rivera','79540','117 Tenth Street,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7185,'Mrs','Jennifer','Smith','78570','490 Poplar Street,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7186,'Mrs','Angelia','Holt','60465','475 View Square,#70')")
    stopIfSqlNotOK(session, "insert into customer values(7187,'Mr','Thomas','Johnson','75790','381 Fourteenth Road,#59')")
    stopIfSqlNotOK(session, "insert into customer values(7188,'Mrs','Barbara','Mack','78523','408 Pine Place,#71')")
    stopIfSqlNotOK(session, "insert into customer values(7189,'Mrs','Nancy','Johnson','76629','87 East St.,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7190,'Mr','William','Stafford','79853','276 Eleventh Parkway,#114')")
    stopIfSqlNotOK(session, "insert into customer values(7191,'Mr','Robert','Good','27839','302 Hill Parkway,#160')")
    stopIfSqlNotOK(session, "insert into customer values(7192,'Mrs','Dorothy','Roth','81250','271 Ash Road,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7193,'Mrs','Virgie','Anderson','17350','332 Franklin Street,#200')")
    stopIfSqlNotOK(session, "insert into customer values(7194,'Mr','Sidney','Hayes','75058','78 Poplar Parkway,#16')")
    stopIfSqlNotOK(session, "insert into customer values(7195,'Mr','Randall','Blake','67513','194 Valley St.,#29')")
    stopIfSqlNotOK(session, "insert into customer values(7196,'Mr','Gabriel','Smith','77282','319 Adams Road,#154')")
    stopIfSqlNotOK(session, "insert into customer values(7197,'Mrs','Holly','Durham','79256','81 Johnson Blvd,#114')")
    stopIfSqlNotOK(session, "insert into customer values(7198,'Mrs','Tamera','Moore','87120','151 Sunset Square,#159')")
    stopIfSqlNotOK(session, "insert into customer values(7199,'Mr','Robert','Davis','02171','414 Forest Place,#89')")
    stopIfSqlNotOK(session, "insert into customer values(7200,'Mrs','Barbara','Gill','46035','269 Smith Lane,#155')")
    stopIfSqlNotOK(session, "insert into customer values(7201,'Mrs','Barbara','Cummings','79312','281 Ash Avenue,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7202,'Mr','Brian','Williams','75138','208 Church Square,#27')")
    stopIfSqlNotOK(session, "insert into customer values(7203,'Mrs','Concepcion','Nolan','79749','385 Locust St.,#28')")
    stopIfSqlNotOK(session, "insert into customer values(7204,'Mr','Lawrence','Duffy','70633','393 Dogwood Boulevard,#10')")
    stopIfSqlNotOK(session, "insert into customer values(7205,'Mr','Carlos','Moore','78590','187 Sixth Boulevard,#50')")
    stopIfSqlNotOK(session, "insert into customer values(7206,'Mrs','Freda','Brown','76824','81 Center Road,#54')")
    stopIfSqlNotOK(session, "insert into customer values(7207,'Mrs','Dianna','Davis','88230','218 Tenth Blvd,#50')")
    stopIfSqlNotOK(session, "insert into customer values(7208,'Mr','Richard','Harvey','41764','387 Locust Square,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7209,'Mr','William','Carney','77660','188 Ash Drive,#125')")
    stopIfSqlNotOK(session, "insert into customer values(7210,'Mrs','Angeline','Miller','76446','310 Hill Road,#161')")
    stopIfSqlNotOK(session, "insert into customer values(7211,'Mrs','Latoya','Davis','78631','51 Eighth Place,#70')")
    stopIfSqlNotOK(session, "insert into customer values(7212,'Mr','James','Preston','85346','361 Valley Avenue,#193')")
    stopIfSqlNotOK(session, "insert into customer values(7213,'Mrs','Louisa','Wilson','79752','238 Chestnut Avenue,#149')")
    stopIfSqlNotOK(session, "insert into customer values(7214,'Mr','Michael','Moore','23141','386 Franklin Ave,#98')")
    stopIfSqlNotOK(session, "insert into customer values(7215,'Mr','Henry','Barron','75862','182 Twelfth Walk,#184')")
    stopIfSqlNotOK(session, "insert into customer values(7216,'Mrs','Carol','Moore','78568','153 Mill Walk,#114')")
    stopIfSqlNotOK(session, "insert into customer values(7217,'Mr','Charles','Stevens','41127','425 Williams Boulevard,#129')")
    stopIfSqlNotOK(session, "insert into customer values(7218,'Mr','Robert','Jones','95045','123 Forest Walk,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7219,'Mrs','Patricia','Frazier','78012','492 Sixth Boulevard,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7220,'Mr','Maurice','Miller','06064','197 South Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7221,'Mrs','April','Valenzuela','75126','322 Chestnut Place,#35')")
    stopIfSqlNotOK(session, "insert into customer values(7222,'Mr','Jimmy','Whitaker','76689','311 Dogwood Ave,#149')")
    stopIfSqlNotOK(session, "insert into customer values(7223,'Mrs','Jennifer','Wilson','40544','4 Third Drive,#83')")
    stopIfSqlNotOK(session, "insert into customer values(7224,'Mr','John','Brown','78053','53 Lakeview Drive,#90')")
    stopIfSqlNotOK(session, "insert into customer values(7225,'Mrs','Justine','Burch','75438','319 Church Boulevard,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7226,'Mr','Clarence','Mercer','31637','437 Hillcrest Drive,#186')")
    stopIfSqlNotOK(session, "insert into customer values(7227,'Mr','Brent','Gibbs','76505','248 Lee Street,#196')")
    stopIfSqlNotOK(session, "insert into customer values(7228,'Mr','Jerry','Ayers','76862','270 Railroad Place,#102')")
    stopIfSqlNotOK(session, "insert into customer values(7229,'Mrs','Summer','Frye','79079','332 Tenth Walk,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7230,'Mr','Gene','Johnson','77836','221 Ninth St.,#105')")
    stopIfSqlNotOK(session, "insert into customer values(7231,'Mr','David','Hinton','19093','336 Dogwood Ave,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7232,'Mrs','Karina','Miller','77985','323 Park Road,#43')")
    stopIfSqlNotOK(session, "insert into customer values(7233,'Mrs','Berta','Brown','78675','440 River Street,#147')")
    stopIfSqlNotOK(session, "insert into customer values(7234,'Mr','Daryl','Jones','79058','244 Hillcrest Avenue,#49')")
    stopIfSqlNotOK(session, "insert into customer values(7235,'Mr','Robert','Moore','75569','289 Spring Drive,#69')")
    stopIfSqlNotOK(session, "insert into customer values(7236,'Mr','Ricky','Bowen','77631','186 Smith Boulevard,#144')")
    stopIfSqlNotOK(session, "insert into customer values(7237,'Mr','Miguel','Blankenship','75070','272 Highland Drive,#198')")
    stopIfSqlNotOK(session, "insert into customer values(7238,'Mrs','Dorothy','Williams','33925','204 Taylor Place,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7239,'Mr','David','Williams','27526','402 Miller Place,#50')")
    stopIfSqlNotOK(session, "insert into customer values(7240,'Mr','Michael','Mullins','78634','258 Miller Avenue,#16')")
    stopIfSqlNotOK(session, "insert into customer values(7241,'Mrs','Patricia','Davis','39044','418 Spruce Walk,#109')")
    stopIfSqlNotOK(session, "insert into customer values(7242,'Mr','Morris','Johnson','76044','103 Walnut Boulevard,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7243,'Mr','Thomas','Talley','92070','166 Ash Drive,#124')")
    stopIfSqlNotOK(session, "insert into customer values(7244,'Mr','Thomas','Jones','76030','456 Williams Walk,#52')")
    stopIfSqlNotOK(session, "insert into customer values(7245,'Mrs','Amy','Johnson','79755','83 Jackson Lane,#72')")
    stopIfSqlNotOK(session, "insert into customer values(7246,'Mrs','Imelda','Rosario','71479','57 Forest Avenue,#184')")
    stopIfSqlNotOK(session, "insert into customer values(7247,'Mr','Ricky','Miranda','28784','44 Fourteenth Walk,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7248,'Mr','Larry','Flowers','79034','393 Washington Parkway,#163')")
    stopIfSqlNotOK(session, "insert into customer values(7249,'Mr','Melvin','Shaw','76685','225 Pine Street,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7250,'Mrs','Sandra','Brown','45727','489 Spring Ave,#113')")
    stopIfSqlNotOK(session, "insert into customer values(7251,'Mr','Charles','Davis','47138','292 Birch Parkway,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7252,'Mr','David','Jones','20019','321 Sycamore Boulevard,#3')")
    stopIfSqlNotOK(session, "insert into customer values(7253,'Mrs','Sharon','Maldonado','75960','416 Lee Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7254,'Mr','Joseph','Smith','65282','348 Mill Square,#33')")
    stopIfSqlNotOK(session, "insert into customer values(7255,'Mrs','Barbara','Jones','49720','140 Hillcrest Boulevard,#145')")
    stopIfSqlNotOK(session, "insert into customer values(7256,'Mrs','Carol','Johnson','13436','210 Washington Lane,#14')")
    stopIfSqlNotOK(session, "insert into customer values(7257,'Mrs','Florine','Smith','79073','305 Cedar Road,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7258,'Mr','Michael','Moore','78343','309 Hickory Street,#24')")
    stopIfSqlNotOK(session, "insert into customer values(7259,'Mr','James','Porter','76878','424 Wilson St.,#105')")
    stopIfSqlNotOK(session, "insert into customer values(7260,'Mr','Julio','Hunt','95142','261 Spruce Boulevard,#56')")
    stopIfSqlNotOK(session, "insert into customer values(7261,'Mrs','Jennifer','Peterson','75394','358 River St.,#120')")
    stopIfSqlNotOK(session, "insert into customer values(7262,'Mr','James','Rios','02169','337 Davis Square,#52')")
    stopIfSqlNotOK(session, "insert into customer values(7263,'Mr','Robert','Wade','76252','208 Madison Walk,#116')")
    stopIfSqlNotOK(session, "insert into customer values(7264,'Mrs','Dorothy','Moore','78377','283 Jackson St.,#165')")
    stopIfSqlNotOK(session, "insert into customer values(7265,'Mrs','Tommie','Moore','78516','131 Main Walk,#61')")
    stopIfSqlNotOK(session, "insert into customer values(7266,'Mrs','Allie','Moore','12148','207 Fourth Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(7267,'Mrs','Rena','Everett','79010','382 Davis Blvd,#37')")
    stopIfSqlNotOK(session, "insert into customer values(7268,'Mrs','Sandra','Smith','75960','49 Ridge Place,#110')")
    stopIfSqlNotOK(session, "insert into customer values(7269,'Mr','Ronnie','Wilson','76579','196 Lee Place,#10')")
    stopIfSqlNotOK(session, "insert into customer values(7270,'Mr','Joseph','Levy','78839','21 Hickory Drive,#174')")
    stopIfSqlNotOK(session, "insert into customer values(7271,'Mr','Randall','Cash','75068','221 Second Drive,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7272,'Mrs','Summer','Miller','37343','308 Hickory St.,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7273,'Mr','William','Jones','76370','336 East Boulevard,#194')")
    stopIfSqlNotOK(session, "insert into customer values(7274,'Mr','John','Taylor','77663','317 View Avenue,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7275,'Mrs','Leila','Puckett','63377','402 Tenth St.,#63')")
    stopIfSqlNotOK(session, "insert into customer values(7276,'Mr','Charles','Johnson','76671','357 Fourteenth Place,#30')")
    stopIfSqlNotOK(session, "insert into customer values(7277,'Mrs','Adrienne','Williams','76455','231 Walnut Parkway,#35')")
    stopIfSqlNotOK(session, "insert into customer values(7278,'Mr','Ivan','Cameron','75489','177 Center Blvd,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7279,'Mrs','Barbara','Cruz','75154','358 Central Boulevard,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7280,'Mr','Charles','Jones','79226','154 Green Ave,#143')")
    stopIfSqlNotOK(session, "insert into customer values(7281,'Mrs','Rosalind','Brady','78674','443 Broadway Ave,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7282,'Mrs','Sharon','Gardner','78670','119 Taylor Drive,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7283,'Mr','Billy','Brown','79324','362 Davis Place,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7284,'Mr','Ivan','Morris','85550','299 Green Place,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7285,'Mr','Nathaniel','Moore','76461','218 Locust Drive,#115')")
    stopIfSqlNotOK(session, "insert into customer values(7286,'Mrs','Sharon','Roach','78537','349 Church Avenue,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7287,'Mrs','Betty','Navarro','76940','109 Poplar St.,#200')")
    stopIfSqlNotOK(session, "insert into customer values(7288,'Mrs','Jennifer','Noel','76060','1 Jefferson Lane,#30')")
    stopIfSqlNotOK(session, "insert into customer values(7289,'Mr','Enrique','Shepherd','78072','135 Spring St.,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7290,'Mrs','Betty','Jarvis','21820','281 Green Walk,#43')")
    stopIfSqlNotOK(session, "insert into customer values(7291,'Mr','Michael','Moore','79734','37 Walnut Walk,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7292,'Mrs','Neva','Mays','77385','294 Washington Lane,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7293,'Mr','Joseph','Johnson','79788','128 Cherry Road,#31')")
    stopIfSqlNotOK(session, "insert into customer values(7294,'Mrs','Betty','Dejesus','78025','73 Oak Ave,#113')")
    stopIfSqlNotOK(session, "insert into customer values(7295,'Mr','Charles','Henson','76685','62 Poplar Parkway,#25')")
    stopIfSqlNotOK(session, "insert into customer values(7296,'Mrs','Ines','Moore','75637','362 College Drive,#163')")
    stopIfSqlNotOK(session, "insert into customer values(7297,'Mr','George','Stanton','76941','134 Center Ave,#147')")
    stopIfSqlNotOK(session, "insert into customer values(7298,'Mrs','Sandra','Williams','78609','296 Spruce Road,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7299,'Mr','Thomas','Brown','75966','188 Birch Square,#154')")
    stopIfSqlNotOK(session, "insert into customer values(7300,'Mrs','Betty','Forbes','75474','391 Lincoln Drive,#42')")
    stopIfSqlNotOK(session, "insert into customer values(7301,'Mrs','Mamie','Gregory','79744','116 Walnut Boulevard,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7302,'Mrs','Jennifer','Johnson','79178','238 Tenth Walk,#140')")
    stopIfSqlNotOK(session, "insert into customer values(7303,'Mrs','Hallie','Gibson','75641','389 East Road,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7304,'Mr','Robert','Huffman','77978','221 Chestnut Place,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7305,'Mrs','Barbara','Wilson','79376','105 Walnut St.,#18')")
    stopIfSqlNotOK(session, "insert into customer values(7306,'Mrs','Sandra','Wilson','75637','160 Spring Street,#4')")
    stopIfSqlNotOK(session, "insert into customer values(7307,'Mrs','Marla','Henderson','23122','140 Chestnut Boulevard,#33')")
    stopIfSqlNotOK(session, "insert into customer values(7308,'Mr','Duane','Johnson','87565','262 Lee Walk,#39')")
    stopIfSqlNotOK(session, "insert into customer values(7309,'Mr','James','Davis','84531','258 Fourteenth Walk,#150')")
    stopIfSqlNotOK(session, "insert into customer values(7310,'Mr','Robert','Branch','94023','269 Walnut Walk,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7311,'Mrs','Althea','Morton','15110','175 First Place,#52')")
    stopIfSqlNotOK(session, "insert into customer values(7312,'Mr','Marvin','Mann','76909','423 Fourteenth Drive,#158')")
    stopIfSqlNotOK(session, "insert into customer values(7313,'Mrs','Sandra','Taylor','76442','30 Park Ave,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7314,'Mrs','Christy','Hardy','93661','166 Fourth Parkway,#113')")
    stopIfSqlNotOK(session, "insert into customer values(7315,'Mrs','Patricia','Miller','78336','413 Mill Place,#64')")
    stopIfSqlNotOK(session, "insert into customer values(7316,'Mrs','Dorothy','Townsend','52228','172 North Lane,#148')")
    stopIfSqlNotOK(session, "insert into customer values(7317,'Mrs','Sharon','Johnson','76059','400 Center Blvd,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7318,'Mr','Michael','Justice','76931','358 Central St.,#36')")
    stopIfSqlNotOK(session, "insert into customer values(7319,'Mrs','Cassie','Smith','76667','20 Washington Lane,#153')")
    stopIfSqlNotOK(session, "insert into customer values(7320,'Mrs','June','Brown','79849','316 Woodland Street,#130')")
    stopIfSqlNotOK(session, "insert into customer values(7321,'Mrs','Tracey','Cain','75152','324 Tenth Drive,#25')")
    stopIfSqlNotOK(session, "insert into customer values(7322,'Mrs','Kenya','Robbins','76940','118 Sycamore Place,#4')")
    stopIfSqlNotOK(session, "insert into customer values(7323,'Mrs','Patricia','Moody','55332','220 Laurel Avenue,#53')")
    stopIfSqlNotOK(session, "insert into customer values(7324,'Mrs','Susan','Davis','78851','430 Forest Drive,#194')")
    stopIfSqlNotOK(session, "insert into customer values(7325,'Mrs','Constance','Miller','93440','186 Birch St.,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7326,'Mrs','Patricia','Johnson','62550','94 Twelfth Parkway,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7327,'Mrs','Nancy','Slater','77516','249 Davis Walk,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7328,'Mr','William','Jackson','77562','52 Ash St.,#148')")
    stopIfSqlNotOK(session, "insert into customer values(7329,'Mrs','Estela','Becker','57118','92 Lee Walk,#21')")
    stopIfSqlNotOK(session, "insert into customer values(7330,'Mrs','Jennifer','Williams','76350','181 Forest Lane,#136')")
    stopIfSqlNotOK(session, "insert into customer values(7331,'Mrs','Pearl','Bush','79327','409 Jefferson Avenue,#69')")
    stopIfSqlNotOK(session, "insert into customer values(7332,'Mr','John','Jones','15001','335 Locust Boulevard,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7333,'Mrs','Tameka','Wagner','79789','159 Lake Lane,#90')")
    stopIfSqlNotOK(session, "insert into customer values(7334,'Mr','Andy','Forbes','04257','380 Second Boulevard,#146')")
    stopIfSqlNotOK(session, "insert into customer values(7335,'Mr','Lloyd','Miller','76462','19 Lee Ave,#31')")
    stopIfSqlNotOK(session, "insert into customer values(7336,'Mr','Juan','Davis','94171','485 Franklin Avenue,#24')")
    stopIfSqlNotOK(session, "insert into customer values(7337,'Mr','Adrian','Davis','77385','6 Fifth Lane,#22')")
    stopIfSqlNotOK(session, "insert into customer values(7338,'Mr','William','Taylor','76299','179 Laurel Street,#39')")
    stopIfSqlNotOK(session, "insert into customer values(7339,'Mr','Michael','Solomon','78055','472 Sixth Square,#9')")
    stopIfSqlNotOK(session, "insert into customer values(7340,'Mrs','Corine','Maldonado','79556','493 Third Road,#144')")
    stopIfSqlNotOK(session, "insert into customer values(7341,'Mr','William','Farley','72358','234 River Boulevard,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7342,'Mr','Charles','Schultz','75468','122 Hickory Square,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7343,'Mrs','Carol','Johnson','76077','105 Eighth Road,#36')")
    stopIfSqlNotOK(session, "insert into customer values(7344,'Mr','Robert','Williams','78020','142 North Avenue,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7345,'Mrs','Barbara','Davis','78344','324 Adams St.,#42')")
    stopIfSqlNotOK(session, "insert into customer values(7346,'Mr','Thomas','Hart','33576','29 Fourth Square,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7347,'Mr','Danny','Olsen','13830','398 Church Ave,#167')")
    stopIfSqlNotOK(session, "insert into customer values(7348,'Mr','David','Smith','73668','124 First Square,#155')")
    stopIfSqlNotOK(session, "insert into customer values(7349,'Mr','Calvin','Dillard','76648','13 Church Ave,#155')")
    stopIfSqlNotOK(session, "insert into customer values(7350,'Mr','Michael','Moore','77284','464 Laurel St.,#99')")
    stopIfSqlNotOK(session, "insert into customer values(7351,'Mrs','Nelda','Hyde','36921','121 Woodland Drive,#101')")
    stopIfSqlNotOK(session, "insert into customer values(7352,'Mrs','Hester','Salinas','76664','48 Oak Square,#56')")
    stopIfSqlNotOK(session, "insert into customer values(7353,'Mrs','Susan','Smith','79719','265 Washington Ave,#183')")
    stopIfSqlNotOK(session, "insert into customer values(7354,'Mr','Joseph','Lindsey','79084','283 First Drive,#74')")
    stopIfSqlNotOK(session, "insert into customer values(7355,'Mr','Charles','Sharpe','75959','196 Fourth Avenue,#124')")
    stopIfSqlNotOK(session, "insert into customer values(7356,'Mrs','Carol','Taylor','79250','124 Main Avenue,#42')")
    stopIfSqlNotOK(session, "insert into customer values(7357,'Mr','Hector','Langley','77619','171 Eleventh Walk,#141')")
    stopIfSqlNotOK(session, "insert into customer values(7358,'Mrs','Barbara','Jones','50076','495 Mill Boulevard,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7359,'Mrs','Jayne','Kramer','79083','154 River Boulevard,#97')")
    stopIfSqlNotOK(session, "insert into customer values(7360,'Mrs','Nancy','Davis','78582','32 Chestnut Ave,#64')")
    stopIfSqlNotOK(session, "insert into customer values(7361,'Mrs','Kim','Moore','76474','330 Laurel Drive,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7362,'Mr','William','Williams','18979','342 Washington Avenue,#106')")
    stopIfSqlNotOK(session, "insert into customer values(7363,'Mr','John','Rich','76258','214 Madison Boulevard,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7364,'Mrs','Betty','Sykes','50420','90 Hill Lane,#120')")
    stopIfSqlNotOK(session, "insert into customer values(7365,'Mr','William','Taylor','76249','2 Washington Street,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7366,'Mrs','Mabel','Wilson','77299','123 Seventh Square,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7367,'Mr','Thomas','Taylor','26811','442 Sixth Street,#24')")
    stopIfSqlNotOK(session, "insert into customer values(7368,'Mrs','Sharon','Lynch','78835','199 Willow Avenue,#68')")
    stopIfSqlNotOK(session, "insert into customer values(7369,'Mr','Harry','Wilson','75068','123 Birch Drive,#175')")
    stopIfSqlNotOK(session, "insert into customer values(7370,'Mrs','Betty','Lambert','78617','123 Williams Street,#144')")
    stopIfSqlNotOK(session, "insert into customer values(7371,'Mr','David','Foley','01537','221 Sunset Drive,#127')")
    stopIfSqlNotOK(session, "insert into customer values(7372,'Mrs','Allison','Miller','77448','215 Sixth Square,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7373,'Mr','Robert','Smith','78938','481 Willow Street,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7374,'Mrs','Betty','Raymond','76150','468 Broadway Avenue,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7375,'Mrs','Sharon','Mcguire','71268','169 Third Avenue,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7376,'Mrs','Susan','Wilson','79854','128 Lakeview Ave,#22')")
    stopIfSqlNotOK(session, "insert into customer values(7377,'Mrs','Ursula','Baker','76670','6 Highland St.,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7378,'Mr','Javier','Bullock','78427','357 Spruce Avenue,#29')")
    stopIfSqlNotOK(session, "insert into customer values(7379,'Mr','David','Guerra','87140','233 Ash Avenue,#171')")
    stopIfSqlNotOK(session, "insert into customer values(7380,'Mrs','Susan','Boyle','78380','354 Elm Drive,#9')")
    stopIfSqlNotOK(session, "insert into customer values(7381,'Mrs','Rhea','Johnson','40103','142 Forest Street,#63')")
    stopIfSqlNotOK(session, "insert into customer values(7382,'Mrs','Eunice','Wilson','18441','359 Lakeview Street,#164')")
    stopIfSqlNotOK(session, "insert into customer values(7383,'Mrs','Flossie','Johnson','75792','367 South Street,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7384,'Mr','Andrew','Miller','75073','64 Adams Boulevard,#33')")
    stopIfSqlNotOK(session, "insert into customer values(7385,'Mrs','Sharon','Butler','75832','341 Spring Blvd,#74')")
    stopIfSqlNotOK(session, "insert into customer values(7386,'Mr','Ray','Brown','77275','25 Smith Street,#101')")
    stopIfSqlNotOK(session, "insert into customer values(7387,'Mrs','Barbara','Moore','48226','174 Willow Square,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7388,'Mr','Robert','Jones','12051','461 Eighth Ave,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7389,'Mrs','Betty','Davis','76234','84 Davis Square,#68')")
    stopIfSqlNotOK(session, "insert into customer values(7390,'Mrs','Dorothy','Davis','75416','469 Elm Street,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7391,'Mrs','Sharon','Camacho','76259','317 Central Place,#141')")
    stopIfSqlNotOK(session, "insert into customer values(7392,'Mrs','Jennifer','Woodward','92332','271 Johnson Walk,#31')")
    stopIfSqlNotOK(session, "insert into customer values(7393,'Mrs','Jennifer','Hebert','61753','283 Central Parkway,#95')")
    stopIfSqlNotOK(session, "insert into customer values(7394,'Mr','Thomas','Lee','76252','33 Second Place,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7395,'Mrs','Monique','Taylor','78016','458 Williams Drive,#159')")
    stopIfSqlNotOK(session, "insert into customer values(7396,'Mr','Thomas','Valentine','87053','432 Locust Street,#178')")
    stopIfSqlNotOK(session, "insert into customer values(7397,'Mr','Gilbert','Herman','00940','209 Seventh Walk,#163')")
    stopIfSqlNotOK(session, "insert into customer values(7398,'Mrs','Cora','Massey','71311','246 Green Road,#139')")
    stopIfSqlNotOK(session, "insert into customer values(7399,'Mr','Joe','Brown','90094','447 Sunset Boulevard,#186')")
    stopIfSqlNotOK(session, "insert into customer values(7400,'Mr','Charles','Smith','78359','407 Fourth Walk,#139')")
    stopIfSqlNotOK(session, "insert into customer values(7401,'Mr','Michael','Noel','77837','36 Fourteenth Road,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7402,'Mr','Jessie','Brown','76227','359 First Blvd,#149')")
    stopIfSqlNotOK(session, "insert into customer values(7403,'Mrs','Carol','Harrington','78115','116 Taylor Drive,#132')")
    stopIfSqlNotOK(session, "insert into customer values(7404,'Mr','Claude','Banks','78607','315 Mill Boulevard,#30')")
    stopIfSqlNotOK(session, "insert into customer values(7405,'Mrs','Wilda','Mcleod','79054','419 Smith St.,#192')")
    stopIfSqlNotOK(session, "insert into customer values(7406,'Mr','Byron','Miller','75310','278 Fifteenth St.,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7407,'Mrs','Sylvia','Reese','79357','458 Sunset Drive,#170')")
    stopIfSqlNotOK(session, "insert into customer values(7408,'Mr','William','Williams','31629','392 Tenth Boulevard,#127')")
    stopIfSqlNotOK(session, "insert into customer values(7409,'Mrs','Susan','Franks','76057','455 Park Lane,#16')")
    stopIfSqlNotOK(session, "insert into customer values(7410,'Mrs','Kerri','Jones','79553','401 Fifteenth Road,#11')")
    stopIfSqlNotOK(session, "insert into customer values(7411,'Mr','Willard','Clark','76909','193 Locust Ave,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7412,'Mr','Bill','Davis','79312','435 Ninth Boulevard,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7413,'Mrs','Carol','Moore','05669','431 College Ave,#196')")
    stopIfSqlNotOK(session, "insert into customer values(7414,'Mr','Charles','Burns','28703','274 Green Place,#61')")
    stopIfSqlNotOK(session, "insert into customer values(7415,'Mrs','Juliette','Griffith','76026','143 Hickory Street,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7416,'Mrs','Betty','Taylor','02338','342 Spruce Lane,#150')")
    stopIfSqlNotOK(session, "insert into customer values(7417,'Mr','Alfred','Mcneil','75631','162 Park Place,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7418,'Mr','Robert','Sullivan','45381','188 East Square,#93')")
    stopIfSqlNotOK(session, "insert into customer values(7419,'Mr','Scott','Harrison','78951','242 West Street,#28')")
    stopIfSqlNotOK(session, "insert into customer values(7420,'Mr','Michael','Jones','76505','464 Davis Parkway,#127')")
    stopIfSqlNotOK(session, "insert into customer values(7421,'Mr','Perry','Mccarthy','77367','184 Jefferson Road,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7422,'Mrs','Daphne','Horn','78635','175 Church Lane,#85')")
    stopIfSqlNotOK(session, "insert into customer values(7423,'Mr','Joseph','Smith','76526','413 Tenth Blvd,#130')")
    stopIfSqlNotOK(session, "insert into customer values(7424,'Mrs','Sandra','Sweet','76369','425 Davis Blvd,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7425,'Mr','David','Smith','27294','48 Forest Parkway,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7426,'Mrs','Letitia','Smith','78604','135 Oak Road,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7427,'Mrs','Willa','Arnold','78108','31 Railroad Avenue,#173')")
    stopIfSqlNotOK(session, "insert into customer values(7428,'Mr','Richard','Velasquez','62084','8 Fourth Ave,#99')")
    stopIfSqlNotOK(session, "insert into customer values(7429,'Mrs','Lora','Smith','79364','335 Main St.,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7430,'Mr','Mario','Davis','16912','145 Miller St.,#61')")
    stopIfSqlNotOK(session, "insert into customer values(7431,'Mr','David','Davis','95713','278 Wilson Walk,#47')")
    stopIfSqlNotOK(session, "insert into customer values(7432,'Mr','William','Randolph','76677','195 Ash Lane,#173')")
    stopIfSqlNotOK(session, "insert into customer values(7433,'Mr','Charles','Cochran','76951','240 Taylor St.,#141')")
    stopIfSqlNotOK(session, "insert into customer values(7434,'Mr','Curtis','Moore','29377','208 Hillcrest Walk,#176')")
    stopIfSqlNotOK(session, "insert into customer values(7435,'Mr','Elmer','Medina','75560','465 Adams Place,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7436,'Mrs','Francesca','Farley','78860','126 Sycamore Lane,#107')")
    stopIfSqlNotOK(session, "insert into customer values(7437,'Mrs','Enid','Taylor','79090','394 South Place,#44')")
    stopIfSqlNotOK(session, "insert into customer values(7438,'Mr','James','Serrano','77245','361 Fourteenth Road,#184')")
    stopIfSqlNotOK(session, "insert into customer values(7439,'Mr','Angel','Brown','75401','137 Smith Boulevard,#152')")
    stopIfSqlNotOK(session, "insert into customer values(7440,'Mr','Timothy','Leblanc','79042','211 Madison Walk,#155')")
    stopIfSqlNotOK(session, "insert into customer values(7441,'Mrs','Nancy','Marquez','94497','284 Ninth Road,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7442,'Mr','Michael','Taylor','79510','399 Poplar Parkway,#21')")
    stopIfSqlNotOK(session, "insert into customer values(7443,'Mrs','Nancy','Moore','77487','351 Chestnut Ave,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7444,'Mr','David','Moore','52323','338 Center Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7445,'Mrs','Jennifer','Brown','79842','319 Lake Avenue,#176')")
    stopIfSqlNotOK(session, "insert into customer values(7446,'Mrs','Sandra','Walls','76877','330 Jefferson Ave,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7447,'Mrs','Angelia','Tucker','28173','484 Adams Ave,#36')")
    stopIfSqlNotOK(session, "insert into customer values(7448,'Mr','David','Brown','79382','354 North Road,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7449,'Mr','Clarence','Moore','76931','497 Meadow Drive,#68')")
    stopIfSqlNotOK(session, "insert into customer values(7450,'Mr','Terry','Wilson','77391','323 Pine Street,#162')")
    stopIfSqlNotOK(session, "insert into customer values(7451,'Mr','David','Osborn','76262','492 Hillcrest Avenue,#14')")
    stopIfSqlNotOK(session, "insert into customer values(7452,'Mr','Ken','Smith','75858','175 Lee Street,#53')")
    stopIfSqlNotOK(session, "insert into customer values(7453,'Mr','Eric','Carson','98376','136 Church Avenue,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7454,'Mrs','Nancy','Miller','78540','379 Spring St.,#135')")
    stopIfSqlNotOK(session, "insert into customer values(7455,'Mrs','Clara','Boyd','48450','259 Eleventh Ave,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7456,'Mr','Michael','Wilson','77450','149 Davis Ave,#119')")
    stopIfSqlNotOK(session, "insert into customer values(7457,'Mr','Richard','Johnson','78108','137 Laurel Lane,#200')")
    stopIfSqlNotOK(session, "insert into customer values(7458,'Mr','James','Moore','62601','11 Spring Ave,#119')")
    stopIfSqlNotOK(session, "insert into customer values(7459,'Mr','Thomas','Kirby','54976','306 Mill Place,#89')")
    stopIfSqlNotOK(session, "insert into customer values(7460,'Mrs','Sharon','Moore','75368','239 Madison Square,#179')")
    stopIfSqlNotOK(session, "insert into customer values(7461,'Mr','Franklin','Taylor','79851','297 Spruce Road,#12')")
    stopIfSqlNotOK(session, "insert into customer values(7462,'Mrs','Sharon','Jones','77351','166 Ridge St.,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7463,'Mr','Ryan','Ferrell','78351','454 Eighth Lane,#150')")
    stopIfSqlNotOK(session, "insert into customer values(7464,'Mr','Anthony','Valencia','77578','489 Eighth Street,#130')")
    stopIfSqlNotOK(session, "insert into customer values(7465,'Mr','Michael','Jones','58371','311 Woodland Ave,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7466,'Mr','William','Wilson','77547','446 Sunset Drive,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7467,'Mr','David','Perry','77614','411 Oak Street,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7468,'Mrs','Patricia','Taylor','79201','39 Main Street,#168')")
    stopIfSqlNotOK(session, "insert into customer values(7469,'Mrs','Jennifer','Sherman','79734','3 Davis Boulevard,#119')")
    stopIfSqlNotOK(session, "insert into customer values(7470,'Mr','Joseph','Smith','76127','480 Dogwood Avenue,#87')")
    stopIfSqlNotOK(session, "insert into customer values(7471,'Mr','Joseph','Acosta','18979','486 Hill Square,#161')")
    stopIfSqlNotOK(session, "insert into customer values(7472,'Mrs','Anita','Taylor','76569','440 Cherry Parkway,#58')")
    stopIfSqlNotOK(session, "insert into customer values(7473,'Mr','John','Brown','75667','76 Cedar Walk,#165')")
    stopIfSqlNotOK(session, "insert into customer values(7474,'Mrs','Kristina','Wilson','55332','100 Fifteenth Lane,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7475,'Mr','William','Williams','76517','351 Lakeview Street,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7476,'Mrs','Sharon','Kaufman','93118','377 Twelfth Boulevard,#55')")
    stopIfSqlNotOK(session, "insert into customer values(7477,'Mrs','Patricia','Smith','24450','431 Third Avenue,#69')")
    stopIfSqlNotOK(session, "insert into customer values(7478,'Mrs','Nadia','Brown','77971','387 Locust Boulevard,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7479,'Mr','Cecil','Drake','79530','383 Eighth Square,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7480,'Mr','Charles','Brown','48732','410 Third Lane,#40')")
    stopIfSqlNotOK(session, "insert into customer values(7481,'Mr','John','Johnson','77360','45 Sycamore Boulevard,#107')")
    stopIfSqlNotOK(session, "insert into customer values(7482,'Mrs','Nancy','Davis','19341','11 Green Street,#36')")
    stopIfSqlNotOK(session, "insert into customer values(7483,'Mr','Erik','Hall','78070','91 Third Street,#117')")
    stopIfSqlNotOK(session, "insert into customer values(7484,'Mrs','Jennifer','George','78933','115 Broadway Ave,#65')")
    stopIfSqlNotOK(session, "insert into customer values(7485,'Mrs','Gloria','Davis','83441','472 Oak Walk,#59')")
    stopIfSqlNotOK(session, "insert into customer values(7486,'Mrs','Jewel','Miller','75065','438 Pine Place,#66')")
    stopIfSqlNotOK(session, "insert into customer values(7487,'Mr','Nathaniel','Glass','76119','318 Lee Street,#163')")
    stopIfSqlNotOK(session, "insert into customer values(7488,'Mr','William','Nunez','48413','380 Laurel Boulevard,#95')")
    stopIfSqlNotOK(session, "insert into customer values(7489,'Mr','Melvin','Miller','68351','53 Walnut Walk,#127')")
    stopIfSqlNotOK(session, "insert into customer values(7490,'Mrs','Luella','Smith','63377','215 Main Avenue,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7491,'Mrs','Trina','Roman','77665','22 Adams Avenue,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7492,'Mrs','Dona','Johnson','76462','148 Seventh Square,#106')")
    stopIfSqlNotOK(session, "insert into customer values(7493,'Mr','Mitchell','Powers','39361','151 River Walk,#57')")
    stopIfSqlNotOK(session, "insert into customer values(7494,'Mrs','Kimberley','Miller','91778','27 Third Ave,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7495,'Mrs','Lori','Miller','47456','40 Woodland Street,#55')")
    stopIfSqlNotOK(session, "insert into customer values(7496,'Mr','Tom','Watts','76692','73 Park Blvd,#66')")
    stopIfSqlNotOK(session, "insert into customer values(7497,'Mr','Lance','Humphrey','75750','354 Jefferson Lane,#43')")
    stopIfSqlNotOK(session, "insert into customer values(7498,'Mrs','Betty','Davenport','77349','348 Sycamore Walk,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7499,'Mr','Kenneth','Wilson','75661','435 Williams Road,#133')")
    stopIfSqlNotOK(session, "insert into customer values(7500,'Mr','Donald','Rios','31801','367 Sycamore Avenue,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7501,'Mrs','Jeri','Gibson','77481','497 Meadow Street,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7502,'Mr','David','Jones','77582','388 Second Street,#94')")
    stopIfSqlNotOK(session, "insert into customer values(7503,'Mrs','Barbara','Valenzuela','75142','484 Hill Boulevard,#60')")
    stopIfSqlNotOK(session, "insert into customer values(7504,'Mrs','Dorothy','Taylor','76934','1 West Blvd,#52')")
    stopIfSqlNotOK(session, "insert into customer values(7505,'Mrs','Elisabeth','Jones','76051','484 Jackson Street,#115')")
    stopIfSqlNotOK(session, "insert into customer values(7506,'Mr','Kurt','Rodriguez','27869','275 Miller Walk,#106')")
    stopIfSqlNotOK(session, "insert into customer values(7507,'Mrs','Claudia','Taylor','76508','168 East Ave,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7508,'Mr','Cody','Cherry','79733','313 River Boulevard,#129')")
    stopIfSqlNotOK(session, "insert into customer values(7509,'Mr','Thomas','Calderon','76689','246 Second Boulevard,#2')")
    stopIfSqlNotOK(session, "insert into customer values(7510,'Mrs','Wilda','Taylor','78076','364 Mill Lane,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7511,'Mr','John','Taylor','76564','392 Second Ave,#119')")
    stopIfSqlNotOK(session, "insert into customer values(7512,'Mrs','Tracey','Miller','79031','443 Elm Road,#94')")
    stopIfSqlNotOK(session, "insert into customer values(7513,'Mrs','Claudette','Farmer','70765','188 Maple Lane,#14')")
    stopIfSqlNotOK(session, "insert into customer values(7514,'Mr','Robert','Davis','75858','112 Fourth Drive,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7515,'Mrs','Nancy','Davis','78836','379 Green Road,#195')")
    stopIfSqlNotOK(session, "insert into customer values(7516,'Mr','Patrick','Roberts','12107','195 Miller Walk,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7517,'Mrs','Jennifer','Jones','78559','467 Jackson Place,#3')")
    stopIfSqlNotOK(session, "insert into customer values(7518,'Mr','Richard','Johnson','78114','179 Elm Avenue,#55')")
    stopIfSqlNotOK(session, "insert into customer values(7519,'Mr','Michael','Mcpherson','75936','327 Willow Lane,#175')")
    stopIfSqlNotOK(session, "insert into customer values(7520,'Mrs','Leticia','Edwards','77487','414 Cedar Road,#123')")
    stopIfSqlNotOK(session, "insert into customer values(7521,'Mrs','Hillary','Wilson','75057','169 Spring Lane,#27')")
    stopIfSqlNotOK(session, "insert into customer values(7522,'Mrs','Barbara','Williams','62889','484 Second Street,#49')")
    stopIfSqlNotOK(session, "insert into customer values(7523,'Mrs','Caroline','Davis','78072','200 Birch Street,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7524,'Mr','Raul','Brown','76712','236 Second Parkway,#32')")
    stopIfSqlNotOK(session, "insert into customer values(7525,'Mr','Derek','Garza','77391','228 West Parkway,#70')")
    stopIfSqlNotOK(session, "insert into customer values(7526,'Mrs','Candice','Pope','78009','184 Spring Avenue,#171')")
    stopIfSqlNotOK(session, "insert into customer values(7527,'Mrs','Thelma','Johnson','45381','139 Ninth Street,#83')")
    stopIfSqlNotOK(session, "insert into customer values(7528,'Mr','Richard','Frank','65534','272 Adams Drive,#110')")
    stopIfSqlNotOK(session, "insert into customer values(7529,'Mr','Justin','Hood','48732','193 Hillcrest St.,#72')")
    stopIfSqlNotOK(session, "insert into customer values(7530,'Mr','Jeffrey','Roberts','47865','279 Walnut Walk,#198')")
    stopIfSqlNotOK(session, "insert into customer values(7531,'Mrs','Betty','Lamb','75568','80 Hill Square,#10')")
    stopIfSqlNotOK(session, "insert into customer values(7532,'Mr','Manuel','Maldonado','49082','58 Second Ave,#87')")
    stopIfSqlNotOK(session, "insert into customer values(7533,'Mrs','Carol','Brown','24360','222 Taylor Lane,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7534,'Mr','James','Taylor','77968','361 Tenth Road,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7535,'Mrs','Barbara','Wilson','76552','68 Jefferson Boulevard,#8')")
    stopIfSqlNotOK(session, "insert into customer values(7536,'Mr','Erik','Smith','76512','72 Madison Parkway,#57')")
    stopIfSqlNotOK(session, "insert into customer values(7537,'Mr','David','Moore','75077','52 Meadow St.,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7538,'Mr','Clifton','Taylor','78549','26 College Blvd,#157')")
    stopIfSqlNotOK(session, "insert into customer values(7539,'Mrs','May','Johnson','19353','415 Hillcrest Boulevard,#175')")
    stopIfSqlNotOK(session, "insert into customer values(7540,'Mr','Louis','Henson','31050','369 Wilson Road,#11')")
    stopIfSqlNotOK(session, "insert into customer values(7541,'Mr','Mathew','Patterson','61728','313 Adams St.,#151')")
    stopIfSqlNotOK(session, "insert into customer values(7542,'Mr','John','Miller','75640','382 Elm Place,#191')")
    stopIfSqlNotOK(session, "insert into customer values(7543,'Mrs','Jeannette','Brown','24628','490 Lakeview Parkway,#191')")
    stopIfSqlNotOK(session, "insert into customer values(7544,'Mr','Terrence','Baird','75488','280 Elm Avenue,#55')")
    stopIfSqlNotOK(session, "insert into customer values(7545,'Mr','James','Wilson','76148','27 Maple Place,#77')")
    stopIfSqlNotOK(session, "insert into customer values(7546,'Mr','Don','Brown','79008','57 River St.,#128')")
    stopIfSqlNotOK(session, "insert into customer values(7547,'Mr','James','Moore','78372','413 Forest Lane,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7548,'Mr','Alan','Miller','75072','165 Fifteenth Street,#135')")
    stopIfSqlNotOK(session, "insert into customer values(7549,'Mrs','Janie','Hernandez','33441','78 View Boulevard,#59')")
    stopIfSqlNotOK(session, "insert into customer values(7550,'Mrs','Susan','Flynn','77434','260 Hickory Lane,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7551,'Mr','Fernando','Harrington','76650','126 Sycamore Street,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7552,'Mr','Joseph','Stout','77866','270 North Parkway,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7553,'Mr','Lester','Sims','79237','125 Johnson Ave,#98')")
    stopIfSqlNotOK(session, "insert into customer values(7554,'Mrs','Willa','Davis','78504','425 Lake Ave,#66')")
    stopIfSqlNotOK(session, "insert into customer values(7555,'Mrs','Carmela','Wilson','16036','148 Ninth Drive,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7556,'Mr','Brad','Smith','78586','339 Central St.,#174')")
    stopIfSqlNotOK(session, "insert into customer values(7557,'Mrs','Bettye','Wiley','75476','241 Ninth Street,#99')")
    stopIfSqlNotOK(session, "insert into customer values(7558,'Mr','George','Johnson','75436','138 Johnson Boulevard,#1')")
    stopIfSqlNotOK(session, "insert into customer values(7559,'Mr','Joseph','Davis','67513','44 Locust Square,#200')")
    stopIfSqlNotOK(session, "insert into customer values(7560,'Mr','Michael','Brown','76855','194 Pine Boulevard,#4')")
    stopIfSqlNotOK(session, "insert into customer values(7561,'Mr','Charles','Massey','78014','328 Laurel St.,#25')")
    stopIfSqlNotOK(session, "insert into customer values(7562,'Mrs','Hazel','Glass','75773','58 Madison Place,#141')")
    stopIfSqlNotOK(session, "insert into customer values(7563,'Mr','John','Greer','76060','335 Williams Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7564,'Mr','John','Schmidt','75935','491 Miller Parkway,#113')")
    stopIfSqlNotOK(session, "insert into customer values(7565,'Mrs','Theresa','Garcia','90721','307 Locust St.,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7566,'Mr','Adam','Wolfe','40927','407 Hickory Place,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7567,'Mrs','Carol','Wilson','76621','150 River Blvd,#119')")
    stopIfSqlNotOK(session, "insert into customer values(7568,'Mrs','Rosalind','Moore','62830','105 East Blvd,#193')")
    stopIfSqlNotOK(session, "insert into customer values(7569,'Mrs','Patricia','Taylor','70310','80 Eleventh Blvd,#145')")
    stopIfSqlNotOK(session, "insert into customer values(7570,'Mrs','Kimberly','Brown','16027','302 College Avenue,#12')")
    stopIfSqlNotOK(session, "insert into customer values(7571,'Mrs','Leah','Pierce','78342','423 Central St.,#48')")
    stopIfSqlNotOK(session, "insert into customer values(7572,'Mrs','Lorena','Smith','76030','303 Railroad Ave,#84')")
    stopIfSqlNotOK(session, "insert into customer values(7573,'Mrs','Kirsten','Brown','78667','392 Church Walk,#148')")
    stopIfSqlNotOK(session, "insert into customer values(7574,'Mr','James','Johnson','75831','89 Fifteenth Road,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7575,'Mr','Angel','Miller','79778','422 Meadow Place,#89')")
    stopIfSqlNotOK(session, "insert into customer values(7576,'Mrs','Carol','Jones','22135','359 Seventh Ave,#3')")
    stopIfSqlNotOK(session, "insert into customer values(7577,'Mrs','Sandra','Harvey','76354','225 Center Road,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7578,'Mrs','Nancy','Johnson','93441','75 Dogwood Road,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7579,'Mr','Jim','Macdonald','78393','441 Fifteenth Ave,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7580,'Mrs','Jaime','Mcdonald','29682','86 Broadway Road,#33')")
    stopIfSqlNotOK(session, "insert into customer values(7581,'Mr','Wayne','Williams','73051','344 First Road,#187')")
    stopIfSqlNotOK(session, "insert into customer values(7582,'Mr','Robert','Miller','14507','53 East Road,#26')")
    stopIfSqlNotOK(session, "insert into customer values(7583,'Mr','Felix','Johnson','78355','366 South Place,#109')")
    stopIfSqlNotOK(session, "insert into customer values(7584,'Mrs','Patricia','Smith','15090','301 Wilson Street,#148')")
    stopIfSqlNotOK(session, "insert into customer values(7585,'Mr','Guy','Jones','75667','288 Adams Walk,#117')")
    stopIfSqlNotOK(session, "insert into customer values(7586,'Mr','John','Banks','78344','271 Church Walk,#136')")
    stopIfSqlNotOK(session, "insert into customer values(7587,'Mr','Ruben','Miller','79373','401 Chestnut Road,#182')")
    stopIfSqlNotOK(session, "insert into customer values(7588,'Mr','Jessie','Taylor','55331','28 Adams St.,#58')")
    stopIfSqlNotOK(session, "insert into customer values(7589,'Mrs','Chris','Stanley','14005','205 Birch Drive,#64')")
    stopIfSqlNotOK(session, "insert into customer values(7590,'Mrs','Harriet','Taylor','75026','209 College Parkway,#137')")
    stopIfSqlNotOK(session, "insert into customer values(7591,'Mr','Jose','Bridges','75791','499 North Drive,#191')")
    stopIfSqlNotOK(session, "insert into customer values(7592,'Mrs','Nancy','Taylor','25180','183 Center Place,#126')")
    stopIfSqlNotOK(session, "insert into customer values(7593,'Mrs','Sharon','Wilson','76462','322 Fifth St.,#87')")
    stopIfSqlNotOK(session, "insert into customer values(7594,'Mr','Carl','Williams','87506','23 View Square,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7595,'Mrs','Cynthia','Reid','65541','36 Adams Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(7596,'Mr','Benjamin','Moore','76246','427 Main St.,#114')")
    stopIfSqlNotOK(session, "insert into customer values(7597,'Mr','Edgar','Moore','76831','83 Taylor Street,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7598,'Mr','Joseph','Smith','45871','180 Madison Lane,#68')")
    stopIfSqlNotOK(session, "insert into customer values(7599,'Mr','David','Johnson','90018','141 Spring Place,#168')")
    stopIfSqlNotOK(session, "insert into customer values(7600,'Mrs','Sharon','Johnson','76371','29 Thirteenth St.,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7601,'Mr','John','Saunders','94156','179 Washington Place,#59')")
    stopIfSqlNotOK(session, "insert into customer values(7602,'Mrs','Nancy','Miller','76052','298 Willow Road,#8')")
    stopIfSqlNotOK(session, "insert into customer values(7603,'Mrs','Yvette','Davis','79013','318 Walnut Drive,#63')")
    stopIfSqlNotOK(session, "insert into customer values(7604,'Mr','Erik','Herrera','78142','355 Hillcrest Place,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7605,'Mr','John','Taylor','78154','342 Birch Street,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7606,'Mrs','Sharon','Taylor','63381','88 College Parkway,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7607,'Mrs','Sharon','Hickman','28784','388 Highland Road,#54')")
    stopIfSqlNotOK(session, "insert into customer values(7608,'Mrs','Ruby','Moore','79851','469 Johnson Blvd,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7609,'Mrs','Betty','Davis','79511','215 Twelfth Boulevard,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7610,'Mrs','Betty','Miller','23427','305 Walnut Walk,#184')")
    stopIfSqlNotOK(session, "insert into customer values(7611,'Mrs','Hollie','Miller','40153','271 Dogwood Drive,#193')")
    stopIfSqlNotOK(session, "insert into customer values(7612,'Mrs','Marjorie','Davis','78050','257 Lakeview Ave,#58')")
    stopIfSqlNotOK(session, "insert into customer values(7613,'Mr','Tyrone','Mcneil','79718','151 Lake Square,#84')")
    stopIfSqlNotOK(session, "insert into customer values(7614,'Mr','Robert','Smith','78933','304 Cherry Walk,#10')")
    stopIfSqlNotOK(session, "insert into customer values(7615,'Mr','Ben','Miller','16678','408 Central Street,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7616,'Mr','Joseph','Hobbs','76559','266 Willow Boulevard,#25')")
    stopIfSqlNotOK(session, "insert into customer values(7617,'Mrs','Dorothy','Ballard','56543','219 Cherry Street,#93')")
    stopIfSqlNotOK(session, "insert into customer values(7618,'Mr','James','Moore','79368','450 Valley Drive,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7619,'Mr','Francisco','Tate','65735','464 Ridge Parkway,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7620,'Mr','Ian','Miller','75368','240 Williams Square,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7621,'Mr','Dwight','Duke','52056','405 Main St.,#125')")
    stopIfSqlNotOK(session, "insert into customer values(7622,'Mrs','Rosemary','Allen','17825','281 Elm Blvd,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7623,'Mr','Jack','Harris','76943','376 Willow Drive,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7624,'Mrs','Sandra','Williams','79081','330 Valley Walk,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7625,'Mr','Ernest','Miller','76561','380 Cedar Street,#144')")
    stopIfSqlNotOK(session, "insert into customer values(7626,'Mrs','Tanisha','Williams','78872','123 Ninth Boulevard,#74')")
    stopIfSqlNotOK(session, "insert into customer values(7627,'Mrs','Lupe','Davis','33441','14 Fifteenth Avenue,#101')")
    stopIfSqlNotOK(session, "insert into customer values(7628,'Mr','William','Moore','88521','366 East Road,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7629,'Mrs','Nancy','Craft','10099','331 Ash Avenue,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7630,'Mrs','Sharon','Shepard','78622','463 Sunset Ave,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7631,'Mr','Francis','Williams','75125','150 Lake Walk,#116')")
    stopIfSqlNotOK(session, "insert into customer values(7632,'Mrs','Sandra','Moody','77489','308 Fifth Lane,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7633,'Mr','Marcus','Petty','76651','461 Highland Street,#144')")
    stopIfSqlNotOK(session, "insert into customer values(7634,'Mrs','Barbara','Davis','76528','347 Fourth Square,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7635,'Mr','Edgar','Brown','77839','181 Wilson Street,#117')")
    stopIfSqlNotOK(session, "insert into customer values(7636,'Mrs','Susan','Johnson','78351','155 Laurel Lane,#59')")
    stopIfSqlNotOK(session, "insert into customer values(7637,'Mrs','Claire','Smith','79360','92 College Square,#127')")
    stopIfSqlNotOK(session, "insert into customer values(7638,'Mrs','Sandra','Smith','56308','92 Eleventh Road,#56')")
    stopIfSqlNotOK(session, "insert into customer values(7639,'Mrs','Carol','Vaughn','76087','55 Wilson Square,#85')")
    stopIfSqlNotOK(session, "insert into customer values(7640,'Mr','Antonio','Luna','77991','93 Adams Boulevard,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7641,'Mrs','Kaitlin','Jones','78959','257 Ninth Drive,#196')")
    stopIfSqlNotOK(session, "insert into customer values(7642,'Mr','Francisco','Mcbride','29682','405 Main Road,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7643,'Mr','Eduardo','Taylor','30417','14 Sunset Lane,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7644,'Mr','Francis','Williams','78360','63 Sunset Place,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7645,'Mr','James','Davis','22737','100 Main Walk,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7646,'Mrs','Angeline','Johnson','87545','327 Smith St.,#179')")
    stopIfSqlNotOK(session, "insert into customer values(7647,'Mrs','Patricia','Tillman','75163','56 Maple Avenue,#35')")
    stopIfSqlNotOK(session, "insert into customer values(7648,'Mr','Kurt','Munoz','60102','322 Broadway Road,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7649,'Mrs','Ines','Taylor','78947','10 Meadow Avenue,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7650,'Mr','Byron','Collier','76638','365 East Street,#131')")
    stopIfSqlNotOK(session, "insert into customer values(7651,'Mrs','Sharon','Davis','76148','17 Smith Road,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7652,'Mr','David','Williams','73668','351 Wilson Place,#49')")
    stopIfSqlNotOK(session, "insert into customer values(7653,'Mrs','Sharon','Brown','75075','253 Pine Parkway,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7654,'Mrs','Carol','Davis','75562','493 Birch Walk,#44')")
    stopIfSqlNotOK(session, "insert into customer values(7655,'Mrs','Dorothy','Jones','75339','262 Fourteenth Place,#109')")
    stopIfSqlNotOK(session, "insert into customer values(7656,'Mrs','Jennifer','Williams','76255','419 Fifth Parkway,#147')")
    stopIfSqlNotOK(session, "insert into customer values(7657,'Mrs','Carol','Hurley','77350','93 Sunset Square,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7658,'Mr','Robert','Moore','87050','349 Hill Road,#145')")
    stopIfSqlNotOK(session, "insert into customer values(7659,'Mrs','Susan','Watkins','82323','178 Johnson Drive,#162')")
    stopIfSqlNotOK(session, "insert into customer values(7660,'Mrs','Sandra','Patrick','77972','79 Highland Boulevard,#2')")
    stopIfSqlNotOK(session, "insert into customer values(7661,'Mrs','Diann','Mcintosh','75019','287 Cherry Lane,#184')")
    stopIfSqlNotOK(session, "insert into customer values(7662,'Mr','David','Contreras','64478','454 Fifteenth Parkway,#78')")
    stopIfSqlNotOK(session, "insert into customer values(7663,'Mrs','Marguerite','Davis','88348','384 Forest Drive,#193')")
    stopIfSqlNotOK(session, "insert into customer values(7664,'Mrs','Sharon','Taylor','78270','357 Ninth Road,#173')")
    stopIfSqlNotOK(session, "insert into customer values(7665,'Mrs','Carol','Davis','75019','308 River Street,#106')")
    stopIfSqlNotOK(session, "insert into customer values(7666,'Mr','William','Taylor','79561','384 Jefferson St.,#49')")
    stopIfSqlNotOK(session, "insert into customer values(7667,'Mrs','Patricia','Haley','75453','307 Maple Ave,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7668,'Mr','John','Moore','78245','369 Lincoln St.,#138')")
    stopIfSqlNotOK(session, "insert into customer values(7669,'Mrs','Nancy','Fernandez','78656','53 Birch Drive,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7670,'Mrs','Claire','Johnson','76066','412 Green Boulevard,#50')")
    stopIfSqlNotOK(session, "insert into customer values(7671,'Mrs','Jennifer','Johnson','75570','20 Meadow Parkway,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7672,'Mrs','Jennifer','Johnson','57335','432 River Road,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7673,'Mrs','Nancy','Johnson','77461','430 Madison Drive,#163')")
    stopIfSqlNotOK(session, "insert into customer values(7674,'Mr','Charles','Smith','77870','280 Park Boulevard,#21')")
    stopIfSqlNotOK(session, "insert into customer values(7675,'Mr','Richard','Smith','79001','95 Forest Walk,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7676,'Mrs','Rosemary','Wilson','77974','79 Willow Road,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7677,'Mr','Enrique','Shields','66086','10 Wilson Parkway,#53')")
    stopIfSqlNotOK(session, "insert into customer values(7678,'Mrs','Annmarie','Johnson','50076','290 Pine St.,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7679,'Mrs','Carol','Taylor','54730','37 Ninth Ave,#1')")
    stopIfSqlNotOK(session, "insert into customer values(7680,'Mr','William','Maldonado','79854','329 Maple Road,#116')")
    stopIfSqlNotOK(session, "insert into customer values(7681,'Mrs','Marie','Vazquez','79353','128 Third Boulevard,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7682,'Mrs','Jennifer','Raymond','51052','237 Sunset Drive,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7683,'Mr','Michael','Williams','78594','331 Locust Boulevard,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7684,'Mr','John','Taylor','75009','36 Birch Avenue,#178')")
    stopIfSqlNotOK(session, "insert into customer values(7685,'Mr','Jimmie','Taylor','76513','224 Sunset Walk,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7686,'Mrs','Dorothy','Roberson','75415','13 North Road,#95')")
    stopIfSqlNotOK(session, "insert into customer values(7687,'Mrs','Leila','Taylor','59353','165 Eighth Avenue,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7688,'Mr','Joseph','Reid','85242','356 Maple Blvd,#118')")
    stopIfSqlNotOK(session, "insert into customer values(7689,'Mrs','Susan','Davis','75492','10 North Street,#160')")
    stopIfSqlNotOK(session, "insert into customer values(7690,'Mr','Everett','Gallegos','63373','315 Woodland Boulevard,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7691,'Mr','Tracy','Smith','78004','40 Lakeview Drive,#190')")
    stopIfSqlNotOK(session, "insert into customer values(7692,'Mr','Morris','Davis','75926','239 Eighth Place,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7693,'Mrs','Lawanda','Johnson','79543','266 Madison Parkway,#85')")
    stopIfSqlNotOK(session, "insert into customer values(7694,'Mrs','Dorothy','Miller','11762','370 Spring Drive,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7695,'Mrs','Jennifer','Williams','04224','264 Mill Drive,#152')")
    stopIfSqlNotOK(session, "insert into customer values(7696,'Mrs','Lorena','House','08736','429 East Avenue,#90')")
    stopIfSqlNotOK(session, "insert into customer values(7697,'Mrs','Jacquelyn','Perez','97423','250 Spring Street,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7698,'Mr','Michael','Morgan','76680','367 Main Boulevard,#93')")
    stopIfSqlNotOK(session, "insert into customer values(7699,'Mr','Thomas','Williams','93160','278 View Ave,#171')")
    stopIfSqlNotOK(session, "insert into customer values(7700,'Mrs','Sharon','William','02173','49 Oak Avenue,#95')")
    stopIfSqlNotOK(session, "insert into customer values(7701,'Mrs','Betsy','Collier','76061','414 Johnson Lane,#2')")
    stopIfSqlNotOK(session, "insert into customer values(7702,'Mrs','Nancy','Smith','75182','401 West Avenue,#78')")
    stopIfSqlNotOK(session, "insert into customer values(7703,'Mr','Herman','Smith','69037','402 Second Place,#192')")
    stopIfSqlNotOK(session, "insert into customer values(7704,'Mr','Micheal','Mcconnell','79525','462 Railroad Street,#130')")
    stopIfSqlNotOK(session, "insert into customer values(7705,'Mrs','Patricia','Little','77582','371 Lakeview Blvd,#47')")
    stopIfSqlNotOK(session, "insert into customer values(7706,'Mr','William','Calhoun','77414','77 Wilson Walk,#187')")
    stopIfSqlNotOK(session, "insert into customer values(7707,'Mrs','Nancy','Davis','79244','205 Ridge Drive,#150')")
    stopIfSqlNotOK(session, "insert into customer values(7708,'Mrs','Jennifer','Wilson','76642','39 Valley Square,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7709,'Mr','William','Watson','01808','347 College Road,#125')")
    stopIfSqlNotOK(session, "insert into customer values(7710,'Mr','Ralph','Wilson','76958','146 Forest Avenue,#168')")
    stopIfSqlNotOK(session, "insert into customer values(7711,'Mrs','Jessica','Jones','78164','452 Meadow Avenue,#162')")
    stopIfSqlNotOK(session, "insert into customer values(7712,'Mr','John','Reynolds','78634','458 Wilson Lane,#114')")
    stopIfSqlNotOK(session, "insert into customer values(7713,'Mr','Ronnie','Mcgowan','78935','26 Spruce Ave,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7714,'Mrs','Barbara','Wilson','77993','261 Chestnut St.,#178')")
    stopIfSqlNotOK(session, "insert into customer values(7715,'Mr','William','Logan','78280','247 West Walk,#133')")
    stopIfSqlNotOK(session, "insert into customer values(7716,'Mrs','Patricia','Brooks','78011','320 Highland Walk,#99')")
    stopIfSqlNotOK(session, "insert into customer values(7717,'Mr','Peter','Johnson','75659','487 Church Road,#190')")
    stopIfSqlNotOK(session, "insert into customer values(7718,'Mr','Lewis','Moore','77541','407 Ash Lane,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7719,'Mrs','Trina','Robles','79515','426 College Road,#107')")
    stopIfSqlNotOK(session, "insert into customer values(7720,'Mr','Duane','Taylor','40526','22 Lake Street,#52')")
    stopIfSqlNotOK(session, "insert into customer values(7721,'Mrs','Robert','Taylor','75422','355 Miller Blvd,#198')")
    stopIfSqlNotOK(session, "insert into customer values(7722,'Mr','Robert','Taylor','75155','453 Woodland Parkway,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7723,'Mr','Bob','Davis','77442','267 Hillcrest Walk,#87')")
    stopIfSqlNotOK(session, "insert into customer values(7724,'Mr','Robert','Miller','78341','274 Fifth Drive,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7725,'Mrs','Sharon','Humphrey','78673','237 Fifth Blvd,#154')")
    stopIfSqlNotOK(session, "insert into customer values(7726,'Mrs','Marlene','Moore','78562','323 Johnson Avenue,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7727,'Mr','Zachary','Valenzuela','78662','58 Second Walk,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7728,'Mrs','Sharon','Williams','77519','260 Sycamore Parkway,#10')")
    stopIfSqlNotOK(session, "insert into customer values(7729,'Mrs','Misty','Campbell','70633','99 North St.,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7730,'Mr','John','Williams','00651','265 Poplar Avenue,#77')")
    stopIfSqlNotOK(session, "insert into customer values(7731,'Mr','Earl','Parrish','87725','246 West St.,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7732,'Mr','Joseph','Mendoza','79252','312 Jefferson Street,#84')")
    stopIfSqlNotOK(session, "insert into customer values(7733,'Mrs','Susan','Huber','48413','323 Maple Lane,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7734,'Mrs','Jacklyn','Bird','75693','211 Miller St.,#35')")
    stopIfSqlNotOK(session, "insert into customer values(7735,'Mr','John','Jones','18245','130 North Street,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7736,'Mrs','Jolene','Williams','10132','278 Sycamore Walk,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7737,'Mr','Adam','Phelps','76380','123 Sixth Boulevard,#175')")
    stopIfSqlNotOK(session, "insert into customer values(7738,'Mr','James','Williams','79735','234 Broadway Drive,#158')")
    stopIfSqlNotOK(session, "insert into customer values(7739,'Mr','Bradley','Hobbs','75932','137 Williams Blvd,#70')")
    stopIfSqlNotOK(session, "insert into customer values(7740,'Mrs','Barbara','Todd','79363','20 Ninth Blvd,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7741,'Mrs','Marci','Miller','00757','455 South Lane,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7742,'Mr','Erik','Wilson','13362','327 Fifth Drive,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7743,'Mr','David','Peck','79346','280 Valley Blvd,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7744,'Mr','Ramon','Smith','07863','270 Sixth Parkway,#164')")
    stopIfSqlNotOK(session, "insert into customer values(7745,'Mrs','Dale','Byrd','70765','307 Taylor St.,#100')")
    stopIfSqlNotOK(session, "insert into customer values(7746,'Mrs','Ella','Miller','75155','423 Oak St.,#2')")
    stopIfSqlNotOK(session, "insert into customer values(7747,'Mr','David','Jones','75663','432 Sixth Parkway,#136')")
    stopIfSqlNotOK(session, "insert into customer values(7748,'Mr','Ben','Williams','95148','350 Sycamore St.,#52')")
    stopIfSqlNotOK(session, "insert into customer values(7749,'Mrs','Sandra','Johnson','78950','218 Hickory St.,#180')")
    stopIfSqlNotOK(session, "insert into customer values(7750,'Mrs','Patricia','Jones','79566','81 Twelfth Ave,#153')")
    stopIfSqlNotOK(session, "insert into customer values(7751,'Mrs','Dorothy','Taylor','75956','189 Forest Lane,#21')")
    stopIfSqlNotOK(session, "insert into customer values(7752,'Mrs','Celina','Williams','79506','204 Mill Walk,#101')")
    stopIfSqlNotOK(session, "insert into customer values(7753,'Mr','James','Stone','11959','215 Church Blvd,#40')")
    stopIfSqlNotOK(session, "insert into customer values(7754,'Mr','Johnny','Holden','70302','77 River Place,#155')")
    stopIfSqlNotOK(session, "insert into customer values(7755,'Mr','Jay','Brown','10199','92 Mill Drive,#119')")
    stopIfSqlNotOK(session, "insert into customer values(7756,'Mr','Wade','Davis','01885','79 Walnut Ave,#4')")
    stopIfSqlNotOK(session, "insert into customer values(7757,'Mr','Joseph','Miller','45056','175 East Boulevard,#199')")
    stopIfSqlNotOK(session, "insert into customer values(7758,'Mr','James','Miller','77358','184 Seventh Ave,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7759,'Mrs','Sandra','Moore','79754','169 Railroad Parkway,#30')")
    stopIfSqlNotOK(session, "insert into customer values(7760,'Mrs','Sandra','Wilson','77335','425 Franklin Parkway,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7761,'Mrs','Barbara','Brown','77612','212 West Drive,#72')")
    stopIfSqlNotOK(session, "insert into customer values(7762,'Mr','Francisco','Smith','79961','69 Cherry Ave,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7763,'Mrs','Teresa','Mcdowell','62889','100 Sixth Parkway,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7764,'Mr','Thomas','Williams','79968','98 West Ave,#47')")
    stopIfSqlNotOK(session, "insert into customer values(7765,'Mr','Joseph','Jones','77853','468 Miller Road,#86')")
    stopIfSqlNotOK(session, "insert into customer values(7766,'Mrs','Barbara','Riley','75790','409 Smith Street,#25')")
    stopIfSqlNotOK(session, "insert into customer values(7767,'Mrs','Jan','Noble','49854','156 Spruce Place,#173')")
    stopIfSqlNotOK(session, "insert into customer values(7768,'Mrs','Maureen','Wilson','75758','297 Elm Walk,#133')")
    stopIfSqlNotOK(session, "insert into customer values(7769,'Mrs','Barbara','Emerson','78114','367 Park Street,#19')")
    stopIfSqlNotOK(session, "insert into customer values(7770,'Mrs','Patricia','Johnson','76354','183 Locust St.,#71')")
    stopIfSqlNotOK(session, "insert into customer values(7771,'Mr','Charles','Robinson','76676','231 Meadow Square,#93')")
    stopIfSqlNotOK(session, "insert into customer values(7772,'Mrs','Vera','Brown','79382','129 Valley St.,#97')")
    stopIfSqlNotOK(session, "insert into customer values(7773,'Mr','Richard','Johnson','77402','80 Madison Parkway,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7774,'Mr','Miguel','Sanchez','76070','261 Ridge Street,#97')")
    stopIfSqlNotOK(session, "insert into customer values(7775,'Mr','James','Miller','75481','415 Valley Street,#105')")
    stopIfSqlNotOK(session, "insert into customer values(7776,'Mrs','Patricia','Welch','05454','256 Walnut Street,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7777,'Mrs','Olivia','Miles','62332','12 Main Blvd,#153')")
    stopIfSqlNotOK(session, "insert into customer values(7778,'Mrs','Nadia','Johnson','75487','32 Dogwood Place,#70')")
    stopIfSqlNotOK(session, "insert into customer values(7779,'Mrs','Dorothy','Miller','04093','367 East Walk,#34')")
    stopIfSqlNotOK(session, "insert into customer values(7780,'Mr','Thomas','Smith','75845','384 Railroad Street,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7781,'Mr','Charles','Figueroa','76266','312 Highland Drive,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7782,'Mrs','Mabel','Rush','75496','423 Mill St.,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7783,'Mrs','Fern','Davis','78638','250 Central Street,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7784,'Mrs','Barbra','Jones','90080','360 Center Blvd,#2')")
    stopIfSqlNotOK(session, "insert into customer values(7785,'Mr','Arthur','Nash','76352','439 Ninth Square,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7786,'Mr','David','Wilson','98936','93 Cherry Blvd,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7787,'Mr','William','Smith','54976','278 Laurel Square,#101')")
    stopIfSqlNotOK(session, "insert into customer values(7788,'Mrs','Marlene','Taylor','75266','143 Church Avenue,#40')")
    stopIfSqlNotOK(session, "insert into customer values(7789,'Mrs','Patricia','Wilson','90018','109 Taylor Street,#100')")
    stopIfSqlNotOK(session, "insert into customer values(7790,'Mr','David','Davis','79733','290 Third Parkway,#38')")
    stopIfSqlNotOK(session, "insert into customer values(7791,'Mr','Robert','Padilla','77373','394 Sunset Place,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7792,'Mrs','Patricia','Brown','77547','405 Main Boulevard,#171')")
    stopIfSqlNotOK(session, "insert into customer values(7793,'Mrs','Ilene','Wilson','80441','293 Pine Lane,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7794,'Mr','Ray','Wilson','87527','229 Madison Street,#7')")
    stopIfSqlNotOK(session, "insert into customer values(7795,'Mrs','April','Rodgers','00673','100 Ninth Ave,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7796,'Mr','Jacob','Jones','76060','379 Church Avenue,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7797,'Mrs','Jennifer','Williams','76657','28 Fourth Street,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7798,'Mr','Thomas','Moore','75756','120 Railroad St.,#8')")
    stopIfSqlNotOK(session, "insert into customer values(7799,'Mrs','Sharon','Smith','76228','415 Woodland Parkway,#142')")
    stopIfSqlNotOK(session, "insert into customer values(7800,'Mrs','Patricia','Rivas','79541','458 Fifteenth Square,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7801,'Mrs','Laurie','Taylor','79256','187 Dogwood Road,#12')")
    stopIfSqlNotOK(session, "insert into customer values(7802,'Mrs','Nina','Daniels','66086','161 Washington Blvd,#140')")
    stopIfSqlNotOK(session, "insert into customer values(7803,'Mrs','Kim','Richard','77878','158 Sunset St.,#50')")
    stopIfSqlNotOK(session, "insert into customer values(7804,'Mrs','Susan','Warner','12141','120 Lincoln St.,#132')")
    stopIfSqlNotOK(session, "insert into customer values(7805,'Mrs','Sandra','Young','58760','392 View St.,#40')")
    stopIfSqlNotOK(session, "insert into customer values(7806,'Mrs','Betty','Brewer','76043','39 Woodland St.,#47')")
    stopIfSqlNotOK(session, "insert into customer values(7807,'Mr','Miguel','Acosta','77293','286 Ash Lane,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7808,'Mrs','Barbara','Herrera','84531','242 Smith Street,#136')")
    stopIfSqlNotOK(session, "insert into customer values(7809,'Mr','Johnny','Brown','87542','221 Pine Boulevard,#193')")
    stopIfSqlNotOK(session, "insert into customer values(7810,'Mrs','Barbara','Taylor','77622','311 Cherry Road,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7811,'Mr','Ricky','Johnson','76367','132 Davis Square,#153')")
    stopIfSqlNotOK(session, "insert into customer values(7812,'Mrs','Tracie','Johnson','57039','383 Ridge Street,#73')")
    stopIfSqlNotOK(session, "insert into customer values(7813,'Mr','Shane','Smith','53952','414 Twelfth Ave,#152')")
    stopIfSqlNotOK(session, "insert into customer values(7814,'Mr','Thomas','Ewing','75780','334 Johnson St.,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7815,'Mrs','Barbara','Hendricks','79848','500 Willow Avenue,#200')")
    stopIfSqlNotOK(session, "insert into customer values(7816,'Mrs','Barbara','Tran','78660','371 Fourth Road,#161')")
    stopIfSqlNotOK(session, "insert into customer values(7817,'Mrs','Wilma','Jones','77483','499 Meadow Road,#192')")
    stopIfSqlNotOK(session, "insert into customer values(7818,'Mrs','Betty','Kaufman','76267','245 North Square,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7819,'Mr','Robert','Brown','77451','206 North Place,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7820,'Mr','Clarence','Gibbs','79503','285 Third Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7821,'Mr','Troy','Gallagher','78060','299 Railroad Blvd,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7822,'Mr','William','Matthews','00651','332 Ash Walk,#65')")
    stopIfSqlNotOK(session, "insert into customer values(7823,'Mrs','Kari','Williams','78570','236 Adams Street,#3')")
    stopIfSqlNotOK(session, "insert into customer values(7824,'Mr','Max','Clements','75127','79 Hill Street,#84')")
    stopIfSqlNotOK(session, "insert into customer values(7825,'Mr','Nathan','Taylor','10249','130 First Ave,#65')")
    stopIfSqlNotOK(session, "insert into customer values(7826,'Mr','Herbert','Johnson','94146','302 Oak Walk,#23')")
    stopIfSqlNotOK(session, "insert into customer values(7827,'Mr','John','Mccormick','01808','482 Lakeview St.,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7828,'Mr','James','Jones','76649','298 East Boulevard,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7829,'Mr','Dwight','Wilson','75975','23 Franklin Avenue,#178')")
    stopIfSqlNotOK(session, "insert into customer values(7830,'Mrs','Sandra','Williams','95971','203 Maple Place,#72')")
    stopIfSqlNotOK(session, "insert into customer values(7831,'Mrs','Shelly','Davis','10261','220 South Road,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7832,'Mr','Aaron','Brown','75253','306 Park Blvd,#188')")
    stopIfSqlNotOK(session, "insert into customer values(7833,'Mr','Charles','Morris','76890','474 Hill Ave,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7834,'Mr','Glen','Rice','11762','4 Elm Avenue,#63')")
    stopIfSqlNotOK(session, "insert into customer values(7835,'Mr','Charles','Parrish','76635','159 Hill Boulevard,#181')")
    stopIfSqlNotOK(session, "insert into customer values(7836,'Mr','Louis','Dejesus','60021','50 Adams Square,#87')")
    stopIfSqlNotOK(session, "insert into customer values(7837,'Mr','Gene','Weber','76855','303 Poplar Avenue,#137')")
    stopIfSqlNotOK(session, "insert into customer values(7838,'Mr','Richard','Berger','00752','349 Lakeview Square,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7839,'Mrs','Sharon','Ruiz','48886','464 Meadow Square,#161')")
    stopIfSqlNotOK(session, "insert into customer values(7840,'Mrs','Florine','Pratt','17032','193 Spruce Square,#155')")
    stopIfSqlNotOK(session, "insert into customer values(7841,'Mr','Mario','Joyner','75032','197 Broadway Blvd,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7842,'Mr','Jonathan','Potter','78661','454 Spring Lane,#63')")
    stopIfSqlNotOK(session, "insert into customer values(7843,'Mr','Robert','Jones','57719','122 Johnson Ave,#54')")
    stopIfSqlNotOK(session, "insert into customer values(7844,'Mrs','Patricia','Stanley','78940','274 Broadway St.,#175')")
    stopIfSqlNotOK(session, "insert into customer values(7845,'Mrs','Lindsay','Mcdonald','50124','451 Birch Parkway,#134')")
    stopIfSqlNotOK(session, "insert into customer values(7846,'Mrs','Patricia','Wilson','22035','334 Fourteenth Parkway,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7847,'Mrs','Ramona','Olson','56502','44 Sixth Place,#128')")
    stopIfSqlNotOK(session, "insert into customer values(7848,'Mrs','Betty','Moore','20608','488 Pine Walk,#76')")
    stopIfSqlNotOK(session, "insert into customer values(7849,'Mr','Terrence','Davis','76029','266 Johnson Walk,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7850,'Mrs','Alexandra','Taylor','76832','302 Maple Lane,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7851,'Mr','Michael','Wilson','75756','128 Franklin Boulevard,#91')")
    stopIfSqlNotOK(session, "insert into customer values(7852,'Mrs','Latasha','Taylor','75573','50 Eighth Ave,#13')")
    stopIfSqlNotOK(session, "insert into customer values(7853,'Mr','Luis','Williams','19093','160 Park Boulevard,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7854,'Mrs','Autumn','Wilson','76909','35 Davis Walk,#61')")
    stopIfSqlNotOK(session, "insert into customer values(7855,'Mrs','Susan','Miller','76845','136 Williams Road,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7856,'Mr','Joseph','Brown','62934','264 Hillcrest Lane,#153')")
    stopIfSqlNotOK(session, "insert into customer values(7857,'Mr','Thomas','Maynard','78159','74 Ninth Blvd,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7858,'Mrs','Mari','Burch','77328','127 Cherry Place,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7859,'Mrs','Betty','Guzman','60451','121 Fifteenth Lane,#24')")
    stopIfSqlNotOK(session, "insert into customer values(7860,'Mr','James','Wilson','76041','295 Poplar Avenue,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7861,'Mrs','Wendi','Richard','01929','258 Central Place,#96')")
    stopIfSqlNotOK(session, "insert into customer values(7862,'Mrs','Barbara','Lambert','76941','127 Lakeview Blvd,#65')")
    stopIfSqlNotOK(session, "insert into customer values(7863,'Mr','James','Blair','62601','99 Railroad Road,#39')")
    stopIfSqlNotOK(session, "insert into customer values(7864,'Mrs','Dorothy','Williams','46374','425 Miller Parkway,#44')")
    stopIfSqlNotOK(session, "insert into customer values(7865,'Mr','Henry','Thornton','78789','21 Miller Blvd,#65')")
    stopIfSqlNotOK(session, "insert into customer values(7866,'Mr','Thomas','Davis','79018','192 Lake Avenue,#174')")
    stopIfSqlNotOK(session, "insert into customer values(7867,'Mr','Roy','Smith','63841','205 Jackson Road,#118')")
    stopIfSqlNotOK(session, "insert into customer values(7868,'Mrs','Nancy','Wilson','78838','22 Ninth Parkway,#9')")
    stopIfSqlNotOK(session, "insert into customer values(7869,'Mr','Thomas','Dorsey','75116','226 South Avenue,#83')")
    stopIfSqlNotOK(session, "insert into customer values(7870,'Mrs','Susan','Johnson','75115','285 Main Street,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7871,'Mrs','Nancy','Taylor','15632','419 Valley Parkway,#68')")
    stopIfSqlNotOK(session, "insert into customer values(7872,'Mr','Charles','Doyle','75065','300 River Walk,#137')")
    stopIfSqlNotOK(session, "insert into customer values(7873,'Mrs','Jennifer','Taylor','01242','373 Eleventh Lane,#110')")
    stopIfSqlNotOK(session, "insert into customer values(7874,'Mr','Joseph','Shepard','31629','445 East Ave,#195')")
    stopIfSqlNotOK(session, "insert into customer values(7875,'Mr','Ron','Watts','00622','402 Seventh Boulevard,#186')")
    stopIfSqlNotOK(session, "insert into customer values(7876,'Mr','Jimmy','Davis','77534','123 West Blvd,#99')")
    stopIfSqlNotOK(session, "insert into customer values(7877,'Mrs','Jennifer','Jones','88008','156 Elm Place,#36')")
    stopIfSqlNotOK(session, "insert into customer values(7878,'Mrs','Betty','Greene','78609','215 Broadway St.,#130')")
    stopIfSqlNotOK(session, "insert into customer values(7879,'Mr','Sean','Smith','78949','21 Green Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(7880,'Mr','John','Taylor','78070','460 Lake Parkway,#98')")
    stopIfSqlNotOK(session, "insert into customer values(7881,'Mrs','Tasha','Johnson','75091','89 Tenth Walk,#25')")
    stopIfSqlNotOK(session, "insert into customer values(7882,'Mrs','Raquel','Miller','77367','28 Madison Walk,#189')")
    stopIfSqlNotOK(session, "insert into customer values(7883,'Mrs','Nancy','Williams','77376','111 Highland Walk,#59')")
    stopIfSqlNotOK(session, "insert into customer values(7884,'Mrs','Maritza','Hart','78614','30 River Street,#71')")
    stopIfSqlNotOK(session, "insert into customer values(7885,'Mrs','Delores','Taylor','76045','65 Green Ave,#187')")
    stopIfSqlNotOK(session, "insert into customer values(7886,'Mr','Thomas','Logan','75475','482 Valley Square,#178')")
    stopIfSqlNotOK(session, "insert into customer values(7887,'Mrs','Kari','Mack','12474','166 Green Drive,#121')")
    stopIfSqlNotOK(session, "insert into customer values(7888,'Mrs','Teresa','Mayer','81150','420 Cherry Street,#88')")
    stopIfSqlNotOK(session, "insert into customer values(7889,'Mrs','Patricia','Hobbs','94070','101 Mill Square,#90')")
    stopIfSqlNotOK(session, "insert into customer values(7890,'Mrs','Sandra','Moore','77461','477 Broadway Walk,#103')")
    stopIfSqlNotOK(session, "insert into customer values(7891,'Mr','Calvin','Williams','75846','293 Spring Drive,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7892,'Mrs','Caitlin','Davis','78063','128 Locust Drive,#53')")
    stopIfSqlNotOK(session, "insert into customer values(7893,'Mr','William','Golden','77561','177 Sunset Parkway,#118')")
    stopIfSqlNotOK(session, "insert into customer values(7894,'Mr','Martin','Smith','77623','232 East Place,#140')")
    stopIfSqlNotOK(session, "insert into customer values(7895,'Mr','Robert','Allison','75966','455 First Street,#199')")
    stopIfSqlNotOK(session, "insert into customer values(7896,'Mr','Brett','Smith','02332','26 Highland Boulevard,#72')")
    stopIfSqlNotOK(session, "insert into customer values(7897,'Mrs','Sandra','Robles','78044','452 Washington Parkway,#197')")
    stopIfSqlNotOK(session, "insert into customer values(7898,'Mr','Richard','Brown','00755','432 East Lane,#11')")
    stopIfSqlNotOK(session, "insert into customer values(7899,'Mrs','Jennifer','Brown','66528','97 Hill Place,#77')")
    stopIfSqlNotOK(session, "insert into customer values(7900,'Mrs','Sharon','Trevino','77546','273 Hill Ave,#170')")
    stopIfSqlNotOK(session, "insert into customer values(7901,'Mrs','Patricia','Wilson','75844','393 Lakeview Lane,#60')")
    stopIfSqlNotOK(session, "insert into customer values(7902,'Mrs','Fannie','Jones','87010','188 North Place,#33')")
    stopIfSqlNotOK(session, "insert into customer values(7903,'Mr','Thomas','Carson','16928','299 Ash Parkway,#177')")
    stopIfSqlNotOK(session, "insert into customer values(7904,'Mr','Robert','Davis','78674','365 Birch Ave,#42')")
    stopIfSqlNotOK(session, "insert into customer values(7905,'Mr','Jack','Miller','37909','372 Green Boulevard,#82')")
    stopIfSqlNotOK(session, "insert into customer values(7906,'Mrs','Irene','Smith','75447','485 Hillcrest Walk,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7907,'Mr','Scott','Moore','79519','59 Davis Road,#12')")
    stopIfSqlNotOK(session, "insert into customer values(7908,'Mr','Francisco','Wade','04224','310 Green Lane,#159')")
    stopIfSqlNotOK(session, "insert into customer values(7909,'Mrs','Cherry','Taylor','22021','405 Valley Blvd,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7910,'Mrs','Dorothy','Bradford','78605','232 Lakeview Road,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7911,'Mr','Franklin','Miller','79111','252 Highland Drive,#143')")
    stopIfSqlNotOK(session, "insert into customer values(7912,'Mrs','Betty','Johnson','87051','251 Smith Ave,#114')")
    stopIfSqlNotOK(session, "insert into customer values(7913,'Mr','Lewis','Andrews','40806','355 Oak Place,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7914,'Mrs','Patricia','Dyer','75449','435 Taylor Avenue,#21')")
    stopIfSqlNotOK(session, "insert into customer values(7915,'Mrs','Greta','Williams','78639','472 Twelfth Place,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7916,'Mrs','Rosemary','Davis','16027','284 Fifteenth Blvd,#111')")
    stopIfSqlNotOK(session, "insert into customer values(7917,'Mrs','Patricia','Hawkins','17056','146 Cherry Place,#185')")
    stopIfSqlNotOK(session, "insert into customer values(7918,'Mrs','Betty','Smith','76466','303 Williams Street,#105')")
    stopIfSqlNotOK(session, "insert into customer values(7919,'Mr','Robert','Gomez','77984','378 Woodland Square,#152')")
    stopIfSqlNotOK(session, "insert into customer values(7920,'Mr','David','Brown','75474','326 Hillcrest Ave,#11')")
    stopIfSqlNotOK(session, "insert into customer values(7921,'Mr','Kurt','Davis','79046','173 Dogwood Drive,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7922,'Mrs','Sandra','Campbell','76664','467 Woodland Drive,#39')")
    stopIfSqlNotOK(session, "insert into customer values(7923,'Mrs','Cora','Herman','50138','388 First Parkway,#140')")
    stopIfSqlNotOK(session, "insert into customer values(7924,'Mrs','Betty','Bean','81152','222 Johnson Avenue,#53')")
    stopIfSqlNotOK(session, "insert into customer values(7925,'Mr','Michael','Potts','75059','40 Main Boulevard,#85')")
    stopIfSqlNotOK(session, "insert into customer values(7926,'Mrs','Morgan','Jones','79314','110 Broadway St.,#56')")
    stopIfSqlNotOK(session, "insert into customer values(7927,'Mrs','Ester','Jones','16670','233 River Walk,#145')")
    stopIfSqlNotOK(session, "insert into customer values(7928,'Mr','Johnnie','Johnson','78050','26 Cherry Boulevard,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7929,'Mr','Richard','Williams','78644','342 Seventh Lane,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7930,'Mr','Michael','Davis','76185','8 Fourth Square,#5')")
    stopIfSqlNotOK(session, "insert into customer values(7931,'Mrs','Carol','Taylor','77422','267 Sunset Square,#107')")
    stopIfSqlNotOK(session, "insert into customer values(7932,'Mr','Richard','Miller','78593','278 Smith Blvd,#50')")
    stopIfSqlNotOK(session, "insert into customer values(7933,'Mr','William','Miller','79719','200 Wilson Walk,#149')")
    stopIfSqlNotOK(session, "insert into customer values(7934,'Mr','Christian','Smith','92253','141 Oak St.,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7935,'Mr','William','Brown','76859','57 Lincoln Square,#161')")
    stopIfSqlNotOK(session, "insert into customer values(7936,'Mr','Shawn','Pate','66761','448 Laurel Blvd,#46')")
    stopIfSqlNotOK(session, "insert into customer values(7937,'Mrs','Essie','Johnson','76518','263 Main St.,#83')")
    stopIfSqlNotOK(session, "insert into customer values(7938,'Mr','Chester','Wilson','16232','442 Davis Drive,#107')")
    stopIfSqlNotOK(session, "insert into customer values(7939,'Mr','Lee','Chapman','78873','419 Cherry Road,#132')")
    stopIfSqlNotOK(session, "insert into customer values(7940,'Mr','George','Mercer','57775','240 West Parkway,#74')")
    stopIfSqlNotOK(session, "insert into customer values(7941,'Mrs','Sandra','Wilson','74943','25 River Place,#57')")
    stopIfSqlNotOK(session, "insert into customer values(7942,'Mrs','Wilda','Stein','75555','26 Taylor Square,#137')")
    stopIfSqlNotOK(session, "insert into customer values(7943,'Mr','James','Johnson','75426','33 Oak Avenue,#166')")
    stopIfSqlNotOK(session, "insert into customer values(7944,'Mrs','Lucinda','Stark','79252','340 Meadow St.,#190')")
    stopIfSqlNotOK(session, "insert into customer values(7945,'Mrs','Johanna','Williamson','79516','393 Poplar Road,#75')")
    stopIfSqlNotOK(session, "insert into customer values(7946,'Mrs','Tracy','Randolph','87176','282 Lake Street,#1')")
    stopIfSqlNotOK(session, "insert into customer values(7947,'Mrs','Sharon','Johnson','98256','211 West Parkway,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7948,'Mrs','Francine','Johnson','77836','25 Spring Avenue,#79')")
    stopIfSqlNotOK(session, "insert into customer values(7949,'Mr','William','Smith','17959','10 Hillcrest Lane,#62')")
    stopIfSqlNotOK(session, "insert into customer values(7950,'Mrs','Caroline','Miller','79245','284 Dogwood Boulevard,#168')")
    stopIfSqlNotOK(session, "insert into customer values(7951,'Mr','Steven','Wilson','79547','379 Second Boulevard,#80')")
    stopIfSqlNotOK(session, "insert into customer values(7952,'Mrs','Bernice','Haney','79258','59 Fourth Blvd,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7953,'Mr','John','Taylor','78947','116 College Road,#51')")
    stopIfSqlNotOK(session, "insert into customer values(7954,'Mr','Ronald','Taylor','75005','439 Lee Lane,#108')")
    stopIfSqlNotOK(session, "insert into customer values(7955,'Mrs','Betty','Farmer','78961','228 Fourth Ave,#143')")
    stopIfSqlNotOK(session, "insert into customer values(7956,'Mrs','Sandra','Davis','75418','208 Ash Avenue,#195')")
    stopIfSqlNotOK(session, "insert into customer values(7957,'Mrs','Sandra','Sheppard','78641','158 Seventh Lane,#179')")
    stopIfSqlNotOK(session, "insert into customer values(7958,'Mr','Richard','Davis','24360','248 Ash Blvd,#4')")
    stopIfSqlNotOK(session, "insert into customer values(7959,'Mrs','Dorothy','Williams','79032','160 Center Road,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7960,'Mrs','Sharon','Contreras','76855','161 Cherry Parkway,#112')")
    stopIfSqlNotOK(session, "insert into customer values(7961,'Mr','John','Eaton','08072','68 Locust Lane,#35')")
    stopIfSqlNotOK(session, "insert into customer values(7962,'Mrs','Holly','Holcomb','79364','302 Johnson Lane,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7963,'Mr','Robert','Williams','88048','383 Sunset Walk,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7964,'Mrs','Nancy','Brown','29827','275 Taylor Avenue,#49')")
    stopIfSqlNotOK(session, "insert into customer values(7965,'Mr','George','Jones','95543','202 Sunset Walk,#199')")
    stopIfSqlNotOK(session, "insert into customer values(7966,'Mrs','Ellen','Jones','75642','186 Lincoln Drive,#72')")
    stopIfSqlNotOK(session, "insert into customer values(7967,'Mrs','Mamie','Jones','78340','157 Oak Blvd,#170')")
    stopIfSqlNotOK(session, "insert into customer values(7968,'Mr','Phillip','Brown','78545','495 Woodland Place,#110')")
    stopIfSqlNotOK(session, "insert into customer values(7969,'Mr','John','Savage','78054','462 Madison Lane,#56')")
    stopIfSqlNotOK(session, "insert into customer values(7970,'Mr','Floyd','Johnson','81134','344 Smith Ave,#190')")
    stopIfSqlNotOK(session, "insert into customer values(7971,'Mr','Anthony','Miller','76443','127 Walnut Square,#186')")
    stopIfSqlNotOK(session, "insert into customer values(7972,'Mr','Wayne','Garza','77376','445 Laurel Boulevard,#28')")
    stopIfSqlNotOK(session, "insert into customer values(7973,'Mr','Michael','Williams','76643','461 Johnson Road,#32')")
    stopIfSqlNotOK(session, "insert into customer values(7974,'Mrs','Louisa','Calderon','75507','488 Johnson Avenue,#78')")
    stopIfSqlNotOK(session, "insert into customer values(7975,'Mr','John','Davis','78632','251 Church Road,#15')")
    stopIfSqlNotOK(session, "insert into customer values(7976,'Mrs','Meredith','Jones','10185','28 Center Place,#134')")
    stopIfSqlNotOK(session, "insert into customer values(7977,'Mr','Everett','Jones','77995','99 Fourth Blvd,#122')")
    stopIfSqlNotOK(session, "insert into customer values(7978,'Mr','Charles','Williams','33441','469 Woodland Street,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7979,'Mrs','Jeanine','Wilson','37374','395 Williams Blvd,#32')")
    stopIfSqlNotOK(session, "insert into customer values(7980,'Mrs','Rosalind','Welch','78572','120 Second Boulevard,#6')")
    stopIfSqlNotOK(session, "insert into customer values(7981,'Mrs','Laurie','Wilson','77481','130 Oak Avenue,#172')")
    stopIfSqlNotOK(session, "insert into customer values(7982,'Mr','Kyle','Gibbs','78774','473 Fifteenth St.,#81')")
    stopIfSqlNotOK(session, "insert into customer values(7983,'Mrs','Glenda','Davis','87050','301 Forest Lane,#123')")
    stopIfSqlNotOK(session, "insert into customer values(7984,'Mr','William','Williams','93150','491 Madison Parkway,#106')")
    stopIfSqlNotOK(session, "insert into customer values(7985,'Mr','Darryl','Williams','76240','254 Woodland Walk,#38')")
    stopIfSqlNotOK(session, "insert into customer values(7986,'Mr','Wade','Smith','10261','134 Forest Walk,#110')")
    stopIfSqlNotOK(session, "insert into customer values(7987,'Mr','Dan','Mueller','75441','201 Church Road,#104')")
    stopIfSqlNotOK(session, "insert into customer values(7988,'Mrs','Sandra','Davis','78962','408 Spruce Square,#41')")
    stopIfSqlNotOK(session, "insert into customer values(7989,'Mr','Alex','Williams','78575','340 Seventh Drive,#194')")
    stopIfSqlNotOK(session, "insert into customer values(7990,'Mr','Felix','Mcintyre','75770','494 Wilson Street,#138')")
    stopIfSqlNotOK(session, "insert into customer values(7991,'Mrs','Elsie','Smith','79056','181 Davis Blvd,#67')")
    stopIfSqlNotOK(session, "insert into customer values(7992,'Mrs','Guadalupe','Rivera','45381','218 Washington Square,#156')")
    stopIfSqlNotOK(session, "insert into customer values(7993,'Mr','David','Brown','75847','453 Broadway St.,#20')")
    stopIfSqlNotOK(session, "insert into customer values(7994,'Mr','Freddie','Howe','60102','220 Railroad Drive,#17')")
    stopIfSqlNotOK(session, "insert into customer values(7995,'Mrs','Sharon','Ferrell','17860','348 Pine Blvd,#64')")
    stopIfSqlNotOK(session, "insert into customer values(7996,'Mrs','Teri','Miller','35648','41 College St.,#192')")
    stopIfSqlNotOK(session, "insert into customer values(7997,'Mrs','Marcia','Taylor','07440','135 First Walk,#169')")
    stopIfSqlNotOK(session, "insert into customer values(7998,'Mr','Charles','Jimenez','79738','380 Highland Lane,#45')")
    stopIfSqlNotOK(session, "insert into customer values(7999,'Mr','Jeffrey','Davis','79261','27 Lee Drive,#158')")
    stopIfSqlNotOK(session, "insert into customer values(8000,'Mr','Edgar','Bridges','75444','296 Adams Street,#40')")
    stopIfSqlNotOK(session, "insert into customer values(8001,'Mr','Joseph','Jones','30267','252 Eighth Drive,#17')")
    stopIfSqlNotOK(session, "insert into customer values(8002,'Mr','Robert','Wilson','76852','414 Dogwood Boulevard,#14')")
    stopIfSqlNotOK(session, "insert into customer values(8003,'Mr','Darryl','Johns','78347','46 Central Ave,#54')")
    stopIfSqlNotOK(session, "insert into customer values(8004,'Mr','Melvin','Wilson','76671','453 Elm Road,#77')")
    stopIfSqlNotOK(session, "insert into customer values(8005,'Mr','Harry','Barber','76058','349 Poplar Avenue,#175')")
    stopIfSqlNotOK(session, "insert into customer values(8006,'Mrs','Dorothy','Davis','00742','359 Jefferson Drive,#68')")
    stopIfSqlNotOK(session, "insert into customer values(8007,'Mr','David','Calderon','83534','63 Willow Drive,#162')")
    stopIfSqlNotOK(session, "insert into customer values(8008,'Mr','Joseph','Franks','10178','447 Locust St.,#160')")
    stopIfSqlNotOK(session, "insert into customer values(8009,'Mr','Christian','Miller','75141','124 River Street,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8010,'Mrs','Nancy','Miller','75258','489 Third Parkway,#42')")
    stopIfSqlNotOK(session, "insert into customer values(8011,'Mr','William','Lane','78885','385 Cedar Place,#129')")
    stopIfSqlNotOK(session, "insert into customer values(8012,'Mr','William','Davis','76054','454 Locust Avenue,#140')")
    stopIfSqlNotOK(session, "insert into customer values(8013,'Mr','Michael','Lindsey','77440','233 Pine Street,#18')")
    stopIfSqlNotOK(session, "insert into customer values(8014,'Mrs','Carol','Jones','78582','27 Adams Square,#66')")
    stopIfSqlNotOK(session, "insert into customer values(8015,'Mrs','Pearlie','Erickson','10099','53 Jefferson Blvd,#47')")
    stopIfSqlNotOK(session, "insert into customer values(8016,'Mr','Brandon','Taylor','97486','497 Jefferson Ave,#70')")
    stopIfSqlNotOK(session, "insert into customer values(8017,'Mrs','Carol','Peters','78830','468 Jefferson Lane,#157')")
    stopIfSqlNotOK(session, "insert into customer values(8018,'Mr','Clifford','Johnson','75943','203 Taylor St.,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8019,'Mrs','Lauren','Sutton','75418','485 Pine Drive,#119')")
    stopIfSqlNotOK(session, "insert into customer values(8020,'Mrs','Shelly','Livingston','75003','491 Ridge Walk,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8021,'Mr','Javier','Moore','16611','449 Poplar Ave,#9')")
    stopIfSqlNotOK(session, "insert into customer values(8022,'Mrs','Angelica','Bentley','77579','469 Center Blvd,#113')")
    stopIfSqlNotOK(session, "insert into customer values(8023,'Mr','Terrence','Mcintyre','76035','320 College Walk,#99')")
    stopIfSqlNotOK(session, "insert into customer values(8024,'Mrs','Melanie','Giles','79758','294 Lakeview Avenue,#172')")
    stopIfSqlNotOK(session, "insert into customer values(8025,'Mrs','Susan','Jones','97624','350 North Boulevard,#49')")
    stopIfSqlNotOK(session, "insert into customer values(8026,'Mrs','Tamika','Jones','77976','22 Valley Walk,#66')")
    stopIfSqlNotOK(session, "insert into customer values(8027,'Mrs','Patricia','Jackson','79464','266 Meadow Boulevard,#79')")
    stopIfSqlNotOK(session, "insert into customer values(8028,'Mrs','Trina','Davis','58371','191 Pine Boulevard,#13')")
    stopIfSqlNotOK(session, "insert into customer values(8029,'Mrs','Erika','Wilson','75862','385 South Blvd,#83')")
    stopIfSqlNotOK(session, "insert into customer values(8030,'Mrs','Tracie','Davis','76538','306 Fourteenth St.,#27')")
    stopIfSqlNotOK(session, "insert into customer values(8031,'Mrs','Sandra','Miller','75141','90 Pine Drive,#51')")
    stopIfSqlNotOK(session, "insert into customer values(8032,'Mr','Sergio','Mercado','78558','387 Park Boulevard,#118')")
    stopIfSqlNotOK(session, "insert into customer values(8033,'Mrs','Betty','Williams','78568','126 Ridge Avenue,#134')")
    stopIfSqlNotOK(session, "insert into customer values(8034,'Mrs','Bernice','Johnson','93118','481 Madison Blvd,#140')")
    stopIfSqlNotOK(session, "insert into customer values(8035,'Mr','John','Moore','78640','306 Chestnut Ave,#80')")
    stopIfSqlNotOK(session, "insert into customer values(8036,'Mr','Rick','Powell','79096','475 Lake Road,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8037,'Mrs','Corinne','Moore','76436','264 Cherry Drive,#158')")
    stopIfSqlNotOK(session, "insert into customer values(8038,'Mrs','Susan','Miller','76861','122 Elm Ave,#20')")
    stopIfSqlNotOK(session, "insert into customer values(8039,'Mrs','Nancy','Wall','78376','332 Washington Square,#184')")
    stopIfSqlNotOK(session, "insert into customer values(8040,'Mrs','Christi','Wilson','78124','244 Ninth St.,#125')")
    stopIfSqlNotOK(session, "insert into customer values(8041,'Mr','Richard','Jones','78613','273 Second Blvd,#108')")
    stopIfSqlNotOK(session, "insert into customer values(8042,'Mr','Jeffery','Moore','79090','254 Hillcrest Parkway,#45')")
    stopIfSqlNotOK(session, "insert into customer values(8043,'Mrs','Dorothy','Davis','76570','40 Johnson Avenue,#168')")
    stopIfSqlNotOK(session, "insert into customer values(8044,'Mr','Michael','Brown','76374','459 Spring Walk,#185')")
    stopIfSqlNotOK(session, "insert into customer values(8045,'Mr','David','Bryan','78001','405 Eleventh Ave,#16')")
    stopIfSqlNotOK(session, "insert into customer values(8046,'Mrs','Sandra','Flowers','75644','338 Eighth Place,#77')")
    stopIfSqlNotOK(session, "insert into customer values(8047,'Mrs','Lesa','Miller','76888','315 South Ave,#158')")
    stopIfSqlNotOK(session, "insert into customer values(8048,'Mr','Casey','Jones','76028','226 Lake Ave,#69')")
    stopIfSqlNotOK(session, "insert into customer values(8049,'Mr','Dustin','Martinez','75972','406 Davis Avenue,#129')")
    stopIfSqlNotOK(session, "insert into customer values(8050,'Mr','Thomas','Simpson','75019','164 Sycamore Lane,#33')")
    stopIfSqlNotOK(session, "insert into customer values(8051,'Mrs','Sandra','Wilson','76648','417 River Lane,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8052,'Mr','Thomas','Wilson','78013','140 Mill St.,#33')")
    stopIfSqlNotOK(session, "insert into customer values(8053,'Mr','Charles','Smith','62832','434 Park Boulevard,#176')")
    stopIfSqlNotOK(session, "insert into customer values(8054,'Mrs','Marion','Williams','76024','149 Oak Street,#145')")
    stopIfSqlNotOK(session, "insert into customer values(8055,'Mr','Jimmy','Smith','78933','104 Green Ave,#149')")
    stopIfSqlNotOK(session, "insert into customer values(8056,'Mr','Joseph','Smith','79512','405 Eighth Place,#111')")
    stopIfSqlNotOK(session, "insert into customer values(8057,'Mrs','Jennifer','Deleon','77284','407 Spring Drive,#130')")
    stopIfSqlNotOK(session, "insert into customer values(8058,'Mr','Richard','Sherman','54559','42 Ninth Place,#88')")
    stopIfSqlNotOK(session, "insert into customer values(8059,'Mrs','Lora','Meyer','75759','266 Franklin Avenue,#37')")
    stopIfSqlNotOK(session, "insert into customer values(8060,'Mr','Raymond','Jones','77435','275 Green St.,#90')")
    stopIfSqlNotOK(session, "insert into customer values(8061,'Mrs','Lorena','Wilson','77337','417 Hill St.,#101')")
    stopIfSqlNotOK(session, "insert into customer values(8062,'Mr','Dan','Crosby','77988','41 Cherry Boulevard,#131')")
    stopIfSqlNotOK(session, "insert into customer values(8063,'Mr','Jerome','Todd','78065','190 Williams Ave,#3')")
    stopIfSqlNotOK(session, "insert into customer values(8064,'Mr','Ken','Bowen','95142','449 Elm Ave,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8065,'Mrs','Joan','Cleveland','12051','424 Woodland Street,#96')")
    stopIfSqlNotOK(session, "insert into customer values(8066,'Mrs','Barbara','Abbott','24360','244 Williams Ave,#87')")
    stopIfSqlNotOK(session, "insert into customer values(8067,'Mr','Clifton','Taylor','87192','375 Fifteenth Walk,#104')")
    stopIfSqlNotOK(session, "insert into customer values(8068,'Mr','Randy','Williams','79248','156 Ash Place,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8069,'Mr','George','Miller','77213','419 Smith Square,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8070,'Mr','Andre','Patton','75002','75 Church Place,#45')")
    stopIfSqlNotOK(session, "insert into customer values(8071,'Mr','Charles','Johnson','78347','427 Main Place,#127')")
    stopIfSqlNotOK(session, "insert into customer values(8072,'Mr','Curtis','Davis','63373','476 Broadway Place,#22')")
    stopIfSqlNotOK(session, "insert into customer values(8073,'Mr','Alan','Moore','77546','161 Third Lane,#15')")
    stopIfSqlNotOK(session, "insert into customer values(8074,'Mr','Eugene','Johnson','76030','428 Forest Square,#47')")
    stopIfSqlNotOK(session, "insert into customer values(8075,'Mr','John','Luna','78349','65 Spring Lane,#60')")
    stopIfSqlNotOK(session, "insert into customer values(8076,'Mrs','Susan','Kaufman','79096','94 Locust Avenue,#37')")
    stopIfSqlNotOK(session, "insert into customer values(8077,'Mrs','Latonya','Becker','79608','467 Church Walk,#62')")
    stopIfSqlNotOK(session, "insert into customer values(8078,'Mr','Victor','Smith','73540','37 Ninth Parkway,#193')")
    stopIfSqlNotOK(session, "insert into customer values(8079,'Mrs','Jasmine','Williams','97835','263 Center Walk,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8080,'Mrs','Morgan','Rosario','75943','129 Ridge Blvd,#199')")
    stopIfSqlNotOK(session, "insert into customer values(8081,'Mrs','Betty','Taylor','30267','312 Valley Square,#160')")
    stopIfSqlNotOK(session, "insert into customer values(8082,'Mrs','Adeline','Brown','75444','474 Jefferson Road,#146')")
    stopIfSqlNotOK(session, "insert into customer values(8083,'Mr','Nicholas','Wall','76469','220 Madison Road,#136')")
    stopIfSqlNotOK(session, "insert into customer values(8084,'Mr','Rick','Rutledge','91778','176 Locust Street,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8085,'Mrs','Letitia','Whitehead','75969','99 Cherry Avenue,#127')")
    stopIfSqlNotOK(session, "insert into customer values(8086,'Mrs','Betty','Moore','78145','214 Central Walk,#82')")
    stopIfSqlNotOK(session, "insert into customer values(8087,'Mrs','Christi','Saunders','89199','290 Valley Drive,#26')")
    stopIfSqlNotOK(session, "insert into customer values(8088,'Mr','Charles','Wilson','77856','46 North Blvd,#133')")
    stopIfSqlNotOK(session, "insert into customer values(8089,'Mrs','Jamie','Mills','75004','415 Seventh Blvd,#112')")
    stopIfSqlNotOK(session, "insert into customer values(8090,'Mr','William','Bartlett','75778','89 Laurel Blvd,#196')")
    stopIfSqlNotOK(session, "insert into customer values(8091,'Mrs','Susan','Armstrong','77856','104 Pine Walk,#105')")
    stopIfSqlNotOK(session, "insert into customer values(8092,'Mrs','Gwendolyn','Wilson','77541','362 Green Drive,#54')")
    stopIfSqlNotOK(session, "insert into customer values(8093,'Mrs','Carol','Snow','77870','450 Willow Street,#143')")
    stopIfSqlNotOK(session, "insert into customer values(8094,'Mr','Jose','Miller','71307','197 Washington St.,#131')")
    stopIfSqlNotOK(session, "insert into customer values(8095,'Mr','Joseph','Davis','87565','5 Ridge Parkway,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8096,'Mrs','Autumn','Wilson','61753','322 Lee Lane,#179')")
    stopIfSqlNotOK(session, "insert into customer values(8097,'Mrs','Carol','Miller','63841','441 Davis Drive,#109')")
    stopIfSqlNotOK(session, "insert into customer values(8098,'Mrs','Barbara','Taylor','95620','8 Birch Street,#31')")
    stopIfSqlNotOK(session, "insert into customer values(8099,'Mr','Thomas','Taylor','76061','147 Franklin Parkway,#103')")
    stopIfSqlNotOK(session, "insert into customer values(8100,'Mr','David','Berg','78140','231 Thirteenth Blvd,#107')")
    stopIfSqlNotOK(session, "insert into customer values(8101,'Mrs','Barbara','Conley','77972','177 North Square,#76')")
    stopIfSqlNotOK(session, "insert into customer values(8102,'Mr','Joel','Molina','78861','43 Fifteenth Road,#22')")
    stopIfSqlNotOK(session, "insert into customer values(8103,'Mrs','Betty','Savage','76311','40 Ash Place,#153')")
    stopIfSqlNotOK(session, "insert into customer values(8104,'Mrs','Sharon','Brown','76842','410 Cherry Avenue,#81')")
    stopIfSqlNotOK(session, "insert into customer values(8105,'Mr','Felix','Johnson','77879','345 Lakeview Boulevard,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8106,'Mrs','Nancy','Smith','79364','374 North Place,#53')")
    stopIfSqlNotOK(session, "insert into customer values(8107,'Mr','John','Gaines','78828','4 Highland Place,#135')")
    stopIfSqlNotOK(session, "insert into customer values(8108,'Mrs','Wilma','Miller','76228','444 Miller Boulevard,#48')")
    stopIfSqlNotOK(session, "insert into customer values(8109,'Mr','Jeffery','Wilson','11762','2 Lincoln Ave,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8110,'Mr','Robert','Wilson','95055','25 Green Avenue,#14')")
    stopIfSqlNotOK(session, "insert into customer values(8111,'Mrs','Patricia','Brown','41764','444 Meadow Street,#34')")
    stopIfSqlNotOK(session, "insert into customer values(8112,'Mrs','Thelma','Wilson','27233','463 Hill St.,#93')")
    stopIfSqlNotOK(session, "insert into customer values(8113,'Mr','William','Burris','47138','117 Highland Ave,#91')")
    stopIfSqlNotOK(session, "insert into customer values(8114,'Mr','Mark','Taylor','78159','224 Maple Street,#65')")
    stopIfSqlNotOK(session, "insert into customer values(8115,'Mr','Marshall','Tate','77629','488 Sunset Ave,#193')")
    stopIfSqlNotOK(session, "insert into customer values(8116,'Mr','John','Parsons','77882','199 Pine Road,#118')")
    stopIfSqlNotOK(session, "insert into customer values(8117,'Mrs','Marisol','Miller','74561','419 Chestnut Boulevard,#182')")
    stopIfSqlNotOK(session, "insert into customer values(8118,'Mr','Michael','Garrison','77631','251 Ninth Square,#85')")
    stopIfSqlNotOK(session, "insert into customer values(8119,'Mr','Thomas','Williams','87574','109 Elm Square,#88')")
    stopIfSqlNotOK(session, "insert into customer values(8120,'Mr','Joseph','Bryan','28619','446 Spring Walk,#174')")
    stopIfSqlNotOK(session, "insert into customer values(8121,'Mrs','Patricia','Smith','77880','15 Hill Walk,#161')")
    stopIfSqlNotOK(session, "insert into customer values(8122,'Mrs','Tammi','Smith','78053','130 Adams Boulevard,#53')")
    stopIfSqlNotOK(session, "insert into customer values(8123,'Mrs','Jennifer','Johnson','56472','496 Madison Boulevard,#131')")
    stopIfSqlNotOK(session, "insert into customer values(8124,'Mr','William','Ashley','94904','3 East Parkway,#96')")
    stopIfSqlNotOK(session, "insert into customer values(8125,'Mrs','Dorothy','Taylor','50076','94 West Blvd,#89')")
    stopIfSqlNotOK(session, "insert into customer values(8126,'Mr','Theodore','Frye','75110','61 Johnson Drive,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8127,'Mr','David','Goodwin','98376','437 Fourteenth Lane,#137')")
    stopIfSqlNotOK(session, "insert into customer values(8128,'Mrs','Tricia','Taylor','65459','25 First Drive,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8129,'Mrs','Bobbie','Taylor','77835','302 Hickory Boulevard,#63')")
    stopIfSqlNotOK(session, "insert into customer values(8130,'Mrs','Patricia','Wilson','15847','365 Seventh Boulevard,#68')")
    stopIfSqlNotOK(session, "insert into customer values(8131,'Mrs','Carol','Jones','75482','120 Hillcrest Ave,#195')")
    stopIfSqlNotOK(session, "insert into customer values(8132,'Mrs','Betty','Moore','94583','397 Johnson Blvd,#145')")
    stopIfSqlNotOK(session, "insert into customer values(8133,'Mrs','Jenny','Brown','76038','96 Lake Blvd,#83')")
    stopIfSqlNotOK(session, "insert into customer values(8134,'Mrs','Betty','Brown','78025','429 Thirteenth Lane,#89')")
    stopIfSqlNotOK(session, "insert into customer values(8135,'Mr','Thomas','Rivas','82323','362 Franklin St.,#172')")
    stopIfSqlNotOK(session, "insert into customer values(8136,'Mr','Joel','Davis','49720','95 Broadway Drive,#152')")
    stopIfSqlNotOK(session, "insert into customer values(8137,'Mrs','Kerri','Moore','79003','305 Taylor Street,#34')")
    stopIfSqlNotOK(session, "insert into customer values(8138,'Mrs','Sonia','Brown','61334','109 Oak Blvd,#136')")
    stopIfSqlNotOK(session, "insert into customer values(8139,'Mr','William','Dorsey','76873','240 Lake Avenue,#73')")
    stopIfSqlNotOK(session, "insert into customer values(8140,'Mr','Richard','Allison','75148','97 Pine Avenue,#51')")
    stopIfSqlNotOK(session, "insert into customer values(8141,'Mrs','Emma','Stark','41348','496 Ninth Place,#91')")
    stopIfSqlNotOK(session, "insert into customer values(8142,'Mrs','Diann','Finch','78364','186 Walnut Square,#148')")
    stopIfSqlNotOK(session, "insert into customer values(8143,'Mrs','Barbara','Erickson','79354','271 Thirteenth Drive,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8144,'Mrs','Betty','Nichols','78620','292 Poplar St.,#29')")
    stopIfSqlNotOK(session, "insert into customer values(8145,'Mrs','Rachelle','Campbell','24957','37 Railroad Parkway,#107')")
    stopIfSqlNotOK(session, "insert into customer values(8146,'Mr','Joseph','Ochoa','36505','475 Park St.,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8147,'Mr','Alexander','Nielsen','62601','30 South Drive,#81')")
    stopIfSqlNotOK(session, "insert into customer values(8148,'Mr','Ruben','Moore','75651','348 Central Place,#32')")
    stopIfSqlNotOK(session, "insert into customer values(8149,'Mr','James','Wright','22320','83 Locust Drive,#78')")
    stopIfSqlNotOK(session, "insert into customer values(8150,'Mrs','Lesley','Austin','78343','77 Railroad Lane,#64')")
    stopIfSqlNotOK(session, "insert into customer values(8151,'Mr','Mitchell','Henson','78140','431 East Boulevard,#81')")
    stopIfSqlNotOK(session, "insert into customer values(8152,'Mrs','Carol','Taylor','35059','356 Mill Boulevard,#75')")
    stopIfSqlNotOK(session, "insert into customer values(8153,'Mrs','Susan','Johnson','78950','367 Fifth Blvd,#63')")
    stopIfSqlNotOK(session, "insert into customer values(8154,'Mr','Chad','Fitzpatrick','76071','327 Eleventh Drive,#195')")
    stopIfSqlNotOK(session, "insert into customer values(8155,'Mrs','Dorothy','Smith','57311','453 Center Drive,#19')")
    stopIfSqlNotOK(session, "insert into customer values(8156,'Mrs','Nancy','Johnson','17946','43 Williams Boulevard,#106')")
    stopIfSqlNotOK(session, "insert into customer values(8157,'Mrs','Barbara','Moore','87567','290 South Ave,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8158,'Mr','David','Bass','77831','262 Hill Place,#96')")
    stopIfSqlNotOK(session, "insert into customer values(8159,'Mr','Floyd','Mosley','76435','206 First Drive,#192')")
    stopIfSqlNotOK(session, "insert into customer values(8160,'Mrs','Jennifer','Taylor','27872','359 Fourteenth Lane,#36')")
    stopIfSqlNotOK(session, "insert into customer values(8161,'Mr','William','Wilson','91322','447 Broadway Place,#84')")
    stopIfSqlNotOK(session, "insert into customer values(8162,'Mr','Joseph','Johnson','79226','122 Main Place,#126')")
    stopIfSqlNotOK(session, "insert into customer values(8163,'Mrs','Dorothy','Jennings','33576','18 Laurel Parkway,#174')")
    stopIfSqlNotOK(session, "insert into customer values(8164,'Mr','Corey','Aguirre','24174','441 Madison Parkway,#166')")
    stopIfSqlNotOK(session, "insert into customer values(8165,'Mr','Manuel','Fitzgerald','75750','297 Fifth Boulevard,#27')")
    stopIfSqlNotOK(session, "insert into customer values(8166,'Mr','Seth','Miller','75450','155 Ninth Lane,#189')")
    stopIfSqlNotOK(session, "insert into customer values(8167,'Mrs','Susan','Stanley','76251','118 Eighth Avenue,#10')")
    stopIfSqlNotOK(session, "insert into customer values(8168,'Mrs','Reyna','Wilson','04257','135 Wilson Parkway,#74')")
    stopIfSqlNotOK(session, "insert into customer values(8169,'Mrs','Ashlee','Williams','75660','397 Third Drive,#194')")
    stopIfSqlNotOK(session, "insert into customer values(8170,'Mr','Joe','Wall','04257','332 Woodland Ave,#104')")
    stopIfSqlNotOK(session, "insert into customer values(8171,'Mrs','Nancy','Mcmillan','78280','430 Oak Walk,#104')")
    stopIfSqlNotOK(session, "insert into customer values(8172,'Mr','John','Noble','94964','100 Miller St.,#180')")
    stopIfSqlNotOK(session, "insert into customer values(8173,'Mr','William','Tanner','76527','353 Forest Parkway,#25')")
    stopIfSqlNotOK(session, "insert into customer values(8174,'Mrs','Barbara','Davis','79506','35 Forest Street,#155')")
    stopIfSqlNotOK(session, "insert into customer values(8175,'Mrs','Nancy','Brown','94974','71 Valley Lane,#175')")
    stopIfSqlNotOK(session, "insert into customer values(8176,'Mr','Robert','Johnson','77428','107 Laurel Parkway,#121')")
    stopIfSqlNotOK(session, "insert into customer values(8177,'Mr','Ron','Owens','62832','342 Maple Boulevard,#63')")
    stopIfSqlNotOK(session, "insert into customer values(8178,'Mr','Joseph','Johnson','88434','186 Wilson Street,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8179,'Mr','Norman','Gilliam','77519','149 Taylor Avenue,#47')")
    stopIfSqlNotOK(session, "insert into customer values(8180,'Mr','Leo','Williams','77372','456 Walnut Square,#88')")
    stopIfSqlNotOK(session, "insert into customer values(8181,'Mr','Danny','Moore','67753','130 Third Place,#53')")
    stopIfSqlNotOK(session, "insert into customer values(8182,'Mrs','Kim','Davis','79313','115 Johnson Parkway,#101')")
    stopIfSqlNotOK(session, "insert into customer values(8183,'Mrs','Betty','Hammond','77850','477 Tenth Place,#12')")
    stopIfSqlNotOK(session, "insert into customer values(8184,'Mrs','Jennifer','Jones','77335','109 Hillcrest Place,#66')")
    stopIfSqlNotOK(session, "insert into customer values(8185,'Mrs','Nancy','Williams','78597','270 Adams Square,#105')")
    stopIfSqlNotOK(session, "insert into customer values(8186,'Mr','Virgil','Wynn','75104','393 Pine Square,#158')")
    stopIfSqlNotOK(session, "insert into customer values(8187,'Mrs','Meghan','Farrell','52254','144 Taylor Parkway,#90')")
    stopIfSqlNotOK(session, "insert into customer values(8188,'Mr','William','Brown','76263','409 Jackson Avenue,#4')")
    stopIfSqlNotOK(session, "insert into customer values(8189,'Mr','Lawrence','Johnson','75642','445 Broadway Parkway,#158')")
    stopIfSqlNotOK(session, "insert into customer values(8190,'Mr','Jessie','Fowler','61753','196 Woodland Drive,#68')")
    stopIfSqlNotOK(session, "insert into customer values(8191,'Mrs','Lynne','Mclean','94904','421 Cherry Ave,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8192,'Mrs','Jennifer','Vance','75455','44 West Road,#113')")
    stopIfSqlNotOK(session, "insert into customer values(8193,'Mrs','Dorothy','Jarvis','76228','215 Ash Lane,#30')")
    stopIfSqlNotOK(session, "insert into customer values(8194,'Mr','Norman','Johnson','75182','88 Locust Boulevard,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8195,'Mr','Clarence','Johnson','92262','446 Dogwood Lane,#71')")
    stopIfSqlNotOK(session, "insert into customer values(8196,'Mrs','Nancy','Kelley','78648','457 Dogwood Walk,#138')")
    stopIfSqlNotOK(session, "insert into customer values(8197,'Mr','Michael','Weeks','75095','339 Lee Walk,#114')")
    stopIfSqlNotOK(session, "insert into customer values(8198,'Mr','Michael','Nielsen','76043','238 Taylor Drive,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8199,'Mrs','Barbara','Davis','21131','324 Eighth Square,#178')")
    stopIfSqlNotOK(session, "insert into customer values(8200,'Mrs','Kirsten','Smith','78832','341 Second Walk,#79')")
    stopIfSqlNotOK(session, "insert into customer values(8201,'Mrs','Dorothy','Jones','76622','308 River Street,#174')")
    stopIfSqlNotOK(session, "insert into customer values(8202,'Mr','Perry','Morris','79842','296 Locust St.,#142')")
    stopIfSqlNotOK(session, "insert into customer values(8203,'Mr','Richard','Berg','23884','30 Davis St.,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8204,'Mrs','Fannie','Dorsey','76373','110 Dogwood Parkway,#37')")
    stopIfSqlNotOK(session, "insert into customer values(8205,'Mr','William','Shepherd','75120','258 Ridge Avenue,#96')")
    stopIfSqlNotOK(session, "insert into customer values(8206,'Mrs','Sharon','Davidson','79503','225 Fifth Drive,#28')")
    stopIfSqlNotOK(session, "insert into customer values(8207,'Mrs','Rene','Taylor','98065','313 East Parkway,#8')")
    stopIfSqlNotOK(session, "insert into customer values(8208,'Mr','John','Davis','75929','417 Spring Street,#72')")
    stopIfSqlNotOK(session, "insert into customer values(8209,'Mr','Charles','Brown','76359','178 Lakeview Street,#79')")
    stopIfSqlNotOK(session, "insert into customer values(8210,'Mr','Keith','Riddle','13135','375 Tenth Parkway,#35')")
    stopIfSqlNotOK(session, "insert into customer values(8211,'Mrs','Cecile','Brewer','12203','490 North Lane,#147')")
    stopIfSqlNotOK(session, "insert into customer values(8212,'Mr','Richard','Justice','99329','187 Meadow Square,#103')")
    stopIfSqlNotOK(session, "insert into customer values(8213,'Mrs','Susan','Brown','79231','374 Railroad St.,#61')")
    stopIfSqlNotOK(session, "insert into customer values(8214,'Mr','Greg','Castillo','76461','246 Fifth Walk,#98')")
    stopIfSqlNotOK(session, "insert into customer values(8215,'Mrs','Kelli','Chandler','76936','110 River Square,#129')")
    stopIfSqlNotOK(session, "insert into customer values(8216,'Mrs','Tamika','Terrell','97476','253 Church St.,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8217,'Mrs','Susan','Moore','79245','217 Taylor Drive,#110')")
    stopIfSqlNotOK(session, "insert into customer values(8218,'Mr','Ben','Mcclure','78616','403 Willow Ave,#134')")
    stopIfSqlNotOK(session, "insert into customer values(8219,'Mrs','Lorrie','Davis','78006','348 Lake Place,#198')")
    stopIfSqlNotOK(session, "insert into customer values(8220,'Mr','Morris','Bennett','66859','99 Highland St.,#36')")
    stopIfSqlNotOK(session, "insert into customer values(8221,'Mr','Charles','Jones','79371','80 Broadway Blvd,#161')")
    stopIfSqlNotOK(session, "insert into customer values(8222,'Mr','Richard','Wilson','76470','198 Main Parkway,#185')")
    stopIfSqlNotOK(session, "insert into customer values(8223,'Mr','Robert','Gibson','80731','286 Forest Ave,#10')")
    stopIfSqlNotOK(session, "insert into customer values(8224,'Mr','Alan','Duncan','71315','495 Central St.,#9')")
    stopIfSqlNotOK(session, "insert into customer values(8225,'Mr','Richard','Doyle','78949','270 River Street,#76')")
    stopIfSqlNotOK(session, "insert into customer values(8226,'Mr','David','Davis','00651','138 Eleventh Drive,#137')")
    stopIfSqlNotOK(session, "insert into customer values(8227,'Mrs','Jennifer','Jones','87566','236 Elm Walk,#110')")
    stopIfSqlNotOK(session, "insert into customer values(8228,'Mr','Thomas','Underwood','75151','127 Woodland Road,#29')")
    stopIfSqlNotOK(session, "insert into customer values(8229,'Mr','Hector','Chang','92145','168 Lakeview Square,#50')")
    stopIfSqlNotOK(session, "insert into customer values(8230,'Mrs','Elisabeth','Williams','77563','153 Ash Boulevard,#89')")
    stopIfSqlNotOK(session, "insert into customer values(8231,'Mrs','Tracy','Case','75127','143 Ridge Lane,#52')")
    stopIfSqlNotOK(session, "insert into customer values(8232,'Mr','Charles','Reed','77850','222 Ridge Ave,#47')")
    stopIfSqlNotOK(session, "insert into customer values(8233,'Mr','Thomas','Bailey','02269','334 Lincoln Walk,#110')")
    stopIfSqlNotOK(session, "insert into customer values(8234,'Mrs','Janelle','Johnson','97486','69 College Lane,#105')")
    stopIfSqlNotOK(session, "insert into customer values(8235,'Mr','Ernest','Pace','76649','291 Jackson Avenue,#145')")
    stopIfSqlNotOK(session, "insert into customer values(8236,'Mr','Dale','Moore','75947','487 Central St.,#85')")
    stopIfSqlNotOK(session, "insert into customer values(8237,'Mrs','Lakeisha','Jones','77974','211 Miller Ave,#158')")
    stopIfSqlNotOK(session, "insert into customer values(8238,'Mr','James','Johnson','76009','107 Wilson Drive,#109')")
    stopIfSqlNotOK(session, "insert into customer values(8239,'Mrs','Barbara','Wilson','14722','73 Central Square,#28')")
    stopIfSqlNotOK(session, "insert into customer values(8240,'Mr','Lawrence','Moran','79178','282 Hill St.,#122')")
    stopIfSqlNotOK(session, "insert into customer values(8241,'Mr','James','Woodward','76906','257 Green Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(8242,'Mr','Joseph','Moore','94960','459 Valley Road,#126')")
    stopIfSqlNotOK(session, "insert into customer values(8243,'Mrs','June','Taylor','92707','109 Forest Square,#93')")
    stopIfSqlNotOK(session, "insert into customer values(8244,'Mrs','Annmarie','William','88434','124 Twelfth Ave,#118')")
    stopIfSqlNotOK(session, "insert into customer values(8245,'Mr','Ken','Johnson','76040','304 Willow Street,#69')")
    stopIfSqlNotOK(session, "insert into customer values(8246,'Mr','Robert','Sexton','75433','418 North Boulevard,#129')")
    stopIfSqlNotOK(session, "insert into customer values(8247,'Mrs','Claire','Williams','97624','164 Thirteenth Avenue,#48')")
    stopIfSqlNotOK(session, "insert into customer values(8248,'Mr','William','Miller','76077','23 North Road,#155')")
    stopIfSqlNotOK(session, "insert into customer values(8249,'Mr','Keith','Wilson','40524','447 Main Drive,#161')")
    stopIfSqlNotOK(session, "insert into customer values(8250,'Mr','John','Johnson','79565','26 Walnut Road,#19')")
    stopIfSqlNotOK(session, "insert into customer values(8251,'Mrs','Tamika','Moore','78355','198 Birch Ave,#105')")
    stopIfSqlNotOK(session, "insert into customer values(8252,'Mrs','Marguerite','Miller','79505','290 Broadway Drive,#11')")
    stopIfSqlNotOK(session, "insert into customer values(8253,'Mrs','Lora','Thompson','77952','347 Cherry Boulevard,#100')")
    stopIfSqlNotOK(session, "insert into customer values(8254,'Mrs','Dorothy','Stone','91322','205 Central Ave,#71')")
    stopIfSqlNotOK(session, "insert into customer values(8255,'Mrs','Sandra','Brown','76906','405 East Avenue,#95')")
    stopIfSqlNotOK(session, "insert into customer values(8256,'Mrs','Barbara','Taylor','75481','437 Lake Place,#101')")
    stopIfSqlNotOK(session, "insert into customer values(8257,'Mr','William','Shaw','57775','158 Ash Lane,#70')")
    stopIfSqlNotOK(session, "insert into customer values(8258,'Mr','Richard','Reeves','32088','473 Hickory Parkway,#51')")
    stopIfSqlNotOK(session, "insert into customer values(8259,'Mrs','Sharon','Miller','33575','372 Walnut Boulevard,#19')")
    stopIfSqlNotOK(session, "insert into customer values(8260,'Mr','James','Brown','08736','115 Smith Walk,#183')")
    stopIfSqlNotOK(session, "insert into customer values(8261,'Mrs','Sharon','Mccall','36026','256 Eleventh Boulevard,#162')")
    stopIfSqlNotOK(session, "insert into customer values(8262,'Mr','Michael','Davis','52060','25 View Lane,#40')")
    stopIfSqlNotOK(session, "insert into customer values(8263,'Mr','Travis','Bush','54976','268 Hill Walk,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8264,'Mr','Robert','Taylor','77363','70 Maple Parkway,#19')")
    stopIfSqlNotOK(session, "insert into customer values(8265,'Mr','Ramon','Davis','37990','69 Laurel Place,#98')")
    stopIfSqlNotOK(session, "insert into customer values(8266,'Mr','Joseph','Smith','52228','282 Fourteenth Street,#48')")
    stopIfSqlNotOK(session, "insert into customer values(8267,'Mr','Stephen','Moore','76007','78 Taylor Road,#18')")
    stopIfSqlNotOK(session, "insert into customer values(8268,'Mrs','Nancy','Cox','28703','62 Green Blvd,#171')")
    stopIfSqlNotOK(session, "insert into customer values(8269,'Mr','Joseph','Moore','75150','272 Third Boulevard,#101')")
    stopIfSqlNotOK(session, "insert into customer values(8270,'Mrs','Betty','Johnson','75501','62 Twelfth Lane,#136')")
    stopIfSqlNotOK(session, "insert into customer values(8271,'Mr','Joseph','Schroeder','78671','490 Valley Parkway,#113')")
    stopIfSqlNotOK(session, "insert into customer values(8272,'Mrs','Sharon','Davis','04764','281 Fourth Street,#31')")
    stopIfSqlNotOK(session, "insert into customer values(8273,'Mr','Charles','Delaney','78073','268 Lakeview Blvd,#91')")
    stopIfSqlNotOK(session, "insert into customer values(8274,'Mr','Jerome','Flores','77326','209 Main Place,#6')")
    stopIfSqlNotOK(session, "insert into customer values(8275,'Mrs','Delores','Brown','32018','493 North Ave,#61')")
    stopIfSqlNotOK(session, "insert into customer values(8276,'Mr','Javier','Hinton','78570','68 Wilson Avenue,#4')")
    stopIfSqlNotOK(session, "insert into customer values(8277,'Mr','Michael','Alford','75086','99 Maple Boulevard,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8278,'Mr','Lonnie','Holland','65714','150 Dogwood Street,#169')")
    stopIfSqlNotOK(session, "insert into customer values(8279,'Mr','Kurt','Schwartz','26385','224 Lincoln Road,#169')")
    stopIfSqlNotOK(session, "insert into customer values(8280,'Mrs','Norma','Wilson','48051','248 Lakeview Boulevard,#187')")
    stopIfSqlNotOK(session, "insert into customer values(8281,'Mr','Thomas','Moore','65618','158 Spring Avenue,#31')")
    stopIfSqlNotOK(session, "insert into customer values(8282,'Mrs','Susan','Jacobs','76859','14 Ninth Boulevard,#189')")
    stopIfSqlNotOK(session, "insert into customer values(8283,'Mr','William','Nielsen','46534','402 Smith Place,#130')")
    stopIfSqlNotOK(session, "insert into customer values(8284,'Mr','Warren','Williams','77484','157 Elm Parkway,#58')")
    stopIfSqlNotOK(session, "insert into customer values(8285,'Mrs','Christa','Williams','92712','201 Ash Square,#143')")
    stopIfSqlNotOK(session, "insert into customer values(8286,'Mr','Tom','Bowman','88348','304 Seventh Place,#166')")
    stopIfSqlNotOK(session, "insert into customer values(8287,'Mrs','Leanna','Williams','78705','109 Meadow Street,#126')")
    stopIfSqlNotOK(session, "insert into customer values(8288,'Mr','Mario','Sherman','97535','58 Spring Road,#67')")
    stopIfSqlNotOK(session, "insert into customer values(8289,'Mrs','Nell','Jones','77850','493 Mill St.,#108')")
    stopIfSqlNotOK(session, "insert into customer values(8290,'Mrs','Betty','Buckner','75831','9 First Place,#194')")
    stopIfSqlNotOK(session, "insert into customer values(8291,'Mr','Steven','Johnson','06783','161 Poplar Parkway,#134')")
    stopIfSqlNotOK(session, "insert into customer values(8292,'Mrs','Patricia','Trujillo','76435','346 Walnut Street,#200')")
    stopIfSqlNotOK(session, "insert into customer values(8293,'Mrs','Sandra','Taylor','69155','440 West Boulevard,#178')")
    stopIfSqlNotOK(session, "insert into customer values(8294,'Mr','Richard','Davis','77861','485 Meadow Place,#17')")
    stopIfSqlNotOK(session, "insert into customer values(8295,'Mrs','Willa','Johnson','76446','358 Center Lane,#94')")
    stopIfSqlNotOK(session, "insert into customer values(8296,'Mr','Robert','Smith','75951','272 Cherry Blvd,#89')")
    stopIfSqlNotOK(session, "insert into customer values(8297,'Mrs','Susan','Gentry','56681','146 Tenth Drive,#42')")
    stopIfSqlNotOK(session, "insert into customer values(8298,'Mr','William','Mcintosh','76384','200 Miller Road,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8299,'Mr','Jesse','Lee','75480','130 Hillcrest Walk,#194')")
    stopIfSqlNotOK(session, "insert into customer values(8300,'Mrs','Sharon','Wilson','78628','356 College Blvd,#122')")
    stopIfSqlNotOK(session, "insert into customer values(8301,'Mrs','Sandra','Anderson','76890','160 Third Ave,#116')")
    stopIfSqlNotOK(session, "insert into customer values(8302,'Mrs','Patricia','Moore','78658','498 North Boulevard,#44')")
    stopIfSqlNotOK(session, "insert into customer values(8303,'Mrs','Debora','Sparks','77967','61 Forest St.,#73')")
    stopIfSqlNotOK(session, "insert into customer values(8304,'Mrs','Dona','Schneider','78739','79 Highland Walk,#167')")
    stopIfSqlNotOK(session, "insert into customer values(8305,'Mr','Charles','Saunders','77631','31 Valley Place,#71')")
    stopIfSqlNotOK(session, "insert into customer values(8306,'Mrs','Patricia','Johnson','43761','59 Lee Boulevard,#99')")
    stopIfSqlNotOK(session, "insert into customer values(8307,'Mr','David','Miller','79066','495 Railroad Road,#179')")
    stopIfSqlNotOK(session, "insert into customer values(8308,'Mr','Chester','Miller','79227','262 East Lane,#160')")
    stopIfSqlNotOK(session, "insert into customer values(8309,'Mrs','Juliette','Decker','75573','89 Sixth Ave,#133')")
    stopIfSqlNotOK(session, "insert into customer values(8310,'Mrs','Neva','Wilson','95620','83 Oak Parkway,#58')")
    stopIfSqlNotOK(session, "insert into customer values(8311,'Mrs','Willa','Miller','76056','229 Second Blvd,#84')")
    stopIfSqlNotOK(session, "insert into customer values(8312,'Mr','William','Reed','21758','15 Fourth Blvd,#143')")
    stopIfSqlNotOK(session, "insert into customer values(8313,'Mrs','Carol','Moore','76092','287 Lee Street,#49')")
    stopIfSqlNotOK(session, "insert into customer values(8314,'Mr','James','Miller','00940','494 Pine Square,#133')")
    stopIfSqlNotOK(session, "insert into customer values(8315,'Mr','Thomas','Lang','78956','215 Walnut Lane,#144')")
    stopIfSqlNotOK(session, "insert into customer values(8316,'Mrs','Claudia','Rocha','79066','358 Birch Street,#175')")
    stopIfSqlNotOK(session, "insert into customer values(8317,'Mr','Jay','Brown','79313','339 Ninth Place,#130')")
    stopIfSqlNotOK(session, "insert into customer values(8318,'Mr','Herbert','Williams','98027','368 Ninth Blvd,#142')")
    stopIfSqlNotOK(session, "insert into customer values(8319,'Mrs','Barbara','Elliott','75948','291 Highland Ave,#167')")
    stopIfSqlNotOK(session, "insert into customer values(8320,'Mr','Jimmie','Ross','79221','93 Davis Ave,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8321,'Mrs','Jennifer','Williams','71417','455 South Avenue,#7')")
    stopIfSqlNotOK(session, "insert into customer values(8322,'Mrs','Bernadette','Suarez','79243','162 Oak Blvd,#149')")
    stopIfSqlNotOK(session, "insert into customer values(8323,'Mr','Ken','Miller','77876','243 First Avenue,#200')")
    stopIfSqlNotOK(session, "insert into customer values(8324,'Mrs','Sandra','Taylor','38047','48 South Road,#128')")
    stopIfSqlNotOK(session, "insert into customer values(8325,'Mrs','Sharon','Cooper','52004','24 Fifteenth Avenue,#26')")
    stopIfSqlNotOK(session, "insert into customer values(8326,'Mrs','Hester','Frost','93111','131 Adams Parkway,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8327,'Mr','Johnnie','Davis','77655','43 Third Avenue,#79')")
    stopIfSqlNotOK(session, "insert into customer values(8328,'Mr','Johnnie','Brown','88589','113 Mill Walk,#147')")
    stopIfSqlNotOK(session, "insert into customer values(8329,'Mrs','Betty','Ortiz','16027','112 Davis Avenue,#23')")
    stopIfSqlNotOK(session, "insert into customer values(8330,'Mr','James','Lawson','76043','367 Meadow Boulevard,#111')")
    stopIfSqlNotOK(session, "insert into customer values(8331,'Mrs','Dorothy','Johnson','76949','500 Adams Walk,#56')")
    stopIfSqlNotOK(session, "insert into customer values(8332,'Mr','Keith','Jennings','77582','224 Spruce Street,#71')")
    stopIfSqlNotOK(session, "insert into customer values(8333,'Mr','Ray','Sykes','87174','288 Highland Ave,#59')")
    stopIfSqlNotOK(session, "insert into customer values(8334,'Mr','Bryan','Bird','94901','391 Central Street,#81')")
    stopIfSqlNotOK(session, "insert into customer values(8335,'Mrs','Patricia','Johnson','77385','9 Eleventh Drive,#99')")
    stopIfSqlNotOK(session, "insert into customer values(8336,'Mrs','Lora','Johnston','78123','159 Sycamore Square,#42')")
    stopIfSqlNotOK(session, "insert into customer values(8337,'Mr','Bernard','Miller','75853','178 Franklin St.,#87')")
    stopIfSqlNotOK(session, "insert into customer values(8338,'Mr','Jessie','Taylor','60957','121 Fifth Road,#69')")
    stopIfSqlNotOK(session, "insert into customer values(8339,'Mrs','Sharon','Williams','77616','138 Seventh Drive,#200')")
    stopIfSqlNotOK(session, "insert into customer values(8340,'Mrs','Sandra','Miller','75783','163 College Boulevard,#60')")
    stopIfSqlNotOK(session, "insert into customer values(8341,'Mrs','Tina','Davis','47576','406 Dogwood Boulevard,#85')")
    stopIfSqlNotOK(session, "insert into customer values(8342,'Mrs','Sandra','Jones','75757','360 Cedar Road,#69')")
    stopIfSqlNotOK(session, "insert into customer values(8343,'Mr','David','Moody','85631','256 Second Street,#106')")
    stopIfSqlNotOK(session, "insert into customer values(8344,'Mrs','Patricia','Collier','78029','437 Lakeview Blvd,#119')")
    stopIfSqlNotOK(session, "insert into customer values(8345,'Mrs','Patricia','Johnson','10514','109 Forest Walk,#103')")
    stopIfSqlNotOK(session, "insert into customer values(8346,'Mrs','Tamra','Williams','75058','103 Central Street,#41')")
    stopIfSqlNotOK(session, "insert into customer values(8347,'Mr','Ruben','Moore','52158','138 Willow Road,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8348,'Mrs','Sharon','Davis','75486','414 Poplar Place,#132')")
    stopIfSqlNotOK(session, "insert into customer values(8349,'Mrs','Leah','Smith','91346','101 Madison Lane,#149')")
    stopIfSqlNotOK(session, "insert into customer values(8350,'Mr','Guy','Smith','78605','77 Eleventh St.,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8351,'Mr','Thomas','Taylor','79327','350 Adams Walk,#106')")
    stopIfSqlNotOK(session, "insert into customer values(8352,'Mr','David','Wilson','76539','159 Valley Road,#162')")
    stopIfSqlNotOK(session, "insert into customer values(8353,'Mrs','Viola','Wilson','75754','250 Franklin Avenue,#53')")
    stopIfSqlNotOK(session, "insert into customer values(8354,'Mr','Joseph','Moore','77614','7 Meadow Ave,#190')")
    stopIfSqlNotOK(session, "insert into customer values(8355,'Mr','Richard','Carrillo','08736','328 Johnson Drive,#199')")
    stopIfSqlNotOK(session, "insert into customer values(8356,'Mr','Keith','Williams','75858','264 Jefferson Lane,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8357,'Mrs','Muriel','Jones','79223','296 Sycamore Walk,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8358,'Mrs','Barbara','Foley','78853','444 Center Boulevard,#45')")
    stopIfSqlNotOK(session, "insert into customer values(8359,'Mr','Alexander','Wilson','36458','328 Ridge Boulevard,#1')")
    stopIfSqlNotOK(session, "insert into customer values(8360,'Mr','John','Fischer','61334','428 Main Boulevard,#127')")
    stopIfSqlNotOK(session, "insert into customer values(8361,'Mrs','Susan','Schmidt','78516','285 Locust Place,#103')")
    stopIfSqlNotOK(session, "insert into customer values(8362,'Mr','Charles','Brown','78583','34 Fourth Boulevard,#198')")
    stopIfSqlNotOK(session, "insert into customer values(8363,'Mr','David','Williams','21758','400 Jackson St.,#28')")
    stopIfSqlNotOK(session, "insert into customer values(8364,'Mrs','Nancy','Vega','77457','251 Lee Blvd,#83')")
    stopIfSqlNotOK(session, "insert into customer values(8365,'Mr','Charles','Shaffer','77643','127 Chestnut Parkway,#98')")
    stopIfSqlNotOK(session, "insert into customer values(8366,'Mrs','Sharon','Williams','79835','312 Thirteenth Ave,#87')")
    stopIfSqlNotOK(session, "insert into customer values(8367,'Mrs','Monique','Logan','78073','368 West Walk,#63')")
    stopIfSqlNotOK(session, "insert into customer values(8368,'Mr','Ivan','Jones','79491','419 Second Walk,#33')")
    stopIfSqlNotOK(session, "insert into customer values(8369,'Mrs','Patricia','Moore','78662','188 First Lane,#92')")
    stopIfSqlNotOK(session, "insert into customer values(8370,'Mr','Tyrone','Wilson','78054','237 Fifth Walk,#85')")
    stopIfSqlNotOK(session, "insert into customer values(8371,'Mr','David','Albert','79832','227 Eleventh Blvd,#162')")
    stopIfSqlNotOK(session, "insert into customer values(8372,'Mrs','Elinor','Miller','78558','231 North Road,#63')")
    stopIfSqlNotOK(session, "insert into customer values(8373,'Mrs','Dianna','Smith','77429','316 Lee Lane,#85')")
    stopIfSqlNotOK(session, "insert into customer values(8374,'Mrs','Alyssa','Taylor','77231','447 Pine Place,#136')")
    stopIfSqlNotOK(session, "insert into customer values(8375,'Mr','James','Smith','79491','24 Pine Drive,#153')")
    stopIfSqlNotOK(session, "insert into customer values(8376,'Mrs','Bobbie','Sampson','78641','438 Birch Square,#1')")
    stopIfSqlNotOK(session, "insert into customer values(8377,'Mrs','Maryellen','Padilla','79968','190 Birch Blvd,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8378,'Mrs','Betty','Elliott','60465','396 Dogwood Walk,#27')")
    stopIfSqlNotOK(session, "insert into customer values(8379,'Mrs','Mamie','Taylor','76949','358 Ninth Drive,#16')")
    stopIfSqlNotOK(session, "insert into customer values(8380,'Mr','Clifton','Williams','75410','488 Second Parkway,#80')")
    stopIfSqlNotOK(session, "insert into customer values(8381,'Mr','Eddie','Patterson','76676','230 View Ave,#176')")
    stopIfSqlNotOK(session, "insert into customer values(8382,'Mrs','Loraine','Taylor','79519','374 Woodland Parkway,#106')")
    stopIfSqlNotOK(session, "insert into customer values(8383,'Mr','Michael','Santiago','81250','463 Miller Drive,#15')")
    stopIfSqlNotOK(session, "insert into customer values(8384,'Mr','Michael','Williams','92332','11 Johnson Square,#82')")
    stopIfSqlNotOK(session, "insert into customer values(8385,'Mr','Wallace','Wilson','04426','327 First Boulevard,#160')")
    stopIfSqlNotOK(session, "insert into customer values(8386,'Mrs','Dorothy','Greene','78330','148 South Blvd,#4')")
    stopIfSqlNotOK(session, "insert into customer values(8387,'Mr','Marc','Brown','75449','485 Jackson St.,#165')")
    stopIfSqlNotOK(session, "insert into customer values(8388,'Mrs','Nancy','Snyder','72355','427 Seventh Avenue,#199')")
    stopIfSqlNotOK(session, "insert into customer values(8389,'Mrs','Dorothy','Hewitt','31624','455 Dogwood Lane,#18')")
    stopIfSqlNotOK(session, "insert into customer values(8390,'Mr','Joshua','Williams','76633','43 Pine Blvd,#193')")
    stopIfSqlNotOK(session, "insert into customer values(8391,'Mrs','Betty','Moore','07879','132 Locust St.,#166')")
    stopIfSqlNotOK(session, "insert into customer values(8392,'Mr','James','Boyle','78952','470 Meadow St.,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8393,'Mrs','Jennifer','Wilson','95032','450 Mill Boulevard,#76')")
    stopIfSqlNotOK(session, "insert into customer values(8394,'Mrs','Carol','Brown','98376','486 Jackson Road,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8395,'Mr','Charles','Moore','79529','461 Pine Ave,#174')")
    stopIfSqlNotOK(session, "insert into customer values(8396,'Mr','Chester','Moore','79735','461 Lee Avenue,#174')")
    stopIfSqlNotOK(session, "insert into customer values(8397,'Mr','Charles','Williams','94960','214 Ridge Place,#50')")
    stopIfSqlNotOK(session, "insert into customer values(8398,'Mrs','Sharon','Phelps','37343','405 Broadway Ave,#38')")
    stopIfSqlNotOK(session, "insert into customer values(8399,'Mrs','Karla','Smith','75494','115 Oak Square,#5')")
    stopIfSqlNotOK(session, "insert into customer values(8400,'Mr','Bryan','Brown','77617','76 Williams St.,#146')")
    stopIfSqlNotOK(session, "insert into customer values(8401,'Mr','Michael','Emerson','76468','449 Cedar Avenue,#132')")
    stopIfSqlNotOK(session, "insert into customer values(8402,'Mrs','Betty','Brown','95106','269 Woodland Blvd,#73')")
    stopIfSqlNotOK(session, "insert into customer values(8403,'Mr','Wesley','Barron','78117','422 Walnut St.,#155')")
    stopIfSqlNotOK(session, "insert into customer values(8404,'Mr','Billy','Skinner','79001','337 Sunset Lane,#42')")
    stopIfSqlNotOK(session, "insert into customer values(8405,'Mrs','Susan','Davis','77962','33 Second Road,#5')")
    stopIfSqlNotOK(session, "insert into customer values(8406,'Mr','Robert','Landry','76246','185 Washington Square,#52')")
    stopIfSqlNotOK(session, "insert into customer values(8407,'Mrs','Ester','Harrell','78005','446 South Road,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8408,'Mr','Thomas','Duncan','62830','453 Second Drive,#78')")
    stopIfSqlNotOK(session, "insert into customer values(8409,'Mr','Tyler','Perkins','76691','46 Elm Lane,#64')")
    stopIfSqlNotOK(session, "insert into customer values(8410,'Mrs','Sandra','Taylor','78369','46 Church Lane,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8411,'Mrs','Susan','Fleming','79540','180 View Parkway,#10')")
    stopIfSqlNotOK(session, "insert into customer values(8412,'Mr','Richard','Reilly','60945','29 Hickory Avenue,#139')")
    stopIfSqlNotOK(session, "insert into customer values(8413,'Mr','Salvador','Brown','41602','455 Miller Ave,#187')")
    stopIfSqlNotOK(session, "insert into customer values(8414,'Mrs','Sharon','Johnson','75573','224 Miller Avenue,#142')")
    stopIfSqlNotOK(session, "insert into customer values(8415,'Mrs','Christa','Cummings','67753','241 Jefferson Square,#86')")
    stopIfSqlNotOK(session, "insert into customer values(8416,'Mrs','Patricia','Ramirez','48886','350 Lee Square,#13')")
    stopIfSqlNotOK(session, "insert into customer values(8417,'Mrs','Sandra','Smith','79042','265 Green Road,#182')")
    stopIfSqlNotOK(session, "insert into customer values(8418,'Mrs','Bonnie','Davis','78039','294 Lincoln Place,#103')")
    stopIfSqlNotOK(session, "insert into customer values(8419,'Mr','Jordan','Ross','79373','397 Hill Parkway,#57')")
    stopIfSqlNotOK(session, "insert into customer values(8420,'Mrs','Carol','Smith','58759','489 Jefferson Boulevard,#92')")
    stopIfSqlNotOK(session, "insert into customer values(8421,'Mrs','Elinor','Smith','79220','453 Johnson Blvd,#187')")
    stopIfSqlNotOK(session, "insert into customer values(8422,'Mrs','Rita','Taylor','67740','126 Sixth Boulevard,#190')")
    stopIfSqlNotOK(session, "insert into customer values(8423,'Mrs','Erin','Davis','93256','13 Johnson Avenue,#5')")
    stopIfSqlNotOK(session, "insert into customer values(8424,'Mrs','Ruby','Williams','76628','239 Smith Walk,#50')")
    stopIfSqlNotOK(session, "insert into customer values(8425,'Mr','James','Wilson','92712','158 Woodland Lane,#4')")
    stopIfSqlNotOK(session, "insert into customer values(8426,'Mr','Michael','Meadows','79777','198 Green Lane,#116')")
    stopIfSqlNotOK(session, "insert into customer values(8427,'Mr','Ivan','Potts','79035','352 Highland Road,#135')")
    stopIfSqlNotOK(session, "insert into customer values(8428,'Mr','John','Sanchez','76950','53 Fifth Place,#185')")
    stopIfSqlNotOK(session, "insert into customer values(8429,'Mr','Clarence','Williams','76951','101 Sycamore Place,#49')")
    stopIfSqlNotOK(session, "insert into customer values(8430,'Mrs','Dorothy','Willis','78076','275 Williams Boulevard,#94')")
    stopIfSqlNotOK(session, "insert into customer values(8431,'Mrs','Margo','Wilson','76682','289 Lake Avenue,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8432,'Mrs','Nancy','Davis','75435','93 West Walk,#111')")
    stopIfSqlNotOK(session, "insert into customer values(8433,'Mrs','Patricia','Sears','15662','415 Lakeview Blvd,#33')")
    stopIfSqlNotOK(session, "insert into customer values(8434,'Mr','Joseph','Johnson','75557','461 Valley Parkway,#19')")
    stopIfSqlNotOK(session, "insert into customer values(8435,'Mrs','Celina','David','78151','226 South Road,#34')")
    stopIfSqlNotOK(session, "insert into customer values(8436,'Mrs','Sandra','Johnson','93660','382 Jackson Street,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8437,'Mrs','Jennifer','Miller','54835','401 Mill St.,#182')")
    stopIfSqlNotOK(session, "insert into customer values(8438,'Mr','Douglas','Spears','78714','441 Broadway Parkway,#26')")
    stopIfSqlNotOK(session, "insert into customer values(8439,'Mrs','Betty','Davis','78538','198 Church Avenue,#143')")
    stopIfSqlNotOK(session, "insert into customer values(8440,'Mr','Chester','Barron','61334','395 Park Drive,#143')")
    stopIfSqlNotOK(session, "insert into customer values(8441,'Mr','William','Davis','79014','190 Chestnut Square,#99')")
    stopIfSqlNotOK(session, "insert into customer values(8442,'Mr','Marcus','Moore','07440','97 Center Place,#30')")
    stopIfSqlNotOK(session, "insert into customer values(8443,'Mrs','Sandra','Wilson','76869','236 Spring Street,#1')")
    stopIfSqlNotOK(session, "insert into customer values(8444,'Mr','Thomas','Frank','79082','25 Valley Blvd,#77')")
    stopIfSqlNotOK(session, "insert into customer values(8445,'Mr','John','Guzman','78636','71 Smith Walk,#23')")
    stopIfSqlNotOK(session, "insert into customer values(8446,'Mr','Thomas','Smith','76708','335 Spruce Road,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8447,'Mr','William','Porter','10286','30 Third Road,#119')")
    stopIfSqlNotOK(session, "insert into customer values(8448,'Mr','Robert','Donovan','00938','256 Highland Parkway,#3')")
    stopIfSqlNotOK(session, "insert into customer values(8449,'Mr','Thomas','Mclean','16027','458 South Avenue,#1')")
    stopIfSqlNotOK(session, "insert into customer values(8450,'Mr','Joseph','Smith','76547','209 Fifth Ave,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8451,'Mr','William','Jones','14877','286 Second Drive,#179')")
    stopIfSqlNotOK(session, "insert into customer values(8452,'Mr','David','Williams','77457','373 View Drive,#25')")
    stopIfSqlNotOK(session, "insert into customer values(8453,'Mr','Michael','Brown','89199','452 Hickory Walk,#59')")
    stopIfSqlNotOK(session, "insert into customer values(8454,'Mrs','Julianne','Johnson','77456','230 First Ave,#20')")
    stopIfSqlNotOK(session, "insert into customer values(8455,'Mr','Richard','Moore','16918','231 Main Parkway,#198')")
    stopIfSqlNotOK(session, "insert into customer values(8456,'Mrs','Nancy','Love','76029','22 South Parkway,#112')")
    stopIfSqlNotOK(session, "insert into customer values(8457,'Mrs','Lynn','Combs','76255','186 First Ave,#33')")
    stopIfSqlNotOK(session, "insert into customer values(8458,'Mrs','Kaitlin','Smith','77468','283 Hill Walk,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8459,'Mrs','Barbara','Wilson','79178','269 Johnson Place,#37')")
    stopIfSqlNotOK(session, "insert into customer values(8460,'Mrs','Ursula','Campos','75497','476 Lincoln Drive,#139')")
    stopIfSqlNotOK(session, "insert into customer values(8461,'Mrs','Tracy','Ballard','75639','127 Park Street,#169')")
    stopIfSqlNotOK(session, "insert into customer values(8462,'Mrs','Nancy','Graves','51250','194 Smith Walk,#16')")
    stopIfSqlNotOK(session, "insert into customer values(8463,'Mr','Keith','Smith','77979','240 Eighth Blvd,#40')")
    stopIfSqlNotOK(session, "insert into customer values(8464,'Mr','Russell','Hutchinson','05154','404 Valley St.,#175')")
    stopIfSqlNotOK(session, "insert into customer values(8465,'Mr','William','Walls','79560','484 Adams Lane,#66')")
    stopIfSqlNotOK(session, "insert into customer values(8466,'Mr','Robert','Brown','75554','466 East Blvd,#138')")
    stopIfSqlNotOK(session, "insert into customer values(8467,'Mrs','Betty','Brown','79078','480 Dogwood Street,#15')")
    stopIfSqlNotOK(session, "insert into customer values(8468,'Mrs','Jennifer','Miller','76679','62 Park Square,#147')")
    stopIfSqlNotOK(session, "insert into customer values(8469,'Mr','Sergio','Pennington','00673','165 Lakeview Boulevard,#167')")
    stopIfSqlNotOK(session, "insert into customer values(8470,'Mr','Robert','Graves','90091','389 Lake Street,#145')")
    stopIfSqlNotOK(session, "insert into customer values(8471,'Mr','John','Buchanan','49854','148 West Ave,#109')")
    stopIfSqlNotOK(session, "insert into customer values(8472,'Mr','Michael','Moore','01242','268 Valley Street,#138')")
    stopIfSqlNotOK(session, "insert into customer values(8473,'Mr','Thomas','Smith','77460','458 Center Boulevard,#98')")
    stopIfSqlNotOK(session, "insert into customer values(8474,'Mrs','Sylvia','Brown','75861','372 Highland Parkway,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8475,'Mr','Lonnie','Evans','77535','294 Tenth Boulevard,#38')")
    stopIfSqlNotOK(session, "insert into customer values(8476,'Mr','Clyde','Fuller','78107','79 Seventh Road,#70')")
    stopIfSqlNotOK(session, "insert into customer values(8477,'Mr','David','Calhoun','75323','291 Main Walk,#59')")
    stopIfSqlNotOK(session, "insert into customer values(8478,'Mrs','Jennifer','Camacho','77972','146 Woodland Road,#113')")
    stopIfSqlNotOK(session, "insert into customer values(8479,'Mrs','Sharon','Stone','79161','351 Ninth Ave,#35')")
    stopIfSqlNotOK(session, "insert into customer values(8480,'Mrs','Neva','Williams','78076','20 Woodland Walk,#45')")
    stopIfSqlNotOK(session, "insert into customer values(8481,'Mrs','Carol','Underwood','75833','343 Birch Road,#112')")
    stopIfSqlNotOK(session, "insert into customer values(8482,'Mr','James','Brown','77428','409 Fifth Road,#197')")
    stopIfSqlNotOK(session, "insert into customer values(8483,'Mrs','Carol','Camacho','76534','433 Lake Lane,#83')")
    stopIfSqlNotOK(session, "insert into customer values(8484,'Mr','Joseph','Waller','76206','80 Chestnut Place,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8485,'Mrs','Sharon','Prince','79838','334 Seventh Avenue,#68')")
    stopIfSqlNotOK(session, "insert into customer values(8486,'Mr','Charles','Miller','24360','170 Fourth Boulevard,#115')")
    stopIfSqlNotOK(session, "insert into customer values(8487,'Mr','David','Sparks','36439','12 Chestnut Street,#17')")
    stopIfSqlNotOK(session, "insert into customer values(8488,'Mrs','Esperanza','Moore','20903','52 Sunset Walk,#193')")
    stopIfSqlNotOK(session, "insert into customer values(8489,'Mr','John','Wilson','75835','310 Willow Road,#58')")
    stopIfSqlNotOK(session, "insert into customer values(8490,'Mrs','Sandra','Moore','28619','473 River Drive,#46')")
    stopIfSqlNotOK(session, "insert into customer values(8491,'Mrs','Bonnie','Padilla','77099','227 Fifth Avenue,#26')")
    stopIfSqlNotOK(session, "insert into customer values(8492,'Mrs','Connie','Brown','76654','189 Thirteenth Road,#43')")
    stopIfSqlNotOK(session, "insert into customer values(8493,'Mrs','Barbara','Miller','78561','345 Madison Drive,#57')")
    stopIfSqlNotOK(session, "insert into customer values(8494,'Mr','Brandon','Anderson','59853','314 Woodland Avenue,#146')")
    stopIfSqlNotOK(session, "insert into customer values(8495,'Mr','Nicholas','Fisher','78104','272 Washington Road,#20')")
    stopIfSqlNotOK(session, "insert into customer values(8496,'Mrs','Lawanda','Miller','76155','69 Mill Boulevard,#58')")
    stopIfSqlNotOK(session, "insert into customer values(8497,'Mrs','Patricia','Taylor','79338','188 View Ave,#15')")
    stopIfSqlNotOK(session, "insert into customer values(8498,'Mr','Michael','Miller','90671','284 Hickory Walk,#94')")
    stopIfSqlNotOK(session, "insert into customer values(8499,'Mrs','Candice','Davis','67119','136 Willow Lane,#178')")
    stopIfSqlNotOK(session, "insert into customer values(8500,'Mr','Robert','Gomez','77866','272 Madison Street,#67')")
    stopIfSqlNotOK(session, "insert into customer values(8501,'Mr','Roland','Taylor','77375','377 Spruce Boulevard,#47')")
    stopIfSqlNotOK(session, "insert into customer values(8502,'Mr','Marvin','Edwards','78333','221 Pine Place,#64')")
    stopIfSqlNotOK(session, "insert into customer values(8503,'Mrs','Patricia','Moore','10514','363 Forest Avenue,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8504,'Mrs','Patricia','Moss','79189','159 Sycamore Blvd,#121')")
    stopIfSqlNotOK(session, "insert into customer values(8505,'Mr','Michael','Chandler','75488','326 Second St.,#157')")
    stopIfSqlNotOK(session, "insert into customer values(8506,'Mrs','Carol','Cabrera','78622','56 Second Square,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8507,'Mr','Joseph','Smith','50124','293 Willow Walk,#106')")
    stopIfSqlNotOK(session, "insert into customer values(8508,'Mr','Rene','Jackson','76447','84 Eighth Boulevard,#62')")
    stopIfSqlNotOK(session, "insert into customer values(8509,'Mrs','Kristin','Hood','76028','263 Cedar Blvd,#62')")
    stopIfSqlNotOK(session, "insert into customer values(8510,'Mr','Gilbert','Miller','94096','322 Ash Drive,#144')")
    stopIfSqlNotOK(session, "insert into customer values(8511,'Mrs','Barbara','Johnson','54557','363 Johnson Street,#128')")
    stopIfSqlNotOK(session, "insert into customer values(8512,'Mr','Juan','Lowery','77864','55 Meadow Drive,#49')")
    stopIfSqlNotOK(session, "insert into customer values(8513,'Mr','Jesse','Griffin','76389','99 West Parkway,#139')")
    stopIfSqlNotOK(session, "insert into customer values(8514,'Mrs','Eula','Mitchell','51111','85 Willow St.,#56')")
    stopIfSqlNotOK(session, "insert into customer values(8515,'Mr','Donald','Russell','01921','285 Woodland Parkway,#129')")
    stopIfSqlNotOK(session, "insert into customer values(8516,'Mr','Joseph','Levine','87199','257 Fourteenth Lane,#176')")
    stopIfSqlNotOK(session, "insert into customer values(8517,'Mr','Gary','Dixon','75001','283 Center Walk,#173')")
    stopIfSqlNotOK(session, "insert into customer values(8518,'Mrs','Shawn','Dunn','76825','211 Main Drive,#36')")
    stopIfSqlNotOK(session, "insert into customer values(8519,'Mrs','Dorothy','Taylor','64446','457 Center Place,#110')")
    stopIfSqlNotOK(session, "insert into customer values(8520,'Mrs','Maxine','Wilson','41331','425 Davis St.,#133')")
    stopIfSqlNotOK(session, "insert into customer values(8521,'Mr','Timothy','Williams','76827','493 Jackson Blvd,#15')")
    stopIfSqlNotOK(session, "insert into customer values(8522,'Mr','Salvador','Callahan','75756','91 Spring Drive,#167')")
    stopIfSqlNotOK(session, "insert into customer values(8523,'Mr','Joseph','Miller','76599','267 North Blvd,#140')")
    stopIfSqlNotOK(session, "insert into customer values(8524,'Mrs','Dorothy','Davis','76569','469 Lincoln Street,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8525,'Mrs','Kirsten','Davis','45381','226 Thirteenth Ave,#32')")
    stopIfSqlNotOK(session, "insert into customer values(8526,'Mr','James','Moore','76624','402 Johnson Lane,#198')")
    stopIfSqlNotOK(session, "insert into customer values(8527,'Mr','David','Miller','76676','431 Lake Road,#43')")
    stopIfSqlNotOK(session, "insert into customer values(8528,'Mr','Bobby','Reyes','76827','221 Lincoln Boulevard,#88')")
    stopIfSqlNotOK(session, "insert into customer values(8529,'Mrs','Jennifer','Campbell','93665','48 Third Boulevard,#32')")
    stopIfSqlNotOK(session, "insert into customer values(8530,'Mrs','Sandra','Delacruz','61454','207 Ash Ave,#111')")
    stopIfSqlNotOK(session, "insert into customer values(8531,'Mr','Johnny','Williams','51111','369 Smith Boulevard,#27')")
    stopIfSqlNotOK(session, "insert into customer values(8532,'Mr','Richard','Smith','79535','404 Laurel Lane,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8533,'Mr','Charles','Miller','29072','400 Central Place,#168')")
    stopIfSqlNotOK(session, "insert into customer values(8534,'Mr','Jim','Miller','01540','171 Park Road,#97')")
    stopIfSqlNotOK(session, "insert into customer values(8535,'Mr','Dean','Gallagher','78662','103 Green Ave,#79')")
    stopIfSqlNotOK(session, "insert into customer values(8536,'Mrs','Liza','Colon','77989','441 Taylor Road,#131')")
    stopIfSqlNotOK(session, "insert into customer values(8537,'Mr','Kirk','Williams','94963','265 Eleventh Square,#84')")
    stopIfSqlNotOK(session, "insert into customer values(8538,'Mrs','Susan','Moore','58760','37 Lee Parkway,#153')")
    stopIfSqlNotOK(session, "insert into customer values(8539,'Mrs','Susan','Johnson','75124','125 Lakeview Walk,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8540,'Mrs','Sandra','Decker','75151','415 Ridge St.,#102')")
    stopIfSqlNotOK(session, "insert into customer values(8541,'Mrs','Sandra','Moore','65755','390 Elm Avenue,#34')")
    stopIfSqlNotOK(session, "insert into customer values(8542,'Mr','David','Riggs','92714','414 Seventh Blvd,#96')")
    stopIfSqlNotOK(session, "insert into customer values(8543,'Mr','Thomas','Smith','77479','236 Fourth St.,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8544,'Mrs','Leticia','Coffey','79324','48 Second Drive,#161')")
    stopIfSqlNotOK(session, "insert into customer values(8545,'Mr','John','Brown','10987','399 Oak Walk,#42')")
    stopIfSqlNotOK(session, "insert into customer values(8546,'Mr','Thomas','Hurley','78377','182 Fourth Road,#23')")
    stopIfSqlNotOK(session, "insert into customer values(8547,'Mr','Richard','Church','25180','147 Walnut Avenue,#93')")
    stopIfSqlNotOK(session, "insert into customer values(8548,'Mr','Russell','Brady','42409','93 Ridge Parkway,#187')")
    stopIfSqlNotOK(session, "insert into customer values(8549,'Mr','Joseph','Wilson','48732','476 Dogwood Street,#150')")
    stopIfSqlNotOK(session, "insert into customer values(8550,'Mrs','Dorothy','Wilson','79838','333 Lee Ave,#37')")
    stopIfSqlNotOK(session, "insert into customer values(8551,'Mrs','Lorie','Williams','88048','105 Smith Avenue,#13')")
    stopIfSqlNotOK(session, "insert into customer values(8552,'Mr','David','Brown','73435','172 Ninth Boulevard,#77')")
    stopIfSqlNotOK(session, "insert into customer values(8553,'Mrs','Sandra','Smith','75048','80 Adams Road,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8554,'Mrs','Teresa','Wood','78112','362 Hillcrest Walk,#109')")
    stopIfSqlNotOK(session, "insert into customer values(8555,'Mr','Joseph','Taylor','76127','88 Main Walk,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8556,'Mrs','Sandra','Foreman','98936','384 Miller Ave,#106')")
    stopIfSqlNotOK(session, "insert into customer values(8557,'Mr','Patrick','Garza','77554','207 Valley Drive,#200')")
    stopIfSqlNotOK(session, "insert into customer values(8558,'Mr','Thomas','Wilson','10019','27 Maple Street,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8559,'Mr','Christian','Wilson','93039','107 Ash Blvd,#164')")
    stopIfSqlNotOK(session, "insert into customer values(8560,'Mrs','Patricia','Compton','79041','296 Hickory Street,#169')")
    stopIfSqlNotOK(session, "insert into customer values(8561,'Mrs','Susan','Meadows','64862','228 Fourth Walk,#13')")
    stopIfSqlNotOK(session, "insert into customer values(8562,'Mr','Terry','Miranda','75852','230 Thirteenth Blvd,#5')")
    stopIfSqlNotOK(session, "insert into customer values(8563,'Mr','Robert','Fulton','77882','124 North Road,#58')")
    stopIfSqlNotOK(session, "insert into customer values(8564,'Mr','Thomas','Walter','41331','260 Valley Blvd,#32')")
    stopIfSqlNotOK(session, "insert into customer values(8565,'Mr','Jessie','Shannon','79504','439 Second Parkway,#121')")
    stopIfSqlNotOK(session, "insert into customer values(8566,'Mrs','Patricia','Tran','79329','389 Dogwood Walk,#123')")
    stopIfSqlNotOK(session, "insert into customer values(8567,'Mrs','Frankie','Davis','78056','302 Third Parkway,#99')")
    stopIfSqlNotOK(session, "insert into customer values(8568,'Mrs','Barbara','Forbes','77588','122 Fourteenth Road,#144')")
    stopIfSqlNotOK(session, "insert into customer values(8569,'Mr','Roberto','Johnson','79540','235 Third Parkway,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8570,'Mrs','Sandra','Short','01808','402 Hill Square,#121')")
    stopIfSqlNotOK(session, "insert into customer values(8571,'Mrs','Vilma','Shaffer','98550','347 Miller Avenue,#196')")
    stopIfSqlNotOK(session, "insert into customer values(8572,'Mrs','Claudia','Brown','01813','245 Second St.,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8573,'Mr','Robert','Grant','92253','473 Lincoln Square,#134')")
    stopIfSqlNotOK(session, "insert into customer values(8574,'Mrs','Patricia','Galloway','97535','383 Lincoln St.,#122')")
    stopIfSqlNotOK(session, "insert into customer values(8575,'Mr','Tim','Taylor','77363','231 Poplar Place,#130')")
    stopIfSqlNotOK(session, "insert into customer values(8576,'Mr','Fred','Roberts','79542','253 Fourth Street,#164')")
    stopIfSqlNotOK(session, "insert into customer values(8577,'Mrs','Nancy','Hebert','23959','343 Franklin Boulevard,#14')")
    stopIfSqlNotOK(session, "insert into customer values(8578,'Mr','Christian','Jones','77459','143 Hill Ave,#52')")
    stopIfSqlNotOK(session, "insert into customer values(8579,'Mr','Byron','Smith','75418','115 Johnson Square,#111')")
    stopIfSqlNotOK(session, "insert into customer values(8580,'Mrs','Madeline','Moore','87158','452 Twelfth Street,#44')")
    stopIfSqlNotOK(session, "insert into customer values(8581,'Mr','Melvin','Jones','78357','389 Meadow Place,#183')")
    stopIfSqlNotOK(session, "insert into customer values(8582,'Mr','David','Moore','79354','483 Hickory St.,#64')")
    stopIfSqlNotOK(session, "insert into customer values(8583,'Mr','Charles','Conley','39355','366 River Drive,#174')")
    stopIfSqlNotOK(session, "insert into customer values(8584,'Mr','William','Moore','79369','62 Valley Road,#175')")
    stopIfSqlNotOK(session, "insert into customer values(8585,'Mrs','Patricia','Duncan','75569','215 Davis St.,#134')")
    stopIfSqlNotOK(session, "insert into customer values(8586,'Mr','Fernando','Atkinson','39346','205 Sunset Street,#128')")
    stopIfSqlNotOK(session, "insert into customer values(8587,'Mrs','Sandra','Buckley','18932','319 Wilson Blvd,#44')")
    stopIfSqlNotOK(session, "insert into customer values(8588,'Mr','Richard','Waters','76226','386 Seventh Street,#17')")
    stopIfSqlNotOK(session, "insert into customer values(8589,'Mr','Joseph','Davis','75788','164 East Parkway,#168')")
    stopIfSqlNotOK(session, "insert into customer values(8590,'Mr','Ben','Smith','77494','116 West Parkway,#17')")
    stopIfSqlNotOK(session, "insert into customer values(8591,'Mrs','Raquel','Morales','79847','448 Laurel Drive,#63')")
    stopIfSqlNotOK(session, "insert into customer values(8592,'Mrs','Luz','Wilson','75502','158 Lakeview Lane,#149')")
    stopIfSqlNotOK(session, "insert into customer values(8593,'Mr','Robert','Williams','78504','179 Poplar Drive,#39')")
    stopIfSqlNotOK(session, "insert into customer values(8594,'Mrs','Susan','Williams','78159','433 Davis Blvd,#128')")
    stopIfSqlNotOK(session, "insert into customer values(8595,'Mrs','Bobbie','Bryan','78355','160 Seventh Boulevard,#168')")
    stopIfSqlNotOK(session, "insert into customer values(8596,'Mrs','Nola','Richard','75382','334 Willow Parkway,#4')")
    stopIfSqlNotOK(session, "insert into customer values(8597,'Mr','John','Miller','59353','218 Central St.,#98')")
    stopIfSqlNotOK(session, "insert into customer values(8598,'Mrs','Christina','Williams','79243','239 Woodland Drive,#103')")
    stopIfSqlNotOK(session, "insert into customer values(8599,'Mrs','Sharon','Gay','13487','342 Fifth Parkway,#186')")
    stopIfSqlNotOK(session, "insert into customer values(8600,'Mrs','Barbara','Davis','75757','277 Sycamore Blvd,#112')")
    stopIfSqlNotOK(session, "insert into customer values(8601,'Mr','Richard','Brown','13114','422 Miller Blvd,#191')")
    stopIfSqlNotOK(session, "insert into customer values(8602,'Mr','Darren','Brooks','77803','460 Willow Place,#111')")
    stopIfSqlNotOK(session, "insert into customer values(8603,'Mrs','Dorothy','Jones','72820','487 Second Drive,#178')")
    stopIfSqlNotOK(session, "insert into customer values(8604,'Mrs','Jennifer','Miller','75931','154 Fifth Boulevard,#130')")
    stopIfSqlNotOK(session, "insert into customer values(8605,'Mrs','Patricia','Mooney','76034','408 First Road,#107')")
    stopIfSqlNotOK(session, "insert into customer values(8606,'Mrs','Nancy','Smith','76036','289 Wilson Square,#196')")
    stopIfSqlNotOK(session, "insert into customer values(8607,'Mrs','Jacquelyn','Farrell','77367','311 Eleventh Parkway,#142')")
    stopIfSqlNotOK(session, "insert into customer values(8608,'Mr','David','Jones','75636','55 Franklin Street,#129')")
    stopIfSqlNotOK(session, "insert into customer values(8609,'Mrs','Dorothy','Wiley','75486','270 Maple Square,#157')")
    stopIfSqlNotOK(session, "insert into customer values(8610,'Mrs','Sharon','Brown','30267','165 Willow St.,#190')")
    stopIfSqlNotOK(session, "insert into customer values(8611,'Mr','John','Wilkinson','22737','88 Hillcrest Parkway,#16')")
    stopIfSqlNotOK(session, "insert into customer values(8612,'Mr','Clayton','Williams','78635','293 River Ave,#37')")
    stopIfSqlNotOK(session, "insert into customer values(8613,'Mr','Curtis','Johnson','75067','54 Railroad Ave,#72')")
    stopIfSqlNotOK(session, "insert into customer values(8614,'Mrs','Felecia','Valenzuela','92124','410 Walnut Road,#188')")
    stopIfSqlNotOK(session, "insert into customer values(8615,'Mrs','Jody','Morris','74637','293 Central Road,#138')")
    stopIfSqlNotOK(session, "insert into customer values(8616,'Mrs','Tamra','Solis','75949','50 Sixth Blvd,#133')")
    stopIfSqlNotOK(session, "insert into customer values(8617,'Mrs','Betty','Fowler','77565','413 Park Avenue,#183')")
    stopIfSqlNotOK(session, "insert into customer values(8618,'Mrs','Sandra','Davis','75492','222 Eighth Ave,#104')")
    stopIfSqlNotOK(session, "insert into customer values(8619,'Mrs','Holly','Gordon','75505','272 Eleventh St.,#193')")
    stopIfSqlNotOK(session, "insert into customer values(8620,'Mr','Salvador','Moore','19093','406 Davis Drive,#190')")
    stopIfSqlNotOK(session, "insert into customer values(8621,'Mrs','Mildred','Williams','40983','392 Williams St.,#89')")
    stopIfSqlNotOK(session, "insert into customer values(8622,'Mr','Thomas','Carrillo','79712','318 Taylor Blvd,#8')")
    stopIfSqlNotOK(session, "insert into customer values(8623,'Mr','Fernando','Hood','63961','255 Lincoln Drive,#44')")
    stopIfSqlNotOK(session, "insert into customer values(8624,'Mr','Neil','Summers','78932','302 Fifth St.,#165')")
    stopIfSqlNotOK(session, "insert into customer values(8625,'Mrs','Jennifer','Miller','78944','215 Fourth Square,#68')")
    stopIfSqlNotOK(session, "insert into customer values(8626,'Mrs','Eloise','Hurst','79012','310 Ninth Street,#169')")
    stopIfSqlNotOK(session, "insert into customer values(8627,'Mr','Richard','Hull','79768','15 Wilson Avenue,#27')")
    stopIfSqlNotOK(session, "insert into customer values(8628,'Mr','John','Burke','75694','203 Spruce Street,#193')")
    stopIfSqlNotOK(session, "insert into customer values(8629,'Mrs','Nancy','Moore','07088','424 South Blvd,#100')")
    stopIfSqlNotOK(session, "insert into customer values(8630,'Mr','David','Williams','76043','114 Eighth St.,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8631,'Mr','Jerry','Mann','78333','399 Ridge St.,#18')")
    stopIfSqlNotOK(session, "insert into customer values(8632,'Mrs','Kathie','Freeman','12148','134 Sycamore Boulevard,#75')")
    stopIfSqlNotOK(session, "insert into customer values(8633,'Mr','John','Hanson','79029','140 Twelfth Street,#138')")
    stopIfSqlNotOK(session, "insert into customer values(8634,'Mr','Tyrone','Jones','92070','410 Miller Street,#97')")
    stopIfSqlNotOK(session, "insert into customer values(8635,'Mr','Benjamin','Rios','77474','229 Forest Ave,#110')")
    stopIfSqlNotOK(session, "insert into customer values(8636,'Mrs','Karla','Davis','57049','117 Green Lane,#175')")
    stopIfSqlNotOK(session, "insert into customer values(8637,'Mr','Robert','Taylor','87125','150 West Parkway,#23')")
    stopIfSqlNotOK(session, "insert into customer values(8638,'Mr','Charles','Townsend','78523','431 Church Road,#112')")
    stopIfSqlNotOK(session, "insert into customer values(8639,'Mr','Dwayne','Brown','78339','41 Franklin Drive,#68')")
    stopIfSqlNotOK(session, "insert into customer values(8640,'Mrs','Jennifer','Smith','37025','57 Willow Lane,#178')")
    stopIfSqlNotOK(session, "insert into customer values(8641,'Mrs','Madeline','Mcdaniel','78540','281 Locust Lane,#152')")
    stopIfSqlNotOK(session, "insert into customer values(8642,'Mrs','Ada','Moore','54730','416 Jefferson Place,#125')")
    stopIfSqlNotOK(session, "insert into customer values(8643,'Mrs','Barbara','Smith','79339','235 Highland Blvd,#142')")
    stopIfSqlNotOK(session, "insert into customer values(8644,'Mr','John','Miller','78382','485 Dogwood Lane,#124')")
    stopIfSqlNotOK(session, "insert into customer values(8645,'Mrs','Christi','Wilson','76865','98 Miller Lane,#105')")
    stopIfSqlNotOK(session, "insert into customer values(8646,'Mr','David','Williams','27294','497 Franklin Street,#41')")
    stopIfSqlNotOK(session, "insert into customer values(8647,'Mrs','Sandra','Brown','79031','105 Chestnut Street,#135')")
    stopIfSqlNotOK(session, "insert into customer values(8648,'Mr','Tim','Hubbard','75835','349 Ninth Square,#190')")
    stopIfSqlNotOK(session, "insert into customer values(8649,'Mr','Thomas','Brown','79085','343 South Drive,#141')")
    stopIfSqlNotOK(session, "insert into customer values(8650,'Mrs','Connie','Gomez','24558','310 Hickory Street,#6')")
    stopIfSqlNotOK(session, "insert into customer values(8651,'Mrs','Trina','Jones','93103','146 Lakeview Road,#92')")
    stopIfSqlNotOK(session, "insert into customer values(8652,'Mr','Tyrone','Whitehead','75765','420 Taylor Square,#34')")
    stopIfSqlNotOK(session, "insert into customer values(8653,'Mr','William','Miller','78838','148 Jefferson Square,#105')")
    stopIfSqlNotOK(session, "insert into customer values(8654,'Mr','Charles','Wilson','70112','384 Cherry Street,#96')")
    stopIfSqlNotOK(session, "insert into customer values(8655,'Mr','Everett','Moore','79243','452 North Lane,#75')")
    stopIfSqlNotOK(session, "insert into customer values(8656,'Mr','Allan','Caldwell','22135','452 Church Street,#119')")
    stopIfSqlNotOK(session, "insert into customer values(8657,'Mrs','Patricia','Miller','75059','417 Johnson Road,#102')")
    stopIfSqlNotOK(session, "insert into customer values(8658,'Mr','William','Jones','88135','171 Ninth Avenue,#22')")
    stopIfSqlNotOK(session, "insert into customer values(8659,'Mr','Robert','Johnson','76889','278 Hickory St.,#117')")
    stopIfSqlNotOK(session, "insert into customer values(8660,'Mrs','Betty','Davis','75771','226 Ninth Square,#84')")
    stopIfSqlNotOK(session, "insert into customer values(8661,'Mr','Charles','Knapp','75684','234 Park Road,#69')")
    stopIfSqlNotOK(session, "insert into customer values(8662,'Mr','John','Matthews','70765','290 Lakeview Boulevard,#192')")
    stopIfSqlNotOK(session, "insert into customer values(8663,'Mr','John','Jones','75455','10 Fourth Place,#5')")
    stopIfSqlNotOK(session, "insert into customer values(8664,'Mr','Ricardo','Bush','87574','219 Lake Road,#49')")
    stopIfSqlNotOK(session, "insert into customer values(8665,'Mr','Glen','James','27557','101 Willow Ave,#170')")
    stopIfSqlNotOK(session, "insert into customer values(8666,'Mr','Jose','Johnson','75114','41 Dogwood Road,#49')")
    stopIfSqlNotOK(session, "insert into customer values(8667,'Mrs','Nona','Hamilton','75085','100 South Blvd,#200')")
    stopIfSqlNotOK(session, "insert into customer values(8668,'Mr','Richard','Mooney','78870','91 Sycamore Blvd,#163')")
    stopIfSqlNotOK(session, "insert into customer values(8669,'Mrs','Sharon','Smith','77587','240 Elm Walk,#139')")
    stopIfSqlNotOK(session, "insert into customer values(8670,'Mr','William','Strong','76623','162 Spruce Boulevard,#21')")
    stopIfSqlNotOK(session, "insert into customer values(8671,'Mrs','Jennifer','Wilson','76037','61 Eleventh Blvd,#36')")
    stopIfSqlNotOK(session, "insert into customer values(8672,'Mr','Andre','Duran','77470','57 Jefferson Drive,#71')")
    stopIfSqlNotOK(session, "insert into customer values(8673,'Mr','William','Moore','85051','223 Smith Place,#120')")
    stopIfSqlNotOK(session, "insert into customer values(8674,'Mr','Donald','Oneil','76888','167 Main Drive,#65')")
    stopIfSqlNotOK(session, "insert into customer values(8675,'Mr','Bernard','Smith','93660','180 Jackson Boulevard,#155')")
    stopIfSqlNotOK(session, "insert into customer values(8676,'Mr','Robert','Stafford','76953','196 Laure