/*!******************************************************************************

  @file         hkb512.h

  ------------------------------------------------------------------------------

  @author       FerdiF

  @brief        KB_ConsistView_lock

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB512_H
#define HKB512_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x06\x69\xf9\x99\x53\xac\xef\x4f\x00\xdf\xfc\x7d\x8c\x4f\xe7\x63'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void k512MonInit ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k512MonEndTransaction (
    tsp00_TaskId                         TaskId,
    tgg00_TransIndex                     TransIndex,
    pasbool                              committed);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k512MonRestartTransaction (
    tsp00_Addr            VAR_VALUE_REF  monContextPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k512MonStartTransaction (
    tgg00_TransContext    VAR_VALUE_REF  Trans,
    tsp00_Addr            VAR_VALUE_REF  monContextPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k512SetTransactionComment (
    tsp00_TaskId                         TaskId,
    tgg00_TransIndex                     TransIndex,
    tsp00_Int2                           commentLength,
    SAPDB_Char*                          pComment);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

