/*!******************************************************************************

  @file         hgg06.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        GG_cpp_auxiliary_functions

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HGG06_H
#define HGG06_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x43\xa6\xc9\xd8\x81\x64\xf1\xa8\x1c\x1b\x7a\x36\x98\xc5\x2b\x4c'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal tsp00_Int4 gg06Align (
    SAPDB_Int4                           length,
    SAPDB_Int4                           alignment);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06BuildRedoSession (
    tgg91_SessionNo       VAR_VALUE_REF  Session,
    tgg91_TransNo         VAR_VALUE_REF  transno);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06BuildTaskSession (
    tgg91_SessionNo       VAR_VALUE_REF  Session);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void g06TaskTypeToLine (
    char                                 TaskType,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06BuildRef (
    tgg91_PageRef         VAR_VALUE_REF  PageRef,
    tsp00_Int4                           Pno,
    tsp00_Int4                           Pos);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06Cint6Decr (
    tgg90_Cint6           VAR_VALUE_REF  Cint6);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06Cint6Incr (
    tgg90_Cint6           VAR_VALUE_REF  Cint6);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06Cint6ToLine (
    tgg90_Cint6           VAR_VALUE_REF  Cint6,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06FileVersIncr (
    tgg91_FileVersion     VAR_VALUE_REF  FileVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06FileVersToLine (
    tgg91_FileVersion     VAR_VALUE_REF  FileVers,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06GetObjHeaderParam (
    void*                                ObjHeaderBuf,
    tgg00_ObjTransInfo    VAR_VALUE_REF  ObjTransInfo,
    tgg00_ObjPagePos      VAR_VALUE_REF  NextFreeObj,
    tgg00_ObjState        VAR_VALUE_REF  ObjState,
    tgg00_ObjFrameVers    VAR_VALUE_REF  ObjFrameVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

class tgg92_KernelOid;

externPascal tsp00_Int4 gg06GetOidFrameVers (
    tgg92_KernelOid&                     oid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06GetOidPos (
    tgg92_KernelOid&                     oid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06InitObjTransInfo (
    tgg00_ObjTransInfo    VAR_VALUE_REF  ObjTransInfo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06Int4Get (
    const tsp00_BytePtr                  buffer,
    tsp00_Int4                           pos);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06Int4FromUint2 (
    tsp00_Uint2                          Uint2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06Int4ToUint2 (
    tsp00_Int4                           Int4,
    tsp00_Uint2           VAR_VALUE_REF  Uint2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsDummyFileVers (
    tgg91_FileVersion     VAR_VALUE_REF  FileVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsDummyRef (
    tgg91_PageRef         VAR_VALUE_REF  PageRef);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsDummyTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsEqOidPnoPos (
    tgg92_KernelOid&                     oid1,
    tgg92_KernelOid&                     oid2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsGreaterOrEqualUint4 (
    tsp00_Uint4                          Left,
    tsp00_Uint4                          Right);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsMaxSession (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsMaxTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsNilObjFileNo (
    tgg00_ObjFileNo                      ObjFileNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsNilOid (
    tgg92_KernelOid&                     oid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsNilRef (
    tgg91_PageRef         VAR_VALUE_REF  PageRef);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsNilSession (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsNilTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsSpecialFileVers (
    tgg91_FileVersion     VAR_VALUE_REF  FileVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsZeroTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06OidToLine (
    tgg92_KernelOid&                     oid,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06PnoGet (
    tgg90_Cint4           VAR_VALUE_REF  Cint4);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06PnoPut (
    tgg90_Cint4           VAR_VALUE_REF  Cint4,
    tsp00_Int4                           int4);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06RefPno (
    tgg91_PageRef         VAR_VALUE_REF  PageRef);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06RefPos (
    tgg91_PageRef         VAR_VALUE_REF  PageRef);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SessionBecomes (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo,
    tsp00_Int4                           IntValue);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SessionDecr (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06SessionGetInt4 (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SessionIncr (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SessionToLine (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetDummyFileVers (
    tgg91_FileVersion     VAR_VALUE_REF  FileVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetDummyRef (
    tgg91_PageRef         VAR_VALUE_REF  PageRef);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetDummyTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetNilOid (
    tgg92_KernelOid&                     oid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetNilRef (
    tgg91_PageRef         VAR_VALUE_REF  PageRef);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetNilSession (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetNilTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetOid (
    tgg92_KernelOid&                     oid,
    tsp00_Int4                           pno,
    tsp00_Int4                           pos,
    tsp00_Int4                           FrameVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetOidFrameVers (
    tgg92_KernelOid&                     oid,
    tsp00_Int4                           FrameVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetOidPos (
    tgg92_KernelOid&                     oid,
    tsp00_Int4                           pos);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetSpecialFileVers (
    tgg91_FileVersion     VAR_VALUE_REF  FileVers);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetZeroCint6 (
    tgg90_Cint6           VAR_VALUE_REF  Cint6);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetZeroSession (
    tgg91_SessionNo       VAR_VALUE_REF  SessionNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SetZeroTrans (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06SizeofObjHeader ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06SubtransDecr (
    tgg00_SubtransNo      VAR_VALUE_REF  SubtransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06TransBecomes (
    tgg91_TransNo         VAR_VALUE_REF  TransNo,
    tsp00_Int4                           IntValue);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06TransDecr (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06TransGetInt4 (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06TransIncr (
    tgg91_TransNo         VAR_VALUE_REF  TransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06TransToLine (
    tgg91_TransNo         VAR_VALUE_REF  TransNo,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06Min (
    tsp00_Int4                           value1,
    tsp00_Int4                           value2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg06Max (
    tsp00_Int4                           value1,
    tsp00_Int4                           value2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06buildCompressedKey (
    const tsp00_Byte*                    key,
    tsp00_Int4                           keySize,
    tsp00_Int4                           keyStartPosition,
    tsp00_Int4                           keyLength,
    tsp00_Int4                           compressedKeySize,
    tsp00_Byte*                          compressedKey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06CalculateHash (
    const tsp00_Byte*                    key,
    tsp00_Uint4                          keysize,
    tsp00_Uint4                          hashtype,
    tsp00_Uint4           VAR_VALUE_REF  hashvalue);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06CalculateRowIdHashPrimNumbers ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06DeviceStateToLine (
    integer                              devicestate,
    integer               VAR_VALUE_REF  length,
    tsp00_Line            VAR_ARRAY_REF  line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06FlushModeToLine (
    integer                              flushmode,
    integer               VAR_VALUE_REF  length,
    tsp00_Line            VAR_ARRAY_REF  line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06LogActionToLine (
    integer                              ActionType,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06LogSavepointReasonToLine (
    integer                              Reason,
    integer               VAR_VALUE_REF  LineLen,
    tsp00_Line            VAR_ARRAY_REF  Line);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg06IsSurrogateGreater (
    const tgg00_Surrogate  VAR_ARRAY_REF  surrogateA,
    const tgg00_Surrogate  VAR_ARRAY_REF  surrogateB);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg06UInt4toLine (
    SAPDB_UInt4                          number,
    integer                              maxNumWidth,
    tsp00_Line            VAR_ARRAY_REF  outArray);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

