/*!******************************************************************************

  @file         hbd20.h

  ------------------------------------------------------------------------------

  @author       <unknown>

  @brief        <unknown topic>

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD20_H
#define HBD20_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xc1\x62\xcd\x9c\xa5\xc5\x97\x72\x16\x17\x4d\x43\x8f\x6c\x9b\x4b'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"
#include "gbd02.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void bd20CheckExclusiveLockedPageForIO (
    tsp00_TaskId             TaskId,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    tbd_nodeptr              pCBlock,
    pasbool               &  bWritePage,
    tbd02_CachePageState  &  PageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20CheckRootNptrs (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_PageNo             Root,
    tsp00_PageNo             pageNo,
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20LockPageForFree (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    pasbool                  FirstCall,
    pasbool               &  PageLockedToFree,
    tbd02_CachePageState  &  PageState,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20FreePage (
    tsp00_TaskId             TaskId,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    tgg00_BasisError      &  TrError,
    tsp00_Int2            &  ExclFileLockCnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20FlushDataCache (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ForcedIODone (
    tbd_nodeptr              pCBlock,
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20GetPage (
    tsp00_TaskId             TaskId,
    tgg00_WaitContext     &  WaitContext,
    tgg00_BasisError      &  TrError,
    tsp00_Int2            &  ExclFileLockCnt,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    tbd_node_request_Param     NodeRequest,
    tbd_nodeptr           &  nptr,
    tbd_nodeptr &            cbptr,
    tbd02_CachePageState  &  PageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20InitDataCache (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_Int4               TotalFreeFrames,
    tsp00_Int4               TotalDataPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd20IsPageChanged (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd20IsPageExclusiveLocked (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd20IsPageShareLocked (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int2 bd20GetPageUsageCount (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20LoadPage (
    tsp00_TaskId             taskId,
    tsp00_PageNo             pageNo,
    tgg00_RecoveryMode_Param     recMode,
    pasbool                  bSetToChanged,
    pasbool                  bIsClustered,
    tgg00_PageType        &  pageType,
    tgg00_BasisError      &  trError,
    tgg00_FileId          &  fileId,
    tbd_nodeptr           &  pFrame,
    tbd_nodeptr &            pCBlock,
    tbd02_CachePageState  &  pageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20NewPage (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr,
    tbd02_CachePageState  &  PageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20RReleasePage (
    tsp00_TaskId             TaskId,
    tsp00_Int2            &  ExclFileLockCnt,
    tgg00_FileId          &  FileId,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr,
    tsp00_PageNo             pageNo,
    tgg00_RecoveryMode_Param     recMode,
    tbd_lru_info_Param       LruInfo,
    pasbool                  bDoReduceSyncCnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20WReleasePage (
    tsp00_TaskId             TaskId,
    tsp00_Int2            &  ExclFileLockCnt,
    tgg00_FileId          &  FileId,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr,
    tsp00_PageNo             pageNo,
    tgg00_RecoveryMode_Param     recMode,
    pasbool                  isClustered,
    tbd02_SwapState       &  IoState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ReplaceOldOccupant (
    tsp00_TaskId             TaskId,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    tbd_nodeptr              cbptr,
    pasbool                  bLockPageExclusive);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ShutdownDataCache (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20UsePage (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_PageNo             PageNo,
    tgg00_RecoveryMode_Param     recMode,
    tbd_nodeptr              cbptr,
    tbd_nodeptr           &  nptr,
    pasbool                  bLockPageExclusive);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20UsePageAfterLoad (
    tsp00_TaskId             taskId,
    tsp00_PageNo             pageNo,
    tgg00_RecoveryMode_Param     recMode,
    pasbool                  bSetToChanged,
    pasbool                  bIsClustered,
    tbd_nodeptr              pCBlock,
    tgg00_FileId          &  file_id,
    tgg00_BasisError      &  trError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ClearAccessStatistic (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20GetAccessStatistic (
    tsp00_TaskId             TaskId,
    tsp00_8ByteCounter    &  HistoryTotal,
    tsp00_8ByteCounter    &  HistoryHit,
    tsp00_8ByteCounter    &  HistoryMiss,
    tsp00_8ByteCounter    &  OmsDataTotal,
    tsp00_8ByteCounter    &  OmsDataHit,
    tsp00_8ByteCounter    &  OmsDataMiss,
    tsp00_8ByteCounter    &  SqlDataTotal,
    tsp00_8ByteCounter    &  SqlDataHit,
    tsp00_8ByteCounter    &  SqlDataMiss);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

