/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef KERNEL_MESSAGES_HPP
#define KERNEL_MESSAGES_HPP

// Generated Header file Kernel_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define KERNEL_ERR_BAD_CHECKSUM                     SAPDBErr_MessageList::Error,20000,"Bad page - checksums not maching",0
#define KERNEL_ERR_BAD_CHECKSUM_ID 20000
#define KERNEL_ERR_CHECKSUM_MISMATCH                SAPDBErr_MessageList::Error,20001,"Bad page - calculated checksum [ %s ] header checksum [ %s ] trailer checksum [ %s ]",3
#define KERNEL_ERR_CHECKSUM_MISMATCH_ID 20001
#define KERNEL_ERR_BAD_WRITE_CNT                    SAPDBErr_MessageList::Error,20002,"Bad page - header and trailer checksum not matching",0
#define KERNEL_ERR_BAD_WRITE_CNT_ID 20002
#define KERNEL_ERR_WRITE_CNT_MISMATCH               SAPDBErr_MessageList::Error,20003,"Bad page - header checksum [ %s ] trailer checksum [ %s ]",2
#define KERNEL_ERR_WRITE_CNT_MISMATCH_ID 20003
#define KERNEL_ERR_BAD_ALGO                         SAPDBErr_MessageList::Error,20004,"Bad page - page check algorithm is invalid",0
#define KERNEL_ERR_BAD_ALGO_ID 20004
#define KERNEL_ERR_HEADER_TRAILER_MISMATCH          SAPDBErr_MessageList::Error,20005,"Bad page - header and trailer not matching",0
#define KERNEL_ERR_HEADER_TRAILER_MISMATCH_ID 20005
#define KERNEL_ERR_HEADER_INFO                      SAPDBErr_MessageList::Error,20006,"Header [ %s - %s - %s - %s -%s ]",5
#define KERNEL_ERR_HEADER_INFO_ID 20006
#define KERNEL_ERR_TRAILER_INFO                     SAPDBErr_MessageList::Error,20007,"Trailer[ %s - %s - %s - %s -%s ]",5
#define KERNEL_ERR_TRAILER_INFO_ID 20007
#define KERNEL_ERR_PAGE_BAD_VERIFY                  SAPDBErr_MessageList::Error,20008,"Parity mismatch - header [ %s ] trailer [ %s ]",2
#define KERNEL_ERR_PAGE_BAD_VERIFY_ID 20008
#define KERNEL_ERR_OPEN_FAILED                      SAPDBErr_MessageList::Error,20009,"The opening of file %s failed because of %s",2
#define KERNEL_ERR_OPEN_FAILED_ID 20009
#define KERNEL_ERR_SET_TO_OCCUPIED                  SAPDBErr_MessageList::Error,20010,"Could not mark snapshot restart page as occupied in FBM",0
#define KERNEL_ERR_SET_TO_OCCUPIED_ID 20010
#define KERNEL_EMERGENCY_SHUTDOWN                   SAPDBErr_MessageList::Error,20011,"%s, %s",2
#define KERNEL_EMERGENCY_SHUTDOWN_ID 20011
#define KERNEL_UNTILDATE_TOO_OLD                    SAPDBErr_MessageList::Error,20012,"UNTIL DATE is older than last savepoint (%s %s)",2
#define KERNEL_UNTILDATE_TOO_OLD_ID 20012
#define KERNEL_ENTER_CRITICAL_STATE_FAILED          SAPDBErr_MessageList::Error,20013,"Admin command cannot enter critical state '%s'",1
#define KERNEL_ENTER_CRITICAL_STATE_FAILED_ID 20013
#define KERNEL_INIT_STANDBY_NOT_ALLOWED             SAPDBErr_MessageList::Error,20014,"'INIT STANDBY' not for own '%s' = master '%s'",2
#define KERNEL_INIT_STANDBY_NOT_ALLOWED_ID 20014
#define KERNEL_STANDBY_NODELIST_OP_FAILED           SAPDBErr_MessageList::Error,20015,"'%s' internal list operation failed for '%s'",2
#define KERNEL_STANDBY_NODELIST_OP_FAILED_ID 20015
#define KERNEL_STANDBY_SEND_TO_NODE_FAILED          SAPDBErr_MessageList::Error,20016,"'%s' sending command to node '%s' failed",2
#define KERNEL_STANDBY_SEND_TO_NODE_FAILED_ID 20016
#define KERNEL_RESTART_FILESYSTEM_FAILED            SAPDBErr_MessageList::Error,20017,"RestartFilesystem failed with '%s'",1
#define KERNEL_RESTART_FILESYSTEM_FAILED_ID 20017
#define KERNEL_PREPARE_LOGINFO_PAGE_FOR_READ_FAILED SAPDBErr_MessageList::Error,20018,"Could not open log info page for read.",0
#define KERNEL_PREPARE_LOGINFO_PAGE_FOR_READ_FAILED_ID 20018
#define KERNEL_RESET_READONLY_FAILED                SAPDBErr_MessageList::Error,20019,"Reset data readonly state failed with '%s'",1
#define KERNEL_RESET_READONLY_FAILED_ID 20019
#define KERNEL_UNHANDLED_MESSAGES                   SAPDBErr_MessageList::Error,20020,"List of unhandled messages above.",0
#define KERNEL_UNHANDLED_MESSAGES_ID 20020
#define KERNEL_RESTART_FOR_STANDBY_NOT_ALLOWED      SAPDBErr_MessageList::Error,20021,"RESTART for standby not allwowed, because master is active.",0
#define KERNEL_RESTART_FOR_STANDBY_NOT_ALLOWED_ID 20021
#define KERNEL_CHECK_HOTSTANDBY_CONFIG              SAPDBErr_MessageList::Error,20022,"RTEHSS_KernelInterface::CheckForValidHotStandbyConfiguration() returned 'InvalidConfiguration'",0
#define KERNEL_CHECK_HOTSTANDBY_CONFIG_ID 20022
#define KERNEL_UNTILIOSEQ_TOO_OLD                   SAPDBErr_MessageList::Error,20023,"UNTIL IOSEQUENCE is older then last savepoint %s",1
#define KERNEL_UNTILIOSEQ_TOO_OLD_ID 20023
#define KERNEL_ALREADY_ACTIVATED                    SAPDBErr_MessageList::Warning,20024,"is already activated.",0
#define KERNEL_ALREADY_ACTIVATED_ID 20024
#define KERNEL_ACTIVATE_IS_MISSING                  SAPDBErr_MessageList::Warning,20025,"ACTIVATE is missing",0
#define KERNEL_ACTIVATE_IS_MISSING_ID 20025
#define KERNEL_UNKNOWN_ACTIVATION_STATE             SAPDBErr_MessageList::Warning,20026,"Unknown activation state '%s' found.",1
#define KERNEL_UNKNOWN_ACTIVATION_STATE_ID 20026
#define KERNEL_RESTART_LOCKLIST_FAILED              SAPDBErr_MessageList::Warning,20027,"Sql lock manager could not be initialized",0
#define KERNEL_RESTART_LOCKLIST_FAILED_ID 20027
#define KERNEL_INIT_LOG_FAILED                      SAPDBErr_MessageList::Warning,20028,"Initialization of log for '%s' failed with '%s'",2
#define KERNEL_INIT_LOG_FAILED_ID 20028
#define KERNEL_REDO_ERROR                           SAPDBErr_MessageList::Warning,20029,"Redo error '%s' occured",1
#define KERNEL_REDO_ERROR_ID 20029
#define KERNEL_INIT_TERMSET_FAILED                  SAPDBErr_MessageList::Warning,20030,"Termset initialization failed.",0
#define KERNEL_INIT_TERMSET_FAILED_ID 20030
#define KERNEL_CREATE_ERROR_FILE_FAILED             SAPDBErr_MessageList::Warning,20031,"Create of errorfile failed",0
#define KERNEL_CREATE_ERROR_FILE_FAILED_ID 20031
#define KERNEL_SAVE_GOOD_FAILED                     SAPDBErr_MessageList::Warning,20032,"Saving last known good config failed with '%s', '%s'.",2
#define KERNEL_SAVE_GOOD_FAILED_ID 20032
#define KERNEL_ATTACH_LOGVOLUMES_ERROR              SAPDBErr_MessageList::Warning,20033,"Error occured during open log volumes",0
#define KERNEL_ATTACH_LOGVOLUMES_ERROR_ID 20033
#define KERNEL_ATTACH_DATAVOLUMES_ERROR             SAPDBErr_MessageList::Warning,20034,"Error occured during open data volumes",0
#define KERNEL_ATTACH_DATAVOLUMES_ERROR_ID 20034
#define KERNEL_CLEAR_LOG_ERROR                      SAPDBErr_MessageList::Warning,20035,"Error '%s' occured during clear log volume",1
#define KERNEL_CLEAR_LOG_ERROR_ID 20035
#define KERNEL_ENABLE_MIGRATION                     SAPDBErr_MessageList::Info,20036,"Migration enabled for '%s'",1
#define KERNEL_ENABLE_MIGRATION_ID 20036
#define KERNEL_SWITCHED_TO_ACTIVATED                SAPDBErr_MessageList::Info,20037,"Database is activated",0
#define KERNEL_SWITCHED_TO_ACTIVATED_ID 20037
#define KERNEL_SWITCHED_TO_ACTIVATED2               SAPDBErr_MessageList::Info,20038,"Database is activated for log only recovery",0
#define KERNEL_SWITCHED_TO_ACTIVATED2_ID 20038
#define KERNEL_REDO_LOG_FINISHED                    SAPDBErr_MessageList::Info,20039,"Kernel state: 'REDO LOG' finished",0
#define KERNEL_REDO_LOG_FINISHED_ID 20039
#define KERNEL_STATE_IS_ADMIN                       SAPDBErr_MessageList::Info,20040,"Kernel state: 'ADMIN' reached",0
#define KERNEL_STATE_IS_ADMIN_ID 20040
#define KERNEL_STATE_IS_ONLINE                      SAPDBErr_MessageList::Info,20041,"Kernel state: 'ONLINE' reached",0
#define KERNEL_STATE_IS_ONLINE_ID 20041
#define KERNEL_INIT_STANDBY_START                   SAPDBErr_MessageList::Info,20042,"Kernel state: 'INIT STANDBY' for master '%s' started",1
#define KERNEL_INIT_STANDBY_START_ID 20042
#define KERNEL_NEW_STANDBY                          SAPDBErr_MessageList::Info,20043,"Hotstandby: new standby on %s registered with offset %s",2
#define KERNEL_NEW_STANDBY_ID 20043
#define KERNEL_STANDBY_REMOVED                      SAPDBErr_MessageList::Info,20044,"Hotstandby: standby (%s) removed",1
#define KERNEL_STANDBY_REMOVED_ID 20044
#define KERNEL_LAST_STANDBY_REMOVED                 SAPDBErr_MessageList::Info,20045,"Hotstandby: last standby (%s) removed",1
#define KERNEL_LAST_STANDBY_REMOVED_ID 20045
#define KERNEL_STANDBY_REGISTER                     SAPDBErr_MessageList::Info,20046,"Hotstandby: register succeded; redo until offset %s",1
#define KERNEL_STANDBY_REGISTER_ID 20046
#define KERNEL_SYNC_RECEIVED                        SAPDBErr_MessageList::Info,20047,"HotStandby: Synchronize: redo until offset %s",1
#define KERNEL_SYNC_RECEIVED_ID 20047
#define KERNEL_SYNCREPLY_RECEIVED                   SAPDBErr_MessageList::Info,20048,"HotStandby: SynchronizeReply from %s offset %s received",2
#define KERNEL_SYNCREPLY_RECEIVED_ID 20048
#define KERNEL_CRITICAL_STATE_NOT_ENTERED           SAPDBErr_MessageList::Info,20049,"Could not enter critical state '%s'.",1
#define KERNEL_CRITICAL_STATE_NOT_ENTERED_ID 20049
#define KERNEL_HINT_HOTSTANDBY_CONFIG               SAPDBErr_MessageList::Info,20050,"The database parameters are neither correctly configured for 'HotStandby' nor for 'Normal' operation.",0
#define KERNEL_HINT_HOTSTANDBY_CONFIG_ID 20050
#define KERNEL_COMMAND_NOT_ALLOWED                  SAPDBErr_MessageList::Info,20051,"'%s' is not allowed in mode '%s'.",2
#define KERNEL_COMMAND_NOT_ALLOWED_ID 20051
#define DEVTEST_TRY_LOCK_OBJ                        SAPDBErr_MessageList::Info,20052,"COLLISION LIST OUTPUT TEST: TR%s TRIES TO LOCK OBJECT %s.%s => %s",4
#define DEVTEST_TRY_LOCK_OBJ_ID 20052
#define DEVTEST_LIST_OBJ_COLLS_BEGIN                SAPDBErr_MessageList::Info,20053,"COLLISION LIST OUTPUT TEST: Object Collisionlist Begin",0
#define DEVTEST_LIST_OBJ_COLLS_BEGIN_ID 20053
#define DEVTEST_LIST_OBJ_COLLS                      SAPDBErr_MessageList::Info,20054,"** %s TR%s %s.%s.%s",5
#define DEVTEST_LIST_OBJ_COLLS_ID 20054
#define DEVTEST_LIST_OBJ_COLLS_END                  SAPDBErr_MessageList::Info,20055,"COLLISION LIST OUTPUT TEST: Object Collisionlist End",0
#define DEVTEST_LIST_OBJ_COLLS_END_ID 20055

#endif /* KERNEL_MESSAGES_HPP */
