/*
        ========== licence begin  GPL
        Copyright (C) 2006 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef DATA_MESSAGES_HPP
#define DATA_MESSAGES_HPP

// Generated Header file Data_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define DATA_NOT_IMPLEMENTED                    SAPDBErr_MessageList::Error,20000,"%s not yet implemented",1
#define DATA_NOT_IMPLEMENTED_ID 20000
#define DATA_PAM_ERROR                          SAPDBErr_MessageList::Error,20001,"%s: PageId=%s/%s",3
#define DATA_PAM_ERROR_ID 20001
#define DATA_CHAIN_IS_INCONSISTENT              SAPDBErr_MessageList::Error,20002,"Chain is inconsistent: '%s'->'%s'",2
#define DATA_CHAIN_IS_INCONSISTENT_ID 20002
#define DATA_CHAIN_SPLITTED_RECORD_TRUNCATED    SAPDBErr_MessageList::Error,20003,"Truncated record: %s,%s",2
#define DATA_CHAIN_SPLITTED_RECORD_TRUNCATED_ID 20003
#define DATA_ERR_BAD_CHECKSUM                   SAPDBErr_MessageList::Error,20004,"Bad page - checksums not matching",0
#define DATA_ERR_BAD_CHECKSUM_ID 20004
#define DATA_ERR_CHECKSUM_MISMATCH              SAPDBErr_MessageList::Error,20005,"Bad page - calculated checksum [ %s ] checksum found in page [ %s ]",2
#define DATA_ERR_CHECKSUM_MISMATCH_ID 20005
#define DATA_ERR_BAD_WRITE_CNT                  SAPDBErr_MessageList::Error,20006,"Bad page - header and trailer write count not matching",0
#define DATA_ERR_BAD_WRITE_CNT_ID 20006
#define DATA_ERR_WRITE_CNT_MISMATCH             SAPDBErr_MessageList::Error,20007,"Bad page - header write count [ %s ] trailer write count [ %s ]",2
#define DATA_ERR_WRITE_CNT_MISMATCH_ID 20007
#define DATA_ERR_BAD_PAGE_TYPE                  SAPDBErr_MessageList::Error,20008,"Bad page - page type '%s' is invalid",1
#define DATA_ERR_BAD_PAGE_TYPE_ID 20008
#define DATA_ERR_BAD_ALGO                       SAPDBErr_MessageList::Error,20009,"Bad page - page check algorithm is invalid",0
#define DATA_ERR_BAD_ALGO_ID 20009
#define DATA_ERR_CORRUPTED_PAGE                 SAPDBErr_MessageList::Error,20010,"Corrupted data page %s belongs to root %s which is of filetype '%s'",3
#define DATA_ERR_CORRUPTED_PAGE_ID 20010
#define DATA_NOT_ENOUGH_SPACE                   SAPDBErr_MessageList::Error,20011,"PageAccessManager: cannot allocate new pages",0
#define DATA_NOT_ENOUGH_SPACE_ID 20011
#define DATA_ERROR_VERIFY_PAGE                  SAPDBErr_MessageList::Error,20012,"Verify page %s next: %s, root: %s, chainroot: %s, prev: %s",5
#define DATA_ERROR_VERIFY_PAGE_ID 20012
#define DATA_ERROR_MARK_USED                    SAPDBErr_MessageList::Error,20013,"Verify page %s: error during 'mark as used'",1
#define DATA_ERROR_MARK_USED_ID 20013
#define DATA_ERROR_VERIFY_CHAIN                 SAPDBErr_MessageList::Error,20014,"Verify chain: root %s, error: %s, first page failed: %s",3
#define DATA_ERROR_VERIFY_CHAIN_ID 20014
#define DATA_ERR_PRIM_STATISTIC                 SAPDBErr_MessageList::Error,20015,"Base error '%s' during update statistic on record index %s on page %s of root %s",4
#define DATA_ERR_PRIM_STATISTIC_ID 20015
#define DATA_ERR_SCAN_TREE                      SAPDBErr_MessageList::Error,20016,"Base error '%s' during tree scan operation on record index %s on page %s of root %s",4
#define DATA_ERR_SCAN_TREE_ID 20016
#define DATA_COMPONENT_TEST_FAILED              SAPDBErr_MessageList::Error,20017,"Component test failed: %s",1
#define DATA_COMPONENT_TEST_FAILED_ID 20017
#define DATA_ERROR_CHAIN_FIX_SIZE_MISMATCH      SAPDBErr_MessageList::Error,20018,"fix size is %s but requested is %s",2
#define DATA_ERROR_CHAIN_FIX_SIZE_MISMATCH_ID 20018
#define DATA_PAGE_SPLIT_SPACE_VERIFY            SAPDBErr_MessageList::Error,20019,"split space page verify failed: pno: %s",1
#define DATA_PAGE_SPLIT_SPACE_VERIFY_ID 20019
#define DATA_ERR_BAD_PAGE                       SAPDBErr_MessageList::Error,20020,"Bad data page %s belongs to root %s which is of filetype '%s'",3
#define DATA_ERR_BAD_PAGE_ID 20020
#define DATA_ERR_PAGENO_OUT_OF_RANGE            SAPDBErr_MessageList::Error,20021,"Requested %s data page %s of root %s is greater than the upper limit of %s.",4
#define DATA_ERR_PAGENO_OUT_OF_RANGE_ID 20021
#define DATA_CALLED_WITH_ERROR                  SAPDBErr_MessageList::Error,20022,"%s was called with error. It might be an unhandled error.",1
#define DATA_CALLED_WITH_ERROR_ID 20022
#define DATA_FILE_TYPE_INVALID                  SAPDBErr_MessageList::Error,20023,"Filetype: %s unexpected.",1
#define DATA_FILE_TYPE_INVALID_ID 20023
#define DATA_RECOVERY_MODE_STATIC_NOT_POSSIBLE  SAPDBErr_MessageList::Error,20024,"RecoveryMode static not possible",0
#define DATA_RECOVERY_MODE_STATIC_NOT_POSSIBLE_ID 20024
#define DATA_PAGE_ALREADY_ASSIGNED              SAPDBErr_MessageList::Error,20025,"Data page is already assigned.",0
#define DATA_PAGE_ALREADY_ASSIGNED_ID 20025
#define DATA_PAGE_NOT_ASSIGNED                  SAPDBErr_MessageList::Error,20026,"%s: Data page is not assigned.",1
#define DATA_PAGE_NOT_ASSIGNED_ID 20026
#define DATA_COULD_NOT_APPEND_NEW_PAGE          SAPDBErr_MessageList::Error,20027,"A new page could not be appended to a page chain.",0
#define DATA_COULD_NOT_APPEND_NEW_PAGE_ID 20027
#define DATA_NOT_ENOUGH_FREE_PAGES_AVAILABLE    SAPDBErr_MessageList::Error,20028,"Not enough free pages available. (%s)",1
#define DATA_NOT_ENOUGH_FREE_PAGES_AVAILABLE_ID 20028
#define DATA_CHAIN_TRUNCATE_ERROR               SAPDBErr_MessageList::Error,20029,"Truncation of data chain failed with '%s' newlastpageno=%s newfirstfreeoffset=%s",3
#define DATA_CHAIN_TRUNCATE_ERROR_ID 20029
#define DATA_PAGE_BASIC_CHECK_AFTER_READ_FAILED SAPDBErr_MessageList::Error,20030,"CORRUPTED PAGE DETECTED: CheckType=%s, CalculatedParity=%s, ReadParity=%s",3
#define DATA_PAGE_BASIC_CHECK_AFTER_READ_FAILED_ID 20030
#define DATA_PAGE_BASIC_CHECK_TRAILER           SAPDBErr_MessageList::Error,20031,"CORRUPTED PAGE DETECTED: end of page was overwritten.",0
#define DATA_PAGE_BASIC_CHECK_TRAILER_ID 20031
#define DATA_PAGE_BASIC_FRAME_NOT_VALID         SAPDBErr_MessageList::Error,20032,"Page frame is not valid",0
#define DATA_PAGE_BASIC_FRAME_NOT_VALID_ID 20032
#define DATA_ERR_CREATE_INDEX_FREE_FAILED_1     SAPDBErr_MessageList::Error,20033,"Create index parallel - empty temp result file failed due to data cache overflow",0
#define DATA_ERR_CREATE_INDEX_FREE_FAILED_1_ID 20033
#define DATA_ERR_ILLEGAL_ENTRY_POS_1            SAPDBErr_MessageList::Error,20034,"Record position %s of index %s on leaf page %s (%s) is out of range",4
#define DATA_ERR_ILLEGAL_ENTRY_POS_1_ID 20034
#define DATA_WRN_BAD_FILE                       SAPDBErr_MessageList::Warning,20035,"Bad file for root %s",1
#define DATA_WRN_BAD_FILE_ID 20035
#define DATA_WRN_CREATE_INDEX_FUNNEL_OVERFLOW_1 SAPDBErr_MessageList::Warning,20036,"Create index parallel - merge step failed, data cache too small",0
#define DATA_WRN_CREATE_INDEX_FUNNEL_OVERFLOW_1_ID 20036
#define DATA_WRN_CREATE_INDEX_FUNNEL_MEMORY_1   SAPDBErr_MessageList::Warning,20037,"Create index parallel - merge step faile:d due to exhausted memory",0
#define DATA_WRN_CREATE_INDEX_FUNNEL_MEMORY_1_ID 20037
#define DATA_WRN_FUNNEL_FAILED_1                SAPDBErr_MessageList::Warning,20038,"Create index parallel - data cache overflow during funnel merge instantiation",0
#define DATA_WRN_FUNNEL_FAILED_1_ID 20038
#define DATA_WRN_FUNNEL_FAILED_2                SAPDBErr_MessageList::Warning,20039,"Create index parallel - funnel merge failed",0
#define DATA_WRN_FUNNEL_FAILED_2_ID 20039
#define DATA_WRN_CREATE_INDEX_SEND_1            SAPDBErr_MessageList::Warning,20040,"Create index parallel - no server tasks available",0
#define DATA_WRN_CREATE_INDEX_SEND_1_ID 20040
#define DATA_WRN_CREATE_INDEX_IN_USE_1          SAPDBErr_MessageList::Warning,20041,"Only one parallel index creation possible",0
#define DATA_WRN_CREATE_INDEX_IN_USE_1_ID 20041
#define DATA_WRN_CREATE_INDEX_FILELISTSIZE_1    SAPDBErr_MessageList::Warning,20042,"Create index parallel - configuration parameter '%s' [%s] is not suitable",2
#define DATA_WRN_CREATE_INDEX_FILELISTSIZE_1_ID 20042
#define DATA_WRN_CREATE_INDEX_OUT_OF_MEMORY_1   SAPDBErr_MessageList::Warning,20043,"Create index parallel - initialization failed due to exhausted memory",0
#define DATA_WRN_CREATE_INDEX_OUT_OF_MEMORY_1_ID 20043
#define DATA_PAGE_INFO                          SAPDBErr_MessageList::Info,20044,"%s: pno=%s(%s/%s) acc=%s rel=%s root=%s",7
#define DATA_PAGE_INFO_ID 20044
#define DATA_CHAIN_PAGE_INFO                    SAPDBErr_MessageList::Info,20045,"%s: next=%s last=%s.",3
#define DATA_CHAIN_PAGE_INFO_ID 20045
#define DATA_PRIM_STATISTIC_CANCELED            SAPDBErr_MessageList::Info,20046,"Update statistic on root %s canceled by task %s",2
#define DATA_PRIM_STATISTIC_CANCELED_ID 20046
#define DATA_SPLIT_SPACE_RESIZE                 SAPDBErr_MessageList::Info,20047,"A split space is resized to %s",1
#define DATA_SPLIT_SPACE_RESIZE_ID 20047
#define DATA_CHAIN_INFO                         SAPDBErr_MessageList::Info,20048,"%s: root %s last %s addressing: %s recovery: %s",5
#define DATA_CHAIN_INFO_ID 20048
#define DATA_PAM_INFO                           SAPDBErr_MessageList::Info,20049,"%s pno: %s (%s/%s) accessmode: %s",5
#define DATA_PAM_INFO_ID 20049
#define DATA_SPLIT_SPACE_READER_INFO            SAPDBErr_MessageList::Info,20050,"%s: currpart=%s currlen=%s restlen=%s %s",5
#define DATA_SPLIT_SPACE_READER_INFO_ID 20050
#define DATA_SPLIT_SPACE_INFO_NOT_ASSIGNED      SAPDBErr_MessageList::Info,20051,"%s: split space not assigned",1
#define DATA_SPLIT_SPACE_INFO_NOT_ASSIGNED_ID 20051
#define DATA_SPLIT_SPACE_INFO                   SAPDBErr_MessageList::Info,20052,"%s: CurrentPart=%s numPagesAppended=%s",3
#define DATA_SPLIT_SPACE_INFO_ID 20052
#define DATA_SPLIT_SPACE_PART_INFO              SAPDBErr_MessageList::Info,20053,"Part%s: length=%s offset=%s",3
#define DATA_SPLIT_SPACE_PART_INFO_ID 20053
#define DATA_CHAIN_FIX_ITER_INFO                SAPDBErr_MessageList::Info,20054,"%s: (%s) pos=%s id=%s breakpos=%s breakid=%s",6
#define DATA_CHAIN_FIX_ITER_INFO_ID 20054
#define DATA_BACK_CHAIN_ITER_INFO               SAPDBErr_MessageList::Info,20055,"%s: space is %s break=%s.%s (%s)",5
#define DATA_BACK_CHAIN_ITER_INFO_ID 20055
#define DATA_PAM_CONTEXT                        SAPDBErr_MessageList::Info,20056,"%s: t%s tr%s root=%s",4
#define DATA_PAM_CONTEXT_ID 20056
#define DATA_BASE_FILE_INFO                     SAPDBErr_MessageList::Info,20057,"%s: filetype=%s root=%s %s %s",5
#define DATA_BASE_FILE_INFO_ID 20057
#define DATA_CREATE_INDEX_STAT_INTRO_1          SAPDBErr_MessageList::Info,20058,"Create index parallel - final index statistics",0
#define DATA_CREATE_INDEX_STAT_INTRO_1_ID 20058
#define DATA_CREATE_INDEX_STAT_INTRO_2          SAPDBErr_MessageList::Info,20059,"Create index parallel - interim index statistics",0
#define DATA_CREATE_INDEX_STAT_INTRO_2_ID 20059
#define DATA_CREATE_INDEX_STAT_1                SAPDBErr_MessageList::Info,20060,"Perm leaf pages %s - record count %s",2
#define DATA_CREATE_INDEX_STAT_1_ID 20060
#define DATA_CREATE_INDEX_STAT_2                SAPDBErr_MessageList::Info,20061,"Create index parallel - temp pages %s - temp files %s",2
#define DATA_CREATE_INDEX_STAT_2_ID 20061
#define DATA_CREATE_INDEX_FINAL_MERGE_1         SAPDBErr_MessageList::Info,20062,"Create index parallel - start final merge step",0
#define DATA_CREATE_INDEX_FINAL_MERGE_1_ID 20062
#define DATA_CREATE_INDEX_INTERIM_MERGE_1       SAPDBErr_MessageList::Info,20063,"Create index parallel - start interim merge step",0
#define DATA_CREATE_INDEX_INTERIM_MERGE_1_ID 20063
#define DATA_CREATE_INDEX_FINAL_MERGE_2         SAPDBErr_MessageList::Info,20064,"Create index parallel - stop final merge step [count %s]",1
#define DATA_CREATE_INDEX_FINAL_MERGE_2_ID 20064
#define DATA_CREATE_INDEX_INTERIM_MERGE_2       SAPDBErr_MessageList::Info,20065,"Create index parallel - stop interim merge step [count %s]",1
#define DATA_CREATE_INDEX_INTERIM_MERGE_2_ID 20065
#define DATA_FUNNEL_CANCELED_1                  SAPDBErr_MessageList::Info,20066,"Create index parallel - funnel merge instantiation canceled",0
#define DATA_FUNNEL_CANCELED_1_ID 20066
#define DATA_FUNNEL_OUT_OF_MEMORY_1             SAPDBErr_MessageList::Info,20067,"Create index parallel - funnel merge instantiation failed due to exhausted memory",0
#define DATA_FUNNEL_OUT_OF_MEMORY_1_ID 20067
#define DATA_CREATE_INDEX_CANCELED_1            SAPDBErr_MessageList::Info,20068,"Create index parallel - participant canceled",0
#define DATA_CREATE_INDEX_CANCELED_1_ID 20068
#define DATA_CREATE_INDEX_CANCELED_2            SAPDBErr_MessageList::Info,20069,"Create index parallel - coordinator canceled",0
#define DATA_CREATE_INDEX_CANCELED_2_ID 20069
#define DATA_CREATE_INDEX_SELF_PROC_1           SAPDBErr_MessageList::Info,20070,"Create index parallel - start process keyrange without server task support",0
#define DATA_CREATE_INDEX_SELF_PROC_1_ID 20070
#define DATA_CREATE_INDEX_SELF_PROC_2           SAPDBErr_MessageList::Info,20071,"Create index parallel - stop process keyrange without server task support",0
#define DATA_CREATE_INDEX_SELF_PROC_2_ID 20071
#define DATA_CREATE_INDEX_FILELISTSIZE_UPD_1    SAPDBErr_MessageList::Info,20072,"Update configuration parameter '%s' from [%s] to [%s]",3
#define DATA_CREATE_INDEX_FILELISTSIZE_UPD_1_ID 20072
#define DATA_CREATE_INDEX_USE_SEQUENTIAL_1      SAPDBErr_MessageList::Info,20073,"Sequential index creation used instead",0
#define DATA_CREATE_INDEX_USE_SEQUENTIAL_1_ID 20073
#define DATA_CREATE_INDEX_USE_SEQUENTIAL_2      SAPDBErr_MessageList::Info,20074,"Sequential index creation used for this table range",0
#define DATA_CREATE_INDEX_USE_SEQUENTIAL_2_ID 20074

#endif /* DATA_MESSAGES_HPP */
