/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver.test;

import com.sap.dbtech.udeserver.test.TestException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class TestConnection {
    private String name;
    private String pwd;
    private String dbname;
    private String host;
    private Connection sqlConnection;

    public TestConnection(String string, String string2, String string3, String string4) {
        this.name = string;
        this.pwd = string2;
        this.dbname = string3;
        this.host = string4;
    }

    public String toString() {
        String string = "[TestConnection name=" + this.name + ";pwd=" + this.pwd + ";dbname=" + this.dbname + ";host=" + this.host + "]";
        return string;
    }

    protected Connection getConnection() {
        if (this.sqlConnection == null) {
            try {
                try {
                    Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new TestException("could not load class com.sap.dbtech.jdbc.DriverSapDB");
                }
                String string = "jdbc:sapdb://" + this.host + "/" + this.dbname;
                this.sqlConnection = DriverManager.getConnection(string, this.name, this.pwd);
                this.sqlConnection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                throw new TestException(sQLException);
            }
        }
        return this.sqlConnection;
    }

    public void close() {
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.sqlConnection = null;
        }
    }

    public void commit() {
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void sql(String string) {
        try {
            System.out.println("SQL: " + string);
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            boolean bl = statement.execute(string);
            if (bl) {
                this.dumpCursor(statement.getResultSet());
            }
        }
        catch (SQLException sQLException) {
            throw new TestException(sQLException);
        }
    }

    public void sql(String string, String string2) {
        this.sql(string);
        try {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            System.out.println("TestSQL: " + string2);
            ResultSet resultSet = statement.executeQuery(string2);
            this.dumpCursor(resultSet);
        }
        catch (SQLException sQLException) {
            throw new TestException(sQLException);
        }
    }

    public void sqlX(String string, Object[] objectArray) {
        this.sqlX(string, new Object[][]{objectArray});
    }

    public void sqlX(String string, Object[][] objectArray) {
        try {
            System.out.println("SQL: " + string);
            CallableStatement callableStatement = this.getConnection().prepareCall(string);
            ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                int n2;
                Object[] objectArray2 = objectArray[i];
                for (n2 = 0; n2 < parameterMetaData.getParameterCount(); ++n2) {
                    n = parameterMetaData.getParameterMode(n2 + 1);
                    if (n == 4) continue;
                    Object object = objectArray2[n2];
                    System.out.println("    " + (n2 + 1) + ":> " + object);
                    callableStatement.setObject(n2 + 1, object);
                }
                n2 = 0;
                try {
                    n2 = callableStatement.execute() ? 1 : 0;
                }
                catch (SQLException sQLException) {
                    System.out.println("  ERR: " + sQLException);
                    continue;
                }
                for (n = 0; n < parameterMetaData.getParameterCount(); ++n) {
                    Object object;
                    int n3 = parameterMetaData.getParameterMode(n + 1);
                    if (n3 == 1) continue;
                    objectArray2[n] = object = callableStatement.getObject(n + 1);
                    System.out.println("    " + (n + 1) + ":< " + object);
                }
                if (n2 == 0) continue;
                this.dumpCursor(callableStatement.getResultSet());
            }
        }
        catch (SQLException sQLException) {
            throw new TestException(sQLException);
        }
    }

    public void safeSQL(String string, int n) {
        block2: {
            try {
                Connection connection = this.getConnection();
                Statement statement = connection.createStatement();
                statement.execute(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == n) break block2;
                System.out.println("SQL: " + string);
                throw new TestException(sQLException);
            }
        }
    }

    protected void dumpCursor(ResultSet resultSet) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        String string = "";
        for (n = 1; n <= n2; ++n) {
            System.out.print(string + resultSetMetaData.getColumnLabel(n));
            string = ",";
        }
        System.out.println();
        n = 0;
        while (resultSet.next()) {
            n = 1;
            string = "";
            for (int i = 1; i <= n2; ++i) {
                System.out.print(string + resultSet.getString(i));
                string = ",";
            }
            System.out.println();
        }
        if (n == 0) {
            System.out.println("+++ no result +++");
        }
    }

    public static TestConnection fromArgs(String[] stringArray) {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        for (int i = 0; i < stringArray.length && !(string = stringArray[i]).equals("--"); ++i) {
            if (string.equals("-d")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string.equals("-n")) {
                string5 = stringArray[++i];
                continue;
            }
            if (!string.equals("-u")) continue;
            String string6 = stringArray[++i];
            int n = string6.indexOf(44);
            string2 = string6.substring(0, n);
            string3 = string6.substring(n + 1);
        }
        return new TestConnection(string2, string3, string4, string5);
    }

    public static void main(String[] stringArray) {
        TestConnection testConnection = TestConnection.fromArgs(stringArray);
        System.out.println("Result: " + testConnection);
    }
}

