/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.udeserver.Log;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;

public class SocketComm
extends JdbcCommunication {
    private Socket socket;
    private InputStream instream;
    private OutputStream outstream;
    private StructuredMem sendBuf;
    int packetSize;
    public static final int currentProtocolVersionC = 1;
    public static final int protocolVersion_O = 0;
    public static final int packetKind_O = 2;
    public static final int options_O = 3;
    public static final int length_O = 4;
    public static final int headerSizeC = 8;
    public static final int dataPacketC = 1;
    public static final int errorPacketC = 2;

    public SocketComm(int n, int n2) throws RTEException {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            Socket socket = new Socket(inetAddress, n);
            Log.log("socket peer: " + socket.getRemoteSocketAddress());
            this.init(socket, n2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
    }

    public SocketComm(Socket socket, int n) throws RTEException {
        this.init(socket, n);
    }

    private void init(Socket socket, int n) throws RTEException {
        try {
            this.socket = socket;
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
            this.packetSize = n;
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
    }

    void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public void finalize() {
        this.close();
    }

    void send(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = new byte[8];
        Log.log("send'ing " + n + " bytes");
        byArray2[0] = 0;
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[3] = 0;
        int n2 = n + 8;
        for (int i = 3; i >= 0; --i) {
            byArray2[i + 4] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
        this.outstream.write(byArray2);
        this.outstream.write(byArray);
    }

    void send(byte[] byArray) throws IOException {
        this.send(byArray, byArray.length);
    }

    void sendString(String string) throws IOException {
        this.send(string.getBytes());
    }

    public byte[] recv() throws IOException {
        Log.log("bytes available: " + this.instream.available());
        while (this.instream.available() == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        byte[] byArray = this.recvBytes(8);
        int n = 0;
        Log.log("recv: got header of " + byArray.length + " bytes");
        Log.log(" header: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7]);
        for (int i = 0; i < 4; ++i) {
            int n2 = byArray[i + 4];
            if (n2 < 0) {
                n2 += 256;
            }
            n = n * 256 + n2;
        }
        Log.log("now reading " + (n -= 8) + " bytes");
        byte[] byArray2 = this.recvBytes(n);
        return byArray2;
    }

    public String recvString() throws IOException {
        byte[] byArray = this.recv();
        return new String(byArray);
    }

    private byte[] recvBytes(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = this.instream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new IOException("Read from socket failed");
        }
        return byArray;
    }

    public void cancel() throws SQLException {
    }

    public StructuredMem getRequestPacket() {
        StructuredMem structuredMem;
        if (this.sendBuf != null) {
            structuredMem = this.sendBuf;
            this.sendBuf = null;
        } else {
            structuredMem = new StructuredBytes(this.packetSize);
        }
        return structuredMem;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public StructuredMem receive() throws RTEException {
        try {
            return new StructuredBytes(this.recv());
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
    }

    public void release() {
        this.close();
    }

    public void request(StructuredMem structuredMem, int n) throws RTEException {
        this.sendBuf = structuredMem;
        StructuredBytes structuredBytes = (StructuredBytes)structuredMem;
        try {
            this.send(structuredBytes.bytes(), n);
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
    }
}

