/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ProcReplyPacket;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.udeserver.Callable;
import com.sap.dbtech.udeserver.CallableFactory;
import com.sap.dbtech.udeserver.Log;
import com.sap.dbtech.udeserver.ProcParameterList;
import com.sap.dbtech.udeserver.ProcServerConnection;
import com.sap.dbtech.udeserver.SQLJCallable;
import com.sap.dbtech.udeserver.Stop;
import com.sap.dbtech.udeserver.UDEComm;
import com.sap.dbtech.udeserver.UDERequestPacket;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Traceable;
import java.sql.SQLException;
import java.util.Iterator;

public class ProcServerSession
extends Thread {
    private String uri;
    private UDEComm comm;
    private ProcServerConnection conn;
    private CallableFactory callFactory;

    public ProcServerSession(String string) throws Exception {
        this.uri = "maxdb:local:" + string;
    }

    protected void connect() throws Exception {
        try {
            Log.log("trying to connect to " + this.uri);
            this.comm = new UDEComm(this.uri);
        }
        catch (RTEException rTEException) {
            throw new Exception(rTEException.getMessage());
        }
        try {
            this.conn = new ProcServerConnection(this.comm);
        }
        catch (SQLException sQLException) {
            throw new Exception(sQLException.getMessage());
        }
        this.callFactory = new SQLJCallable.SQLJCallableFactory();
    }

    protected void release() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.connect();
            StructuredMem structuredMem = this.comm.getRequestPacket();
            structuredMem.putString("", 0);
            this.comm.request(structuredMem, 0);
            while (true) {
                ProcReplyPacket procReplyPacket;
                Object object;
                StructuredBytes[] structuredBytesArray = new StructuredBytes[1];
                StructuredMem structuredMem2 = this.comm.receive();
                if (structuredMem2.size() == 0) {
                    Log.log("got eosession packet");
                    break;
                }
                boolean bl = false;
                if (structuredMem2.getInt1(1) == 2) {
                    object = (StructuredBytes)structuredMem2;
                    structuredMem2 = new FullswapMem(object.bytes());
                    bl = true;
                }
                try {
                    Iterator iterator;
                    object = new UDERequestPacket(structuredMem2);
                    String[] stringArray = this.parseProcidPart((ReplyPacket)object);
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    Log.log("call " + string + " from " + string2);
                    Callable callable = this.callFactory.create(string, string2);
                    ProcParameterList procParameterList = new ProcParameterList((ReplyPacket)object);
                    callable.call(procParameterList);
                    procReplyPacket = this.initReply(bl, structuredBytesArray);
                    if (procParameterList.hasOutputParameter()) {
                        iterator = procReplyPacket.newDataPart(5);
                        procParameterList.copyToOutputPacket((DataPart)iterator);
                        iterator.close();
                    }
                    if ((iterator = procParameterList.getCursorNames()) != null) {
                        procReplyPacket.addCursorPart((String)iterator.next());
                    }
                }
                catch (Stop stop) {
                    Log.log("STOP: [" + stop.getErrorCode() + "] " + stop.getMessage());
                    procReplyPacket = this.initReply(bl, structuredBytesArray);
                    procReplyPacket.setStopInfo(stop.getErrorCode(), stop.getMessage());
                }
                catch (Throwable throwable) {
                    Log.traceException(throwable);
                    procReplyPacket = this.initReply(bl, structuredBytesArray);
                    procReplyPacket.setExceptionInfo(throwable);
                }
                procReplyPacket.closePacket();
                Log.log("sending reply of " + procReplyPacket.length() + " bytes");
                Log.trace((Traceable)procReplyPacket);
                this.comm.request((StructuredMem)procReplyPacket, procReplyPacket.length());
            }
        }
        catch (RTEException rTEException) {
        }
        catch (Throwable throwable) {
            Log.traceException(throwable);
        }
        finally {
            Log.log("releasing session");
            this.release();
        }
    }

    protected String[] parseProcidPart(ReplyPacket replyPacket) throws PartNotFound {
        String[] stringArray = new String[2];
        replyPacket.findPart(29);
        int n = replyPacket.getPartDataPos();
        for (int i = 0; i < 2; ++i) {
            String string;
            int n2 = replyPacket.getUInt1(n) * 256 + replyPacket.getUInt1(n + 1);
            stringArray[i] = string = replyPacket.getString(n + 2, n2);
            n += 2 + n2;
        }
        return stringArray;
    }

    protected ProcReplyPacket initReply(boolean bl, StructuredBytes[] structuredBytesArray) {
        StructuredBytes structuredBytes;
        StructuredMem structuredMem = this.comm.getRequestPacket();
        structuredBytesArray[0] = (StructuredBytes)structuredMem;
        if (bl) {
            structuredBytes = (StructuredBytes)structuredMem;
            structuredMem = new FullswapMem(structuredBytes.bytes());
        }
        structuredBytes = new ProcReplyPacket(structuredMem);
        return structuredBytes;
    }

    public class Exception
    extends Throwable {
        public Exception(String string) {
            super(string);
        }
    }
}

