/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends ClassLoader {
    private JarFile jar;
    private boolean deleteOnClose;

    public JarClassLoader(String string, boolean bl) throws IOException {
        File file = new File(string);
        this.jar = new JarFile(file);
        this.deleteOnClose = bl;
        if (bl) {
            file.deleteOnExit();
        }
    }

    public JarClassLoader(String string) throws IOException {
        this(string, false);
    }

    public void finalize() {
        try {
            this.jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.deleteOnClose) {
            new File(this.jar.getName()).delete();
        }
    }

    boolean isCurrent(String string) {
        return false;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        ZipEntry zipEntry = this.jar.getEntry(string2);
        if (zipEntry == null) {
            throw new ClassNotFoundException(string);
        }
        int n = (int)zipEntry.getSize();
        byte[] byArray = new byte[n];
        try {
            InputStream inputStream = this.jar.getInputStream(zipEntry);
            inputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string, iOException);
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        return clazz;
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        JarClassLoader jarClassLoader = new JarClassLoader(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                System.out.println("trying " + stringArray[i]);
                Class<?> clazz = jarClassLoader.loadClass(stringArray[i]);
                System.out.println(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Throwable throwable = classNotFoundException.getCause();
                if (throwable != null) {
                    throwable.printStackTrace();
                    continue;
                }
                System.out.println(classNotFoundException);
            }
        }
    }
}

