#!/usr/bin/perl
#
# @(#) sutvars			1997-11-18
#
# constants for all sutscripts
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

use Env;


# Protokollverzeichnise anlegen
$PERM = 0;
$TEST = $ENV{TEST} = $ENV{OWN}."\\test" unless (defined $TEST);
$SUT = $ENV{SUT} = $ENV{OWN}."\\test\\kern\\sut" unless (defined $SUT);

die "directory $SUT does not exist" unless (-d $SUT);

mkdir("$SUT/fast", $PERM)       unless -d "$SUT/fast";
mkdir("$SUT/slow", $PERM)       unless -d "$SUT/slow";
mkdir("$SUT/quick", $PERM)      unless -d "$SUT/quick";
mkdir("$SUT/uni", $PERM)        unless -d "$SUT/uni";
mkdir("$SUT/dbuni", $PERM)      unless -d "$SUT/dbuni";
mkdir("$SUT/xci", $PERM)        unless -d "$SUT/xci";
mkdir("$SUT/alluni", $PERM)     unless -d "$SUT/alluni";
mkdir("$SUT/lvl_0", $PERM)      unless -d "$SUT/lvl_0";
mkdir("$SUT/lvl_2", $PERM)      unless -d "$SUT/lvl_2";
mkdir("$SUT/lvl_3", $PERM)      unless -d "$SUT/lvl_3";
mkdir("$SUT/lvl_15", $PERM)     unless -d "$SUT/lvl_15";
mkdir("$SUT/stack", $PERM)      unless -d "$SUT/stack";
mkdir("$SUT/stack-save", $PERM) unless -d "$SUT/stack-save";

# zusammenfassende Protokolle
$AllSut  = "$TEST/kern/allsut.prt";
$AllCore = "$TEST/kern/allcore.prt";
$AllDiff = "$TEST/kern/alldiff.prt";
$AllOk   = "$TEST/kern/allok.prt";
$AllTest = "$TEST/kern/alltest.prt";
$AllStack= "$TEST/kern/allstack.prt";

$StdColdUser="superdba,colduser";

#Protokoll Datei fr dbmcli
$DbmcliProt   = "$SUT/dbmcli.prt";
$DbmcliOutput = "$SUT/dbmcli.out";

# SUT-globale Makros
$NULL = "nul";
$PROG_EXT = ".exe";
if ($RELVER eq "R61"){
	$X_UTIL		= "$DBROOT\\bin\\xutil.exe";
}
$X_DIAGNOSE = "$DBROOT\\bin\\x_diag.exe";
$DIFF = "$TOOL/Posix/diff -bw";

1;
