
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#
use Env;
use Getopt::Std;

my ($VMAKE_COLLECTION) = "$ENV{TMP}/$$";
my ($OUTFILE) = "a.xml";

    @XMLFILE = ();

my %ext2Type = ( "mac", "macro",
                 "lnk", "program",
                 "shm", "program",
                 "lib", "library",
                 "rel", "relocatable",
                 "dld", "relocatable"
                 );

%displayTags = ( "*", 0,
                    "name", 1,
                    "module", 1,
                    "unknown", 1,
                    "include", 1,
                    "macro", 1,
                    "program", 1,
                    "library", 1,
                    "relocatable", 1,
                    "dependencies", 1 );

use Pmod;

sub beginTag;
sub endTag;

my   $USAGE="USAGE: pmod [-[i:o:]d] \<vmake_desc\>\n";
    $USAGE.="            -i \<vmake_input\> : Input VMAKE collection.\n";
    $USAGE.="            -o \<xml_file\>   : Output XML file (default a.xml).\n";
    $USAGE.="            -d                : Displays collection graphically.\n";

getopts('i:o:dh') or die $USAGE;
if ($opt_h) {
    print "$opt_?\n";
    print $USAGE;
    exit;
}
if ($opt_x) {
    $OUTFILE = $opt_x;
}
else {
    if ($opt_o) {
        $OUTFILE = $opt_o;
    }
    if ($opt_i) {
        $VMAKE_COLLECTION=$opt_i;
    }
    else {
        if (@ARGV != 0) {
            @desc = @ARGV;
        }
        else {
            @desc = "all";
        }
        open(SAVEOUT, ">&STDOUT");
        open(STDOUT, ">$VMAKE_COLLECTION");
        $name = $desc[0];
        foreach $desc (@desc) {
            @ARGV = ("-c", $desc);
            do "$TOOL/bin/imf$TOOLEXT";
            if ( $@ ) { die "Error while executing ims$TOOLEXT: $@" }
        }

        close(STDOUT);
        open(STDOUT, ">&SAVEOUT");
    }

    open(file_in, "<$VMAKE_COLLECTION");

    beginTag ("collection", $name);
    while(<file_in>) {
        chop;
        if (/^macro/
            || /^program/
            || /^relocatable/
            || /^library/
            || /^module/
            || /^include/
            || /^file/
            || /^command/ ) {
            if (defined $tag) {
                $tag->flush(@XMLFILE);
                undef $tag;
            }
            if (/(\w+)/) {
                $tag = new Tag ( "$&" );
            }
        }
        if (/ +name +/ ) {
            if (/ +(\w+) +'(.*)'/) {
                $attr = $1;
                $name = $2;
                if ($name =~ /^(\w+|\w+-\w+)\.(\w+)$/) {
                    $name = $1;
                    $ext = "$2";
                    $ext2Type{$ext} = $tag->{tagname};
                }
                if ($name =~ /^(\w+)-(\w+)/) {
                    $name = $1;
                    $varspec = $2;
                    $child = $tag->addTag("name", "$name.$ext");
                    $child->addAttr("varspec", $varspec);
                }
                else {
                    $child = $tag->addTag("name", "$name.$ext");
                }
            }
        }
        if (/ +dependencies +/ ) {
            if (/(\w+)/) {
                local ($tagname) = $1;
                local (@list) = ();
                local ($child);
                local ($depend);
              LINE:
                while(<file_in>) {
                    chop;
                    if ( /'(.*)'\t.*/ ) {
                        $depend = $tag->addTag($tagname) unless (defined $depend);
                        local $value = $1;
                        if ($value =~ /^(\w+|\w+-\w+)\.(\w+)$/) {
                            $name = "$1";
                            $ext = "$2";
                            $type = $ext2Type{$ext};
                            if (defined $type) {
                                $child = $depend->addTag("$type");
                            }
                            else {
                                $child = $depend->addTag("module");
                            }
                            if ($name =~ /^(\w+)-(\w+)/) {
                                $name = $1;
                                $varspec = $2;
                                $nametag = $child->addTag("name", "$name.$ext");
                                $nametag->addAttr("varspec", $varspec);
                            }
                            else {
                                $child->addTag("name", "$name.$ext");
                            }
                        }
                        else {
                            if ($value =~ /^((h|g|v)[a-zA-Z]{2})(\w+|\w+-\w+)$/) {
                                $child = $depend->addTag("module");
                                $nametag = $child->addTag("name", "$value");
                            }
                            else {
                                $child = $depend->addTag("unknown");
                                $nametag = $child->addTag("name", "$value");
                            }
                        }
                    }
                    else {
                        undef $depend;
                        last LINE;
                    }
                }
            }
        }
    }
    if (defined $tag) {
        $tag->flush(@XMLFILE);
        undef $tag;
    }
    close(file_in);
    endTag "collection";

    open(file_out, ">$OUTFILE");
    foreach $out (@XMLFILE) {
        print file_out $out;
    }
    close(file_out);
}
if ($opt_d) {
  PDOT::display($INFILE);
}
if(0) {
use XML::DOM;
my $parser = new XML::DOM::Parser;
my $parsefile = $parser->parsefile($OUTFILE);

foreach my $elem ($parsefile->getElementsByTagName('collection')) {
    foreach my $child ($elem->getChildNodes) {
        if ($child->getNodeType == ELEMENT_NODE ) {
            if (defined $child->getFirstChild()) {
                if ($child->getTagName eq 'program') {
                    foreach my $dep (getElementsByTagName('dependencies')) {
                        print $child->getTagName . "\n";
                    }
                }
                if ($child->getTagName eq 'macro') {
                    print $child->getTagName . "\n";
                }
            }
        }
    }
}
}

sub beginTag
{
    my ($tag, $name) = @_;
    push @XMLFILE, "\<$tag\>\n<name>$name</name\>\n";
}

sub endTag
{
    my ($tag) = @_;
    push @XMLFILE, "\</$tag\>\n";
}

