#!/usr/bin/perl
# @(#) initdomsut   3.1.3   1993-08-13   kern   Carsten
#
# init config, load 'sqldb.inst', save serverdb
# als vorbereitung fuer sutall mit komplett installierter db
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

use Env;
use ToolLib;
do "$TOOL/bin/sutvars$TOOLEXT";

$INST_FILE = "SQLDB.ins";

print scalar localtime, "	... start initdomsut, using $INST_FILE.\n";
chdir($SUT) || die "Can't change to directory $SUT: $!";

$CI_PROG = "$DBROOT/pgm/slowci";
$CI_PROT = ToolLib::ProtokollName($CI_PROG);
open(FILE_OUT, ">>$AllSut");
print FILE_OUT ToolLib::Timestamp(),  "... initdomsut ...\n";

if ( $^O =~ /mswin32/i )
{
    system("x_stop $SERVERDB")
}
else
{
    system("x_clear $SERVERDB")
}
system("x_start $SERVERDB");

print scalar localtime, "\n$CI_PROG XINITDOM\n";
system("$CI_PROG -b XINITDOM.cmd > $NULL");
unlink "XINITDOM.prot";
rename("$CI_PROT", "XINITDOM.prot");

print "\n";
chdir($DBROOT/env) || die "Can't change to directory $DBROOT/env: $!";
unlink "load.prot";

$LOAD_CMD = "xload -u SYSTEMDBA,SYSTEMDBA -d $DBNAME -b \"$INST_FILE\" domain";

print scalar localtime, "\n$LOAD_CMD\n";
system("$LOAD_CMD > $SUT/xload.screen");

unlink "$SUT/xload.prot", rename("load.prot", "$SUT/xload.prot");

chdir($SUT) || die "Can't change to directory $SUT: $!";
print "\n", scalar localtime, "	  $CI_PROG XSAVEDOM\n";
system("$CI_PROG -b XSAVEDOM.cmd > $NULL");
unlink "XSAVEDOM.prot"; rename($CI_PROT ,"XSAVEDOM.prot");
print "... end of initdomsut	", scalar localtime;

close(FILE_OUT);
