#!/usr/bin/perl -w
#
# checkmake.pl Script
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#
use strict;

#define vars
my ($Prot, $ErrFound, @Lines, @Msg);

foreach my $Prot ( @ARGV ) {
    
    # read prot
    if ( !open (IN, "<$Prot") )  {
        print "Make protocol $Prot not found (ignored)\n";
        next;
    }
    @Lines = <IN>;
    close IN;

    print "Checking make protocol $Prot for errors\n";
    $ErrFound = grep { /END:\s*MAKE\s*TARGET:\s*\S*\s*RESULT:\s*ERROR/i } @Lines;
    push @Msg, @Lines if ( $ErrFound );
}

if ( @Msg ) {

    print "Errors found in make protocols\n";

    # send mail
    &SendErrorMail(@Msg) if ( @Msg ); 
    # exit with error code
    exit -1;
}

print "No errors found in make protocols\n";
exit 0;

#########################################################################

sub SendErrorMail {
    use Mail::Sendmail;

    # define local vars
    my ($msg, $receiver, %mail, $hostname);

    
    # get hostname
    $hostname =  `hostname`;
    chomp $hostname;
    
    # generate message
    $msg  = "make problem on $hostname($ENV{OWN})\n\n";
    $msg .= join '', @_;
    
    $receiver = join (',', map {chomp; $_ . '@sap.com'} <DATA>);
    
    %mail = ( To      => "$receiver",
                 From    => 'automail.unixmake@sap.com',
                 Message => "$msg",
                 Smtp    => 'mail.sap-ag.de',
                 Subject => "make problem on $hostname");

    if ( ! sendmail(%mail) ) {
        print "FATAL: sendmail error $Mail::Sendmail::error\n";
    }
}

__DATA__
torsten.strahl
henrik.hempelmann
uwe.hahn
martin.brunzema
daniel.dittmar
martin.kittel
elke.zabach
ulrich.jansen
thomas.anhaus
ferdinand.flohe
gert.grossmann
holger.becker
joerg.mensing
raymond.roedling
stefan.paeck
robin.wissbrock
burkhard.diesing
thomas.simenec
marco.paskamp
alexander.schroeder
markus.oezgen
daniel.kirmse
thomas.theodor.koetter
juergen.aurisch
martin.reinecke
bernd.vorsprach
tilo.heinrich
steffen.schildberg
hans-georg.bumes
wolfgang.auer
markus.stausberg
mechthild.bore
dennis.adler
robert.voelkel
paul.von.buenau
ivan.schreter
markus.sinnwell
peter.goertz
