/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechdev.tools.jdiagnose;

import com.sap.dbtechdev.tools.jdiagnose.ByteUtil;
import com.sap.dbtechdev.tools.jdiagnose.JDiagGUI;

public class LongDesc {
    static final String[] valmodeMap = new String[]{"vm_datapart", "vm_alldata", "vm_lastdata", "vm_nodata", "vm_no_more_data", "vm_last_putval", "vm_data_trunc", "vm_close", "vm_error", "vm_startpos_invalid"};
    static final String[] infosetMap = new String[]{"ld_ex_trigger", "ld_with_lock", "ld_no_close", "ld_new_rec", "ld_is_comment", "ld_is_catalog", "ld_unicode", "ld_without_shortcol"};
    static final String[] ldStateMap = new String[]{"ld_stream", "ld_use_conversion", "ld_use_toascii", "ld_use_ucs_2_swap", "ld_short_scol", "ld_first_insert", "ld_copy", "ld_first_call"};
    static final String[] longdescProps = new String[]{"UndefSignal", "Descriptor", "Tabid", "MaxLen", "InternPos", "Infoset", "LDState", "UsedInAK", "Valmode", "Valind", "Unused", "Valpos", "Vallen"};
    static final int[] longDescOffsets = new int[]{1, 2, 10, 18, 22, 26, 27, 28, 29, 30, 32, 34, 38};
    public byte UndefSignal;
    public byte[] Descriptor;
    public byte[] Tabid;
    public int MaxLen;
    public int InternPos;
    public byte Infoset;
    public byte ld_state;
    public byte ld_used_in_ak;
    public int Valmode;
    public int Valind;
    public byte[] ld_unused_2;
    public int Valpos;
    public int Vallen;
    public byte[] wholeDescriptor;

    public String bytes2String(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public String getInfoSet() {
        return this.Set2HexString(this.Infoset) + ", " + this.Set2String(this.Infoset, infosetMap);
    }

    public String getLDState() {
        return this.Set2HexString(this.ld_state) + ", " + this.Set2String(this.ld_state, ldStateMap);
    }

    public String getUsedInAK() {
        return this.Set2HexString(this.ld_used_in_ak);
    }

    public String getUnused2() {
        return ByteUtil.printasHexPattern(this.ld_unused_2, '|');
    }

    public String Set2HexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (by == 0) {
            stringBuffer.append("0xFFFFFFFF");
        } else {
            stringBuffer.append("0x");
            stringBuffer.append((by & 0x80) != 0 ? "B" : "F");
            stringBuffer.append((by & 0x40) != 0 ? "B" : "F");
            stringBuffer.append((by & 0x20) != 0 ? "B" : "F");
            stringBuffer.append((by & 0x10) != 0 ? "B" : "F");
            stringBuffer.append((by & 8) != 0 ? "B" : "F");
            stringBuffer.append((by & 4) != 0 ? "B" : "F");
            stringBuffer.append((by & 2) != 0 ? "B" : "F");
            stringBuffer.append((by & 1) != 0 ? "B\n" : "F");
        }
        return stringBuffer.toString();
    }

    public String Set2String(byte by, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (by == 0) {
            stringBuffer.append("");
        } else {
            String string = "[";
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if ((by & 1 << i) == 0) continue;
                stringBuffer.append(string + stringArray[i]);
                string = ", ";
                bl = true;
            }
            if (bl) {
                stringBuffer.append("]");
            }
        }
        return stringBuffer.toString();
    }

    public String getDescriptor() {
        return this.bytes2String(this.Descriptor);
    }

    public String getTabid() {
        return this.bytes2String(this.Tabid);
    }

    public String getValmode() {
        try {
            return this.Valmode + " [" + valmodeMap[this.Valmode] + "]";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDiagGUI.logError("unknown valmode [" + this.Valmode + "]");
            return "unknown valmode [" + this.Valmode + "]";
        }
    }

    public String getUndefSignal() {
        return Byte.toString(this.UndefSignal);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UndefSignal: " + this.UndefSignal + "\n");
        stringBuffer.append("Descriptor : " + this.getDescriptor() + "\n");
        stringBuffer.append("Tabid      : " + this.getTabid() + "\n");
        stringBuffer.append("MaxLen     : " + this.MaxLen + "\n");
        stringBuffer.append("InternPos  : " + this.InternPos + "\n");
        stringBuffer.append("Infoset    : " + this.getInfoSet() + "\n");
        stringBuffer.append("LDState    : " + this.getLDState() + "\n");
        stringBuffer.append("UsedInAK   : " + this.getUsedInAK() + "\n");
        stringBuffer.append("Valmode    : " + this.getValmode() + "\n");
        stringBuffer.append("Valind     : " + this.Valind + "\n");
        stringBuffer.append("unused     : " + this.getUnused2() + "\n");
        stringBuffer.append("Valpos     : " + this.Valpos + "\n");
        stringBuffer.append("Vallen     : " + this.Vallen + "\n");
        return stringBuffer.toString();
    }

    public String[] getLongDescValues() {
        return new String[]{this.getUndefSignal(), this.getDescriptor(), this.getTabid(), Integer.toString(this.MaxLen), Integer.toString(this.InternPos), this.getInfoSet(), this.getLDState(), this.getUsedInAK(), this.getValmode(), Integer.toString(this.Valind), this.getUnused2(), Integer.toString(this.Valpos), Integer.toString(this.Vallen)};
    }

    public static String[] getLongdescProps() {
        return longdescProps;
    }

    public static int[] getLongDescOffsets() {
        return longDescOffsets;
    }
}

