/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.io.UnsupportedEncodingException;

public class UnicodeUtil {
    public static final int CharWidthC = 2;
    private static boolean encodingAvailable;

    private UnicodeUtil() {
    }

    public static char[] bigUnicode2Chars(byte[] b, int off, int len) {
        char[] result = new char[len / 2];
        int lenInChars = len / 2;
        for (int i = 0; i < lenInChars; ++i) {
            int low;
            int high = b[off + 2 * i];
            if (high < 0) {
                high += 256;
            }
            if ((low = b[off + (2 * i + 1)]) < 0) {
                low += 256;
            }
            int current = (high << 8) + low;
            result[i] = (char)current;
        }
        return result;
    }

    public static char[] bigUnicode2Chars(byte[] b) {
        return UnicodeUtil.bigUnicode2Chars(b, 0, b.length);
    }

    public static String bigUnicode2String(byte[] input) {
        String result;
        if (encodingAvailable) {
            try {
                result = new String(input, "UTF-16BE");
            }
            catch (UnsupportedEncodingException UEEexp) {
                result = new String(UnicodeUtil.bigUnicode2Chars(input));
                encodingAvailable = false;
            }
        } else {
            result = new String(UnicodeUtil.bigUnicode2Chars(input));
        }
        return result;
    }

    public static byte[] char2BigUnicode(char[] input) {
        int charCount = input.length;
        byte[] result = new byte[input.length * 2];
        UnicodeUtil.charIntoBytes(input, result, 0);
        return result;
    }

    public static void charIntoBytes(char[] input, byte[] output, int byteOffset) {
        int charCount = input.length;
        for (int i = 0; i < charCount; ++i) {
            char current = input[i];
            output[i * 2 + byteOffset] = (byte)(current / 256);
            output[i * 2 + byteOffset + 1] = (byte)(current % 256);
        }
    }

    static {
        CharWidthC = 2;
        encodingAvailable = true;
    }
}

