/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.util;

/**
 * Title:        SAP DB JDBC Driver
 * Description:  This class generates unique id's used for cursornames
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author       MarcoP
 * @version 1.0
 */

public class UniqueID {

    private long counter;

    public final String getNextID(String prefix)
    {
        return prefix + getNextID();
    }

    private synchronized final long getNextID()
    {
        if(++counter<=0) {
            counter=0;
        }
        return counter;
    }
}
