/*
 * Created on Feb 10, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.dbtech.jdbc.translators;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;

/**
 * SQL Output for a structure.
 *
 */
public class StructureSQLOutput implements SQLOutput {

	private StructuredBytes     data;
	private StructureTranslator translator;
	private int fieldIndex;
	
	public StructureSQLOutput(StructureTranslator translator) {
		this.translator = translator;
		this.data = new StructuredBytes(translator.logicalLength);
		this.fieldIndex = -1;
	}
	
	public boolean isDataComplete() {
		return this.fieldIndex == translator.parameterStructure.getMemberCount();
	}

	public byte[] getData() throws SQLException {
		if(!isDataComplete()) {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STRUCTURE_INCOMPLETE));
		}
		return data.bytes();
	}

	private void checkDataComplete() throws SQLException {
		if(isDataComplete()) {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STRUCTURE_COMPLETE));
		}
	}

	public void writeByte(byte b) throws SQLException {
		try {
			++fieldIndex;
			checkDataComplete();
		} catch(SQLException sqlEx) {
			--fieldIndex;
			throw sqlEx;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeDouble(double)
	 */
	public void writeDouble(double arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeFloat(float)
	 */
	public void writeFloat(float arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeInt(int)
	 */
	public void writeInt(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeLong(long)
	 */
	public void writeLong(long arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeShort(short)
	 */
	public void writeShort(short arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeBoolean(boolean)
	 */
	public void writeBoolean(boolean arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeBytes(byte[])
	 */
	public void writeBytes(byte[] arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeAsciiStream(java.io.InputStream)
	 */
	public void writeAsciiStream(InputStream arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeBinaryStream(java.io.InputStream)
	 */
	public void writeBinaryStream(InputStream arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeCharacterStream(java.io.Reader)
	 */
	public void writeCharacterStream(Reader arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeString(java.lang.String)
	 */
	public void writeString(String arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeBigDecimal(java.math.BigDecimal)
	 */
	public void writeBigDecimal(BigDecimal arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeURL(java.net.URL)
	 */
	public void writeURL(URL arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeArray(java.sql.Array)
	 */
	public void writeArray(Array arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeBlob(java.sql.Blob)
	 */
	public void writeBlob(Blob arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeClob(java.sql.Clob)
	 */
	public void writeClob(Clob arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeDate(java.sql.Date)
	 */
	public void writeDate(Date arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeRef(java.sql.Ref)
	 */
	public void writeRef(Ref arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeObject(java.sql.SQLData)
	 */
	public void writeObject(SQLData arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeStruct(java.sql.Struct)
	 */
	public void writeStruct(Struct arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeTime(java.sql.Time)
	 */
	public void writeTime(Time arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see java.sql.SQLOutput#writeTimestamp(java.sql.Timestamp)
	 */
	public void writeTimestamp(Timestamp arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

}
