package com.sap.dbtech.jdbc.translators;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

import javax.sound.sampled.DataLine;

import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/*

 @author d031096

 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


 */
public class GetvalCharByte extends AbstractSimpleGetval implements Blob {
    byte [] data;
    
    public GetvalCharByte (byte[] datavalue){
        data= datavalue;
    }

    public long length() throws SQLException {
        return data.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (length+pos-1 > data.length ){
            throw new SQLException(MessageTranslator.translate(MessageKey.ERROR_INVALID_BLOB_POSITION, String.valueOf(pos)));  
        }
        byte[] erg = new byte[length];
        try {
            System.arraycopy(data,(int)pos-1,erg,0,length); 
        } catch (Exception e) {
            throw new SQLException(MessageTranslator.translate(MessageKey.ERROR_INVALID_BLOB_POSITION, String.valueOf(pos)));  
        }
        return erg;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(data);
    }



}
