/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.io.InputStream;
import java.sql.SQLException;

import com.sap.dbtech.util.StructuredMem;
/**
 *
 */
public class BinaryStreamTranslator extends StreamTranslator {
    /**
     * AsciiStreamTranslator constructor comment.
     * @param mode int
     * @param ioType int
     * @param dataType int
     * @param len int
     * @param ioLen int
     * @param bufpos int
     */
    protected BinaryStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos, 
            boolean readOnly, 
            boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public java.io.InputStream getBinaryStream (
        SQLParamController controller,
        StructuredMem mem,
        StructuredMem longData) throws SQLException
    {
        return this.getStream (controller, mem, longData);
    }
    public byte getByte (
        SQLParamController controller,
        StructuredMem mem) throws SQLException
    {
        byte [] result = null;
        if (this.isNull (controller, mem))
          return 0;
        else
          result = this.getBytes(controller,mem);
        return result[0];
    }
    /**
     *
     * @return byte []
     */
    public byte [] getBytes (
            SQLParamController controller,
            StructuredMem mem)
        throws SQLException
    {
        java.io.InputStream blobStream;
        java.io.ByteArrayOutputStream tmpStream;

        blobStream = this.getBinaryStream (controller, mem, controller.getReplyData());
        if (blobStream == null) {
            return null;
        }
        try {
            final int bufSizeC = 4096;
            byte [] buf = new byte [bufSizeC];
            int readLen;

            tmpStream = new java.io.ByteArrayOutputStream ();
            readLen = blobStream.read (buf);
            while (readLen > 0) {
                tmpStream.write (buf, 0, readLen);
                if (readLen < bufSizeC) {
                    break;
                }
                readLen = blobStream.read (buf);
            }
        }
        catch (com.sap.dbtech.jdbc.exceptions.StreamIOException sqlExc) {
            throw sqlExc.getSqlException ();
        }
        catch (java.io.IOException ioExc) {
            throw new com.sap.dbtech.jdbc.exceptions.JDBCDriverException (
                ioExc.getMessage (), controller);
        }
        return tmpStream.toByteArray ();
    }
    /**
     *
     * @return java.lang.String
     */
    public Object getObject (
            SQLParamController controller,
            StructuredMem mem)
        throws SQLException
    {
        byte[] tmp = this.getBytes (controller, mem);
        if (tmp == null) {
            tmp = null;
        }
        return tmp;
    }

    public Object transByteForInput (
            byte val) throws SQLException
    {
        byte[] barr=new byte[1];
        barr[0]=val;
        return this.transBytesForInput (barr);
    }
    
	public Object transBytesForInput (byte [] val)
		 throws SQLException
	 {
		 if (val == null) {
			 return null;
		 }
         return new Putval (val, bufpos);	
	 }
 
    
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */

    public Object transBinaryStreamForInput (
        java.io.InputStream stream, int length) throws SQLException
    {
        return this.transStreamForInput (stream, length);
    }

    public Object transSpecificForInput (Object obj)
        throws SQLException
    {
        Object result = null;

        if (obj instanceof InputStream) {
            result = this.transBinaryStreamForInput ((InputStream) obj, -1);
        }
        return result;
    }
    boolean isPackectEncodingUnicode() {
        return false;
    }
}
