package com.sap.dbtech.jdbc.translators;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/*

 @author D031096

 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


 */
/**
 * @author D031096
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
abstract class BasisProcedurePutval extends AbstractProcedurePutval {

    protected InputStream stream;
    protected boolean     marksupported;
    protected int         length;
    protected boolean     atBegin;
    /**
     * @param translator
     */
    public BasisProcedurePutval(DBTechTranslator translator, InputStream stream, int length){
        super(translator);
        this.atBegin = true;
        if(length == -1) {
            this.stream = stream;
            this.marksupported = this.stream.markSupported();
            this.length = Integer.MAX_VALUE; 
        } else {
            this.stream = new InputStreamFilter(stream, length);
            this.marksupported = this.stream.markSupported();
            this.length = length;
        }
        if(marksupported) {
            this.stream.mark(this.length);
        }
    }

    public void transferStream(DataPart dataPart, short rowCount) throws SQLException {
        if(rowCount == STREAM_RESET) {
            if(!atBegin) {
                if(marksupported) {
                    try {
                        stream.reset();
                        this.atBegin = true;
                        stream.mark(length);
                    } catch(IOException ioEx) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
        						ioEx.getMessage()));
                    }
                } else {
                    throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_RESET_STREAM));
                }
            }
            rowCount = Short.MAX_VALUE;
        } else if(atBegin) {
            if(marksupported) {
                stream.mark(length);
            }
        }
        
        if(dataPart.fillWithProcedureStream(stream, rowCount)) {
    	}          	
        this.atBegin = false;
    }

    public void closeStream() throws SQLExceptionSapDB {
        try {
            stream.close();
        } catch(IOException ioex) {
            throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
    					ioex.getMessage()));                   
        }
    }



}
