/*!
	========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/
package com.sap.dbtech.jdbc.translators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;

public class ABAPStreamArray implements Array {

	StructMemberTranslator[] memberTranslator;
	StructuredBytes          rawData;
	int                      elementCount;
	int                      recordSize;
 	ArrayList                elements;
 	String                   baseTypeName;
 	
 	public ABAPStreamArray(StructuredBytes data, 
 						   StructMemberTranslator[] translator,
 						   int elementCount,
 						   String baseTypeName) throws SQLException {
 		this.rawData          = data;
 		this.memberTranslator = translator;
 		this.elementCount     = elementCount;
 		this.elements         = new ArrayList();
 		
 		if((this.rawData.size() % elementCount) != 0) {
 			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_ODDSIZE));
 		}
 		this.recordSize = this.rawData.size() / elementCount;
 		this.baseTypeName = baseTypeName;
// 		System.err.println("=== REPLY ===");
 		this.rawData.traceOn(System.err);
 	}
	
	public int getBaseType() throws SQLException {
		return 0;
	}

	public Object getArray() throws SQLException {
		checkArray(0, elementCount);
		return elements.toArray();
	}

	public Object getArray(long index, int count) throws SQLException {
		return null;
	}

	public String getBaseTypeName() throws SQLException {
		return this.baseTypeName;
	}

	public ResultSet getResultSet() throws SQLException {
		return null;
	}

	public ResultSet getResultSet(long arg0, int arg1) throws SQLException {
		return null;
	}

	public Object getArray(long arg0, int arg1, Map arg2) throws SQLException {
		return null;
	}

	public Object getArray(Map arg0) throws SQLException {
		return null;
	}

	public ResultSet getResultSet(long arg0, int arg1, Map arg2)
		throws SQLException {
		return null;
	}

	public ResultSet getResultSet(Map arg0) throws SQLException {
		return null;
	}
	
	private void checkArray(long startindex, int count) 
		throws SQLException {
		for(long ex=startindex; ex<count && ex<elements.size(); ++ex) {
			if(elements.get((int)ex) == null) {
				elements.set((int)ex, getObject(ex));		
			}
		}
		for(long i=elements.size(); i<count; ++i) {
			elements.add(getObject(i));
		}
	}
	
	private Object getObject(long index) 
		throws SQLException {
		//System.err.println("GETTING OBJECT #" + index);
		//System.err.println("RECORD SIZE #" + recordSize);
		if(memberTranslator.length == 1) {
			return memberTranslator[0].getObject(this.rawData, (int)index * recordSize);
		} else {
			Object[] result = new Object[memberTranslator.length];
			for(int i=0; i<memberTranslator.length; ++i) {
				result[i] = memberTranslator[i].getObject(rawData, (int)index * recordSize);
			}
			Structure s = new Structure(result, baseTypeName);
			// System.err.println("================================ STRUCT");
			// System.err.println(s.toString());
			return s;
		}
	}

	public String toString() {
		try {
			Object[] values=(Object[]) getArray();
			StringWriter sw = new StringWriter();
			PrintWriter pw = new PrintWriter(sw);
			pw.println("ARRAY [" + values.length + "] = {");
			
			for(int i=0; i<values.length; ++i) {
				if(i != 0) {
					pw.println(",");
				}
				pw.print(values[i].toString());
			}
			pw.println("");
			pw.println("}");
			
			return sw.toString();
		} catch(Exception ex) {
			return "*** not available ***";
		}
	}
}
