/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.util.cache.LruCache;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;

public class ParseinfoCache
extends LruCache {
    static final int defaultSizeC = 1000;
    private static final int maxFunctionCodeC = 10;
    private boolean keepStats;
    private boolean[] kindFilter;
    private Info[] stats;

    public ParseinfoCache(Properties properties) {
        super(ParseinfoCache.getSizeProperty(properties));
        this.setOptions(properties);
    }

    static int getSizeProperty(Properties properties) {
        int n = DriverSapDB.getIntProperty(properties, "cachesize", 1000);
        return n;
    }

    private void setOptions(Properties properties) {
        String string = properties.getProperty("cache");
        this.kindFilter = new boolean[10];
        if (string.indexOf(63) >= 0) {
            this.initStats();
        }
        if (string.indexOf("all") >= 0) {
            for (int i = 0; i < 10; ++i) {
                this.kindFilter[i] = true;
            }
        } else {
            if (string.indexOf("i") >= 0) {
                this.kindFilter[3] = true;
            }
            if (string.indexOf("u") >= 0) {
                this.kindFilter[5] = true;
            }
            if (string.indexOf("d") >= 0) {
                this.kindFilter[9] = true;
            }
            if (string.indexOf("s") >= 0) {
                this.kindFilter[4] = true;
            }
        }
    }

    private void initStats() {
        this.keepStats = true;
        this.stats = new Info[10];
        this.stats[0] = new Info("other");
        this.stats[3] = new Info("Insert");
        this.stats[4] = new Info("select");
        this.stats[5] = new Info("update");
        this.stats[9] = new Info("delete");
    }

    public Parseinfo findParseinfo(String string) {
        Parseinfo parseinfo = null;
        parseinfo = (Parseinfo)this.get(string);
        if (this.keepStats && parseinfo != null) {
            this.stats[ParseinfoCache.mapFunctionCode(parseinfo.functionCode)].addHit();
        }
        return parseinfo;
    }

    public void addParseinfo(Parseinfo parseinfo) {
        int n = ParseinfoCache.mapFunctionCode(parseinfo.functionCode);
        if (this.kindFilter[n]) {
            this.put(parseinfo.sqlCmd, parseinfo);
            parseinfo.cached = true;
            if (this.keepStats) {
                this.stats[n].addMiss();
            }
        }
    }

    private static int mapFunctionCode(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public Info[] getStats() {
        Info[] infoArray;
        if (!this.keepStats) {
            return null;
        }
        infoArray = new Info[]{this.stats[0], this.stats[3], this.stats[5], this.stats[9], this.stats[4], Info.cummulate(infoArray)};
        return infoArray;
    }

    public void dumpStats(PrintWriter printWriter) {
        if (!this.keepStats) {
            return;
        }
        printWriter.println("Parseinfo cache statistics:");
        Info[] infoArray = this.getStats();
        for (int i = 0; i < infoArray.length; ++i) {
            printWriter.println(infoArray[i].toString());
        }
    }

    public void dumpStats(PrintStream printStream) {
        if (!this.keepStats) {
            return;
        }
        printStream.println("Parseinfo cache statistics:");
        Info[] infoArray = this.getStats();
        for (int i = 0; i < infoArray.length; ++i) {
            printStream.println(infoArray[i].toString());
        }
    }

    public static class Info {
        private String name;
        private long hits;
        private long misses;

        Info(String string) {
            this.name = string;
            this.hits = 0L;
            this.misses = 0L;
        }

        public String toString() {
            return this.name + ": " + this.hits + " hits, " + this.misses + " misses, " + this.hitrate() + "%";
        }

        final void addHit() {
            ++this.hits;
        }

        final void addMiss() {
            ++this.misses;
        }

        public double hitrate() {
            long l = this.hits + this.misses;
            return (double)this.hits / (double)l * 100.0;
        }

        protected static Info cummulate(Info[] infoArray) {
            Info info = new Info("all");
            for (int i = 0; i < infoArray.length; ++i) {
                if (infoArray[i] == null) continue;
                info.hits += infoArray[i].hits;
                info.misses += infoArray[i].misses;
            }
            return info;
        }
    }
}

