/*!
	\file    Interval.java
	\author  TiloH
	\ingroup DBM Server test
	\brief   

    ========== licence begin  GPL
    Copyright (c) 2006 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/

package com.sap.sapdb.DBMTest.backup.automatic.log;

import java.sql.SQLException;

import com.sap.sapdb.DBMTest.DBMUtility;
import com.sap.sapdb.DBMTest.util.MessageTable;
import com.sap.sapdb.DBMTest.MediumPut;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestProtocol;

/**
 * @author d025561
 * 
 * The following test tries to use the interval feature of automatic log backups.
 * This is currently only a basic smoke test as a check is missing, wether the
 * DBM really switches on the correct things in the database kernel or not. 
 */
public class Interval extends MediumPut {

    String m_ReplacedAutoMedium;
    DBMUtility m_DBM = null; 
	/**
	 * @throws SQLException
	 * @throws TestDatabaseException
	 */
	public Interval() throws SQLException, TestDatabaseException {
		super();
	}

    boolean getAutoLogMedium()
    {
        boolean      rc=false;
        MessageTable msgTab = new MessageTable();

        if (m_DBM.execCmd("medium_getall", DBMUtility.OK_OK))
        {
            //parse reply
            msgTab.setMessage(m_DBM.getAnswer());

            //find AUTO medium
            for (int r = 0 ; r < msgTab.getRowCount(); r++)
            {
                int firstTab=msgTab.getRow(r).indexOf("\t");

                if(-1<firstTab && -1!=msgTab.getRow(r).indexOf("FILE\tAUTO"))
                {
                    m_ReplacedAutoMedium=msgTab.getRow(r).substring(0, firstTab);
                    rc=true;
                }
            }
        }

        if(!rc)
            addMessage("Could not determine previuos existing autolog medium.", TestProtocol.ERROR , msgTab.getMessage());
        
        return rc;
    }
    
    void restoreAutoLogMedium()
    {
        m_DBM.execCmd("autolog_on "+m_ReplacedAutoMedium, DBMUtility.OK_OK);
        m_DBM.execCmd("autolog_off", DBMUtility.OK_OK);
    }
	
	/**
	 * @see com.sap.sapdb.testframe.testcase.TestCase#run()
	 */
	public void run()
	{
		//prepare the actual test
		try
		{
			m_DBM = new  DBMUtility(getDatabase(), this);
			getAutoLogMedium();
			m_DBM.execCmd("medium_put AutoLogIntervalData testAutomaticLogWithIntervalData FILE DATA 0 8 yes NO \"\" NONE", DBMUtility.OK_OK);
			m_DBM.execCmd("util_connect", DBMUtility.OK_OK);
			m_DBM.execCmd("backup_start AutoLogIntervalData", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_off", DBMUtility.OK_OK);
		}
		catch (Exception e)
		{
			super.addMessage(
				super.getTestId(),
				TestProtocol.ERROR,
				e.getClass().getName()
					+ " caught while preparing test ( "
					+ e.getMessage()
					+ "). Aborting test.");
		}
		
		//test if a not configured backup tools are reported as such
		try
		{
			//create a backup medium for automatic log backup with interval of 10 seconds should fail below 7.7
			m_DBM.execCmd("medium_put AutoLogInterval testAutomaticLogWithInterval FILE LOG 0 8 yes NO \"\" NONE 10", DBMUtility.ERR_TOMANYPARAM);
			m_DBM.execCmd("medium_put AutoLogInterval testAutomaticLogWithInterval FILE LOG 0 8 yes NO \"\" NONE", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_on AutoLogInterval", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_off", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_on AutoLogInterval INTERVAL 11", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_off", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_on interval 12", DBMUtility.OK_OK);
			m_DBM.execCmd("autolog_off", DBMUtility.OK_OK);
		}
		catch (Exception e)
		{
			super.addMessage(
				super.getTestId(),
				TestProtocol.ERROR,
				e.getClass().getName()
					+ " caught during test ( "
					+ e.getMessage()
					+ "). Aborting failed test.");
		}
		
		//clean up as much as possible
		finally
		{
			try
			{
				restoreAutoLogMedium();
				m_DBM.execCmd("medium_delete AutoLogInterval", DBMUtility.OK_OK);
				m_DBM.execCmd("medium_delete AutoLogIntervalData", DBMUtility.OK_OK);
			    m_DBM.execCmd("db_release", DBMUtility.OK_OK);
			}
			catch(Exception e)
			{
				super.addMessage(
					super.getTestId(),
					TestProtocol.ERROR,
					e.getClass().getName()
						+ " caught while cleaning up test resources ( "
						+ e.getMessage()
						+ "). Aborting test.");
			}
		}
	}

	/**
	   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
	   * will set the name to the name of the java class. To make the test name independend
	   * from the java implementation, this method should return a unique string.
	   * Attention: The uniqueness is not automatically checked by anybody.
	   * @return The UNIQUE name of the test class
	   */
	public static String getTestClassId() {
		return "automatic log backup with interval";
	} // end getTestClassId
}
