package com.sap.sapdb.DBMTest;
/*!
  -----------------------------------------------------------------------------
  module: DBAddVolume.java
  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
import java.sql.*;
import com.sap.sapdb.testframe.driver.*;
import java.io.*;

/**
 * DBMServer
 * <xmp>
 * -----------------------------------------------------------------------------
 * Class:        DBAddVolume
 * -----------------------------------------------------------------------------
 * responsible:  ChristianH
 * special area: DBMServer Java Test
 * description:  DBMServer db_addvolume command tests
 * version:      7.4.*
 * copyright:    (c) 2000-2004 SAP AG
 * -----------------------------------------------------------------------------
 * </xmp>
 */

public class DBAddVolume extends BackupState
{
  public DBAddVolume() throws SQLException, TestDatabaseException
  {
    super();
  }
  /**
   * run() contains the test implementation
   */
  public void run()
  {
    DBMUtility oDBM = new  DBMUtility(getDatabase(), this);
    TestDatabaseSap sapdb = (TestDatabaseSap) getDatabase();
    String name = getTestClassId();

    //  create one global try-catch block to handle exceptions
    try
    {
      //Too few parameters - command only
      oDBM.execCmd("db_addvolume",DBMUtility.ERR_TOFEWPARAM);
      //Too few parameters - datamedium type
      oDBM.execCmd("db_addvolume DATA",DBMUtility.ERR_TOFEWPARAM);
      //Too few parameters - datamedium type, name of device
      oDBM.execCmd("db_addvolume DATA " + name + "_DATA",DBMUtility.ERR_TOFEWPARAM);
      //Too few parameters - datamedium type, name of masterdevice, type of devspace
      oDBM.execCmd("db_addvolume DATA " + name + "_DATA F",DBMUtility.ERR_TOFEWPARAM);
      //datamedium type, name of masterdevice, type of devspace, block size [pages]
      oDBM.execCmd("db_addvolume DATA " + name + "_DATA F 625",DBMUtility.OK_OK);

      //Too few parameters - datamedium type
      oDBM.execCmd("db_addvolume LOG",DBMUtility.ERR_TOFEWPARAM);
      //Too few parameters - datamedium type, name of device
      oDBM.execCmd("db_addvolume LOG " + name + "_LOG",DBMUtility.ERR_TOFEWPARAM);
      //Too few parameters - datamedium type, name of masterdevice, type of devspace
      oDBM.execCmd("db_addvolume LOG " + name + "_LOG F",DBMUtility.ERR_TOFEWPARAM);
      //datamedium type, name of masterdevice, type of devspace, block size [pages]
      oDBM.execCmd("db_addvolume LOG " + name + "_LOG F 625",DBMUtility.OK_OK);

      oDBM.execCmd("db_offline",DBMUtility.OK_OK);

      //Run Directory clean up
      oDBM.execCmd("param_delvolume 2 DATA",DBMUtility.OK_OK);
      File f = new File(sapdb.getRunDir()+oDBM.getSrvProperty("file.separator")+name+"_DATA");
      f.delete();

      //Run Directory clean up
      oDBM.execCmd("param_delvolume 2 LOG",DBMUtility.OK_OK);
      f = new File(sapdb.getRunDir()+oDBM.getSrvProperty("file.separator")+name+"_LOG");
      f.delete();

      oDBM.execCmd("db_reinstall",DBMUtility.OK_OK);
    }
    // catch any kind of exception and write it to the protocol
    catch (Exception e) {
      // standard error handler

      this.handleExceptions(e);
    } // end try catch

    // clean up, i.e. close statements and connections
    finally {
      try {
        // print all parameters from the parameter object to the protocol.
        printParametersToProtocol();
      }
      catch (Exception e) {
        // do nothing
      } // end try catch
    } // end finally
  } // end run
  /**
   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
   * will set the name to the name of the java class. To make the test name independend
   * from the java implementation, this method should return a unique string.
   * Attention: The uniqueness is not automatically checked by anybody.
   * @return The UNIQUE name of the test class
   */
  public static String getTestClassId() {
    return "DBAddVolume";
  } // end getTestClassId
} //end of class MediumGet