/*
* @(#) endloss.cpc	7.X



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/

#include <stdio.h>
#include <signal.h>
#include <time.h>
#ifdef   _WIN32
#include <windows.h>
#define  getpid    GetCurrentProcessId
#define  sleep(x)  Sleep (x * 1000)
#else
#define  Sleep(x)  usleep (x * 1000)
#endif


void release_connect ();
void check_table ();
void update_stat ();
void update_stat_column_tab3j ();
void update_stat_sample ();
void crea_index_tab1 ();
void alter_tab3_not_dynamic ( );
void alter_tab3_dynamic ( );
void alter_tab1_not_dynamic ( );
void alter_tab1_dynamic ( );
void drop_index_tab1 ();
void insert_tab1 ();
void update_tab1_lr ();
void update_tab1 ();
void update_tab1_between ();
void update_tab1_key ();
void insert_tab3 ();
void insert_tab3j_1 ();
void insert_tab3j_2 ();
void count_tab1 ();
void delete_tab3 ();
void delete_tab3_key ();
void delete_tab3j_1 ();
void delete_tab3j_2 ();
void select_and_check_tab1sl  () ;
void update_tab1sl  ();
void delete_range_tab3_between ();
void mass_upd_tab1 ();
void delete_rollback_tab4 ();
void TraversePartList (int LockMode);
void CheckLocksPartList (int LockMode);
void CreateDummyVersion ();
void DropDummyVersion ();
void CheckVersionedLocksPartList1 (int LockMode);
void CheckVersionedLocksPartList2(int LockMode);
void sel_from_roots ();
void check_mark ();
int pe (char *s, int leave );
void print_f (char *s );
void rollback ();
void commit ();
void Sqldump ();
int rollberr (int kind );


void    check_long_raw () ;
void    update_tabv1 () ;
void    update_tabv1_2 () ;
void	delete_init_tab2 () ;
void    diagnose_analyze_on () ;
void    diagnose_analyze_count_on () ;
void    diagnose_analyze_count_off () ;
void    diagnose_analyze_off () ;
void    diagnose_analyze_clear () ;

long	TraverseList (long Lno, int RelOids,
					  long Ntt, int LockMode,
					  char *TravString ) ;
long	TraverseKeyList (long Lno, int RelOids,
					  long Ntt, int ReadLocked,
					  char *TravString ,
					  long *NoOfElems ) ;

void	ConsistentRead () ;
void	VersionedRead () ;
void	ConsistentKeyRead () ;
void	ConsistentVarRead () ;
void	ConsistentVersionKeyRead () ;
void	DebugOmsOn () ;
void	DropPrivateVersions () ;
void	protVarObjs () ;
void	protDiagnoseFiles () ;

EXEC SQL INCLUDE  "endlos.h" ;

EXEC SQL BEGIN DECLARE SECTION;
int     rows ;
char	k0 [240] ;
char    c6 [1501] ;
int     k1 , k2 , k3 ;
char    c1 [21] , c2[21] , c3[21] , c4[21] , c5[101] ;
int     i1 , i2 , i3 , i4 , i5 , i6 ;
int     ii ;
int     nr , avg , cnt ;
int     chpNum ;
long	elements , del_elements ;
long	listno ;
long	sumVarlenObj ;
char	VerString [23] ;
char	VerString2 [23] ;
char	VerString3 [23] ;
char	VerString4 [23] ;
long	vrc;
char    FiOidIn [9] ;
char    FiOidOut [9] ;
char    FiOidInVar [9] ;
char    FiOidOutVar [9] ;

int	maxlongraw ;
VARCHAR cll [MAXLONGRAW] ;
int	icll ;
int	cll_len ;
int	cll_len_i ;
int	cllen ;
int	icllen ;

struct  {long len; char arr[100000];} scl;
EXEC SQL VAR scl IS LONG VARCHAR(100000);
long	lnll , nrll ;
char	stmnt [1000] ;

EXEC SQL END DECLARE SECTION;

EXEC SQL INCLUDE SQLCA;

#ifdef _WIN32
char    buf [256] ;
#else
FILE    *fo = NULL;
#endif
FILE	*fout ;
int     line , col ;
int     maxdurch ;
int     protocol = 0 ;
int     supers ;
int     rolled_back = 0 ;
int     pid ;
int     durch ;
int     noinit = 0 ;
int		check_longs = 0 ;   /* JH  aendern ! */
int		argn ;
int		UseOms = 0 ;
int		UseKeys = 0 ;
int		UseOids = 0 ;
int		OmsDebug = 1 ;
int		MaxListNo = 20 ;
int		maxRuntime = 0 ;
int		DummyVersionWasCreated = 0 ;
int		nEndloss ;
long	endTime = 0 ;

void	cwr () ;
void    cwr_ok () ;

main (argc , argv )
int     argc ;
char    **argv ;
{
    int     i ;
    char    head_line [80] ;

	int		OnlyKeys = 0 ;
	int		OnlyObjects = 0 ;
	int		subloops ;

#ifdef _WIN32
    signal ( SIGTERM , (void (__cdecl *)(int)) cwr_ok ) ;
#else
    signal ( SIGTERM , cwr_ok ) ;
    fo = fopen ( "/dev/tty" , "w" ) ;
    if ( fo )
      if ( ! isatty(fileno(fo)) )
      {
        fclose(fo);
        fo = NULL ;
      }
#endif
    col = 1 ;

    pid = getpid () ;

    line = atoi ( argv [1] ) ;

    maxdurch = atoi ( argv [2] ) ;

	del_elements = rows / 50 ;

    for ( argn = 6 ; argn <= argc ; argn++ )
    {
		if ( strcmp ( argv [argn-1] , "noinit" ) == 0 )
		{
			noinit = 1 ;
			prot ("No init !\n");
		}
		if ( strcmp ( argv [argn-1] , "-l" ) == 0 )
			check_longs = 1 ;

		if ( strcmp ( argv [argn-1] , "-o" ) == 0 )
		{
			if ( OnlyKeys == 0 && OnlyObjects == 0)
			{
				UseOms = 1 ;
				UseKeys = 1 ;
				UseOids = 1 ;
			}
		}

		if ( strcmp ( argv [argn-1] , "-k" ) == 0 )
		{
			OnlyKeys = 1 ;
			UseOms = 1 ;
			UseKeys = 1 ;
			UseOids = 0 ;
		}

		if ( strcmp ( argv [argn-1] , "-O" ) == 0 )
		{
			OnlyObjects = 1 ;
			UseOms = 1 ;
			UseKeys = 0 ;
			UseOids = 1 ;
		}

		if ( strcmp ( argv [argn-1] , "-N" ) == 0 )
		{
			OmsDebug = 0 ;
		}

		if ( strcmp ( argv [argn-1] , "-n" ) == 0 )
		{
			nEndloss = atoi ( argv [argn] ) ;
			argn++ ;
		}
		if ( strcmp ( argv [argn-1] , "-T" ) == 0 )
		{
			maxRuntime = atoi ( argv [argn] ) ;
			argn++ ;
		}
    }

	{
		char filename [100] ;
		sprintf ( filename , "endloss%d.prot" , nEndloss ) ;

		if ( ( fout = fopen ( filename , "w" ) ) == NULL )
		{
			char outtext [100] ;
			sprintf ( outtext , "Error opening file '%s'\n" , filename ) ;
			perror ( outtext ) ;
			exit (-99) ;
		}
	}

	if ( maxRuntime > 0 )
	{
		endTime = (long) time ((time_t *) 0 ) + maxRuntime  ;
		prot ("time now: %ld\n" , (long) time ((time_t *) 0 ) ) ;
		prot ("endtime = %ld\n" , endTime ) ;
		maxdurch = 0x7fffffff ;
	}

	prot ("===== User     superu =====\n" , 0 ) ;
	sprintf ( head_line,
		"===== %s = %s =====\n" , ENV_DBNAME, getenv ( ENV_DBNAME ) ) ;
	prot ( head_line, "" ) ;

	if ( maxRuntime > 0 )
		prot ("Max. Runtime : %d sec\n" , maxRuntime ) ;
	else
		prot ("Max. Durchgaenge : %d\n" , maxdurch ) ;

	supers = atoi ( argv [3] ) ;
	prot ( "supers = %d\n" , supers ) ;

	rows = atoi ( argv [4] ) ;
	prot ("Rows = %d\n" , rows ) ;

#ifdef PROTOKOLL
    protocol = 1 ;
    movep ( line , col , "writing protocol" , SQLC ) ;
    sleep (1) ;
#endif

    movep ( line , col , "CONNECT" , SQLC ) ;
    EXEC SQL CONNECT SUPERU IDENTIFIED BY SUPERU KEY SQLOPT;
    movep ( line , col , "CONNECT , ERR = %d" , SQLC ) ;
    CE ("CONNECT" , 1 ) ;



	if ( UseOms )
	{
		char pidString [20] ;
		sprintf ( pidString , "%ld" , (long) pid ) ;

		memset ( VerString , 'a' , 22 ) ;
		VerString [22] = 0 ;
		memcpy ( VerString , pidString , (int)strlen (pidString) ) ;

		memset ( VerString2 , 'b' , 22 ) ;
		VerString2 [22] = 0 ;
		memcpy ( VerString2 , pidString , (int)strlen (pidString) ) ;

		memset ( VerString3 , 'c' , 22 ) ;
		VerString3 [22] = 0 ;
		memcpy ( VerString3 , pidString , (int)strlen (pidString) ) ;

		memset ( VerString4 , 'd' , 22 ) ;
		VerString4 [22] = 0 ;
		memcpy ( VerString4 , pidString , (int)strlen (pidString) ) ;

		commit () ;

		DropPrivateVersions () ;
		/*
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString2, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString3, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		*/
		if ( OmsDebug )
			DebugOmsOn () ;
	}

    EXEC SQL
		SELECT maxr INTO :maxlongraw FROM superu.maxraw WHERE ROWNO <= 1 ;

    CE ("SELECT MAXRAW ... " , 1 ) ;

    prot ("maxlongraw = %d\n" , maxlongraw ) ;

    srand ( pid ) ;

    memset ( k0 , 'x' , 240 ) ;
    k0[239] = 0 ;
    memset ( c6 , 'y' , 1500 ) ;
    c6 [1499] = 0 ;

    for ( durch = 1 ; durch <= maxdurch ; durch++ )
    {
		movep (line-1 , col , "DBA :      Durchlauf %d" , durch ) ;

		if ( durch % 25 == 0 )
			release_connect () ;

		if ( !UseOms )
		{
			if ( ( durch % 12 == 2 ) && ( supers == 0 ) )
				delete_rollback_tab4 () ;

			if ( supers == 0 )
				update_stat_column_tab3j () ;

			/* wegen sqlcode -7015 & -7012        1994-03-25 glo */
			/* if ( durch != 1 && supers ) delete_init_tab2 () ; */

			switch ( durch % 8 )
			{
			case 0 :
			case 1 :
				diagnose_analyze_clear (1) ;
				break ;
			case 2 :
				drop_index_tab1 () ;
				diagnose_analyze_on () ;
				break ;
			case 3 :
				diagnose_analyze_clear (0) ;
				alter_tab3_not_dynamic () ;
				alter_tab1_dynamic () ;
				diagnose_analyze_count_on () ;
				break ;
			case 4 :
				check_table () ;
				diagnose_analyze_clear (1) ;
				break ;
			case 5 :
				diagnose_analyze_clear (0) ;
				alter_tab3_dynamic () ;
				alter_tab1_not_dynamic () ;
				diagnose_analyze_count_off () ;
				break ;
			case 6 :
				diagnose_analyze_clear (0) ;
				crea_index_tab1 () ;
				diagnose_analyze_off () ;
				break ;
			case 7 :
				update_stat () ;
				diagnose_analyze_clear (1) ;
				break ;
			}
		}
		else
		{
			if ( supers == 0 )
				protVarObjs () ;
		}

		subloops = UseOms ? 50 : 200 ;

		for ( i = 1 ; i < subloops ; i++ )
		{
			movep ( line-1 , 40 , "%d" , i ) ;

			if ( UseOms ) /* testet nur OMS, kein SQL */
			{

				if ( UseOids ) /* falls nur OIDs (keine Keys) */
				{
					AddElementToList (0) ;

					DeleteElememtsFromList (1) ;

					if ( ( rand () % 2 ) == 0 )
						ConsistentRead () ;

					if ( ( rand () % 5) == 0 )
						CheckLocksPartList (1) ;

					/* if ( ( rand () % 79 ) == 0 ) */
					/*	CreateList (0) ;  */

					if ( ( rand () % 8) == 0 )
						DeleteElememtsFromList (0) ;

					if ( ( rand () % 9) == 0 )
						TraversePartList (1) ;	/* read locked */

					if ( ( rand () % 10 ) == 0 )
						ConsistentVarRead () ;

					if ( ( rand () % 24) == 0 )
						VersionedRead () ;

					if ( ( rand () % 71) == 0 )
						ReadIteratedList() ;

					if ( ( rand () % 100 ) == 0 )
						ReadIteratedVarList() ;

					if ( (rand () % 250 ) == 0 )
						CompareSingleIterated() ;
				}

				if ( UseKeys )
				{
					DeleteElememtsFromKeyList (1) ;

					if ( ( rand () % 2) == 0 )
						ConsistentKeyRead () ;

					if ( ( rand () % 15) == 0 )
						ConsistentVersionKeyRead () ;
				}
			}
			else /* SQL Tests */
			{
				if ( i % 128 == 40 )
					protDiagnoseFiles () ;

				insert_tab3j_1 () ;

				if ( ( rand () % 2 ) == 0 )
					insert_tab3j_2 () ;

				if ( check_longs == 0 || ( rand () % 2 ) == 0 )
					insert_tab3 () ;

				if ( check_longs == 0 && ( rand () % 3 ) == 0 )
					update_tab1 () ;

				if ( ( rand () % 4 ) == 0 )
					insert_tab1 () ;

				if ( ( rand () % 17 ) == 0 )
					update_tab1_lr () ;

				if ( ( rand () % 18 ) == 0 )
					update_tab1_key () ;

				if ( ( rand () % 19 ) == 0 )
					update_tabv1_2 () ;

				if ( ( rand () % 23 ) == 0 )
					update_tab1_between () ;

				if ( ( rand () % 29) == 0 )
					select_and_check_tab1sl  ()  ;

				if ( ( rand () % 35 ) == 0 )
					update_tabv1 () ;

				if ( ( rand () % 51 ) == 0 )
					delete_tab3 () ;

				if ( ( rand () % 53 ) == 0 )
					delete_tab3_key () ;

				if ( ( rand () % 71 ) == 0 )
					update_tab1sl () ;

				if ( ( rand () % 75 ) == 0 )
					delete_range_tab3_between () ;

				if ( ( rand () % 77 ) == 0 )
					mass_upd_tab1 () ;

					/*
					if ( ( rand () % 97 ) == 0 )
					sel_from_roots () ;
				*/

				if ( ( rand () % 101 ) == 0 )
					count_tab1 () ;

				if ( ( rand () % 149 ) == 0 )
					update_stat_sample () ;

				if ( ( rand () % 4096 ) == 0 )
					delete_tab3j_1 () ;

				if ( ( rand () % 9192 ) == 0 )
					delete_tab3j_2 () ;
			}

			if ( ( supers == 0 ) && ( ( rand () % 10 ) == 0 ) )
				release_connect () ;

			if ( maxRuntime > 0 && endTime < (long) time ((time_t *) 0 ) )
			{
				prot ("Endtime reached: %ld\n", (long) time ((time_t *)0) );
				break ;
			}

		}
		if ( maxRuntime > 0 && endTime < (long) time ((time_t *) 0 ) )
			break ;

    }
    movep ( line , col , "***** ENDE *****" , "" ) ;

	if ( UseOms )
	{
		DropPrivateVersions () ;
	}
    // stop analyzing, because normal sessions will work longer than dba
    // and will fill database with analyze-info
    else
    {
        diagnose_analyze_off () ;
    }

	cwr () ;
}

/*------------------------------------------------------------------------*/

void release_connect ()
{
    EXEC SQL
		COMMIT WORK RELEASE  ;

    movep ( line , col , "COMMIT WORK RELEASE , ERR = %d" , SQLC ) ;
    CE ("COMMIT WORK RELEASE " , 1 ) ;

    sleep ( rand () % 5 ) ;

    EXEC SQL CONNECT SUPERU IDENTIFIED BY SUPERU KEY SQLOPT;
    movep ( line , col , "CONNECT , ERR = %d" , SQLC ) ;

    if ( SQLC == -9807 )
    {
		cwr () ;
    }

	if ( UseOms && OmsDebug )
		DebugOmsOn () ;

    CE ("CONNECT" , 1 ) ;
}

/*------------------------------------------------------------------------*/

void check_table ()
{

    if ( supers == 1 )
    {

		if ( rand () % 2 )
        {
			movep (line,col,"CHECK TABLE TAB1\n",0) ;
			do
			{
				EXEC SQL
					CHECK TABLE TAB1 ;

				CE ("CHECK TABLE TAB1" , 0 ) ;
			} while ( rollberr (2) ) ;
        }
		else
		{
			movep (line,col,"CHECK TABLE TAB4\n",0) ;
			do
			{
				EXEC SQL
					CHECK TABLE TAB4 ;

				CE ("CHECK TABLE TAB4" , 0 ) ;
			} while ( rollberr (2) ) ;
        }
		CE ("CHECK TABLE" , 1 ) ;
    }


}

/*------------------------------------------------------------------------*/

void update_stat ()
{

    int z = 0 ;

    if ( supers == 1 )
    {
		if ( rand () % 2 )
        {
			movep (line,col,"UPDATE STATISTICS *\n",0) ;
			do
			{
				EXEC SQL
					UPDATE STATISTICS * ;

				if ( SQLC == -3007 && z++ < 2 )
				{
                    prot ("UPDATE STATISTICS *\n",0);
					SQLC = 500 ;
				}
				else
					CE ("UPDATE STATISTICS *" , 0 ) ;

			} while ( rollberr (2) ) ;
			SE ("UPDATE STATISTICS *" , 1 ) ;
        }
		else
		{
			movep (line,col,"UPDATE STATISTICS COLUMN (*)\n",0) ;
			do
			{
				EXEC SQL
					UPDATE STATISTICS COLUMN (*) FOR TAB1 ;

				if ( SQLC == -3007 && z++ < 2 )
				{
                    prot ("UPDATE STATISTICS COLUMN ... \n",0);
					SQLC = 500 ;
				}
				else
					CE ("UPDATE STATISTICS COLUMN ... " , 0 ) ;

			} while ( rollberr (2) ) ;
            SE ("UPDATE STATISTICS COLUMN ... "  , 1 ) ;
        }
    }
}

/*------------------------------------------------------------------------*/

void update_stat_column_tab3j ()
{
	int i ;

	movep (line,col,"UPDATE STATISTICS COLUMN (*) FOR TAB3J_X\n",0) ;

	for ( i = 1 ; i <= 4 ; i++ )
	{
		sprintf ( stmnt ,"UPDATE STATISTICS COLUMN (*) FOR TAB3J_%d", i ) ;

		do
		{

			EXEC SQL EXECUTE IMMEDIATE :stmnt ;
			CE (stmnt , 0 ) ;

		} while ( rollberr (2) ) ;

		SE ( stmnt , 1 ) ;

		commit () ;
	}
}

/*------------------------------------------------------------------------*/

void update_stat_sample ()
{
    int z = 0 ;

    movep (line,col,"UPDATE STATISTICS ... SAMPLE \n",0) ;

    do
    {
	EXEC SQL UPDATE STATISTICS TAB1 ESTIMATE SAMPLE 1000 ROWS  ;

	if ( SQLC == -3007 && z++ < 2 )
	{
            prot ("UPDATE STATISTICS ... SAMPLE, sqlcode = \n",SQLC);
            rollback () ;
	    SQLC = 500 ;
	}
	else
	    SE ("UPDATE STATISTICS ... SAMPLE" , 0 ) ;

    } while ( rollberr (2) ) ;

    SE ("UPDATE STATISTICS ... SAMPLE" , 1 ) ;

    if ( rand () % 2 )
        commit () ;
    else
	rollback () ;

    movep (line,col,"UPDATE STATISTICS COLUMN ... SAMPLE \n",0) ;

    do
    {
	EXEC SQL UPDATE STATISTICS COLUMN (*) FOR TAB1 ESTIMATE SAMPLE 1000 ROWS  ;
	if ( SQLC == -3007 && z++ < 2 )
	{
            prot ("UPDATE STATISTICS COLUMN ... SAMPLE, sqlcode = \n",SQLC);
            rollback () ;
	    SQLC = 500 ;
	}
	else
	   SE ("UPDATE STATISTICS COLUMN ... SAMPLE" , 0 ) ;

    } while ( rollberr (2) ) ;

    SE ("UPDATE STATISTICS COLUMN ... SAMPLE" , 1 ) ;

    commit () ;

}

/*------------------------------------------------------------------------*/

void crea_index_tab1 ()
{
    if ( supers == 1 )
    {
	movep (line,col,"CREATE INDEX TAB1(I3)\n","") ;

	do
	{
	    EXEC SQL
	      CREATE INDEX TAB1_I3 ON TAB1(I3)  ;

	    CE ( "CREATE INDEX ON TAB1 (I3)",0);

	    if ( ( SQLC < 0 ) && ( SQLC != -1000 ) )
	    {
		print_f ("calling sqldump") ;
		Sqldump () ;
		exit (1) ;
	    }

	} while ( rollberr (2) ) ;

	if ( ! ( noinit && SQLC == -103 ) )
	{
	    CE ( "CREATE INDEX ON TAB1 (I3)",1);
	}

	commit () ;

    }

}

/*------------------------------------------------------------------------*/

void alter_tab3_not_dynamic ( )
{
    if ( supers == 1 )
    {
		do
		{
			movep (line,col,"ALTER TABLE TAB3 NOT DYNAMIC\n","") ;
			prot ("Try to set TAB3 to NOT DYNAMIC\n",0);
			EXEC SQL BEFORE NOT DYNAMIC ; /* for vtrace */
			EXEC SQL
				ALTER TABLE TAB3 NOT DYNAMIC ;
			CE ("ALTER TABLE TAB3 NOT DYNAMIC",0 ) ;
		}    while ( rollberr(2) ) ;

        CE ("ALTER TABLE TAB3 NOT DYNAMIC",1 ) ;
        prot ("Set TAB3 to NOT DYNAMIC\n",0);

		if ( rand () % 2 )
		{
			do
			{
				movep (line,col,"ALTER TABLE TAB3J_1 NOT DYNAMIC\n","") ;
				prot ("Try to set TAB3J_1 to NOT DYNAMIC\n",0);
				EXEC SQL BEFORE NOT DYNAMIC ; /* for vtrace */
				EXEC SQL
					ALTER TABLE TAB3J_1 NOT DYNAMIC ;
				CE ("ALTER TABLE TAB3J_1 NOT DYNAMIC",0 ) ;
			}    while ( rollberr(2) ) ;

			CE ("ALTER TABLE TAB3J_1 NOT DYNAMIC",1 ) ;
			prot ("Set TAB3J_1 to NOT DYNAMIC\n",0);
		}

		if ( rand () % 2 )
		{
			do
			{
				movep (line,col,"ALTER TABLE TAB3J_2 NOT DYNAMIC\n","") ;
				prot ("Try to set TAB3J_2 to NOT DYNAMIC\n",0);
				EXEC SQL BEFORE NOT DYNAMIC ; /* for vtrace */
				EXEC SQL
					ALTER TABLE TAB3J_2 NOT DYNAMIC ;
				CE ("ALTER TABLE TAB3J_2 NOT DYNAMIC",0 ) ;
			}    while ( rollberr(2) ) ;

			CE ("ALTER TABLE TAB3J_2 NOT DYNAMIC",1 ) ;
			prot ("Set TAB3J_2 to NOT DYNAMIC\n",0);
		}
	}
}

/*------------------------------------------------------------------------*/

void alter_tab3_dynamic ( )
{
    if ( supers == 1 )
    {
		do
		{
			movep (line,col,"ALTER TABLE TAB3 DYNAMIC\n","") ;
            prot ("Try to set TAB3 to DYNAMIC\n",0);
			EXEC SQL BEFORE DYNAMIC ; /* for vtrace */
			EXEC SQL
				ALTER TABLE TAB3 DYNAMIC ;
			CE ("ALTER TABLE TAB3 DYNAMIC",0 ) ;
		}    while ( rollberr(2) ) ;

        CE ("ALTER TABLE TAB3 DYNAMIC",1 ) ;
        prot ("Set TAB3 to DYNAMIC\n",0);

		if ( rand () % 2 )
		{
			do
			{
				movep (line,col,"ALTER TABLE TAB3J_1 DYNAMIC\n","") ;
				prot ("Try to set TAB3J_1 to DYNAMIC\n",0);
				EXEC SQL BEFORE DYNAMIC ; /* for vtrace */
				EXEC SQL
					ALTER TABLE TAB3J_1 DYNAMIC ;
				CE ("ALTER TABLE TAB3J_1 DYNAMIC",0 ) ;
			}    while ( rollberr(2) ) ;

			CE ("ALTER TABLE TAB3J_1 DYNAMIC",1 ) ;
			prot ("Set TAB3 to DYNAMIC\n",0);
		}

		if ( rand () % 2 )
		{
			do
			{
				movep (line,col,"ALTER TABLE TAB3J_2 DYNAMIC\n","") ;
				prot ("Try to set TAB3J_2 to DYNAMIC\n",0);
				EXEC SQL BEFORE DYNAMIC ; /* for vtrace */
				EXEC SQL
					ALTER TABLE TAB3J_2 DYNAMIC ;
				CE ("ALTER TABLE TAB3J_2 DYNAMIC",0 ) ;
			}    while ( rollberr(2) ) ;

			CE ("ALTER TABLE TAB3J_2 DYNAMIC",1 ) ;
			prot ("Set TAB3J_2 to DYNAMIC\n",0);
		}
    }
}

/*------------------------------------------------------------------------*/

void alter_tab1_not_dynamic ( )
{
    if ( supers == 1 )
    {
	do
	{
	    movep (line,col,"ALTER TABLE TAB1 NOT DYNAMIC\n","") ;

	    EXEC SQL
	      ALTER TABLE TAB1 NOT DYNAMIC ;

	    CE ("ALTER TABLE TAB1 NOT DYNAMIC",0 ) ;
	}    while ( rollberr(2) ) ;

        CE ("ALTER TABLE TAB1 NOT DYNAMIC",1 ) ;
        prot ("Set TAB1 to NOT DYNAMIC\n",0);
    }
}

/*------------------------------------------------------------------------*/

void alter_tab1_dynamic ( )
{
    if ( supers == 1 )
    {
	do
	{
	    movep (line,col,"ALTER TABLE TAB1 DYNAMIC\n","") ;

	    EXEC SQL
 	      ALTER TABLE TAB1 DYNAMIC ;

	    CE ("ALTER TABLE TAB1 DYNAMIC",0 ) ;
	}    while ( rollberr(2) ) ;

        CE ("ALTER TABLE TAB1 DYNAMIC",1 ) ;
        prot ("Set TAB1 to DYNAMIC\n",0);
    }
}

/*------------------------------------------------------------------------*/

void drop_index_tab1 ()
{
	int dump_c = DumpOnLongCheck ;

	if ( supers == 1 )
	{
		do
		{
			do
			{
				movep (line,col,"LOCK TABLE TAB1 IN EXCLUSIVE MODE",0) ;

				EXEC SQL
					LOCK TABLE TAB1 IN EXCLUSIVE MODE ;

				CE ( "LOCK TABLE TAB1 IN EXCLUSIVE MODE",0) ;
			} while ( rollberr (2) ) ;

			CE ( "LOCK TABLE TAB1 IN EXCLUSIVE MODE",1) ;

			DumpOnLongCheck = 1 ;
			check_long_raw ( "CHECK ALL WITH DUMP" ,  1  , 99999 , -1  , -1 )  ;
			DumpOnLongCheck = dump_c ;
			movep (line,col,"DROP INDEX TAB1_I3 ON TAB1\n","") ;

			movep ( line , col , "DROP INDEX TAB1(I3)","" ) ;

			EXEC SQL
				DROP INDEX TAB1_I3 ON TAB1 ;

			CE ( "DROP INDEX TAB1_I3 ON TAB1",0);

		} while ( rollberr (2) ) ;

		if ( ! ( noinit && SQLC == -104 ) )
		{
			CE ( "DROP INDEX TAB1_I3 ON TAB1",1);
		}

		commit () ;
	}
}

/*------------------------------------------------------------------------*/

void insert_tab1 ()
{
    int     i ;

    i = rand () % rows ;

    k1 = i ;
    i1 = i * 100 + 1 ;
    i2 = i % 10 + 1 ;
    sprintf ( c1 , "Name_i%d" , i ) ;
    sprintf ( c2 , "Name.i%d" , i / 10 ) ;
    i3 = i / 10 ;

    memset ( c6 , 'y' , 1500 ) ;
    c6 [(rand()%1250)+250] = 0 ;

    cll.len = rand () % maxlongraw + 4 ;
    cll_len = cll.len ;
    memset ( cll.arr , '2' , cll.len ) ;
    /* cll.arr[0] = cll.len / 256 ;
    cll.arr[1] = cll.len & 0xff ; */
    cll.arr[0] = ( cll.len >> 8 ) & 0x7f  ;
    cll.arr[1] = cll.len & 0x7f ;
    cll.arr[2] = '+' ;
    cll.arr[cll_len-1] = '+' ;

    movep ( line , col , "INSERT TAB1, I3 = %d" , i3 ) ;

	EXEC SQL 	INSERT TAB1
	SET
		K0 = :k0 , K1 = :k1 ,
		I1 = :i1 , I2 = :i2 , C1 = :c1 , C2 = :c2 ,
		I3 = :i3 , CLLEN = :cll_len , CF0 = :c6 , CLB = :cll ;

	/* BI_16 = 'aaaaa', BI_201 = "a" ; */

    /*
    EXEC SQL
      INSERT TAB1
      VALUES ( :k0 , :k1 , :i1 , :i2 , :c1 , :c2 , :i3 , :cll_len , :c6 , :cll ) ;
	VALUES ( :k1 , ( :k1 * 100 ) + 1  , ( :k1 MOD 10 ) + 1,
	    'Name_i' || chr (:k1) ,
	    'Name.i' || chr ( :k1 DIV 10 ) ,
	    ( :k1 DIV 10 ) - 1 , :cll_len , :cll ) ;
*/
    CE ("INSERT TAB1",0) ;

    if ( SQLC == 0 )
	check_long_raw ( "INSERT TAB1" ,  k1  , k1 , -1  , -1 )  ;

    if ( rand () % 4 )
        commit () ;
    else
	rollback () ;

}
/*------------------------------------------------------------------------*/

void update_tab1_lr ()
{
    i2 = rand () % rows ;
    i1 = rand () % rows ;
    sprintf ( c2 , "%dtab1_lr%d" , i2 , ( i1 + i2 ) % 100 ) ;

    movep ( line , col , "UPDATE long raws ... BETWEEN" , k1 ) ;

    ii = i1 + 20 ;

    cll.len = rand () % maxlongraw + 4 ;
    cll_len = cll.len ;
    memset ( cll.arr , '0' + ( i1 % 10 ) , cll.len ) ;
    cll.arr[0] = ( cll.len >> 8 ) & 0x7f  ;
    cll.arr[1] = cll.len & 0x7f ;
    cll.arr[2] = '+' ;
    cll.arr[cll_len-1] = '+' ;

    do
    {
	EXEC SQL
	  UPDATE TAB1
	  SET I2 = :i2 , C2 = :c2 , CLLEN = :cll_len , CLB = :cll
	  WHERE I1 = :i1 ;

	if ( SQLC != -7012 )
	{
	    CE ( "UPDATE long raws ... BETWEEN" , 0 ) ;
	}
    }		while ( rollberr (1) ) ;

    if ( SQLC != 100 && SQLC != -7012 )
    {
	prot ( "UPDATE long raws ... BETWEEN, sqlcode = %d\n" , SQLC ) ;
	prot ( "UPDATE long raws ... BETWEEN, count   = %d\n" , sqlca.sqlerrd[2] ) ;
	if ( SQLC == 0 && sqlca.sqlerrd[2] > 1 )
	{
	    check_mark () ;
	    DE ( "UPDATE long raws, too many" , 1 ) ;
	}
    }

    if ( SQLC == 0 )
    {
	if ( rand () % 4 )
	    commit () ;
	else
	    rollback () ;
    }
    else
	rollback () ;

    check_long_raw ( "UPDATE long raws ... BETWEEN" , -1 , -1 , i1 , i1 )  ;
}

/*------------------------------------------------------------------------*/

void update_tab1 ()
{
    k1 = rand () % rows ;
    i2 = rand () % rows ;
    i1 = rand () % rows ;
    sprintf ( c2 , "%dtab1_ut%d" , i2 , ( i1 + i2 ) % 100 ) ;

    movep ( line , col , "UPDATE TAB1" , k1 ) ;

    do
    {
	EXEC SQL
	  UPDATE TAB1
	  SET I2 = :i2 , C2 = :c2
	  WHERE K1 = :k1 ;

	CE ( "UPDATE TAB1" , 0 ) ;
    }		while ( rollberr (1) ) ;

    if ( rand () % 8 )
	commit () ;
    else
	rollback () ;

}

/*------------------------------------------------------------------------*/

void update_tab1_between ()
{
    i2 = rand () % rows ;
    i1 = rand () % rows ;
    sprintf ( c2 , "%dtab1_ut%d" , i2 , ( i1 + i2 ) % 100 ) ;

    movep ( line , col , "UPDATE TAB1 ... BETWEEN" , k1 ) ;

    ii = i1 + 20 ;

    do
    {
		EXEC SQL
			UPDATE TAB1
			SET I2 = :i2 , C2 = :c2
			WHERE I1 BETWEEN :i1 AND :ii ;

		CE ( "UPDATE TAB1 ... BETWEEN" , 0 ) ;
    } while ( rollberr (1) ) ;

    if ( ( SQLC == 0 ) && ( rand () % 4 ) )
		commit () ;
    else
		rollback () ;

    check_long_raw ( "UPDATE TAB1 ... BETWEEN" ,  -1 , -1  , i1 , ii )  ;

}

/*------------------------------------------------------------------------*/

void update_tab1_key ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int	kplus ;
	EXEC SQL END DECLARE SECTION ;

    k1 = rand () % rows ;
    kplus = rand () % rows ;

    movep ( line , col , "UPDATE TAB1 KEY" , k1 ) ;

    do
    {
		EXEC SQL
			UPDATE TAB1
			SET K1 = :kplus
			WHERE K1 = :k1 ;

		CE ( "UPDATE TAB1 KEY" , 0 ) ;
    } while ( rollberr (1) ) ;

    if ( ! SQLC )
		commit () ;
    else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void check_long_raw (c,k1,k2,i1,i2)
char	*c ;
int	k1 ;
int	k2 ;
int	i1 ;
int	i2 ;
{
    EXEC SQL BEGIN DECLARE SECTION ;
    int	kk1 ;
    int	kk2 ;
    int	ii1 ;
    int	ii2 ;
    EXEC SQL END DECLARE SECTION ;

    if ( check_longs == 0 ) return ;

    movep (line,col,"CHECK long raw >%s<",c) ;

    cll.len = MAXLONGRAW ;

    if ( k1 >= 0 )
    {
		kk1 = k1 ;
		if ( k1 == k2 )
		{
			EXEC SQL
				SELECT K1 , CLLEN , CLB
				FROM superu.TAB1
				WHERE K1 = :kk1 WITH LOCK ISOLATION LEVEL 1 ;
		}
		else
		{
			kk2 = k2 ;
			EXEC SQL
				SELECT K1 , CLLEN , CLB
				FROM superu.TAB1
				WHERE K1 BETWEEN :kk1 AND :kk2 WITH LOCK ISOLATION LEVEL 1 ;
		}
		SE ("SELECT CLLEN , CLB FROM TAB1, K1 =" ,0) ;
    }
    else
    {
		ii1 = i1 ;
		ii2 = i2 ;

		EXEC SQL
			SELECT K1 , CLLEN , CLB
			FROM superu.TAB1
			WHERE I1 BETWEEN :ii1 AND :ii2 WITH LOCK ISOLATION LEVEL 1 ;

		SE ("SELECT CLLEN , CLB FROM TAB1, BETWEEN ..." ,0) ;
    }

    while ( SQLC == 0 )
    {

		cll.len = MAXLONGRAW ;

		EXEC SQL
			FETCH INTO :kk1 , :cllen :icllen , :cll  :icll ;

		if ( SQLC == 100 )
			return ;

		if ( SQLC == 0 && icllen == 0 )
		{
			if ( cll.len != cllen )
			{
				check_mark () ;
				prot ( "=== %s ===\n" 		    , c ) ;
				prot ( "Illegal length : k1 = %d\n" , kk1 ) ;
				prot ( "cll.len             = %d\n" , cll.len ) ;
				prot ( "cllen               = %d\n" , cllen ) ;
				if ( DumpOnLongCheck )
				{
					print_f ("** calling sqldump **") ;
					Sqldump () ;
					exit ( 1 ) ;
				}
			}
			else if  ( cllen > 1000 )
			{
				int	i ;

				if ( cll.arr [2] != cll.arr[cllen-1] )
				{
					check_mark () ;
					prot ( "=== %s ===\n" 		    , c ) ;
					prot ( "Illegal start/endmark of long raw : k1 = %d\n" , kk1 ) ;
					if ( DumpOnLongCheck )
					{
						print_f ("** calling sqldump **") ;
						Sqldump () ;
						exit ( 1 ) ;
					}
				}

				for ( i = 3 ; i < cllen - 2 ; i++ )
				{
					if ( cll.arr[3] != cll.arr[i] )
					{
						check_mark () ;
						prot ( "=== %s ===\n" 		    , c ) ;
						prot ( "Illegal char in long raw : k1 = %d\n" , kk1 ) ;
						if ( DumpOnLongCheck )
						{
							print_f ("** calling sqldump **") ;
							Sqldump () ;
							exit ( 1 ) ;
						}
					}
				}
			}
		}
    }
}
/*------------------------------------------------------------------------*/

void insert_tab3 ()
{
    k3 = rand () % rows ;
    if ( ( k3 % 3 ) == 1 ) k3 /= 10 ;
    i5 = rand () % 10 ;
    sprintf ( c4 , "%dttt%d" , k3 , ( k3 + i5 ) % 100 ) ;
    memset ( c5 , 'x' , sizeof(c5) ) ;
    memcpy ( c5 , c4 , strlen(c4) ) ;
    c5 [ sizeof (c5) - 1 ] = 0 ;

    movep ( line , col , "INSERT TAB3 , K3 = %d" , k3 ) ;

    do
    {
	EXEC SQL
	  INSERT TAB3 VALUES ( :k3 , :i5 , :c4 , :c5 ) ;

	CE ("INSERT TAB3",0) ;

    }		while ( rollberr (1) ) ;

    if ( ! SQLC )
	commit () ;
    else
	rollback () ;

}

/*------------------------------------------------------------------------*/

void insert_tab3j_1 ()
{
    k3 = rand () % rows ;
    if ( ( k3 % 3 ) == 1 ) k3 /= 10 ;
    i5 = rand () % 10 ;

	if ( (rand() % 3) == 0 )
		sprintf ( c4 , "itab%d" , ( k3 + i5 ) % 100 ) ;
	else
		sprintf ( c4 , "tab%d" , ( k3 + i5 ) % 100 ) ;

    memset ( c5 , 'x' , sizeof(c5) ) ;
    memcpy ( c5 , c4 , strlen(c4) ) ;
    c5 [ sizeof (c5) - 1 ] = 0 ;

    movep ( line , col , "INSERT TAB3J_1 , K3 = %d" , k3 ) ;

    do
    {
		EXEC SQL
			INSERT TAB3J_1 VALUES ( :k3 , :i5 , :c4 , :c5 ) ;

		CE ("INSERT TAB3J_",0) ;

    }		while ( rollberr (1) ) ;

	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void insert_tab3j_2 ()
{
    k3 = rand () % rows ;
    if ( ( k3 % 3 ) == 1 ) k3 /= 10 ;
    i5 = rand () % 10 ;

	if ( (rand () % 3) != 0 )
		sprintf ( c4 , "itab%d" , ( k3 + i5 ) % 100 ) ;
	else
		sprintf ( c4 , "tab%d" , ( k3 + i5 ) % 100 ) ;

    memset ( c5 , 'x' , sizeof(c5) ) ;
    memcpy ( c5 , c4 , strlen(c4) ) ;
    c5 [ sizeof (c5) - 1 ] = 0 ;

    movep ( line , col , "INSERT TAB3J_2 , K3 = %d" , k3 ) ;

    do
    {
	EXEC SQL
	  INSERT TAB3J_2 VALUES ( :k3 , :i5 , :c4 , :c5 ) ;

	CE ("INSERT TAB3",0) ;

    }		while ( rollberr (1) ) ;


	if ( rand () % 4 )
		commit () ;
	else
		rollback () ;

}

/*------------------------------------------------------------------------*/

void count_tab1 ()
{
    movep (line,col,"SELECT COUNT(*) FROM TAB1",0) ;

    do
    {
	EXEC SQL
	  SELECT COUNT (*)
	  FROM TAB1 ;

	CE ("SELECT COUNT(*) FROM TAB1",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
      FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB1, cnt = %d",cnt) ;

    sleep (1) ;

    prot ( "SELECT COUNT(*) FROM TAB1, cnt = %d\n" , cnt ) ;

    CE ("FETCH COUNT(*) TAB1",0) ;

    commit () ;
}

/*------------------------------------------------------------------------*/

void delete_tab3 ()
{

    movep (line,col,"SELECT COUNT(*) FROM TAB3",0) ;

    do
    {
	EXEC SQL
	  SELECT COUNT (*)
	  FROM TAB3 ;

	CE ("SELECT COUNT(*) FROM TAB3",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
      FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB3, cnt = %d",cnt) ;
    sleep (1) ;

    CE ("FETCH COUNT(*) TAB3",0) ;

    if ( cnt > 50 )
    {
	movep ( line , col , "DELETE TAB3 WHERE ... SELECT" , "" ) ;
	do
	{
	    EXEC SQL
	      DELETE TAB3
	      WHERE I6 >
	      (SELECT AVG (I6)
	      FROM TAB3) ;

	    CE ("DELETE TAB3 WHERE ... SELECT",0) ;
	}			while ( rollberr (1) ) ;

	if ( ! SQLC )
	    commit () ;
	else
	    rollback () ;

    }
}

/*------------------------------------------------------------------------*/

void delete_tab3_key ()
{

    i5 = rand () % rows ;

    movep (line,col,"SELECT COUNT(*) FROM TAB3",0) ;

    do
    {
		EXEC SQL
			SELECT COUNT (*)
			FROM TAB3 ;

		CE ("SELECT COUNT(*) FROM TAB3",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
      FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB3, cnt = %d",cnt) ;
    sleep (1) ;

    CE ("FETCH COUNT(*) TAB3",0) ;

    if ( cnt > 50 )
    {
	movep ( line , col , "DELETE RANGE TAB3, KEY " , "" ) ;
	do
	{
	    EXEC SQL
	      DELETE TAB3 WHERE I5 = :i5 ;

	    CE ("DELETE RANGE TAB3 ... SELECT",0) ;
	}			while ( rollberr (1) ) ;

	if ( ! SQLC )
	    commit () ;
	else
	    rollback () ;

    }
}

/*------------------------------------------------------------------------*/

void delete_tab3j_1 ()
{

    movep (line,col,"SELECT COUNT(*) FROM TAB3J_1",0) ;

    do
    {
		EXEC SQL
			SELECT COUNT (*), AVG (I6)
			FROM TAB3J_1 ;

		CE ("SELECT COUNT(*) FROM TAB3J_1",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
		FETCH INTO :cnt, :avg ;

    CE ("FETCH COUNT(*) TAB3J_1",0) ;

    if ( cnt > 50 )
    {
		movep ( line , col , "DELETE TAB3 WHERE ..." , "" ) ;
		do
		{
			EXEC SQL
				DELETE TAB3J_1
				WHERE I6 > ( :avg / 10 ) ;

			CE ("DELETE TAB3J_1 WHERE ... ",0) ;
		}			while ( rollberr (1) ) ;

		if ( rand () % 4 )
			commit () ;
		else
			rollback () ;
    }
}

/*------------------------------------------------------------------------*/

void delete_tab3j_2 ()
{

    movep (line,col,"SELECT COUNT(*) FROM TAB3",0) ;

    do
    {
		EXEC SQL
			SELECT COUNT (*), AVG (I6)
			FROM TAB3J_2 ;

		CE ("SELECT COUNT(*) FROM TAB3J_2",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
		FETCH INTO :cnt, :avg ;

    CE ("FETCH COUNT(*) TAB3J_2",0) ;

    if ( cnt > 50 )
    {
		movep ( line , col , "DELETE TAB3J_2 WHERE ... " , "" ) ;
		do
		{
			EXEC SQL
				DELETE TAB3J_2
				WHERE I6 > ( :avg / 10 ) ;

			CE ("DELETE TAB3J_2 WHERE ... ",0) ;
		}			while ( rollberr (1) ) ;

		if ( rand () % 4 )
			commit () ;
		else
			rollback () ;
    }
}

/*------------------------------------------------------------------------*/

void select_and_check_tab1sl  ()
{
    int loclen ;
    char loclong [100001] ;

    loclong [100000] = (char) 0 ;

    nrll = rand () % 20 ;

    do
    {
  	movep ( line ,col , "====== SELECT TAB1SL, nr = %d" , nrll ) ;

        EXEC SQL
	    SELECT lnll , clll
            FROM   tab1sl
            WHERE  nrll = :nrll  WITH LOCK ISOLATION LEVEL 1 ;

        CE ("SELECT TAB1SL" ,0) ;

        if ( SQLC == 0 )
        {
            scl.len = 100000 ;

	    EXEC SQL FETCH INTO :lnll , :scl ;

            CE ("FETCH TAB1SL" ,0) ;

            /* In error situations no 0 delimiter is returned by DB. */
	    /* So first copy to local array, then perform strlen()  */
            memcpy ( loclong , scl.arr , 100000 ) ;
	    loclen = strlen ( scl.arr ) ;

	    if ( loclen != lnll )
            {
                prot ( "=== Longlong Table TAB1SL ===\n"             ) ;
                prot ( "Illegal length : nr = %d\n" , nrll ) ;
                prot ( "stored length       = %d\n" , lnll ) ;
                prot ( "strlen (result)     = %d\n" , loclen   ) ;
            }

	}

    } while ( rollberr (1) ) ;

}

/*------------------------------------------------------------------------*/

void update_tab1sl  ()
{

    int i ;

    nrll = rand () % 20 ;

    for ( i = 1 ; i < 10 ; i++ )
    do
    {
        movep ( line ,col , "====== UPDATE TAB1SL, nr = %d" , nrll ) ;

        lnll = 50000 + ( rand () % 6 ) * 10000 - 1 ;

        memset ( scl.arr , 's' , lnll ) ;
		scl.arr[0] = scl.arr[lnll-2] = 't' ;
        scl.arr[lnll-1]= (char) 0 ;
		scl.len = lnll = strlen ( scl.arr ) ;

        EXEC SQL
            UPDATE tab1sl
            SET CLLL = :scl , LNLL = :lnll
            WHERE  nrll = :nrll ;

        CE ("UPDATE TAB1SL" ,0) ;

    } while ( rollberr (1) ) ;

    if ( rand () % 2 == 0 )
		EXEC SQL COMMIT ;
    else
		EXEC SQL ROLLBACK ;

}

/*------------------------------------------------------------------------*/


void delete_range_tab3_between ()
{

    i5 = rand () % rows ;

    movep (line,col,"SELECT COUNT(*) FROM TAB3",0) ;

    do
    {
		EXEC SQL
		  SELECT COUNT (*)
		  FROM TAB3 ;

		CE ("SELECT COUNT(*) FROM TAB3",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
		FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB3, cnt = %d",cnt) ;
    sleep (1) ;

    CE ("FETCH COUNT(*) TAB3",0) ;

    if ( cnt > 50 )
    {
		movep ( line , col , "DELETE RANGE TAB3, KEY " , "" ) ;
		do
		{
			if ( rand () % 2 )
			{
				EXEC SQL
					DELETE TAB3
					WHERE I5 BETWEEN :i5 AND ( :i5 + ( :rows / 5 )  ) ;
			}
			else
			{
				EXEC SQL
					DELETE TAB3
					WHERE I5 BETWEEN ( :i5 - ( :rows / 5 ) ) AND :i5 ;
			}

			CE ("DELETE RANGE TAB3 ... BETWEEN",0) ;

		} while ( rollberr (1) ) ;

		if ( ! SQLC && ( rand () % 2 ) )
			commit () ;
		else
			rollback () ;
    }
}

/*------------------------------------------------------------------------*/

void update_tabv1 ()
{
    nr = rand () % rows ;

    movep (line,col,"SELECT TAB1 ... WHERE ROWNO <= 1" , "" ) ;

    do
    {
		EXEC SQL
			SELECT K1 , I3 , CLLEN , CLB
			INTO :k1 , :i3 , :cll_len :cll_len_i , :cll :icll
			FROM TAB1
			WHERE K0 = :k0 AND K1 > :nr AND ROWNO <= 1 ;

		if ( SQLC == -6000 )
		{
			rollback () ;
			return ;
		}

		CE ( "SELECT TAB1 ... WHERE K1 > :nr AND ROWNO <= 1" , 0 ) ;
    }	while ( rollberr (0) ) ;


    if ( SQLC == 0 )
    {
		i1 = rand () % rows ;

		movep (line,col,"UPDATE TABV1" , "" ) ;

		do
		{

			check_long_raw ( "before UPDATE TABV1" ,
				i3 * 10 , i3 * 10 + 10 , -1 , -1 ) ;

			EXEC SQL
				UPDATE TABV1
				SET I1 = :i1
				WHERE I3 = :i3 ;

				/*
				if ( SQLC == 600 )
				{
				print_f ("calling sqldump") ;
				Sqldump () ;
				exit (1) ;
				}
				*/

			CE ("UPDATE VIEW TABV1",0);
		}		while ( rollberr (3) ) ;

		commit () ;

		check_long_raw ( "after UPDATE TABV1",i3*10,i3*10+10,-1,-1);

    }
    else
		CE ("SELECT TAB1 ... WHERE ROWNO <= 1",0);

}

/*------------------------------------------------------------------------*/

void update_tabv1_2 ()
{
    movep (line,col,"SELECT FROM TABV1 WHERE ... SELECT FROM TABV1","") ;

    do
    {
		EXEC SQL
			SELECT K1 , I3
			FROM TABV1
			WHERE K1 =
			( SELECT MIN (K1)
			FROM TABV1 WHERE K1 > :nr ) ;

		if ( SQLC == -6000 )
        {
			rollback () ;
			return ;
		}

		CE ("SELECT FROM TABV1 WHERE ..." , 0 ) ;
    }		while ( rollberr (1) ) ;

    if ( SQLC == 0 )
    {
		EXEC SQL
			FETCH INTO :k1 , :i3 ;

		i1 = ( k1 + i3 ) % rows ;

		movep (line,col,"UPDATE TABV1" , 0 ) ;

		do
		{
			EXEC SQL
				UPDATE TABV1
				SET I1 = :i1 WHERE I3 = :i3 ;

			CE ("UPDATE VIEW TABV1",0);
		}		while ( rollberr (3) ) ;

		commit () ;

		check_long_raw ( "UPDATE VIEW TABV1",-1,-1, i1 , i1 ) ;
    }
}

/*------------------------------------------------------------------------*/

void mass_upd_tab1 ()
{
    int     table_lock ;
    int     ergeb1_open = 0 ;
    int     ergeb2_open = 0 ;


    nr = rand () % rows ;

    table_lock = rand () % 2 ;

    movep (line,col,"SELECT ERGEB1 FROM TABV1" , "" ) ;

    do
    {
		if ( ergeb1_open )
		{
			do
			{
				EXEC SQL
					CLOSE ERGEB1;

				if ( SQLC == -8 )
					DE ( "CLOSE ERGEB1" , 1 ) ;

			} while ( rollberr (0) ) ;

			ergeb1_open = 0 ;

			if ( SQLC != -4000 )
				CE ( "CLOSE ERGEB1" , 0 ) ;
		}

		EXEC SQL
			SELECT ERGEB1 ( K1 , I1 , I2 , I3 , C1 )
			FROM TABV1
			WHERE ( ( I1 + I2 ) / 4 ) > :nr ;

		CE ( "SELECT ERGEB1 FROM TABV1" , 0 ) ;
    } while ( rollberr (1) ) ;

    commit () ;

    ergeb1_open = 1 ;

again :         /* pfui deibel */
    rolled_back = 0 ;

    movep (line,col,"SELECT ERGEB2 FROM ERGEB1" , "" ) ;
    do
    {

		do  /*sure is sure */
		{
			EXEC SQL
				CLOSE ERGEB2;

			if ( SQLC == -8 )
				DE ( "CLOSE ERGEB2" , 1 ) ;

		}
		while ( rollberr (0) ) ;

		if ( SQLC != -4000 )
			CE ( "CLOSE ERGEB2" , 0 ) ;

		EXEC SQL
			SELECT  ERGEB2 ( K1 , I1 , I2 , I3 )
			FROM ERGEB1
			ORDER BY I1 ;

		CE ( "SELECT ERGEB2 FROM ERGEB1" , 0 ) ;
    } while ( rollberr (0) ) ;

    commit () ;

    ergeb2_open = 1 ;

    movep (line,col,"FETCH ERGEB1 UPDATE TABV1 , ERR = %d" , SQLC ) ;

    if ( table_lock || supers == 1 )
    {
		movep (line,col,"LOCK TABLE TAB1 IN EXCLUSIVE MODE" , 0 ) ;

		do
		{
			EXEC SQL
				LOCK TABLE TAB1 IN EXCLUSIVE MODE ;

			CE ("LOCK TABLE TAB1 IN EXCLUSIVE MODE" , 0 ) ;

			if ( SQLC == 600 )
				goto again ;

		} while ( rollberr (1) && ( rolled_back == 0 ) ) ;

		if ( rolled_back )
			goto again ;
    }


    while ( SQLC == 0 )
    {
		do
		{
			EXEC SQL
				FETCH ERGEB2 INTO :k1 , :i1 , :i2 , :i3 ;

			CE ( "FETCH ERGEB2" , 0 ) ;

		} while ( rollberr (0) ) ;

		if ( SQLC == 0 )
		{
			movep (line,col,"Massen-UPDATE TAB1 , K1 = %d" , k1 ) ;

			do
			{
				EXEC SQL
					UPDATE TAB1 SET I1 = :i2 , I2 = :i1
					KEY K0 = :k0 , K1 = :k1 ;

				CE ("Massen-UPDATE TAB1",0);

				if ( SQLC == 600 ) goto again ;

			} while ( rollberr (1) && ( rolled_back == 0 ) ) ;

			if ( rolled_back )
				goto again ;

			if ( ( SQLC == 100 ) || ( SQLC == 200 ) )
				SQLC = 0 ;
		}

    }

    if ( rand () % 3 == 0 )
    {
		movep (line,col,"Massen-UPDATE TAB1 , ROLLBACK (ok) " , 0 ) ;
		rollback () ;
    }
    else
    {
		commit () ;
    }

    do
    {
		EXEC SQL
			CLOSE ERGEB1 ;

		if ( SQLC == -8 )
			DE ( "CLOSE ERGEB1" , 1 ) ;

		if ( SQLC != -4000 )
			DE ( "CLOSE ERGEB1" , 0 ) ;

    } while ( rollberr (0) ) ;

    ergeb1_open = 0 ;

    do
    {
		EXEC SQL
			CLOSE ERGEB2 ;

		if ( SQLC == -8 )
			DE ( "CLOSE ERGEB2" , 1 ) ;

		if ( SQLC != -4000 )
			CE ( "CLOSE ERGEB2" , 0 ) ;

    } while ( rollberr (0) ) ;

    ergeb2_open = 0 ;

    check_long_raw ( "Massen Update TAB1" , -1,-1 , 1 , rows ) ;
}


/*------------------------------------------------------------------------*/

void delete_init_tab2 ()
{
    movep ( line , col , "SELECT ERGEBDEL1 (*) FROM TAB1 " , 0 ) ;

    do
    {
		EXEC SQL
			SELECT ERGEBDEL1 (*)
			FROM TAB1 FOR REUSE ;

		CE ( "SELECT ERGEBDEL1 (*) FROM TAB1 " , 0 ) ;

    }		while ( rollberr (1) ) ;

    commit () ;

    movep ( line , col , "SELECT ERGEBDEL (*) FROM TAB2 " , "" ) ;
    do
    {
		EXEC SQL
			SELECT ERGEBDEL (*)
			FROM TAB2 FOR REUSE ;

		CE ( "SELECT ERGEBDEL (*) FROM TAB2" , 0 ) ;
    }		while ( rollberr (1) ) ;

    commit () ;

again :

    rolled_back = 0 ;

    movep (line,col,"SELECT COUNT(*) FROM TAB2",0) ;

    do
    {
		EXEC SQL
			SELECT COUNT (*)
			FROM TAB2 ;

		CE ("SELECT COUNT(*) FROM TAB3",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
		FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB2, cnt = %d",cnt) ;

    CE ("FETCH COUNT(*) TAB2",0) ;

    prot ( "SELECT COUNT(*) FROM TAB2, cnt = %d\n" , cnt ) ;

    movep (line,col,"DELETE UNQ. TAB2" , "" ) ;

    do
    {
		EXEC SQL
			DELETE TAB2 ;

		CE ("DELETE UNQ. TAB2",0);
    } while ( rollberr (1) ) ;

    if ( ( SQLC == 350 ) || ( rand () % 2 ) )
    {
		CE ("DELETE UNQ. TAB2",0);

		rollback () ;

		CE ("ROLLBACK DELETE UNQ. TAB2",0);

		EXEC SQL
			CLOSE ERGEBDEL ;

		EXEC SQL
			CLOSE ERGEBDEL1 ;

		return ;
    }
    else if ( SQLC )
    {
		CE ("DELETE UNQ. TAB2",1);
    }

    movep ( line , col , "INSERT TAB2 ... SELECT * FROM ERGEBDEL" , "" ) ;

    do
    {
		EXEC SQL
			INSERT TAB2
			SELECT *  FROM ERGEBDEL ;

		CE ("INSERT TAB2 SELECT * FROM ERGEBDEL",0) ;

		prot ( "INSERT TAB2 SELECT * FROM ERGEBDEL, 600, goto again\n" , 0 ) ;

		if ( SQLC == 600 ) goto again ;

    } while ( rollberr (1) && ( rolled_back == 0 ) ) ;

    prot ( "INSERT TAB2 SELECT * FROM ERGEBDEL, rolled back, goto again\n" , 0 ) ;

    if ( rolled_back )
		goto again ;

    if ( SQLC )
    {
		CE ("INSERT TAB2 ... SELECT * FROM ERGEBDEL",0) ;
		rollback () ;
		prot ("INSERT TAB2 ... SELECT * FROM ERGEBDEL : ROLLBACK\n",0) ;
		return ;
    }

    commit () ;

    EXEC SQL
		CLOSE ERGEBDEL ;

    movep ( line , col , "INSERT TAB1 ... SELECT * FROM ERGEBDEL1", "" ) ;

    do
    {
		EXEC SQL
			INSERT TAB1
			SELECT *  FROM ERGEBDEL1 ;

		CE ("INSERT TAB1 ... SELECT * FROM ERGEBDEL1",0) ;

    } while ( rollberr (1) ) ;


    EXEC SQL
		CLOSE ERGEBDEL1 ;

    commit () ;
}

/*------------------------------------------------------------------------*/

void delete_rollback_tab4 ()
{

    movep (line,col,"DELETE UNQ. TAB4" , "" ) ;

    do
    {
		EXEC SQL DELETE TAB4 ;
		CE ("DELETE UNQ. TAB4",0);
    }
	while ( rollberr (2) ) ;

    prot ("DELETE UNQ. TAB4, ERR = %d\n",SQLC);

    sleep ( 5 ) ;

    if ( SQLC != 350 )
    {
		CE ("DELETE UNQ. TAB4",1);
    }

    movep (line,col,"DELETE UNQ. TAB4 : Rollback (ok)" , "" ) ;

    rollback () ;

    prot  ( "DELETE UNQ. TAB4 (Rollback) : %d\n" , SQLC ) ;
    CE ("DELETE UNQ. TAB4 (Rollback)",1);

    EXEC SQL
		CLOSE ERGEBDEL ;

    commit () ;

    movep (line,col,"SELECT COUNT(*) FROM TAB4",0) ;

    do
    {
		EXEC SQL
			SELECT COUNT (*)
			FROM TAB4 ;

		CE ("SELECT COUNT(*) FROM TAB4",0) ;
    }		while ( rollberr (1) ) ;

    EXEC SQL
		FETCH INTO :cnt ;

    movep (line,col,"SELECT COUNT(*) FROM TAB4, cnt = %d",cnt) ;

    if ( cnt == 0 )
		DE ( "SELECT COUNT(*) FROM TAB4 = 0\n" , 1 )  ;
}

/*------------------------------------------------------------------------*/

void DebugOmsOn ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long iOut ;
	EXEC SQL END DECLARE SECTION ;

	EXEC SQL DBPROC CHL_DEBUG ( 1 , :iOut ) ;
}
/*------------------------------------------------------------------------*/
void    diagnose_analyze_on ()
{
	movep (line,col,"DIAGNOSE ANALYZE ON" , "" ) ;

    do
    {
		EXEC SQL DIAGNOSE ANALYZE ON  ;
		CE ("DIAGNOSE ANALYZE ON",0);
    }
	while ( rollberr (1) ) ;
	commit () ;
}
/*------------------------------------------------------------------------*/
void    diagnose_analyze_count_on ()
{
	movep (line,col,"DIAGNOSE ANALYZE COUNT ON" , "" ) ;

    do
    {
		EXEC SQL DIAGNOSE ANALYZE COUNT ON  ;
		CE ("DIAGNOSE ANALYZE COUNT ON",0);
    }
	while ( rollberr (1) ) ;
	commit () ;
}
/*------------------------------------------------------------------------*/
void    diagnose_analyze_count_off ()
{
	movep (line,col,"DIAGNOSE ANALYZE COUNT OFF" , "" ) ;

    do
    {
		EXEC SQL DIAGNOSE ANALYZE COUNT OFF  ;
		CE ("DIAGNOSE ANALYZE COUNT OFF",0);
    }
	while ( rollberr (1) ) ;
	commit () ;
}
/*------------------------------------------------------------------------*/
void    diagnose_analyze_off ()
{
	movep (line,col,"DIAGNOSE ANALYZE OFF" , "" ) ;

    do
    {
		/* PTS 1106220 */
		EXEC SQL DIAGNOSE ANALYZE OFF ;
		CE ("DIAGNOSE ANALYZE OFF",0);
    }
	while ( rollberr (1) ) ;
	commit () ;
}
/*------------------------------------------------------------------------*/

void    diagnose_analyze_clear (int clAll)
{
	int clearKind ;
	char *cd[3] = { "DATA","COMMAND","ALL" } ;
	char clearString [100] ;

	if ( clAll == 0 )
		clearKind = rand() % 3 ;
	else
		clearKind = 2 ;

	sprintf ( clearString , "DIAGNOSE ANALYZE CLEAR %s", cd [clearKind] ) ;

	movep (line,col,clearString , "" ) ;

    do
    {
		switch (clearKind)
		{
		case 0:
			EXEC SQL DIAGNOSE ANALYZE CLEAR DATA ;
			break ;
		case 1:
			EXEC SQL DIAGNOSE ANALYZE CLEAR COMMAND ;
			break ;
		case 2:
			EXEC SQL DIAGNOSE ANALYZE CLEAR ALL ;
			break ;
		}
		CE (clearString,0);
    }
	while ( rollberr (1) ) ;
	prot ("%s\n",clearString);
	commit () ;
}

void protDiagnoseFiles ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int	dCnt ;
	EXEC SQL END DECLARE SECTION ;

	EXEC SQL SELECT COUNT (*) INTO :dCnt FROM SYSMONITOR ;
	prot ("SELECT COUNT (*) FROM SYSMONITOR: %d\n",dCnt);

	EXEC SQL SELECT COUNT (*) INTO :dCnt FROM SYSMONDATA ;
	prot ("SELECT COUNT (*) FROM SYSMONDATA: %d\n",dCnt);

	EXEC SQL SELECT COUNT (*) INTO :dCnt FROM SYSPARSEID ;
	prot ("SELECT COUNT (*) FROM SYSPARSEID: %d\n",dCnt);

	EXEC SQL SELECT COUNT (*) INTO :dCnt FROM SYSDATA_ANALYZE  ;
	prot ("SELECT COUNT (*) FROM SYSDATA_ANALYZE: %d\n",dCnt);

	EXEC SQL SELECT COUNT (*) INTO :dCnt FROM SYSCMD_ANALYZE  ;
	prot ("SELECT COUNT (*) FROM SYSCMD_ANALYZE: %d\n",dCnt);

	commit() ;
}

/*------------------------------------------------------------------------*/
/*========================================================================*/
/*                              O M S                                     */
/*========================================================================*/


/*------------------------------------------------------------------------*/

int CreateList (int AlwaysCommit )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long cre_elements ;
	EXEC SQL END DECLARE SECTION ;

    movep ( line , col , "DBPROC: CREATELIST", "" ) ;

	cre_elements = 3000 + ( rand () % rows )  ;
	listno = ( rand () % MaxListNo ) + 1 ;

	do
	{
		EXEC SQL DBPROC CREATELIST ( :cre_elements, 0 , :listno ) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( AlwaysCommit || ( rand () % 4 ))
			commit ();
		else
			rollback () ;
	}
	return 0;
}


/*------------------------------------------------------------------------*/

int DeleteElememtsFromList (int n)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElementsToDelete ;
	EXEC SQL END DECLARE SECTION ;

	listno = ( rand () % MaxListNo ) + 1 ;
	elements = 0 ;

	ElementsToDelete = n ? n : del_elements ;

    movep ( line , col , "DBPROC: DELETE_ELEMENT_FROM_LIST", "" ) ;
	do
	{
		EXEC SQL DBPROC DELETE_ELEMENT_FROM_LIST ( :listno , :ElementsToDelete ,
			0, :elements ) ;

		CE ("DBPROC: DELETE_ELEMENT_FROM_LIST",0) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback ()  ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
	return 0;
}


/*------------------------------------------------------------------------*/

int AddElementToList (l)
{
	listno = l ? l : ( rand () % MaxListNo ) + 1 ;

    movep ( line , col , "DBPROC: ADD_ELEMENT_TO_LIST", "" ) ;

	do
	{
		EXEC SQL DBPROC ADD_ELEMENT_TO_LIST ( :listno , :FiOidIn , :FiOidOut ) ;

		CE ("DBPROC: ADD_ELEMENT_TO_LIST",0) ;
	}
	while ( rollberr (4) ) ;

	CE ("DBPROC: ADD_ELEMENT_TO_LIST",0) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
	return 0;
}
/*------------------------------------------------------------------------*/

void TraversePartList (int LockMode)
{
	long	ElemsToRead ;
	long	i = 1 + ( rand () % 20 ) ;

	ElemsToRead = rand () % rows ;

	if ( LockMode == 1 )
		movep ( line , col , "DBPROC: TraversePartList Locked, lno = %d", i ) ;
	else
		movep ( line , col , "DBPROC: TraversePartList Unlocked, lno = %d", i ) ;

	do
	{
		TraverseList ( i , 1 , ElemsToRead , LockMode, "TRAV REL") ;

		switch ( LockMode)
		{
			case 0 :
				CE ("TraversePartList unlocked",0) ;
				break ;
			case 1:
				CE ("TraversePartList locked",0) ;
				break ;
			case 2:
				CE ("TraversePartList check lock",0) ;
				break ;
		}

	} while ( rollberr (1) ) ;

	switch ( LockMode)
	{
		case 0 :
			CE ("TraversePartList unlocked",0) ;
			break ;
		case 1:
			CE ("TraversePartList locked",0) ;
			break ;
		case 2:
			CE ("TraversePartList check lock",0) ;
			break ;
	}

	commit () ;
}

/*------------------------------------------------------------------------*/

void CheckLocksPartList (int LockMode)
{
	long	ElemsToRead ;
	long	i = 1 + ( rand () % 20 ) ;
	int		RelOids = rand () % 2;

	ElemsToRead = rand () % rows ;

	movep ( line , col , "DBPROC: CheckLocksPartList first, lno = %d", i ) ;

	do
	{
		TraverseList ( i , RelOids , ElemsToRead , 1, "TRAV REL") ;
		CE ("CheckLocksPartList first (lock)",0) ;
	} while ( rollberr (1) ) ;

	CE ("CheckLocksPartList lock",0) ;

	if ( sqlca.sqlcode == 0 )
	{
		movep ( line , col , "DBPROC: CheckLocksPartList second, lno = %d", i ) ;

		do
		{
			TraverseList ( 0 , 1 , ElemsToRead , 2, "TRAV REL") ;
			CE ("CheckLocksPartList second (check)",0) ;
		} while ( rollberr (1) ) ;

		CE ("CheckLocksPartList check",0) ;
	}

	commit () ;
}

/*------------------------------------------------------------------------*/

void CreateDummyVersion ()
{
	/* Diese Version wird lange Zeit nicht gelscht. Damit knnen ltere Objekte nicht */
	/* freigegeben werden. Auer etwas zustzlichem Platzverbrauch sollten */
	/* keine weiteren Effekte eintreten. */

	if ( DummyVersionWasCreated )
	{
		commit () ;
		movep ( line , col, "Drop Dummy Version" , 0 ) ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4 , :vrc ) ;
	    prot ( "Drop Dummy Version; sqlcode = %d\n" , SQLC ) ;
		if ( SQLC != -9205 )
			CE ("Create/Drop Dummy Version",0) ;
		commit () ;
	}

	movep ( line , col, "Open Dummy Version" , 0 ) ;
	EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString4 , :vrc ) ;
	prot ( "Open Dummy Version; sqlcode = %d\n" , SQLC ) ;
	CE ("Open Dummy Version",0) ;
	commit () ;

	if ( sqlca.sqlcode == 0 )
	{
		DummyVersionWasCreated = 1 ;
		movep ( line , col, "Close Dummy Version" , 0 ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString4 , :vrc ) ;
	    prot ( "Close Dummy Version; sqlcode = %d\n" , SQLC ) ;
		CE ("Close Dummy Version",0) ;
		commit () ;
	}
}
/*------------------------------------------------------------------------*/

void DropDummyVersion ()
{
	if ( DummyVersionWasCreated )
	{
		commit () ;
		movep ( line , col, "Drop Dummy Version" , 0 ) ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4 , :vrc ) ;
	    prot ( "Drop Dummy Version; sqlcode = %d\n" , SQLC ) ;
		if ( SQLC != -9205 )
			CE ("Drop Dummy Version",0) ;
		commit () ;
	}
}
/*------------------------------------------------------------------------*/

void CheckVersionedLocksPartList1 (int LockMode)
{
	long	ElemsToRead ;
	long	i = rand () % 20 + 1 ;
	long    ListNo = i ;
	int		RelOids = rand () % 2;
	int		sqlsumcode = 0 ;

	ElemsToRead = rand () % rows ;

	movep ( line , col, "Open Version VerString2, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString2 , :vrc ) ;
	CE ("Open Version VerString2",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	movep ( line , col , "DBPROC: CheckVersionedLocksPartList1 first, lno = %d", ListNo) ;

	/* hier tun mer mal nix */

	movep ( line , col, "Close Version VerString2, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString2 , :vrc ) ;
	CE ("Close Version VerString2",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	/* jetzt werden Objekte gesperrt */

	do
	{
		TraverseList ( i , RelOids , ElemsToRead , 1, "TRAV REL") ;
		CE ("CheckVersionedLocksPartList1 first (lock)",0) ;
	} while ( rollberr (1) ) ;

	CE ("CheckLocksPartList lock",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	if ( sqlsumcode == 0 )
	{

		/* die Version wird neu geffnet, und nun drfte immer noch nix gesperrt sein  */

		movep ( line , col, "Open Version VerString2, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString2 , :vrc ) ;
		CE ("Open Version VerString2",0) ;

		if ( sqlca.sqlcode == 0 )
		{
			movep ( line , col , "DBPROC: CheckLocksPartList second, lno = %d", i ) ;

			do
			{
				TraverseList ( 0 , 1 , ElemsToRead , 3, "TRAV REL") ;
				CE ("CheckVersionedLocksPartList1 second (check)",0) ;
			} while ( rollberr (1) ) ;

			CE ("CheckVersionedLocksPartList1 check",0) ;
		}

		/* und wieder weg mit der Version */

		movep ( line , col, "Close Version VerString2, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString2 , :vrc ) ;
		CE ("Close Version VerString2",0) ;
	}

	movep ( line , col, "Drop Version VerString2, lno = %d" , ListNo ) ;
	commit () ;
	EXEC SQL DBPROC CHL_DROP_VERSION (:VerString2 , :vrc ) ;
	CE ("Drop Version VerString2",0) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

void CheckVersionedLocksPartList2(int LockMode)
{
	long	ElemsToRead ;
	long	i = rand () % 20 ;
	long    ListNo = i ;
	int		RelOids = rand () % 2;
	int		sqlsumcode = 0 ;

	commit () ; /* sicher ist sicher wegen -9214 */

	ElemsToRead = rand () % rows ;

	movep ( line , col, "Open Version VerString3, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString3 , :vrc ) ;
	CE ("Open Version VerString3",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	movep ( line , col , "DBPROC: CheckVersionedLocksPartList2 first, lno = %d", i ) ;

	/* jetzt werden Objekte gesperrt, aber nur in der Verision */

	do
	{
		TraverseList ( i , RelOids , ElemsToRead , 1, "TRAV REL") ;
		CE ("CheckVersionedLocksPartList2 first (lock)",0) ;
	} while ( rollberr (1) ) ;

	CE ("CheckLocksPartList lock",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	movep ( line , col, "Close Version VerString3, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString3 , :vrc ) ;
	CE ("Close Version VerString3",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	/* und nun drfte nix gesperrt sein */

	if ( sqlsumcode == 0 )
	{
		movep ( line , col , "DBPROC: CheckVersionedLocksPartList2 second, lno = %d", i ) ;

		do
		{
			TraverseList ( 0 , 1 , ElemsToRead , 3, "TRAV REL") ;
			CE ("CheckVersionedLocksPartList2 second (check)",0) ;
		} while ( rollberr (1) ) ;

		CE ("CheckLocksPartList check",0) ;
	}

	/* und weg mit der Verision */

	movep ( line , col, "Drop Version VerString3, lno = %d" , ListNo ) ;
	commit () ;
	EXEC SQL DBPROC CHL_DROP_VERSION (:VerString3 , :vrc ) ;
	CE ("Drop Version VerString3",0) ;

	commit () ;
}

/*------------------------------------------------------------------------*/

long TraverseList (/*long lno ,		 List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse */
				   int	RelOids ,	/* 1: Release OIDs after reading */
				   long Ntt,		/* no of elements to traverse. 0: traverse all  */
				   int	LockMode ,  /* 1: lock OIDs when reading 2: Check for locks */
				   char *TravString )
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int		ReleaseOids ;
    long	NoToTraverse ;
	int		OidsLockMode ;
	long	sum ;
	EXEC SQL END DECLARE SECTION ;

	sum = 0 ;
	ReleaseOids = RelOids ;
	NoToTraverse = Ntt ;
	elements = 0 ;
	listno = Lno ;
	OidsLockMode = LockMode ;

	if ( Lno == 0 )
	{
		memcpy ( FiOidIn , FiOidOut , sizeof FiOidIn ) ;
		/*prot ("TRAVERSE_LIST: Lno = 0, OidIn = %s" , FiOidIn ) ;*/
	}
	else
		strcpy ( FiOidIn , "12345678" ) ; /* for Debug*/

	EXEC SQL DBPROC TRAVERSE_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :OidsLockMode, :FiOidIn , :FiOidOut ) ;

	/*prot ( "TRAVERSE_LIST: OidOut = %s" , FiOidOut ) ;*/

	return sum ;
}

/*------------------------------------------------------------------------*/

long TraverseVarList (/*long lno ,		 List number (just for output protocol) */
				   long Lno,		/* List number; 0: use start OID of last traverse */
				   int	RelOids ,	/* 1: Release OIDs after reading */
				   long Ntt,		/* no of elements to traverse. 0: traverse all */
				   int	LockMode ,  /* 1: lock OIDs when reading 2: Check for locks */
				   char *TravString )
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int		ReleaseOids ;
    long	NoToTraverse ;
	int		OidsLockMode ;
	long	sum ;
	EXEC SQL END DECLARE SECTION ;

	sum = 0 ;
	ReleaseOids = RelOids ;
	NoToTraverse = Ntt ;
	elements = 0 ;
	listno = Lno ;
	OidsLockMode = LockMode ;

	if ( Lno == 0 )
	{
		memcpy ( FiOidInVar , FiOidOutVar , sizeof FiOidInVar ) ;
	}
	else
		strcpy ( FiOidInVar , "12345678" ) ; /* for Debug */

	EXEC SQL DBPROC OMS_TRAVERSE_VAROBJ_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :OidsLockMode, 1, :FiOidInVar , :FiOidOutVar ) ;

	return sum ;
}

/*------------------------------------------------------------------------*/

void ConsistentRead ()
{

	long sum1, sum2, sum3 ;
	long ListNo = rand () % 20 + 1 ;

	elements = 0 ;

	/*if ( rand () % 3 ) == 0 ) ;*/
	/*	AddElementToListInSubtrans (ListNo , (rand()%2)) ;*/

	/*
	long TraverseList :
	long Lno,		 List number; 0: use start OID of last traverse
	int	 RelOids ,	 Release OIDs after reading
	long Ntt		 no of elements to traverse. 0: traverse all
	int  ReadLocked  lock OIDs when reading.
	char *TravString  Comment in Output
	*/

	/* Read from database and release OIDs*/
    movep ( line , col , "DBPROC: Consistent Read, lno = %d, first", ListNo ) ;
	sum1 = TraverseList ( ListNo , 1 , 0 , 0 , "TRAV REL") ;
	CE ("Consistent Read, first",0) ;
    /*prot ( "Consistent read; sum1  = %d\n" , sum1 ) ;*/

	if ( sqlca.sqlcode == 0 && ( rand () % 3 ) == 0 )
		AddElementToListInSubtrans (0 , 0) ;

	/* ReleaseAll () ;*/

	if ( rand () % 100 == 0 )
		sleep ( 60 ) ; /* 1 Minute schlafen*/
	else
		sleep ( 1 ) ;

	/* Read from database and keep Oids */
	if ( sqlca.sqlcode == 0 )
	{
	    movep ( line , col , "DBPROC: Consistent Read, lno = %d, second", ListNo ) ;
		sum2 = TraverseList ( 0 , 0 , 0 , 0 ,"TRAV STO") ;
		CE ("Consistent Read, second",0) ;
		if ( SQLC == -28007 )
			prot ("Consistent Read, second: %s", sqlca.sqlerrmc ) ;

		if ( sum1 != sum2 && SQLC != -28815 )
		{
		    prot ( "Consistent read; sum1 <> sum2\n" , 0 ) ;
		    prot ( "Consistent read; sum1  = %d\n" , sum1 ) ;
		    prot ( "Consistent read; sum2  = %d\n" , sum2 ) ;
			print_f ("calling sqldump") ;
			Sqldump () ;
			exit (1) ;
		}

		if ( sqlca.sqlcode == 0 && ( rand () % 3 ) == 0 )
			AddElementToListInSubtrans (0 , 0) ;

		Sleep ( rand () % 1000 ) ;

		/* Read on local OID images and release Oids afterwards*/
		if ( sqlca.sqlcode == 0 )
		{
			movep ( line , col , "DBPROC: Consistent Read, lno = %d, last", ListNo ) ;
			sum3 = TraverseList ( 0 , 1 , 0 , 0, "TRAV LOC" ) ;
			CE ("Consistent Read, last",0) ;
			if ( SQLC == -28007 )
				prot ("Consistent Read, second: %s", sqlca.sqlerrmc ) ;

			if ( sum2 != sum3 && SQLC != -28815 )
			{
				prot ( "Consistent read; sum2 <> sum3\n" , 0 ) ;
				prot ( "Consistent read; sum2  = %d\n" , sum2 ) ;
				prot ( "Consistent read; sum3  = %d\n" , sum3 ) ;
				print_f ("calling sqldump") ;
				/*rollback () ; */
				/*return ;*/
				Sqldump () ;
				exit (1) ;
			}

		}
	}

	commit () ;

}

/*------------------------------------------------------------------------*/

void ConsistentVarRead ()
{

	long sum1, sum2, sum3 ;
	long ListNo = rand () % 20 + 1 ;

	elements = 0 ;

	/*if ( rand () % 3 ) == 0 ) ;
		AddElementToListInSubtrans (ListNo , (rand()%2)) ; */

	/*
	long TraverseVarList :
	long Lno,		 List number; 0: use start OID of last traverse
	int	 RelOids ,	 Release OIDs after reading
	long Ntt		 no of elements to traverse. 0: traverse all
	int  ReadLocked  lock OIDs when reading.
	char *TravString Comment in Output
	*/

	/* Read from database and release OIDs */
    movep ( line , col , "DBPROC: Consistent Var Read, lno = %d, first", ListNo ) ;
	sum1 = TraverseVarList ( ListNo , 1 , 0 , 0 , "TRAV REL") ;
	CE ("Consistent Var Read, first",0) ;
	if ( SQLC == -28007 )
		prot ("Consistent Var Read, second: %s", sqlca.sqlerrmc ) ;
    /*prot ( "Consistent read; sum1  = %d\n" , sum1 ) ; */

	if ( sqlca.sqlcode == 0 && ( rand () % 3 ) == 0 )
		AddVarElementToListInSubtrans (ListNo , 0) ;

	/* ReleaseAll () ; */

	if ( rand () % 100 == 0 )
		Sleep ( 60 * 1000 ) ; /* 1 Minute schlafen */
	else
		Sleep ( rand () % 1000 ) ;

	/* Read from database and keep Oids */
	if ( sqlca.sqlcode == 0 )
	{
	    movep ( line , col , "DBPROC: Consistent Var Read, lno = %d, second", ListNo ) ;
		sum2 = TraverseVarList ( 0 , 0 , 0 , 0 ,"TRAV STO") ;
		CE ("Consistent Var Read, second",0) ;
		if ( SQLC == -28007 )
			prot ("Consistent Var Read, second: %s", sqlca.sqlerrmc ) ;
		/*prot ( "Consistent read; sum2  = %d\n" , sum2 ) ; */

		if ( sum1 != sum2 && SQLC != -28815)
		{
		    prot ( "Consistent read; sum1 <> sum2\n" , 0 ) ;
		    prot ( "Consistent read; sum1  = %d\n" , sum1 ) ;
		    prot ( "Consistent read; sum2  = %d\n" , sum2 ) ;
			print_f ("calling sqldump") ;
			/*rollback () ;
			eturn ; */
			Sqldump () ;
			exit (1) ;
		}

		if ( sqlca.sqlcode == 0 && ( rand () % 3 ) == 0 )
			AddVarElementToListInSubtrans (ListNo , 0) ;

		Sleep ( rand () % 1000 ) ;

		/* Read on local OID images and release Oids afterwards */
		if ( sqlca.sqlcode == 0 )
		{
			movep ( line , col , "DBPROC: Consistent Var Read, lno = %d, last", ListNo ) ;
			sum3 = TraverseVarList ( 0 , 1 , 0 , 0, "TRAV LOC" ) ;
			CE ("Consistent Var Read, last",0) ;
			if ( SQLC == -28007 )
				prot ("Consistent Var Read, second: %s", sqlca.sqlerrmc ) ;
		    /* prot ( "Consistent read; sum3  = %d\n" , sum3 ) ; */

			if ( sum2 != sum3 && SQLC != -28815)
			{
				prot ( "Consistent read; sum2 <> sum3\n" , 0 ) ;
				prot ( "Consistent read; sum2  = %d\n" , sum2 ) ;
				prot ( "Consistent read; sum3  = %d\n" , sum3 ) ;
				print_f ("calling sqldump") ;
				/* rollback () ;
				eturn ; */
				Sqldump () ;
				exit (1) ;
			}

		}
	}

	commit () ;

}

/*------------------------------------------------------------------------*/

int AddElementToListInSubtrans (l,co)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int sTrans ;
	long rc ;
	EXEC SQL END DECLARE SECTION ;

	listno = l ;

    movep ( line , col , "DBPROC: ADD ELEMENT TO LIST in SUBTRANS", 0 ) ;

	EXEC SQL DBPROC CHL_START_SUBTRANS (:sTrans,:rc) ;
	CE ("DBPROC: START SUBTRANS",0) ;

	if ( SQLC )
		return SQLC ;

	if ( listno == 0 )
		memcpy ( FiOidIn , FiOidOut , sizeof FiOidIn ) ;
	else
		strcpy ( FiOidIn , "12345678" ) ; /* Debug*/

	EXEC SQL DBPROC ADD_ELEMENT_TO_LIST ( :listno, :FiOidIn , :FiOidOut  ) ;

	CE ("DBPROC: ADD_ELEMENT_TO_LIST in Subtrans",0) ;

	if ( SQLC )
		return SQLC ;

	if ( co )
	{
		EXEC SQL DBPROC CHL_COMMIT_SUBTRANS (-1,:rc) ;
		CE ("DBPROC: COMMIT SUBTRANS",0) ;
	}
	else
	{
		EXEC SQL DBPROC CHL_ROLLBACK_SUBTRANS (-1,:rc) ;
		CE ("DBPROC: ROLLBACK SUBTRANS",0) ;
	}
	return 0;
}

/*------------------------------------------------------------------------*/

int AddVarElementToListInSubtrans (l,co)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int sTrans ;
	long rc ;
	EXEC SQL END DECLARE SECTION ;

	listno = l ;

    movep ( line , col , "DBPROC: ADD VAR ELEMENT TO LIST in SUBTRANS", 0 ) ;

	EXEC SQL DBPROC OMS_START_SUBTRANS (:sTrans,:rc) ;
	CE ("DBPROC: START SUBTRANS",0) ;

	if ( SQLC )
		return SQLC ;

	EXEC SQL DBPROC OMS_ADD_VAROBJ ( :listno, :rc ) ;

	CE ("DBPROC: OMS_ADD_VAROBJ in Subtrans",0) ;

	if ( SQLC )
		return SQLC ;

	if ( co )
	{
		EXEC SQL DBPROC OMS_COMMIT_SUBTRANS (-1,:rc) ;
		CE ("DBPROC: COMMIT SUBTRANS",0) ;
	}
	else
	{
		EXEC SQL DBPROC OMS_ROLLBACK_SUBTRANS (-1,:rc) ;
		CE ("DBPROC: ROLLBACK SUBTRANS",0) ;
	}
	return 0;
}

/*------------------------------------------------------------------------*/

void VersionedRead ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long vrc ;
	EXEC SQL END DECLARE SECTION ;

	long sum1, sum2, sum3 ;
	long ListNo = rand () % 20 + 1 ;
	int	 sqlsumcode ;

	elements = 0 ;

	/*
	long TraverseList :
	long Lno,		List number; 0: use start OID of last traverse
	int	 RelOids ,	 Release OIDs after reading
	long Ntt		 no of elements to traverse. 0: traverse all
	int  ReadLocked  lock OIDs when reading.
	char *TravString  Comment in Output
	*/

	commit () ; /*sicher ist sicher wegen -9214*/

	sqlsumcode = 0 ;

	movep ( line , col, "Open Version VerString1, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString , :vrc ) ;
	CE ("Open Version VerString1",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	/* Read from database and release OIDs*/
    movep ( line , col , "DBPROC: Versioned Read, lno = %d, first", ListNo ) ;
	sum1 = TraverseList ( ListNo , 1 , 0 , 0 , "TRAV REL") ;
	CE ("Versioned Read, first",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	/*if ( rand () % 2 == 0 )*/
	/*	ReleaseAll () ;*/

	movep ( line, col, "Close Version VerString1, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;
	CE ("Close Version VerString1",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	if ( ( supers == 0 ) && ( ( rand () % 4) == 0 ) )
		release_connect () ;
	else
	{
		commit () ;
		Sleep ( rand () % 1000 ) ;
	}

	sqlsumcode += sqlca.sqlcode  ;

	/* Change list in same transaction but outside version */
/*
	if ( ( rand () % 4 ) == 0 )
	{
		movep ( line , col , "DBPROC: ADD_ELEMENT_TO_LIST out of Version", "" ) ;

		EXEC SQL DBPROC ADD_ELEMENT_TO_LIST ( :listno , :FiOidIn , :FiOidOut ) ;

		CE ("DBPROC: ADD_ELEMENT_TO_LIST out of Version",0) ;
	}
*/
	/* sqlsumcode += sqlca.sqlcode ;*/

	/* Read from database and keep Oids */
	if ( sqlsumcode == 0 )
	{
		movep ( line , col, "Open Version VerString1, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString , :vrc ) ;
		CE ("Open Version VerString1",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		movep ( line , col , "DBPROC: Versioned Read VerString1, lno = %d, second", ListNo ) ;
		sum2 = TraverseList ( 0 , 0 , 0 , 0 ,"TRAV STO") ;
		CE ("Versioned Read VerString1, second",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		if ( sum1 != sum2 && SQLC != -28815 )
		{
		    prot ( "Versioned read; sum1 <> sum2\n" , 0 ) ;
		    prot ( "Versioned read; sum1  = %d\n" , sum1 ) ;
		    prot ( "Versioned read; sum2  = %d\n" , sum2 ) ;
			print_f ("calling sqldump") ;
			Sqldump () ;
			exit (1) ;
		}

		movep ( line,col,"Close Version VerString1, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;
		CE ("Close Version VerString1",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		if ( ( supers == 0 ) && ( ( rand () % 4) == 0 ) )
			release_connect () ;
		else
		{
			commit () ;
			Sleep ( rand () % 1000 ) ;
		}

		sqlsumcode += sqlca.sqlcode  ;

		movep (line,col, "Open Version VerString1, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString , :vrc ) ;
		CE ("Open Version VerString1",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		/* Read on local OID images and release Oids afterwards*/
		if ( sqlsumcode == 0 )
		{
			movep ( line , col , "DBPROC: Versioned Read, lno = %d, last", ListNo ) ;
			sum3 = TraverseList ( 0 , 1 , 0 , 0, "TRAV LOC" ) ;
			CE ("Versioned Read, last",0) ;
			sqlsumcode += sqlca.sqlcode  ;

			if ( sum2 != sum3 && SQLC != -28815 )
			{
				prot ( "Versioned read; sum2 <> sum3\n" , 0 ) ;
				prot ( "Versioned read; sum2  = %d\n" , sum2 ) ;
				prot ( "Versioned read; sum3  = %d\n" , sum3 ) ;
				print_f ("calling sqldump") ;
				Sqldump () ;
				exit (1) ;
			}

		}
	}

	commit () ;

	movep ( line,col,"Close Version VerString1, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;
	CE ("Close Version VerString1",0) ;

	commit () ;

	movep ( line,col,"Drop Version VerString1, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_DROP_VERSION (:VerString , :vrc ) ;
	CE ("Drop Version VerString1",0) ;

	commit () ;

}
/*------------------------------------------------------------------------*/

int ReadIteratedList ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElIn = 0 ;
	long ElOut = 0  ;
	long rc = 0 ;
	EXEC SQL END DECLARE SECTION ;
	char lineOut [200] ;

    movep ( line , col , "DBPROC: CHL_ITER_CLIST", "" ) ;

	EXEC SQL DBPROC CHL_ITER_CLIST (:ElIn , :ElOut , :rc ) ;

	sprintf (lineOut , "CHL_ITER_CLIST : Elems = %d, sqlcode = %d" , ElOut, SQLC ) ;
	print_f ( lineOut) ;

	CE ("DBPROC: CHL_ITER_LIST", 0 ) ;

	commit () ;

	return rc ;
}

/*------------------------------------------------------------------------*/

int ReadIteratedVarList ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElIn = 0 ;
	long ElOut = 0  ;
	long rc = 0 ;
	long minlen ;
	long maxlen ;
	int  VarSumPagecount ;
	EXEC SQL END DECLARE SECTION ;
	char lineOut [200] ;

    movep ( line , col , "DBPROC: OMS_ITER_VCLIST", "" ) ;

	EXEC SQL DBPROC OMS_ITER_VCLIST (:ElIn , :ElOut , :sumVarlenObj , :minlen , :maxlen , :rc ) ;

	sprintf (lineOut , "OMS_ITER_VCLIST : Elems = %d, Sum Lengths = %ld, MinLen = %d , MaxLen = %d , sqlcode = %d" ,
		ElOut, sumVarlenObj, minlen , maxlen, SQLC ) ;

	print_f ( lineOut) ;

	CE ("DBPROC: OMS_ITER_VCLIST", 0 ) ;

    movep ( line , col , "SELECT ... FROM CLASSCONTAINERS", "" ) ;

	EXEC SQL SELECT sum (PAGECOUNT) INTO :VarSumPagecount
		FROM CLASSCONTAINERS
		WHERE CLASS_NAME = 'VarObjContainer' ;

	CE ("SELECT ... FROM CLASSCONTAINERS", 0 ) ;

	sprintf (lineOut , "OMS_ITER_VCLIST : Classcontainers: %d Pages" , VarSumPagecount ) ;
	print_f ( lineOut) ;

	commit () ;

	return rc ;
}

/*------------------------------------------------------------------------*/

int CompareSingleIterated ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long	ElIn = 0 ;
	long	ElOut = 0  ;
	long	rc = 0 ;
	int		ReleaseOids = 1 ;
    long	NoToTraverse = 0 ;
	int		OidsLockMode = 0 ;
	long	sum ;
	EXEC SQL END DECLARE SECTION ;

	char	lineOut [200] ;
	long	ElemsTotal = 0 ;
	int		EmptyLists = 0 ;

    movep ( line , col , "DBPROCs: Compare Counts (CompareSingleIterated)", "" ) ;

	EXEC SQL DBPROC CHL_ITER_CLIST (:ElIn , :ElOut , :rc ) ;

	sprintf (lineOut , "CHL_ITER_CLIST : Elems = %d, sqlcode = %d" , ElOut, SQLC ) ;
	print_f ( lineOut) ;

	CE ("DBPROC: CHL_ITER_LIST(CompareSingleIterated)", 0 ) ;

	sum = 0 ;
	elements = 0 ;
	strcpy ( FiOidIn , "12345678" ) ; /* for Debug */

	if ( SQLC == 0 )
	{
		for ( listno = 1 ; listno <=20 ; listno++ )
		{
			sum = 0 ;
			elements = 0 ;
			strcpy ( FiOidIn , "12345678" ) ; /* for Debug */

			EXEC SQL DBPROC TRAVERSE_LIST ( :listno , :NoToTraverse , :elements,
				:sum , :ReleaseOids, :OidsLockMode, :FiOidIn , :FiOidOut ) ;

			sprintf (lineOut,"Listno = %d, elems = %d, sqlcode = %d" , listno,elements,SQLC ) ;
			print_f (lineOut) ;

			CE ("DBPROC: TRAVERSE_LIST (CompareSingleIterated)", 0 ) ;

			if ( elements == 0 )
				EmptyLists++ ;

			ElemsTotal += elements ;
		}

		sprintf (lineOut,"ElIter = %d, ElSum = %d, EmptyList = %d" , ElOut,ElemsTotal,EmptyLists ) ;
		print_f (lineOut) ;

		if ( ElOut != ElemsTotal )
		{
		    prot ( "Iterate Class: Iteration <> Listcount\n" , 0 ) ;
			print_f ("calling sqldump") ;
			/*rollback () ;
			return ; */
			Sqldump () ;
			exit (1) ;
		}

	}

	commit () ;

	/* prot ( "TRAVERSE_LIST: OidOut = %s" , FiOidOut ) ; */
	return 0;
}

/*------------------------------------------------------------------------*/

int DeleteElememtsFromKeyList (int n)
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long ElementsToDelete ;
	EXEC SQL END DECLARE SECTION ;

	ElementsToDelete = n ? n : del_elements ;

	listno = 1 + ( rand () % MaxListNo ) ;
	elements = 0 ;

    movep ( line , col , "DBPROC: DELETE_ELEMENT_FROM_LIST, listno = %d", listno ) ;
	do
	{
		EXEC SQL DBPROC DELETE_FROM_KEYOID_LIST ( :listno , :ElementsToDelete ,
			:elements ) ;

		CE ("DBPROC: DELETE_FROM_KEYOID_LIST",0) ;
	}
	while ( rollberr (1) ) ;

	if ( SQLC )
		rollback () ;
	else
	{
		if ( rand () % 4 )
			commit ();
		else
			rollback () ;
	}
	return 0;
}


/*------------------------------------------------------------------------*/

long TraverseKeyList (long Lno,		/* List number; 0: use start OID of last traverse*/
				   int	RelOids ,	/* 1: Release OIDs after reading*/
				   long Ntt,		/* no of elements to traverse. 0: traverse all */
				   int	ReadLocked, /* 1: lock OIDs when reading */
				   char *TravString,
				   long *NoOfElems)
{

	EXEC SQL BEGIN DECLARE SECTION ;
	int		ReleaseOids ;
    long	NoToTraverse ;
	int		ReadOidsLocked ;
	long	sum ;
	EXEC SQL END DECLARE SECTION ;

	sum = 0 ;
	ReleaseOids = RelOids ;
	NoToTraverse = Ntt ;
	elements = 0 ;
	listno = Lno ;
	ReadOidsLocked = ReadLocked ;

	EXEC SQL DBPROC TRAVERSE_KEYOID_LIST ( :listno , :NoToTraverse , :elements,
		:sum , :ReleaseOids, :ReadOidsLocked ) ;

	*NoOfElems = elements ;
	return sum ;
}

/*------------------------------------------------------------------------*/

void ConsistentKeyRead ()
{

	long sum1, sum2, sum3 ;
	long NoOfElems ;

	long ListNo = rand () % 20 + 1 ;

	elements = 0 ;

	/*
	long TraverseList :
	long Lno,		 List number; 0: use start OID of last traverse
	int	 RelOids ,	 Release OIDs after reading
	long Ntt		 no of elements to traverse. 0: traverse all
	int  ReadLocked  lock OIDs when reading.
	char *TravString  Comment in Output
	*/

	/* Read from database and release Keys*/
    movep ( line , col , "DBPROC: Consistent Key Read, lno = %d, first", ListNo ) ;
	sum1 = TraverseKeyList ( ListNo , 1 , 0 , 0 , "TRAV REL",&NoOfElems) ;
	CE ("Consistent Key Read, first",0) ;

	/* ReleaseAll () ;*/

	if ( rand () % 100 == 0 )
		Sleep ( 60 * 1000 ) ; /* 1 Minute schlafen, damit Satz ggf. nicht mehr im Log*/
	else
		Sleep ( rand () % 1000 ) ;

	/* Read from database and keep keys (not implemented?)*/
	if ( sqlca.sqlcode == 0 )
	{
	    movep ( line , col , "DBPROC: Consistent Key Read, lno = %d, second", ListNo ) ;
		sum2 = TraverseKeyList ( 0 , 0 , 0 , 0 ,"TRAV STO",&NoOfElems) ;
		CE ("Consistent Key Read, second",0) ;

		if ( sum1 != sum2 && SQLC != -28815 )
		{
		    prot ( "Consistent Key Read; sum1 <> sum2\n" , 0 ) ;
		    prot ( "Consistent Key read; sum1  = %d\n" , sum1 ) ;
		    prot ( "Consistent Key read; sum2  = %d\n" , sum2 ) ;

			print_f ("calling sqldump") ;
			/*rollback () ;*/
			/*return ;*/
			Sqldump () ;
			exit (1) ;
		}

			Sleep ( rand () % 1000 ) ; /* max. 1 Sekunde schlafen*/

		/* Read on local key images and release keys afterwards*/

		if ( sqlca.sqlcode == 0 )
		{
			movep ( line , col , "DBPROC: Consistent Key Read, lno = %d, last", ListNo ) ;
			sum3 = TraverseKeyList ( 0 , 1 , 0 , 0, "TRAV LOC" ,&NoOfElems) ;
			CE ("Consistent Key Read, last",0) ;

			if ( sum2 != sum3 && SQLC != -28815)
			{
				prot ( "Consistent Key read; sum2 <> sum3\n" , 0 ) ;
			    prot ( "Consistent Key read; sum2  = %d\n" , sum2 ) ;
			    prot ( "Consistent Key read; sum3  = %d\n" , sum3 ) ;
				print_f ("calling sqldump") ;
				/*rollback () ; */
				/*return ;*/
				Sqldump () ;
				exit (1) ;
			}
		}

		/*  the number of elements in chained list with the number of
		existing keys in list range (between startkey and startkey+rows)*/

		movep ( line , col , "DBPROC: CompareKeyElementCount, lno = %d", ListNo ) ;
		CompareKeyElementCount (ListNo, NoOfElems )  ;
		CE ("CompareKeyElementCount",0) ;

	}

	commit () ;

}

/*------------------------------------------------------------------------*/

void ConsistentVersionKeyRead ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long vrc ;
	EXEC SQL END DECLARE SECTION ;

	long sum1, sum2, sum3 ;
	long NoOfElems ;

	long ListNo = rand () % 20 + 1 ;
	int	 sqlsumcode ;

	elements = 0 ;

	/*
	long TraverseList :
	long Lno,		 List number; 0: use start OID of last traverse
	int	 RelOids ,	 Release OIDs after reading
	long Ntt		 no of elements to traverse. 0: traverse all
	int  ReadLocked  lock OIDs when reading.
	char *TravString Comment in Output
	*/

	/* Read from database and release Keys*/

	sqlsumcode = 0 ;

	movep ( line , col, "Open Version, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CREATE_VERSION (:VerString , :vrc ) ;
	CE ("Open Version",0) ;
	sqlsumcode += sqlca.sqlcode  ;

    movep ( line , col , "DBPROC: Versioned Key Read, lno = %d, first", ListNo ) ;
	sum1 = TraverseKeyList ( ListNo , 1 , 0 , 0 , "TRAV REL",&NoOfElems) ;
	CE ("Versioned Key Read, first",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	/* ReleaseAll () ;*/

	movep ( line, col, "Close Version, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;
	CE ("Close Version",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	if ( ( supers == 0 ) && ( ( rand () % 4) == 0 ) )
		release_connect () ;
	else
	{
		commit () ;
		Sleep ( rand () % 1000 ) ;
	}

	sqlsumcode += sqlca.sqlcode  ;


	movep (line,col, "Open Version, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString , :vrc ) ;
	CE ("Open Version",0) ;
	sqlsumcode += sqlca.sqlcode  ;

	/* Read from database and keep keys (not implemented?)*/
	if ( sqlsumcode == 0 )
	{
		movep ( line , col , "DBPROC: Versioned Key Read, lno = %d, second", ListNo ) ;
		sum2 = TraverseKeyList ( ListNo , 0 , 0 , 0 ,"TRAV STO",&NoOfElems) ;
		CE ("Versioned Key Read, second",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		if ( sum1 != sum2 && SQLC != -28815 )
		{
			prot ( "Consistent Key Read; sum1 <> sum2\n" , 0 ) ;
			prot ( "Consistent Key read; sum1  = %d\n" , sum1 ) ;
			prot ( "Consistent Key read; sum2  = %d\n" , sum2 ) ;

			print_f ("calling sqldump") ;
			/*rollback () ;*/
			/*return ;*/
			Sqldump () ;
			exit (1) ;
		}

		movep ( line,col,"Close Version, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;
		CE ("Close Version",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		if ( ( supers == 0 ) && ( ( rand () % 4) == 0 ) )
			release_connect () ;
		else
		{
			commit () ;
			Sleep ( rand () % 1000 ) ;
		}

		sqlsumcode += sqlca.sqlcode  ;


		movep (line,col, "Open Version, lno = %d" , ListNo ) ;
		EXEC SQL DBPROC CHL_OPEN_VERSION (:VerString , :vrc ) ;
		CE ("Open Version",0) ;
		sqlsumcode += sqlca.sqlcode  ;

		/* Read on local key images and release keys afterwards*/
		if ( sqlsumcode == 0 )
		{
			movep ( line , col , "DBPROC: Versioned Key Read, lno = %d, last", ListNo ) ;
			sum3 = TraverseKeyList ( ListNo , 1 , 0 , 0, "TRAV LOC" ,&NoOfElems) ;
			CE ("Versioned Key Read, last",0) ;

			if ( sum2 != sum3 && SQLC != -28815 )
			{
				prot ( "Versioned Key read; sum2 <> sum3\n" , 0 ) ;
				prot ( "Versioned Key read; sum2  = %d\n" , sum2 ) ;
				prot ( "Versioned Key read; sum3  = %d\n" , sum3 ) ;
				print_f ("calling sqldump") ;
				/*rollback () ; */
				/*return ;*/
				Sqldump () ;
				exit (1) ;
			}
		}

		/*  the number of elements in chained list with the number of
		existing keys in list range (between startkey and startkey+rows)*/
		/*
		movep ( line , col , "DBPROC: CompareKeyElementCount, lno = %d", ListNo ) ;
		CompareKeyElementCount (ListNo, NoOfElems )  ;
		CE ("CompareKeyElementCount",0) ;
		*/
	}

	commit () ;

	movep ( line,col,"Close Version, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_CLOSE_VERSION (:VerString , :vrc ) ;
	CE ("Close Version",0) ;

	commit () ;

	movep ( line,col,"Drop Version, lno = %d" , ListNo ) ;
	EXEC SQL DBPROC CHL_DROP_VERSION (:VerString , :vrc ) ;
	CE ("Drop Version",0) ;

	commit () ;

}

/*------------------------------------------------------------------------*/

int CompareKeyElementCount (long lno, long ListElements )
{
	EXEC SQL BEGIN DECLARE SECTION ;
	long cre_elements ;
	long listno ;
	long ElementsFound = 0 ;
	long ElementsTraversed = 0 ;
	EXEC SQL END DECLARE SECTION ;
	char s [100] ;

	listno = lno ;
	cre_elements = 3000 +  rows  ;
	EXEC SQL DBPROC CHECK_KEYOID_LIST_EMPTY ( :listno , :cre_elements, :ElementsFound, :ElementsTraversed) ;
	sprintf (s , "CompareKeyElementCount, listno = %d, max=%d, scan=%d, list=%d" , listno , ElementsTraversed,
		ElementsFound , ListElements) ;
	print_f (s) ;

	if ( ListElements != ElementsFound && SQLC != -28815 )
	{
		sprintf (s , "CompareKeyElementCount, %d (scan) <> %d (list)" , ElementsFound , ListElements) ;
		print_f (s) ;
		print_f ("calling sqldump") ;
		Sqldump () ;
	}

	return ( ElementsFound ) ;
}

/*------------------------------------------------------------------------*/

void protVarObjs ()
{
	EXEC SQL BEGIN DECLARE SECTION ;
	int pc ;
	int opp ;
	EXEC SQL END DECLARE SECTION ;
	char lineOut [200] ;

	movep ( line , col , "SELECT FROM CLASSCONTAINERS", 0 ) ;

	EXEC SQL select sum ( pagecount) , avg ( objects_per_page )
			 into :pc , :opp
			 from classcontainers
			 where class_name like 'Var%' ;

	CE ("SELECT FROM CLASSCONTAINERS",0) ;

	sprintf ( lineOut , "VarObjContainer: %d pages, %d objs per page => %d objs\n", pc, opp, pc*opp ) ;
	prot ( lineOut ) ;
}

/*------------------------------------------------------------------------*/

void DropPrivateVersions ()
{

		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString2, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString3, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
		EXEC SQL DBPROC CHL_DROP_VERSION (:VerString4, :vrc ) ;
		if ( SQLC && SQLC != -28514 )
			CE ("DBPROC CHL_DROP_VERSION" , 1 ) ;
		commit () ;
}

/*------------------------------------------------------------------------*/

#ifdef OLD
void init_tab2 ()
{
    int     i ;

again :

    rolled_back = 0 ;

    for ( i = 1 ; i < 100 ; i++ )
    {
	i3 = i ;
	i4 = 10 - i ;
	sprintf ( c3 , "tab2%d" , i3 ) ;

	do
	{
	    EXEC SQL
	      INSERT TAB2 VALUES ( :i3 , :i4 , :c3 ) ;

	    if ( SQLC && ( SQLC != 200 ) )
		CE ("INSERT TAB2",0) ;

	    if ( SQLC == 600 ) goto again ;

	} while ( rollberr (1) && ( rolled_back == 0 ) ) ;

	if ( rolled_back ) goto again ;

    }
}
#endif

/*------------------------------------------------------------------------*/

void sel_from_roots ()
{
    movep (line,col,"SELECT * FROM ROOTS" , "" ) ;
    do
    {
	EXEC SQL
	  SELECT * FROM ROOTS ;

	CE ("SELECT * FROM ROOTS",0);
    }		while ( rollberr (1) ) ;
}

/*------------------------------------------------------------------------*/

void check_mark ()
{
    EXEC SQL BEGIN DECLARE SECTION ;
    char	stmt [100] ;
    EXEC SQL END DECLARE SECTION ;

    strcpy ( stmt , "SQLDUMP_LONGCHECK" ) ;

    EXEC SQL
      EXECUTE IMMEDIATE :stmt ;

}
/*------------------------------------------------------------------------*/

int pe (char *s, int leave )
{
    char    zeile [200] ;


	if ( protocol || ( SQLC > 200 ) || ( SQLC < 0 ) )
		print_f (s) ;

    if ( SQLC == 650 || SQLC == 710 )      /* Location down / Shutdown */
		cwr () ;

	if ( SQLC == -9041 ) return 1 ;

    sprintf ( zeile , "%s :  ERR = %d" , s , sqlca.sqlcode ) ;
    movep ( line , col , zeile , "" ) ;

    if ( leave || SQLC == -108 || SQLC == -6000 || SQLC == -28007 || SQLC == -28804 ||
		( SQLC <= -9000 && SQLC >= -10000 ) || SQLC == -7500 ||
		SQLC == -8 ||
		( SQLC != -809 && ( SQLC <= -800 && SQLC > -900 ) ) )
    {
		print_f (s) ;
		print_f ("** calling sqldump **") ;
		Sqldump () ;
		exit (1) ;
    }
	return 0;
}

/*------------------------------------------------------------------------*/

#include <time.h>

void print_f (char *s )
{
    char    da [40]  ;
    time_t    tm ;

    tm = time ( (time_t *) 0) ;
    strncpy ( da , ctime ( &tm ) , 39 ) ;
    da [ 39 ] = 0 ;
    fprintf ( fout , "pid %d , %.19s , durch %3d , %s :  ERR = %d\n" ,
      pid , da , durch , s , SQLC ) ;
}

/*------------------------------------------------------------------------*/

void rollback ()
{
    EXEC SQL
      ROLLBACK WORK ;

    CE ("ROLLBACK WORK" , 1 ) ;
}

/*------------------------------------------------------------------------*/

void commit ()
{
    EXEC SQL
      COMMIT WORK ;

    CE ("COMMIT WORK" , 1 ) ;
}

/*------------------------------------------------------------------------*/

void cwr_ok ()
{
    print_f ("Terminated (SIGTERM), O.K.\n") ;
    cwr () ;
    exit (0) ;
}

/*------------------------------------------------------------------------*/

void cwr()
{
	if ( fout )
		fclose ( fout ) ;

    EXEC SQL
      COMMIT WORK RELEASE;

    exit (0) ;
}

/*------------------------------------------------------------------------*/

void Sqldump ()
{
    print_f ("in Sqldump\n") ;
    if ( ( SQLC != -709 ) && ( SQLC != -807 ) && ( SQLC != 800 ) )
	{
	    /* only if kernel is alive, because if not the precompiler crashes */
    	EXEC SQL SQLDUMP ; /* to find dumping task in vtrace */
	}
	sqladump () ;
	fopen ("dmp.file","a") ;
	if ( fout )
		fclose ( fout ) ;

	exit (1) ;
}

/*------------------------------------------------------------------------*/

int movep (line,col,s1,s2)
int line,col;
char *s1, *s2;
{
    char    zeile [200] ;

    sprintf ( zeile , s1 , s2 ) ;
#ifdef _WIN32
    sprintf (buf , "\033[%d;%dH\033[K%s\r\r",line,col,zeile);
    sflushf (buf) ;
    sprintf (buf , "\033[21;1H") ;
    sflushf (buf) ;
#else
    if ( fo )
    {
      fprintf (fo , "\033[%d;%dH\033[K%s\r\r",line,col,zeile);
      fflush (fo) ;
      fprintf (fo , "\033[21;1H") ;
      fflush (fo) ;
    }
#endif
	return 0;
}

int rollberr (int kind )
{
    int sqlc ;

    if ( ROLLBERR )
		switch ( kind )
	{
	case 0 :
		return ( 1 ) ;
		break ;
	case 1 :
		if ( ( rand () % 4 ) == 0 || ( UseOms && SQLC == -7067 ) )
		{
			rollback () ;
			prot ("Transaction rolled back, loop again\n","");
			rolled_back = 1 ;
			sleep ( 1 ) ;
		}

		if ( UseOms && SQLC == -51 )
			Sleep (100 * ( rand () % 10 ) ) ;

		return ( 1 ) ;
		break ;
	case 2 :
		rollback () ;
		if ( UseOms && SQLC == -51 )
			Sleep (100 * ( rand () % 10 ) ) ;
		else
			sleep ( 1 ) ;
		prot ("Transaction rolled back, loop again\n","") ;
		rolled_back = 1 ;
		return ( 1 ) ;
		break ;
	case 3 :
		sqlc = SQLC ;
		rollback () ;
		prot ("Transaction rolled back, no more loop\n","") ;
		SQLC = sqlc ;
		rolled_back = 1 ;
		return ( 0 ) ;
	case 4 :
		rollback () ;
		prot ("Transaction rolled back, loop again\n","") ;
		sleep (1) ;
		return 1 ;
		break ;

	}
    else{}
	return (0) ;
}

/*------------------------------------------------------------------------*/

int prot (s1 ,s2 )
char *s1,*s2;
{
    char    da [40] ;
    time_t    tm ;
    tm = time ( (time_t *) 0) ;
    strncpy ( da , ctime ( &tm ) , 39 ) ;
    da [ 39 ] = 0 ;

    fprintf ( fout , "pid %d , %.19s , durch %3d , " , pid , da , durch ) ;
    fprintf ( fout , s1 , s2 ) ;
    fflush ( fout ) ;
    return 0;
}
