/*!
  @file           PacketSpy.h
  @author         D025086
  @ingroup        Tests
  @brief          Simulation of comunication and order interface errors.
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/
#ifndef IFR_PACKETSPY_H
#define IFR_PACKETSPY_H
#include "SAPDBCommon/SAPDB_ReuseLib.h"
#include "SAPDB/Interfaces/Runtime/IFR_String.h"
#include "SAPDB/Interfaces/SQLDBC/SQLDBC_ClientRuntime.h"

/**
 * @brief Simulation of comunication and order interface errors.
 * This class supports the modification of the return result of the
 * next request/receive call.
 * The normal request/receive call is done but the result of sqlarequest or
 * sqlareceive is modified after the call.
 * If a specific sql code is required a temporary replypacket is returned
 * where the sqlcode is set and the first segment contains a error text part.
 */

class PacketSpyRuntime 
  :public SQLDBC_ClientRuntime
{
public:
  PacketSpyRuntime();

  void setRTEError(tsp01_CommErr_Enum commErr, const char *errtext, bool OnReceive=true);
  void setSQLError(tsp00_Int2 sqlcode, const IFR_String& errtext);
  
  virtual SAPDB_Bool request(SAPDB_Int8  sessionID,
                             void       *requestData,
                             SAPDB_UInt4 requestDataLength,
                             Msg_List& errorMessages);   
  virtual SAPDB_Bool receive(SAPDB_Int8 sessionID,
                             void **replyData,
                             SAPDB_Int4& replyDataLength,
                             Msg_List& errorMessages);

private:

  void clearRTEError();
  void clearSQLError();
  SAPDB_Bool m_requesterror;
  SAPDB_Bool m_replyerror;
  SAPDB_Bool m_sqlerror;
  Msg_List m_Message;
  tsp00_Int2 m_sqlcode;
  IFR_String m_sqlerrtext;
  tsp1_packet *m_retpacket;
  
};

#endif
