/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class UniversalFileAccess {
    public static final int TEXT_PLAIN = 1;
    public static final int ZIP = 2;
    public static final int GZIP = 3;
    public static final String EXT_ZIP = ".zip";
    public static final String EXT_GZIP = ".gz";

    public static String createUri(File f) {
        String uri = "file:" + f.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        return uri;
    }

    public static InputStream getInputStream(String filename) throws IOException {
        File f = new File(filename);
        File fnew = UniversalFileAccess.findExistingVersion(f);
        if (fnew == null) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        return UniversalFileAccess.getInputStream(fnew);
    }

    public static File findExistingVersion(File f) {
        if (!f.exists()) {
            File fnew = new File(f.getAbsolutePath() + EXT_GZIP);
            if (fnew.exists()) {
                return fnew;
            }
            return null;
        }
        return f;
    }

    public static InputStream getInputStream(File f) throws IOException {
        int fileClass = UniversalFileAccess.classify(f);
        FileInputStream fis = new FileInputStream(f);
        switch (fileClass) {
            case 1: {
                return fis;
            }
            case 2: {
                ZipFile zf = new ZipFile(f);
                ZipEntry ze = zf.getEntry(UniversalFileAccess.cutExtension(f.getName(), fileClass));
                if (ze == null) {
                    throw new IOException("No entry with name '" + ze.getName() + "' found in file '" + f.getPath() + "'!");
                }
                return zf.getInputStream(ze);
            }
            case 3: {
                return new GZIPInputStream(fis);
            }
        }
        return fis;
    }

    public static OutputStream getOutputStream(File f) throws IOException {
        int fileClass = UniversalFileAccess.classify(f);
        return UniversalFileAccess.getOutputStream(f, fileClass);
    }

    public static OutputStream getOutputStream(File file, int fileClass) throws IOException {
        switch (fileClass) {
            case 1: {
                return new FileOutputStream(file);
            }
            case 2: {
                if (!file.getName().toLowerCase().endsWith(EXT_ZIP)) {
                    file = new File(file.getAbsolutePath() + EXT_ZIP);
                }
                FileOutputStream fos = new FileOutputStream(file);
                ZipOutputStream zos = new ZipOutputStream(fos);
                zos.putNextEntry(new ZipEntry(UniversalFileAccess.cutExtension(file.getName(), fileClass)));
                return zos;
            }
            case 3: {
                if (!file.getName().toLowerCase().endsWith(EXT_GZIP)) {
                    file = new File(file.getAbsolutePath() + EXT_GZIP);
                }
                FileOutputStream fos = new FileOutputStream(file);
                return new GZIPOutputStream(fos);
            }
        }
        return new FileOutputStream(file);
    }

    public static int classify(File file) {
        String ext = file.getName().toLowerCase();
        if (ext.endsWith(EXT_ZIP)) {
            return 2;
        }
        if (ext.endsWith(EXT_GZIP)) {
            return 3;
        }
        return 1;
    }

    private static String cutExtension(String name, int fileClass) {
        switch (fileClass) {
            case 1: {
                return name;
            }
            case 2: {
                return name.substring(0, name.length() - 4);
            }
            case 3: {
                return name.substring(0, name.length() - 3);
            }
        }
        return name;
    }
}

